<?php
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
    	exit;
    }
    
    date_default_timezone_set('America/Lima');
    
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    
    function format_date_dd_mm_Y($date)
    {
        return date('d/m/Y', strtotime($date));
    }
    
    function format_date_Y_mm_dd($date)
    {
        return date('Y-m-d', strtotime($date));
    }
    
    include 'config/db.php';
    include 'config/conexion.php';
    require (__DIR__) . '/helper/helper_validacion.php';
    
    if (isset($_GET['idventa'])) {
        $idventa = sanitizaCampo($_GET['idventa'], 'sanitizeint|scapestring|htmlspecialchars', $con);
        $idventa=htmlspecialchars($idventa);
    }
    
    $fechames=date("M-Y");

    /* CONSULTA PREPARADA N°18 */
    $queryVenta = "SELECT 1 FROM yifi58ge_dbVENTAS.tblventa v WHERE v.IdVenta=?";

	try{       
        $stmt = $con->prepare($queryVenta);
        $stmt->bind_param('i', $idventa);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($num);
        
        if($stmt->num_rows > 0){
            $numrows = $stmt->num_rows;
        } else {
            $numrows = 0;
        }        
        
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

    if($numrows > 0){
        
        /* CONSULTA PREPARADA N°19 */
        $queryVentas = "SELECT 
        u.IdUsuario,
        v.Matricula,
        v.Comercial,
        v.CC,
        v.JefeVenta,
        CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta,
        p.EstadoProspecto,
        v.EstadoVenta,
        v.CategoriaVenta,
        v.TipoVenta,
        v.Segmento,
        v.MesesAutorizado,
        v.NProspecto,
        v.IdCliente,
        c.NombApellido Cliente,
        c.Representante,
        c.Correo,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.IdGeografico,
        g.Distrito,
        g.Provincia,
        v.PrecioKit,
        v.TotalExtra,
        v.ResumenVenta,
        v.ExtraAutorizado,
        v.FormaPago,
        v.N590,
        v.PAI,
        p.ComentarioProspectoRP,
        v.IdProspectoRP,
        agen.InstaladoX,
        agen.MatriculaTec,
        CONCAT(t.Nombres,' ',t.Apellidos) Instalador,
        t.LN LNInstalador,
        DATE_FORMAT(agen.FechaInst, '%d/%m/%Y') FechaInst, 
        TIME_FORMAT(agen.HoraInst,'%r') HoraInst,
        DATE_FORMAT(agen.FechaVisitaTEC, '%d/%m/%Y') FechaVisitaTEC,
        TIME_FORMAT(agen.HoraVisitaTEC,'%r') HoraVisitaTEC,
        agen.AsignadoTEC,
        CONCAT(t2.Nombres,' ',t2.Apellidos) TecnicoValoracion,
        agen.Comentario,
        v.HojaCertificacion,
        v.TipoKIT,
        v.ClosingPack,
        v.PrecioEspecial,
        v.CantidadExtras,
        v.ScoringRP,
        v.objCotizacion,
        c.IdDocRP,
        d.TipoDocumento,
        d.Documento,
        v.Observacion,
        v.GGCC,
        v.IdGGCC
        FROM yifi58ge_dbVENTAS.tblventa v
        LEFT JOIN yifi58ge_dbVENTAS.tblprospectorp p on p.IdProspectoRP=v.IdProspectoRP 
        INNER JOIN yifi58ge_dbUSUARIO.tblusuario u on v.IdUsuario=u.IdUsuario 
        INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea 
        INNER JOIN yifi58ge_dbUSUARIO.tblusuario m on m.Matricula=u.Manager
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
        LEFT JOIN yifi58ge_dbVENTAS.tbldocumento d on d.IdDoc=c.IdDocRP
        INNER JOIN yifi58ge_dbVENTAS.tblagenda agen on agen.IdVenta=v.IdVenta
        LEFT JOIN yifi58ge_dbUSUARIO.tblusuario t on t.Matricula=agen.MatriculaTec
        LEFT JOIN yifi58ge_dbUSUARIO.tblusuario t2 on t2.Matricula=agen.AsignadoTEC
        WHERE v.IdVenta=?";
        
    	try{       
            $stmt = $con->prepare($queryVentas);
            $stmt->bind_param('i', $idventa);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($idu, $matricula, $comercial, $dc, $matjefe, $jefeventa, $estadoprospecto, $estadoventa, $categoriaventa, $tipoventa, $segmento, $mesesautorizados, $nprospecto, $idcliente, $cliente, $Representante, $correo,
            $movil, $fijo, $direccion, $idgeografico, $distrito, $provincia, $preciokit, $totalextra, $resumenventa, $regaloutorizado, $formadepago, $n590, $PAI, $comentarioprospecto, $idprospectorp, $instaladox, $matriculatec, 
            $nomreinstalador, $lninstalador, $fechainstalacionver, $horainstalacionver, $FechaVisitaTEC, $HoraVisitaTEC, $AsignadoTEC, $TecnicoValoracion, $comentarioagenda, $HojaCertificacion, $TipoKIT, $ClosingPack, $PrecioEspecial, 
            $CantidadExtras, $ScoringRP, $objCotizacion, $IdDocRP, $TipoDocumento, $Documento, $Observacion, $GGCC, $IdGGCC);
            $stmt->fetch();

            if (empty($AsignadoTEC) || $AsignadoTEC == ''){
                $htmlValoracionTEC='<option value="" selected>Seleccione</option>';
            } else {
                $htmlValoracionTEC='<option value="'.$AsignadoTEC.'" selected>'.$AsignadoTEC.' - '.$TecnicoValoracion.'</option>';
            }
            
            if($GGCC == "NO"){
               $GGCC = "SI";
            }      
            
            $stmt->close();
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }        
        
    }
    
    /* CONSULTA PREPARADA N°20 */
    $querySql = "SELECT DISTINCT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) JefeVenta FROM yifi58ge_dbUSUARIO.tblusuario u  where u.CC=? AND u.LN='11' AND (u.Categoria ='JE' OR u.Categoria ='COACH' OR u.Categoria ='DEL' or u.Categoria='JE/DEL' or u.Categoria='GERENTE TERRITORIAL' ) LIMIT 50";
    $html = NULL;

	try{       
        $stmt = $con->prepare($querySql);
        $stmt->bind_param('i', $dc);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($Matricula, $JefeVenta);
        
        if($stmt->num_rows > 0){
            while($row = $stmt->fetch()){
    	        if ($Matricula == $matjefe) {
    	            $html .= '<option value="' . $Matricula . '" selected>' . $Matricula . ' - ' . $JefeVenta . ' </option>';
    	        } else {
    	            $html .= '<option value="' . $Matricula . '">' . $Matricula . ' - ' . $JefeVenta . ' </option>';
    	        }      
            }
        } else {
            $html .= '<option>No se encontraron resultados.</option>';
        }        
        
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
    $html_tecnico = NULL;
    
    if($lninstalador == "" || empty($lninstalador)){
        $html_tecnico .= '<option></option>';
    } else {
        
        /* CONSULTA PREPARADA N°21 */
        $queryTecnico = "SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Instalador FROM yifi58ge_dbUSUARIO.tblusuario u INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea WHERE u.LN=?";
    	
    	try{       
            $stmt = $con->prepare($queryTecnico);
            $stmt->bind_param('i', $lninstalador);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($Matricula, $Instalador);
            
            if($stmt->num_rows > 0){
                while($row = $stmt->fetch()){
        	        if ($Matricula == $matriculatec) {
        	            $html_tecnico .= '<option value="' . $Matricula . '" selected>' . $Matricula . ' - ' . utf8_encode($Instalador) . ' </option>';
        	        } else {
        	            $html_tecnico .= '<option value="' . $Matricula . '">' . $Matricula . ' - ' . utf8_encode($Instalador) . ' </option>';
        	        }      
                }
            } else {
                $html_tecnico .= '<option>No se encontraron resultados.</option>';
            }        
            
            $stmt->close();
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }        
    }
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
       <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
        <!-- Bootstrap toogle-->
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>
        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
         <link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css"/>
         <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
        <script src="admin/bower_components/moment/modernizr-custom.js" type="text/javascript"></script>
 
        <style>

            .modal-header-danger {
                color:#fff;
                background-color: #e4002b;              
            }
            
            #frmEditarVenta .clsreadonly{
                background-color: #fff;
                cursor: pointer;
            }

            .preloader{
                background-color:#FFF;
                width: 100%;
                height: 100%;
                position: absolute;
                z-index: 1;
            }

            .dataTables_wrapper .myfilter .dataTables_filter{float:left}
            .dataTables_wrapper .mylength .dataTables_length{float:right}
            div.dataTables_scrollBody thead th {
                vertical-align: top;
            } 
            td {
                max-width: 250px;
                overflow: hidden;
                white-space: nowrap;
                text-overflow: ellipsis;

            }
            .espacio{
                height:10px;
            }
            
           .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }


            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #frmEditarVenta .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: auto;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 200%;

            }
            #slider section{
                width: 100%;
            }


            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo { 
                color: #FFFFFF; 
                background-color: #444444; 
                border-color: #444444; 
            } 

            .btn-nuevo:hover, 
            .btn-nuevo:focus, 
            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                color: #FFFFFF; 
                background-color: #616161;  
                border-color: #444444; 
            } 

            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                background-image: none; 
            } 

            .btn-nuevo.disabled, 
            .btn-nuevo[disabled], 
            fieldset[disabled] .btn-nuevo, 
            .btn-nuevo.disabled:hover, 
            .btn-nuevo[disabled]:hover, 
            fieldset[disabled] .btn-nuevo:hover, 
            .btn-nuevo.disabled:focus, 
            .btn-nuevo[disabled]:focus, 
            fieldset[disabled] .btn-nuevo:focus, 
            .btn-nuevo.disabled:active, 
            .btn-nuevo[disabled]:active, 
            fieldset[disabled] .btn-nuevo:active, 
            .btn-nuevo.disabled.active, 
            .btn-nuevo[disabled].active, 
            fieldset[disabled] .btn-nuevo.active { 
                background-color: #444444; 
                border-color: #444444; 
            } 
            

input[type=number]::-webkit-outer-spin-button,

input[type=number]::-webkit-inner-spin-button {

    -webkit-appearance: none;

    margin: 0;

}

 

input[type=number] {

    -moz-appearance:textfield;

}
        </style>
        
        <style>
            .main-header,.main-sidebar,.left-side{
                position:fixed
            }
       
            .main-header {
                top: 0;
                right: 0;
                left: 0
            }
            
            .content-wrapper, .right-side {
                padding-top: 50px
            }

            @media (max-width:767px) {
                .content-wrapper, .right-side {
                    padding-top: 100px
                }
            }

            .layout-boxed .wrapper {
                max-width: 100%
            }

            .wrapper {
                overflow: hidden
            
                .control-sidebar {
                position: fixed;
                height: 100%;
                overflow-y: auto;
                padding-bottom: 50px
            }       
        </style>
     
        <style>
            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                   -moz-border-radius: 5px;
                        border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                   -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        
                    z-index: 1051 !important;    
            }
            
            hr {
              height: 4px;
              width: 100%;
              background-color: #ecf0f5;
            }
            
            hr {
                /* margin-top: 20px; */
                margin-bottom: 20px;
                border: 0;
                /* border-top: 1px solid #eee; */
            }
            
            hr {
                display: block;
                unicode-bidi: isolate;
                -webkit-margin-before: 0.5em;
                -webkit-margin-after: 0.5em;
                -webkit-margin-start: auto;
                -webkit-margin-end: auto;
                overflow: hidden;
                border-style: inset;
               
            }

            .box.box-custom {
                border-top-color: #ffffff;
            }

            .box {
                position: relative;
                border-radius: 3px;
                background: #ffffff;
                border-top: 3px solid #d2d6de;
                margin-bottom: 5px;
                width: 100%;
                box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            }

        </style>
        
        <style>
            .readonly_blanco {
                background-color: #fff!important;
            }
            label{
                font-weight: 400;
                text-align:left;
                font-size: 12px;
            }
            .ocultar{
                display:none;
            }
        </style>
        
    </head>

    <body class="sidebar-collapse skin-red sidebar-mini">

        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php

                $consultaventa="active";

                include 'admin/main-sidebar.php';
            ?>


            <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        <div class="col-md-2"></div>
                        <div class="col-md-8">
                            <!-- /.box-header -->
                            <div class="box box-danger">
                                <div class="box-header">
                                <div class="form-horizontal">
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <h3 class="col-sm-12 col-xs-12 box-title" style="text-align:left;">EDITAR</h3>
                                                        <div class="col-sm-12 col-xs-12">
                                                   <h3 class="box-title">
                                                    <select name="lblcategoria" id="lblcategoria" style="border:none;-moz-appearance:none;-webkit-appearance:none;-ms-appearance:none;-o-appearance:none;">  
                                                        <?php if($categoriaventa=="ProspectoRP"){?>
                                                            <option value="ProspectoRP">NUEVO PROSPECTO RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="Evaluacion">PENDIENTE EVAL. TEC - <?php echo $idprospectorp; ?></option>
                                                        <?php }elseif($categoriaventa=="Evaluacion" || $categoriaventa=="Cotizacion"){?>
                                                            <option value="Evaluacion"<?php if ($categoriaventa == "Evaluacion") {echo "selected";}?>hidden="">PENDIENTE EVAL. TEC - <?php echo $idprospectorp; ?></option>
                                                            <option value="Cotizacion"<?php if ($categoriaventa == "Cotizacion") {echo "selected";}?>>PENDIENTE COTIZACION - <?php echo $idprospectorp; ?></option>
                                                        <?php }elseif($categoriaventa=="VRPAsignada"){?>
                                                            <option value="VRPAsignada"<?php if ($categoriaventa == "VRPAsignada") {echo "selected";}?> hidden="">VISITA ASIGNADA RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="Ficha"<?php if ($categoriaventa == "Ficha") {echo "selected";}?>>VENTA FICHA - <?php echo $idprospectorp; ?></option>
                                                            <option value="Delegacion"<?php if ($categoriaventa == "Delegacion") {echo "selected";}?>>VENTA DELEGACIÓN - <?php echo $idprospectorp; ?></option>
                                                            <option value="NoVendida"<?php if ($categoriaventa == "NoVendida") {echo "selected";}?> >NO VENDIDA - <?php echo $idprospectorp; ?></option>
                                                        <?php }elseif($categoriaventa=="Ficha" || $categoriaventa=="Delegacion" || $categoriaventa=="NoVendida" || $categoriaventa=="Cancelada"){?>
                                                            <option value="Online"<?php if ($categoriaventa == "Online") {echo "selected";}?> hidden="">VENTA ONLINE - <?php echo $idprospectorp; ?></option>
                                                            <option value="Ficha"<?php if ($categoriaventa == "Ficha") {echo "selected";}?>>VENTA FICHA - <?php echo $idprospectorp; ?></option>
                                                            <option value="Delegacion"<?php if ($categoriaventa == "Delegacion") {echo "selected";}?>>VENTA DELEGACIÓN - <?php echo $idprospectorp; ?></option>
                                                            <option value="NoVendida"<?php if ($categoriaventa == "NoVendida") {echo "selected";}?> hidden="">NO VENDIDA - <?php echo $idprospectorp; ?></option>
                                                            <option value="Cancelada"<?php if ($categoriaventa == "Cancelada") {echo "selected";}?> hidden="">CANCELADA - <?php echo $idprospectorp; ?></option>   
                                                        <?php }else{?>
                                                            <option value="VisitaAceptada"<?php if ($categoriaventa == "VisitaAceptada") {echo "selected";}?> disabled="" hidden="" >GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="NoAceptaVisita"<?php if ($categoriaventa == "NoAceptaVisita") {echo "selected";}?> disabled="" hidden="" >GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="DevolverLlamada"<?php if ($categoriaventa == "DevolverLlamada") {echo "selected";}?> disabled="" hidden="" >GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="NoContesta"<?php if ($categoriaventa == "NoContesta") {echo "selected";}?> disabled="" hidden="">GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="ClienteError"<?php if ($categoriaventa == "ClienteError") {echo "selected";}?>disabled="" hidden="" >GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="TelefonoError"<?php if ($categoriaventa == "TelefonoError") {echo "selected";}?>disabled="" hidden="" >GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="ZSCC"<?php if ($categoriaventa == "ZSCC") {echo "selected";}?> disabled="" hidden="">GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="Provincia"<?php if ($categoriaventa == "Provincia") {echo "selected";}?>disabled="" hidden="">GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="Inviable"<?php if ($categoriaventa == "Inviable") {echo "selected";}?>disabled="" hidden="" >GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="Rechazada"<?php if ($categoriaventa == "Rechazada") {echo "selected";}?>disabled="" hidden="">GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="AnuladaOP"<?php if ($categoriaventa == "AnuladaOP") {echo "selected";}?>disabled="" hidden="" >GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="AnuladaCLI"<?php if ($categoriaventa == "AnuladaCLI") {echo "selected";}?>disabled="" hidden="">GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="AnuladaTEC"<?php if ($categoriaventa == "AnuladaTEC") {echo "selected";}?>disabled="" hidden="">GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                            <option value="ClienteVerisure"<?php if ($categoriaventa == "ClienteVerisure") {echo "selected";}?>disabled="" hidden="">GESTIONADO POR CALL RP - <?php echo $idprospectorp; ?></option>
                                                        <?php }?>
                                                    </select>
                                                </h3>
                                                <input id="lblcat" name="lblcat" value="<?php echo $categoriaventa;?>" hidden="">
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                </div>    
                                   
                                    <div class="box-tools pull-right">
                                        <?php if($estadoventa=='Facturada' || $nombacceso=='test' || $estadoventa=='PendienteCotizacion'){ }else{ ?>
                                            <a class="btn btn-nuevo btn-sm" id="btnGuardarEditarVenta" href="#"><i class="fa fa-save"></i></a>
                                        <?php   } ?>
                                         <a href="consultagrandescuentas.php" class="btn btn-danger btn-sm" ><i class="fa fa-reply"></i> </a>
                                    </div>
                                </div>
                            </div>
                            <form id="frmEditarVenta" method="POST">
                                <!--INFORMACION DEL COMERCIAL -->
                                <div class="box box-custom">
                                    <!-- box-header -->
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                       <h5>INFORMACION DEL COMERCIAL</h5>
                        
                                      <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                        
                                      </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <!-- box-body -->
                                    <div class="box-body">
                                         <div class="form-horizontal">
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblmatricula">MATRICULA: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                    <input type="text" name="lblmatricula" id="lblmatricula" value="<?php echo $matricula;?>" class="form-control input-sm" style="width: 100%;" readonly="readonly"> 
                                                    <input id="lblidusuario" name="lblidusuario" value="<?php echo $idu;?>" hidden="">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnombcomercial">COMERCIAL: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input name="lblnombcomercial" id="lblnombcomercial" value="<?php echo $comercial;?>" class="form-control input-sm" style="width: 100%;" readonly="readonly" required />
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lbldc">DC: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                    <select class="form-control input-sm" name="lbldc" id="lbldc" style="width: 100%;" disabled>
                                                        <option>Seleccione</option>
                                                        <?php if ($dc == "150") { ?>
                                                            <option value="150" <?php if ($dc == "150") {echo "selected";}?>>150</option>
                                                        <?php }else if($dc == "151") { ?>
                                                           <option value="151" <?php if ($dc == "151") {echo "selected";}?>>151</option>
                                                        <?php }else if ($dc == "152") { ?>
                                                               <option value="152" <?php if ($dc == "152") {echo "selected";}?>>152</option>
                                                        <?php }else if($dc == "153") { ?>
                                                         <option value="153" <?php if ($dc == "153") {echo "selected";}?>>153</option>
                                                        <?php }else if ($dc == "154") { ?>
                                                          <option value="154" <?php if ($dc == "154") {echo "selected";}?>>154</option>
                                                        <?php }else if($dc == "155") { ?>
                                                              <option value="155" <?php if ($dc == "155") {echo "selected";}?>>155</option>
                                                        <?php }else if($dc == "156") { ?>
                                                              <option value="156" <?php if ($dc == "156") {echo "selected";}?>>156</option>
                                                          <?php }else if ($dc == "200") { ?>
                                                         <option value="200" <?php if ($dc == "200") {echo "selected";}?>>200</option>      
                                                        <?php }else if ($dc == "120") { ?>
                                                            <option value="120" <?php if ($dc == "120") {echo "selected";}?>>120</option>
                                                        <?php }else if ($dc == "40") { ?>
                                                            <option value="40" <?php if ($dc == "40") {echo "selected";}?>>40</option>
                                                        <?php }else if ($dc == "41") { ?>
                                                            <option value="41" <?php if ($dc == "41") {echo "selected";}?>>41</option>
                                                        <?php }else if ($dc == "511") { ?>
                                                          <option value="511" <?php if ($dc == "511") {echo "selected";}?>>511</option>
                                                          <?php }else if ($dc == "512") { ?>
                                                          <option value="512" <?php if ($dc == "512") {echo "selected";}?>>512</option>
                                                        <?php }else if ($dc == "500") { ?>
                                                          <option value="500" <?php if ($dc == "500") {echo "selected";}?>>500</option>
                                                          <?php }else if ($dc == "513") { ?>
                                                          <option value="513" <?php if ($dc == "513") {echo "selected";}?>>513</option>
                                                        <?php }else if ($dc == "599") { ?>
                                                          <option value="599" <?php if ($dc == "599") {echo "selected";}?>>599</option>
                                                        <?php }else { ?>
                                                        <option value="" selected></option>
                                                        <?php }?>
                                                    </select>                                                                        
                                                        </div>
                                                    </div>
                                               </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lbljefeventa" style="text-align:left;">JEFE VENTA: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                    <select class="form-control input-sm" name="lbljefeventa" id="lbljefeventa" style="width: 100%;" disabled>
                                                        <?php echo $html;?>
                                                    </select>    
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                        </div>
                                       
                                    </div>
                                    <!-- /.box-body -->
                                </div>
                                <!--INFORMACION DEL CLIENTE -->
                                <div class="box box-custom">
                                        <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                            <h5>INFORMACION DEL CLIENTE</h5>
                                            <div class="box-tools pull-right">
                                                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                                </button>
                                            </div>
                                        </div>
                                        <!-- /.box-header -->
                                        <div class="box-body">
                                            <div class="form-horizontal">
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnombcliente">CLIENTE: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                    <input name="lblnombcliente" class="form-control input-sm" id="lblnombcliente" value="<?php echo $cliente;?>" style="width: 100%;" disabled/></td>
                                                    <input id="lblidcliente" name="lblidcliente" value="<?php echo $idcliente;?>" hidden="">
                                                     </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">CORREO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input type="email"  class="form-control input-sm" id="lblcorreo" value="<?php echo $correo;?>" name="lblcorreo" disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblrepresentante">REPRESENTANTE: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input name="lblrepresentante" class="form-control input-sm" id="lblrepresentante"  value="<?php echo $Representante; ?>" style="width: 100%;" disabled />
                                                     </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lbltiventa">SEGMENTO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="text" name="lblsegmento" id="lblsegmento" class="form-control input-sm" style="width: 100%;" readonly="readonly" value="NEG"/>
                                                        </div>
                                                    </div>
                                               </div>
                                                
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lbldireccion">DIRECCIÓN: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <textarea class="form-control input-sm" name="lbldireccion" rows="1" style="resize:none" id="lbldireccion" placeholder="Ingresar..." disabled><?php echo $direccion;?></textarea>
                                                        </div>
                                                    </div>
                                               </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lbldistrito" style="text-align:left;">DISTRITO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                                    <select class="form-control selectdistrito input-sm" name="lbldistrito" id="lbldistrito" style="width: 100%;" disabled>
                                                                         <option value="<?php echo $idgeografico; ?>"><?php echo $distrito.' - '.$provincia; ?></option>
                                                                             </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblmovil">TELEFONO UNO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input type="tel" class="form-control input-sm" name="lblmovil" id="lblmovil" value='<?php echo $movil;?>' readonly="readonly" data-inputmask="'mask': '999999999'" data-mask disabled>
                                                        
                                                        </div>
                                                    </div>
                                               </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblfijo" style="text-align:left;">TELEFONO DOS:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="tel" class="form-control input-sm" name="lblfijo" id="lblfijo" value="<?php echo $fijo;?>" data-inputmask="'mask': '999999999'" data-mask disabled>  
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                <div class="form-group ocultar" style="margin-bottom: 0px;">
                                                 <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lbltipodoc">TIPO DOCUMENTO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="text" name="lbltipodoc" id="lbltipodoc" class="form-control input-sm" style="width: 100%;" readonly="readonly" value="RUC">
                                                            
                                                        </div>
                                                    </div>
                                               </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblruc" style="text-align:left;">DOCUMENTO: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="tel" class="form-control input-sm" name="lbldocumento" id="lbldocumento" maxlength="11" onkeypress="return filterFloat(event, this);" disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                                </div> 
                                                
                                               
                                        </div>                                            
                                           
                                        </div>
                                        <!-- /.box-body -->
                                </div>
                               
                                <!-- INFORMACION DE LA OFERTA -->
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                       <h5>INFORMACION DE LA OFERTA</h5>
                                        <div class="box-tools pull-right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                    <div class="form-horizontal">
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblestadoventa">RECURSO:<span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                   <select name="lbltipoventa" id="lbltipoventa" class="form-control input-sm" disabled>
                                                        <option>Seleccione</option>
                                                        <option value="RPGGCC"<?php if ($tipoventa == "RPGGCC") {echo "selected";}?>>RPGGCC</option>
                                                        <option value="REGGCC"<?php if ($tipoventa == "REGGCC") {echo "selected";}?>>REGGCC</option>
                                                    </select>
                                                    <input id="lbltiventa" name="lbltiventa" value="<?php echo $tipoventa;?>"  hidden="" />
                                                    <input id="IdDocRP" name="IdDocRP" value="<?php echo $IdDocRP; ?>" hidden="" />
                                                     </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblestventa">ESTADO VENTA:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <input type="text" class="form-control input-sm" name="lblestventa" value="<?php echo $estadoventa;?>" id="lblestventa" readonly="readonly">
                                                            <input type="hidden" name="lblestadoprospecto" id="lblestadoprospecto" value="<?php echo $estadoprospecto;?>">     
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6 ocultar">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblpreciokit">MESES AUTORIZADOS:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input type="number" maxlength="3" class="form-control input-sm" id="lblmesesautorizados" name="lblmesesautorizados"  value="<?php echo $mesesautorizados;?>" onkeypress="return filterFloat(event, this);">
                                                        </div>
                                                    </div>
                                                </div>    
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lbltotalextra" style="text-align:left;">TIPO KIT: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" id="lbltipokit" name="lbltipokit">
                                                            <option value="" hidden selected>Seleccione</option>
                                                            </select>
                                                    <input type="hidden" id="valtipokit" value="<?php echo $TipoKIT; ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                </div> 
                                                
                                                 <div class="form-group ocultar" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblpreciokit">PRECIO KIT:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="input-group">
                                                           <div class="input-group-addon input-sm">
                                                            <i class="">S/.</i>
                                                        </div>
                                                       <input type="number" class="form-control input-sm" name="lblpreciokit" id="lblpreciokit" value="<?php echo $preciokit;?>" onkeypress="return filterFloat(event, this);">
                                                    </div>
                                                        </div>
                                                    </div>
                                                </div>    
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lbltotalextra" style="text-align:left;">TOTAL EXTRA:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                                   <div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="">S/.</i>
                                                        </div>
                                                        <input type="number" class="form-control input-sm" name="lbltotalextra" id="lbltotalextra" value="<?php echo $totalextra;?>" onkeypress="return filterFloat(event, this);">
                                                    </div>
                                                        </div>
                                                    </div>
                                                </div>
                                               </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-12 col-md-12">
                                                    <div class="form-group">
                                                        <label class="col-sm-2 col-xs-4 control-label " style="text-align:left;" for="lblresumenventa">RESUMEN INST.: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-10 col-xs-8">
                                                        <div class="input-group">
                                                            <input type="text" class="form-control input-sm" id="lblresumenventa" name="lblresumenventa" rows="2"  value="<?php echo $resumenventa; ?>" readonly="readonly">
                                                            <input type="hidden" id="lbljsonresumenventa" name="lbljsonresumenventa" value='<?php echo $objCotizacion; ?>'>
                                        
                                                            <div class="input-group-addon btn" id="btnModalProductos">
                                                                <i class="fa fa-cart-plus"></i>
                                                            </div>
                                                        </div>    
                                                                
                                                        </div>
                                                    </div>
                                               </div>
                                                <div class="col-sm-6 col-md-6 ocultar">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblextraautorizado" style="text-align:left;">REGALO AUTORIZADO:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                    <select class="form-control input-sm" name="lblextraautorizado" id="lblextraautorizado">
                                                        <option>Seleccione</option>
                                                        <option value="Ninguno"<?php if ($regaloutorizado == "Ninguno") {echo "selected";}?>>Ninguno</option>
                                                        <option value="Mando a distancia"<?php if ($regaloutorizado == "Mando a distancia") {echo "selected";}?>>Mando a distancia</option>
                                                        <option value="Magnetico"<?php if ($regaloutorizado == "Magnetico") {echo "selected";}?>>Magnetico</option>
                                                        <option value="Pulsador"<?php if ($regaloutorizado == "Pulsador") {echo "selected";}?>>Pulsador</option>
                                                    </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;display:none">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblclosingpack">CLOSING PACK</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm" name="lblclosingpack" id="lblclosingpack">
                                                        <option value="" disabled>Seleccione</option>
                                                        <option value="Ninguno" selected>Ninguno</option>
                                                    </select>
                                                    <input type="hidden" id="valclosingpack" value="<?php echo $ClosingPack; ?>">
                                                        </div>
                                                    </div>
                                               </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblprecioEspecial" style="text-align:left;">PRECIO ESPECIAL:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                                <select class="form-control input-sm" name="lblprecioEspecial" id="lblprecioEspecial">
                                                        <option value="" disabled>Seleccione</option>
                                                        <option value="Ninguno" selected>Ninguno</option>
                                                        <option value="Renove">Renove</option>
                                                        <option value="IceBreaker">IceBreaker</option>
                                                    </select>
                                                    <input type="hidden" id="valprecioEspecial" value="<?php echo $PrecioEspecial; ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                </div>    
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblCantExtras">CANTIDAD EXTRAS:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input type="number" class="form-control input-sm" id="lblCantExtras" name="lblCantExtras" min="0" value="<?php echo $CantidadExtras; ?>" readonly="readonly"> 
                                                        </div>
                                                    </div>
                                               </div>
                                               <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblPAI" style="text-align:left;">COMENTARIO RP:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                          <textarea class="form-control input-sm" name="lblcomentarioprospecto" id="lblcomentarioprospecto" rows="2" style="resize:none" placeholder="Ingresar..."><?php echo $comentarioprospecto;?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                                                  
                                               <div class="col-sm-6 col-md-6 ocultar">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="lblresultadoScoring" style="text-align:left;">RESULTADO SCORING:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm" name="lblresultadoScoring" id="lblresultadoScoring">
                                                        <option value="" disabled selected>Seleccione</option>
                                                        <option value="Especial">Oferta especial</option>
                                                        <option value="Oferta">Oferta</option>
                                                        <option value="Limitada">Oferta limitada</option>
                                                    </select>  
                                                    <input type="hidden" id="valresultadoScoring" value="<?php echo $ScoringRP; ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                </div>       
                                                  <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-12 col-md-12">
                                                    <div class="form-group">
                                                        <label class="col-sm-2 col-xs-4 control-label " style="text-align:left;" for="lblobservacion">OBSERVACION: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-10 col-xs-8">
                                                         <textarea class="form-control input-sm" name="lblobservacion" id="lblobservacion" rows="2" style="resize:none" placeholder="Ingresar..."><?php echo $Observacion;?></textarea>   
                                                        </div>
                                                    </div>
                                               </div>
                                               
                                                </div>        
                                                <div class="form-group ocultar" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblformadepago">FORMA DE PAGO:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm" name="lblformadepago" id="lblformadepago">
                                                        <option value="">Seleccione</option> 
                                                        <option value="Cheque" <?php if ($formadepago == "Cheque") {echo "selected";}?>>Cheque</option>
                                                        <option value="Deposito" <?php if ($formadepago == "Deposito") {echo "selected";}?>>Depósito</option>
                                                        <option value="Transferencia" <?php if ($formadepago == "Transferencia") {echo "selected";}?>>Transferencia</option>
                                                        <option value="TransferenciaInterbancaria" <?php if ($formadepago == "TransferenciaInterbancaria") {echo "selected";}?>>Transferencia Interbancaria</option>
                                                        <option value="PagoPOSVisa" <?php if ($formadepago == "PagoPOSVisa") {echo "selected";}?>>Pago POSVisa</option>
                                                        <option value="PagoPOSMC" <?php if ($formadepago == "PagoPOSMC") {echo "selected";}?>>Pago POSMC</option>
                                                        <option value="TarjetadeCredito" <?php if ($formadepago == "TarjetadeCredito") {echo "selected";}?>>Tarjeta de Crédito</option>
                                                        <option value="PagoPasarella" <?php if ($formadepago == "PagoPasarella") {echo "selected";}?>>Pago Pasarella</option>
                                                    </select>
                                                        </div>
                                                    </div>
                                               </div>
                                               <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="mesano" style="text-align:left;">590:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                          <div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="fa fa-calendar"></i>
                                                        </div>
                                                        <input type="text" class="form-control pull-right input-sm"  id="mesano" data-role="date" value="<?php if(isset($n590)){ echo $n590;}else{echo $fechames;}?>" name="lbl590" readonly="readonly" >
                                                    </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                </div>  
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6 ocultar">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="lblPAI">PAI: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm" name="lblPAI" id="lblPAI">
                                                        <option>Seleccione</option>
                                                        <option value="BBVA-DIN"<?php if ($PAI == "BBVA-DIN") {echo "selected";}?>>BBVA-DIN</option>
                                                        <option value="PAI 30x36"<?php if ($PAI == "PAI 30x36") {echo "selected";}?>>PAI 30x36</option>
                                                        <option value="NO"<?php if ($PAI == "NO") {echo "selected";}?>>NO</option>
                                                    </select>
                                                        </div>
                                                    </div>
                                               </div>

                                                
                                                </div>
                                                <div class="form-group ocultar" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " style="text-align:left;" for="HCertificacion">HOJA CERTIFICACIÓN:</label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <input type="checkbox" name="HCertificacion" id="HCertificacion" <?php if($HojaCertificacion=="SI"){echo 'checked';}else{echo '';}?> data-size="small"/>
                                                  <input type="hidden" name="hidden_HCertificacion" id="hidden_HCertificacion" value="<?php echo $HojaCertificacion; ?>">
                                                        </div>
                                                    </div>
                                               </div>
                                               <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label " for="hidGGCC" style="text-align:left;"></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                          <input type="hidden" name="hidGGCC" id="hidGGCC" value="<?php echo $GGCC; ?>"/>
                                                          <input type="hidden" name="lblidggcc" id="lblidggcc" value="<?php echo $IdGGCC; ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                </div>  
                                                
                                                 
                                        </div>                                           
                                        
                                    </div>
                                    <!-- /.box-body -->
                                </div>
                                <!-- INFORMACION DE LA AGENDA -->
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                       <h5>INFORMACION DE AGENDA</h5>
                        
                                      <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                        
                                      </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                                                        <div class="form-horizontal">
                                        <div class="VTEC">
                                        <!--ASIGNACIÓN DE EVALUACION TÉCNICA -->
                                        <div>
                                                <h5 class="subtitulo">ASIGNACIÓN DE EVALUACION TÉCNICA</h5>
                                            </div> 
                                        <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnombcliente">TÉCNICO:<span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <select name="lblAsignadoTEC" id="lblAsignadoTEC" class="form-control cbxtecnico input-sm" style="width: 100%;" disabled>
                                                               <option value="">Seleccione</option>
                                                                <?php echo $htmlValoracionTEC;?>
                                                            </select>
                                                            <input type="hidden" id="hidlblAsignadoTEC" value="<?php echo $AsignadoTEC; ?>">
                                                     </div>
                                                    </div>
                                                </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfvisitaTEC">FECHA EVALUACION TÉCNICA: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group" id="fi">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfvisitaTEC" name="lblfvisitaTEC" value="<?php echo $FechaVisitaTEC;?>"  data-inputmask="'alias': 'dd/mm/yyyy'" data-mask="" disabled>
                                                        </div>
                                                     </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">HORA EVALUACION TÉCNICA: <span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <div class="bootstrap-timepicker timepicker">
                                                                <div class="input-group">
                                                                    <input type="text" class="form-control input-sm" placeholder="12:00 AM" name="lblhvisitaTEC" id="lblhvisitaTEC" value="<?php echo $HoraVisitaTEC;?>" disabled>
                                                                    <div class="input-group-addon input-sm">
                                                                    <i class="fa fa-clock-o"></i>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                        </div>
                                        <div class="form-group vercomentariovalorarion" style="margin-bottom: 0px;">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group">
                                                        <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcomentarioagendaver">COMENTARIO:<span style="color:red"> * </span></label>
                                                        <div class="col-sm-8 col-xs-8">
                                                            <textarea class="form-control input-sm" name="lblcomentarioagendaver" id="lblcomentarioagendaver" maxlength="254" rows="1" style="resize:none" placeholder="Ingresar..." disabled><?php echo $comentarioagenda;?></textarea>
                                                     </div>
                                                    </div>
                                                </div>
                                                    <div class="col-sm-6 col-md-6 logcambios ocultar">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">LOG AGENDA:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <a class="btn btn-danger btn-sm"  href="#" data-toggle="modal" id="logcambios" data-target="#modal-default"><i class="fa fa-pencil-square-o"></i> Log Cambios</a>
                                                            </div>
                                                        </div>
                                                    </div>                                                
                                        </div>                                        
                                        </div>
                                        </div> 
                                        
                                        <div class="INSTAGENDA" style="display:none">
                                        <table cellspacing="0"  style="width:100%;border-collapse: separate;padding: 0px 0px 0px 20px;">
                                            <tr>
                                                <td><h5 class="subtitulo">DATOS DE LA INSTALACIÓN</h5></td>
                                            </tr>
 <tr>
                                                <td style="width:15%;font-size: 12px">INSTALADOX:</td>
    
                                                <td style="width:25%"><select class="form-control input-sm" name="lblinstaladox" id="lblinstaladox">
                                                        <option>Seleccione</option>
                                                         <option value="TEC"<?php if ($instaladox == "TEC") {echo "selected";}?>>TEC</option>
                                                        <option value="DEL"<?php if ($instaladox == "DEL") {echo "selected";}?>>DEL</option>
                                                    </select>
                                                    
                                                    <input id="lblidagenda" name="lblidagenda" value="<?php echo $idagenda;?>" hidden="">
                                                </td>
                                            </tr> 
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">TÉCNICO:</td>
                                           
                                                <td style="width:25%"> 
                                                    <select name="lbltecnico" id="lbltecnico" class="form-control cbxtecnico input-sm" style="width: 100%;">
                                                        <?php echo $html_tecnico;?>
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">F.INSTALACIÓN:</td>

                                                <td style="width:25%">
                                                    <div class="input-group" id="fi">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="fa fa-calendar"></i>
                                                        </div>
                                                        <input type="text" class="form-control pull-right input-sm readonly_blanco" id="fechainst" value="<?php echo $fechainstalacionver;?>"  name="lblfinstalacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask readonly="readonly">
                                                    </div>
                                                    
                                                </td>
                                             </tr> 
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">H.INSTALACIÓN:</td>
                                                <td style="width:25%">
                                                    <div class="bootstrap-timepicker timepicker">
                                                     <div class="input-group">
                                                         <input type="text" class="form-control input-sm" placeholder="12:00 AM" name="lblhinstalacion" id="horainst" value="<?php echo $horainstalacionver;?>" >
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-clock-o"></i>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">REPERCUCIÓN:</td>
                                                <td  style="width:25%"><textarea class="form-control input-sm" name="lblrepercucion" id="lblrepercucion" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $repercucion;?></textarea></td>
                                               </tr> 
                                            <tr class="espacio"></tr>
                                            
                                            <tr>
                                                <td style="width:15%;font-size: 12px">COMENTARIO:</td>

                                                <td style="width:25%"><textarea class="form-control input-sm" name="lblcomentarioagenda" id="lblcomentarioagenda" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo utf8_encode($comentarioagenda);?></textarea></td>

      
                                            </tr>
                                                                    
                                            <tr class="espacio" id="tinviableespacio"></tr>
                                            <tr id="tinviable">
                                                <td style="width:15%;font-size: 12px">MOTIVO INVIABLE:</td>
    
                                                <td  style="width:25%"><textarea class="form-control input-sm" name="lblinviable" id="lblinviable" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo utf8_encode($motivoinviable);?></textarea></td>
    
                                            </tr>
                                            
                                            <tr class="espacio" id="tcanceladoespacio"></tr>
                                            <tr id="tcancelado">
                                                <td style="width:15%;font-size: 12px">MOTIVO CANCELADO:</td>
    
                                                <td  style="width:25%"><textarea class="form-control input-sm" name="lblcancelado" id="lblcancelado" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $motivocancelado;?></textarea></td>
    
                                            </tr>
                                            
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td colspan="2"><a class="btn btn-danger btn-sm"  href="#" data-toggle="modal" id="logcambios" data-target="#modal-default"><i class="fa fa-pencil-square-o"></i> Log Cambios</a></td>
                                            </tr>
                                    </table>                                            
                                           
                                        </table>
                                        
                                        </div>
                                </div>
                                    <!-- /.box-body -->
                                </div>
                            </form>
                        </div>
                        <!-- END COL-MD-8 -->
                        <div class="col-md-2"></div>
                    </div>

<!-- MODAL PRODUCTOS -->
         <div class="modal fade" id="modal_productos">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h4>DETALLE PRODUCTOS</h4>
                        </div>
                        <div class="modal-body">
                        <div class="box box-solid" style="box-shadow: none;">
                            <form>
                                <div class="box-body">
                                    <div class="form-horizontal">
                                        <div class="form-group" style="margin-bottom: 0px;">
                                        <div class="col-sm-10 col-md-10">
                                            <div class="form-group">
                                                <label for="cboProducto" class="col-sm-3 control-label">EXTRA:</label>
                                                <div class="col-sm-9">
                                                    <select class="form-control select2" id="cboProducto" name="cboProducto" style="width: 100%">
                                                        <option value="" disabled selected>--Seleccione--</option>
                                                        <?php
                                                            $query="SELECT IdItem, CodItem, Item, Precio, CuotaMes
                                                                    FROM tblitem
                                                                    where CategoriaItem = 'televenta' and Estado = 'Activo'";
                                                            $resultado=$con->query($query);
                                                                    
                                                            while ($data = $resultado->fetch_assoc()){                                                          
                                                        ?>
                                                                <option value="<?php echo $data['IdItem']; ?>"><?php echo $data ['Item']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                    <input type="hidden" id="txtcodigoProducto" name="txtcodigoProducto">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-2 col-md-2">
                                                <div class="form-group">
                                                <div class="col-md-12">
                                                    <button class="btn btn-danger pull-right" id="btnAgregar" name="btnAgregar"><i class="fa fa-plus"></i>&nbsp Agregar </button>
                                                    <button class="btn btn-danger pull-right" id="btnEditar" name="btnEditar" style="display:none"><i class="fa fa-edit"></i>&nbsp Editar </button>
                                                </div>
                                                </div>
                                        </div>
                                        <div class="col-sm-10 col-md-10 ocultar">
                                            <div class="form-group">
                                            <label for="cboTipoPrecio" class="col-sm-3 control-label">TIPO PRECIO:</label>
                                            <div class="col-sm-9">
                                                <select class="form-control select2" id="cboTipoPrecio" name="cboTipoPrecio" style="width: 100%">
                                                            <option value="">--Seleccione--</option>
                                                            <option value="CATALOGO" selected>CATALOGO</option>
                                                            <option value="MEDIO">MEDIO</option>
                                                            <option value="AUTORIZADO">AUTORIZADO</option>
                                                </select>
                                            </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-10 col-md-10">
                                            <div class="form-group">
                                            <label for="cboTipoPrecio" class="col-sm-3 control-label">CANTIDAD:</label>
                                            <div class="col-sm-9">
                                                <input type="number" class="form-control input-sm" id="lblcantidad" name="lblcantidad" style="width: 100%">
                                            </div>
                                            </div>
                                        </div>                                          
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6" style="display:none">
                                                <div class="form-group">
                                                    <label for="cboProducto" class="col-sm-3 control-label">PRECIO ESPECIAL:</label>
                                                    <div class="col-sm-9">
                                                        <input type="number" class="form-control input-sm" id="lblPrecioAdicional" name="lblPrecioAdicional" style="width: 100%">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                        
                                            <table class="table table-hover" id="tbdatos">
                                                <thead>
                                                            <tr>
                                                                <th>#</th>
                                                                <th>Producto</th>
                                                                <th>Cantidad</th>
                                                                <th>Opciones</th>
                                                            </tr>
                                                </thead>
                                                <tbody>
                                                </tbody>
                                            </table>
                                        
                                        
                                    </div>
                                    <div class="form-group ocultar" style="margin-bottom: 0px;">
                                        <div class="col-md-4"></div>
                                        <div class="col-md-8">
                                            <label for="txtResumen" class="col-md-4 control-label">Licencia Guardian:</label>
                                            <div class="col-md-8">
                                                <div class="input-group">
                                                    <input type="text" class="form-control input-sm" name="lblAdicionalesOtros" id="lblAdicionalesOtros">
                                                    <div class="input-group-addon btn" id="btnAgregarOtros">
                                                        <i class="fa fa-plus"></i>
                                                    </div>
                                                </div>      
                                            </div>
                                        </div>
                                        
                                    </div>
                                    
                                    <div class="form-group" style="margin-bottom: 0px;">
                                        <div class="col-md-1"></div>
                                        <div class="col-md-11">
                                            <div class="form-group">
                                            <label for="txtResumen" class="col-sm-4 control-label">RESUMEN:</label>
                                            <div class="col-sm-8">
                                                <textarea rows="2" id="txtResumen" name="txtResumen" style="width: 100%" disabled></textarea>
                                            </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group" style="margin-bottom: 0px;">
                                        <div class="col-md-1"></div>
                                        <div class="col-md-11">
                                            <div class="form-group">
                                            <label for="txtCantidad" class="col-sm-4 control-label">CANTIDAD:</label>
                                            <div class="col-sm-8">
                                                <input type="number" id="txtCantidad" name="txtCantidad" style="width: 100%" min="0" value="0" disabled>
                                            </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group ocultar" style="margin-bottom: 0px;">
                                        <div class="col-md-1"></div>
                                        <div class="col-md-11">
                                            <div class="form-group">
                                            <label for="txtTotal" class="col-sm-4 control-label">TOTAL:</label>
                                            <div class="col-sm-8">
                                                <input type="number" id="txtTotal" name="txtTotal" style="width: 100%" min="0" value="0.00" disabled>
                                            </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group ocultar" style="margin-bottom: 0px;">
                                        <div class="col-md-1"></div>
                                        <div class="col-md-11">
                                            <label for="txtTotalCuota" class="col-sm-4 control-label">Total Cuota:</label>
                                            <div class="col-sm-8">
                                                <input type="number" id="txtTotalCuota" name="txtTotalCuota" style="width: 100%" min="0" value="0.00" disabled>
                                            </div>
                                        </div>
                                    </div>
                                        <input type="hidden" id="txtJson" name="txtJson">
                                        
                                    </div>    

                                </div>
                            </form>
                        </div>
                    </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" id="Cerrarmodal" data-dismiss="modal">Cerrar</button>
                            <input type="submit" name="btnGenerar" id="btnGenerar" value="Generar" class="btn btn-danger">
                        </div>   
                </div>
                </div>
            </div>                  
                    
                </section>
                <!-- /.content -->
            </div>
            <!-- /.content-wrapper -->
            <div class="control-sidebar-bg"></div>
        </div>
        <!-- ./wrapper -->

        <!-- jQuery v1.11 -->
        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>
        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>
        $.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
        <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>
         <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>
        <!-- Moment-->
        <script src="admin/bower_components/moment/moment.js" type="text/javascript"></script>
        <script src="admin/bower_components/bootstrap-datepicker-mobile/bootstrap-datepicker-mobile.js" type="text/javascript"></script>
        <!-- Bootstrap toogle -->
        <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>
        <!-- Notificaciones -->
        <script src="js/notificaciones.js" type="text/javascript"></script>
        <!-- SCRIPT EVENTOS -->
        <script>
            //lbllbltipokit
            $('#lbltipokit').on('change', function(){
                //console.log($('#lblsegmento').val());
                $("#lbltipokit option:selected").each(function () {
                var tipokit = $(this).val();
                var resumenventa=$("#lblresumenventa").val();
                if(resumenventa==""){
                    $("#lblresumenventa").val(tipokit);
                }else{
                    resumenventa=resumenventa.replace('Basico', tipokit);
                    resumenventa=resumenventa.replace('Premium', tipokit);
                    resumenventa=resumenventa.replace('ZeroVision', tipokit);
                    $("#lblresumenventa").val(resumenventa);
                }                
                    
                });    
            });
            //lblsegmento
            $('#lblsegmento').on('change', function(){
                //console.log($('#lblsegmento').val());
                
                tipoKit();
                closingPack();
                
            })
            //LBLDC
            $("#lbldc").change(function () {
               $("#lbldc option:selected").each(function () {
               var lbldc = $(this).val();
                $.post("./ajax/selectJefeVenta.php", { lbldc: lbldc }, function(data){
                    $("#lbljefeventa").html(data);
                });            
                });
            });
            //lblinstaladox
            $("#lblinstaladox").change(function () {
                $("#lblinstaladox option:selected").each(function () {
                   var lblinstaladox= $(this).val();
                    $.post("./ajax/selectTecnico.php", { lblinstaladox: lblinstaladox }, function(data){
                        $("#lbltecnico").html(data);
                    });            
                });
            });
            //lblestadoventa
            $("#lblestadoventa").change(function () {
                var condiciones = $("#lblestadoventa").val();
                $("#lblestventa").val(condiciones);
                    bloquear(condiciones);
            });
            //lbltipoventa
            $("#lbltipoventa").change(function () {
               var tps= $("#lbltipoventa").val();
                $("#lbltiventa").val(tps);
            });
            //lblcategoria
            $("#lblcategoria").change(function () {
                var categoria = $("#lblcategoria").val();
                var recurso=$("#lbltiventa").val();
                 $("#lblcat").val(categoria);
                bloquearxCategoria(categoria);
                if(recurso=="RE"){
                    if(categoria =="Ficha"){
                        $("#lblestadoventa").val("PendienteAgenda");
                        $("#lblestvisita").val("Vendida");
                        $("#lblestventa").val("PendienteAgenda");
                    }
                    if(categoria =="Online"){
                        $("#lblestadoventa").val("PendienteData");
                        $("#lblestvisita").val("Vendida");
                        $("#lblestventa").val("PendienteData");
                    }
                    if(categoria =="VAsignada"){
                        $("#lblestadoventa").val("VAsignada");
                        $("#lblestvisita").val("Asignada");
                        $("#lblestventa").val("VAsignada");
                    }
                    if(categoria =="Delegacion"){
                        $("#lblestadoventa").val("AgendadaDEL");
                        $("#lblestvisita").val("Vendida");
                        $("#lblestventa").val("AgendadaDEL");
                        $('#lblestadoventa')[0].disabled=true;
                    }
                    if(categoria =="NoVendida"){
                        $("#lblestadoventa").val("NoVendida");
                        $("#lblestvisita").val("NoVendida");
                        $("#lblestventa").val("NoVendida");
                        $('#lblestadoventa')[0].disabled=true;
                    }
                }else{
                    if(categoria =="ProspectoRP"){
                        $("#lblestadoprospecto").val("ProspectoRP");
                        $("#lblestventa").val("");
                    }
                    if(categoria =="Ficha"){
                        $("#lblestadoprospecto").val("Vendida");
                        $("#lblestventa").val("PendienteAgenda");
                    }
                    if(categoria =="Evaluacion"){
                        $("#lblestadoprospecto").val("AsignadaEvalTEC");
                        $("#lblestventa").val("AsignadaEvalTEC");
                    }
                    if(categoria =="Cotizacion"){
                        $("#lblestadoprospecto").val("PendienteCotizacion");
                        $("#lblestventa").val("PendienteCotizacion");
                    }                    
                    if(categoria =="Online"){
                        $("#lblestadoprospecto").val("Vendida");
                        $("#lblestventa").val("PendienteData");
                    }
                    if(categoria =="Delegacion"){
                        $("#lblestadoprospecto").val("Vendida");
                        $("#lblestventa").val("AgendadaDEL");
                    }
                    if(categoria =="NoVendida"){
                        $("#lblestadoprospecto").val("NoVendida");
                        $("#lblestventa").val("NoVendida");
                    }   
                    if(categoria =="VRPAsignada"){
                        $("#lblestadoprospecto").val("VRPAsignada");
                        $("#lblestventa").val("");
                    }                 
                }
            });
            //lblmatricula
            $('#lblmatricula').on('keyup', function () {
                var dato = $('#lblmatricula').val();
                var url = 'ajax/findMatricula.php';
                $.ajax({
                    type: 'POST',
                    url: url,
                    data: 'dato=' + dato,
                    success: function (datos) {
                        $('.mensajematricula').html(datos);
                    }
                });
                return false;
            });
            $("#lblmatricula").autocomplete({
                source: "./ajax/selectMatricula.php",
                minLength: 2,
                select: function (event, ui) {
                    event.preventDefault();
                    $('#lblidusuario').val(ui.item.idusuario);
                    $('#lblmatricula').val(ui.item.matricula);
                    $('#lblnombcomercial').val(ui.item.comercial);
//                        $('#lbldc').val(ui.item.dc);
//                        $('#lbljefeventa').val(ui.item.jefe);
                 
                }
            });
            $("#lblmatricula").on("keydown", function (event) {
                if (event.keyCode == $.ui.keyCode.LEFT || event.keyCode == $.ui.keyCode.RIGHT || event.keyCode == $.ui.keyCode.UP || event.keyCode == $.ui.keyCode.DOWN || event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE)
                {
                    $('#lblidusuario').val("");
                    $('#lblmatricula').val("");
                    $('#lblnombcomercial').val("");
//                        $('#lbldc').val("");
//                        $('#lbljefeventa').val("");

                }
                if (event.keyCode == $.ui.keyCode.DELETE) {
                    $('#lblmatricula').val("");
                    $('#lblidusuario').val("");
                    $('#lblnombcomercial').val("");
//                        $('#lbldc').val("");
//                        $('#lbljefeventa').val("");
                }
            });
            
            $('#HCertificacion').change(function(){
                if($(this).prop('checked')){
                    $('#hidden_HCertificacion').val('SI');
                }else{
                    $('#hidden_HCertificacion').val('NO');
                }
            });
            
            $('#logcambios').click(function () {
                refresh();
            }); 
        </script>
        <!-- SCRIPT DOCUMENT READY -->
        <script>
            $(document).ready(function () {
                
                //NOTIFICACIONES
                notificacionVisitasField();
                                                                                
                bloquear('<?php echo $estadoventa; ?>');
                bloquearxCategoria('<?php echo $categoriaventa; ?>');
                bloquearxResultado('<?php echo $categoriaventa; ?>');
                
                //FUNCION TIPO KIT Y CLOSINGPACK
                tipoKit();
                closingPack();
                
                $('#lbltipokit').val($('#valtipokit').val());
                $('#lblclosingpack').val($('#valclosingpack').val());
                $('#lblprecioEspecial').val($('#valprecioEspecial').val());
                $('#lblresultadoScoring').val($('#valresultadoScoring').val());
                
                $('#HCertificacion').bootstrapToggle({
                    on:'SI',
                    off:'NO',
                    onstyle:'success',
                    offstyle:'danger'
                });
                
                var alterClass = function () {
                    var ww = document.body.clientWidth;
                    if (ww < 767) {
                        $('body').removeClass('sidebar-collapse');
                    } else if (ww >= 768) {
                        $('body').addClass('sidebar-collapse');
                    }
                    ;
                };
    
                $(window).resize(function () {
                    alterClass();
                });
                //Fire it when the page first loads:
                alterClass();
                            
                $('.selectdistrito').select2({
                    placeholder: 'Seleccione Distrito - Provincia',
                    allowClear: true,
                    language: {
                        errorLoading: function () {
                            return "La carga falló";
                        },
                        noResults: function () {
                            return "No hay resultado";
                        },
                        searching: function () {

                            return "Buscando..";
                        }
                    },
                    ajax: {
                        url: 'ajax/selectDistrito.php',
                        dataType: 'json',
                        delay: 250,
                        processResults: function (data) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    }
                });
        
                $('.cbxtecnico').select2({
                    placeholder: 'Seleccione',
                    allowClear: true,
                    language: {
                        errorLoading: function () {
                            return "La carga falló";
                        },
                        noResults: function () {
                            return "No hay resultado";
                        },
                        searching: function () {

                            return "Buscando..";
                        }
                    }
                });
                          
                $('#datemask').inputmask('dd/mm/yyyy', {'placeholder': 'dd/mm/yyyy'});
           
                $('#lblfecharecpciondoc').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                $('#lblfechafacturacion').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                //Money Euro
                $('[data-mask]').inputmask();
                //Date picker
                var DP_FechaFin = new Date();
                var dias = 30; // Número de días a agregar
                DP_FechaFin.setDate(DP_FechaFin.getDate() + dias);
                            
                $('#fechainst').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1,
                    todayHighlight: true,
                    format: 'dd/mm/yyyy',
                    startDate: new Date(),
                    endDate: DP_FechaFin,
                    clearBtn:true,
                    todayBtn: 'linked',
                });
                //Date picker
                $('#horainst').timepicker({
                     defaultTime:false,
                    showInputs: true,
                     minuteStep: 15
                });
                $('#mesano').datepicker({
                    autoclose: true,
                    language: 'en',
                    firstDay: 1, format: 'M-yyyy',
                    viewMode: "years",
                    minViewMode: "months"
                });
            });
        </script>
    <script>
        const contenedorNuevosDatos = document.querySelector('#tbdatos tbody');
        var lbljsonresumenventa = document.getElementById("lbljsonresumenventa").value;
        if (lbljsonresumenventa == "") {
            console.log("Vacio");
            var arregloDatos = [];
        } else {
            console.log("datos");
            console.log(lbljsonresumenventa);
            var arregloDatos = JSON.parse(lbljsonresumenventa);
            console.log(arregloDatos);
        }
    </script>
        <!-- BOTON GUARDAR -->
        <script>
            $('#btnGuardarEditarVenta').click(function () {
                var gestor='<?php echo $matriculausuario; ?>';
                var catgventa=$('#lblcat').val();
                var ediventa='<?php echo $idventa;?>';
                var idprospectorp='<?php echo $idprospectorp;?>';
                //Algunas variables por default de alertify
                alertify.defaults.theme.ok = "btn btn-nuevo";
                alertify.defaults.theme.cancel = "btn btn-danger";
                if (catgventa == 'VRPAsignada'){
                    Swal.fire(
                      'Alerta!',
                      'Debes modificar la categoria de la VENTA',
                      'warning'
                    )
                } else {
                    var lastX,lastY;
                        alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea guardar los cambios que ha realizado?', function(){ 
                            // Primero validará el formulario.
                            if (validaForm()) {
                                //var datos = $('#frmEditarVenta').serialize();
                                var lblmatricula = $('#lblmatricula').val();
                                var lblidusuario = $('#lblidusuario').val();
                                var lblnombcomercial = $('#lblnombcomercial').val();
                                var lbldc = $('#lbldc').val();
                                var lbljefeventa = $('#lbljefeventa').val();
                                var lblidcliente = $('#lblidcliente').val();
                                var lblnombcliente = $('#lblnombcliente').val();
                                var lblcorreo = $('#lblcorreo').val();
                                var lbldireccion = $('#lbldireccion').val();
                                var lbldistrito = $('#lbldistrito').val();
                                var lblmovil = $('#lblmovil').val();
                                var lblfijo = $('#lblfijo').val();
                                var lbltiventa = $('#lbltiventa').val();
                                var lblsegmento = $('#lblsegmento').val();
                                var lblestadoprospecto = $('#lblestadoprospecto').val();
                                var lblestventa = $('#lblestventa').val();
                                var lblmesesautorizados = $('#lblmesesautorizados').val();
                                var lblpreciokit = $('#lblpreciokit').val();
                                var lbltotalextra = $('#lbltotalextra').val();
                                var lblresumenventa = $('#lblresumenventa').val();
                                var lblextraautorizado = $('#lblextraautorizado').val();
                                var lblformadepago = $('#lblformadepago').val();
                                var lbl590 = $('#mesano').val();
                                var lblPAI = $('#lblPAI').val();
                                var lblcomentarioprospecto = $('#lblcomentarioprospecto').val();
                                var lblidagenda = $('#lblidagenda').val();
                                var lblcancelado = $('#lblcancelado').val();
                                var lblinstaladox = $('#lblinstaladox').val();
                                var lbltecnico = $('#lbltecnico').val();
                                var lblfinstalacion = $('#fechainst').val();
                                var lblhinstalacion = $('#horainst').val();
                                var lblcomentarioagenda = $('#lblcomentarioagenda').val();
                                var hidden_HCertificacion = $('#hidden_HCertificacion').val();
                                //NUEVOS CAMPOS GENERADOS EL 02112020 PARA PILOTO ZEROVISION
                                var lbltipokit=$('#lbltipokit').val();
                                var lblclosingpack=$('#lblclosingpack').val();
                                var lblprecioEspecial=$('#lblprecioEspecial').val();
                                var lblCantExtras=$('#lblCantExtras').val();
                                var lblresultadoScoring=$('#lblresultadoScoring').val();
                                var lbljsonresumenventa = $('#lbljsonresumenventa').val();
                                var lbltipodoc = $('#lbltipodoc').val();
                                var lbldocumento = $('#lbldocumento').val();
                                var IdDocRP=$('#IdDocRP').val();
                                var lblobservacion=$('#lblobservacion').val();
                                var hidGGCC=$('#hidGGCC').val();
                                var lblidggcc=$('#lblidggcc').val();
                                
                                datos = {
                                    lblcategoria:catgventa, 
                                    lblidventa:ediventa, 
                                    gestor:gestor, 
                                    lblnombcliente:lblnombcliente,
                                    lblcorreo:lblcorreo,
                                    lbldireccion:lbldireccion,
                                    lbldistrito:lbldistrito,
                                    lblmovil:lblmovil,
                                    lblfijo:lblfijo,
                                    lblcategoria:catgventa,
                                    lblidprospectorp:idprospectorp,
                                    gestor:gestor,
                                    lblmatricula:lblmatricula,
                                    lblidusuario:lblidusuario,
                                    lblnombcomercial:lblnombcomercial,
                                    lbldc:lbldc,
                                    lbljefeventa:lbljefeventa,
                                    lblidcliente:lblidcliente,
                                    lbltiventa:lbltiventa,
                                    lblsegmento:lblsegmento,
                                    lblestadoprospecto:lblestadoprospecto,
                                    lblestventa:lblestventa,
                                    lblestventa:lblestventa,
                                    lblmesesautorizados:lblmesesautorizados,
                                    lblpreciokit:lblpreciokit,
                                    lbltotalextra:lbltotalextra,
                                    lblresumenventa:lblresumenventa,
                                    lblextraautorizado:lblextraautorizado,
                                    lblformadepago:lblformadepago,
                                    lbl590:lbl590,
                                    lblPAI:lblPAI,
                                    lblcomentarioprospecto:lblcomentarioprospecto,
                                    lblidagenda:lblidagenda,
                                    lblcancelado:lblcancelado, 
                                    lblinstaladox:lblinstaladox, 
                                    lbltecnico:lbltecnico, 
                                    lblfinstalacion:lblfinstalacion, 
                                    lblhinstalacion:lblhinstalacion, 
                                    lblcomentarioagenda:lblcomentarioagenda,
                                    hidden_HCertificacion: hidden_HCertificacion,
                                    lbltipokit: lbltipokit,
                                    lblclosingpack: lblclosingpack,
                                    lblprecioEspecial: lblprecioEspecial,
                                    lblCantExtras: lblCantExtras,
                                    lblresultadoScoring: lblresultadoScoring,
                                    lbljsonresumenventa:lbljsonresumenventa,
                                    IdDocRP:IdDocRP,
                                    lblobservacion:lblobservacion,
                                    hidGGCC:hidGGCC,
                                    lblidggcc:lblidggcc
                                };
                                                    
                                console.log(datos);
                                                   
                                $.ajax({
                                    type: 'POST',
                                    url: 'ajax/updateConsultaGGCC.php',
                                    data: datos,
                                    success: function (r) {
                                        if (r == 1) {
                                            alertify.success("Modificado con exito");
                                        }
                                        else if (r == 0){
                                            alertify.warning("No se realizaron modificaciones");
                                        }
                                        else {
                                            alertify.error("Fallo el server");
                                        }
                                    }
                                });
                                
                            } //END IF VALIRDAR FORM 
                        }   //END FUNCTION CONFIRMAR ALERTIFY
                        , function(){ 
                            alertify.error('No se han guardado los cambios')}
                        ).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
                                lastX = window.scrollX;
                                lastY = window.scrollY;
                            },'onfocus':function(){window.scrollTo(lastX, lastY);}  }).show(); 
                } //END ELSE
            }); //END BTNGUARDAR
            
 $('#btnModalProductos').on('click', function() {
            var lbltipokit = $('#lbltipokit').val();
            var lbljsonresumenventa = $('#lbljsonresumenventa').val();
            if (lbltipokit == '') {
                swal.fire(
                    'Debe seleccionar el tipo kit',
                    '',
                    'error'
                )
                $('#lbltipokit').focus();
            } else {

                if (lbljsonresumenventa != "") {
                    datosHTML();
                }
                $('#modal_productos').modal('show');
                $('#btnEditar').hide();
                $('#btnAgregar').show();
                $('#cboProducto').val('').trigger('change');
                $('#cboTipoPrecio').val('CATALOGO').trigger('change');
                $('#lblcantidad').val('');
                $('#txtcodigoProducto').val('');
                
            }

        })
        
  $('#btnAgregar').on('click', function(e) {
            e.preventDefault();

            const Producto = $('#cboProducto option:selected');
            const TipoPrecio = $('#cboTipoPrecio option:selected');
            const Cantidad =parseInt($('#lblcantidad').val());

            if (Producto.val() != '' && TipoPrecio.val() != '' && Cantidad!='' && Cantidad>0) {

                fetch('ajax/selectListarExtras.php')
                    .then(function(res) {
                        return res.json();
                    })
                    .then(function(datos) {
                        console.log(datos);
                        //var catalogoPrecios = datos;

                        let precioProducto;
                        let precioProductoTotal;
                        let CuotaMensual;
                        let TipoPrecioTotal;

                        for (let [llave, valor] of Object.entries(datos)) {
                            if (valor.IdItem == Producto.val()) {
                                precioProducto = valor.Precio;
                                CuotaMensual = parseInt(valor.CuotaMes);
                                break;
                            }
                        }

                        //let precioProducto = catalogoPrecios[]['Precio'];
                        let precioProductoNeto;

                        if (TipoPrecio.text() == 'CATALOGO') {
                            let descuento = 1.00;
                            precioProductoNeto = precioProducto * descuento;
                            TipoPrecioTotal='CATALOGO';
                        } else if (TipoPrecio.text() == 'MEDIO') {
                            let descuento = 0.75;
                            precioProductoNeto = precioProducto * descuento;
                            TipoPrecioTotal='MEDIO';
                        } else {
                            let descuento = 0.50;
                            precioProductoNeto = precioProducto *descuento;
                            TipoPrecioTotal='AUTORIZADO';
                        }

                        //callback(precioProductoNeto);

                        let PrecioAdicional;

                        if ($('#lblPrecioAdicional').val() != '') {
                            PrecioAdicional = parseFloat($('#lblPrecioAdicional').val());
                            TipoPrecioTotal='PRECIO ESPECIAL';
                            $('#lblPrecioAdicional').val('');
                        } else {
                            PrecioAdicional = precioProductoNeto;
                        }
                        precioProductoTotal=(PrecioAdicional*Cantidad);

                        //GENERAR CODIGO DE ITEM PARA LA TABLA
                        let totalFilas = arregloDatos.length + 1;
                        let codigoProducto = Producto.val() + '-' + totalFilas;

                        let data = {
                            Numero: Producto.val(),
                            Producto: codigoProducto,
                            txtProducto: Producto.text(),
                            TipoPrecio: TipoPrecioTotal,
                            Cantidad: Cantidad,
                            PrecioAdicional: PrecioAdicional,
                            PrecioSubTotal:precioProductoTotal,
                            CuotaMensual: CuotaMensual
                        }

                        arregloDatos = [...arregloDatos, data];

                        datosHTML();
                        $('#btnEditar').hide();
                        $('#btnAgregar').show();

                    })
                    .catch(function(error) {
                        console.log(error);
                    })

            } else {
                Swal.fire(
                    'Error',
                    'Debe seleccionar Extra,Tipo Precio y Cantidad',
                    'error'
                )
            }

            $('#cboProducto').val('').trigger('change');
            $('#cboTipoPrecio').val('').trigger('change');
            $('#lblcantidad').val('');
            $('#txtcodigoProducto').val('');

        })
      $('#btnEditar').on('click', function(e) {
            e.preventDefault();

            const Producto = $('#cboProducto option:selected');
            const TipoPrecio = $('#cboTipoPrecio option:selected');
            const CodigoProducto = $('#txtcodigoProducto').val();
            const Cantidad =parseInt($('#lblcantidad').val());

            if (Producto.val() != '' && TipoPrecio.val() != '' && Cantidad!='' && Cantidad>0) {

                fetch('ajax/selectListarExtras.php')
                    .then(function(res) {
                        return res.json();
                    })
                    .then(function(datos) {
                        console.log(datos);
                        //var catalogoPrecios = datos;

                        let precioProducto;
                        let precioProductoTotal;
                        let TipoPrecioTotal;
                        let CuotaMensual;

                        for (let [llave, valor] of Object.entries(datos)) {
                            if (valor.IdItem == Producto.val()) {
                                precioProducto = valor.Precio;
                                CuotaMensual = parseInt(valor.CuotaMes);
                                break;
                            }
                        }

                        //let precioProducto = catalogoPrecios[]['Precio'];
                        let precioProductoNeto;

                        if (TipoPrecio.text() == 'CATALOGO') {
                            let descuento = 1.00;
                            precioProductoNeto = precioProducto * descuento;
                            TipoPrecioTotal='CATALOGO';
                        } else if (TipoPrecio.text() == 'MEDIO') {
                            let descuento = 0.75;
                            precioProductoNeto = precioProducto * descuento;
                            TipoPrecioTotal='MEDIO';
                        } else {
                            let descuento = 0.50;
                            precioProductoNeto = precioProducto * descuento;
                            TipoPrecioTotal='AUTORIZADO';
                        }

                        //callback(precioProductoNeto);

                        let PrecioAdicional;

                        if ($('#lblPrecioAdicional').val() != '') {
                            PrecioAdicional = parseFloat($('#lblPrecioAdicional').val());
                            TipoPrecioTotal='PRECIO ESPECIAL';
                            $('#lblPrecioAdicional').val('');
                        } else {
                            PrecioAdicional = precioProductoNeto;
                        }
                        
                        precioProductoTotal=(PrecioAdicional*Cantidad);

                        //GENERAR CODIGO DE ITEM PARA LA TABLA
                        //let totalFilas = arregloDatos.length +1;
                        //let codigoProducto = Producto.val()+'-'+totalFilas;

                        let data = {
                            Numero: Producto.val(),
                            Producto: CodigoProducto,
                            txtProducto: Producto.text(),
                            TipoPrecio: TipoPrecioTotal,
                            Cantidad: Cantidad,
                            PrecioAdicional: PrecioAdicional,
                            PrecioSubTotal:precioProductoTotal,
                            CuotaMensual: CuotaMensual
                        }

                        arregloDatos = arregloDatos.map(datos => datos.Producto === data.Producto ? data : datos)
                        console.log(arregloDatos);

                        datosHTML();
                        $('#btnEditar').hide();
                        $('#btnAgregar').show();

                    })
                    .catch(function(error) {
                        console.log(error);
                    })

            } else {
                Swal.fire(
                    'Error',
                    'Debe seleccionar Extra,Tipo Precio y Cantidad',
                    'error'
                )
            }

            $('#cboProducto').val('').trigger('change');
            $('#cboTipoPrecio').val('').trigger('change');
            $('#lblcantidad').val('');
            $('#txtcodigoProducto').val('');

        })      
        $('#btnAgregarOtros').on('click', function(e){
            e.preventDefault();
            
            datosHTML();
        })
        
  $('#btnGenerar').on('click', function(e) {
            e.preventDefault();

            let lbltipokit = $('#lbltipokit').val();

            if (lbltipokit == '') {
                swal.fire(
                    'Debe seleccionar el tipo kit',
                    '',
                    'error'
                )
            } else {
                let resumen = lbltipokit + ' + ' + $('#txtResumen').val();
                let txtCantidad = $('#txtCantidad').val();
                let txtTotal = $('#txtTotal').val();
                let txtTotalCuota = $('#txtTotalCuota').val();
                let txtjson = $('#txtJson').val();

                $('#lbltotalextra').val(txtTotal);
                $('#lblCantExtras').val(txtCantidad);
                $('#lblresumenventa').val(resumen);
                //$('#lblTotalCuotaMonitoreo').val(txtTotalCuota);
                $('#lbljsonresumenventa').val(txtjson);

                $('#modal_productos').modal('hide');
            }


        })
        
      $('#tbdatos').on("click", function(e) {
            e.preventDefault();

            if (e.target.classList.contains('borrar-producto')) {
                const Producto = e.target.getAttribute('data-id');
                const txtProducto = e.target.getAttribute('text-id');
                //Elimina del arreglo de articulosCarrito por el data-id
                arregloDatos = arregloDatos.filter(datos => datos.Producto != Producto);
                datosHTML();
            }

            if (e.target.classList.contains('editar-producto')) {
                $('#btnEditar').show();
                $('#btnAgregar').hide();
                const Producto = e.target.getAttribute('data-id');
                const txtProducto = e.target.getAttribute('text-id');

                let datosencontrados;
                datosencontrados = arregloDatos.find(datos => datos.Producto === Producto);
                console.log(datosencontrados);

                //Edita del arreglo de articulosCarrito por el data-id
                $('#cboProducto').val(datosencontrados.Numero);
                $('#cboTipoPrecio').val(datosencontrados.TipoPrecio);
                $('#lblcantidad').val(datosencontrados.Cantidad);
                $('#txtcodigoProducto').val(Producto);

            }
        })        

        
        $('#lbltipokit').on("change", function(){
            //cargarPrecios();
        })
        </script>
        <!-- SCRIPT FUNCIONES -->
        <script>
            function bloquear(condiciones){
                $('#tinviable').hide();
                $('#lblinviable').hide();
                $('#lblinviable').disabled=true;
                $('#tinviableespacio').hide();
                
                $('#tcancelado').hide();
                $('#lblcancelado').hide();
                $('#lblcancelado').disabled=true;
                $('#tcanceladoespacio').hide();
                        
                if (condiciones == "Inviable") {
                    $('#tinviable').show();
                    $('#lblinviable').show();
                    $('#lblinviable').show();
                    $('#lblinviable').disabled=false;
                    $('#tinviableespacio').show();
                }else if(condiciones=="AgendadaTEC" || condiciones=="Instalada" || condiciones=="Facturada" || condiciones=="Incidencia" || condiciones=="IncidenciaGestCorreo" || condiciones=="IncidenciaGestValija" || condiciones=="NoDoc" || condiciones=="DocEnvi" ){
                    $('#lblcategoria')[0].disabled=true;  
                }
                else if(condiciones=="Cancelado"){
                    $('#tcancelado').show();
                    $('#lblcancelado').show();
                    $('#lblcancelado').disabled=false;
                    $('#tcanceladoespacio').show();
                } 
                else {
                    $('#tinviable').hide();
                    $('#lblinviable').hide();
                    $('#lblinviable').disabled=true;
                    $('#tinviableespacio').hide();
                    $('#tcancelado').hide();
                    $('#lblcancelado').hide();
                    $('#lblcancelado').disabled=true;
                    $('#tcanceladoespacio').hide();
                }
    
            }
            
            function bloquearxResultado(categoria){
                if(categoria=="Delegacion"){
                    $('#btnGuardarEditarVenta').hide();
                    $('#lblcategoria')[0].disabled=true;
                    $('.lblver590').show();
                    $('#veragenda').show();
                    $('#lblmatricula')[0].disabled=true;
                    $('#lblnombcomercial')[0].disabled=true;
                    $('#lbldc')[0].disabled=true;
                    $('#lbljefeventa')[0].disabled=true;
                    $('#lblnombcliente')[0].disabled=true;
                    $('#lblcorreo')[0].disabled=true;
                    $('#lbldireccion')[0].disabled=true;
                    $('#lbldistrito')[0].disabled=true;
                    $('#lblmovil')[0].disabled=true;
                    $('#lblfijo')[0].disabled=true;
                    $('#lbltipoventa')[0].disabled=true;
                    $('#lblsegmento')[0].disabled=true;
                    $('#lblmesesautorizados')[0].disabled=true;
                    $('#lblpreciokit')[0].disabled=true;
                    $('#lbltotalextra')[0].disabled=true;
                    $('#lblresumenventa')[0].disabled=true;
                    $('#lblextraautorizado')[0].disabled=true;
                    $('#lblformadepago')[0].disabled=true;
                    $('#mesano')[0].disabled=true;
                    $('#lblPAI')[0].disabled=true;
                    $('#lblcomentarioprospecto')[0].disabled=true;
                    $('#lblinstaladox')[0].disabled=true;
                    $('#lbltecnico')[0].disabled=true;
                    $('#fechainst')[0].disabled=true;
                    $('#horainst')[0].disabled=true;
                    $('#lblcomentarioagenda')[0].disabled=true;
                    $('#lblinviable')[0].disabled=true;
                }else if(categoria=="Ficha"){
                    $('.lblver590').show();
                    $('#veragenda').hide();
                    $('#btnGuardarEditarVenta').hide();
                    $('#lblcategoria')[0].disabled=true;
                    $('#lblmatricula')[0].disabled=true;
                    $('#lblnombcomercial')[0].disabled=true;
                    $('#lbldc')[0].disabled=true;
                    $('#lbljefeventa')[0].disabled=true;
                    $('#lblnombcliente')[0].disabled=true;
                    $('#lblcorreo')[0].disabled=true;
                    $('#lbldireccion')[0].disabled=true;
                    $('#lbldistrito')[0].disabled=true;
                    $('#lblmovil')[0].disabled=true;
                    $('#lblfijo')[0].disabled=true;
                    $('#lbltipoventa')[0].disabled=true;
                    $('#lblsegmento')[0].disabled=true;
                    $('#lblmesesautorizados')[0].disabled=true;
                    $('#lblpreciokit')[0].disabled=true;
                    $('#lbltotalextra')[0].disabled=true;
                    $('#lblresumenventa')[0].disabled=true;
                    $('#lblextraautorizado')[0].disabled=true;
                    $('#lblformadepago')[0].disabled=true;
                    $('#mesano')[0].disabled=true;
                    $('#lblPAI')[0].disabled=true;
                    $('#lblcomentarioprospecto')[0].disabled=true;
                }else if(categoria=="Cotizacion"){
                    $('.lblver590').show();
                    $('#veragenda').hide();
                    $('#btnGuardarEditarVenta').hide();
                    $('#lblcategoria')[0].disabled=true;
                    $('#lblmatricula')[0].disabled=true;
                    $('#lblnombcomercial')[0].disabled=true;
                    $('#lbldc')[0].disabled=true;
                    $('#lbljefeventa')[0].disabled=true;
                    $('#lblnombcliente')[0].disabled=true;
                    $('#lblcorreo')[0].disabled=true;
                    $('#lbldireccion')[0].disabled=true;
                    $('#lbldistrito')[0].disabled=true;
                    $('#lblmovil')[0].disabled=true;
                    $('#lblfijo')[0].disabled=true;
                    $('#lbltipoventa')[0].disabled=true;
                    $('#lblsegmento')[0].disabled=true;
                    $('#lblmesesautorizados')[0].disabled=true;
                    $('#lblpreciokit')[0].disabled=true;
                    $('#lbltotalextra')[0].disabled=true;
                    $('#lblresumenventa')[0].disabled=true;
                    $('#lblextraautorizado')[0].disabled=true;
                    $('#lblformadepago')[0].disabled=true;
                    $('#mesano')[0].disabled=true;
                    $('#lblPAI')[0].disabled=true;
                    $('#lblcomentarioprospecto')[0].disabled=true;
                }  
                else{
                    $('.lblver590').hide();
                    $('#veragenda').hide();
                    $('#lblinstaladox')[0].disabled=true;
                    $('#lbltecnico')[0].disabled=true;
                    $('#fechainst')[0].disabled=true;
                    $('#horainst')[0].disabled=true;
                    $('#lblcomentarioagenda')[0].disabled=true;
                    $('#lblinviable')[0].disabled=true;
                }
            }
            
            function bloquearxCategoria(categoria){
                                                                                
                if(categoria=="Delegacion"){
                $('#lblestadoventa')[0].disabled=false;
                $('#lblncontrato')[0].disabled=false;
                $('#lblinstaladox')[0].disabled=false;
                $('#lbltecnico')[0].disabled=false;
                $('#fechainst')[0].disabled=false;
                $('#horainst')[0].disabled=false;
                $('#lblrepercucion')[0].disabled=false;
                $('#lblcomentarioagenda')[0].disabled=false;
                $('#lblinviable')[0].disabled=false;
                }else{
                $('#lblinstaladox')[0].disabled=true;
                $('#lbltecnico')[0].disabled=true;
                $('#fechainst')[0].disabled=true;
                $('#horainst')[0].disabled=true;
                $('#lblrepercucion')[0].disabled=true;
                $('#lblcomentarioagenda')[0].disabled=true;
                $('#lblinviable')[0].disabled=true;
                }
                
            }
            
            function validaForm() {
                
                
                // Campos de texto
                if ($("#frmEditarVenta #lblmatricula").val() == "") {
                    alertify.warning("Por favor ingresar la Matricula correspondiente");
                    $("#frmEditarVenta #lblmatricula").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmEditarVenta #lblnombcomercial").val() == "") {
                    alertify.warning("Por favor ingresar la Matricula valida");
                    $("#frmEditarVenta #lblmatricula").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmEditarVenta #lbldc").val() == "" || $("#frmEditarVenta #lbldc").val() == "Seleccione" ) {
                    alertify.warning("Por favor ingresar CC correcto");
                    $("#frmEditarVenta #lbldc").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmEditarVenta #lbljefeventa").val() == "" || $("#frmEditarVenta #lbljefeventa").val() == "No se encontraron resultado") {
                    alertify.warning("Por favor revisar Jefe de Estructura Comercial");
                    $("#frmEditarVenta #lbljefeventa").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmEditarVenta #lblnombcliente").val() == "") {
                    alertify.warning("Por favor ingresar Nombre del Cliente");
                    $("#frmEditarVenta #lblnombcliente").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblcorreo").val() == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test($("#frmEditarVenta #lblcorreo").val())) {
                    alertify.warning("Por favor ingresar correo válido");
                    $("#frmEditarVenta #lblcorreo").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lbldireccion").val() == "") {
                    alertify.warning("Por favor ingresar la Direccion del Cliente");
                    $("#frmEditarVenta #lbldireccion").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lbldistrito").val() =="") {
                    alertify.warning("Por favor ingresar Distrito correcto");
                 
                    $("#frmEditarVenta #lbldistrito").select2('open');
                    return false;
                }
                if ($("#frmEditarVenta #lblmovil").val() == "") {
                    alertify.warning("Por favor ingresar Telefono, de caso contrario digite: 0");
                    $("#frmEditarVenta #lblmovil").focus();
                    return false;
                }
                if ($("#lblcat").val() == "Evaluacion" || $("#lblcat").val() == "Cotizacion") {
                    if ($("#frmEditarVenta #lbltipokit").val() == "" || $("#frmEditarVenta #lbltipokit").val() == null) {
                        alertify.warning("Por favor ingresar Tipo Kit");
                        $("#frmEditarVenta #lbltipokit").focus();
                        return false;
                    }                    
                    if ($("#frmEditarVenta #lblresumenventa").val() == "") {
                        alertify.warning("Por favor ingresar Resumen de Venta");
                        $("#frmEditarVenta #lblresumenventa").focus();
                        return false;
                    }
                   
                    if ($("#frmEditarVenta #lblCantExtras").val() == "" ) {
                        alertify.warning("Por favor ingresar CANTIDAD EXTRAS");
                        $("#frmEditarVenta #lblCantExtras").focus();
                        return false;
                    }                    
                    
                }
                //VALIDACION CUANDO EL PROSPECTO SE VENDE -- CATEGORIA FICHA
                if ($("#lblcat").val() == "Ficha") {
                    if ($("#frmEditarVenta #lblpreciokit").val() == "") {
                        alertify.warning("Por favor ingresar Precio del KIT");
                        $("#frmEditarVenta #lblpreciokit").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lbltotalextra").val() == "") {
                        alertify.warning("Por favor ingresar Total de Extra, de caso contrario digite: 0");
                        $("#frmEditarVenta #lbltotalextra").focus();
                        return false;
                    }

                    if ($("#frmEditarVenta #lblresumenventa").val() == "") {
                        alertify.warning("Por favor ingresar Resumen de Venta");
                        $("#frmEditarVenta #lblresumenventa").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblformadepago").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar Forma de Pago");
                        $("#frmEditarVenta #lblformadepago").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #mesano").val() == "") {
                        alertify.warning("Por favor ingresar 590");
                        $("#frmEditarVenta #mesano").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblPAI").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar PAI");
                        $("#frmEditarVenta #lblPAI").focus();
                        return false;
                    }

                    if ($("#frmEditarVenta #lblestadoventa").val() == "Seleccione" || $("#frmEditarVenta #lblestadoventa").val() == "") {
                        alertify.warning("Por favor ingresar Estado de Venta correcto");
                        $("#frmEditarVenta #lblestadoventa").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lbltipoventa").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar Recurso correcto");
                        $("#frmEditarVenta #lbltipoventa").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblsegmento").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar Segmento correcto");
                        $("#frmEditarVenta #lblsegmento").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblmesesautorizados").val() == "") {
                        alertify.warning("Por favor ingresar MesAutorizado.Si no tuviese coloque: 0");
                        $("#frmEditarVenta #lblmesesautorizados").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lbltipokit").val() == "" || $("#frmEditarVenta #lbltipokit").val() == null) {
                        alertify.warning("Por favor ingresar Tipo Kit");
                        $("#frmEditarVenta #lbltipokit").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblclosingpack").val() == "" || $("#frmEditarVenta #lblclosingpack").val() == null){
                        alertify.warning("Por favor ingresar Closing Pack");
                        $("#frmEditarVenta #lblclosingpack").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblprecioEspecial").val() == "" || $("#frmEditarVenta #lblprecioEspecial").val() == null) {
                        alertify.warning("Por favor ingresar PRECIO ESPECIAL");
                        $("#frmEditarVenta #lblprecioEspecial").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblresultadoScoring").val() == "" || $("#frmEditarVenta #lblresultadoScoring").val() == null) {
                        alertify.warning("Por favor ingresar RESULTADO SCORING");
                        $("#frmEditarVenta #lblresultadoScoring").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblCantExtras").val() == "" ) {
                        alertify.warning("Por favor ingresar CANTIDAD EXTRAS");
                        $("#frmEditarVenta #lblCantExtras").focus();
                        return false;
                    }
                    
                }
                if ($("#lblcat").val() == "Delegacion") {
                    if ($("#frmEditarVenta #lblpreciokit").val() == "") {
                        alertify.warning("Por favor ingresar Precio del KIT");
                        $("#frmEditarVenta #lblpreciokit").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lbltotalextra").val() == "") {
                        alertify.warning("Por favor ingresar Total de Extra, de caso contrario digite: 0");
                        $("#frmEditarVenta #lbltotalextra").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblresumenventa").val() == "") {
                        alertify.warning("Por favor ingresar Resumen de Venta");
                        $("#frmEditarVenta #lblresumenventa").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblformadepago").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar Forma de Pago");
                        $("#frmEditarVenta #lblformadepago").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #mesano").val() == "") {
                        alertify.warning("Por favor ingresar 590");
                        $("#frmEditarVenta #mesano").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblPAI").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar PAI");
                        $("#frmEditarVenta #lblPAI").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblestadoventa").val() == "Seleccione" || $("#frmEditarVenta #lblestadoventa").val() == "") {
                        alertify.warning("Por favor ingresar Estado de Venta correcto");
                        $("#frmEditarVenta #lblestadoventa").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lbltipoventa").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar Recurso correcto");
                        $("#frmEditarVenta #lbltipoventa").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblsegmento").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar Segmento correcto");
                        $("#frmEditarVenta #lblsegmento").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblmesesautorizados").val() == "") {
                        alertify.warning("Por favor ingresar MesAutorizado.Si no tuviese coloque: 0");
                        $("#frmEditarVenta #lblmesesautorizados").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblinstaladox").val() == "" || $("#frmEditarVenta #lblinstaladox").val() == "Seleccione" || $("#frmEditarVenta #lblinstaladox").val() == "TEC" ) {
                        alertify.warning("Por favor seleccionar Instaladox: DEL");
                        $("#frmEditarVenta #lblinstaladox").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lbltecnico").val() =="" || $("#frmEditarVenta #lbltecnico").val()==null) {
                        alertify.warning("Por favor seleccionar el instalador");
                        $("#frmEditarVenta #lbltecnico").select2('open');
                        return false;
                    }
                    if ($("#frmEditarVenta #fechainst").val() == "") {
                        alertify.warning("Por favor ingresar Fecha de Instalacion");
                        $("#frmEditarVenta #fechainst").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #horainst").val() == "") {
                        alertify.warning("Por favor ingresar Hora de Instalacion");
                        $("#frmEditarVenta #horainst").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lbltipokit").val() == "") {
                        alertify.warning("Por favor ingresar Tipo Kit");
                        $("#frmEditarVenta #lbltipokit").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblclosingpack").val() == "" || $("#frmEditarVenta #lblclosingpack").val() == null){
                        alertify.warning("Por favor ingresar Closing Pack");
                        $("#frmEditarVenta #lblclosingpack").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblprecioEspecial").val() == "" || $("#frmEditarVenta #lblprecioEspecial").val() == null) {
                        alertify.warning("Por favor ingresar PRECIO ESPECIAL");
                        $("#frmEditarVenta #lblprecioEspecial").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblresultadoScoring").val() == "" || $("#frmEditarVenta #lblresultadoScoring").val() == null) {
                        alertify.warning("Por favor ingresar RESULTADO SCORING");
                        $("#frmEditarVenta #lblresultadoScoring").focus();
                        return false;
                    }
                    if ($("#frmEditarVenta #lblCantExtras").val() == "" ) {
                        alertify.warning("Por favor ingresar CANTIDAD EXTRAS");
                        $("#frmEditarVenta #lblCantExtras").focus();
                        return false;
                    }
                }
                return true; 
            }
            
            function calcDataTableHeight() {
                return $(window).height() * 65 / 100;
            };

            function filterFloat(evt, input) {
                // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
                var key = window.Event ? evt.which : evt.keyCode;
                var chark = String.fromCharCode(key);
                var tempValue = input.value + chark;
                if (key >= 48 && key <= 57) {
                    if (filter(tempValue) === false) {
                        return false;
                    } else {
                        return true;
                    }
                } else {
                    if (key == 8 || key == 13 || key == 0) {
                        return true;
                    } else if (key == 46) {
                        if (filter(tempValue) === false) {
                            return false;
                        } else {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
            }

            function filter(__val__) {
                var preg = /^([0-9]+\.?[0-9]{0,2})$/;
                if (preg.test(__val__) === true) {
                    return true;
                } else {
                    return false;
                }

            }
        </script>
        <!-- NUEVAS FUNCIONES -->
        <script>
            const dc = $('#lbldc').val();
            
            const option = document.createElement("option");
            
            function tipoKit(){
                const segmento = $('#lblsegmento').val();
                const tipokit = document.getElementById("lbltipokit");
                
                limpiarDatos(tipokit)
                
                if(segmento == 'RES'){
                    //ARBOL DE DESICIONES PARA ZEROVISION
                    
                    if(dc == '150' || dc == '151' || dc == '120' || dc == '513'){
                        let arragloKit = ['Basico', 'ZeroVision','Premium'];
                        cargarDatosKit(tipokit, arragloKit);
                    }else if(dc=='155' || dc== '153' || dc == '152'){
                        let arragloKit = ['Basico', 'ZeroVision'];
                        cargarDatosKit(tipokit, arragloKit);
                    } else {
                        let arragloKit = ['Basico', 'Premium'];
                        cargarDatosKit(tipokit, arragloKit);
                    }
                    
                    //ARBOL DE DESICIONES SIN ZEROVISION
                    /*
                    let arragloKit = ['Basico', 'Premium'];
                    cargarDatosKit(tipokit, arragloKit);
                    */
                }
                else if (segmento == 'NEG'){
                    //ARBOL DE DESICIONES PARA ZEROVISION
                    
                    if(dc == '150' || dc=='151' || dc=='120' || dc == '513'){
                        let arragloKit = ['Basico', 'ZeroVision','Premium'];
                        cargarDatosKit(tipokit, arragloKit);
                    }
                    else if (dc == '155' || dc == '153' || dc == '152'){
                        let arragloKit = ['ZeroVision'];
                        cargarDatosKit(tipokit, arragloKit);
                    } else {
                        let arragloKit = ['Basico', 'Premium'];
                        cargarDatosKit(tipokit, arragloKit);
                    }
                    //ARBOL DE DESICIONES SIN ZEROVISION
                    /*
                    let arragloKit = ['Basico', 'Premium'];
                    cargarDatosKit(tipokit, arragloKit);
                    */
                }
            }
            
            function cargarDatosKit(tipokit, arragloKit){
                for (value in arragloKit) {
                    var option = document.createElement("option");
                    option.value = arragloKit[value];
                    option.text = arragloKit[value];
                    tipokit.add(option);
                }
            }
            
            function closingPack(){
                const segmento = $('#lblsegmento').val();
                closingpack = document.getElementById("lblclosingpack");
                
                limpiarDatos(closingpack);
                
                if (segmento == 'RES'){
                    if(dc == '150' || dc == '151' || dc=='152' || dc== '153' || dc == '155' || dc == '120'){
                        let arregloValueClosingPack = ['Ninguno', '3Magnetico', '1MG+1FOTO'];
                        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
                    } else {
                        let arregloValueClosingPack = ['Ninguno', '3Magnetico'];
                        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
                    }
                } else if (segmento == 'NEG'){
                    if(dc == '150' || dc == '151' || dc=='152' || dc== '153' || dc == '155' || dc == '120'){
                        let arregloValueClosingPack = ['Ninguno', '3Magnetico', '1MG+1FOTO'];
                        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
                    } else {
                        let arregloValueClosingPack = ['Ninguno', '3Magnetico'];
                        cargarDatosClosingPack(closingpack, arregloValueClosingPack);
                    }
                }
                
                
                /*
                if (segmento == 'RES'){
                    let arregloValueClosingPack = ['Ninguno', '3Magnetico'];
                    cargarDatosClosingPack(closingpack, arregloValueClosingPack);
                } else {
                    let arregloValueClosingPack = ['Ninguno'];
                    cargarDatosClosingPack(closingpack, arregloValueClosingPack);
                }
                */
            }
            
            function cargarDatosClosingPack(closingpack, arregloClosingPack){
                for (value in arregloClosingPack) {
                    var option = document.createElement("option");
                    option.value = arregloClosingPack[value];
                    option.text = arregloClosingPack[value];
                    closingpack.add(option);
                }
            }
            
            function limpiarDatos(select){
                while(select.children.length > 1){
                    select.lastChild.remove();
                }
            }
            
   function datosHTML() {
            limpiarHTML(contenedorNuevosDatos);
            

            let resumen = '';
            let total = 0;
            let totalcantidad=0;
            let totalCuota = 0;
            let fila = 1;

            let myJsonString = JSON.stringify(arregloDatos);

            arregloDatos.forEach(
                datos => {
                    console.log(datos);
                    const {
                        Producto,
                        txtProducto,
                        TipoPrecio,
                        Cantidad,
                        PrecioAdicional,
                        PrecioSubTotal,
                        CuotaMensual
                    } = datos;
                    const row = document.createElement('tr');
                    row.innerHTML = `
                                    <td data-label="#">${Producto}</td>
                                    <td data-label="Producto">${txtProducto}</td>
                                    <td data-label="Cantidad">${Cantidad}</td>
                                    <td data-label="Opciones"><a href="#" class="borrar-producto fa fa-fw  fa-remove" data-id="${Producto}" text-id="${txtProducto}"></a> <a href="#" class="editar-producto fa fa-fw fa-edit" data-id="${Producto}" text-id="${txtProducto}"></a></td>
                                `
                    contenedorNuevosDatos.appendChild(row);

                    console.log(arregloDatos.length);

                    if (fila == arregloDatos.length) {
                        resumen += Cantidad+' '+txtProducto+ '';
                    } else {
                        resumen += Cantidad+' '+txtProducto +' + ';
                    }

                    console.log(PrecioSubTotal);
                    console.log(CuotaMensual);

                    total += PrecioSubTotal;
                    totalcantidad+=Cantidad;
                    totalCuota += CuotaMensual;
                    fila++;

                })

            let adicionalOtros = $('#lblAdicionalesOtros').val();

            if (adicionalOtros != '') {
                resumen += ' + ' + adicionalOtros;
            }

            $('#txtResumen').val(resumen);
            $('#txtCantidad').val(totalcantidad);
            $('#txtTotal').val(total);
            $('#txtTotalCuota').val(totalCuota);
            $('#txtJson').val(myJsonString);


        }
        
        //Elimina los cursos del tbody
        function limpiarHTML(cont) {
            //forma recomendada
            while (cont.firstChild) {
                cont.removeChild(cont.firstChild);
            }
            
            $('#txtResumen').val('');
            $('#txtCantidad').val('');
            $('#txtTotal').val('');
            $('#txtJson').val('');
        }
    </script>
            
        </script>
    </body>
</html>