<?php
session_start();
if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
        }


if (($_SESSION['pzcallrpporcontactar']+$_SESSION['pzcallrpbacklog'])==0) {
     header("location: ./denegado.php");
		exit;
        }

date_default_timezone_set('America/Lima');
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

include 'config/db.php';
include 'config/conexion.php';
include 'helper/helper_validacion.php';

if (isset($_GET['Id'])) {

    $idreferido = sanitizaCampo($_GET['Id'], 'sanitizeint|scapestring|htmlspecialchars', $con);
    $idreferido = htmlspecialchars($idreferido);
    $IdRPRE = sanitizaCampo($_GET['IdRPRE'], 'sanitizeint|scapestring|htmlspecialchars', $con);
    $IdRPRE = htmlspecialchars($IdRPRE); 
    $TipoVentaURL = sanitizaCampo($_GET['TipoVenta'], 'sanitizestring|scapestring|htmlspecialchars', $con);
    $TipoVentaURL = htmlspecialchars($TipoVentaURL); 

}

if(isset($_GET['regr'])){
    $regr = sanitizaCampo($_GET['regr'], 'sanitizeint|scapestring|htmlspecialchars', $con);
    $regr = htmlspecialchars($regr);     
}else{
    $regr="";
}     

$fechames=date("M-Y");

if($TipoVentaURL=='RE' || $TipoVentaURL=='RPMKT' || $TipoVentaURL=='REGGCC'){
    $sql_venta = "SELECT 
refd.Id,
ref.IdProspectoRP,
ref.TipoVenta,
ref.Matricula,
pr.IdUsuario,
pr.Comercial,
pr.CC,
pr.JefeVenta,
u.Estado AS EstadoUsuario,
c.NombApellido AS ClienteREF,
refd.EstadoReferido,
refd.PrimerNombre,
refd.PrimerApellido,
refd.Telefono,
refd.Segmento,
refd.FechaHoraREG,
refd.TipoContacto,
refd.MotivoNoAceptaVisita,
DATE_FORMAT(refd.FechaRellamada,'%d/%m/%Y') FechaRellamada,
TIME_FORMAT(refd.HoraRellamada,'%r') HoraRellamada,
refd.Competencia,
refd.ComentarioCallRP,
c2.Correo,
c2.Direccion,
DATE_FORMAT(p2.FechaVisitaRP,'%d/%m/%Y') FechaVisitaRP,
TIME_FORMAT(p2.HoraVisitaRP,'%r') HoraVisitaRP,
p2.MesVisitaRP,
g.IdGeografico,
g.Distrito,
g.Provincia,
refd.FechaPrimerContacto,
refd.Vueltas
FROM yifi58ge_dbREFERIDO.tblreferido ref 
INNER JOIN yifi58ge_dbREFERIDO.tblreferido_detalle refd on ref.Id=refd.Referido_ID
INNER JOIN yifi58ge_dbVENTAS.tblventa pr on pr.IdVenta=ref.IdProspectoRP
INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=pr.IdCliente
INNER JOIN yifi58ge_dbUSUARIO.tblusuario u on pr.IdUsuario=u.IdUsuario

LEFT JOIN yifi58ge_dbVENTAS.tblprospectorp p2 on p2.IdReferido=refd.Id
LEFT JOIN yifi58ge_dbVENTAS.tblcliente c2 on c2.IdCliente=p2.IdCliente
LEFT JOIN yifi58ge_dbVENTAS.tblgeografico g on g.IdGeografico=c2.IdGeografico
WHERE refd.Id=?";
}else{
  $sql_venta ="SELECT 
refd.Id,
ref.IdProspectoRP,
ref.TipoVenta,
ref.Matricula,
pr.IdUsuario,
pr.Comercial,
pr.CC,
pr.JefeVenta,
u.Estado AS EstadoUsuario,
c.NombApellido AS ClienteREF,
refd.EstadoReferido,
refd.PrimerNombre,
refd.PrimerApellido,
refd.Telefono,
refd.Segmento,
refd.FechaHoraREG,
refd.TipoContacto,
refd.MotivoNoAceptaVisita,
DATE_FORMAT(refd.FechaRellamada,'%d/%m/%Y') FechaRellamada,
TIME_FORMAT(refd.HoraRellamada,'%r') HoraRellamada,
refd.Competencia,
refd.ComentarioCallRP,
c2.Correo,
c2.Direccion,
DATE_FORMAT(p2.FechaVisitaRP,'%d/%m/%Y') FechaVisitaRP,
TIME_FORMAT(p2.HoraVisitaRP,'%r') HoraVisitaRP,
p2.MesVisitaRP,
g.IdGeografico,
g.Distrito,
g.Provincia,
refd.FechaPrimerContacto,
refd.Vueltas
FROM yifi58ge_dbREFERIDO.tblreferido ref 
INNER JOIN yifi58ge_dbREFERIDO.tblreferido_detalle refd on ref.Id=refd.Referido_ID
INNER JOIN yifi58ge_dbVENTAS.tblprospectorp pr on pr.IdProspectoRP=ref.IdProspectoRP
INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=pr.IdCliente
INNER JOIN yifi58ge_dbUSUARIO.tblusuario u on pr.IdUsuario=u.IdUsuario

LEFT JOIN yifi58ge_dbVENTAS.tblprospectorp p2 on p2.IdReferido=refd.Id
LEFT JOIN yifi58ge_dbVENTAS.tblcliente c2 on c2.IdCliente=p2.IdCliente
LEFT JOIN yifi58ge_dbVENTAS.tblgeografico g on g.IdGeografico=c2.IdGeografico
WHERE refd.Id=?";  
}

    try{

        $stmt = $con->prepare($sql_venta);
        $stmt->bind_param('i', $idreferido);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($Id,
$IdProspectoRP,
$TipoVenta,
$Matricula,
$IdUsuario,
$Comercial,
$CC,
$JefeVenta,
$EstadoComercial,
$ClienteREF,
$EstadoReferido,
$PrimerNombre,
$PrimerApellido,
$Telefono,
$Segmento,
$FechaHoraREG,
$TipoContacto,
$movitonoaceptavisita,
$frellamada,
$hrellamada,
$competencia,
$ComentarioCallRP,
$correo,
$direccion,
$fvisita,
$hvisita,
$mesvisita,
$idgeografico,
$distrito,
$provincia,
$FechaPrimerContacto,
$Vueltas);
$stmt->fetch();

        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

?>


<!DOCTYPE html>
<html>

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<title>Verisure | VeriSmart</title>
	<!-- Tell the browser to be responsive to screen width -->
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png">
	<!-- Bootstrap 3.3.7 -->
	<link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
	<!-- Font Awesome -->
	<link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
	<!-- Ionicons -->
	<link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
	<!-- Theme style -->
	<link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
	<!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
	<link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">


	<!-- bootstrap datepicker -->
	<link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
	<!-- iCheck for checkboxes and radio inputs -->
	<link rel="stylesheet" href="admin/plugins/iCheck/all.css">
	<!-- Bootstrap time Picker -->
	<link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
	<!-- Select2 -->
	<link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">


	<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
	<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
	<!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->

	<!-- Google Font -->
	<link rel="stylesheet"
		href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">

	<link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css"
		rel="stylesheet" type="text/css" />
	<!-- Alertifyjs -->
	<link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css" />
	<link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css" />


	<style>
		.lblvervisita {
			display: none;
		}

		.lblverllamada {
			display: none;
		}

		.lblvermotivonoaceptavisita {
			display: none;
		}

		.lblver590 {
			display: none;
		}

		.lblcompetencia {
			display: none;
		}

		.modal-header-danger {
			color: #fff;
			background-color: #e4002b;
		}


		.preloader {
			background-color: #FFF;
			width: 100%;
			height: 100%;
			position: absolute;
			z-index: 1;
		}

		.dataTables_wrapper .myfilter .dataTables_filter {
			float: left
		}

		.dataTables_wrapper .mylength .dataTables_length {
			float: right
		}

		div.dataTables_scrollBody thead th {
			vertical-align: top;
		}

		td {
			max-width: 250px;
			overflow: hidden;
			white-space: nowrap;
			text-overflow: ellipsis;

		}

		.espacio {
			height: 10px;
		}

		.espacio2 {
			height: 15px;
		}

		.thumbnail_style {
			text-align: center;
			border: none;
		}


		.caption h4 {
			margin-top: -10px;
			font-size: 13px;
			font-weight: bold;
		}

		.caption p {
			color: #777;
			font-size: 13px;
		}

		.caption a {
			color: #777;
			font-size: 10px;
		}


		#frmEditarVenta .form-control {
			border-radius: 4px
		}

		#c-slider {
			margin: auto;
			width: 100%;
			max-width: 900px;
			position: relative;
			overflow: hidden;

		}

		#slider {
			display: flex;
			width: 200%;

		}

		#slider section {
			width: 100%;
		}


		.select2-container--default .select2-selection--single {

			border: 1px solid #d2d6de;
			border-radius: 4px;
			font-size: 12px;
			padding: 4px 6px;
		}

		.btn-nuevo {
			color: #FFFFFF;
			background-color: #444444;
			border-color: #444444;
		}

		.btn-nuevo:hover,
		.btn-nuevo:focus,
		.btn-nuevo:active,
		.btn-nuevo.active,
		.open .dropdown-toggle.btn-nuevo {
			color: #FFFFFF;
			background-color: #616161;
			border-color: #444444;
		}

		.btn-nuevo:active,
		.btn-nuevo.active,
		.open .dropdown-toggle.btn-nuevo {
			background-image: none;
		}

		.btn-nuevo.disabled,
		.btn-nuevo[disabled],
		fieldset[disabled] .btn-nuevo,
		.btn-nuevo.disabled:hover,
		.btn-nuevo[disabled]:hover,
		fieldset[disabled] .btn-nuevo:hover,
		.btn-nuevo.disabled:focus,
		.btn-nuevo[disabled]:focus,
		fieldset[disabled] .btn-nuevo:focus,
		.btn-nuevo.disabled:active,
		.btn-nuevo[disabled]:active,
		fieldset[disabled] .btn-nuevo:active,
		.btn-nuevo.disabled.active,
		.btn-nuevo[disabled].active,
		fieldset[disabled] .btn-nuevo.active {
			background-color: #444444;
			border-color: #444444;
		}


		input[type=number]::-webkit-outer-spin-button,

		input[type=number]::-webkit-inner-spin-button {

			-webkit-appearance: none;

			margin: 0;

		}



		input[type=number] {

			-moz-appearance: textfield;

		}
	</style>

	<style>
		.main-header,
		.main-sidebar,
		.left-side {
			position: fixed
		}

		.main-header {
			top: 0;
			right: 0;
			left: 0
		}

		.content-wrapper,
		.right-side {
			padding-top: 50px
		}

		@media (max-width:767px) {

			.content-wrapper,
			.right-side {
				padding-top: 100px
			}
		}

		.layout-boxed .wrapper {
			max-width: 100%
		}

		.wrapper {
			overflow: hidden .control-sidebar {
				position: fixed;
				height: 100%;
				overflow-y: auto;
				padding-bottom: 50px
			}
	</style>



	<style>
		.ui-autocomplete {
			position: absolute;
			z-index: 1000;
			cursor: default;
			padding: 0;
			margin-top: 2px;
			list-style: none;
			font-size: 11px;
			font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
			background-color: #ffffff;
			border: 1px solid #ccc;
			-webkit-border-radius: 5px;
			-moz-border-radius: 5px;
			border-radius: 5px;
			-webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
			-moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
			box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);

			z-index: 1051 !important;

		}





		hr {
			height: 4px;
			width: 100%;
			background-color: #ecf0f5;

		}



		hr {
			/* margin-top: 20px; */
			margin-bottom: 20px;
			border: 0;
			/* border-top: 1px solid #eee; */
		}


		hr {
			display: block;
			unicode-bidi: isolate;
			-webkit-margin-before: 0.5em;
			-webkit-margin-after: 0.5em;
			-webkit-margin-start: auto;
			-webkit-margin-end: auto;
			overflow: hidden;
			border-style: inset;

		}

		.box.box-custom {
			border-top-color: #ffffff;
		}

		.box {
			position: relative;
			border-radius: 3px;
			background: #ffffff;
			border-top: 3px solid #d2d6de;
			margin-bottom: 5px;
			width: 100%;
			box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
		}
        .subtitulo{
            text-decoration: underline;
            font-weight: bold;
        }		
	</style>


</head>

<body class="sidebar-collapse skin-red sidebar-mini">

	<div class="wrapper">
		<!-- Header -->
		<?php include 'admin/header.php'; ?>
		<!-- Left side column. contains the logo and sidebar -->
		<?php

$callrp="active";


            include 'admin/main-sidebar.php';
            ?>


		<!-- Content Wrapper. Contains page content -->
		<div class="content-wrapper">
			<!-- Content Header (Page header) -->
			<section class="content-header">
				<h1>
					RPTMK - REFERIDO
				</h1>
				<ol class="breadcrumb">
					<li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
					<li class="active">Referido</li>
				</ol>


			</section>


			<!-- Main content -->
			<section class="content">


				<div class="row">
					<div class="col-md-2"></div>

					<div class="col-md-8">


						<!-- /.box-header -->

						<div class="box box-danger">
							<div class="box-header">

								<table style="width:90%;">

									<tr>
										<td style="width: 7%;">





											<h3 class="box-title cattitle">
												NUEVO REFERIDO
											</h3>


											<input id="lblcat" name="lblcat" value="" hidden="">


										</td>


									</tr>

								</table>



								<div class="box-tools pull-right">
									<?php if($nombacceso=='test'){

                                                 }else{ ?>
									<a class="btn btn-nuevo btn-sm" id="btnGuardarEditarVenta" href="#" <?php /*CAMBIO
										AÑADIDO EL 9.07 porque se envia estadoprospecto Vacio*/ if
										($EstadoReferido=='VisitaAceptada' ){ echo 'style= display:none' ;} ?>><i
											class="fa fa-save"></i></a>

									<?php   } if($regr=="backlog"){ ?>

									<a href="callrpreferidosgestor.php" class="btn btn-danger btn-sm"><i
											class="fa fa-reply"></i> </a>
									<?php } else {?>
									<a href="callrpreferidos.php" class="btn btn-danger btn-sm"><i
											class="fa fa-reply"></i> </a>
									<?php } ?>

								</div>


							</div>
							<div class="espacio"></div>



						</div>

						<form id="frmEditarVenta" method="POST">
						    <input type="hidden" id="FechaPrimerContacto" value="<?php echo $FechaPrimerContacto; ?>">
						    <input type="hidden" id="idreferido" value="<?php echo $idreferido; ?>">
						    
							<div class="box box-custom">
								<div class="box-header with-border" style="background-color:#2c3b41;color:white;">
									<h5>INFORMACION DEL CLIENTE</h5>

									<div class="box-tools pull-right">
										<button type="button" class="btn btn-box-tool" data-widget="collapse"><i
												class="fa fa-minus"></i>
										</button>

									</div>
								</div>
								<!-- /.box-header -->
								<div class="box-body">

									<table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">

										<tr>


											<td style="width:15%;font-size: 12px">CLIENTE:</td>

											<td style="width:25%;">
												<input name="lblclienteref" id="lblclienteref"
													class="form-control input-sm" value="<?php echo $ClienteREF;?>"
													style="width: 100%;" readonly="readonly">
											</td>
											<td style="width:10%"></td>
											<td style="width:15%;font-size: 12px">IDPROSPECTO_RP_RE: <span
													style="color:red"> * </span></td>
											<td style="width:2%"></td>
											<td style="width:25%">
												<input name="lblidprospectorp" id="lblidprospectorp"
													class="form-control input-sm" style="width: 100%;"
													value="<?php echo $IdProspectoRP;?>" readonly="readonly">
											</td>
										</tr>
										<tr class="espacio"></tr>
										<tr>


											<td style="width:15%;font-size: 12px">MATRICULA: <span style="color:red"> *
												</span></td>

											<td style="width:25%;">
												<?php if ($EstadoComercial == 'Activo') { ?>
												<div class="input-group">
													<span class="input-group-addon" style="color: green"
														title="ACTIVO"><i class="fa fa-check"></i></span>
													<input name="lblmatricula" id="lblmatricula"
														class="form-control input-sm" value="<?php echo $Matricula;?>"
														style="width: 100%;" readonly="readonly">
													<input id="lblidusuario" name="lblidusuario"
														value="<?php echo $IdUsuario;?>" hidden="">
												</div>
												<?php } else { ?>
												<div class="input-group">
													<span class="input-group-addon" style="color: red" title="CESADO"><i
															class="fa fa-exclamation"></i></span>
													<input name="lblmatricula" id="lblmatricula"
														class="form-control input-sm" value="<?php echo $Matricula;?>"
														style="width: 100%;" readonly="readonly">
													<input id="lblidusuario" name="lblidusuario"
														value="<?php echo $IdUsuario;?>" hidden="">
												</div>
												<?php } ?>
											</td>
											<td style="width:10%"></td>
											<td style="width:15%;font-size: 12px">COMERCIAL: <span style="color:red"> *
												</span></td>
											<td style="width:2%"></td>
											<td style="width:25%"><input name="lblnombcomercial" id="lblnombcomercial"
													class="form-control input-sm" style="width: 100%;"
													value="<?php echo $Comercial;?>" readonly="readonly"></td>
										</tr>
										<tr class="espacio"></tr>
										<tr>
											<td style="width:15%;font-size: 12px">DC: <span style="color:red"> * </span>
											</td>

											<td style="width:25%;">
												<input name="lbldc" id="lbldc" class="form-control input-sm"
													style="width: 100%;" value="<?php echo $CC;?>" readonly="readonly">
											<td style="width:10%"></td>
											<td style="width:15%;font-size: 12px">JEFE VENTA: <span style="color:red"> *
												</span></td>
											<td style="width:2%"></td>
											<td style="width:25%">
												<input name="lbljefeventa" id="lbljefeventa"
													class="form-control input-sm" style="width: 100%;"
													value="<?php echo $JefeVenta;?>" readonly="readonly">
											</td>

										</tr>
										<tr class="espacio"></tr>
										<tr>
											<td style="width:15%;font-size: 12px">TIPOVENTA: <span style="color:red"> *
												</span></td>

											<td style="width:25%;">
												<input type="text" class="form-control pull-right input-sm"
													id="tipoventa" name="tipoventa" value="<?php echo $TipoVenta;?>"
													readonly="readonly">
											<td style="width:10%"></td>
											<td style="width:15%;font-size: 12px"></td>
											<td style="width:2%"></td>
											<td style="width:25%">
											</td>

										</tr>
									</table>
								</div>
								<!-- /.box-body -->

							</div>

							<div class="box box-custom">
								<div class="box-header with-border" style="background-color:#2c3b41;color:white;">
									<h5>INFORMACION DEL REFERIDO</h5>

									<div class="box-tools pull-right">
										<button type="button" class="btn btn-box-tool" data-widget="collapse"><i
												class="fa fa-minus"></i>
										</button>

									</div>
								</div>
								<!-- /.box-header -->
								<div class="box-body">

									<table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">
										<tr>
											<td style="width:15%;font-size: 12px">NOMBRE: <span style="color:red"> *
												</span></td>

											<td style="width:25%;">
												<input name="lblprimernombre" id="lblprimernombre"
													class="form-control input-sm" style="width: 100%;"
													value="<?php echo $PrimerNombre;?>">
											</td>
											<td style="width:10%"></td>
											<td style="width:15%;font-size: 12px">APELLIDO: <span style="color:red"> *
												</span></td>
											<td style="width:2%"></td>
											<td style="width:25%">
												<input name="lblprimerapellido" id="lblprimerapellido"
													class="form-control input-sm" style="width: 100%;"
													value="<?php echo $PrimerApellido;?>">
										</tr>
										<tr class="espacio"></tr>
										<tr>
											<td style="width:15%;font-size: 12px">TELEFONO: <span style="color:red"> *
												</span></td>

											<td style="width:25%;"><input type="tel" class="form-control input-sm"
													name="lbltelefono" id="lbltelefono" value="<?php echo $Telefono;?>"
													readonly="readonly"></td>
											<td style="width:10%"></td>
											<td style="width:15%;font-size: 12px">SEGMENTO: <span style="color:red"> *
												</span></td>
											<td style="width:2%"></td>
											<td style="width:25%"><select class="form-control input-sm"
													name="lblsegmento" id="lblsegmento">
													<option>Seleccione</option>
													<option value="RES" <?php if ($Segmento=="RES" ) {echo "selected"
														;}?>>RES</option>
													<option value="NEG" <?php if ($Segmento=="NEG" ) {echo "selected"
														;}?>>NEG</option>
												</select></td>
										</tr>
									</table>
								</div>
								<!-- /.box-body -->

							</div>


							<div class="box box-custom">
								<div class="box-header with-border" style="background-color:#2c3b41;color:white;">
									<h5>INFORMACION DE GESTIÓN</h5>

									<div class="box-tools pull-right">
										<button type="button" class="btn btn-box-tool" data-widget="collapse"><i
												class="fa fa-minus"></i>
										</button>

									</div>
								</div>
								<!-- /.box-header -->
								<div class="box-body">
									<table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">
										<tr>
											<td style="width:15%;font-size: 12px">GESTOR CONTACT RP: <span
													style="color:red"> * </span></td>

											<td style="width:25%"><input name="lblgestorcontactrp"
													class="form-control input-sm" id="lblgestorcontactrp"
													value="<?php echo $matriculausuario." - ".$nombreusuario;?>"
													style="width: 100%;" readonly="readonly" />
											</td>
											<td style="width:10%"></td>
											<td style="width:15%;font-size: 12px">TIPO CONTACTO</td>
											<td style="width:2%"></td>
											<td style="width:25%">
												<select class="form-control input-sm" id="tipocontacto"
													name="tipocontacto">
													<option value="" disabled="" selected="">Seleccione</option>
													<option value="SI" <?php if ($TipoContacto=="SI" ) {echo "selected"
														;}?>>SI</option>
													<option value="NO" <?php if ($TipoContacto=="NO" ) {echo "selected"
														;}?>>NO</option>
												</select>
											</td>
										</tr>
										<tr class="espacio"></tr>
										<tr>
											<td style="width:15%;font-size: 12px">ESTADO DE REFERIDO: <span
													style="color:red"> * </span></td>
											<td style="width:25%;">

												<select class="form-control input-sm" name="lblestadoreferido"
													id="lblestadoreferido" style="width: 100%;">
													<option value="">Seleccione</option>
												</select>
												<input type="hidden" name="hiddenestadoreferido"
													value="<?php echo $EstadoReferido; ?>" id="hiddenestadoreferido" />
											</td>
											<td style="width:10%"></td>
											<td style="width:15%;font-size: 12px"><span class="lblvervisita">MES VISITA:
													<span style="color:red"> * </span></span></td>
											<td style="width:2%"></td>
											<td style="width:25%">
												<div class="lblvervisita"><input name="lblmesvisita"
														class="form-control input-sm" id="lblmesvisit"
														value="<?php if(isset($mesvisita)){ echo $mesvisita;}else{echo $fechames;}?>"
														style="width: 100%;" />

												</div>

											</td>
										</tr>
										<tr class="espacio lblvervisita"></tr>
										<tr class="lblvervisita">
											<td style="width:15%;font-size: 12px">RECURSO: <span style="color:red"> *
												</span></td>
											<td style="width:25%">
												<input type="text" class="form-control pull-right input-sm"
													id="lbltipoventa" name="lbltipoventa" value="RPTMK"
													readonly="readonly">
											</td>
											<td style="width:10%"></td>
											<td style="width:15%;font-size: 12px">CORREO: <span style="color:red"> *
												</span></td>
											<td style="width:2%"></td>
											<td style="width:25%">
												<input type="text" class="form-control input-sm" id="lblcorreo"
													value="<?php echo $correo;?>" name="lblcorreo">
											</td>
										</tr>
										<tr class="espacio lblvervisita"></tr>
										<tr class="lblvervisita">

											<td style="width:15%;font-size: 12px">DIRECCIÓN: <span style="color:red"> *
												</span>:</td>

											<td colspan="3" style="width:50%"><textarea class="form-control input-sm"
													name="lbldireccion" id="lbldireccion" rows="1" style="resize:none"
													placeholder="Ingresar..."><?php echo $direccion;?></textarea></td>

											<td style="width:2%"></td>
											<td style="width:25%"><select class="form-control selectdistrito input-sm"
													name="lbldistrito" id="lbldistrito" style="width: 100%;">
													<option value="<?php echo $idgeografico; ?>">
														<?php echo $distrito.' - '.$provincia; ?>
													</option>
												</select></td>

										</tr>
										<tr class="espacio lblvervisita"></tr>
										<tr class="lblvervisita">
											<td style="width:15%;font-size: 12px">FECHA VISITA: <span style="color:red">
													* </span></td>

											<td style="width:25%">
												<div class="input-group">
													<div class="input-group-addon input-sm btn btn-default"
														data-toggle="modal" data-target="#modal-default"
														id="btn_agenda">
														<i class="fa fa-calendar"></i>
													</div>
													<input type="text" class="form-control pull-right input-sm"
														id="lblfvisita" name="lblfvisita" value="<?php echo $fvisita;?>"
														data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
												</div>

											</td>
											<td style="width:10%"></td>
											<td style="width:15%;font-size: 12px">HORA VISITA: <span style="color:red">
													* </span></td>
											<td style="width:2%"></td>
											<td style="width:25%">
												<div class="bootstrap-timepicker timepicker">
													<div class="input-group">
														<input type="text" class="form-control input-sm"
															placeholder="12:00 AM" name="lblhvisita" id="lblhvisita"
															value="<?php echo $hvisita;?>">
														<div class="input-group-addon input-sm">
															<i class="fa fa-clock-o"></i>
														</div>
													</div>
												</div>

											</td>
										</tr>

										<tr class="espacio lblverllamada"></tr>
										<tr class="lblverllamada">
											<td style="width:15%;font-size: 12px">FECHA RELLAMADA: <span
													style="color:red"> * </span></td>

											<td style="width:25%">
												<div class="input-group">
													<div class="input-group-addon input-sm">
														<i class="fa fa-calendar"></i>
													</div>
													<input type="text" class="form-control pull-right input-sm"
														id="lblfrellamada" name="lblfrellamada"
														value="<?php echo $frellamada;?>"
														data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
												</div>

											</td>
											<td style="width:10%"></td>
											<td style="width:15%;font-size: 12px">HORA RELLAMADA: <span
													style="color:red"> * </span></td>
											<td style="width:2%"></td>
											<td style="width:25%">
												<div class="bootstrap-timepicker timepicker">
													<div class="input-group">
														<input type="text" class="form-control input-sm"
															placeholder="12:00 AM" name="lblhrellamada"
															id="lblhrellamada" value="<?php echo $hrellamada;?>">
														<div class="input-group-addon input-sm">
															<i class="fa fa-clock-o"></i>
														</div>
													</div>
												</div>

											</td>
										</tr>
										<tr class="espacio lblvermotivonoaceptavisita"></tr>
										<tr>
											<td style="width:15%;font-size: 12px"><span
													class="lblvermotivonoaceptavisita">MOTIVO NO ACEPTA VISITA: <span
														style="color:red"> * </span></span></td>

											<td style="width:25%"> <select
													class="form-control input-sm lblvermotivonoaceptavisita"
													name="lblmovitonoaceptavisita" id="lblmovitonoaceptavisita"
													style="width: 100%;">
													<option value="">Seleccione</option>
													<option value="NoInteresado" <?php if
														($movitonoaceptavisita=="NoInteresado" ) {echo "selected" ;}?>
														>No Interesado</option>
													<option value="NoInteresadoDemo" <?php if
														($movitonoaceptavisita=="NoInteresadoDemo" ) {echo "selected"
														;}?>>No Interesado - Demo</option>
													<option value="Precio" <?php if ($movitonoaceptavisita=="Precio" )
														{echo "selected" ;}?>>Precio</option>
													<option value="Competencia" <?php if
														($movitonoaceptavisita=="Competencia" ) {echo "selected" ;}?>
														>Competencia</option>
													<option value="Otros" <?php if ($movitonoaceptavisita=="Otros" )
														{echo "selected" ;}?>>Otros</option>
												</select>
											</td>
											<td style="width:10%"></td>
											<td style="width:15%;font-size: 12px"><span
													class="lblcompetencia">COMPETENCIA: <span style="color:red"> *
													</span></span></td>
											<td style="width:2%"></td>
											<td style="width:25%">
												<select style="" class="form-control input-sm lblcompetencia"
													name="lblcompetencia" id="lblcompetencia" hidden="">
													<option value="">Seleccione</option>
													<option value="Prosegur" <?php if ($competencia=="Prosegur" )
														{echo "selected" ;}?>>Prosegur</option>
													<option value="Mapfre" <?php if ($competencia=="Mapfre" )
														{echo "selected" ;}?>>Mapfre</option>
													<option value="Clave3" <?php if ($competencia=="Clave3" )
														{echo "selected" ;}?>>Clave3</option>
													<option value="Boxer" <?php if ($competencia=="Boxer" )
														{echo "selected" ;}?>>Boxer</option>
													<option value="Otros" <?php if ($competencia=="Otros" )
														{echo "selected" ;}?>>Otros</option>
												</select>
											</td>
										</tr>
										<tr class="espacio"></tr>
										<tr>
											<td style="width:15%;font-size: 12px">COMENTARIO CALL RP: <span
													style="color:red"> * </span></td>

											<td colspan="5" style="width:77%"><textarea class="form-control input-sm"
													name="lblcomentariocallrp" id="lblcomentariocallrp" rows="2"
													style="resize:none"
													placeholder="Ingresar..."><?php echo $ComentarioCallRP;?></textarea>
											</td>
										</tr>
										<tr class="espacio"></tr>	
										<tr>
											<td style="width:15%;font-size: 12px">VUELTAS</td>
                                            <td colspan="1" style="width:25%"><input name="lblvueltas"
													class="form-control input-sm" id="lblvueltas"
													value="<?php echo $Vueltas; ?>"
													style="width: 100%;" readonly="readonly" />
											</td>											
										</tr>
									</table>

                                            <br>
                                            <div class="row origen_ocultar" style="padding: 10px 20px 0">
                                                <div>
                                                    <h5 class="subtitulo ">HISTORICO GESTIÓN</h5>
                                                </div>
                                                <div class="col-md-2"></div>
                                                <div class="col-md-8 table-responsive">
                                                    <table class="table table-hover" id="historicoGestion">
                                                        <thead>
                                                            <tr>
                                                                <th>#</th>
                                                                <th>EstadoReferido</th>
                                                                <th>Gestor</th>
                                                                <th>FechaGestion</th>
                                                                <th>TipoContacto</th>
                                                                <th>FechaRellamada</th>
                                                                <th>ComentarioRP</th>
                                                                <th></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
								</div>
								<!-- /.box-body -->

							</div>


						</form>




					</div>


					<div class="col-md-2"></div>


				</div>


			</section>
			<!-- /.content -->

		</div>
		<!-- /.content-wrapper -->



		<div class="control-sidebar-bg"></div>
	</div>
	<!-- ./wrapper -->





	<!-- jQuery v1.11 -->

	<script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>

	<!-- jQuery UI 1.11.4 -->
	<script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
	<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
	<script>
		$.widget.bridge('uibutton', $.ui.button);</script>
	<!-- Bootstrap 3.3.7 -->
	<script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
	<!-- Select2 -->
	<script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
	<!-- Sparkline -->
	<script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>

	<!-- Slimscroll -->
	<script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
	<!-- FastClick -->
	<script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
	<!-- AdminLTE App -->
	<script src="admin/dist/js/adminlte.min.js"></script>
	<script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>

	<!-- InputMask -->
	<script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
	<script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
	<script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>


	<!-- bootstrap datepicker -->
	<script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
	<script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
	<!-- bootstrap time picker -->
	<script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>

	<!-- Alertify -->
	<script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
	<!-- SweetAlert -->
	<script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>
	<!-- Notificaciones -->
	<!--<script src="js/notificaciones.js" type="text/javascript"></script>-->
	
        <!-- CONSTANTES GLOBALES -->
        <script>
            const queryString = window.location.search;
            const urlParams = new URLSearchParams(queryString);        
            const IdReferido = urlParams.get('Id');
            const contenedorTablaHistoricoGestion = document.querySelector('#historicoGestion tbody');

        </script>	

	<script>
		$(function () {



			$("#lbldc").change(function () {
				$("#lbldc option:selected").each(function () {
					var lbldc = $(this).val();
					$.post("./ajax/selectJefeVenta.php", { lbldc: lbldc }, function (data) {
						$("#lbljefeventa").html(data);
					});
				});

			});

			$("#lblinstaladox").change(function () {
				$("#lblinstaladox option:selected").each(function () {
					var lblinstaladox = $(this).val();
					$.post("./ajax/selectTecnico.php", { lblinstaladox: lblinstaladox }, function (data) {
						$("#lbltecnico").html(data);
					});
				});

			});

			$("#lblestadoventa").change(function () {
				var condiciones = $("#lblestadoventa").val();
				$("#lblestventa").val(condiciones);
				bloquear(condiciones);

			});


			$("#lblestadoreferido").change(function () {
				var estadoreferido = $("#lblestadoreferido").val();
				var hiddenestadoreferido = $("#hiddenestadoreferido").val();
				var idreferido=$("#idreferido").val();


				if (estadoreferido == "ProspectoRP") {
					$(".cattitle").text("ProspectoRP");
				} else if (estadoreferido == "VisitaAceptada") {
					$(".cattitle").text("VISITA ACEPTADA RP - "+idreferido);
					$('.lblvervisita').show();
					$('.lblverllamada').hide();
					$('.lblvermotivonoaceptavisita').hide();
					$("#lblcat").val("VisitaAceptada");
					$('.lblcompetencia').hide();
					$('#lblmovitonoaceptavisita').val("");
				} else if (estadoreferido == "NoAceptaVisita") {
					$(".cattitle").text("NO ACEPTA VISITA - "+idreferido);
					$('.lblvervisita').hide();
					$('.lblverllamada').hide();
					$('.lblvermotivonoaceptavisita').show();
					$("#lblcat").val("NoAceptaVisita");
					$("#lblmovitonoaceptavisita").val("");
				} else if (estadoreferido == "NoContesta") {
					$(".cattitle").text("NO CONTESTA - "+idreferido);
					$('.lblvervisita').hide();
					$('.lblverllamada').hide();
					$('.lblvermotivonoaceptavisita').hide();
					$("#lblcat").val("NoContesta");
					$('.lblcompetencia').hide();
				} else if (estadoreferido == "DevolverLlamada") {
					$(".cattitle").text("DEVOLVER LLAMADA - "+idreferido);
					if (hiddenestadoreferido != estadoreferido) {
						$("#lblfrellamada").val("");
						$("#lblhrellamada").val("");
					}
					$('.lblvervisita').hide();
					$('.lblverllamada').show();
					$('.lblvermotivonoaceptavisita').hide();
					$("#lblcat").val("DevolverLlamada");
					$('.lblcompetencia').hide();

				} else if (estadoreferido == "ClienteError") {
					$(".cattitle").text("CLIENTE ERROR - "+idreferido);
					$('.lblvervisita').hide();
					$('.lblverllamada').hide();
					$('.lblvermotivonoaceptavisita').hide();
					$("#lblcat").val("ClienteError");
					$('.lblcompetencia').hide();
				} else if (estadoreferido == "TelefonoError") {
					$(".cattitle").text("TELEFONO ERROR - "+idreferido);
					$('.lblvervisita').hide();
					$('.lblverllamada').hide();
					$('.lblvermotivonoaceptavisita').hide();
					$("#lblcat").val("TelefonoError");
					$('.lblcompetencia').hide();
				} else if (estadoreferido == "ZSCC") {
					$(".cattitle").text("ZSCC - "+idreferido);
					$('.lblvervisita').hide();
					$('.lblverllamada').hide();
					$('.lblvermotivonoaceptavisita').hide();
					$("#lblcat").val("ZSCC");
					$('.lblcompetencia').hide();
				} else if (estadoreferido == "Provincia") {
					$(".cattitle").text("PROVINCIA RP - "+idreferido);
					$('.lblvervisita').hide();
					$('.lblverllamada').hide();
					$('.lblvermotivonoaceptavisita').hide();
					$("#lblcat").val("Provincia");
					$('.lblcompetencia').hide();
				} else if (estadoreferido == "Inviable") {
					$(".cattitle").text("INVIABLE - "+idreferido);
					$('.lblvervisita').hide();
					$('.lblverllamada').hide();
					$('.lblvermotivonoaceptavisita').hide();
					$("#lblcat").val("Inviable");
					$('.lblcompetencia').hide();
				} else if (estadoreferido == "Rechazada") {
					$(".cattitle").text("RECHAZADA - "+idreferido);
					$('.lblvervisita').hide();
					$('.lblverllamada').hide();
					$('.lblvermotivonoaceptavisita').hide();
					$("#lblcat").val("Rechazada");
					$('.lblcompetencia').hide();
				} else if (estadoreferido == "ClienteVerisure") {
					$(".cattitle").text("CLIENTE VERISURE - "+idreferido);
					$('.lblvervisita').hide();
					$('.lblverllamada').hide();
					$('.lblvermotivonoaceptavisita').hide();
					$("#lblcat").val("ClienteVerisure");
					$('.lblcompetencia').hide();
				}

				else if (estadoreferido == "VRPAsignada") {
					$(".cattitle").text("VISITA ASIGNADA RP - "+idreferido);
					$('.lblvervisita').show();
					$('.lblverllamada').hide();
					$('.lblvermotivonoaceptavisita').hide();
					$("#lblcat").val("VRPAsignada");
					$('.lblcompetencia').hide();
				} else if (estadoreferido == "AnuladaOP") {
					$(".cattitle").text("ANULADA POR OPERADOR - "+idreferido);
					$('.lblvervisita').hide();
					$('.lblverllamada').hide();
					$('.lblvermotivonoaceptavisita').hide();
					$("#lblcat").val("AnuladaOP");
					$('.lblcompetencia').hide();
				} else if (estadoreferido == "AnuladaCLI") {
					$(".cattitle").text("ANULADA POR CLIENTE - "+idreferido);
					$('.lblvervisita').hide();
					$('.lblverllamada').hide();
					$('.lblvermotivonoaceptavisita').hide();
					$("#lblcat").val("AnuladaCLI");
					$('.lblcompetencia').hide();
				} else if (estadoreferido == "AnuladaTEC") {
					$(".cattitle").text("ANULADA POR TECNICO - "+idreferido);
					$('.lblvervisita').show();
					$('.lblverllamada').hide();
					$('.lblvermotivonoaceptavisita').hide();
					$("#lblcat").val("AnuladaTEC");
					$('.lblcompetencia').hide();
				} else {
					$('.lblvervisita').hide();
					$('.lblverllamada').hide();
					$('.lblvermotivonoaceptavisita').hide();
					$("#lblcat").val("");
					$('.lblcompetencia').hide();
				}

			});

			$('#lblmovitonoaceptavisita').change(function () {
				var movitonoaceptavisita = $('#lblmovitonoaceptavisita').val();

				if (movitonoaceptavisita == 'Competencia') {
					$('.lblcompetencia').show();
				} else {
					$('.lblcompetencia').hide();
				}
			})


			$('#lblmatricula').on('keyup', function () {
				var dato = $('#lblmatricula').val();
				var url = 'ajax/findMatricula.php';
				$.ajax({
					type: 'POST',
					url: url,
					data: 'dato=' + dato,
					success: function (datos) {
						$('.mensajematricula').html(datos);
					}
				});
				return false;
			});

			$("#lblmatricula").autocomplete({
				source: "./ajax/selectMatricula.php",
				minLength: 2,
				select: function (event, ui) {
					event.preventDefault();
					$('#lblidusuario').val(ui.item.idusuario);
					$('#lblmatricula').val(ui.item.matricula);
					$('#lblnombcomercial').val(ui.item.comercial);
					//                        $('#lbldc').val(ui.item.dc);
					//                        $('#lbljefeventa').val(ui.item.jefe);

				}
			});

			$("#lblmatricula").on("keydown", function (event) {
				if (event.keyCode == $.ui.keyCode.LEFT || event.keyCode == $.ui.keyCode.RIGHT || event.keyCode == $.ui.keyCode.UP || event.keyCode == $.ui.keyCode.DOWN || event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE) {
					$('#lblidusuario').val("");
					$('#lblmatricula').val("");
					$('#lblnombcomercial').val("");
					//                        $('#lbldc').val("");
					//                        $('#lbljefeventa').val("");

				}
				if (event.keyCode == $.ui.keyCode.DELETE) {
					$('#lblmatricula').val("");
					$('#lblidusuario').val("");
					$('#lblnombcomercial').val("");
					//                        $('#lbldc').val("");
					//                        $('#lbljefeventa').val("");
				}
			});


			
			

		});


	</script>
	<!-- DOC READY -->
	<script>
		$(document).ready(function () {



			//notificacion();
			
			//Gestiones
			cargarDatos(IdReferido);

			cargarEstadoReferido($('#tipocontacto option:selected').val());
			$('#lblestadoreferido').val($('#hiddenestadoreferido').val());

			var alterClass = function () {
				var ww = document.body.clientWidth;
				if (ww < 767) {
					$('body').removeClass('sidebar-collapse');
				} else if (ww >= 768) {
					$('body').addClass('sidebar-collapse');
				}
				;
			};

			$(window).resize(function () {
				alterClass();
			});
			//Fire it when the page first loads:
			alterClass();


			$('#btnGuardarEditarVenta').click(function () {
				$(".cancel-button").prop("disabled", false);
				$(".habilitado-button").prop("disabled", false);
				var gestor = '<?php echo $matriculausuario; ?>';
				var catgventa = $('#lblcat').val();
				var idreferido = $("#idreferido").val();
				var FechaPrimerContacto=$('#FechaPrimerContacto').val();

				//Algunas variables por default de alertify
				alertify.defaults.theme.ok = "btn btn-nuevo habilitado-button";
				alertify.defaults.theme.cancel = "btn btn-danger cancel-button";

				var lastX, lastY;
				alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea guardar los cambios que ha realizado?', function () {
					if (validaForm()) {
						// Primero validará el formulario.

						var datos = $('#frmEditarVenta').serialize();
						console.log(gestor);
						console.log(catgventa);
						console.log(idreferido);
						console.log(datos);
						$(".cancel-button").prop("disabled", true);
						$(".habilitado-button").prop("disabled", true);
						$.ajax({
							type: 'POST',
							url: 'ajax/updateCallRPReferido.php',
							data: "lblcategoria=" + catgventa + "&lblidreferido=" + idreferido + "&gestor=" + gestor + "&FechaPrimerContacto=" + FechaPrimerContacto + "&" + datos,
							dataType: "JSON",
							success: function (r) {
								console.log(r);
								if (r.respuesta == "exito") {
									//alertify.success("Modificado con exito");
									var vueltas = $('#lblvueltas').val();
									vueltas = parseInt(vueltas) + 1;
                                    $('#lblvueltas').val(parseInt(vueltas));
                                    
									Swal.fire({
										title: "Modificado con éxito Referido ",
										text: '',
										type: 'success',
										confirmButtonColor: '#e4002b',
										confirmButtonText: 'Ok'
									}).then((result) => {
										if (result.value) {
											// alertify.success("Modificado con exito");
											window.location.reload();
										}
									})

								} else if (r.respuesta == "exitoVAceptada") {
									//alertify.success("Modificado con exito Visita Aceptada");

									Swal.fire({
										title: "Modificado con éxito Visita Aceptada",
										text: 'IDPROSPECTORP N°' + r.id_registro,
										type: 'success',
										confirmButtonColor: '#e4002b',
										confirmButtonText: 'Ok'
									}).then((result) => {
										if (result.value) {
											//alertify.success("Modificado con exito");
											window.location.reload();
										}
									})

									$('#btnGuardarEditarVenta').hide();

								} else {
									alertify.error("Fallo el server");
								}


							}
						});

					}
				}
					, function () { alertify.error('No se han guardado los cambios') }).set({
						transition: 'zoom', 'labels': { ok: '<i class="fa fa-check"></i> Aceptar', cancel: '<i class="fa fa-remove"></i> Cancelar' }, 'onshow': function () {

							lastX = window.scrollX;
							lastY = window.scrollY;
						},
						'onfocus': function () {
							window.scrollTo(lastX, lastY);
						}
					}).show();



			});

			$('.selectdistrito').select2({
				placeholder: 'Seleccione Distrito - Provincia',
				allowClear: true,
				language: {
					errorLoading: function () {
						return "La carga falló";
					},
					noResults: function () {
						return "No hay resultado";
					},
					searching: function () {

						return "Buscando..";
					}
				},
				ajax: {
					url: 'ajax/selectDistrito.php',
					dataType: 'json',
					delay: 250,
					processResults: function (data) {
						return {
							results: data
						};
					},
					cache: true
				}
			});



			$('.cbxtecnico').select2({
				placeholder: 'Seleccione',
				allowClear: true,
				language: {
					errorLoading: function () {
						return "La carga falló";
					},
					noResults: function () {
						return "No hay resultado";
					},
					searching: function () {

						return "Buscando..";
					}
				}
			});


			$('#datemask').inputmask('dd/mm/yyyy', { 'placeholder': 'dd/mm/yyyy' });
			$('#lblfvisita').datepicker({
				autoclose: true,
				language: 'es',
				firstDay: 1
			});
			$('#lblhvisita').timepicker({
				defaultTime: false,
				showInputs: true,
				minuteStep: 1

			});
			$('#lblfrellamada').datepicker({
				autoclose: true,
				language: 'es',
				firstDay: 1
			});
			$('#lblhrellamada').timepicker({
				defaultTime: false,
				showInputs: true,
				minuteStep: 1

			});


			$('#lblmesvisit').datepicker({

				autoclose: true,
				language: 'en',
				firstDay: 1, format: 'M-yyyy',
				viewMode: "years",
				minViewMode: "months",
				orientation: 'bottom'

			});
			$('#lblfecharecpciondoc').datepicker({
				autoclose: true,
				language: 'es',
				firstDay: 1
			});
			$('#lblfechafacturacion').datepicker({
				autoclose: true,
				language: 'es',
				firstDay: 1
			});
			//Money Euro
			$('[data-mask]').inputmask();
			//Date picker
			$('#fechainst').datepicker({
				autoclose: true,
				language: 'es',
				firstDay: 1
			});
			//Date picker
			$('#horainst').timepicker({
				defaultTime: false,
				showInputs: true,
				minuteStep: 1
			});

			$('#mesano').datepicker({
				autoclose: true,
				language: 'en',
				firstDay: 1, format: 'M-yyyy',
				viewMode: "years",
				minViewMode: "months"

			});

			$("#tipocontacto").change(function () {
				$("#tipocontacto option:selected").each(function () {
					var tipocontacto = $(this).val();
					cargarEstadoReferido(tipocontacto);
				});
			});

		});




		function cargarEstadoReferido(tipocontacto) {
			var lblestadoreferido = $('#lblestadoreferido');
			var arrayContactado = [
				{ id: "VisitaAceptada", valor: "Visita Aceptada" },
				{ id: "NoAceptaVisita", valor: "No Acepta Visita" },
				{ id: "DevolverLlamada", valor: "Devolver Llamada" },
				{ id: "ClienteError", valor: "Cliente Error" },
				{ id: "ZSCC", valor: "ZSCC" },
				{ id: "Provincia", valor: "Provincia" },
				{ id: "Inviable", valor: "Inviable" },
				{ id: "DatosErroneos", valor: "Datos Erroneos" },
				{ id: "ReferidoNoConoceCliente", valor: "Referido no conoce cliente" },				
				{ id: "NoDeseaContactacion", valor: "No Desea Contactacion" },
				{ id: "EliminarDatos", valor: "Eliminar Datos" }
			];
			var arrayNoContactado = [
				{ id: "NoContesta", valor: "No Contesta" },
				{ id: "TelefonoApagado", valor: "Telefono Apagado" },
				{ id: "NoContacto", valor: "No Contacto" },
				{ id: "TelefonoError", valor: "Telefono Error" }
			];


			lblestadoreferido.find('option').remove();
			lblestadoreferido.append('<option value="">Seleccione</option>');
			if (tipocontacto == "SI") {
				//$('#lblestadoreferido').val($('#hiddenestadoreferido').val()).trigger('change'); 
				r = arrayContactado;
			} else if (tipocontacto == "NO") {
				//$('#lblestadoreferido').val($('#hiddenestadoreferido').val()).trigger('change'); 
				r = arrayNoContactado;
			} else {
				r = null;
			}
			if (r != null) {
				$(r).each(function (i, v) { // indice, valor
					lblestadoreferido.append('<option value="' + v.id + '">' + v.valor + '</option>');
				});
				if (tipocontacto == "SI") {
					$('#lblestadoreferido').val($('#hiddenestadoreferido').val()).trigger('change');
				} else {
					$('#lblestadoreferido').val($('#hiddenestadoreferido').val()).trigger('change');
				}
			}
		}

		function validaForm() {
			// Campos de texto

			if ($("#frmEditarVenta #lblprimernombre").val() == "") {
				alertify.warning("Por favor completar Nombre");
				$("#frmEditarVenta #lblprimernombre").focus();
				return false;
			}

			if ($("#frmEditarVenta #lblprimerapellido").val() == "") {
				alertify.warning("Por favor completar Apellido");
				$("#frmEditarVenta #lblprimerapellido").focus();
				return false;
			}

			if ($("#frmEditarVenta #tipocontacto option:selected").val() == "") {
				alertify.warning("Por favor seleccionar Tipo Contacto");
				$("#frmEditarVenta #tipocontacto").focus();
				return false;
			}

			if ($("#frmEditarVenta #lblestadoreferido").val() == "") {
				alertify.warning("Por favor cambiar el estado de Referido");
				$("#frmEditarVenta #lblestadoreferido").focus();
				return false;
			}


			if ($("#frmEditarVenta #lblestadoreferido").val() == "VisitaAceptada") {

				if ($("#frmEditarVenta #lblcorreo").val() == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test($("#frmEditarVenta #lblcorreo").val())) {
					alertify.warning("Por favor ingresar correo válido");
					$("#frmEditarVenta #lblcorreo").focus();
					return false;
				}
				if ($("#frmEditarVenta #lbldireccion").val() == "") {
					alertify.warning("Por favor ingresar la Direccion del Cliente");
					$("#frmEditarVenta #lbldireccion").focus();
					return false;
				}
				if ($("#frmEditarVenta #lbldistrito").val() == "") {
					alertify.warning("Por favor ingresar Distrito correcto");

					$("#frmEditarVenta #lbldistrito").select2('open');
					return false;
				}

				if ($("#frmEditarVenta #lblfvisita").val() == "") {
					alertify.warning("Por favor ingresar  Fecha de Visita");
					$("#frmEditarVenta #lblfvisita").focus();
					return false;
				}
				if ($("#frmEditarVenta #lblhvisita").val() == "") {
					alertify.warning("Por favor ingresar  Hora de Visita");
					$("#frmEditarVenta #lblhvisita").focus();
					return false;
				}
				if ($("#frmEditarVenta #lblmesvisit").val() == "") {
					alertify.warning("Por favor ingresar  Mes de Visita");
					$("#frmEditarVenta #lblmesvisit").focus();
					return false;
				}

			}

			if ($("#frmEditarVenta #lblcomentariocallrp").val() == "") {
				alertify.warning("Por favor ingresar  Comentario CallRP");
				$("#frmEditarVenta #lblcomentariocallrp").focus();
				return false;
			}


			return true;
		}




		var calcDataTableHeight = function () {
			return $(window).height() * 65 / 100;
		};


		function filterFloat(evt, input) {
			// Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
			var key = window.Event ? evt.which : evt.keyCode;
			var chark = String.fromCharCode(key);
			var tempValue = input.value + chark;
			if (key >= 48 && key <= 57) {
				if (filter(tempValue) === false) {
					return false;
				} else {
					return true;
				}
			} else {
				if (key == 8 || key == 13 || key == 0) {
					return true;
				} else if (key == 46) {
					if (filter(tempValue) === false) {
						return false;
					} else {
						return true;
					}
				} else {
					return false;
				}
			}
		}

		function filter(__val__) {
			var preg = /^([0-9]+\.?[0-9]{0,2})$/;
			if (preg.test(__val__) === true) {
				return true;
			} else {
				return false;
			}

		}
		
            async function cargarDatos(IdReferido){
                
                datos ={
                        array:'array1',
                        IdReferido: IdReferido
                };
                
               await $.ajax({
                    type: 'POST',
                    url: './Controller/ControllerReferido.php',
                    data: {function: JSON.stringify(datos)},
                    dataType: 'json',
                    success: function (data) {
                        console.log(data);
                        
                        if(data.length>0){
                            generarHistoricoGestion(data);
                        }
                        
                        // if(data.resultado == 'exito'){
                            
                        //     const datosLead = data.lead;
                            
                        //     completarFormulario(datosLead);
                            
                        //     if(data.detalleLead != null){
                            
                        //         const datosdetalleLead = data.detalleLead;
                            
                        //         generarHistoricoGestion(datosdetalleLead);
                        //     }
                        // }
                        
                    }
                })
            }		
		
            function generarHistoricoGestion(datosdetalleRPTMK){
                
                
                limpiarHTML(contenedorTablaHistoricoGestion);

                datosdetalleRPTMK.forEach(elemento => {
                    
                    const {GestorRP,TipoContacto,EstadoReferido,ComentarioRP,NVuelta,FechaHoraREG,FechaHoraRellamada} = elemento;
                    
                    
                    const row = document.createElement('tr');
                    
                    //$('#vueltas').val(Vueltas);
                    
                    
                    let accion = '';
                    
  
                    
                    const IdVenta = $('#IdVenta').val();
                    
                    row.innerHTML = `
                                <td>${NVuelta}</td>
                                <td>${EstadoReferido}</td>
                                <td>${GestorRP}</td>
                                <td>${FechaHoraREG}</td>
                                <td>${TipoContacto}</td>
                                <td>${FechaHoraRellamada == null ? "" : FechaHoraRellamada}</td>
                                <td>${ComentarioRP}</td>
                                <td>${accion}</td>
                            `;
                   contenedorTablaHistoricoGestion.appendChild(row);
                   
                })
                
            }
            
            function limpiarHTML(cont) {
                //forma recomendada
                while (cont.firstChild) {
                    cont.removeChild(cont.firstChild);
                }
            }		


	</script>


</body>

</html>