<?php
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
    }

    if ($_SESSION['pzwbvisitas']==0) {
        header("location: ./denegado.php");
		exit;
    }
    date_default_timezone_set('America/Lima');
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date)
    {
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date)
    {
        return date('Y-m-d', strtotime($date));
    }
    
    include 'config/db.php';
    include 'config/conexion.php';
    include 'helper/helper_validacion.php';

    $fechadiahoy=date("M-Y");
    $fechadiahoy=htmlspecialchars($fechadiahoy);

    $dias=date("d");
    $mes=date("m");
    $ano=date("Y");
    
    $dias=htmlspecialchars($dias);
    $mes=htmlspecialchars($mes);
    $ano=htmlspecialchars($ano);


    try{

        $stmt = $con->prepare("SELECT DATE_FORMAT(vi.FechaVisita,'%e') FechaVisita, IFNULL(vi.visitas,0) visitas, IFNULL(ck.checkin,0) checkin FROM
        (SELECT v.FechaVisita, COUNT( v.IdVenta ) visitas FROM yifi58ge_dbVENTAS.tblventa v WHERE DATE_FORMAT( v.FechaVisita,  '%b-%Y')=? and v.FechaVisita <= CURDATE() and v.CCOriginal<>'511' and v.TipoVenta='RE' and (v.EstadoVisita =  'Asignada' OR v.EstadoVisita =  'Vendida' OR v.EstadoVisita =  'NoVendida') GROUP BY v.FechaVisita) vi
        LEFT JOIN (SELECT v.FechaVisita, COUNT( v.IdVenta ) checkin FROM yifi58ge_dbVENTAS.tblventa v WHERE DATE_FORMAT( v.FechaVisita,  '%b-%Y')=? AND v.FechaVisita <= CURDATE() and v.CCOriginal<>'511'  AND v.TipoVenta =  'RE' and v.checkin='SI'  GROUP BY v.FechaVisita) ck
        on vi.FechaVisita=ck.FechaVisita");
        
        $stmt->bind_param('ss', $fechadiahoy,$fechadiahoy);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($FechaVisita,$visitas,$checkin);
        $html=null;
        if($stmt->num_rows>0){
            while ($stmt->fetch()){
            $html.= "[".$FechaVisita.", ".$visitas.", ".$checkin."],";
    	    }
            
        }else{
             $html.="[0, 0, 0]";
        }

        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

    
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verisure | VeriSmart</title>

    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" />
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
            folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">  
    <!-- Date Picker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
    <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
    <!-- Alertifyjs -->
    <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <!--Hoja de estilos de la pagina dashboard visita *No usuar stilos en la misma pagina-->
    <link rel="stylesheet" href="css/dashboardvisita.css">
</head>
<body class="skin-red sidebar-mini sidebar-collapse">
    <div id="divLoading" style="display: none;">
        <div class="spinner">
            <div class="bounce1"></div>
            <div class="bounce2"></div>
            <div class="bounce3"></div>
        </div>
    </div>
    <div class="wrapper">
        <!-- Header -->
        <?php include 'admin/header.php'; ?>
        <!-- Left side column. contains the logo and sidebar -->
        <?php
            $inicio = "active";
            $dashboardvisitas= "active";
            include 'admin/main-sidebar.php';
        ?>
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <div style="font-size:180%;"> DASHBOARD&nbsp <span style="font-size:80%;color:#DAD8D4"> | &nbsp <span style="font-size:80%;color:#8D8A80">DELEGACIONES</span></span> </div>              
                <ol class="breadcrumb">
                    <li><a class="text-left"><font color="red">Día: <?php echo $dias."/".$mes."/".$ano;?></font></a></li>
                </ol>
            </section>
            <!-- Main content -->
            <section class="content">
                <div class="box box-danger">
                    <div class="box-header"> 
                        <i class="fa fa-bar-chart-o"></i> 
                        <h3 class="box-title">VISITAS - CHECK IN | <input type="text" style="font-size:100%;color:#444; background-color: #fff;border: 0;"  id="lblmesvisit" name="lblmesvisita"></h3>
                    </div>

                    <div class="divFundo" style="background-color:white;">
                        <table id="tblVentas">
                            <thead>
                                <tr style="height:2vw">
                                    <th style="width:20%;" class="text-center"><!--<img src="admin/dist/img/bandera.png" style="width:8vw;height:5vw; " />--></th>
                                    <th colspan="7" class="tblHeader text-center">VISITAS</th>
                                    <th style="width:0.5%;"></th>
                                    <th colspan="4" class="tblHeader text-center">ASIGNACION</th>
                                    <th style="width:0.5%;"></th>
                                </tr>

                                <tr style="height:2vw">
                                    <td style="width:5%;" ></td>
                                    <td style="width:5%;" class="tblSubHeader text-center">TOTAL VISITAS</td>
                                    <td style="width:5%;" class="tblSubHeader text-center">ASIGNADAS</td>
                                    <td style="width:5%;" class="tblSubHeader text-center">ANULADAS OP</td>
                                    <td style="width:5%;" class="tblSubHeader text-center">ANULADAS TEC</td>
                                    <td style="width:5%;" class="tblSubHeader text-center">ANULADAS CLI</td>
                                    <td style="width:5%;" class="tblSubHeader text-center">VENTA</td>
                                    <td style="width:5%;" class="tblSubHeader text-center">NO VENTA</td>
                                    <td ></td>
                                    <td style="width:5%;" class="tblSubHeader text-center">VISITAS ASIGNADAS</td>
                                    <td style="width:5%;" class="tblSubHeader text-center">VISITAS ASIGNADAS ACT</td>
                                    <td style="width:5%;" class="tblSubHeader text-center">CHECK IN</td>
                                    <td style="width:5%;" class="tblSubHeader text-center">% CHECK IN</td>
                                </tr>
                            </thead>
                            <tbody>       
                            </tbody>
                        </table>
                    </div>
                    <div class="espacio"></div>
                        <div class="box-body">
                            <div class="col-md-12">
                                <input type="hidden" id="idnumero" value="<?php echo $html;?>"/>
                                <?php echo $fechadiahoy;?>
                                <div id="chart_div" class="chart" style="width: 100%;min-height: 350px;"></div>
                            </div>  
                        </div>
                        <!-- /.box-body-->     
                </div>
                <!-- /. box -->
            </section>
            <?php include 'modalpassword.php';?>
        </div>
    </div>
    <!-- jQuery 3 -->
    <script src="admin/bower_components/jquery/dist/jquery.min.js"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <!-- Bootstrap 3.3.7 -->
    <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>

    <!-- datepicker -->
    <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
    <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>

    <!-- Bootstrap WYSIHTML5 -->
    <script src="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
    <!-- Slimscroll -->
    <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <!-- FastClick -->
    <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
    <!-- AdminLTE App -->
    <script src="admin/dist/js/adminlte.min.js"></script>
    
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    <!-- SCRIPT DASHBOARD -->
    <script type="text/javascript" src="js/dashboardVisita.js"></script>
    
    <script>
            google.charts.load('current', {'packages':['line']});
            google.charts.setOnLoadCallback(drawChart);
        
            function drawChart() {
              var data = new google.visualization.DataTable();
              data.addColumn('number', 'Dias');
              data.addColumn('number', 'Visitas');
              data.addColumn('number', 'Check-in');
        

            data.addRows([<?php echo htmlspecialchars($html);?>]);
        
              var options = {
                chart: {
                  title: '',
                  subtitle: ''
                },'legend':{
                position:'none'
                      }
              };
              var chart = new google.charts.Line(document.getElementById('chart_div'));
              chart.draw(data, google.charts.Line.convertOptions(options));
            }

 </script>
</body>
</html>