<?php
header("Content-Type: text/html;charset=utf-8");
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}

require '../config/db.php';
require '../config/conexion.php';
include '../helper/helper_validacion.php';

$fecharegistro = date("Y-m-d H:i:s");

$usuarioreg = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$usuarioreg = htmlspecialchars($usuarioreg);

//VALIDAR

$cboGestorTV = sanitizaCampo($_POST['cboGestorTV'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$cboGestorTV = htmlspecialchars($cboGestorTV);

$arraySelect = array();

$selectrows = sanitizaCampo($_POST['selectrows'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$selectrows = htmlspecialchars($selectrows);

$arraySelect = explode ( ',', $selectrows );

//LOG DE SEGURIDAD Y TRANSACCION
include 'log/insertLog.php';
include 'log/insertLogTeleventa.php';

$arrayActual = consultaGestorTV($selectrows);

if($cboGestorTV=='NSP'){
    //$resultadoventa=mysqli_query($con,"UPDATE tblventa v SET v.TCGestor=NULL WHERE v.IdVenta in (".$selectrows.")");    
}else{
    
        
    if(!empty($arraySelect)){

        foreach ($arraySelect as $key => $value) {

            updateTvAsignar($cboGestorTV,$value);    
                
        }
            
        die(json_encode(array('respuesta' => 'exito', 'id_registro' => '')));    
    }else{
        die(json_encode(array('respuesta' => 'error')));
    }

}


function updateTvAsignar($cboGestorTV,$selectrows){
    global $con;   
    
            $resultadoventa=$con->prepare("UPDATE tblventa v SET v.TCGestor=? WHERE v.IdVenta=? "); 
            $resultadoventa->bind_param('si',$cboGestorTV,$selectrows);
            $resultadoventa->execute();
            $resultadoventa->close();
    
}

