<?php
include('is_logged.php');
require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';

$idusuario = sanitizaCampo($_GET['idusuario'], 'sanitizeint|scapestring|htmlspecialchars', $con);

$arreglo = null;

$sql = "select v.MesVisita, v.FechaVisita, v.HoraVisita, v.TipoVenta 
from tblventa v INNER JOIN yifi58ge_dbUSUARIO.tblusuario u on u.IdUsuario=v.IdUsuario 
WHERE v.TipoVenta = 'RE' AND u.IdUsuario=? and v.FechaVisita>=CURDATE() 
UNION 
select p.MesVisitaRP, p.FechaVisitaRP, p.HoraVisitaRP, p.TipoVenta from tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u on u.IdUsuario=p.IdUsuario 
WHERE p.TipoVenta = 'RPTMK' AND u.IdUsuario=? and p.FechaVisitaRP>=CURDATE()";

    	try{       
            $stmt = $con->prepare($query);
            $stmt->bind_param('ii', $idusuario, $idusuario);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($MesVisita, $FechaVisita, $HoraVisita, $TipoVenta);
            
            if($stmt->num_rows > 0){
                while($stmt->fetch()){
                    $arreglo[]=array_map("utf8_encode",['MesVisita' => $MesVisita, 'FechaVisita' => $FechaVisita, 'HoraVisita' => $HoraVisita, 'TipoVenta' => $TipoVenta]); 
                }
            }
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }

echo json_encode($arreglo);
