<?php
include('is_logged.php');
require_once '../config/db.php';
require_once '../config/conexion.php';
    require_once '../helper/helper_validacion.php';
date_default_timezone_set('America/Lima');

$numero=sanitizaCampo($_GET['numero'], 'sanitizestring|scapestring|htmlspecialchars', $con);
$ccusuario=sanitizaCampo($_GET['ccusuario'], 'sanitizestring|scapestring|htmlspecialchars', $con);
$fechahoy=date("Y-m-d");

$arreglo=NULL;

$query="SELECT v.IdVenta,
v.EstadoVenta,
DATE_FORMAT(a.FechaInst, '%d/%m/%Y') FechaInst,
TIME_FORMAT(a.HoraInst,'%r') HoraInst,
v.TipoVenta,
v.CC DC,
CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
v.Segmento,
v.NProspecto,
v.NContrato,
c.NombApellido Cliente,
c.Direccion,
CONCAT(g.Distrito,'-',g.Provincia) Distrito,
v.CategoriaVenta,
v.PrecioKit,
v.TotalExtra,
v.ExtraAutorizado,
v.N590,
a.InstaladoX,
a.MatriculaTec,
a.Comentario,
CONCAT(v.IdVenta,'-',v.TipoVenta) as NuevoIdVenta
FROM yifi58ge_dbVENTAS.tblventa v INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=v.IdUsuario 
INNER JOIN yifi58ge_dbVENTAS.tblagenda a ON a.IdVenta=v.IdVenta 
INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
INNER JOIN yifi58ge_dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
WHERE a.FechaInst=? and ((a.MatriculaTec=? and (v.EstadoVenta='AgendadaDEL' or v.EstadoVenta='AgendadaTEC' or v.EstadoVenta='InstaladaTEC')) or (a.AsignadoTEC=? and v.EstadoVenta='AsignadaEvalTEC'))

ORDER BY a.FechaInst,a.HoraInst,v.CC asc";


    	try{       
            $stmt = $con->prepare($query);
            $stmt->bind_param('sss', $fechahoy, $numero, $numero);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($IdVenta, $EstadoVenta, $FechaInst, $HoraInst, $TipoVenta, $DC, $Comercial, $Segmento, $NProspecto, $NContrato, $Cliente, $Direccion, $Distrito, $CategoriaVenta, $PrecioKit, $TotalExtra, $ExtraAutorizado, $N590, $InstaladoX, $MatriculaTec, $Comentario, $NuevoIdVenta);
            
            if($stmt->num_rows > 0){
                while($stmt->fetch()){
                    $arreglo[] = array_map("utf8_encode",['IdVenta' => $IdVenta,
'EstadoVenta' => $EstadoVenta,
'FechaInst' => $FechaInst,
'HoraInst' => $HoraInst,
'TipoVenta' => $TipoVenta,
'DC' => $DC,
'Comercial' => $Comercial,
'Segmento' => $Segmento,
'NProspecto' => $NProspecto,
'NContrato' => $NContrato,
'Cliente' => $Cliente,
'Direccion' => $Direccion,
'Distrito' => $Distrito,
'CategoriaVenta' => $CategoriaVenta,
'PrecioKit' => $PrecioKit,
'TotalExtra' => $TotalExtra,
'ExtraAutorizado' => $ExtraAutorizado,
'N590' => $N590,
'InstaladoX' => $InstaladoX,
'MatriculaTec' => $MatriculaTec,
'Comentario' => $Comentario,
'NuevoIdVenta'=> $NuevoIdVenta
]); //array_map("utf8_encode",$data)  este codigo nos ayuda a muestrar caracteres diferentes
                    unset($data);     
                }
            }
            $stmt->close();
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        } 


   echo json_encode($arreglo);
?>