<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include '../helper/helper_validacion.php';


$numero = sanitizaCampo($_GET['numero'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$numero = htmlspecialchars($numero);

$ccusuario = sanitizaCampo($_GET['ccusuario'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$ccusuario = htmlspecialchars($ccusuario);

//CALLRP
$EstadoRP = sanitizaCampo($_GET['estadoRP'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$EstadoRP = htmlspecialchars($EstadoRP);


$htes=NULL;
$return_arr = array();
if($EstadoRP=="CallRP"){
    $htes="(p.EstadoProspecto='VisitaAceptada' or p.EstadoProspecto='NoContesta' or p.EstadoProspecto='DevolverLlamada') ";
    
    if($numero=='HA6658' || $numero=='BK8947' || $numero=='DF3030' || $numero=='F45995' || $numero=='C37264' || $numero=='CI8027' || $numero=='J20612' || $numero=='JS7240' || $numero=='J36506' || $numero=='JD9721' || $numero=='RT5569' || $numero=='OK0952' || $numero=='CB8533' || $numero=='AJ1066' || $numero=='MJ4599' || $numero=='AU4213' || $numero=='JW0662' || $numero=='Q07881' || $numero=='E38361' || $numero=='CS6467' || $numero=='L48073' || $numero=='MU4220' || $numero=='Q17162' || $numero=='JV6828' || $numero=='JI7865' || $numero=='IU9015'){
            
             $query=$con->prepare("SELECT  
                p.IdProspectoRP,
                (CASE 
                WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
                WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
                WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
                WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
                WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
                WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
                WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
                WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
                WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
                WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
                WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
                WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
                WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
                WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
                WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
                WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
                WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
                END) AS EstadoProspecto,
                p.TipoVenta,
                p.CC DC,
                u.IdUsuario,
                CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
                p.Segmento,
                p.NProspecto,
                c.NombApellido Cliente,
                c.Telefonouno,
                c.Telefonodos,
                c.Direccion,
                g.Distrito,
                p.CategoriaVenta,
                p.PrecioKit,
                p.TotalExtra,
                p.ExtraAutorizado,
                p.CheckinRP,
                CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
                p.FechaHoraREG as fechaHoraReg
            FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
            INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
            INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
            WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC=? AND p.CategoriaVenta!='Anulada') 
            AND ".$htes.
            "ORDER BY IdProspectoRP DESC"); 
            $query->bind_param('s', $ccusuario);    
            $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
                
    }else if($numero=='RF6290'){
        // RENZO BRAÑES 
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada' AND ".$htes." and (p.CC='150' or p.CC='156' or p.CC='159' or p.CC='251' or p.CC='252' or p.CC='130' or p.CC='151' or p.CC='157')) ");
            $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
            
    }
else if($numero=='CD4231'){
        
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada' AND ".$htes." and (p.CC='151' or p.CC='152')) ");
            $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
            
    }   
else if($numero=='JS7240'){
        
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada' AND ".$htes." and (p.CC='120' or p.CC='121' or p.CC='140' or p.CC='701' or p.CC='702' or p.CC='200' or p.CC='60')) ");
            $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
            
    }   
else if($numero=='DF3030'){
        
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada' AND ".$htes." and (p.CC='40' or p.CC='41' or p.CC='80' or p.CC='100' or p.CC='230')) ");
            $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
            
    }       
  else if($numero=='MF6331'){
    //MONICA SANCHEZ
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada' ".$htes." and ((p.CC='154' or p.CC='155' or p.CC='158' or p.CC='152')) ");
        
        $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
            
    }else if($numero=='JB4716'){
         $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada')
        ORDER BY IdProspectoRP DESC
        LIMIT 500");
        $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
            
    }else{
    
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE (p.Matricula=? or u.Manager=?) AND ".$htes." 
        ORDER BY p.IdProspectoRP DESC");
        $query->bind_param('ss',$numero,$numero);
        $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                    array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
    }
    
}else if($EstadoRP=="Terminado"){
    $htes="(p.EstadoProspecto='ClienteError' or p.EstadoProspecto='TelefonoError' or p.EstadoProspecto='ZSCC' or p.EstadoProspecto='Provincia' or p.EstadoProspecto='Inviable' or p.EstadoProspecto='Rechazada' or p.EstadoProspecto='AnuladaOP' or p.EstadoProspecto='AnuladaCLI' or p.EstadoProspecto='AnuladaTEC' or p.EstadoProspecto='NoAceptaVisita') ";

    if($numero=='HA6658' || $numero=='BK8947' || $numero=='DF3030' || $numero=='F45995' || $numero=='C37264' || $numero=='CI8027' || $numero=='J20612' || $numero=='JS7240' || $numero=='J36506' || $numero=='JD9721' || $numero=='RT5569' || $numero=='OK0952' || $numero=='CB8533' || $numero=='AJ1066' || $numero=='MJ4599' || $numero=='AU4213' || $numero=='JW0662' || $numero=='Q07881' || $numero=='E38361' || $numero=='CS6467' || $numero=='L48073' || $numero=='MU4230' || $numero=='Q17162' || $numero=='JV6828' || $numero=='JI7865' || $numero=='IU9015'){
        
             $query=$con->prepare("SELECT  
                p.IdProspectoRP,
                (CASE 
                WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
                WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
                WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
                WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
                WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
                WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
                WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
                WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
                WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
                WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
                WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
                WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
                WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
                WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
                WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
                WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
                WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
                END) AS EstadoProspecto,
                p.TipoVenta,
                p.CC DC,
                u.IdUsuario,
                CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
                p.Segmento,
                p.NProspecto,
                c.NombApellido Cliente,
                c.Telefonouno,
                c.Telefonodos,
                c.Direccion,
                g.Distrito,
                p.CategoriaVenta,
                p.PrecioKit,
                p.TotalExtra,
                p.ExtraAutorizado,
                p.CheckinRP,
                CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
                p.FechaHoraREG as fechaHoraReg
            FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
            INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
            INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
            WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC=? AND p.CategoriaVenta!='Anulada') 
            AND ".$htes.
            "ORDER BY IdProspectoRP DESC");   
            $query->bind_param('s', $ccusuario);  
            $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
                
    }else if($numero=='RF6290'){
        // RENZO BRAÑES 
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada' AND ".$htes." and (p.CC='100' or p.CC='150' or p.CC='159' or p.CC='157' or p.CC='152' or p.CC='251' or p.CC='252')) ");
            $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                     
                }
            }
            echo json_encode($return_arr);
            
    }else if($numero=='M76986'){
        //MANUEL SANCHEZ
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada' and ".$htes." and (p.CC='151' or p.CC='154' or p.CC='120' or p.CC='140' or p.CC='121' or p.CC='156' or p.CC='200' or p.CC='141' or p.CC='20' or p.CC='80')) AND ");
        
            $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
    
    
    }else if($numero=='MF6331'){
    //MONICA SANCHEZ
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada' ".$htes." and (p.CC='153' or p.CC='155' or p.CC='158' or p.CC='40' or p.CC='41' or p.CC='42' or p.CC='250' or p.CC='80')) ");
        
        $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
            
    }else if($numero=='JB4716'){
         $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada')
        ORDER BY IdProspectoRP DESC
        LIMIT 500");
        $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
            
    }else{
    
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE (p.Matricula=? or u.Manager=?) AND ".$htes." 
        ORDER BY p.IdProspectoRP DESC");
        $query->bind_param('ss',$numero,$numero);
        $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
    }    
    
}else if($EstadoRP=="VCPendiente" ){
    $htes="VisitaConcertada='SI'";
    
    if($numero=='CD4231' || $numero=='HA6658' || $numero=='BK8947' || $numero=='DF3030' || $numero=='F45995' || $numero=='C37264' || $numero=='CI8027' || $numero=='J20612' || $numero=='JS7240' || $numero=='J36506' || $numero=='JD9721' || $numero=='RT5569' || $numero=='OK0952' || $numero=='CB8533' || $numero=='AJ1066' || $numero=='MJ4599' || $numero=='AU4213' || $numero=='JW0662' || $numero=='Q07881' || $numero=='E38361' || $numero=='CS6467' || $numero=='L48073' || $numero=='MU4220' || $numero=='Q17162' || $numero=='JV6828' || $numero=='JI7865' || $numero=='IU9015'){
        
             $query=$con->prepare("SELECT  
                p.IdProspectoRP,
                (CASE 
                WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
                WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
                WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
                WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
                WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
                WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
                WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
                WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
                WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
                WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
                WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
                WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
                WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
                WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
                WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
                WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
                WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
                END) AS EstadoProspecto,
                p.TipoVenta,
                p.CC DC,
                u.IdUsuario,
                CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
                p.Segmento,
                p.NProspecto,
                c.NombApellido Cliente,
                c.Telefonouno,
                c.Telefonodos,
                c.Direccion,
                g.Distrito,
                p.CategoriaVenta,
                p.PrecioKit,
                p.TotalExtra,
                p.ExtraAutorizado,
                p.CheckinRP,
                CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
                p.FechaHoraREG as fechaHoraReg
            FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
            INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
            INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
            WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC=? AND p.CategoriaVenta!='Anulada') 
            AND ".$htes.
            "ORDER BY IdProspectoRP DESC");  
            $query->bind_param('s', $ccusuario);
            $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
                
    }else if($numero=='RF6290'){
        // RENZO BRAÑES 
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada' AND ".$htes." and (p.CC='100' or p.CC='150' or p.CC='159' or p.CC='157' or p.CC='152' or p.CC='251' or p.CC='252')) ");
            $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
            
    }else if($numero=='M76986'){
        //MANUEL SANCHEZ
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada' and ".$htes." and (p.CC='151' or p.CC='154' or p.CC='120' or p.CC='140' or p.CC='121' or p.CC='156' or p.CC='200' or p.CC='141' or p.CC='20' or p.CC='80')) AND ");
        
            $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
    
    }else if($numero=='MF6331'){
    //MONICA SANCHEZ
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada' ".$htes." and (p.CC='153' or p.CC='155' or p.CC='158' or p.CC='40' or p.CC='41' or p.CC='42' or p.CC='250' or p.CC='80')) ");
        
        $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
    }else if($numero=='JB4716'){
         $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada')
        ORDER BY IdProspectoRP DESC
        LIMIT 500");
        $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
            
    }else{
    
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE (p.Matricula=? or u.Manager=?) AND ".$htes." 
        ORDER BY p.IdProspectoRP DESC");
        $query->bind_param('ss',$numero,$numero);
        $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
    }    
    
}else{
    // $htes="p.EstadoProspecto='".$EstadoRP."'";
    //  $htes="p.EstadoProspecto=?";

    if($numero=='HA6658' || $numero=='BK8947' || $numero=='F45995' || $numero=='C37264' || $numero=='CI8027' || $numero=='J20612' || $numero=='J36506' || $numero=='JD9721' || $numero=='RT5569' || $numero=='OK0952' || $numero=='CB8533' || $numero=='AJ1066' || $numero=='MJ4599' || $numero=='AU4213' || $numero=='JW0662' || $numero=='Q07881' || $numero=='E38361' || $numero=='CS6467' || $numero=='L48073' || $numero=='MU4220' || $numero=='Q17162' || $numero=='JV6828' || $numero=='JI7865' || $numero=='IU9015'){
        
             $query=$con->prepare("SELECT  
                p.IdProspectoRP,
                (CASE 
                WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
                WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
                WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
                WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
                WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
                WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
                WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
                WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
                WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
                WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
                WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
                WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
                WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
                WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
                WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
                WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
                WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
                END) AS EstadoProspecto,
                p.TipoVenta,
                p.CC DC,
                u.IdUsuario,
                CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
                p.Segmento,
                p.NProspecto,
                c.NombApellido Cliente,
                c.Telefonouno,
                c.Telefonodos,
                c.Direccion,
                g.Distrito,
                p.CategoriaVenta,
                p.PrecioKit,
                p.TotalExtra,
                p.ExtraAutorizado,
                p.CheckinRP,
                CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
                p.FechaHoraREG as fechaHoraReg
            FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
            INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
            INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
            WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC=? AND p.CategoriaVenta!='Anulada') 
            AND p.EstadoProspecto=? ORDER BY IdProspectoRP DESC");     
            $query->bind_param('is', $ccusuario,$EstadoRP);
            $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
                
    }else if($numero=='RF6290'){
        // RENZO BRAÑES 
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada' AND p.EstadoProspecto=? and (p.CC='100' or p.CC='150' or p.CC='159' or p.CC='157' or p.CC='152' or p.CC='251' or p.CC='252')) ");
            $query->bind_param('s',$EstadoRP);
            $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
            
    }else if($numero=='MF6331'){
    //MONICA SANCHEZ
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada' AND p.EstadoProspecto=? and (p.CC='154' or p.CC='155' or p.CC='158' or p.CC='200')) ");
        $query->bind_param('s',$EstadoRP);
        $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
            
    }else if($numero=='JB4716'){
         $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada')
        ORDER BY IdProspectoRP DESC
        LIMIT 500");
        $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
            
    }else if($numero=='DF3030'){
    //CUNEO
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada' AND p.EstadoProspecto=? and (p.CC='40' or p.CC='41' or p.CC='80')) ");
        $query->bind_param('s',$EstadoRP);
        $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
            
    }      
    else if($numero=='CD4231'){
    //CUNEO
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada' AND p.EstadoProspecto=? and (p.CC='151' or p.CC='152' or p.CC='100')) ");
        $query->bind_param('s',$EstadoRP);
        $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
            
    }
    //JS7240
    else if($numero=='JS7240'){
   
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada' AND p.EstadoProspecto=? and (p.CC='120' or p.CC='121' or p.CC='140' or p.CC='701' or p.CC='702'  or p.CC='200' or p.CC='60')) ");
        $query->bind_param('s',$EstadoRP);
        $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
            
    }     
    
    //LUCIO
    else if($numero=='Q51570'){
   
        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE ((YEAR(p.FechaHoraREG)=2023 and MONTH(p.FechaHoraREG)=12) or YEAR(p.FechaHoraREG)=2024) and (p.CC<>511 and p.CategoriaVenta!='Anulada' AND p.EstadoProspecto=? and (p.CC='701' or p.CC='702')) ");
        $query->bind_param('s',$EstadoRP);
        $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
            
    }       
    
    else{

        $query=$con->prepare("SELECT  
        p.IdProspectoRP,
        (CASE 
        WHEN p.EstadoProspecto = 'ProspectoRP' then 'ProspectoRP'
        WHEN p.EstadoProspecto = 'VRPAsignada' then 'VRPAsignada'
        WHEN p.EstadoProspecto = 'Vendida' then 'Vendida'
        WHEN p.EstadoProspecto = 'NoVendida' then 'NoVendida'
        WHEN p.EstadoProspecto = 'VisitaAceptada' then 'CallRP'
        WHEN p.EstadoProspecto = 'NoContesta' then 'CallRP'
        WHEN p.EstadoProspecto = 'DevolverLlamada' then 'CallRP'
        WHEN p.EstadoProspecto = 'ClienteError' then 'Terminado'
        WHEN p.EstadoProspecto = 'TelefonoError' then 'Terminado'
        WHEN p.EstadoProspecto = 'ZSCC' then 'Terminado'
        WHEN p.EstadoProspecto = 'Provincia' then 'Terminado'
        WHEN p.EstadoProspecto = 'Inviable' then 'Terminado'
        WHEN p.EstadoProspecto = 'Rechazada' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaOP' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaCLI' then 'Terminado'
        WHEN p.EstadoProspecto = 'AnuladaTEC' then 'Terminado'
        WHEN p.EstadoProspecto = 'NoAceptaVisita' then 'Terminado'
        END) AS EstadoProspecto,
        p.TipoVenta,
        p.CC DC,
        u.IdUsuario,
        CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
        p.Segmento,
        p.NProspecto,
        c.NombApellido Cliente,
        c.Telefonouno,
        c.Telefonodos,
        c.Direccion,
        g.Distrito,
        p.CategoriaVenta,
        p.PrecioKit,
        p.TotalExtra,
        p.ExtraAutorizado,
        p.CheckinRP,
        CONCAT(p.FechaVisitaRP,' ',p.HoraVisitaRP) FechaHoraVisitaRP,
        p.FechaHoraREG as fechaHoraReg
        FROM yifi58ge_dbVENTAS.tblprospectorp p INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=p.IdUsuario
        INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
        INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE (p.Matricula=? or u.Manager=?) AND p.EstadoProspecto=?
        ORDER BY p.IdProspectoRP DESC");
        $query->bind_param('sss',$numero,$numero,$EstadoRP);
        $query->execute();
            $query->store_result();
            $query->bind_result(
                $IdProspectoRPRow,
                $EstadoProspectoRow,
                $TipoVentaRow,
                $DCRow,
                $IdUsuarioRow,
                $ComercialRow,
                $SegmentoRow,
                $NProspectoRow,
                $ClienteRow,
                $TelefonounoRow,
                $TelefonodosRow,
                $DireccionRow,
                $DistritoRow,
                $CategoriaVentaRow,
                $PrecioKitRow,
                $TotalExtraRow,
                $ExtraAutorizadoRow,
                $CheckinRPRow,
                $FechaHoraVisitaRPRow,
                $fechaHoraRegRow
                );

            if($query->num_rows > 0){
                while($query->fetch()){
        
                    $row_array['IdProspectoRP'] = $IdProspectoRPRow;
                    $row_array['EstadoProspecto'] = $EstadoProspectoRow;
                    $row_array['TipoVenta'] = $TipoVentaRow;
                    $row_array['DC'] = $DCRow;
                    $row_array['IdUsuario'] = $IdUsuarioRow;
                    $row_array['Comercial'] = $ComercialRow;
                    $row_array['Segmento'] = $SegmentoRow;
                    $row_array['NProspecto'] = $NProspectoRow;
                    $row_array['Cliente'] = $ClienteRow;
                    $row_array['Telefonouno'] = $TelefonounoRow;
                    $row_array['Telefonodos'] = $TelefonodosRow;
                    $row_array['Direccion'] = $DireccionRow;
                    $row_array['Distrito'] = $DistritoRow;
                    $row_array['CategoriaVenta'] = $CategoriaVentaRow;
                    $row_array['PrecioKit'] = $PrecioKitRow;
                    $row_array['TotalExtra'] = $TotalExtraRow;
                    $row_array['ExtraAutorizado'] = $ExtraAutorizadoRow;
                    $row_array['CheckinRP'] = $CheckinRPRow;
                    $row_array['FechaHoraVisitaRP'] = $FechaHoraVisitaRPRow;
                    $row_array['fechaHoraReg'] = $fechaHoraRegRow;
                    
                     array_push($return_arr,array_map("utf8_encode",$row_array));
                }
            }
            echo json_encode($return_arr);
    }
     
}


