<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include '../helper/helper_validacion.php';

$q=NULL;

if (isset($_GET['q'])) {
    $q=sanitizaCampo($_GET['q'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $q = htmlspecialchars($q);
}

$q = "%{$q}%";
$sql = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Gestor FROM yifi58ge_dbUSUARIO.tblusuario u  INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea
		WHERE a.IdArea in (57,58) and u.Estado='Activo' and u.Matricula LIKE ?"); 
$sql->bind_param('s',$q);
$sql->execute();
$sql->store_result();
$sql->bind_result(
    $MatriculaRow,
    $GestorRow
    );
    

$json = [];
while($sql->fetch()){
    $Matricula = $MatriculaRow;
    $Gestor = $GestorRow;    
    $json[] = array_map("utf8_encode",['id'=>$Matricula, 'text'=>$Matricula." - ".$Gestor]);
}

echo json_encode($json);

$sql->close();