<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include '../helper/helper_validacion.php';

$q=NULL;

if (isset($_GET['q'])) {
    $q=sanitizaCampo($_GET['q'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $q = htmlspecialchars($q);
}

$q = "%{$q}%";
$sql = $con->prepare("SELECT C.IDCargo, C.Cargo FROM dbMASTERUSUARIO.cargos C
		WHERE C.Cargo LIKE ?"); 
$sql->bind_param('s',$q);
$sql->execute();
$sql->store_result();
$sql->bind_result(
    $IDCargo,
    $Cargo
    );


$json = [];
while($sql->fetch()){
    $IDCargo = $IDCargo;
    $Cargo = $Cargo;
$json[] = array_map("utf8_encode",['id'=>$IDCargo, 'text'=>$Cargo]);

}


echo json_encode($json);

$sql->close();
