<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include '../helper/helper_validacion.php';

$q=NULL;

if (isset($_GET['q'])) {
    $q=sanitizaCampo($_GET['q'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $q = htmlspecialchars($q);
}

$q = "%{$q}%";

$sql = $con->prepare("SELECT g.IdGeografico,g.Distrito,g.Provincia FROM yifi58ge_dbVENTAS.tblgeografico g
		WHERE g.Estado='Activo' and g.TV='SI' and g.Distrito LIKE ?"); 
$sql->bind_param('s',$q);
$sql->execute();
$sql->store_result();
$sql->bind_result(
    $IdGeograficoRow,
    $DistritoRow,
    $ProvinciaRow
    );

$json = [];
while($sql->fetch()){
    $IdGeografico = $IdGeograficoRow;
    $Distrito = $DistritoRow;
    $Provincia = $ProvinciaRow;
$json[] = array_map("utf8_encode",['id'=>$IdGeografico, 'text'=>$Distrito." - ".$Provincia]);
}


echo json_encode($json);

$sql->close();
