<?php

    function consultaVisita($id){
        
        global $con;
        $arrayactual = null;

    try{
        $stmt = $con->prepare( "SELECT 
        v.IdUsuario, 
        v.IdCliente, 
        v.Matricula, 
        v.Comercial, 
        v.CC, 
        v.JefeVenta, 
        v.CategoriaVenta, 
        v.TipoVenta, 
        v.Segmento, 
        v.NProspecto, 
        v.EstadoVenta, 
        v.EstadoVisita, 
        v.FechaVisita, 
        v.HoraVisita, 
        v.FVencimientoVisita, 
        v.GestorMKT, 
        v.OrigenVisita, 
        v.ComentarioVisita, 
        v.CCOriginal, 
        v.Checkin, 
        v.MesVisita, 
        v.LeadID, 
        v.FObras, 
        v.FVisitaObras 
        FROM tblventa v
        WHERE v.IdVenta = ?");
        $stmt->bind_param('i', $id);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdUsuario,
                $IdCliente,
                $Matricula,
                $Comercial,
                $CC,
                $JefeVenta,
                $CategoriaVenta,
                $TipoVenta,
                $Segmento,
                $NProspecto,
                $EstadoVenta,
                $EstadoVisita,
                $FechaVisita,
                $HoraVisita,
                $FVencimientoVisita,
                $GestorMKT,
                $OrigenVisita,
                $ComentarioVisita,
                $CCOriginal,
                $Checkin,
                $MesVisita,
                $LeadID,
                $FObras,
                $FVisitaObras);
        while ($stmt->fetch()){
            $arrayactual = array(
                    'IdUsuario' => $Matricula,
                    'IdCliente' => $IdCliente,
                    'Matricula' => $Matricula,
                    'Comercial' => $Comercial,
                    'CC'=>$CC,
                    'JefeVenta'=>$JefeVenta,
                    'CategoriaVenta'=>$CategoriaVenta,
                    'TipoVenta'=>$TipoVenta,
                    'Segmento'=>$Segmento,
                    'NProspecto'=>$NProspecto,
                    'EstadoVenta'=>$EstadoVenta,
                    'EstadoVisita'=>$EstadoVisita,
                    'FechaVisita' =>$FechaVisita,
                    'HoraVisita'=>$HoraVisita,
                    'FVencimientoVisita'=>$FVencimientoVisita,
                    'GestorMKT'=>$GestorMKT,
                    'OrigenVisita'=>$OrigenVisita,
                    'ComentarioVisita'=>$ComentarioVisita,
                    'CCOriginal'=>$CCOriginal,
                    'Checkin'=>$Checkin,
                    'MesVisita'=>$MesVisita,
                    'LeadID'=>$LeadID,
                    'FObras'=>$FObras,
                    'FVisitaObras'=>$FVisitaObras
                );
	    }
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

        return $arrayactual;
    }
    
    function insertarLogVisita_old($idLogSeg, $actual){
        global $con;
        
        //VARIABLES POST
        global $idventa;
        global $idusuario;
        global $idcliente;
        global $matricula;
        global $nombcomercial;
        global $lblcctc;
        global $jefeventa;
        global $categoria;
        global $tipoventa;
        global $segmento;
        global $nprospecto;
        global $estadoventa;
        global $estvisita;
        global $fechagrabarfvisita;
        global $horagrabarvisita;
        global $fechagrabarvencimiento;
        global $asignadopor;
        global $origen;
        global $comentariovisita;
        global $dc;
        global $checkin;
        global $mesvisita;
        global $leadid;
        global $fobras;
        global $fechagrabarfvisitaObra;
        
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        
        $nuevo = array(
                    'IdUsuario' => $idusuario,
                    'IdCliente' => $idcliente,
                    'Matricula' => $matricula,
                    'Comercial' => $nombcomercial,
                    'CC'=> $lblcctc,
                    'JefeVenta'=> $jefeventa,
                    'CategoriaVenta'=> $categoria,
                    'TipoVenta'=> $tipoventa,
                    'Segmento'=> $segmento,
                    'NProspecto'=> $nprospecto,
                    'EstadoVenta'=> $estadoventa,
                    'EstadoVisita'=> $estvisita,
                    'FechaVisita' => $fechagrabarfvisita,
                    'HoraVisita'=> $horagrabarvisita,
                    'FVencimientoVisita'=> $fechagrabarvencimiento,
                    'GestorMKT'=> $asignadopor,
                    'OrigenVisita'=> $origen,
                    'ComentarioVisita'=> $comentariovisita,
                    'CCOriginal'=> $dc,
                    'Checkin'=> $checkin,
                    'MesVisita'=> $mesvisita,
                    'LeadID'=> $leadid,
                    'FObras'=> $fobras,
                    'FVisitaObras'=> $fechagrabarfvisitaObra
                );
                
        $RegActual = compararArray($actual, $nuevo);
        $RegActual = json_encode($RegActual);
        $RegNuevo = compararArray($nuevo, $actual);
        $RegNuevo = json_encode($RegNuevo);
        
        $tabla = "tblventa";
        $url = "".$_SERVER['REQUEST_URI']."=>IdVenta='".$idventa."'";
        
        StmtInsertarLog($id_usuario, $idLogSeg, $tabla, $url, $RegActual, $RegNuevo, $fechaactual);
        
        
    }
    
    function compararArray($array1, $array2){
        $resultado = array_diff_assoc($array1, $array2);
        
        return $resultado;
    }
    
    function consultaVisitaI(){
        
        $arrayactual = array(
                    'IdUsuario' => '',
                    'IdCliente' => '',
                    'Matricula' => '',
                    'Comercial' => '',
                    'CC'=> '',
                    'JefeVenta'=> '',
                    'CategoriaVenta'=> '',
                    'TipoVenta'=> '',
                    'Segmento'=> '',
                    'NProspecto'=> '',
                    'EstadoVenta'=> '',
                    'EstadoVisita'=> '',
                    'FechaVisita' => '',
                    'HoraVisita'=> '',
                    'FVencimientoVisita'=> '',
                    'GestorMKT'=> '',
                    'OrigenVisita'=> '',
                    'ComentarioVisita'=> '',
                    'GestorOrigen' => '',
                    'CCOriginal'=> '',
                    'MesVisita'=> '',
                    'LeadID'=> '',
                    'FObras'=> '',
                    'FVisitaObras'=> ''
                );
                
        return $arrayactual;
    }
    
    function insertarLogVisitaI($idLogSeg, $actual){
        global $con;
        
        global $idusuario;
        global $idCli;
        global $matricula;
        global $nombcomercial;
        global $dc;
        global $jefeventa;
        $categoria = 'VAsignada';
        global $tipoventa;
        global $segmento;
        global $nprospecto;
        global $estadoventa;
        global $fecharegistroventa;
        global $estadovisita;
        global $fechagrabarfvisita;
        global $horagrabarvisita;
        global $fechagrabarvencimiento;
        global $asignadopor;
        global $origen;
        global $comentariovisita;
        global $gestorbackoffice;
        global $dc;
        global $mesvisita;
        global $leadid;
        global $fobras;
        global $fechagrabarfvisitaobras;
        
        global $idVen;
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        
            $nuevo = array(
                'IdUsuario' => $idusuario,
                'IdCliente' => $idCli,
                'Matricula' => $matricula,
                'Comercial' => $nombcomercial,
                'CC'=> $dc,
                'JefeVenta'=> $jefeventa,
                'CategoriaVenta'=> $categoria,
                'TipoVenta'=> $tipoventa,
                'Segmento'=> $segmento,
                'NProspecto'=> $nprospecto,
                'EstadoVenta'=> $estadoventa,
                'EstadoVisita'=> $estadovisita,
                'FechaVisita' => $fechagrabarfvisita,
                'HoraVisita'=> $horagrabarvisita,
                'FVencimientoVisita'=> $fechagrabarvencimiento,
                'GestorMKT'=> $asignadopor,
                'OrigenVisita'=> $origen,
                'ComentarioVisita'=> $comentariovisita,
                'GestorOrigen' => $gestorbackoffice,
                'CCOriginal'=> $dc,
                'MesVisita'=> $mesvisita,
                'LeadID'=> $leadid,
                'FObras'=>$fobras,
                'FVisitaObras'=>$fechagrabarfvisitaobras
            );
                
        $RegActual = array();
        $RegActual = json_encode($RegActual);
        $RegNuevo = compararArray($nuevo, $actual);
        $RegNuevo = json_encode($RegNuevo);
        
        $tabla = "tblventa";
        $url = "".$_SERVER['REQUEST_URI']."=>IdVenta='".$idVen."'";
        
        StmtInsertarLog($id_usuario, $idLogSeg, $tabla, $url, $RegActual, $RegNuevo, $fechaactual);
    
        
    }
    
    
    //PRUEBA LOG ESTADOS
    
    function insertarLogVisita($idLogSeg, $actual){
        global $con;
        
        //VARIABLES POST
        global $idventa;
        global $idusuario;
        global $idcliente;
        global $matricula;
        global $nombcomercial;
        global $lblcctc;
        global $jefeventa;
        global $categoria;
        global $tipoventa;
        global $segmento;
        global $nprospecto;
        global $estadoventa;
        global $estvisita;
        global $fechagrabarfvisita;
        global $horagrabarvisita;
        global $fechagrabarvencimiento;
        global $asignadopor;
        global $origen;
        global $comentariovisita;
        global $dc;
        global $checkin;
        global $mesvisita;
        global $leadid;
        global $fobras;
        global $fechagrabarfvisitaObra;
        
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        
        $nuevo = array(
                    'IdUsuario' => $idusuario,
                    'IdCliente' => $idcliente,
                    'Matricula' => $matricula,
                    'Comercial' => $nombcomercial,
                    'CC'=> $lblcctc,
                    'JefeVenta'=> $jefeventa,
                    'CategoriaVenta'=> $categoria,
                    'TipoVenta'=> $tipoventa,
                    'Segmento'=> $segmento,
                    'NProspecto'=> $nprospecto,
                    'EstadoVenta'=> $estadoventa,
                    'EstadoVisita'=> $estvisita,
                    'FechaVisita' => $fechagrabarfvisita,
                    'HoraVisita'=> $horagrabarvisita,
                    'FVencimientoVisita'=> $fechagrabarvencimiento,
                    'GestorMKT'=> $asignadopor,
                    'OrigenVisita'=> $origen,
                    'ComentarioVisita'=> $comentariovisita,
                    'CCOriginal'=> $dc,
                    'Checkin'=> $checkin,
                    'MesVisita'=> $mesvisita,
                    'LeadID'=> $leadid,
                    'FObras'=> $fobras,
                    'FVisitaObras'=> $fechagrabarfvisitaObra
                );
                
        $RegActual = array_diff_assoc($actual, $nuevo);
        $RegActual = json_encode($RegActual);
        $RegNuevo = array_diff_assoc($nuevo, $actual);
        $RegNuevo = json_encode($RegNuevo);
        
        unset($actual);
        unset($nuevo);
        
        $tabla = "tblventa";
        $url = "".$_SERVER['REQUEST_URI']."=>IdVenta='".$idventa."'";
        $usuariolog=$_SESSION['usuariosesion'];
        $accion="Modificar";
        
        StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $idventa, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);
        $IdLogTrans = $con->insert_id;
        
        $RegNuevo=json_decode($RegNuevo, true);
        

        
        if(array_key_exists('EstadoVisita', $RegNuevo)){
            $indentificador=$idventa;
            $nombestadoLog="EstadoVisita";
            $estadolog=$RegNuevo['EstadoVisita'];
            $matriculalog=$matricula;
            $cclog=$lblcctc;
            $jefeventalog=$jefeventa;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$indentificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
                if(array_key_exists('EstadoVenta', $RegNuevo)){
            $indentificador=$idventa;
            $nombestadoLog="EstadoVenta";
            $estadolog=$RegNuevo['EstadoVenta'];
            $matriculalog=$matricula;
            $cclog=$lblcctc;
            $jefeventalog=$jefeventa;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$indentificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
        
        unset($RegActual);
        unset($RegNuevo);
        
    }
    
    function insertarLogVisitaI_PRUEBA($idLogSeg, $actual){
        global $con;
        
        global $idusuario;
        global $idCli;
        global $matricula;
        global $nombcomercial;
        global $dc;
        global $jefeventa;
        $categoria = 'VAsignada';
        global $tipoventa;
        global $segmento;
        global $nprospecto;
        global $estadoventa;
        global $fecharegistroventa;
        global $estadovisita;
        global $fechagrabarfvisita;
        global $horagrabarvisita;
        global $fechagrabarvencimiento;
        global $asignadopor;
        global $origen;
        global $comentariovisita;
        global $gestorbackoffice;
        global $dc;
        global $mesvisita;
        global $leadid;
        global $fobras;
        global $fechagrabarfvisitaObra;
        
        global $idVen;
        
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        
            $nuevo = array(
                'IdUsuario' => $idusuario,
                'IdCliente' => $idCli,
                'Matricula' => $matricula,
                'Comercial' => $nombcomercial,
                'CC'=> $dc,
                'JefeVenta'=> $jefeventa,
                'CategoriaVenta'=> $categoria,
                'TipoVenta'=> $tipoventa,
                'Segmento'=> $segmento,
                'NProspecto'=> $nprospecto,
                'EstadoVenta'=> $estadoventa,
                'EstadoVisita'=> $estadovisita,
                'FechaVisita' => $fechagrabarfvisita,
                'HoraVisita'=> $horagrabarvisita,
                'FVencimientoVisita'=> $fechagrabarvencimiento,
                'GestorMKT'=> $asignadopor,
                'OrigenVisita'=> $origen,
                'ComentarioVisita'=> $comentariovisita,
                'GestorOrigen' => $gestorbackoffice,
                'CCOriginal'=> $dc,
                'MesVisita'=> $mesvisita,
                'LeadID'=> $leadid,
                'FObras'=> $fobras,
                'FVisitaObras'=> $fechagrabarfvisitaObra
            );
                
        $RegActual = array();
        $RegActual = json_encode($RegActual);
        $RegNuevo = array_diff_assoc($nuevo, $actual);
        $RegNuevo = json_encode($RegNuevo);
        
        unset($nuevo);
        unset($actual);
        
        $tabla = "tblventa";
        $url = "".$_SERVER['REQUEST_URI']."=>IdVenta='".$idVen."'";
        $usuariolog=$_SESSION['usuariosesion'];
        $accion = "Registrar";
        
        //StmtInsertarLog($id_usuario, $idLogSeg, $tabla, $url, $RegActual, $RegNuevo, $fechaactual);
        StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $idVen, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);
        $IdLogTrans = $con->insert_id;
        
        $RegNuevo=json_decode($RegNuevo, true);
        
        if(array_key_exists('EstadoVisita', $RegNuevo)){
            $indentificador=$idVen;
            $nombestadoLog="EstadoVisita";
            $estadolog=$RegNuevo['EstadoVisita'];
            $matriculalog=$matricula;
            $cclog=$dc;
            $jefeventalog=$jefeventa;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$indentificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
        
        if(array_key_exists('EstadoVenta', $RegNuevo)){
            $indentificador=$idVen;
            $nombestadoLog="EstadoVenta";
            $estadolog=$RegNuevo['EstadoVenta'];
            $matriculalog=$matricula;
            $cclog=$dc;
            $jefeventalog=$jefeventa;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$indentificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
        
        
        unset($RegActual);
        unset($RegNuevo);
    }
    
    
    //Visitas Externas
    
    function consultaVisitaExternasI($id){
        
        global $con;
        $arrayactual = null;

    try{
        $stmt = $con->prepare( "SELECT 
        v.IdCliente, 
        v.CategoriaVenta, 
        v.TipoVenta, 
        v.EstadoVenta, 
        v.EstadoVisita, 
        v.FechaVisita, 
        v.HoraVisita, 
        v.FVencimientoVisita, 
        v.GestorMKT, 
        v.OrigenVisita, 
        v.ComentarioVisita, 
        v.MesVisita, 
        v.FObras, 
        v.FVisitaObras 
        FROM tblventa v
        WHERE v.IdVenta = ?");
        $stmt->bind_param('i', $id);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdCliente,
            $CategoriaVenta,
            $TipoVenta,
            $EstadoVenta,
            $EstadoVisita,
            $FechaVisita,
            $HoraVisita,
            $FVencimientoVisita,
            $GestorMKT,
            $OrigenVisita,
            $ComentarioVisita,
            $MesVisita,
            $FObras,
            $FVisitaObras);
        while ($stmt->fetch()){
            $arrayactual = array(
                    'IdCliente' => $IdCliente,
                    'CategoriaVenta'=>$CategoriaVenta,
                    'TipoVenta'=>$TipoVenta,
                    'EstadoVenta'=>$EstadoVenta,
                    'EstadoVisita'=>$EstadoVisita,
                    'FechaVisita' =>$FechaVisita,
                    'HoraVisita'=>$HoraVisita,
                    'FVencimientoVisita'=>$FVencimientoVisita,
                    'GestorMKT'=>$GestorMKT,
                    'OrigenVisita'=>$OrigenVisita,
                    'ComentarioVisita'=>$ComentarioVisita,
                    'MesVisita'=>$MesVisita,
                    'FObras'=>$FObras,
                    'FVisitaObras'=>$FVisitaObras
                );
	    }
	    
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }	    

        return $arrayactual;
    }
    
    function insertarLogVisitaExternasI($idLogSeg, $actual){
        global $con;
        
        global $idusuario;
        global $idCli;
        global $matricula;
        global $nombcomercial;
        global $dc;
        global $jefeventa;
        global $categoria;
        global $tipoventa;
        global $segmento;
        global $nprospecto;
        global $estadoventa;
        global $fecharegistroventa;
        global $estadovisita;
        global $fechagrabarfvisita;
        global $horagrabarvisita;
        global $fechagrabarvencimiento;
        global $asignadopor;
        global $origen;
        global $comentariovisita;
        global $gestorbackoffice;
        global $dc;
        global $mesvisita;
        global $leadid;
        global $fobras;
        global $fechagrabarfvisitaObra;
        
        global $idVen;
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        
            $nuevo = array(
                'IdUsuario' => $idusuario,
                'IdCliente' => $idCli,
                'Matricula' => $matricula,
                'Comercial' => $nombcomercial,
                'CC'=> $dc,
                'JefeVenta'=> $jefeventa,
                'CategoriaVenta'=> $categoria,
                'TipoVenta'=> $tipoventa,
                'Segmento'=> $segmento,
                'NProspecto'=> $nprospecto,
                'EstadoVenta'=> $estadoventa,
                'EstadoVisita'=> $estadovisita,
                'FechaVisita' => $fechagrabarfvisita,
                'HoraVisita'=> $horagrabarvisita,
                'FVencimientoVisita'=> $fechagrabarvencimiento,
                'GestorMKT'=> $asignadopor,
                'OrigenVisita'=> $origen,
                'ComentarioVisita'=> $comentariovisita,
                'GestorOrigen' => $gestorbackoffice,
                'CCOriginal'=> $dc,
                'MesVisita'=> $mesvisita,
                'LeadID'=> $leadid,
                'FObras'=> $fobras,
                'FVisitaObras'=> $fechagrabarfvisitaObra
            );
                
        $RegActual = array();
        $RegActual = json_encode($RegActual);
        $RegNuevo = array_diff_assoc($nuevo, $actual);
        $RegNuevo = json_encode($RegNuevo);
        
        unset($nuevo);
        unset($actual);
        
        $tabla = "tblventa";
        $url = "".$_SERVER['REQUEST_URI']."=>IdVenta='".$idVen."'";
        $usuariolog=$_SESSION['usuariosesion'];
        $accion = "Registrar";
        
        //StmtInsertarLog($id_usuario, $idLogSeg, $tabla, $url, $RegActual, $RegNuevo, $fechaactual);
        StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $idVen, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);
        $IdLogTrans = $con->insert_id;
        
        $RegNuevo=json_decode($RegNuevo, true);
        
        if(array_key_exists('EstadoVisita', $RegNuevo)){
            $indentificador=$idVen;
            $nombestadoLog="EstadoVisita";
            $estadolog=$RegNuevo['EstadoVisita'];
            $matriculalog=$matricula;
            $cclog=$dc;
            $jefeventalog=$jefeventa;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$indentificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
        
        if(array_key_exists('EstadoVenta', $RegNuevo)){
            $indentificador=$idVen;
            $nombestadoLog="EstadoVenta";
            $estadolog=$RegNuevo['EstadoVenta'];
            $matriculalog=$matricula;
            $cclog=$dc;
            $jefeventalog=$jefeventa;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$indentificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
        
        
        unset($RegActual);
        unset($RegNuevo);
    }
    
    //NUEVAS FUNCION DE INGRESAR VISITA DESDE CALL CENTER
    
    function arregloVisita_CC(){
        $arrayactual = array(
                    'IdUsuario' => '',
                    'IdCliente' => '',
                    'TipoVenta'=> '',
                    'Segmento'=> '',
                    'NProspecto'=> '',
                    'EstadoVenta'=> '',
                    'EstadoVisita'=> '',
                    'FechaVisita' => '',
                    'HoraVisita'=> '',
                    'FVencimientoVisita'=> '',
                    'GestorMKT'=> '',
                    'OrigenVisita'=> '',
                    'ComentarioVisita'=> '',
                    'IdLead' => '',
                    'GrupoACD' => '',
                    'Accion' => '',
                    'PerfilScoring' => '',
                    'IdConsultaScoring' => '',
                    'DetalleObservaciones' => '',
                    'LeadID'=> '',
                    'FObras'=> '',
                    'FVisitaObras'=> ''
                );
                
        return $arrayactual;
    }
    
    function insertarLogVisita_CC($idLogSeg, $identificador, $nuevo){
        global $con;
        
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        
        $RegActual=array();
        $RegNuevo = $nuevo;
        
        $RegActual = json_encode($RegActual);
        $RegNuevo = json_encode($RegNuevo);
        
        unset($nuevo);
        
        $tabla = "tblventa";
        $url = "".$_SERVER['REQUEST_URI']."=>IdVenta='".$identificador."'";
        $usuariolog=$_SESSION['usuariosesion'];
        $accion = "Registrar";
        StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $identificador, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);
        $IdLogTrans = $con->insert_id;
        
        $RegNuevo=json_decode($RegNuevo, true);
        
        /*
        if(array_key_exists('EstadoVisita', $RegNuevo)){
            $indentificador=$identificador;
            $nombestadoLog="EstadoVisita";
            $estadolog=$RegNuevo['EstadoVisita'];
            $matriculalog=$matricula;
            $cclog=$dc;
            $jefeventalog=$jefeventa;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$indentificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
        
        if(array_key_exists('EstadoVenta', $RegNuevo)){
            $indentificador=$identificador;
            $nombestadoLog="EstadoVenta";
            $estadolog=$RegNuevo['EstadoVenta'];
            $matriculalog=$matricula;
            $cclog=$dc;
            $jefeventalog=$jefeventa;
        
            StmtInsertarLogStatus($IdLogTrans,$tabla,$indentificador,$nombestadoLog,$estadolog,$usuariolog,$fechaactual,$matriculalog,$cclog,$jefeventalog);
        
        }
*/
    }
    
    function consultaVisita_AsignarVisita($id){
        
        global $con;
        $arrayactual = null;


    try{
        $stmt = $con->prepare( "SELECT 
                            v.IdUsuario, 
                            v.Matricula, 
                            v.Comercial, 
                            v.CC, 
                            v.JefeVenta, 
                            v.CategoriaVenta, 
                            v.TipoVenta, 
                            v.Segmento, 
                            v.NProspecto, 
                            v.EstadoVenta, 
                            v.EstadoVisita, 
                            v.FechaVisita, 
                            v.HoraVisita, 
                            v.FVencimientoVisita, 
                            v.GestorMKT, 
                            v.OrigenVisita, 
                            v.ComentarioVisita, 
                            v.CCOriginal, 
                            v.MesVisita, 
                            v.LeadID, 
                            v.FObras, 
                            v.FVisitaObras,
                            v.GestorOrigen,
                            v.IdConsultaScoring,
                            v.PerfilScoring,
                            v.Accion,
                            v.MotivoDifDelegacion,
                            v.CalificacionVisita,
                            v.FechaHoraAsignacion
                        FROM tblventa v
                        WHERE v.IdVenta = ?");
        $stmt->bind_param('i', $id);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdUsuario, 
                $Matricula, 
                $Comercial, 
                $CC, 
                $JefeVenta, 
                $CategoriaVenta, 
                $TipoVenta, 
                $Segmento, 
                $NProspecto, 
                $EstadoVenta, 
                $EstadoVisita, 
                $FechaVisita, 
                $HoraVisita, 
                $FVencimientoVisita, 
                $GestorMKT, 
                $OrigenVisita, 
                $ComentarioVisita, 
                $CCOriginal, 
                $MesVisita, 
                $LeadID, 
                $FObras, 
                $FVisitaObras,
                $GestorOrigen,
                $IdConsultaScoring,
                $PerfilScoring,
                $Accion,
                $MotivoDifDelegacion,
                $CalificacionVisita,
                $FechaHoraAsignacion
                );
        while ($stmt->fetch()){
            $arrayactual = array(
                    'IdUsuario' => $IdUsuario,
                    'Matricula' => $Matricula,
                    'Comercial' => $Comercial,
                    'CC'=>$CC,
                    'JefeVenta'=>$JefeVenta,
                    'CategoriaVenta'=>$CategoriaVenta,
                    'TipoVenta'=>$TipoVenta,
                    'Segmento'=>$Segmento,
                    'NProspecto'=>$NProspecto,
                    'EstadoVenta'=>$EstadoVenta,
                    'EstadoVisita'=>$EstadoVisita,
                    'FechaVisita' =>$FechaVisita,
                    'HoraVisita'=>$HoraVisita,
                    'FVencimientoVisita'=>$FVencimientoVisita,
                    'GestorMKT'=>$GestorMKT,
                    'OrigenVisita'=>$OrigenVisita,
                    'MesVisita'=>$MesVisita,
                    'LeadID'=>$LeadID,
                    'FObras'=>$FObras,
                    'FVisitaObras'=>$FVisitaObras,
                    'GestorOrigen'=>$GestorOrigen,
                    'ComentarioVisita'=>$ComentarioVisita,
                    'CCOriginal'=>$CCOriginal,
                    'IdConsultaScoring'=>$IdConsultaScoring,
                    'PerfilScoring'=>$PerfilScoring,
                    'Accion'=>$Accion,
                    'MotivoDifDelegacion'=>$MotivoDifDelegacion,
                    'CalificacionVisita'=>$CalificacionVisita,
                    'FechaHoraAsignacion'=>$FechaHoraAsignacion
                );
	    }
	    
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

        return $arrayactual;
    }
    
    function insertLogTransacVisita_AsignarVisita($idLogSeg, $actual){
        global $con;
        
        $id_usuario = $_SESSION['id_usuario'];
        $fechaactual = date("Y-m-d H:i:s");
        
        global $MatriculaUsuario; //GESTOR ORIGEN
        global $idusuario, $matricula, $nombcomercial, $lblcctc, $jefeventa, $categoria, $tipoventa, $segmento, $nprospecto, $estadoventa, $estvisita;
        global $fechagrabarfvisita, $horagrabarvisita, $fechagrabarvencimiento, $asignadopor, $origen, $comentariovisita, $dc, $mesvisita, $leadid, $fobras, $fechagrabarfvisitaObra;
        global $idventa;
        global $IdConsultaScoring, $PerfilScoring, $Accion, $txtMotivoDelegacion;
        global $lblcalificarGestion;
        global $fecharegistro;
        
        $nuevo = array(
                    'IdUsuario' => $id_usuario,
                    'Matricula' => $matricula,
                    'Comercial' => $nombcomercial,
                    'CC'=> $dc,
                    'JefeVenta'=> $jefeventa,
                    'CategoriaVenta'=> $categoria,
                    'TipoVenta'=> $tipoventa,
                    'Segmento'=> $segmento,
                    'NProspecto'=> $nprospecto,
                    'EstadoVenta'=> $estadoventa,
                    'EstadoVisita'=> $estvisita,
                    'FechaVisita' => $fechagrabarfvisita,
                    'HoraVisita'=> $horagrabarvisita,
                    'FVencimientoVisita'=> $fechagrabarvencimiento,
                    'GestorMKT'=> $asignadopor,
                    'OrigenVisita'=> $origen,
                    'MesVisita'=> $mesvisita,
                    'LeadID'=> $leadid,
                    'FObras'=> $fobras,
                    'FVisitaObras'=> $fechagrabarfvisitaObra,
                    'GestorOrigen'=> $MatriculaUsuario,
                    'ComentarioVisita'=> $comentariovisita,
                    'CCOriginal'=> $dc,
                    'IdConsultaScoring'=> $IdConsultaScoring,
                    'PerfilScoring'=> $PerfilScoring,
                    'Accion'=> $Accion,
                    'MotivoDifDelegacion'=> $txtMotivoDelegacion,
                    'CalificacionVisita'=> $lblcalificarGestion,
                    'FechaHoraAsignacion'=> $fecharegistro
                );
                
        $RegActual = array_diff_assoc($actual, $nuevo);
        $RegNuevo = array_diff_assoc($nuevo, $actual);
        
        if(count($RegNuevo) == 0){
            return;
        }
        
        $RegActual = json_encode($RegActual);
        $RegNuevo = json_encode($RegNuevo);
        
        unset($actual);
        unset($nuevo);
        
        $tabla = "tblventa";
        $usuariolog=$_SESSION['usuariosesion'];
        $accion="Modificar";
        
        $url = "".$_SERVER['REQUEST_URI']."=>IdVenta='".$idventa."'";
        $identificador=$idventa;
        
        StmtInsertarLogTransac($id_usuario, $usuariolog, $idLogSeg, $url, $identificador, $accion, $tabla, $RegActual, $RegNuevo, $fechaactual);
        
        unset($actual);
        unset($nuevo);
    }
    
    