<?php

function actualizarCliente($idcliente){
    global $con;

    global $nombcliente, $correo, $direccion, $distrito, $telefonouno, $telefonodos, $segmento, $ncontrato;

    try{
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblcliente SET IdGeografico = ?, NombApellido = ?, Correo = ?, Direccion = ?, Telefonouno = ?, Telefonodos=?, Segmento=?, NCliente=? WHERE IdCliente = ?");
        $stmt->bind_param("isssssssi", $distrito, $nombcliente, $correo, $direccion, $telefonouno, $telefonodos, $segmento, $ncontrato, $idcliente);
        $stmt->execute();

        $rows = $stmt->affected_rows;

        if ($rows > 0) {
            $respuesta = array(
                'respuesta' => 'exito',
                'id_actualizado' => $idcliente,
                'tipo' => 'cliente'
            );
        } else {
            $respuesta = array(
                'respuesta' => 'nada',
                'tipo' => 'cliente'
            );
        }
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error',
            'mensaje' => $e->getMessage(),
            'tipo' => 'cliente'
        );
    }

    return $respuesta;
}


//Funcion nueva Cliente
function actualizarClienteDoc($idcliente){
    global $con;

    global $nombcliente, $correo, $direccion, $distrito, $telefonouno, $telefonodos, $segmento, $ncontrato,$IdDocTV,$Referencia;

    try{
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblcliente SET IdGeografico = ?, NombApellido = ?, Correo = ?, Direccion = ?, Telefonouno = ?, Telefonodos=?, Segmento=?, NCliente=?, IdDocTV=?, Referencia=? WHERE IdCliente = ?");
        $stmt->bind_param("isssssssisi", $distrito, $nombcliente, $correo, $direccion, $telefonouno, $telefonodos, $segmento, $ncontrato,$IdDocTV, $Referencia, $idcliente);
        $stmt->execute();

        $rows = $stmt->affected_rows;

        if ($rows > 0) {
            $respuesta = array(
                'respuesta' => 'exito',
                'id_actualizado' => $idcliente,
                'tipo' => 'cliente'
            );
        } else {
            $respuesta = array(
                'respuesta' => 'nada',
                'tipo' => 'cliente'
            );
        }
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error',
            'mensaje' => $e->getMessage(),
            'tipo' => 'cliente'
        );
    }

    return $respuesta;
}




?>
