<?php
include('is_logged.php');
require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';

if (isset($_GET['URL'])) {
    $buscarURL=sanitizaCampo($_GET['URL'],'sanitizestring|scapestring|htmlspecialchars',$con);
}else{
    $buscarURL="NSP";
}


    try{
        $stmt = $con->prepare( "SELECT m.IdMdp,m.URL,m.FechaHoraREG,m.FechaVencimiento,m.EstadoURL, m.CodigoMDP,m.CantidadTransaccion,m.HoraVencimiento,m.GestorOrigen, COUNT(t.IdMdp) CantTransaccion,
(CASE WHEN m.CantidadTransaccion-COUNT(t.IdMdp)>2 THEN 'Minimo' 
 WHEN COUNT(t.IdMdp)>=m.CantidadTransaccion THEN 'Maximo'
 WHEN m.CantidadTransaccion-COUNT(t.IdMdp)<=2 THEN 'Medio'
 ELSE 'Vacio' END) InformacionTransaccion
FROM yifi58ge_dbVENTAS.tblmdp m LEFT JOIN yifi58ge_dbVENTAS.tbltransaccion t on t.IdMdp=m.IdMdp  
WHERE m.CodigoMDP = ?
GROUP BY m.IdMdp ORDER BY m.EstadoURL asc");
        $stmt->bind_param('s', $buscarURL);
        $stmt->execute();
        $stmt->store_result();
        if($stmt->num_rows>0){
             echo 1;
        }else{
            echo '<div class="callout bg-gray">
                <span class="pull-left">
                    <img src="admin/dist/img/noresults-img.png" style="width: 70%">
                </span>
                    <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
               <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado con la URL seleccionada <?php echo $buscarmarca;?>.</strong><br>
                <p>&nbsp;</p>
                <br>
    </div>';
        }

	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
