<?php
include('is_logged.php');
require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';

if (isset($_POST['idcli']) && $_POST['idcli']<>'') {

    $idcliente = sanitizaCampo($_POST['idcli'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $idcliente = htmlspecialchars($idcliente);

$arreglo = null;
$sql=$con->prepare("SELECT c.IdCliente,c.NCliente,c.NombApellido,c.Direccion,c.Telefonouno,c.Telefonodos,g.Distrito,g.Provincia,c.Correo,c.Correodos,c.IdGeografico,'ClienteRegistrado' FROM yifi58ge_dbVENTAS.tblcliente c INNER JOIN yifi58ge_dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico WHERE c.NCliente=?");
$sql->bind_param('i',$idcliente);
$sql->execute();
$sql->store_result();
$sql->bind_result(
    $IdClienteRow,
    $NClienteRow,
    $NombApellidoRow,
    $DireccionRow,
    $TelefonounoRow,
    $TelefonodosRow,
    $DistritoRow,
    $ProvinciaRow,
    $CorreoRow,
    $CorreodosRow,
    $IdGeograficoRow,
    $condicion
    );
$row_cnt = $sql->num_rows;
if($row_cnt==0){
$resul=array(
    'condicion' => 'RegistrarCliente'
    );

echo json_encode($resul);    
    
}else{
    $return_arr = array();
    if($row_cnt > 0){
            while($sql->fetch()){
    
                // array_push($return_arr,array_map("utf8_encode",$row_array));
                $return_arr= array_map("utf8_encode",[
                                        			'IdCliente' => $IdClienteRow,
                                                    'NCliente' => $NClienteRow,
                                                    'NombApellido' => $NombApellidoRow,
                                                    'Direccion' => $DireccionRow,
                                                    'Telefonouno' => $TelefonounoRow,
                                                    'Telefonodos' => $TelefonodosRow,
                                                    'Distrito' => $DistritoRow,
                                                    'Provincia' => $ProvinciaRow,
                                                    'Correo' => $CorreoRow,
                                                    'Correodos' => $CorreodosRow,
                                                    'IdGeografico' => $IdGeograficoRow,
                                                    'condicion' => $condicion
                    ]);
            }
    }
    echo json_encode($return_arr);

}



$sql->close();

}

