<?php
include('is_logged.php');
require_once '../config/db.php';
require_once '../config/conexion.php';

$json = file_get_contents('php://input');
$data = json_decode($json);

if(isset($data->idprospectorp)){
    $idprospectorp= htmlspecialchars($data->idprospectorp);
    $tipoventa= htmlspecialchars($data->tipoventa);

        try {
          $stmt = $con->prepare("SELECT COUNT(ref.IdProspectoRP) CantidadReferido FROM yifi58ge_dbREFERIDO.tblreferido ref INNER JOIN yifi58ge_dbREFERIDO.tblreferido_detalle detref on ref.Id= detref.Referido_ID WHERE ref.IdProspectoRP=? and ref.TipoVenta=?");
          $stmt->bind_param('is', $idprospectorp, $tipoventa);
          $stmt->execute();
          $stmt->bind_result($CantidadReferido);
          $stmt->fetch();
          
          if($CantidadReferido>0){
            $cantidadreferido=$CantidadReferido;
            echo json_encode(array('resultado'=>'Actualizado','mensaje'=>'Actualizado', 'cantidad'=>$cantidadreferido));  
          }else{
            $cantidadreferido=0;
            echo json_encode(array('resultado'=>'Actualizado','mensaje'=>'Actualizado, sin referidos', 'cantidad'=>$cantidadreferido));
          }
          
          $stmt->close();
          
        } catch (\Exception $e) {
          echo json_encode(array('resultado'=>'Error','mensaje'=>'No se enviaron los parametros', 'cantidad'=>0));
        }
    
} else {
    echo json_encode(array('resultado'=>'Error','mensaje'=>'No se enviaron los parametros', 'cantidad'=>0));
}


