<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';


//LOG
require_once 'log/insertLog.php';
//LIBRERIA DE EXPORTACION
require_once 'libreria/Spout/Autoloader/autoload.php';

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

$fileName = 'VisitasRE.csv';

$writer = WriterEntityFactory::createCSVWriter();

$writer->openToBrowser($fileName);

$head = array('IdVenta','IdUsuario',
'IdCliente',
'Matricula',
'Comercial',
'CC',
'JefeVenta',
'CategoriaVenta',
'TipoVenta',
'Segmento',
'NProspecto',
'NContrato',
'PrecioKit',
'TotalExtra',
'IngresoKIT',
'IngresoExtras',
'IngresoTotal',
'EstadoVenta',
'ExtraAutorizado',
'MesesAutorizado',
'N590',
'FormaPago',
'PAI',
'ResumenVenta',
'FechaHoraREG',
'EstadoVisita',
'FechaVisita',
'HoraVisita',
'MesVisita',
'FVencimientoVisita',
'GestorMKT',
'OrigenVisita',
'ComentarioVisita',
'FechaHoraAsignacion',
'GestorOrigen',
'IdGeografico',
'NombApellido',
'Telefonouno',
'Telefonodos',
'Correo',
'Direccion',
'Distrito',
'Provincia',
'CCOriginal',
'EstadoTelecierre',
'TCGestor',
'TCMotivoNoVenta',
'TCTipoVenta',
'Checkin',
'LeadID',
'FechaHoraInst',
'TipoDocumento',
'Documento',
'PerfilScoring',
'FObras',
'FVisitaObras',
'IdLead',
'FechaHoraTransferenciaTC',
'MotivoAsignacion',
'visePiso',
'rubroNeg',
'puertaCalle',
'nobleParedes',
'nobleTecho',
'metros',
'motivoInteres',
'conSistema',
'empresaSistema',
'bancarizado',
'segundaDireccion',
'IdVentaVREL',
'TipoSegmento',
'Latitud',
'Longitud',
'Zona',
'Seccion',
'ZonaVerisure',
'SeccionVerisure',
'VisitaNoVisitable',
'Motivo',
'Distancia',
'FechaEnvioCheckIN',
'TipoCheckIN',
'MatriculaCheckIn'
);
$rowFromValues = WriterEntityFactory::createRowFromArray($head);
$writer->addRow($rowFromValues);

date_default_timezone_set('America/Lima');

$fecharegistro=date("Y-m-d H:i:s");

$result_exec = StmtInsertarLogSeguridad_General('Exportar', $fecharegistro, '', '');


$query="SELECT 
v.IdVenta,
v.IdUsuario,
v.IdCliente,
v.Matricula,
v.Comercial,
v.CC,
v.JefeVenta,
v.CategoriaVenta,
v.TipoVenta,
v.Segmento,
v.NProspecto,
v.NContrato,
v.PrecioKit,
v.TotalExtra,
v.IngresoKIT,
v.IngresoExtras,
v.IngresoTotal,
v.EstadoVenta,
v.ExtraAutorizado,
v.MesesAutorizado,
v.N590,
v.FormaPago,
v.PAI,
v.ResumenVenta,
v.FechaHoraREG,
v.EstadoVisita,
v.FechaVisita,
v.HoraVisita,
v.MesVisita,
v.FVencimientoVisita,
v.GestorMKT,
v.OrigenVisita,
v.ComentarioVisita,
v.FechaHoraAsignacion,
v.GestorOrigen,
c.IdGeografico,
c.NombApellido,
c.Telefonouno,
c.Telefonodos,
c.Correo,
c.Direccion,
g.Distrito,
g.Provincia,
v.CCOriginal,
v.EstadoTelecierre,
v.TCGestor,
v.TCMotivoNoVenta,
v.TCTipoVenta,
v.Checkin,
v.LeadID,
concat(a.FechaInst, ' ', a.HoraInst) FechaHoraInst,
d.TipoDocumento,
d.Documento,
v.PerfilScoring,
v.FObras,
v.FVisitaObras,
v.IdLead,
v.FechaHoraTransferenciaTC,
v.MotivoAsignacion,
v.visePiso,
v.rubroNeg,
v.puertaCalle,
v.nobleParedes,
v.nobleTecho,
v.metros,
v.motivoInteres,
v.conSistema,
v.empresaSistema,
v.bancarizado,
v.segundaDireccion,
v.IdVentaVREL,
c.TipoSegmento,
c.objGeofinder,
c.objZonificacion,
v.VisitaNoVisitable,
v.infoVNOV,
v.InfoCheckIn
FROM yifi58ge_dbVENTAS.tblventa v INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
INNER JOIN yifi58ge_dbVENTAS.tblagenda a ON a.IdVenta=v.IdVenta 
INNER JOIN yifi58ge_dbVENTAS.tblgeografico g ON g.IdGeografico=c.IdGeografico
LEFT JOIN yifi58ge_dbVENTAS.tbldocumento d ON c.IdDocVisita = d.IdDoc
WHERE (v.TipoVenta='RE' or v.TipoVenta='REGGCC' or v.TipoVenta='RPMKT') and v.CC!=512
and v.IdVenta>=280807";
/*ID(23466) desde 2019-04 hacia adelante*/
/*ID(29636) desde 2019-06 hacia adelante*/
/*ID(104698) desde 2021-07 hacia adelante*/
/*ID(149027) desde 2022-03-28 hacia adelante*/
/*ID(222038) desde 2023-04-28 hacia adelante*/
/*ID(227528) desde 2023-06-01 hacia adelante*/
/*ID(237977) desde 2023-08-01 hacia adelante*/
/*ID(259045) desde 2023-10-01 hacia adelante*/


$result = $con->query($query);
//Contador para reccorer cada fila del resultado.
$i=0;


while ($Venta = $result->fetch_assoc()){

    $arreglo[] = $Venta;
    
    unset($arreglo[$i]['objGeofinder']);
    unset($arreglo[$i]['objZonificacion']);
    unset($arreglo[$i]['VisitaNoVisitable']);
    unset($arreglo[$i]['infoVNOV']);
    unset($arreglo[$i]['InfoCheckIn']);
    
    $objGeofinder=desanitizaCampo($Venta['objGeofinder'],'htmlspecialchars|htmlspecialchars|scapestring');
    
    if($objGeofinder != '' || $objGeofinder != null){
        $objGeofinder = json_decode($objGeofinder, true);

        $longitud = $objGeofinder['x'];
        $latitud = $objGeofinder['y'];
        
        if($objGeofinder['zonas'] == ''){
            $zona = '';
            $microzona = '';
        } else {
            $zonas = $objGeofinder['zonas'];
            
            if(count($zonas) == 1){
                $zona = $zonas[0]['valor']; 
                $microzona= '';
            }
            else if(count($zonas) == 2){
                $zona = $zonas[0]['valor'];
                $microzona=$zonas[1]['valor'];
            }
        }
        $arreglo[$i]['latitud'] = $latitud;
        $arreglo[$i]['longitud'] = $longitud;
        
        $arreglo[$i]['zona'] = $zona;
        $arreglo[$i]['microzona'] = $microzona;
        
        unset($arreglo[$i]['objGeofinder']);
    } else {
        $arreglo[$i]['zona'] = '';
        $arreglo[$i]['microzona'] = '';
    }
    
    $objZonificacion=desanitizaCampo($Venta['objZonificacion'],'htmlspecialchars|htmlspecialchars|scapestring');
    
    if($objZonificacion != '' || $objZonificacion != null){
        $objZonificacion = json_decode($objZonificacion, true);
        $zonaVerisure = $objZonificacion['Zona'];
        $microzonaVerisure=$objZonificacion['Microzona'];
        
        $arreglo[$i]['zonaVerisure'] = $zonaVerisure;
        $arreglo[$i]['microzonaVerisure'] = $microzonaVerisure;
        
        unset($arreglo[$i]['objZonificacion']);
    } else {
        $arreglo[$i]['zonaVerisure'] = '';
        $arreglo[$i]['microzonaVerisure'] = '';
    }
    
    $arreglo[$i]['VisitaNoVisitable'] = $Venta['VisitaNoVisitable'];
    
    if($Venta['infoVNOV'] != '' || $Venta['infoVNOV'] != null){
        $infoVNOV = json_decode($Venta['infoVNOV'], true);
        
        $motivo = $infoVNOV['Motivo'];
        
        $arreglo[$i]['Motivo'] = $motivo;
    
    } else {
        $arreglo[$i]['Motivo'] = '';
    }
    
$InfoCheckIn=desanitizaCampo($Venta['InfoCheckIn'],'htmlspecialchars|htmlspecialchars|scapestring');
    
    if($Venta['InfoCheckIn'] != '' || $Venta['InfoCheckIn'] != null){
        $InfoCheckIn = json_decode($InfoCheckIn, true);
        
        $Distancia = $InfoCheckIn['Distancia'];
        $FechaEnvio = $InfoCheckIn['FechaEnvio'];
        $Tipo = $InfoCheckIn['Tipo'];
        
        $Matricula =$InfoCheckIn['Matricula'];
        
        $arreglo[$i]['DistanciaCheckIN'] = $Distancia;
        $arreglo[$i]['FechaEnvioCheckIN'] = $FechaEnvio;
        $arreglo[$i]['TipoCheckIN'] = $Tipo;
        $arreglo[$i]['MatriculaCheckIn'] = $Matricula;
        
    } else {
        $arreglo[$i]['DistanciaCheckIN'] = '';
        $arreglo[$i]['FechaEnvioCheckIN'] = '';
        $arreglo[$i]['TipoCheckIN'] = '';
        $arreglo[$i]['MatriculaCheckIn'] = '';
    }
    
    $i++;

}

for($i=0; $i<count($arreglo); $i++){
    $rowData = WriterEntityFactory::createRowFromArray($arreglo[$i]);
    $writer->addRow($rowData);
}


$result->close();

$writer->close();

$con->close();

?>
