<?php

    require_once '../config/db.php';
    require_once '../config/conexion.php';
    //LOG
    require_once 'log/insertLog.php';
    //LIBRERIA DE EXPORTACION
    
    require_once 'libreria/Spout/Autoloader/autoload.php';
    
    use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
    use Box\Spout\Common\Entity\Row;
    
    $fileName = 'CotizacionDetalle.csv';
    
    $writer = WriterEntityFactory::createCSVWriter();
    
    $writer->openToBrowser($fileName);
        
    $head = array(
        'IdCotDet',
        'IdCotizacion',
        'Iditem',
        'Item',
        'Precio',
        'CuotaMes',
        'Unidades',
        'PrecioCotDetalle',
        'TipoPrecio',
        'DsctoCta',
        'Subtotal',
        'Subtotal_cuotaMes',
        'DetReq'
    );
    
    $rowFromValues = WriterEntityFactory::createRowFromArray($head);
    $writer->addRow($rowFromValues);
    
        date_default_timezone_set('America/Lima');
    
    $fecharegistro=date("Y-m-d H:i:s");
    
    $result_exec = StmtInsertarLogSeguridad_General('Exportar', $fecharegistro, '', '');
    
    $query="
        SELECT 
        IFNULL(ctz.IdCotDet, '') IdCotDet, 
        IFNULL(ctz.IdCotizacion, '') IdCotizacion, 
        IFNULL(ctz.Iditem, '') Iditem, 
        IFNULL(i.Item, '') Item, 
        IFNULL(i.Precio, '') Precio, 
        IFNULL(i.CuotaMes, '') CuotaMes, 
        IFNULL(ctz.Unidades, '') Unidades, 
        IFNULL(ctz.PrecioCotDetalle, '') PrecioCotDetalle, 
        IFNULL(ctz.TipoPrecio, '') TipoPrecio, 
        IFNULL(ctz.DsctoCta, '') DsctoCta, 
        IFNULL(ctz.Subtotal, '') Subtotal, 
        IFNULL(ctz.Subtotal_cuotaMes, '') Subtotal_cuotaMes, 
        IFNULL(ctz.DetReq, '') DetReq
        FROM tblcotizaciondetalle ctz
        INNER JOIN tblitem i ON ctz.Iditem = i.IdItem
    ";
    
    $result = $con->query($query);
    
    while ($Venta = $result->fetch_assoc()){
      $rowData = WriterEntityFactory::createRowFromArray($Venta);
      $writer->addRow($rowData);
    }
    
    $result->close();
    
    $writer->close();
    
    
    $con->close();

?>

