<?php

include('is_logged.php');

date_default_timezone_set('America/Lima');
require_once '../config/db.php';
require_once '../config/conexion.php';

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';

$fecharegistro=date("Y-m-d H:i:s");

        $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
        $usuariosesion=htmlspecialchars($_SESSION['usuariosesion']);
        $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI']);
        $Acceso='Exportar';
        $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
        
        try {
                
          $stmt = $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
          $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
          $stmt->execute();
          $stmt->close();
          
        } catch (\Exception $e) {
          echo $e->getMessage();
        } 

try{

        $stmtmdp = $con->prepare( "SELECT
p.IdPorfolio,
p.IdCliente,
p.EstadoMonitoring,
p.EstadoBilling,
p.UsuarioREG,
p.FechaHoraREG,
c.NombApellido,
c.Telefonouno,
c.Telefonodos,
c.Correo,
c.Direccion,
c.IdGeografico,
g.Distrito,
g.Provincia
FROM tblporfolio p
INNER JOIN tblcliente c ON p.IdCliente = c.IdCliente
INNER JOIN tblgeografico g ON c.IdGeografico = g.IdGeografico");
        $stmtmdp->execute();
        $stmtmdp->store_result();
        $stmtmdp->bind_result($IdPorfolio,
$IdCliente,
$EstadoMonitoring,
$EstadoBilling,
$UsuarioREG,
$FechaHoraREG,
$NombApellido,
$Telefonouno,
$Telefonodos,
$Correo,
$Direccion,
$IdGeografico,
$Distrito,
$Provincia);
        $venta = [];        
        while ($stmtmdp->fetch()){
        $venta[] = array_map("utf8_encode",['IdPorfolio'=>$IdPorfolio,
'IdCliente'=>$IdCliente,
'EstadoMonitoring'=>$EstadoMonitoring,
'EstadoBilling'=>$EstadoBilling,
'UsuarioREG'=>$UsuarioREG,
'FechaHoraREG'=>$FechaHoraREG,
'NombApellido'=>$NombApellido,
'Telefonouno'=>$Telefonouno,
'Telefonodos'=>$Telefonodos,
'Correo'=>$Correo,
'Direccion'=>$Direccion,
'IdGeografico'=>$IdGeografico,
'Distrito'=>$Distrito,
'Provincia'=>$Provincia
]);            
	    }
	    
        $stmtmdp->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename=Portfolio.csv');
$output = fopen('php://output', 'w');
fputcsv($output, array(
    'IdPorfolio',
    'IdCliente',
    'EstadoMonitoring',
    'EstadoBilling',
    'UsuarioREG',
    'FechaHoraREG',
    'NombApellido',
    'Telefonouno',
    'Telefonodos',
    'Correo',
    'Direccion',
    'IdGeografico',
    'Distrito',
    'Provincia'
    ));
    
if (count($venta) > 0) {
    foreach ($venta as $row) {
        fputcsv($output, $row);
    }
}

$con->close();