<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';

date_default_timezone_set('America/Lima');
//LIBRERIA DE EXPORTACION
require_once 'libreria/Spout/Autoloader/autoload.php';

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

$fileName = 'logGeofinder.csv';

$writer = WriterEntityFactory::createCSVWriter();

$writer->openToBrowser($fileName);

$head = array(
    'FechaHoraReg',
    'Tipo',
    'NombresApellidos',
    'Matricula',
    'Mes'
);
$rowFromValues = WriterEntityFactory::createRowFromArray($head);
$writer->addRow($rowFromValues);

$query = "SELECT l.FechaHoraReg, l.Tipo, concat(u.Nombres, ' ', u.Apellidos) NombresApellidos, u.Matricula, month(l.FechaHoraReg), mes
            FROM yifi58ge_dbACTIVIDADES.tblog_geofindeInvert l
            INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON l.IdUsuario=u.IdUsuario
            WHERE l.FechaHoraReg BETWEEN '2021-07-01 00:00:00' AND '2021-12-31 11:59:59'
            order by l.FechaHoraReg
            ";
            
$result = $con->query($query);
//CONTADOR i para las filas de la consulta

while ($datos = $result->fetch_assoc()){
    $arreglo[] = $datos;

}

for($i=0; $i<count($arreglo); $i++){
    $rowData = WriterEntityFactory::createRowFromArray($arreglo[$i]);
    $writer->addRow($rowData);
}

$result->close();

$writer->close();

$con->close();

?>