<?php

    require_once '../config/db.php';
    require_once '../config/conexion.php';
    include '../helper/helper_validacion.php';

    date_default_timezone_set('America/Lima');
    
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }
    
    if(isset($_POST['fechaMes']) || !empty($_POST['fechaMes'])){
        // $fechaMes = $_POST['fechaMes'];
        $fechaMes=sanitizaCampo($_POST['fechaMes'],'sanitizestring|scapestring|htmlspecialchars',$con);
        $fechaMes = htmlspecialchars($fechaMes);
    } else {
        $fechaMes = "2022-06-01";
    }
    // $perfilUsuario = $_POST['perfilUsuario'];
    $perfilUsuario=sanitizaCampo($_POST['perfilUsuario'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $perfilUsuario = htmlspecialchars($perfilUsuario);
    
    // $MatriculaUsuario = $_POST['MatriculaUsuario'];
    $MatriculaUsuario=sanitizaCampo($_POST['MatriculaUsuario'],'sanitizestring|scapestring|htmlspecialchars',$con);
    $MatriculaUsuario = htmlspecialchars($MatriculaUsuario);
    
    
    // if($perfilUsuario==55){
    //     $concatenadoV="and v.GestorMKT='".$MatriculaUsuario."'";
    // }else{
    //     $concatenadoV="";
    // }
    
    if($perfilUsuario==55){
        // $concatenadoV="and v.GestorMKT=?";
        
        $sql = "SELECT cv.Week,COUNT(v.IdVenta) TOTAL FROM yifi58ge_dbVENTAS.tblventa as v 
            INNER JOIN tbltmpcalendarioventamkt as cv on cv.CalendarioDia=DATE_FORMAT(v.FechaHoraREG,'%Y-%m-%d') 
            WHERE cv.Mes_Operador=? 
            AND (v.TipoVenta='RE' or v.TipoVenta='REGGCC')  AND (v.EstadoVisita = 'Asignada' OR v.EstadoVisita = 'Vendida' OR v.EstadoVisita = 'NoVendida' OR v.EstadoVisita='PendienteValidarVnoV' OR v.EstadoVisita='AnuladaNoImputableOper')
            AND v.GestorMKT=?
            GROUP BY cv.Week";
        
        $sql->bind_param('ss',$fechaMes,$MatriculaUsuario);
        $sql->execute();
        $sql->store_result();
        $sql->bind_result(
                $WeekRow,
                $TOTALRow
            );
    }else{
        // $concatenadoV="";
        $sql = "SELECT cv.Week,COUNT(v.IdVenta) TOTAL FROM yifi58ge_dbVENTAS.tblventa as v 
                INNER JOIN tbltmpcalendarioventamkt as cv on cv.CalendarioDia=DATE_FORMAT(v.FechaHoraREG,'%Y-%m-%d') 
                WHERE cv.Mes_Operador=? 
                AND (v.TipoVenta='RE' or v.TipoVenta='REGGCC')  AND (v.EstadoVisita = 'Asignada' OR v.EstadoVisita = 'Vendida' OR v.EstadoVisita = 'NoVendida' OR v.EstadoVisita='PendienteValidarVnoV' OR v.EstadoVisita='AnuladaNoImputableOper') 
                GROUP BY cv.Week";
                
        $sql->bind_param('s',$fechaMes);
        $sql->execute();
        $sql->store_result();
        $sql->bind_result(
                $WeekRow,
                $TOTALRow
            );
    }
    
    if($sql->num_rows <= 0){
        $respuesta['Visitas'] = array();
    }else{
        $return_arr = array();
        while($sql->fetch()){
         $row_array['Week'] =$WeekRow;
         $row_array['TOTAL'] =$TOTALRow;
        
         array_push($return_arr,array_map("utf8_encode",$row_array)); //o este
        }
        
        $respuesta['Visitas'] = $return_arr;
        // echo json_encode($respuesta);

    }
    
/****************************/

    if($perfilUsuario==55){
        // $concatenadoV="and v.GestorMKT=?";
        
        $sql = "SELECT cv.Week,COUNT(v.IdVenta) TOTAL FROM yifi58ge_dbVENTAS.tblventa as v 
                INNER JOIN tbltmpcalendarioventamkt as cv on cv.CalendarioDia=DATE_FORMAT(v.FechaHoraREG,'%Y-%m-%d') 
                WHERE cv.Mes_Operador=? 
                AND (v.TipoVenta='RE' or v.TipoVenta='REGGCC') AND (cv.DW='lun' or cv.DW='mar' or cv.DW='mie' or cv.DW='jue' or cv.DW='vie' or cv.DW='sab') and (v.EstadoVisita = 'Asignada' OR v.EstadoVisita = 'Vendida' OR v.EstadoVisita = 'NoVendida' OR v.EstadoVisita='PendienteValidarVnoV' OR v.EstadoVisita='AnuladaNoImputableOper')
                AND v.GestorMKT=?
                GROUP BY cv.Week";
        
        $sql->bind_param('ss',$fechaMes,$MatriculaUsuario);
        $sql->execute();
        $sql->store_result();
        $sql->bind_result(
                $WeekRow,
                $TOTALRow
            );
    }else{
        // $concatenadoV="";
        $sql = "SELECT cv.Week,COUNT(v.IdVenta) TOTAL FROM yifi58ge_dbVENTAS.tblventa as v 
                INNER JOIN tbltmpcalendarioventamkt as cv on cv.CalendarioDia=DATE_FORMAT(v.FechaHoraREG,'%Y-%m-%d') 
                WHERE cv.Mes_Operador=? 
                AND (v.TipoVenta='RE' or v.TipoVenta='REGGCC') AND (cv.DW='lun' or cv.DW='mar' or cv.DW='mie' or cv.DW='jue' or cv.DW='vie' or cv.DW='sab') and (v.EstadoVisita = 'Asignada' OR v.EstadoVisita = 'Vendida' OR v.EstadoVisita = 'NoVendida' OR v.EstadoVisita='PendienteValidarVnoV' OR v.EstadoVisita='AnuladaNoImputableOper')
                GROUP BY cv.Week";
                
        $sql->bind_param('s',$fechaMes);
        $sql->execute();
        $sql->store_result();
        $sql->bind_result(
                $WeekRow,
                $TOTALRow
            );
    }
    
    if($sql->num_rows <= 0){
        $respuesta['VisitasLS'] = array();
    }else{
        $return_arr = array();
        while($sql->fetch()){
         $row_array['Week'] =$WeekRow;
         $row_array['TOTAL'] =$TOTALRow;
        
         array_push($return_arr,array_map("utf8_encode",$row_array)); //o este
        }
        
        $respuesta['VisitasLS'] = $return_arr;
        // echo json_encode($respuesta);

    }
/****************************/

        if($perfilUsuario==55){
        // $concatenadoV="and v.GestorMKT=?";
        
        $sql = "SELECT cv.Week,COUNT(v.IdVenta) TOTAL FROM yifi58ge_dbVENTAS.tblventa as v 
                INNER JOIN tbltmpcalendarioventamkt as cv on cv.CalendarioDia=DATE_FORMAT(v.FechaHoraREG,'%Y-%m-%d') 
                WHERE cv.Mes_Operador=? 
                AND (v.TipoVenta='RE' or v.TipoVenta='REGGCC')  AND (cv.DW='lun' or cv.DW='mar' or cv.DW='mie' or cv.DW='jue' or cv.DW='vie' or cv.DW='sab') and (v.EstadoVisita = 'Asignada' OR v.EstadoVisita = 'Vendida' OR v.EstadoVisita = 'NoVendida' OR v.EstadoVisita='PendienteValidarVnoV' OR v.EstadoVisita='AnuladaNoImputableOper') 
                AND v.GestorMKT=?
                GROUP BY cv.Week";
        
        $sql->bind_param('ss',$fechaMes,$MatriculaUsuario);
        $sql->execute();
        $sql->store_result();
        $sql->bind_result(
                $WeekRow,
                $TOTALRow
            );
    }else{
        // $concatenadoV="";
        $sql = "SELECT cv.Week,COUNT(v.IdVenta) TOTAL FROM yifi58ge_dbVENTAS.tblventa as v 
                INNER JOIN tbltmpcalendarioventamkt as cv on cv.CalendarioDia=DATE_FORMAT(v.FechaHoraREG,'%Y-%m-%d') 
                WHERE cv.Mes_Operador=? 
                AND (v.TipoVenta='RE' or v.TipoVenta='REGGCC')  AND (cv.DW='lun' or cv.DW='mar' or cv.DW='mie' or cv.DW='jue' or cv.DW='vie' or cv.DW='sab') and (v.EstadoVisita = 'Asignada' OR v.EstadoVisita = 'Vendida' OR v.EstadoVisita = 'NoVendida' OR v.EstadoVisita='PendienteValidarVnoV' OR v.EstadoVisita='AnuladaNoImputableOper') 
                GROUP BY cv.Week";
                
        $sql->bind_param('s',$fechaMes);
        $sql->execute();
        $sql->store_result();
        $sql->bind_result(
                $WeekRow,
                $TOTALRow
            );
    }
    
    if($sql->num_rows <= 0){
        $respuesta['VisitasELS'] = array();
    }else{
        $return_arr = array();
        while($sql->fetch()){
         $row_array['Week'] =$WeekRow;
         $row_array['TOTAL'] =$TOTALRow;
        
         array_push($return_arr,array_map("utf8_encode",$row_array)); //o este
        }
        
        $respuesta['VisitasELS'] = $return_arr;
        // echo json_encode($respuesta);

    }
    
    echo json_encode($respuesta);
