<?php

    require_once '../config/db.php';
    require_once '../config/conexion.php';
    
    date_default_timezone_set('America/Lima');
    
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date)
    {
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date)
    {
        return date('Y-m-d', strtotime($date));
    }
    
    if(isset($_POST['MesComercial'])){
        $mes = $_POST['MesComercial'];
    } else {
        $mes = 'jul-2021';
    }
    
    $arrayDatosDispositivos = consultarDispositivos($mes);
    //$diasLaborables = $arrayDatosDispositivos['DiasLaborables'];
    
    //$dispositivos = $arrayDatosDispositivos['BaseDispositivos'];
    
    $diasLaborados = (float)diasLaborados();
    
    if(!empty($arrayDatosDispositivos)){
        
        //$dispositivos = json_decode($arrayDatosDispositivos, true);
        
        $arrayElementosAmpliados = consultarElementosAmpliados($mes);
        
        $arrayElementos = consultarElementos($mes);
        
        $arrayUpfront = consultarUpfrontElemento($mes);
        
        $arrayUpfrontAgendados = consultarUpfrontAgendadosElemento($mes);
        
        $totalUpfront = consultarUpfrontElementoTotal($mes);
        
        $totalElementos = consultarElementosAmpliadosTotal($mes);
        
        $arrayPrecioPromedio = consultarElementosAmpliadosPromedio($mes);
        
        agregarDatos($arrayElementosAmpliados, 'ElementosAmpliados');
        
        agregarDatos($arrayElementos, 'Elementos');
        
        agregarDatos($arrayUpfront, 'Upfront');
        
        agregarDatos($arrayUpfrontAgendados, 'UpfrontAgendados');
        
        agregarDatos($totalUpfront, 'UpfrontTotal');
        
        agregarDatos($totalElementos, 'ElementosTotal');
        
        agregarDatos($arrayPrecioPromedio, 'PrecioPromedio');
        
        $arrayDatos = array(
            'Resultado' => 'exito',
            'Datos' => $arrayDatosDispositivos
        );
    } else {
        $arrayDatos = array(
            'Resultado' => 'sinDatos',
        );
    }
    
    echo json_encode($arrayDatos);
    
    
    function consultarDispositivos($mes){
        global $con;
        
        $sql = "SELECT IdItem, CodItem, Item
                FROM tblitem
                WHERE CategoriaItem = 'ampliacion'";
        $resultado = $con->query($sql);
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        //echo json_encode($respuesta);
        
        return $respuesta;
    }
    
    function consultarElementosAmpliados($mes){
        global $con;
        
        $sql = "SELECT cd.IdItem, count(*) as 'Total'
                FROM tblampliacion a
                INNER JOIN tblcotizacion c ON a.IdCotizacion = c.IdCotizacion
                INNER JOIN tblcotizaciondetalle cd ON c.IdCotizacion = cd.IdCotDet
                WHERE MesAmp = '".$mes."'
                AND EstadoAmp = 'Instalada'
                group by cd.IdItem";
        $resultado = $con->query($sql);
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;
    }
    
    function consultarElementosAmpliadosTotal($mes){
        global $con;
        
        $sql = "SELECT count(*) as 'Total'
                FROM tblampliacion a
                INNER JOIN tblcotizacion c ON a.IdCotizacion = c.IdCotizacion
                INNER JOIN tblcotizaciondetalle cd ON c.IdCotizacion = cd.IdCotDet
                WHERE MesAmp = '".$mes."'
                AND EstadoAmp = 'Instalada'";
        $resultado = $con->query($sql);
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta = $data['Total'];
            }    
        } else {
            $respuesta = 0;
        }
        
        return $respuesta;
    }
    
    function consultarElementos($mes){
        global $con;
        
        $sql = "SELECT cd.IdItem, count(*) as 'Total'
                FROM tblampliacion a
                INNER JOIN tblcotizacion c ON a.IdCotizacion = c.IdCotizacion
                INNER JOIN tblcotizaciondetalle cd ON c.IdCotizacion = cd.IdCotDet
                WHERE MesAmp = '".$mes."'
                group by cd.IdItem";
                
        $resultado = $con->query($sql);
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;        
                
    }
    
    function consultarUpfrontElemento($mes){
        global $con;
        
        $sql = "SELECT cd.IdItem, sum(cd.Subtotal) as 'Total'
                FROM tblampliacion a
                INNER JOIN tblcotizacion c ON a.IdCotizacion = c.IdCotizacion
                INNER JOIN tblcotizaciondetalle cd ON c.IdCotizacion = cd.IdCotDet
                WHERE MesAmp = '".$mes."'
                AND EstadoAmp = 'Instalada'
                group by cd.IdItem";
                
        $resultado = $con->query($sql);
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;    
    }
    
    function consultarUpfrontAgendadosElemento($mes){
        global $con;
        
        $sql = "SELECT cd.IdItem, sum(cd.Subtotal) as 'Total'
                FROM tblampliacion a
                INNER JOIN tblcotizacion c ON a.IdCotizacion = c.IdCotizacion
                INNER JOIN tblcotizaciondetalle cd ON c.IdCotizacion = cd.IdCotDet
                WHERE MesAmp = '".$mes."'
                GROUP BY cd.IdItem";
                
        $resultado = $con->query($sql);
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;    
    }
    
    function consultarUpfrontElementoTotal($mes){
        global $con;
        
        $sql = "SELECT sum(cd.Subtotal) as 'Total'
                FROM tblampliacion a
                INNER JOIN tblcotizacion c ON a.IdCotizacion = c.IdCotizacion
                INNER JOIN tblcotizaciondetalle cd ON c.IdCotizacion = cd.IdCotDet
                WHERE MesAmp = '".$mes."'
                AND EstadoAmp = 'Instalada'";
                
        $resultado = $con->query($sql);
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta = $data['Total'];
            }    
        } else {
            $respuesta = 0;
        }
        
        return $respuesta;    
    }
    
    function consultarElementosAmpliadosPromedio($mes){
        global $con;
        
        $sql = "SELECT cd.IdItem, AVG(cd.Subtotal) as 'Promedio'
                FROM tblampliacion a
                INNER JOIN tblcotizacion c ON a.IdCotizacion = c.IdCotizacion
                INNER JOIN tblcotizaciondetalle cd ON c.IdCotizacion = cd.IdCotDet
                WHERE MesAmp = '".$mes."'
                AND EstadoAmp = 'Instalada'
                group by cd.IdItem";
        $resultado = $con->query($sql);
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;
    }
    
    function agregarDatos($array, $tipo){
        global $arrayDatosDispositivos;
        
        foreach($arrayDatosDispositivos as $clave => $valor){
            $IdItem = $valor['IdItem'];
            
            if($tipo == 'ElementosAmpliados'){
                $arrayDatosDispositivos[$clave]['ElementosAmpliados'] = 0;
            }
            
            if($tipo == 'Elementos'){
                $arrayDatosDispositivos[$clave]['Elementos'] = 0;
            }
            
            if($tipo == 'ElementosTotal'){
                $arrayDatosDispositivos[$clave]['ElementosTotal'] = $array;
            }
            
            if($tipo == 'Upfront'){
                $arrayDatosDispositivos[$clave]['Upfront'] = 0;
            }
            
            if($tipo == 'UpfrontAgendados'){
                $arrayDatosDispositivos[$clave]['UpfrontAgendados'] = 0;
            }
            
            if($tipo == 'UpfrontTotal'){
                $arrayDatosDispositivos[$clave]['UpfrontTotal'] = $array;
            }
            
            if($tipo == 'PrecioPromedio'){
                $arrayDatosDispositivos[$clave]['PrecioPromedio'] = 0.0;
            }
            
            foreach($array as $claveDisp => $valorDisp){
                $IdItemDisp = $valorDisp['IdItem'];
                
                $arrayDatosDispositivos[$clave]['IdItemDispositivo'] = $valorDisp['IdItem'];
                
                if($IdItemDisp == $IdItem){
                    if($tipo == 'ElementosAmpliados'){
                        $arrayDatosDispositivos[$clave]['ElementosAmpliados'] = $valorDisp['Total'];
                    }
                    if($tipo == 'Elementos'){
                        $arrayDatosDispositivos[$clave]['Elementos'] = $valorDisp['Total'];
                    }
                    if($tipo == 'Upfront'){
                        $arrayDatosDispositivos[$clave]['Upfront'] = $valorDisp['Total'];
                    }
                    if($tipo == 'UpfrontAgendados'){
                        $arrayDatosDispositivos[$clave]['UpfrontAgendados'] = $valorDisp['Total'];
                    }
                    if($tipo == 'PrecioPromedio'){
                        $arrayDatosDispositivos[$clave]['PrecioPromedio'] = $valorDisp['Promedio'];
                    }
                    
                    
                }
            }
        }
    }
    
    function diasLaborados(){
        $feriados = 
                    [   '1' => [],
                        '2' => [],
                        '3' => [],
                        '4' => [],
                        '5' => [],
                        '6' => [],
                        '7' => [28, 29],
                        '8' => [30],
                        '9' => [],
                        '10' => [8],
                        '11' => [1],
                        '12' => [8, 25]
                    ];
     
     
        $diaActual = date("j", time()); //Día del mes sin ceros iniciales
        $mes = date("n", time()); //Representación numérica de un mes, sin ceros iniciales
        $mes_format = date("m", time()); //Representación numérica de un mes, con ceros iniciales
         
        $año = date("Y", time()); //Una representación numérica completa de un año, 4 dígitos
        
        $contador = 0;
        
        $feriadosMesActual = $feriados[$mes];
        
        for($i=1; $i<=$diaActual; $i++){
            
            
            //Añadir 0 al recorrido del mes
            //Genera la fecha con formato año-mes-dia de cada día del mes
            if($i<10){
                $dia = "0".$i;
                $fecha = $año."-".$mes_format."-".$dia;
            } else {
                $fecha = $año."-".$mes_format."-".$i;
            }
            //Convertimos el string a una variable tipo time
            $fecha=strtotime($fecha);
            
            //Obtenemos la representacion numérica de la iso-8601 del día de la semana
            $diaFecha = date("N", $fecha); //Representación numérica ISO-8601 del día de la semana (añadido en PHP 5.1.0) 1 (para lunes) hasta 7 (para domingo)
            //Busca en el arreglo de FeriadosMesActual desde el primer día del mes
            if (in_array($i, $feriadosMesActual)) {
                if($diaFecha>= 1 && $diaFecha <= 5){
                    $contador--;
                }else if ($diaFecha == 6){
                    $contador -= 0.5;
                }
            }
            //Si el día es de lunes a viernes aumentamos el contador con un valor igual a 1, si es sabado 0.5
            if($diaFecha >= 1 && $diaFecha <= 5){
                $contador++;
            } else if ($diaFecha == 6){
                $contador += 0.5;
            }
        }
        
        return $contador;
    }
    
    function porcentaje($parte, $total){
        if($total > 0 && $parte >= 0){
            return number_format(round(($parte/$total)*100, 2), 2);
        } else {
            return 0;
        }
    }