<?php

    require_once '../config/db.php';
    require_once '../config/conexion.php';
    
    date_default_timezone_set('America/Lima');
    
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date)
    {
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date)
    {
        return date('Y-m-d', strtotime($date));
    }
    
    
    if(isset($_POST['MesComercial'])){
        $mes = $_POST['MesComercial'];
    } else {
        $mes = 'jul-2021';
    }
    
    $arrayDatosCanales = consultarCanales($mes);
    
    $diasLaborables = $arrayDatosCanales['DiasLaborables'];
    $canales = $arrayDatosCanales['BaseCanal'];
    $diasLaborados = (float)diasLaborados();
    
    if(!empty($canales)){
        
        $canales = json_decode($canales, true);
        //ARRAY CON LOS DATOS DEL UPFRONT DE LA CONSULTA
        $actualCanales = consultaTotalVendidoActual($mes);
        //ARRAY CO NLOS DATOS DE GESTIONES
        $gestionesCanales = consultaTotalGestiones($mes);
        //ARRAY CON LOS DATOS DE AGENDANDOS
        $actualAgendados = consultaAgendados($mes);
        //ARRAY CON LOS DATOS DE INSTALADOS
        $actualInstalados = consultaInstalados($mes);
        //ARRAY CON LOS DATOS DE FACTURADOS
        $actualFacturados = consultaFacturados($mes);
        //ARRAY CON LOS DATOS DE NELEMENTOS INSTALADOS
        $actualNElementos = consultarNElementos($mes);
        
        //AÑADIR DATOS DE LOS RESULTADOS DE LOS ARREGLOS AL ARRAY CANAL
        agregarDatos($actualCanales, 'upfront');
        agregarDatos($gestionesCanales, 'gestiones');
        agregarDatos($actualAgendados, 'agendados');
        agregarDatos($actualInstalados, 'instalados');
        agregarDatos($actualFacturados, 'facturados');
        agregarDatos($actualNElementos, 'nelementos');
        
        $arrayDatos = array(
            'Resultado' => 'exito',
            'Datos' => $canales,
            'diasLaborables' => $diasLaborables,
            'diasLaborados' => $diasLaborados
        );
    } else {
         $arrayDatos = array(
            'Resultado' => 'sinDatos',
        );
    }
    
    echo json_encode($arrayDatos);
    
    function consultarCanales($mes){
        global $con;
        
        $sql = "SELECT BaseCanal, DiasLaborables
                FROM tblDashboardUpselling
                WHERE N590 ='".$mes."'";
        $resultado = $con->query($sql);
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta = [
                    'DiasLaborables' => $data['DiasLaborables'],
                    'BaseCanal' => $data['BaseCanal']
                ];
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;
    }
    
    function consultaTotalVendidoActual($mes){

        global $con;

        $sql = "SELECT Amp.TipoCanal, SUM(Cot.TotalPrecio) Total
                FROM tblampliacion Amp
                INNER JOIN tblcotizacion Cot ON Amp.IdCotizacion = Cot.IdCotizacion
                WHERE MesAmp = '".$mes."'
                AND EstadoAmp IN ('Instalada')
                AND Amp.TipoCanal IN ('Inbound', 'PostMantos', 'Outbound', 'Field')
                GROUP BY Amp.TipoCanal";
        $resultado = $con->query($sql);
        
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;
        
        
    }
    
    function consultaTotalGestiones($mes){
        global $con;

        
        $sql ="SELECT Amp.TipoCanal, count(*) Total
                FROM tblampliacion Amp
                INNER JOIN tblcotizacion Cot ON Amp.IdCotizacion = Cot.IdCotizacion
                WHERE Amp.MesAmp = '".$mes."'
                AND Amp.TipoCanal IN ('Inbound', 'PostMantos', 'Outbound', 'Field')
                GROUP BY TipoCanal";
                
        $resultado = $con->query($sql);
        
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;         
        
    }
    
    function consultaAgendados($mes){
        
        global $con;
        
        $sql ="SELECT Amp.TipoCanal, count(*) Total
                FROM tblampliacion Amp
                INNER JOIN tblcotizacion Cot ON Amp.IdCotizacion = Cot.IdCotizacion
                WHERE Amp.MesAmp = '".$mes."'
                AND Amp.TipoCanal IN ('Inbound', 'PostMantos', 'Outbound', 'Field')
                AND Amp.EstadoAmp IN ('AgendadaTEC', 'Instalada')
                GROUP BY TipoCanal";
                
        $resultado = $con->query($sql);
        
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;        
    }
    
    function consultaInstalados($mes){
        
        global $con;
        
        $sql ="SELECT Amp.TipoCanal, count(*) Total
                FROM tblampliacion Amp
                INNER JOIN tblcotizacion Cot ON Amp.IdCotizacion = Cot.IdCotizacion
                WHERE Amp.MesAmp = '".$mes."'
                AND Amp.TipoCanal IN ('Inbound', 'PostMantos', 'Outbound', 'Field')
                AND Amp.EstadoAmp IN ('Instalada')
                GROUP BY TipoCanal";
                
        $resultado = $con->query($sql);
        
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;        
    }
    
    function consultaFacturados($mes){
        
        global $con;
        
        $sql ="SELECT Amp.TipoCanal, count(*) Total
                FROM tblampliacion Amp
                INNER JOIN tblcotizacion Cot ON Amp.IdCotizacion = Cot.IdCotizacion
                WHERE Amp.MesAmp = '".$mes."'
                AND Amp.TipoCanal IN ('Inbound', 'PostMantos', 'Outbound', 'Field')
                AND Amp.EstadoAmp IN ('Facturada')
                GROUP BY TipoCanal";
                
        $resultado = $con->query($sql);
        
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;        
    }
    
    function consultarNElementos($mes){
        
        global $con;
        
        $sql = "SELECT Amp.TipoCanal, sum(cot.TotalUnidad) Total
                FROM tblampliacion Amp
                INNER JOIN tblcotizacion cot ON Amp.IdCotizacion = cot.IdCotizacion
                WHERE Amp.MesAmp = '".$mes."'
                AND Amp.EstadoAmp IN ('Instalada')
                AND Amp.TipoCanal IN ('Inbound', 'PostMantos', 'Outbound', 'Field')
                GROUP BY TipoCanal";
                
        $resultado = $con->query($sql);
        
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta; 
    }
    
    function agregarDatos($datos, $tipo){
        
        global $canales;
        global $diasLaborables;
        
        //var_dump($datos);
        
        //RECORRE EL ARREGLO DE GESTORES
        foreach($canales as $clave => $valor){
            $canal = $valor['canal'];
            $objetivo = (float)$valor['objetivo'];
            
            //AGREGA VALORES 0.00 A LOS GESTORES QUE NO TIENEN UPFRONT
            if($tipo == 'upfront'){
                $canales[$clave]['upfront'] = "0.00";
                $canales[$clave]['avance'] = "0.00";
                $canales[$clave]['proy'] = "0.00";
                $canales[$clave]['upfrontFLOAT'] = 0.00;
            }
            
            if($tipo == 'gestiones'){
                $canales[$clave]['gestiones'] = 0;
            }
            
            if($tipo == 'agendados'){
                $canales[$clave]['agendados'] = 0;
            }
            
            if($tipo == 'instalados'){
                $canales[$clave]['instalados'] = 0;
            }
            
            if($tipo == 'facturados'){
                $canales[$clave]['facturados'] = 0;
            }
            
            if($tipo == 'nelementos'){
                $canales[$clave]['nelementos'] = 0;
            }
            
            foreach($datos as $claveGestor => $valorGestor){
                $TipoCanal = $valorGestor['TipoCanal'];
                
                if($canal === $TipoCanal){
                    
                    if($tipo == 'upfront'){
                        
                        $total = (float)$valorGestor['Total'];
                        $avance = porcentaje($total, $objetivo);
                        $diasLaborados = (float)diasLaborados();
                        if($objetivo > 0){
                            $proy = ((($total/$diasLaborados)*$diasLaborables)/$objetivo)*100;
                        } else{
                            $proy = 0;
                        }
                        //Añadir total como numero
                        $canales[$clave]['upfrontFLOAT'] = $total;
                        //Usar funcion number format para volver a string con separacion de miles y punto para los decimales
                        $total = number_format($total,2,'.',',');
                        $avance = number_format($avance,2,'.',',');
                        $proy = number_format($proy, 2,'.',',');
                        //Agregar al arreglo Gestores
                        $canales[$clave]['upfront'] = $total;
                        $canales[$clave]['avance'] = $avance;
                        $canales[$clave]['proy'] = $proy;
                    }
                    
                    if($tipo == 'gestiones'){
                        $gestiones = (int)$valorGestor['Total'];
                        $canales[$clave]['gestiones'] = $gestiones;
                    }
                    
                    if($tipo == 'agendados'){
                        $agendados = (int)$valorGestor['Total'];
                        $canales[$clave]['agendados'] = $agendados;
                    }
                    
                    if($tipo == 'instalados'){
                        $instalados = (int)$valorGestor['Total'];
                        $canales[$clave]['instalados'] = $instalados;
                    }
                    
                    if($tipo == 'facturados'){
                        $facturados = (int)$valorGestor['Total'];
                        $canales[$clave]['facturados'] = $facturados;
                    }
                    
                    if($tipo == 'nelementos'){
                        $nelementos = (int)$valorGestor['Total'];
                        $canales[$clave]['nelementos'] = $nelementos;
                    }
                }
            }
            
        }
        
    }
    
    function diasLaborados(){
        $feriados = 
                    [   '1' => [],
                        '2' => [],
                        '3' => [],
                        '4' => [],
                        '5' => [],
                        '6' => [],
                        '7' => [28, 29],
                        '8' => [30],
                        '9' => [],
                        '10' => [8],
                        '11' => [1],
                        '12' => [8, 25]
                    ];
        
        //MES COMERCIAL DATO
        global $mes;
        
        $mesGestion =  date("n", strtotime($mes)); //Representacion número del mes enviado
        $mesActual = date("n", time()); //Representación numérica de un mes, sin ceros iniciales
        
        $año = date("Y", strtotime($mes)); //Una representación numérica completa de un año, 4 dígitos
        
        if($mesGestion == $mesActual){
            $mes_format = date("m", time()); //Representación numérica de un mes, con ceros iniciales
            $diaActual = date("j", time()); //Día del mes sin ceros iniciales
        } else {
            $mes_format = date("m", strtotime($mes)); //Representación numérica de un mes, con ceros iniciales
            $diasTotalesMes = date("t", strtotime($mes)); //Número de días del mes dado
            $diaActual = $diasTotalesMes;
        }
        
        $contador = 0;
        
        $feriadosMesActual = $feriados[$mesGestion];
        
        for($i=1; $i<=$diaActual; $i++){
            
            //Añadir 0 al recorrido del mes
            //Genera la fecha con formato año-mes-dia de cada día del mes
            if($i<10){
                $dia = "0".$i;
                $fecha = $año."-".$mes_format."-".$dia;
            } else {
                $fecha = $año."-".$mes_format."-".$i;
            }
            //Convertimos el string a una variable tipo time
            $fecha=strtotime($fecha);
            
            //Obtenemos la representacion numérica de la iso-8601 del día de la semana
            $diaFecha = date("N", $fecha); //Representación numérica ISO-8601 del día de la semana (añadido en PHP 5.1.0) 1 (para lunes) hasta 7 (para domingo)
            //Busca en el arreglo de FeriadosMesActual desde el primer día del mes
            if (in_array($i, $feriadosMesActual)) {
                if($diaFecha>= 1 && $diaFecha <= 5){
                    $contador--;
                }else if ($diaFecha == 6){
                    $contador -= 0.5;
                }
            }
            //Si el día es de lunes a viernes aumentamos el contador con un valor igual a 1, si es sabado 0.5
            if($diaFecha >= 1 && $diaFecha <= 5){
                $contador++;
            } else if ($diaFecha == 6){
                $contador += 0.5;
            }
        }
        
        return $contador;
    }
    
    function porcentaje($parte, $total){
        if($total > 0 && $parte >= 0){
            return number_format(round(($parte/$total)*100, 2), 2);
        } else {
            return 0;
        }
    }