<?php

    require_once '../config/db.php';
    require_once '../config/conexion.php';
    
    date_default_timezone_set('America/Lima');
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }
    $fechadiahoy= 'Mar-2022';    
    
    $status = array(
        array('status' =>'NOREGISTRADO','Total'=>0),
        array('status' =>'REGISTRADO','Total'=>0)
        );
    $resultTotalREG=0;
    $resultTotalNOREG=0;
    
    $sql = "SELECT tp.N590 FROM yifi58ge_dbVENTAS.tbltmpdashboard tp where tp.Origen='Dashboard1' order by tp.IdTmp desc limit 1";
    $resultado = $con->query($sql);
    $rows = $resultado->num_rows;
    if($rows > 0){
        while($data = $resultado->fetch_assoc()){
            $fechadiahoy = $data['N590'];
        }
        $respuesta['MesEnCurso'] = $fechadiahoy;
    } else {
        $respuesta['MesEnCurso'] = '';
    } 

    $sql = "SELECT status, count(*) Total
    FROM yifi58ge_dbREFERIDO.tblafiliacion
    group by status
    ORDER BY FIELD(status,'NOREGISTRADO','REGISTRADO')";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $acumulado[] = array_merge($status,$data);
            if($data['status']=='REGISTRADO'){
               $resultTotalREG+=$data['Total']; 
            }
            if($data['status']=='NOREGISTRADO'){
               $resultTotalNOREG+=$data['Total'];
            }
        }
        $respuesta['Acumulado'] = $acumulado;
    } else {
        $respuesta['Acumulado'] = $status;
    }
 

    $sql = "SELECT status, count(*) Total
    FROM yifi58ge_dbREFERIDO.tblafiliacion a
    WHERE DATE_FORMAT(FechaHoraREG,'%b-%Y')='".$fechadiahoy."'
    group by status
    ORDER BY FIELD(status,'NOREGISTRADO','REGISTRADO')";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $mensual[] = array_merge($status,$data);
        }
        
        $respuesta['Mensual'] = $mensual;
    } else {
        $respuesta['Mensual'] = $status;
    }
    
    $resultTotalREGiPN=0;
    $resultTotalNOREGiPN=0;   
    $sql = "SELECT status, count(*) Total
    FROM yifi58ge_dbREFERIDO.tblafiliacion a
    INNER JOIN yifi58ge_dbVENTAS.tblventa v on a.beneficiaryId=v.NContrato
    WHERE
    STR_TO_DATE(v.N590,'%b-%Y')>=DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 3 MONTH),'%Y-%m-00')  and
    STR_TO_DATE(v.N590,'%b-%Y')<=STR_TO_DATE('".$fechadiahoy."','%b-%Y')
    group by status
    ORDER BY FIELD(status,'NOREGISTRADO','REGISTRADO')";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $acumuladoporfolionuevo[] =array_merge($status,$data);
            if($data['status']=='REGISTRADO'){
               $resultTotalREGiPN+=$data['Total']; 
            }
            if($data['status']=='NOREGISTRADO'){
               $resultTotalNOREGiPN+=$data['Total'];
            }
        }
        
        $respuesta['AcumuladoPorfolioNuevo'] = $acumuladoporfolionuevo;
    } else {
        $respuesta['AcumuladoPorfolioNuevo'] = $status;
    }
    
    $resultTotalREGiPW=0;
    $resultTotalNOREGiPW=0;  
    $sql = "SELECT status, count(*) Total
    FROM yifi58ge_dbREFERIDO.tblafiliacion a
    INNER JOIN yifi58ge_dbVENTAS.tblventa v on a.beneficiaryId=v.NContrato
    WHERE
    STR_TO_DATE(v.N590,'%b-%Y')>=DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 6 MONTH),'%Y-%m-00')  and
    STR_TO_DATE(v.N590,'%b-%Y')<=DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 4 MONTH),'%Y-%m-00')
    group by status
    ORDER BY FIELD(status,'NOREGISTRADO','REGISTRADO')";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $acumuladoporfoliowelcome[] = array_merge($status,$data);
            if($data['status']=='REGISTRADO'){
               $resultTotalREGiPW+=$data['Total']; 
            }
            if($data['status']=='NOREGISTRADO'){
               $resultTotalNOREGiPW+=$data['Total'];
            }            
        }
        
        $respuesta['AcumuladoPorfolioWelcome'] = $acumuladoporfoliowelcome;
    } else {
        $respuesta['AcumuladoPorfolioWelcome'] = $status;
    }

    $resultTotalREGiP=0;
    $resultTotalNOREGiP=0; 
    $sql = "SELECT status, count(*) Total
    FROM yifi58ge_dbREFERIDO.tblafiliacion a
    INNER JOIN yifi58ge_dbVENTAS.tblventa v on a.beneficiaryId=v.NContrato
    WHERE
    STR_TO_DATE(v.N590,'%b-%Y')<=DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 7 MONTH),'%Y-%m-00')
    group by status
    ORDER BY FIELD(status,'NOREGISTRADO','REGISTRADO')";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
        while($data = $resultado->fetch_assoc()){
            $acumuladoporfolio[] =array_merge($status,$data);
            if($data['status']=='REGISTRADO'){
               $resultTotalREGiP+=$data['Total']; 
            }
            if($data['status']=='NOREGISTRADO'){
               $resultTotalNOREGiP+=$data['Total'];
            }            
        }
        
        $respuesta['AcumuladoPorfolio'] = array(
                array('status' =>'NOREGISTRADO','Total'=>($resultTotalNOREG-$resultTotalNOREGiPN-$resultTotalNOREGiPW-$resultTotalNOREGiP+$resultTotalNOREGiP)),
                array('status' =>'REGISTRADO','Total'=>($resultTotalREG-$resultTotalREGiPN-$resultTotalREGiPW-$resultTotalNOREGiP+$resultTotalNOREGiP))
                );
    } else {
        $respuesta['AcumuladoPorfolio'] = $status;
    }
    
    //ACUMULATIVO MENSUAL
    $resultTotalACUREGVM=0;
    $resultTotalACUNOREGVM=0;  
    $sql = "SELECT status, count(*) Total
    FROM yifi58ge_dbREFERIDO.tblafiliacion a
    INNER JOIN yifi58ge_dbVENTAS.tblventa v on a.beneficiaryId=v.NContrato
    WHERE DATE_FORMAT(a.FechaHoraREG,'%b-%Y')='".$fechadiahoy."' and v.N590='".$fechadiahoy."'
    group by a.status
    ORDER BY FIELD(status,'NOREGISTRADO','REGISTRADO')";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $mensualventasnuevas[] = array_merge($status,$data);
            if($data['status']=='REGISTRADO'){
               $resultTotalACUREGVM+=$data['Total']; 
            }
            if($data['status']=='NOREGISTRADO'){
               $resultTotalACUNOREGVM+=$data['Total'];
            }            
        }
        
        $respuesta['MensualVentasNuevas'] = $mensualventasnuevas;
    } else {
        $respuesta['MensualVentasNuevas'] = $status;
    }

    $resultTotalACUREGPN=0;
    $resultTotalACUNOREGPN=0;  
    $sql = "SELECT status, count(*) Total
    FROM yifi58ge_dbREFERIDO.tblafiliacion a
    WHERE STR_TO_DATE('".$fechadiahoy."','%b-%Y')>=DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 3 MONTH),'%Y-%m-00')  and
    STR_TO_DATE('".$fechadiahoy."','%b-%Y')<=DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 2 MONTH),'%Y-%m-00')   
    group by a.status
    ORDER BY FIELD(status,'NOREGISTRADO','REGISTRADO')";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $mensualporfolionuevo[] = array_merge($status,$data);
            if($data['status']=='REGISTRADO'){
               $resultTotalACUREGPN+=$data['Total']; 
            }
            if($data['status']=='NOREGISTRADO'){
               $resultTotalACUNOREGPN+=$data['Total'];
            }            
        }
        
        $respuesta['MensualPorfolioNuevo'] = $mensualporfolionuevo;
    } else {
        $respuesta['MensualPorfolioNuevo'] = $status;
    }
    
    $resultTotalACUREGPW=0;
    $resultTotalACUNOREGPW=0;  
    $sql = "SELECT status, count(*) Total
    FROM yifi58ge_dbREFERIDO.tblafiliacion a
    WHERE STR_TO_DATE('".$fechadiahoy."','%b-%Y')>=DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 6 MONTH),'%Y-%m-00')  and
    STR_TO_DATE('".$fechadiahoy."','%b-%Y')<=DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 4 MONTH),'%Y-%m-00')   
    group by a.status
    ORDER BY FIELD(status,'NOREGISTRADO','REGISTRADO')";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $mensualporfoliowelcome[] = array_merge($status,$data);
            if($data['status']=='REGISTRADO'){
               $resultTotalACUREGPW+=$data['Total']; 
            }
            if($data['status']=='NOREGISTRADO'){
               $resultTotalACUNOREGPW+=$data['Total'];
            }            
        }
        
        $respuesta['MensualPorfolioWelcome'] = $mensualporfoliowelcome;
    } else {
        $respuesta['MensualPorfolioWelcome'] = $status;
    }      

    $resultTotalACUREGP=0;
    $resultTotalACUNOREGP=0;  
    $sql = "SELECT status, count(*) Total
    FROM yifi58ge_dbREFERIDO.tblafiliacion a
    WHERE STR_TO_DATE('".$fechadiahoy."','%b-%Y')<=DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 7 MONTH),'%Y-%m-00')  
    group by a.status
    ORDER BY FIELD(status,'NOREGISTRADO','REGISTRADO')";
    
    $resultado = $con->query($sql);
    
    $rows = $resultado->num_rows;
    
    if($rows > 0){
    
        while($data = $resultado->fetch_assoc()){
            $mensualporfolio[] = array_merge($status,$data);
            if($data['status']=='REGISTRADO'){
               $resultTotalACUREGP+=$data['Total']; 
            }
            if($data['status']=='NOREGISTRADO'){
               $resultTotalACUNOREGP+=$data['Total'];
            }
        }
        
        $respuesta['MensualPorfolio'] = $mensualporfolio;
    } else {
        $respuesta['MensualPorfolio'] = $status;
    }     
    
    echo json_encode($respuesta);