<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}

$ingresokit=0;
$ingresoextras=0;
$ingresototal=0;

$affectedrowAgenda = 0;

require '../config/db.php';
require '../config/conexion.php';
include '../helper/helper_validacion.php';
//FUNCIONES LOG
include 'log/insertLog.php'; //LOG TRANSAC
include 'log/insertLogVenta.php'; //LOG VENTA

$gestor = sanitizaCampo($_POST['gestor'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$gestor = htmlspecialchars($gestor);

$fechmod=date("Y-m-d H:i:s");

$idventa = sanitizaCampo($_POST['ediventa'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$idventa = htmlspecialchars($idventa);

$lblfechacierre_cert = sanitizaCampo($_POST['lblfechacierre_cert'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$lblfechacierre_cert = htmlspecialchars($lblfechacierre_cert);

if ($lblfechacierre_cert == '' || empty($lblfechacierre_cert)){
        $lblfechacierre_certgrabar=NULL;
    } else {
        $lblfechacierre_certconvert=  myUrlEncode($lblfechacierre_cert);
        $lblfechacierre_certgrabar=  format_date_Y_mm_dd(str_replace('/', '-', $lblfechacierre_certconvert));
    }

$lbltipocierre_cert = sanitizaCampo($_POST['lbltipocierre_cert'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$lbltipocierre_cert = htmlspecialchars($lbltipocierre_cert);

$lblmotivoincidencia_cert = sanitizaCampo($_POST['lblmotivoincidencia_cert'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$lblmotivoincidencia_cert = htmlspecialchars($lblmotivoincidencia_cert);

$lblsolucionincidencia_cert = sanitizaCampo($_POST['lblsolucionincidencia_cert'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$lblsolucionincidencia_cert = htmlspecialchars($lblsolucionincidencia_cert);

$hidden_inci_tecnica = sanitizaCampo($_POST['hidden_inci_tecnica'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$hidden_inci_tecnica = htmlspecialchars($hidden_inci_tecnica);

$gestor = sanitizaCampo($_POST['gestor'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$gestor = htmlspecialchars($gestor);

$hidden_hojacertificacion = sanitizaCampo($_POST['hidden_hojacertificacion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$hidden_hojacertificacion = htmlspecialchars($hidden_hojacertificacion);

$hidden_certificadovalidado = sanitizaCampo($_POST['hidden_certificadovalidado'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$hidden_certificadovalidado = htmlspecialchars($hidden_certificadovalidado);

$lblformapago_cert = sanitizaCampo($_POST['lblformapago_cert'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$lblformapago_cert = htmlspecialchars($lblformapago_cert);

$lblcomentario_cert = sanitizaCampo($_POST['lblcomentario_cert'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$lblcomentario_cert = htmlspecialchars($lblcomentario_cert);



if (empty($_POST['idcertventa'])){
    $idcertventa = NULL;
} else {
    $idcertventa = sanitizaCampo($_POST['idcertventa'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $idcertventa = htmlspecialchars($idcertventa);
}

$lblfechaapertura_cert = sanitizaCampo($_POST['lblfechaapertura_cert'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$lblfechaapertura_cert = htmlspecialchars($lblfechaapertura_cert);

$fecharegistroventa = date("Y-m-d H:i:s");

if ($idcertventa == NULL){
    $idcertventa = insertarCertificacion();
    if($idcertventa>0){
       $resultadoventa=actualizarVenta($idventa);

        //INSERTAR LOG HISTORIAL DE VENTA CERTIFICADA
        insertarCertificacionHist($idventa);
    
       die(json_encode(array('respuesta' => 'exito', 'id_registro' => $idcertventa)));
    }else{
        die(json_encode(array('respuesta' => 'error')));
    }
    
    
}else{
    $resultadocertificacion= actualizarCertificacion($idcertventa);
    $arrayVenta = consultaVentaCertificada($idventa);
    $resultadoventa=actualizarVenta($idventa);
    
    //INSERTAR LOG HISTORIAL DE VENTA CERTIFICADA
    insertarCertificacionHist($idventa);
    
    if($resultadocertificacion==0 && $resultadoventa == 0){
        die(json_encode(array('respuesta' => 'SinCambios')));

    }else if($resultadocertificacion>0 && $resultadoventa>0){
        $Ip = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
        $Usuario = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
        $Url = sanitizaCampo($_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa, 'sanitizeurl|scapestring|htmlspecialchars',$con);
        if(!empty($Url)){
        	$UrlLog = $Url.'=>IdVenta='.$idventa;
        }
        $Modificar = 'Modificar';
        $Navegador = sanitizaCampo($_SERVER['HTTP_USER_AGENT'], 'sanitizeint|scapestring|htmlspecialchars',$con);
                        
        try{
        	$result_exec= $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
        	$result_exec->bind_param('ssssss',$Ip,$Usuario,$fechmod,$UrlLog,$Modificar,$Navegador);
        	$result_exec->execute();
        	$idLogSeg = $con->insert_id;
        	$result_exec->close();
        } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
        }
        
        if ($resultadoventa > 0){
            insertLogVentaCertificada($idLogSeg, $arrayVenta);
        }
        die(json_encode(array('respuesta' => 'exito', 'id_registro' => $idcertventa)));
    }else if($resultadocertificacion>0 && $resultadoventa==0){
        
        die(json_encode(array('respuesta' => 'exito', 'id_registro' => $idcertventa)));

    }else if($resultadocertificacion==0 && $resultadoventa > 0){

        $Ip = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
        $Usuario = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
        $Url = sanitizaCampo($_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa, 'sanitizeurl|scapestring|htmlspecialchars',$con);
        if(!empty($Url)){
        	$UrlLog = $Url.'=>IdVenta='.$idventa;
        }
        $Modificar = 'Modificar';
        $Navegador = sanitizaCampo($_SERVER['HTTP_USER_AGENT'], 'sanitizeint|scapestring|htmlspecialchars',$con);
                        
        try{
        	$result_exec= $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
        	$result_exec->bind_param('ssssss',$Ip,$Usuario,$fechmod,$UrlLog,$Modificar,$Navegador);
        	$result_exec->execute();
        	$idLogSeg = $con->insert_id;
        	$result_exec->close();
        } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
        }
        
        if ($resultadoventa > 0){
            insertLogVentaCertificada($idLogSeg, $arrayVenta);
        }
        die(json_encode(array('respuesta' => 'exito', 'id_registro' => $idcertventa)));
    }else{
        die(json_encode(array('respuesta' => 'error')));
    }
    
}


function insertarCertificacionHist($idventa){
    global $con;
    
    global $idcertventa;
    global $idventa;
    global $gestor;
    global $lblfechaapertura_cert;
    global $lblfechacierre_certgrabar;
    global $lbltipocierre_cert;
    global $hidden_inci_tecnica;
    global $lblformapago_cert;
    global $lblcomentario_cert;
    global $fechmod;
    
    try{
        
        $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblcertificacionhist(IdCertificacionVenta, IdVenta, MatriculaGestor, FechaApertura, FechaCierre, TipoCierre, IncidenciaTecnica, FormaPago, Comentario, FechaHoraREG) VALUES(?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iissssssss',$idcertventa, $idventa, $gestor, $lblfechaapertura_cert, $lblfechacierre_cert, $lbltipocierre_cert, $hidden_inci_tecnica, $lblformapago_cert, $lblcomentario_cert, $fechmod);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
}



function actualizarVenta($idventa){
    
    global $con;
    global $hidden_certificadovalidado;
    global $gestor;
    global $hidden_hojacertificacion;
    global $idcertventa;
    global $lblfechaapertura_cert;
    global $fecharegistroventa;
    if(isset($lblfechaapertura_cert) && !empty($lblfechaapertura_cert)){
        $fecharegistroventa=$lblfechaapertura_cert;
    }else{
        $fecharegistroventa=$fecharegistroventa;
    }

    try{
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET  CertificadoValidado=?,HojaCertificacion=?,GestorCertVenta=?,IdCertVenta=?,FechaApertura=? WHERE IdVenta=?");
        $stmt->bind_param('sssisi',$hidden_certificadovalidado,$hidden_hojacertificacion,$gestor,$idcertventa,$fecharegistroventa, $idventa);
        $stmt->execute();
    
        $respuesta = $stmt->affected_rows;
            
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
}


function actualizarCertificacion($idcertventa){
    
    global $con;
    global $lblfechacierre_certgrabar;
    global $lbltipocierre_cert;
    global $lblmotivoincidencia_cert;
    global $hidden_inci_tecnica;
    global $lblsolucionincidencia_cert;
    global $lblformapago_cert;
    global $lblcomentario_cert;

    try{
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblcertificacionventa SET FechaCierre=?,TipoCierre=?,MotivoIncidencia=?,SolucionIncidencia=?,IncidenciaTecnica=?,FormaPago=?,Comentario=? WHERE IdCertVenta=?");
        $stmt->bind_param('sssssssi',  $lblfechacierre_certgrabar, $lbltipocierre_cert, $lblmotivoincidencia_cert, $lblsolucionincidencia_cert, $hidden_inci_tecnica,$lblformapago_cert,$lblcomentario_cert,$idcertventa);
        $stmt->execute();
    
        $respuesta = $stmt->affected_rows;
            
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
}


function insertarCertificacion(){
    
    global $con;
    
    global $lblfechacierre_certgrabar;
    global $lbltipocierre_cert;
    global $lblmotivoincidencia_cert;
    global $hidden_inci_tecnica;
    global $lblsolucionincidencia_cert;
    global $fecharegistroventa;
    global $lblformapago_cert;
    global $lblcomentario_cert;

    
    try {
        
        $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblcertificacionventa(FechaCierre, TipoCierre, MotivoIncidencia, SolucionIncidencia, FechaHoraREG, IncidenciaTecnica,FormaPago,Comentario) VALUES (?,?,?,?,?,?,?,?)");
        $stmt->bind_param('ssssssss',  $lblfechacierre_certgrabar, $lbltipocierre_cert, $lblmotivoincidencia_cert, $lblsolucionincidencia_cert, $fecharegistroventa, $hidden_inci_tecnica,$lblformapago_cert,$lblcomentario_cert);
        $stmt->execute();
        
        $respuesta = $con->insert_id;

        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
    }
    
    return $respuesta;
}


function stringtonull($val){
    
    if ($val == '' || empty($val) || !isset($val)){
        $resultado = NULL;
    }
    else {
        $resultado = $val;
    }
    
    return $resultado;
}

