<?php

    //SCRIPT PARA REGISTRAR LEADS DE CALL CENTER EN LA TABLA TBLLEADCC
    //NO CONFUNDIR CON LA TABLA LEADS DE TRANSFERENCIA
    include('is_logged.php');
    
    date_default_timezone_set('America/Lima');
    //Funciones para codificar al momento de grabar en Mysql
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }
    
    require_once '../config/db.php';
    require_once '../config/conexion.php';
    include dirname(__DIR__).'/helper/helper_validacion.php';

    $jsonArregloObj = $_POST['jsonArregloObj'];
    $ArregloObj = json_decode($jsonArregloObj);

    foreach ($ArregloObj as $clave => $valor) {
        
        $IdLead = sanitizaCampo($valor->elemento,'sanitizeint|scapestring|htmlspecialchars',$con);
        $Matricula = sanitizaCampo($valor->gestorMatricula,'sanitizestring|scapestring|htmlspecialchars',$con);
        $IdUsuario = obtenerIdUsuario($Matricula);
        
        $remarketing = 'SI';
        $fecharegistro = date("Y-m-d H:i:s");
        
        try{
            $stmt = $con->prepare("UPDATE tblLeadCC SET IdUsuarioRemarketing=?, Remarketing =?, FechaHoraRemarketing=? WHERE IdLeadCC = ?");
            $stmt->bind_param('issi', $IdUsuario, $remarketing, $fecharegistro, $IdLead);
            $stmt->execute();
            
            $rows = $stmt->affected_rows;
            
            if($rows > 0){
                $respuesta[] = array(
                        'respuesta' => 'exito',
                        'id' => $IdLead
                    );
                    
            } else {
                $respuesta[] = array(
                    'respuesta' => 'sincambios',
                    'id' => $IdLead,
                    'error' => $con->error,
                );
            }
            $stmt->close();
            
        } catch (\Exception $e) {
            $respuesta[] = array(
                'respuesta' => 'error',
                'mensaje' => $e
            );
        }
        
    }
    
    echo json_encode($respuesta);
    
    
    function obtenerIdUsuario($matriculaAgente){
        global $con;
        
        try {
            
        $stmtCategoria = $con->prepare("SELECT IdUsuario FROM yifi58ge_dbUSUARIO.tblusuario WHERE Matricula = ?");
        $stmtCategoria->bind_param('s', $matriculaAgente);
        $stmtCategoria->execute();
        $stmtCategoria->store_result();
        $stmtCategoria->bind_result($IdUsuario);
        $stmtCategoria->fetch();
        $stmtCategoria->close();
        
        return $IdUsuario;
    
     
        } catch (\Exception $e) {
          
        }        
        
        
    }