<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

$ingresokit=0;
$ingresoextras=0;
$ingresototal=0;

require '../config/db.php';
require '../config/conexion.php';
require_once '../helper/helper_validacion.php';
//FUNCIONES LOG
include 'log/insertLog.php'; //LOG TRANSAC
include 'log/insertLogCliente.php'; //LOG CLIENTE
include 'log/insertLogVenta.php'; //LOG VENTA
include 'log/insertLogAgenda.php'; //LOG AGENDA

//FUNCIONES DE VENTA
include 'funciones/Venta.php';

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';

$gestor = sanitizaCampo($_POST['gestor'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$gestor = htmlspecialchars($gestor);

$estvisita = sanitizaCampo($_POST['lblestvisita'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$estvisita = htmlspecialchars($estvisita);

$estadoventa = sanitizaCampo($_POST['lblestventa'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$estadoventa = htmlspecialchars($estadoventa);

$tipoventa = sanitizaCampo($_POST['lbltiventa'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$tipoventa = htmlspecialchars($categoria);

$categoria = sanitizaCampo($_POST['lblcategoria'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$categoria = htmlspecialchars($categoria);

$validarfechainst="";
$fechmod=date("Y-m-d H:i:s");

$idagenda = sanitizaCampo($_POST['lblidagenda'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$idagenda = htmlspecialchars($idagenda);

    $mesesautorizados = sanitizaCampo($_POST['lblextraautorizado'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $mesesautorizados = htmlspecialchars($mesesautorizados);

    $preciokit = sanitizaCampo($_POST['lblpreciokit'], 'sanitizefloat|scapestring|htmlspecialchars',$con);
    $preciokit = htmlspecialchars($preciokit);
    
    $totalextra = sanitizaCampo($_POST['lbltotalextra'], 'sanitizefloat|scapestring|htmlspecialchars',$con);
    $totalextra = htmlspecialchars($totalextra);
    

    $extraautorizado = sanitizaCampo($_POST['lblextraautorizado'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $extraautorizado = htmlspecialchars($extraautorizado);
    
    $formadepago = sanitizaCampo($_POST['lblformadepago'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $formadepago = htmlspecialchars($formadepago);

    $n590 = sanitizaCampo($_POST['lbl590'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $n590 = htmlspecialchars($n590);
    
    $PAI = sanitizaCampo($_POST['lblPAI'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $PAI = htmlspecialchars($PAI);
    
    $resumenventa = sanitizaCampo($_POST['lblresumenventa'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $resumenventa = htmlspecialchars($resumenventa);
    
    $idventa = sanitizaCampo($_POST['lblidventa'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $idventa = htmlspecialchars($idventa);
    
    $cancelado=NULL;
    $repercucion=NULL;
    $costo=NULL;
    $ncontrato=NULL;

    //$movivonoventa=$_POST['lblmovivonoventa'];
    //$competencia=$_POST['lblcompetencia'];
    
    $movivonoventa=NULL;
    $competencia=NULL;

    //Agenda
    $finstalacion = sanitizaCampo($_POST['lblfinstalacion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $finstalacion = htmlspecialchars($finstalacion);
    
    $hinstalacion = sanitizaCampo($_POST['lblhinstalacion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $hinstalacion = htmlspecialchars($hinstalacion);
    
    $fechaconvert=  myUrlEncode($finstalacion);
    $fechagrabar=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvert));
    $horaconvert=  myUrlEncode($hinstalacion);
    $horagrabar=  date("H:i", strtotime(str_replace("+"," ",$horaconvert)));
    $horagrabarcomparar=  date("H:i:s", strtotime(str_replace("+"," ",$horaconvert)));
    
    $instaladox = sanitizaCampo($_POST['lblinstaladox'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $instaladox = htmlspecialchars($instaladox);
    
    $tecnico = sanitizaCampo($_POST['lbltecnico'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $tecnico = htmlspecialchars($tecnico);
    
    $comentarioagenda = sanitizaCampo($_POST['lblcomentarioagenda'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $comentarioagenda = htmlspecialchars($comentarioagenda);
    
    $fecharegistroagenda = date("Y-m-d H:i:s");
    $fecharegistrofacturacion = date("Y-m-d H:i:s");
    $fecharegistroventa = date("Y-m-d H:i:s");
 
    $inviable = sanitizaCampo(utf8_decode($_POST['lblinviable']), 'sanitizestring|scapestring|htmlspecialchars',$con);
    $inviable = htmlspecialchars($inviable);

    if($PAI=="PAI 30x36"){
    
    $ingresokit=round((($preciokit+1080)/1.18),2);
    $ingresoextras=round(($totalextra/1.18),2);
    $ingresototal=($ingresokit+$ingresoextras);
    
    }
    else{
    
    $ingresokit=round((($preciokit)/1.18),2);
    $ingresoextras=round(($totalextra/1.18),2);
    $ingresototal=($ingresokit+$ingresoextras);
    }

    //POST NUEVOS

    $matricula = sanitizaCampo($_POST['lblmatricula'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $matricula = htmlspecialchars($matricula);
    
    $dc = sanitizaCampo($_POST['lbldc'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $dc = htmlspecialchars($dc);
    
    // $jefeventa=$_POST['lbljefeventa'];

    $hidden_HCertificacion = sanitizaCampo($_POST['hidden_HCertificacion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $hidden_HCertificacion = htmlspecialchars($hidden_HCertificacion);
    
    //INFORMACION ADICIONAL DE LA VENTA AGREGADA POR PILOTO ZEROVISION
    $lbltipokit = sanitizaCampo($_POST['lbltipokit'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $lbltipokit = htmlspecialchars($lbltipokit);
    //$lblclosingpack=$_POST['lblclosingpack'];
    //$lblprecioEspecial=$_POST['lblprecioEspecial'];
    $lblclosingpack="Ninguno";
    $lblprecioEspecial="Ninguno";    

    $lblCantExtras = sanitizaCampo($_POST['lblCantExtras'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $lblCantExtras = htmlspecialchars($lblCantExtras);

    $lblresultadoScoring = sanitizaCampo($_POST['lblresultadoScoring'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $lblresultadoScoring = htmlspecialchars($lblresultadoScoring);
    
    //OBJETO COTIZACION
    $lbljsonresumenventa = sanitizaCampo($_POST['lbljsonresumenventa'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $lbljsonresumenventa = htmlspecialchars($lbljsonresumenventa);
    
    // $ilblidcliente=$_POST['lblidcliente'];

    $lblobservacion = sanitizaCampo($_POST['lblobservacion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $lblobservacion = htmlspecialchars($lblobservacion);

    $hidGGCC = sanitizaCampo($_POST['hidGGCC'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $hidGGCC = htmlspecialchars($hidGGCC);
    
    $lblidggcc = sanitizaCampo($_POST['lblidggcc'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $lblidggcc = htmlspecialchars($lblidggcc);

    $lblnprospecto = sanitizaCampo($_POST['lblnprospecto'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $lblnprospecto = htmlspecialchars($lblnprospecto);
    
    $lblnprospectohidden = sanitizaCampo($_POST['lblnprospectohidden'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $lblnprospectohidden = htmlspecialchars($lblnprospectohidden);
    
//PROCSEO DE LA INFORMACION

$IdDocRP = sanitizaCampo($_POST['IdDocRP'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$IdDocRP = htmlspecialchars($IdDocRP);

$tipodoc = sanitizaCampo($_POST['lbltipodoc'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$tipodoc = htmlspecialchars($tipodoc);

$documento = sanitizaCampo($_POST['lbldocumento'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$documento = htmlspecialchars($documento);

//DOCUMENTO
if($dc==513){
        if ($IdDocRP == NULL){
         $resultadoDocumento = insertarDocumento();
         if ($resultadoDocumento > 0){
             $IdDocRP=$resultadoDocumento;
             }else{
             $IdDocRP=NULL;  
             }
         
        }else{
            $resultadoDocumento = actualizarDocumento($IdDocRP);
                if ($resultadoDocumento > 0){
                }else{
                }
        }
}



//ARRAY DE DATOS
$arrayVenta = consultaVentaComercial($idventa);
$arrayAgenda = consultaAgenda($idventa);

   if(editar_buscarProspecto($lblnprospecto,$lblnprospectohidden)==false){
        echo 2;
    }else{
        //ACTUALIZA VENTA Y RETORNA EL NUMERO DE FILAS AFECTADAS
        $resultadoventa = actualizarVenta($idventa); 
    }

//ACTUALIZA AGENDA Y RETORNA EL NUMERO DE FILAS AFECTADAS
$resultadoagenda=0;
/*
if($estadoventa=='AsignadaEvalTEC' || $estadoventa=='PendienteCotizacion'){

            //$comentarioagenda='In';
            //$fecharegistroagenda=$fechmod;

            //$sqlagenda=  mysqli_query($con, "UPDATE yifi58ge_dbVENTAS.tblagenda agen SET agen.FechaInst=NULL,agen.HoraInst=NULL,agen.InstaladoX=NULL,agen.MatriculaTec=NULL,agen.Comentario='Ingresa a Agenda',agen.Repercusion=NULL,agen.RepercusionCosto=NULL,agen.FechaHoraMODIF='".$fechmod."',agen.GestorAgenda='".$gestor."',agen.EstadoVenta='".$estadoventa."' WHERE agen.IdVenta='$idventa'");
            //$sqlagendahist=mysqli_query($con,"INSERT INTO yifi58ge_dbVENTAS.tblagendahist(IdAgenda, IdVenta,Comentario, FechaHoraREG,GestorAgenda,EstadoVenta) VALUES ('$idagenda','$idventa','Ingresa a Agenda','$fechmod','$gestor','$estadoventa')"); 
            
            //INSERTA LOG TRANSACCIONAL DE TABLA AGENDA
            //insertLogAgenda($idLogSeg, $arrayAgenda);
    $resultadoagenda=0;
}else{
    //$resultadoagenda = actualizarAgenda($idventa);
    $resultadoagenda=0;
}
*/

if ($resultadoagenda > 0 && $resultadoventa>0) {
    //INSERTA LOG HISTORIO DE AGENDA
    $sqlagendahist=insertarAgendaHist($idagenda);
    
    //INSERTA LOG DE SEGURIDAD
    // $result_exec= mysqli_query($con,"INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES ('".$_SERVER['REMOTE_ADDR']."','".$_SESSION['usuariosesion']."','".$fecharegistroventa."','".$_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa."','Modificar','".$_SERVER['HTTP_USER_AGENT']."')");
    // $idLogSeg = $con->insert_id;
    
    $Ip = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
    $Usuario = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $Url = sanitizaCampo($_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa, 'sanitizeurl|scapestring|htmlspecialchars',$con);
    if(!empty($Url)){
    	$UrlLog = $Url.'=>IdVenta='.$idventa;
    }
    $Modificar = 'Modificar';
    $Navegador = sanitizaCampo($_SERVER['HTTP_USER_AGENT'], 'sanitizeint|scapestring|htmlspecialchars',$con);
                    
    try{
    	$result_exec= $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
    	$result_exec->bind_param('ssssss',$Ip,$Usuario,$fecharegistroventa,$UrlLog,$Modificar,$Navegador);
    	$result_exec->execute();
    	$idLogSeg = $con->insert_id;
    	$result_exec->close();
    }  catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

    
    //INSERTA LOG TRANSACCIONAL DE TABLA VENTA
    insertLogVentaComercial($idLogSeg, $arrayVenta);
    //INSERTA LOG TRANSACCIONAL DE TABLA AGENDA
    insertLogAgenda($idLogSeg, $arrayAgenda);
    
    echo 1;
    
}
else if ($resultadoagenda == 0 && $resultadoventa>0){
        
        if($estadoventa=='AsignadaEvalTEC' || $estadoventa=='PendienteCotizacion'){
            //$comentarioagenda='Ingresa a Agenda';
            $fecharegistroagenda=$fechmod;

            $sqlagenda=  $con->prepare("UPDATE yifi58ge_dbVENTAS.tblagenda agen SET agen.FechaInst=NULL,agen.HoraInst=NULL,agen.InstaladoX=NULL,agen.MatriculaTec=NULL,agen.Comentario=?,agen.Repercusion=NULL,agen.RepercusionCosto=NULL,agen.FechaHoraMODIF=?,agen.GestorAgenda=?,agen.EstadoVenta=? WHERE agen.IdVenta=? ");
            $sqlagenda->bind_param('ssssi',$comentarioagenda,$fechmod,$gestor,$estadoventa,$idventa);
            $sqlagenda->execute();
            
            
            $sqlagendahist=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblagendahist(IdAgenda, IdVenta,Comentario, FechaHoraREG,GestorAgenda,EstadoVenta) VALUES (?,?,?,?,?,?)"); 
            $sqlagendahist->bind_param('iissss',$idagenda,$idventa,$comentarioagenda,$fechmod,$gestor,$estadoventa);
            $sqlagendahist->execute();
            
            //INSERTA LOG TRANSACCIONAL DE TABLA AGENDA
            insertLogAgenda($idLogSeg, $arrayAgenda);
              
            
        }
    
          if($estadoventa=='PendienteData' || $estadoventa=='PendienteAgenda'){
                  
            $comentarioagenda='Ingresa a Agenda';
            $fecharegistroagenda=$fechmod;

            $sqlagenda=  $con->prepare("UPDATE yifi58ge_dbVENTAS.tblagenda agen SET agen.FechaInst=NULL,agen.HoraInst=NULL,agen.InstaladoX=NULL,agen.MatriculaTec=NULL,agen.Comentario='Ingresa a Agenda',agen.Repercusion=NULL,agen.RepercusionCosto=NULL,agen.FechaHoraMODIF=?,agen.GestorAgenda=?,agen.EstadoVenta=? WHERE agen.IdVenta=? ");
            $sqlagenda->bind_param('sssi',$fechmod,$gestor,$estadoventa,$idventa);
            $sqlagenda->execute();
            
            $comentarioInsertVenta = 'Ingresa a Agenda';
            $sqlagendahist=$con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblagendahist(IdAgenda, IdVenta,Comentario, FechaHoraREG,GestorAgenda,EstadoVenta) VALUES (?,?,?,?,?,?)"); 
            $sqlagendahist->bind_param('iissss',$idagenda,$idventa,$comentarioInsertVenta,$fechmod,$gestor,$estadoventa);
            $sqlagendahist->execute();
            
            //INSERTA LOG TRANSACCIONAL DE TABLA AGENDA
            insertLogAgenda($idLogSeg, $arrayAgenda);
              
          }
    
    //INSERTA LOG DE SEGURIDAD
    // $result_exec= mysqli_query($con,"INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES ('".$_SERVER['REMOTE_ADDR']."','".$_SESSION['usuariosesion']."','".$fecharegistroventa."','".$_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa."','Modificar','".$_SERVER['HTTP_USER_AGENT']."')");
    // $idLogSeg = $con->insert_id;
    
    $Ip = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
    $Usuario = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $Url = sanitizaCampo($_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa, 'sanitizeurl|scapestring|htmlspecialchars',$con);
    if(!empty($Url)){
    	$UrlLog = $Url.'=>IdVenta='.$idventa;
    }
    $Modificar = 'Modificar';
    $Navegador = sanitizaCampo($_SERVER['HTTP_USER_AGENT'], 'sanitizeint|scapestring|htmlspecialchars',$con);
                    
    try{
    	$result_exec= $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
    	$result_exec->bind_param('ssssss',$Ip,$Usuario,$fecharegistroventa,$UrlLog,$Modificar,$Navegador);
    	$result_exec->execute();
    	$idLogSeg = $con->insert_id;
    	$result_exec->close();
    }  catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
    //INSERTA LOG TRANSACCIONAL DE TABLA VENTA
    insertLogVentaComercial($idLogSeg, $arrayVenta);
    
    echo 1;
}
else if ($resultadoagenda >0 && $resultadoventa==0){
    
        //INSERTA LOG HISTORIO DE AGENDA
    $sqlagendahist=insertarAgendaHist($idagenda);
    //INSERTA LOG DE SEGURIDAD
    $Ip = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
    $Usuario = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $Url = sanitizaCampo($_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa, 'sanitizeurl|scapestring|htmlspecialchars',$con);
    if(!empty($Url)){
    	$UrlLog = $Url.'=>IdVenta='.$idventa;
    }
    $Modificar = 'Modificar';
    $Navegador = sanitizaCampo($_SERVER['HTTP_USER_AGENT'], 'sanitizeint|scapestring|htmlspecialchars',$con);
                    
    try{
    	$result_exec= $con->prepare("INSERT INTO yifi58ge_dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
    	$result_exec->bind_param('ssssss',$Ip,$Usuario,$fecharegistroventa,$UrlLog,$Modificar,$Navegador);
    	$result_exec->execute();
    	$idLogSeg = $con->insert_id;
    	$result_exec->close();
    }  catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    //INSERTA LOG TRANSACCIONAL DE TABLA AGENDA
    insertLogAgenda($idLogSeg, $arrayAgenda);
    
    echo 1;
}
else if ($resultadoagenda==0 && $resultadoventa==0){
    echo 0;
}
else {
    echo -1;
}


function actualizarVenta($idventa){
    
    global $con;
    
    global $categoria;
    global $tipoventa;
    global $preciokit;
    global $totalextra;
    global $ingresokit;
    global $ingresoextras;
    global $ingresototal;
    global $estadoventa;
    global $extraautorizado;
    global $mesesautorizados;
    global $n590;
    global $formadepago;
    global $PAI;
    global $resumenventa;
    global $estvisita;
    global $movivonoventa;
    global $competencia;
    global $hidden_HCertificacion;
    
    global $lbltipokit;
    global $lblclosingpack;
    global $lblprecioEspecial;
    global $lblCantExtras;
    global $lblresultadoScoring;
    global $lbljsonresumenventa;
    global $lblobservacion;
    global $hidGGCC;
    global $lblidggcc;
    global $lblnprospecto;
    
    try{
        
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblventa v SET 
        v.CategoriaVenta=?,
        v.TipoVenta=?,
        v.PrecioKit=?,
        v.TotalExtra=?,
        v.IngresoKIT=?,
        v.IngresoExtras=?,
        v.IngresoTotal=?,
        v.EstadoVenta=?,
        v.ExtraAutorizado=?,
        v.MesesAutorizado=?,
        v.N590=?,
        v.FormaPago=?,
        v.PAI=?,
        v.ResumenVenta=?,
        v.EstadoVisita=?,
        v.PrecioKITOriginal=?,
        v.TotalExtraOriginal=?,
        v.ExtraAutorizadoOriginal=?,
        v.MesesAutorizadoOriginal=?,
        v.FormaPagoOriginal=?,
        v.PAIOriginal=?,
        v.ResumenVentaOriginal=?,
        v.MotivoNoVenta=?,
        v.Competencia=?,
        v.HojaCertificacion=?,
        v.TipoKIT=?,
        v.TipoKITOriginal=?,
        v.ClosingPack=?,
        v.PrecioEspecial=?,
        v.CantidadExtras=?,
        v.CantidadExtrasOriginal=?,
        v.ScoringRP=?,
        v.objCotizacion=?,
        v.Observacion=?,
        v.GGCC=?,
        v.IdGGCC=?,
        v.NProspecto=?
        WHERE v.IdVenta=?");
          $stmt->bind_param('ssdddddssssssssddssssssssssssiissssssi', $categoria, $tipoventa, $preciokit, $totalextra, $ingresokit, $ingresoextras, $ingresototal, $estadoventa, $extraautorizado, $mesesautorizados, $n590, $formadepago, $PAI, $resumenventa, $estvisita,$preciokit,$totalextra,$extraautorizado,$mesesautorizados,$formadepago,$PAI,$resumenventa,$movivonoventa,$competencia, $hidden_HCertificacion, $lbltipokit, $lbltipokit, $lblclosingpack, $lblprecioEspecial, $lblCantExtras, $lblCantExtras, $lblresultadoScoring,$lbljsonresumenventa, $lblobservacion,$hidGGCC,$lblidggcc,$lblnprospecto,$idventa);
        $stmt->execute();

        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function actualizarAgenda($idventa){
    
    global $con;
    
    
    global $fechagrabar;
    global $horagrabar;
    global $instaladox;
    global $tecnico;
    global $comentarioagenda;
    global $fecharegistroagenda;
    global $inviable;
    global $gestor;
    global $estadoventa;
    
    try{
        
        $stmt = $con->prepare("UPDATE yifi58ge_dbVENTAS.tblagenda SET FechaInst=?, HoraInst=?, InstaladoX=?, MatriculaTec=?, Comentario=?, MotivoInviable=?, GestorAgenda=?, EstadoVenta=? WHERE IdVenta=?");
        $stmt->bind_param('ssssssssi', $fechagrabar, $horagrabar, $instaladox, $tecnico, $comentarioagenda, $inviable, $gestor, $estadoventa, $idventa);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function insertarAgendaHist($idagenda){
    global $con;
    
    
    

    global $idventa;
    global $fechagrabar;
    global $horagrabar;
    global $instaladox;
    global $tecnico;
    global $comentarioagenda;
    global $fecharegistroagenda;
  

    global $gestor;
    global $estadoventa;

    
    
    try{
        
        $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tblagendahist(IdAgenda, IdVenta, FechaInst,HoraInst,InstaladoX, MatriculaTec, Comentario, FechaHoraREG,GestorAgenda,EstadoVenta) VALUES(?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iissssssss',$idagenda,$idventa, $fechagrabar, $horagrabar, $instaladox, $tecnico, $comentarioagenda, $fecharegistroagenda, $gestor, $estadoventa);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}


function stringtonull($val){
    
    if ($val == '' || empty($val)){
        $resultado = NULL;
    }
    else if(!isset($val)){
        $resultado = NULL;
    }
    else {
        $resultado = $val;
    }
    
    return $resultado;
}

//Funcion nueva Documento
function insertarDocumento(){
    global $con;
    global $tipodoc, $documento, $fecharegistro;
    if(empty($tipodoc) && empty($documento)){
        return 0;
    }else{
        try {
    
          $stmt = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tbldocumento(TipoDocumento, Documento, FechaHoraREG) VALUES(?, ?, ?)");
          $stmt->bind_param('sss', $tipodoc,$documento,$fecharegistro);
            $stmt->execute();
            $respuesta = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
    
        return $respuesta;
    }

}

function actualizarDocumento($IdDocRP){
    global $con;
    global $tipodoc, $documento;
    if(empty($tipodoc) && empty($documento)){
        return 0;
    }else{
          try{
        $stmt = $con->prepare("UPDATE tbldocumento SET TipoDocumento=?, Documento=? WHERE IdDoc = ?");
        $stmt->bind_param('ssi', $tipodoc, $documento, $IdDocRP);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();  
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    return $respuesta;  
    }
}


