<?php
include('is_logged.php');

if (isset($_GET['term'])){
include '../config/db.php';
include '../config/conexion.php';
include '../helper/helper_validacion.php';

$return_arr = array();
/* If connection to database, run sql statement. */

if ($con)
{

$q = sanitizaCampo($_GET['term'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$q = "%{$q}%";

    try{
        $stmt = $con->prepare("SELECT u.IdUsuario,u.Matricula,u.CC,CONCAT(u.Nombres,' ',u.Apellidos) NombComercial FROM yifi58ge_dbUSUARIO.tblusuario u  INNER JOIN yifi58ge_dbUSUARIO.tblarea a on a.IdArea=u.IdArea INNER JOIN yifi58ge_dbUSUARIO.tblusuario m on m.Matricula=u.Manager WHERE u.Matricula LIKE ? AND a.LN='11' LIMIT 0,50");
        $stmt->bind_param('s', $q);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdUsuario,$Matricula,$CC,$NombComercial);
        if ($stmt->num_rows > 0) {
            while ($stmt->fetch()){
    		$row_array['value'] = $Matricula." - ".$NombComercial;
    		$row_array['idusuario']=$IdUsuario;
    		$row_array['matricula']=$Matricula;
    		$row_array['comercial']=$NombComercial;
            array_push($return_arr,$row_array);
    	    }
            
        }
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

	
}


echo json_encode($return_arr);

}