<?php

include('is_logged.php');
require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';


$idsuario = sanitizaCampo($_GET['idsuario'], 'sanitizeint|scapestring|htmlspecialchars', $con);
$condicion = sanitizaCampo($_GET['condicion'], 'sanitizestring|scapestring|htmlspecialchars', $con);
$fecha = sanitizaCampo($_GET['fecha'], 'sanitizestring|scapestring|htmlspecialchars', $con);

$arreglo=NULL;

    $consultaquery = "Select u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Comercial,u.Categoria,u.CC,u.Manager from yifi58ge_dbUSUARIO.tblusuario u where u.IdUsuario=?";    
	
	try{       
        $stmt = $con->prepare($consultaquery);
        $stmt->bind_param('i', $idsuario);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($VMatri,$VCC,$Vcomercial,$VCategoria,$VManager);
        $stmt->fetch();
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

//Inicio de Visitas


if($VCategoria=='DEL'){

if($condicion=='visitas'){

$query="SELECT v.IdVenta,
v.EstadoVenta,
v.TipoVenta,
v.CC DC,
u.IdUsuario,
CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
v.Segmento,
v.NProspecto,
v.NContrato,
c.NombApellido Cliente,
v.CategoriaVenta,
v.FechaVisita,
v.HoraVisita,
v.PrecioKit,
v.TotalExtra,
v.ExtraAutorizado,
v.N590,
a.InstaladoX,
DATE_FORMAT(a.FechaInst, '%d/%m/%Y') FechaInst,
TIME_FORMAT(a.HoraInst,'%r') HoraInst,
a.Comentario
FROM yifi58ge_dbVENTAS.tblventa v INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=v.IdUsuario 
INNER JOIN yifi58ge_dbVENTAS.tblagenda a ON a.IdVenta=v.IdVenta 
INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente 
WHERE v.CCOriginal='?' and v.CategoriaVenta!='Anulada' and v.CCOriginal<>'511'  and v.MesVisita=? and (v.EstadoVisita='Asignada' or v.EstadoVisita='Vendida' or v.EstadoVisita='NoVendida')";




	try{       
        $stmt = $con->prepare($query);
        $stmt->bind_param('ss', $VCC, $fecha);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdVenta, $EstadoVenta, $TipoVenta, $DC, $IdUsuario, $Comercial, $Segmento, $NProspecto, $NContrato, $Cliente, $CategoriaVenta, $FechaVisita, $HoraVisita, $PrecioKit, $TotalExtra, $ExtraAutorizado, $N590, 
        $InstaladoX, $FechaInst, $HoraInst, $Comentario);
        
        if($stmt->num_rows > 0){
            while($data = $stmt->fetch()){
                $arreglo[] = array_map("utf8_encode",$data); //array_map("utf8_encode",$data)  este codigo nos ayuda a muestrar caracteres diferentes
                unset($data);     
            }
        }

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

}

if($condicion=='agendadas'){

$query="SELECT v.IdVenta,
v.EstadoVenta,
v.TipoVenta,
v.CC DC,
u.IdUsuario,
CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
v.Segmento,
v.NProspecto,
v.NContrato,
c.NombApellido Cliente,
v.CategoriaVenta,
v.FechaVisita,
v.HoraVisita,
v.PrecioKit,
v.TotalExtra,
v.ExtraAutorizado,
v.N590,
a.InstaladoX,
DATE_FORMAT(a.FechaInst, '%d/%m/%Y') FechaInst,
TIME_FORMAT(a.HoraInst,'%r') HoraInst,
a.Comentario
FROM yifi58ge_dbVENTAS.tblventa v INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=v.IdUsuario 
INNER JOIN yifi58ge_dbVENTAS.tblagenda a ON a.IdVenta=v.IdVenta 
INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente 
WHERE v.CC='?'  and v.N590=? and (v.EstadoVenta='AgendadaDEL' or v.EstadoVenta='AgendadaTEC')";

	try{       
        $stmt = $con->prepare($query);
        $stmt->bind_param('ss', $VCC, $fecha);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdVenta, $EstadoVenta, $TipoVenta, $DC, $IdUsuario, $Comercial, $Segmento, $NProspecto, $NContrato, $Cliente, $CategoriaVenta, $FechaVisita, $HoraVisita, $PrecioKit, $TotalExtra, $ExtraAutorizado, $N590, 
        $InstaladoX, $FechaInst, $HoraInst, $Comentario);
        
        if($stmt->num_rows > 0){
            while($data = $stmt->fetch()){
                $arreglo[] = array_map("utf8_encode",$data); //array_map("utf8_encode",$data)  este codigo nos ayuda a muestrar caracteres diferentes
                unset($data);     
            }
        }

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

}

if($condicion=='instaladas'){

$query="SELECT v.IdVenta,
v.EstadoVenta,
v.TipoVenta,
v.CC DC,
u.IdUsuario,
CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
v.Segmento,
v.NProspecto,
v.NContrato,
c.NombApellido Cliente,
v.CategoriaVenta,
v.FechaVisita,
v.HoraVisita,
v.PrecioKit,
v.TotalExtra,
v.ExtraAutorizado,
v.N590,
a.InstaladoX,
DATE_FORMAT(a.FechaInst, '%d/%m/%Y') FechaInst,
TIME_FORMAT(a.HoraInst,'%r') HoraInst,
a.Comentario
FROM yifi58ge_dbVENTAS.tblventa v INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=v.IdUsuario 
INNER JOIN yifi58ge_dbVENTAS.tblagenda a ON a.IdVenta=v.IdVenta 
INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente 
WHERE v.CC=?  and v.N590=? and (v.EstadoVenta='Instalada'OR v.EstadoVenta =  'Nodoc' OR v.EstadoVenta =  'DocEnvi' OR v.EstadoVenta =  'PorFacturar' OR v.EstadoVenta =  'Incidencia' OR v.EstadoVenta =  'incidenciaGestValija' OR v.EstadoVenta =  'incidenciaGestCorreo' OR v.EstadoVenta =  'Facturada')";


	try{       
        $stmt = $con->prepare($query);
        $stmt->bind_param('ss', $VCC, $fecha);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdVenta, $EstadoVenta, $TipoVenta, $DC, $IdUsuario, $Comercial, $Segmento, $NProspecto, $NContrato, $Cliente, $CategoriaVenta, $FechaVisita, $HoraVisita, $PrecioKit, $TotalExtra, $ExtraAutorizado, $N590, 
        $InstaladoX, $FechaInst, $HoraInst, $Comentario);
        
        if($stmt->num_rows > 0){
            while($data = $stmt->fetch()){
                $arreglo[] = array_map("utf8_encode",$data); //array_map("utf8_encode",$data)  este codigo nos ayuda a muestrar caracteres diferentes
                unset($data);     
            }
        }

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
}

if($condicion=='facturadas'){

$query="SELECT v.IdVenta,
v.EstadoVenta,
v.TipoVenta,
v.CC DC,
u.IdUsuario,
CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
v.Segmento,
v.NProspecto,
v.NContrato,
c.NombApellido Cliente,
v.CategoriaVenta,
v.FechaVisita,
v.HoraVisita,
v.PrecioKit,
v.TotalExtra,
v.ExtraAutorizado,
v.N590,
a.InstaladoX,
DATE_FORMAT(a.FechaInst, '%d/%m/%Y') FechaInst,
TIME_FORMAT(a.HoraInst,'%r') HoraInst,
a.Comentario
FROM yifi58ge_dbVENTAS.tblventa v INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=v.IdUsuario 
INNER JOIN yifi58ge_dbVENTAS.tblagenda a ON a.IdVenta=v.IdVenta 
INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente 
WHERE v.CC=?  and v.N590=? and (v.EstadoVenta =  'Nodoc' OR v.EstadoVenta =  'DocEnvi' OR v.EstadoVenta =  'PorFacturar' OR v.EstadoVenta =  'Incidencia' OR v.EstadoVenta =  'incidenciaGestValija' OR v.EstadoVenta =  'incidenciaGestCorreo' OR v.EstadoVenta =  'Facturada')";


    	try{       
        $stmt = $con->prepare($query);
        $stmt->bind_param('ss', $VCC, $fecha);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdVenta, $EstadoVenta, $TipoVenta, $DC, $IdUsuario, $Comercial, $Segmento, $NProspecto, $NContrato, $Cliente, $CategoriaVenta, $FechaVisita, $HoraVisita, $PrecioKit, $TotalExtra, $ExtraAutorizado, $N590, 
        $InstaladoX, $FechaInst, $HoraInst, $Comentario);
        
        if($stmt->num_rows > 0){
            while($data = $stmt->fetch()){
                $arreglo[] = array_map("utf8_encode",$data); //array_map("utf8_encode",$data)  este codigo nos ayuda a muestrar caracteres diferentes
                unset($data);     
            }
        }

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
}



}

else if($VCategoria=='JE' || $VCategoria=='COACH'){

if($VCC=='511'){

}else{
if($condicion=='visitas'){

    $query="SELECT v.IdVenta,
    v.EstadoVenta,
    v.TipoVenta,
    v.CC DC,
    u.IdUsuario,
    CONCAT(u.Nombres,' ',u.Apellidos) Comercial,
    v.Segmento,
    v.NProspecto,
    v.NContrato,
    c.NombApellido Cliente,
    v.CategoriaVenta,
    v.FechaVisita,
    v.HoraVisita,
    v.PrecioKit,
    v.TotalExtra,
    v.ExtraAutorizado,
    v.N590,
    a.InstaladoX,
    DATE_FORMAT(a.FechaInst, '%d/%m/%Y') FechaInst,
    TIME_FORMAT(a.HoraInst,'%r') HoraInst,
    a.Comentario
    FROM yifi58ge_dbVENTAS.tblventa v INNER JOIN yifi58ge_dbUSUARIO.tblusuario u ON u.IdUsuario=v.IdUsuario 
    INNER JOIN yifi58ge_dbVENTAS.tblagenda a ON a.IdVenta=v.IdVenta 
    INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente 
    WHERE v.CategoriaVenta!='Anulada' and (v.Matricula=? or u.Manager=?) and v.CCOriginal<>'511'  and v.MesVisita=? and (v.EstadoVisita='Asignada' or v.EstadoVisita='Vendida' or v.EstadoVisita='NoVendida')";

	try{       
        $stmt = $con->prepare($query);
        $stmt->bind_param('ss', $VMatri, $VMatri, $fecha);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdVenta, $EstadoVenta, $TipoVenta, $DC, $IdUsuario, $Comercial, $Segmento, $NProspecto, $NContrato, $Cliente, $CategoriaVenta, $FechaVisita, $HoraVisita, $PrecioKit, $TotalExtra, $ExtraAutorizado, $N590, 
        $InstaladoX, $FechaInst, $HoraInst, $Comentario);
        
        if($stmt->num_rows > 0){
            while($data = $stmt->fetch()){
                $arreglo[] = array_map("utf8_encode",$data); //array_map("utf8_encode",$data)  este codigo nos ayuda a muestrar caracteres diferentes
                unset($data);     
            }
        }

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }    
    
    
}

}

}

else if($VCategoria=='MST' || $VCategoria=='VET' || $VCategoria=='N3' || $VCategoria=='N2' || $VCategoria=='N1' || $VCategoria=='ELI/MST'){

if($VCC=='511'){

}else{

$query="";

}

}




// Fin de Visitas




$resultado=mysqli_query($con, $query);














if(!$resultado){
    die("Error");
}else{
   echo json_encode($arreglo);
}


mysqli_free_result($resultado);
mysqli_close($con);
