<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include '../helper/helper_validacion.php';

 if(isset($_POST["idarea"]))  
 {  
     $idArea = sanitizaCampo($_POST["idarea"],'sanitizeint|scapestring|htmlspecialchars',$con);
     $idArea = htmlspecialchars($idArea);
     
      $query = $con->prepare("SELECT d.CC, a.LN FROM yifi58ge_dbUSUARIO.tblarea a
INNER JOIN yifi58ge_dbUSUARIO.tbldepartamento d ON d.IdDpto = a.IdDpto
WHERE a.IdArea = ?"); 
      $query->bind_param('i',$idArea);
      $query->execute();
      $query->store_result();
      $query->bind_result(
          $CCRow,
          $LNRow
          );
          
      $return_arr = array();
      while($query->fetch()){
         $row_array['CC'] =$CCRow;
         $row_array['LN'] =$LNRow;
        
         array_push($return_arr,array_map("utf8_encode",$row_array)); //o este
        }
      echo json_encode($return_arr[0]);
 }  

$query->close();
