<?php

require_once '../config/db.php';
require_once '../config/conexion.php';



$json = file_get_contents('php://input');
$data = json_decode($json);

if(isset($data->mesvisita)){
    $fechadiahoy= $data->mesvisita;
} else {
    $fechadiahoy= 'Oct-2020';
}


$deleaciones = array(
    array('Id' =>150, 'Titulo'=>'SURCO', 'Delegado'=>'B. MURGA'),
    array('Id' =>151, 'Titulo'=>'LIMA SUR', 'Delegado'=>'H. VIGO'),     
    array('Id' =>152, 'Titulo'=>'LIMA ESTE', 'Delegado'=>'C. CUNEO'), 
    array('Id' =>153, 'Titulo'=>'LIMA CENTRO', 'Delegado'=>'C. ALMEIDA'), 
    array('Id' =>154, 'Titulo'=>'MIRAFLORES', 'Delegado'=>'D. ADELL'), 
    array('Id' =>155, 'Titulo'=>'LIMA NORTE 1', 'Delegado'=>'F. VERA'),     
    array('Id' =>156, 'Titulo'=>'LIMA OESTE', 'Delegado'=>'J. TORREGROSA'),
    array('Id' =>157, 'Titulo'=>'LA MOLINA', 'Delegado'=>'J. UGAZ'),
    array('Id' =>158, 'Titulo'=>'LIMA NORTE 2', 'Delegado'=>'J. BARNUEVO'),
    array('Id' =>159, 'Titulo'=>'LINCE', 'Delegado'=>'J. GOICOCHEA'),
    array('Id' =>120, 'Titulo'=>'TRUJILLO', 'Delegado'=>'J. ROJAS JVD'), 
    array('Id' =>200, 'Titulo'=>'PIURA', 'Delegado'=>'J.VALENCIA JVD'), 
    array('Id' =>41, 'Titulo'=>'AREQUIPA NORTE', 'Delegado'=>'C. MOSCOSO'),
    array('Id' =>40, 'Titulo'=>'AREQUIPA SUR', 'Delegado'=>'O. MEIGGS'),
    array('Id' =>100, 'Titulo'=>'ICA', 'Delegado'=>'C. HUAZO'),
    array('Id' =>140, 'Titulo'=>'CHICLAYO', 'Delegado'=> 'A. SOTOMAYOR'),
    array('Id' =>513, 'Titulo'=>'GGCC', 'Delegado'=> 'C. TELLO')
);

//var_dump($deleaciones);

$arregloDatos = array();

$totalVisitas = 0;
$totalVisitasAsignadas = 0;
$totalVisitasAnuladasOP= 0;
$totalVisitasAnuladasTEC= 0;
$totalVisitasAnuladasCLI= 0;
$totalVisitasVenta= 0;
$totalVisitasNoVenta= 0;
$totalVisitasReAsignadas= 0;
$totalVisitasReAsignadasActual= 0;
$totalVisitasReAsginadasActualDiaMenos= 0;
$totalVisitasCheckIN= 0;

$arregloVisitasTotales = consultaVisitas();
$arregloVisitasAsginadas = consultaVisitasAsignadas();
$arregloVisitasAnuladasOP = consultaVisitasAnuladaOP();
$arregloVisitasAnuladasTEC = consultaVisitasAnuladaTEC();
$arregloVisitasAnuladasCLI =  consultaVisitasAnuladaCLI();
$arregloVisitasVenta  = consultaVisitasVENTA();
$arregloVisitasNoVenta = consultaVisitasNoVenta();

$arregloVisitasReAsignadas = consultaVisitasReAsignadas();
$arregloVisitasReAsignadasActual = consultaVisitasReAsignadasActual();
$arregloVisitasReAsginadasActualDiaMenos = consultaVisitasReAsignadasActualDiaMenos();
$arregloVisitasCheckIN = consultaVisitasCheckIN();

for($i=0; $i<count($deleaciones); $i++){
    
    $delegacion = $deleaciones[$i]['Id'];
    $cantidadVisitas = cantidadVisitas($delegacion, $arregloVisitasTotales);
    $cantidadVisitasAsginadas = cantidadVisitas($delegacion, $arregloVisitasAsginadas);
    $cantidadVisitasAnuladasOP = cantidadVisitas($delegacion, $arregloVisitasAnuladasOP);
    $cantidaVisitasAnuladasTEC = cantidadVisitas($delegacion, $arregloVisitasAnuladasTEC);
    $cantidaVisitasAnuladasCLI =  cantidadVisitas($delegacion, $arregloVisitasAnuladasCLI);
    $cantidadVisitasVenta = cantidadVisitas($delegacion, $arregloVisitasVenta);
    $cantidadVisitasNoVenta = cantidadVisitas($delegacion, $arregloVisitasNoVenta);
    $cantidadVisitasReAsignadas = cantidadVisitas($delegacion, $arregloVisitasReAsignadas);
    $cantidadVisitasReAsignadasActual = cantidadVisitas($delegacion, $arregloVisitasReAsignadasActual);
    $cantidadVisitasReAsginadasActualDiaMenos = cantidadVisitas($delegacion, $arregloVisitasReAsginadasActualDiaMenos);
    $cantidadVisitasCheckIN = cantidadVisitas($delegacion, $arregloVisitasCheckIN);
    
    $porcentajeCheckIn = porcentaje($cantidadVisitasCheckIN, $cantidadVisitasReAsginadasActualDiaMenos);
    
    $totalVisitas += $cantidadVisitas;
    $totalVisitasAsignadas += $cantidadVisitasAsginadas;
    $totalVisitasAnuladasOP += $cantidadVisitasAnuladasOP;
    $totalVisitasAnuladasTEC += $cantidaVisitasAnuladasTEC;
    $totalVisitasAnuladasCLI += $cantidaVisitasAnuladasCLI;
    $totalVisitasVenta += $cantidadVisitasVenta;
    $totalVisitasNoVenta += $cantidadVisitasNoVenta;
    $totalVisitasReAsignadas += $cantidadVisitasReAsignadas;
    $totalVisitasReAsignadasActual += $cantidadVisitasReAsignadasActual;
    $totalVisitasReAsginadasActualDiaMenos += $cantidadVisitasReAsginadasActualDiaMenos;
    $totalVisitasCheckIN += $cantidadVisitasCheckIN;
    
    
    $arregloDatos[$i] = array(
            'Delegacion' => $deleaciones[$i],
            'Visitas' => $cantidadVisitas,
            'VisitasAsignadas' => $cantidadVisitasAsginadas,
            'VisitasAnuladasOP' => $cantidadVisitasAnuladasOP,
            'VisitasAnuladasTEC' => $cantidaVisitasAnuladasTEC,
            'VisitasAnuladasCLI' => $cantidaVisitasAnuladasCLI,
            'VisitasVenta' => $cantidadVisitasVenta,
            'VisitasNoVenta' => $cantidadVisitasNoVenta,
            'VisitasReAsignadas' => $cantidadVisitasReAsignadas,
            'VisitasReAsignadasActual' => $cantidadVisitasReAsignadasActual,
            'VisitasCheckIN' => $cantidadVisitasCheckIN,
            'PorcentajeCheckIN' => $porcentajeCheckIn
        );
}

$totalPorcentajeCheckIN = porcentaje($totalVisitasCheckIN, $totalVisitasReAsginadasActualDiaMenos);

$arregloDatos['Totales'] = array(
    'TotalVisitas' => $totalVisitas,
    'TotalVisitasAsignadas' => $totalVisitasAsignadas,
    'TotalVisitasAnuladasOP' => $totalVisitasAnuladasOP,
    'TotalVisitasAnuladasTEC' => $totalVisitasAnuladasTEC,
    'TotalVisitasAnuladasCLI' => $totalVisitasAnuladasCLI,
    'TotalVisitasVenta' => $totalVisitasVenta,
    'TotalVisitasNoVenta' => $totalVisitasNoVenta,
    'TotalVisitasReAsignadas' => $totalVisitasReAsignadas,
    'TotalVisitasReAsignadasActual' => $totalVisitasReAsignadasActual,
    'TotalVisitasCheckIN' => $totalVisitasCheckIN,
    'TotalPorcentajeCheckIN' => $totalPorcentajeCheckIN,
);

echo json_encode($arregloDatos);

function consultaVisitas(){
    global $con;
    global $fechadiahoy;
    
    $sql = "SELECT DISTINCT CCOriginal CC, count(v.IdVenta) visitas 
    FROM yifi58ge_dbVENTAS.tblventa v 
    WHERE v.MesVisita='".$fechadiahoy."' AND (v.TipoVenta IN ('RE', 'REGGCC'))
    GROUP BY CCOriginal";
    $resultado = $con->query($sql);
    while($visita = $resultado->fetch_assoc()){
        $data[] = $visita;
    }
    
    return $data;
}

function consultaVisitasAsignadas(){
    global $con;
    global $fechadiahoy;
    
    $sql = "SELECT DISTINCT CCOriginal CC, count(v.IdVenta) visitas 
    FROM yifi58ge_dbVENTAS.tblventa v 
    WHERE v.MesVisita='".$fechadiahoy."' 
    AND (v.TipoVenta IN ('RE', 'REGGCC')) 
    AND v.EstadoVisita='Asignada'
    GROUP BY CCOriginal";
    $resultado = $con->query($sql);
    while($visita = $resultado->fetch_assoc()){
        $data[] = $visita;
    }
    
    return $data;
}

function consultaVisitasAnuladaOP(){
    global $con;
    global $fechadiahoy;
    
    $sql = "SELECT DISTINCT CCOriginal CC, count(v.IdVenta) visitas 
    FROM yifi58ge_dbVENTAS.tblventa v 
    WHERE v.MesVisita='".$fechadiahoy."' 
    AND (v.TipoVenta IN ('RE', 'REGGCC')) 
    AND v.EstadoVisita='AnuladaOP'
    GROUP BY CCOriginal";
    $resultado = $con->query($sql);
    while($visita = $resultado->fetch_assoc()){
        $data[] = $visita;
    }
    
    return $data;
}

function consultaVisitasAnuladaTEC(){
    global $con;
    global $fechadiahoy;
    
    $sql = "SELECT DISTINCT CCOriginal CC, count(v.IdVenta) visitas 
    FROM yifi58ge_dbVENTAS.tblventa v 
    WHERE v.MesVisita='".$fechadiahoy."' 
    AND (v.TipoVenta IN ('RE', 'REGGCC')) 
    AND v.EstadoVisita='AnuladaTEC'
    GROUP BY CCOriginal";
    $resultado = $con->query($sql);
    
    while($visita = $resultado->fetch_assoc()){
        $data[] = $visita;
    }
    
    return $data;
}

function consultaVisitasAnuladaCLI(){
    global $con;
    global $fechadiahoy;
    
    $sql = "SELECT DISTINCT CCOriginal CC, count(v.IdVenta) visitas 
    FROM yifi58ge_dbVENTAS.tblventa v 
    WHERE v.MesVisita='".$fechadiahoy."' 
    AND (v.TipoVenta IN ('RE', 'REGGCC')) 
    AND v.EstadoVisita='AnuladaCLI'
    GROUP BY CCOriginal";
    $resultado = $con->query($sql);
    while($visita = $resultado->fetch_assoc()){
        $data[] = $visita;
    }
    
    return $data;
}

function consultaVisitasVENTA(){
    global $con;
    global $fechadiahoy;
    
    $sql = "SELECT DISTINCT CCOriginal CC, count(v.IdVenta) visitas 
    FROM yifi58ge_dbVENTAS.tblventa v 
    WHERE v.MesVisita='".$fechadiahoy."' 
    AND (v.TipoVenta IN ('RE', 'REGGCC')) 
    AND v.EstadoVisita='vendida'
    GROUP BY CCOriginal";
    $resultado = $con->query($sql);
    while($visita = $resultado->fetch_assoc()){
        $data[] = $visita;
    }
    
    return $data;
}

function consultaVisitasNoVenta(){
    global $con;
    global $fechadiahoy;
    
    $sql = "SELECT DISTINCT CCOriginal CC, count(v.IdVenta) visitas 
            FROM yifi58ge_dbVENTAS.tblventa v 
            WHERE v.MesVisita='".$fechadiahoy."' 
            AND (v.TipoVenta IN ('RE', 'REGGCC')) 
            AND v.EstadoVisita='novendida'
            GROUP BY CCOriginal";
    $resultado = $con->query($sql);
    while($visita = $resultado->fetch_assoc()){
        $data[] = $visita;
    }
    
    return $data;
}

function consultaVisitasReAsignadas(){
    
    global $con;
    global $fechadiahoy;
    
    $sql = "SELECT DISTINCT CCOriginal CC, count(v.IdVenta) visitas 
            FROM yifi58ge_dbVENTAS.tblventa v 
            WHERE v.MesVisita= '".$fechadiahoy."'
            AND (v.TipoVenta IN ('RE', 'REGGCC'))
            and (v.EstadoVisita =  'Asignada' OR v.EstadoVisita =  'Vendida' OR v.EstadoVisita =  'NoVendida')
            GROUP BY CCOriginal";
    $resultado = $con->query($sql);
    while($visita = $resultado->fetch_assoc()){
        $data[] = $visita;
    }
    
    return $data;
}

function consultaVisitasReAsignadasActual(){
    
    global $con;
    global $fechadiahoy;
    
    $sql = "SELECT DISTINCT CCOriginal CC, count(v.IdVenta) visitas 
            FROM yifi58ge_dbVENTAS.tblventa v 
            WHERE v.MesVisita='".$fechadiahoy."' and v.FechaVisita <= CURDATE() and v.TipoVenta='RE' and (v.EstadoVisita =  'Asignada' OR v.EstadoVisita =  'Vendida' OR v.EstadoVisita =  'NoVendida')
            GROUP BY CCOriginal";
    $resultado = $con->query($sql);
    while($visita = $resultado->fetch_assoc()){
        $data[] = $visita;
    }
    
    return $data;
}

function consultaVisitasReAsignadasActualDiaMenos(){
    
    global $con;
    global $fechadiahoy;
    
    $sql = "SELECT DISTINCT CCOriginal CC, count(v.IdVenta) visitas 
            FROM yifi58ge_dbVENTAS.tblventa v 
            WHERE v.MesVisita='".$fechadiahoy."' and  v.FechaVisita <= DATE_SUB(CURDATE(), INTERVAL 1 DAY) AND (v.TipoVenta IN ('RE', 'REGGCC')) and (v.EstadoVisita =  'Asignada' OR v.EstadoVisita =  'Vendida' OR v.EstadoVisita =  'NoVendida')
            GROUP BY CCOriginal";
    $resultado = $con->query($sql);
    while($visita = $resultado->fetch_assoc()){
        $data[] = $visita;
    }
    
    return $data;
}

function consultaVisitasCheckIN(){
    
    global $con;
    global $fechadiahoy;
    
    $sql = "SELECT DISTINCT v.CCOriginal CC, COUNT( v.IdVenta ) visitas 
            FROM yifi58ge_dbVENTAS.tblventa v 
            WHERE v.MesVisita='".$fechadiahoy."' AND v.FechaVisita <= CURDATE()  AND (v.TipoVenta IN ('RE', 'REGGCC')) and v.CategoriaVenta!='Anulada' and v.checkin='SI'
            GROUP BY v.CCOriginal";
    $resultado = $con->query($sql);
    while($visita = $resultado->fetch_assoc()){
        $data[] = $visita;
    }
    
    return $data;
}

function cantidadVisitas($delegacion, $arregloVisitasTotales){
    //echo json_encode($arregloVisitasTotales);
    $cantVisitas = 0;
    for($i=0; $i<count($arregloVisitasTotales); $i++){
        if ($delegacion == $arregloVisitasTotales[$i]['CC']){
            //echo $arregloVisitasTotales[$i]['visitas'];
            $cantVisitas =  $arregloVisitasTotales[$i]['visitas'];
            break;
        } 
    }
    return $cantVisitas;
}

function porcentaje($parte, $total){
    if($total > 0){
        return round(($parte/$total)*100);
    } else {
        return 0;
    }
    
}


?>