<?php
date_default_timezone_set('America/Lima');


class ConexionVentas
{


	private $db;
	private $usuario;

	function __construct()
	{

		$this->db =  Database::connect();

		// $this->db = new mysqli('localhost','root','','prueba');

	}


	/**** INSERTAR IMAGEN PROSPECTORP *****/
	public function imagenPtospectorp($idProspectoRp,$imgContenido)
	{
        $fecharegistro = date("Y-m-d H:i:s");
        $query = $this->db->prepare("INSERT INTO imagen_prospectorp (id_prospectorp,imagen,creado) VALUES (?,?,?)");
		$query->execute(array($idProspectoRp, $imgContenido, $fecharegistro));
		$idimagen_prospectorp = $this->db->lastInsertId();

		if ($idimagen_prospectorp) {
			return true;
		}else{
			return false;
		}
		
	}
	
/***********/

	/**** INSERTAR  IMAGEN VENTA *****/
	public function imagenVenta($idVen,$imgContenido)
	{

        $fecharegistro = date("Y-m-d H:i:s");
        $query = $this->db->prepare("INSERT INTO imagen_venta (id_prospectorp,imagen,creado) VALUES (?,?,?)");
		$query->execute(array($idVen, $imgContenido, $fecharegistro));
		$idimagen_venta = $this->db->lastInsertId();

		if ($idimagen_venta) {
			return true;
		}else{
			return false;
		}
		
	}
	
	

	public function mostrarTodosVentas($function)
	{
        $new_total_rows = 0;
        $contador=1;
        $pagenum=$function->pagenum;
        $pagesize=$function->pagesize;
        
        $starts = $pagenum * $pagesize;
        


        $queryexec="SELECT 
                    IdVenta,
                    EstadoVenta,
                    TipoVenta,
                    DC,
                    Comercial,
                    Segmento,
                    NProspecto,
                    NContrato,
                    Cliente,
                    CategoriaVenta,
                    PrecioKit,
                    TotalExtra,
                    ExtraAutorizado,
                    PAI,
                    IngresoKIT,
                    IngresoExtras,
                    IngresoTotal,
                    N590,
                    FechaHoraREG,
                    FechaVisita,
                    Distrito,
                    InstaladoX,
                    FechaInst,
                    HoraInst,
                    ScoringRP
                    FROM ventasgeneral";
        
        $query = $queryexec." LIMIT :starts,:pagesize";

        $filterquery = "";
        $where = "";
        // filter data.
        if (isset($function->filterscount))
        {
        	$filterscount = $function->filterscount;
        			
        	if ($filterscount > 0)
        	{
        		$where = " WHERE (";
        		$tmpdatafield = "";
        		$tmpfilteroperator = "";
        		for ($i=0; $i < $filterscount; $i++)
        		{
        			// get the filter's value.
        			$filtervalue = $function->{"filtervalue".$i};
        			// get the filter's condition.
        			$filtercondition =$function->{"filtercondition".$i};
        			// get the filter's column.
        			$filterdatafield =$function->{"filterdatafield".$i};
        			// get the filter's operator.
        			$filteroperator =$function->{"filteroperator".$i};
        					
        			if ($tmpdatafield == "")
        			{
        				$tmpdatafield = $filterdatafield;			
        			}
        			else if ($tmpdatafield <> $filterdatafield)
        			{
        					if ($tmpfilteroperator == 2){
            					$where.= " OR ";
            				}else{ 
            				    $where.= ") AND (";
            				}
        			}
        			else if ($tmpdatafield == $filterdatafield)
        			{
        				    if ($tmpfilteroperator == 0){
            					$where.= " AND ";
            				}else{ 
            				    $where.= " OR ";
            				}	
        			}
        					
        			// build the "WHERE" clause depending on the filter's condition, value and datafield.
        			switch($filtercondition)
        			{
        				case "CONTAINS":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."%'";
        					break;
        				case "DOES_NOT_CONTAIN":
        					$where .= " " . $filterdatafield . " NOT LIKE '%" . $filtervalue ."%'";
        					break;
        				case "EQUAL":
        					$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
        					break;
        				case "NOT_EQUAL":
        					$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN":
        					$where .= " " . $filterdatafield . " > '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN":
        					$where .= " " . $filterdatafield . " < '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ."'";
        					break;
        				case "STARTS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '" . $filtervalue ."%'";
        					break;
        				case "ENDS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."'";
        					break;
        				case "NULL":
        					$where .= " " . $filterdatafield . " IS NULL";
        					break;
        				case "NOT_NULL":
        					$where .= " " . $filterdatafield . " NOT NULL";
        					break;
        				case "GREATER_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ." 00:00:00'";
        					break;
        				case "LESS_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ." 23:59:59'";
        					break;
        					
        					
        			}
        									
        			if ($i == $filterscount - 1){
        				$where.= ")";
        			}
        					
        			$tmpfilteroperator = $filteroperator;
        			$tmpdatafield = $filterdatafield;			
        		}
        		$query = $queryexec." " .$where." LIMIT :starts,:pagesize";	
        		//var_dump($query);
        
        	}
        }

        if (isset($function->sortdatafield)){
        	$sortfield = $function->sortdatafield;
        	$sortorder = $function->sortorder;
        	$filterscount = $function->filterscount;
        	if ($sortorder != '')
        		{
        		if ($filterscount == 0)
        			{
        			if ($sortorder == "desc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}

        			}
        		else
        			{
        			if ($sortorder == "desc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}
        			$query = $queryexec." " .$where.$filterquery;
        			}
        		}
        }


		$result = $this->db->prepare($query); 
        $result->bindParam(':starts', $starts, PDO::PARAM_INT);
        $result->bindParam(':pagesize',$pagesize, PDO::PARAM_INT);		
		$result->execute(); 
		

        $orders = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $orders[] = array(
                    'IdVenta' => $row['IdVenta'],
                    'EstadoVenta' => $row['EstadoVenta'],
                    'TipoVenta' => $row['TipoVenta'],
                    'DC' => $row['DC'],
                    'Comercial' => $row['Comercial'],
                    'Segmento' => $row['Segmento'],
                    'NProspecto' => $row['NProspecto'],
                    'NContrato' => $row['NContrato'],
                    'Cliente' => $row['Cliente'],
                    'CategoriaVenta' => $row['CategoriaVenta'],
                    'PrecioKit' => $row['PrecioKit'],
                    'TotalExtra' => $row['TotalExtra'],
                    'ExtraAutorizado' => $row['ExtraAutorizado'],
                    'PAI' => $row['PAI'],
                    'IngresoKIT' => $row['IngresoKIT'],
                    'IngresoExtras' => $row['IngresoExtras'],
                    'IngresoTotal' => $row['IngresoTotal'],
                    'N590' => $row['N590'],
                    'FechaHoraREG' => $row['FechaHoraREG'],
                    'FechaVisita' => $row['FechaVisita'],
                    'Distrito' => $row['Distrito'],
                    'InstaladoX' => $row['InstaladoX'],
                    'FechaInst' => $row['FechaInst'],
                    'HoraInst' => $row['HoraInst'],
                    'ScoringRP' => $row['ScoringRP']
                	);
$contador++;            
        }
        
	    $query = "SELECT COUNT(IdVenta) AS found_rows FROM ventasgeneral".$where;
		$result =  $this->db->prepare($query);
		$result->execute();
		$rows=$result->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['found_rows'];
        if ($new_total_rows > 0) $total_rows = $new_total_rows;	        

        if ($total_rows > 0){
            $data[] = array(
            	'TotalRows' => $total_rows,
            	'Rows' => array_map(null,$orders),
            	'mensaje' => '',
            	'tipo' =>1
            );
            
        } else {
            $data[] = array(
        	'TotalRows' => 0,
        	'Rows' => null,
        	'mensaje' => '<div class="callout bg-gray">
                            <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                       <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                        <br>
            </div>',
        	'tipo' =>0
        	);
        }
        
        
        return $data;


	}
	
	public function selectListarVentasTotales($function)
	{
        $new_total_rows = 0;
        $contador=1;
        $pagenum=$function->pagenum;
        $pagesize=$function->pagesize;
        
        $starts = $pagenum * $pagesize;
        


        $queryexec="SELECT 
                    IdVenta,
                    EstadoVenta,
                    TipoVenta,
                    DC,
                    IdUsuario,
                    Matricula,
                    Comercial,
                    Segmento,
                    NProspecto,
                    IdProspectoRP,
                    NContrato,
                    Cliente,
                    CategoriaVenta,
                    PrecioKit,
                    TotalExtra,
                    ExtraAutorizado,
                    N590,
                    HojaCertificacion,
                    CertificadoValidado,
                    InstaladoX,
                    distrito,
                    FechaInst,
                    GestorCertVenta,
                    TCGestor,
                    GestorTCTV
                     FROM ventastotales";
        
        $query = $queryexec." LIMIT :starts,:pagesize";

        $filterquery = "";
        $where = "";
        // filter data.
        if (isset($function->filterscount))
        {
        	$filterscount = $function->filterscount;
        			
        	if ($filterscount > 0)
        	{
        		$where = " WHERE (";
        		$tmpdatafield = "";
        		$tmpfilteroperator = "";
        		for ($i=0; $i < $filterscount; $i++)
        		{
        			// get the filter's value.
        			$filtervalue = $function->{"filtervalue".$i};
        			// get the filter's condition.
        			$filtercondition =$function->{"filtercondition".$i};
        			// get the filter's column.
        			$filterdatafield =$function->{"filterdatafield".$i};
        			// get the filter's operator.
        			$filteroperator =$function->{"filteroperator".$i};
        					
        			if ($tmpdatafield == "")
        			{
        				$tmpdatafield = $filterdatafield;			
        			}
        			else if ($tmpdatafield <> $filterdatafield)
        			{
        					if ($tmpfilteroperator == 2){
            					$where.= " OR ";
            				}else{ 
            				    $where.= ") AND (";
            				}
        			}
        			else if ($tmpdatafield == $filterdatafield)
        			{
        				    if ($tmpfilteroperator == 0){
            					$where.= " AND ";
            				}else{ 
            				    $where.= " OR ";
            				}	
        			}
        					
        			// build the "WHERE" clause depending on the filter's condition, value and datafield.
        			switch($filtercondition)
        			{
        				case "CONTAINS":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."%'";
        					break;
        				case "DOES_NOT_CONTAIN":
        					$where .= " " . $filterdatafield . " NOT LIKE '%" . $filtervalue ."%'";
        					break;
        				case "EQUAL":
        					$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
        					break;
        				case "NOT_EQUAL":
        					$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN":
        					$where .= " " . $filterdatafield . " > '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN":
        					$where .= " " . $filterdatafield . " < '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ."'";
        					break;
        				case "STARTS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '" . $filtervalue ."%'";
        					break;
        				case "ENDS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."'";
        					break;
        				case "NULL":
        					$where .= " " . $filterdatafield . " IS NULL";
        					break;
        				case "NOT_NULL":
        					$where .= " " . $filterdatafield . " NOT NULL";
        					break;
        				case "GREATER_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ." 00:00:00'";
        					break;
        				case "LESS_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ." 23:59:59'";
        					break;
        					
        					
        			}
        									
        			if ($i == $filterscount - 1){
        				$where.= ")";
        			}
        					
        			$tmpfilteroperator = $filteroperator;
        			$tmpdatafield = $filterdatafield;			
        		}
        		$query = $queryexec." " .$where." LIMIT :starts,:pagesize";	
        		//var_dump($query);
        
        	}
        }

        if (isset($function->sortdatafield)){
        	$sortfield = $function->sortdatafield;
        	$sortorder = $function->sortorder;
        	$filterscount = $function->filterscount;
        	if ($sortorder != '')
        		{
        		if ($filterscount == 0)
        			{
        			if ($sortorder == "desc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}

        			}
        		else
        			{
        			if ($sortorder == "desc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}
        			$query = $queryexec." " .$where.$filterquery;
        			}
        		}
        }


		$result = $this->db->prepare($query); 
        $result->bindParam(':starts', $starts, PDO::PARAM_INT);
        $result->bindParam(':pagesize',$pagesize, PDO::PARAM_INT);		
		$result->execute(); 
		

        $orders = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $orders[] = array(
                    'IdVenta' => $row['IdVenta'],
                    'EstadoVenta' => $row['EstadoVenta'],
                    'TipoVenta' => $row['TipoVenta'],
                    'DC' => $row['DC'],
                    'IdUsuario' => $row['IdUsuario'],
                    'Matricula' => $row['Matricula'],
                    'Comercial' => $row['Comercial'],
                    'Segmento' => $row['Segmento'],
                    'NProspecto' => $row['NProspecto'],
                    'IdProspectoRP' => $row['IdProspectoRP'],
                    'NContrato' => $row['NContrato'],
                    'Cliente' => $row['Cliente'],
                    'CategoriaVenta' => $row['CategoriaVenta'],
                    'PrecioKit' => $row['PrecioKit'],
                    'TotalExtra' => $row['TotalExtra'],
                    'ExtraAutorizado' => $row['ExtraAutorizado'],
                    'N590' => $row['N590'],
                    'HojaCertificacion' => $row['HojaCertificacion'],
                    'CertificadoValidado' => $row['CertificadoValidado'],
                    'InstaladoX' => $row['InstaladoX'],
                    'distrito' => $row['distrito'],
                    'FechaInst' => $row['FechaInst'],
                    'GestorCertVenta' => $row['GestorCertVenta'],
                    'TCGestor' => $row['TCGestor'],
                    'GestorTCTV' => $row['GestorTCTV']
                	);
$contador++;            
        }
        
	    $query = "SELECT COUNT(IdVenta) AS found_rows FROM ventastotales".$where;
		$result =  $this->db->prepare($query);
		$result->execute();
		$rows=$result->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['found_rows'];
        if ($new_total_rows > 0) $total_rows = $new_total_rows;	        

        if ($total_rows > 0){
            $data[] = array(
            	'TotalRows' => $total_rows,
            	'Rows' => array_map(null,$orders),
            	'mensaje' => '',
            	'tipo' =>1
            );
            
        } else {
            $data[] = array(
        	'TotalRows' => 0,
        	'Rows' => null,
        	'mensaje' => '<div class="callout bg-gray">
                            <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                       <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                        <br>
            </div>',
        	'tipo' =>0
        	);
        }
        
        
        return $data;


	}
	
	public function selectListarCertificacion($function)
	{
        $new_total_rows = 0;
        $contador=1;
        $pagenum=$function->pagenum;
        $pagesize=$function->pagesize;
        
        $starts = $pagenum * $pagesize;
        


        $queryexec="SELECT IdVenta, NContrato, EstadoVenta, TipoVenta, DC, GestorCertVenta, FechaApertura, Prioridad, Territorio, TipoCierre, EstadoLlamada, FechaHoraProgramacion, ComentarioComercial, nuevohorarioSugerido FROM certificacionventa";
        
        $query = $queryexec." LIMIT :starts,:pagesize";

        $filterquery = "";
        $where = "";
        // filter data.
        if (isset($function->filterscount))
        {
        	$filterscount = $function->filterscount;
        			
        	if ($filterscount > 0)
        	{
        		$where = " WHERE (";
        		$tmpdatafield = "";
        		$tmpfilteroperator = "";
        		for ($i=0; $i < $filterscount; $i++)
        		{
        			// get the filter's value.
        			$filtervalue = $function->{"filtervalue".$i};
        			// get the filter's condition.
        			$filtercondition =$function->{"filtercondition".$i};
        			// get the filter's column.
        			$filterdatafield =$function->{"filterdatafield".$i};
        			// get the filter's operator.
        			$filteroperator =$function->{"filteroperator".$i};
        					
        			if ($tmpdatafield == "")
        			{
        				$tmpdatafield = $filterdatafield;			
        			}
        			else if ($tmpdatafield <> $filterdatafield)
        			{
        					if ($tmpfilteroperator == 2){
            					$where.= " OR ";
            				}else{ 
            				    $where.= ") AND (";
            				}
        			}
        			else if ($tmpdatafield == $filterdatafield)
        			{
        				    if ($tmpfilteroperator == 0){
            					$where.= " AND ";
            				}else{ 
            				    $where.= " OR ";
            				}	
        			}
        					
        			// build the "WHERE" clause depending on the filter's condition, value and datafield.
        			switch($filtercondition)
        			{
        				case "CONTAINS":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."%'";
        					break;
        				case "DOES_NOT_CONTAIN":
        					$where .= " " . $filterdatafield . " NOT LIKE '%" . $filtervalue ."%'";
        					break;
        				case "EQUAL":
        					$where .= " " . $filterdatafield . " = '" . $filtervalue ."'";
        					break;
        				case "NOT_EQUAL":
        					$where .= " " . $filterdatafield . " <> '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN":
        					$where .= " " . $filterdatafield . " > '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN":
        					$where .= " " . $filterdatafield . " < '" . $filtervalue ."'";
        					break;
        				case "GREATER_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ."'";
        					break;
        				case "LESS_THAN_OR_EQUAL":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ."'";
        					break;
        				case "STARTS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '" . $filtervalue ."%'";
        					break;
        				case "ENDS_WITH":
        					$where .= " " . $filterdatafield . " LIKE '%" . $filtervalue ."'";
        					break;
        				case "NULL":
        					$where .= " " . $filterdatafield . " IS NULL";
        					break;
        				case "NOT_NULL":
        					$where .= " " . $filterdatafield . " NOT NULL";
        					break;
        				case "GREATER_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " >= '" . $filtervalue ." 00:00:00'";
        					break;
        				case "LESS_THAN_OR_EQUAL_TIME":
        					$where .= " " . $filterdatafield . " <= '" . $filtervalue ." 23:59:59'";
        					break;
        					
        					
        			}
        									
        			if ($i == $filterscount - 1){
        				$where.= ")";
        			}
        					
        			$tmpfilteroperator = $filteroperator;
        			$tmpdatafield = $filterdatafield;			
        		}
        		$query = $queryexec." " .$where." LIMIT :starts,:pagesize";	
        		//var_dump($query);
        
        	}
        }

        if (isset($function->sortdatafield)){
        	$sortfield = $function->sortdatafield;
        	$sortorder = $function->sortorder;
        	$filterscount = $function->filterscount;
        	if ($sortorder != '')
        		{
        		if ($filterscount == 0)
        			{
        			if ($sortorder == "desc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$query = $queryexec." ORDER BY" . " " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}

        			}
        		else
        			{
        			if ($sortorder == "desc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " DESC LIMIT :starts,:pagesize";
        				}
        			  else if ($sortorder == "asc")
        				{
        				$filterquery.= " ORDER BY " . $sortfield . " ASC LIMIT :starts,:pagesize";
        				}
        			$query = $queryexec." " .$where.$filterquery;
        			}
        		}
        }


		$result = $this->db->prepare($query); 
        $result->bindParam(':starts', $starts, PDO::PARAM_INT);
        $result->bindParam(':pagesize',$pagesize, PDO::PARAM_INT);		
		$result->execute(); 
		

        $orders = [];
        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            $orders[] = array(
            'IdVenta' => $row['IdVenta'],
            'NContrato' => $row['NContrato'],
            'EstadoVenta' => $row['EstadoVenta'],
            'TipoVenta' => $row['TipoVenta'],
            'DC' => $row['DC'],
            'GestorCertVenta' => $row['GestorCertVenta'],
            'FechaApertura' => $row['FechaApertura'],
            'Prioridad' => $row['Prioridad'],
            'Territorio' => $row['Territorio'],
            'TipoCierre' => $row['TipoCierre'],
            'EstadoLlamada' => $row['EstadoLlamada'],
            'FechaHoraProgramacion' => $row['FechaHoraProgramacion'],
            'ComentarioComercial' => $row['ComentarioComercial'],
            'nuevohorarioSugerido' => $row['nuevohorarioSugerido']
                	);
            $contador++;            
        }
        
	    $query = "SELECT COUNT(IdVenta) AS found_rows FROM certificacionventa".$where;
		$result =  $this->db->prepare($query);
		$result->execute();
		$rows=$result->fetch(PDO::FETCH_ASSOC); 
		$total_rows = $rows['found_rows'];
        if ($new_total_rows > 0) $total_rows = $new_total_rows;	        

        if ($total_rows > 0){
            $data[] = array(
            	'TotalRows' => $total_rows,
            	'Rows' => array_map(null,$orders),
            	'mensaje' => '',
            	'tipo' =>1
            );
            
        } else {
            $data[] = array(
        	'TotalRows' => 0,
        	'Rows' => null,
        	'mensaje' => '<div class="callout bg-gray">
                            <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                       <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                        <br>
            </div>',
        	'tipo' =>0
        	);
        }
        
        return $data;
	}	
		
	
//***************CERTIFICACION DE VENTA
    public function insertarCertificacionHist($idcertventa, $idventa, $gestor, $lblfechaapertura_cert, $lblfechacierre_certgrabar, $lbltipocierre_cert, $hidden_inci_tecnica, $lblformapago_cert, $lblcomentario_cert,$hidden_kitnoinstalado,$lblfechacorrecion_kitnoinstalado,$hidden_errorcomprobantepago,$lblfechacorrecion_errorcomprobantepago,$hidden_errorsegmento,$lblfechacorrecion_errorsegmento,$hidden_fueranomalcomercial,$lblfechacorrecion_fueranomalcomercial,$hidden_fueranormativatecnica,$lblfechacorrecion_fueranormativatecnica,$hidden_incidenciadatos,$lblfechacorrecion_incidenciadatos,$hidden_inconformidadfuncionamiento,$lblfechacorrecion_inconformidadfuncionamiento,$hidden_inconformidadpagoinicial,$lblfechacorrecion_inconformidadpagoinicial,$hidden_inconformidadpagomensual,$lblfechacorrecion_inconformidadpagomensual,$hidden_inconformidadtiempopermanencia,$lblfechacorrecion_inconformidadtiempopermanencia,$hidden_inconformidadubicaciondispositivos,$lblfechacorrecion_inconformidadubicaciondispositivos,$hidden_noconcefuncionamiento,$lblfechacorrecion_noconcefuncionamiento,$hidden_notienecontrato,$lblfechacorrecion_notienecontrato,$hidden_promesaspendientes,$lblfechacorrecion_promesaspendientes,$hidden_reclamocomercial,$lblfechacorrecion_reclamocomercial,$hidden_solicitabaja,$lblfechacorrecion_solicitabaja,$hidden_tarjetaafiliadanopertenecetitular,$lblfechacorrecion_tarjetaafiliadanopertenecetitular,$hidden_recepmanual,$lblfechacorrecion_recepmanual,$hidden_descargaapp,$lblfechacorrecion_descargaapp,$hidden_capacitado,$lblfechacorrecion_capacitado,$lblnumerollamadas,$TipoAccion){
    
            $fechmod = date("Y-m-d H:i:s");
    
            $query = $this->db->prepare("INSERT INTO yifi58ge_dbVENTAS.tblcertificacionhist(IdCertificacionVenta, IdVenta, MatriculaGestor, FechaApertura, FechaCierre, TipoCierre, IncidenciaTecnica, FormaPago, Comentario, FechaHoraREG,kitnoinstalado,fechacorrecion_kitnoinstalado,errorcomprobantepago,fechacorrecion_errorcomprobantepago,errorsegmento,fechacorrecion_errorsegmento,fueranomalcomercial,fechacorrecion_fueranomalcomercial,fueranormativatecnica,fechacorrecion_fueranormativatecnica,incidenciadatos,fechacorrecion_incidenciadatos,inconformidadfuncionamiento,fechacorrecion_inconformidadfuncionamiento,inconformidadpagoinicial,fechacorrecion_inconformidadpagoinicial,inconformidadpagomensual,fechacorrecion_inconformidadpagomensual,inconformidadtiempopermanencia,fechacorrecion_inconformidadtiempopermanencia,inconformidadubicaciondispositivos,fechacorrecion_inconformidadubicaciondispositivos,noconcefuncionamiento,fechacorrecion_noconcefuncionamiento,notienecontrato,fechacorrecion_notienecontrato,promesaspendientes,fechacorrecion_promesaspendientes,reclamocomercial,fechacorrecion_reclamocomercial,solicitabaja,fechacorrecion_solicitabaja,tarjetaafiliadanopertenecetitular,fechacorrecion_tarjetaafiliadanopertenecetitular,recepmanual,fechacorrecion_recepmanual,descargaapp,fechacorrecion_descargaapp,capacitado,fechacorrecion_capacitado,numerollamadas,TipoAccion) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $query->execute(array($idcertventa, $idventa, $gestor, $lblfechaapertura_cert, $lblfechacierre_certgrabar, $lbltipocierre_cert, $hidden_inci_tecnica, $lblformapago_cert, $lblcomentario_cert, $fechmod,$hidden_kitnoinstalado,$lblfechacorrecion_kitnoinstalado,$hidden_errorcomprobantepago,$lblfechacorrecion_errorcomprobantepago,$hidden_errorsegmento,$lblfechacorrecion_errorsegmento,$hidden_fueranomalcomercial,$lblfechacorrecion_fueranomalcomercial,$hidden_fueranormativatecnica,$lblfechacorrecion_fueranormativatecnica,$hidden_incidenciadatos,$lblfechacorrecion_incidenciadatos,$hidden_inconformidadfuncionamiento,$lblfechacorrecion_inconformidadfuncionamiento,$hidden_inconformidadpagoinicial,$lblfechacorrecion_inconformidadpagoinicial,$hidden_inconformidadpagomensual,$lblfechacorrecion_inconformidadpagomensual,$hidden_inconformidadtiempopermanencia,$lblfechacorrecion_inconformidadtiempopermanencia,$hidden_inconformidadubicaciondispositivos,$lblfechacorrecion_inconformidadubicaciondispositivos,$hidden_noconcefuncionamiento,$lblfechacorrecion_noconcefuncionamiento,$hidden_notienecontrato,$lblfechacorrecion_notienecontrato,$hidden_promesaspendientes,$lblfechacorrecion_promesaspendientes,$hidden_reclamocomercial,$lblfechacorrecion_reclamocomercial,$hidden_solicitabaja,$lblfechacorrecion_solicitabaja,$hidden_tarjetaafiliadanopertenecetitular,$lblfechacorrecion_tarjetaafiliadanopertenecetitular,$hidden_recepmanual,$lblfechacorrecion_recepmanual,$hidden_descargaapp,$lblfechacorrecion_descargaapp,$hidden_capacitado,$lblfechacorrecion_capacitado,$lblnumerollamadas,$TipoAccion));
            $respuesta = $this->db->lastInsertId(); 
            return $respuesta;
    }
    
    public function actualizarVenta($idventa,$hidden_certificadovalidado,$gestor,$hidden_hojacertificacion,$idcertventa,$lblfechaapertura_cert){
        
        if(isset($lblfechaapertura_cert) && !empty($lblfechaapertura_cert)){
            $fecharegistroventa=$lblfechaapertura_cert;
        }else{
            $fecharegistroventa=date("Y-m-d H:i:s");
        }
    
            $query = $this->db->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET  CertificadoValidado=?,HojaCertificacion=?,GestorCertVenta=?,IdCertVenta=?,FechaApertura=? WHERE IdVenta=?");
            $query->execute(array($hidden_certificadovalidado,$hidden_hojacertificacion,$gestor,$idcertventa,$fecharegistroventa, $idventa));
            $respuesta = $query->rowCount();
            
            return $respuesta;
    
    }


    public function actualizarCertificacion($idcertventa,$lblfechacierre_certgrabar,$lbltipocierre_cert,$lblmotivoincidencia_cert,$hidden_inci_tecnica,$lblsolucionincidencia_cert,$lblformapago_cert,$lblcomentario_cert,$hidden_kitnoinstalado,$lblfechacorrecion_kitnoinstalado,$hidden_errorcomprobantepago,$lblfechacorrecion_errorcomprobantepago,$hidden_errorsegmento,$lblfechacorrecion_errorsegmento,$hidden_fueranomalcomercial,$lblfechacorrecion_fueranomalcomercial,$hidden_fueranormativatecnica,$lblfechacorrecion_fueranormativatecnica,$hidden_incidenciadatos,$lblfechacorrecion_incidenciadatos,$hidden_inconformidadfuncionamiento,$lblfechacorrecion_inconformidadfuncionamiento,$hidden_inconformidadpagoinicial,$lblfechacorrecion_inconformidadpagoinicial,$hidden_inconformidadpagomensual,$lblfechacorrecion_inconformidadpagomensual,$hidden_inconformidadtiempopermanencia,$lblfechacorrecion_inconformidadtiempopermanencia,$hidden_inconformidadubicaciondispositivos,$lblfechacorrecion_inconformidadubicaciondispositivos,$hidden_noconcefuncionamiento,$lblfechacorrecion_noconcefuncionamiento,$hidden_notienecontrato,$lblfechacorrecion_notienecontrato,$hidden_promesaspendientes,$lblfechacorrecion_promesaspendientes,$hidden_reclamocomercial,$lblfechacorrecion_reclamocomercial,$hidden_solicitabaja,$lblfechacorrecion_solicitabaja,$hidden_tarjetaafiliadanopertenecetitular,$lblfechacorrecion_tarjetaafiliadanopertenecetitular,$hidden_recepmanual,$lblfechacorrecion_recepmanual,$hidden_descargaapp,$lblfechacorrecion_descargaapp,$hidden_capacitado,$lblfechacorrecion_capacitado,$lblnumerollamadas,$FechaPendiente,$FechaPrimeraGestion,$FechaFinalizadoconIncidencia,$FechaResuelto){
    
            $query = $this->db->prepare("UPDATE yifi58ge_dbVENTAS.tblcertificacionventa SET FechaCierre=?,TipoCierre=?,MotivoIncidencia=?,SolucionIncidencia=?,IncidenciaTecnica=?,FormaPago=?,Comentario=?,kitnoinstalado=?,fechacorrecion_kitnoinstalado=?,errorcomprobantepago=?,fechacorrecion_errorcomprobantepago=?,errorsegmento=?,fechacorrecion_errorsegmento=?,fueranomalcomercial=?,fechacorrecion_fueranomalcomercial=?,fueranormativatecnica=?,fechacorrecion_fueranormativatecnica=?,incidenciadatos=?,fechacorrecion_incidenciadatos=?,inconformidadfuncionamiento=?,fechacorrecion_inconformidadfuncionamiento=?,inconformidadpagoinicial=?,fechacorrecion_inconformidadpagoinicial=?,inconformidadpagomensual=?,fechacorrecion_inconformidadpagomensual=?,inconformidadtiempopermanencia=?,fechacorrecion_inconformidadtiempopermanencia=?,inconformidadubicaciondispositivos=?,fechacorrecion_inconformidadubicaciondispositivos=?,noconcefuncionamiento=?,fechacorrecion_noconcefuncionamiento=?,notienecontrato=?,fechacorrecion_notienecontrato=?,promesaspendientes=?,fechacorrecion_promesaspendientes=?,reclamocomercial=?,fechacorrecion_reclamocomercial=?,solicitabaja=?,fechacorrecion_solicitabaja=?,tarjetaafiliadanopertenecetitular=?,fechacorrecion_tarjetaafiliadanopertenecetitular=?,recepmanual=?,fechacorrecion_recepmanual=?,descargaapp=?,fechacorrecion_descargaapp=?,capacitado=?,fechacorrecion_capacitado=?,numerollamadas=?,FechaPendiente=?,FechaPrimeraGestion=?,FechaFinalizadoconIncidencia=?,FechaResuelto=? WHERE IdCertVenta=?");
            $query->execute(array($lblfechacierre_certgrabar, $lbltipocierre_cert, $lblmotivoincidencia_cert, $lblsolucionincidencia_cert, $hidden_inci_tecnica,$lblformapago_cert,$lblcomentario_cert,$hidden_kitnoinstalado,$lblfechacorrecion_kitnoinstalado,$hidden_errorcomprobantepago,$lblfechacorrecion_errorcomprobantepago,$hidden_errorsegmento,$lblfechacorrecion_errorsegmento,$hidden_fueranomalcomercial,$lblfechacorrecion_fueranomalcomercial,$hidden_fueranormativatecnica,$lblfechacorrecion_fueranormativatecnica,$hidden_incidenciadatos,$lblfechacorrecion_incidenciadatos,$hidden_inconformidadfuncionamiento,$lblfechacorrecion_inconformidadfuncionamiento,$hidden_inconformidadpagoinicial,$lblfechacorrecion_inconformidadpagoinicial,$hidden_inconformidadpagomensual,$lblfechacorrecion_inconformidadpagomensual,$hidden_inconformidadtiempopermanencia,$lblfechacorrecion_inconformidadtiempopermanencia,$hidden_inconformidadubicaciondispositivos,$lblfechacorrecion_inconformidadubicaciondispositivos,$hidden_noconcefuncionamiento,$lblfechacorrecion_noconcefuncionamiento,$hidden_notienecontrato,$lblfechacorrecion_notienecontrato,$hidden_promesaspendientes,$lblfechacorrecion_promesaspendientes,$hidden_reclamocomercial,$lblfechacorrecion_reclamocomercial,$hidden_solicitabaja,$lblfechacorrecion_solicitabaja,$hidden_tarjetaafiliadanopertenecetitular,$lblfechacorrecion_tarjetaafiliadanopertenecetitular,$hidden_recepmanual,$lblfechacorrecion_recepmanual,$hidden_descargaapp,$lblfechacorrecion_descargaapp,$hidden_capacitado,$lblfechacorrecion_capacitado,$lblnumerollamadas,$FechaPendiente,$FechaPrimeraGestion,$FechaFinalizadoconIncidencia,$FechaResuelto,$idcertventa));
            $respuesta = $query->rowCount();
            
            return $respuesta;
    }
    
public function guardarresumenventa($lblasignado,
                $lblfechaapertura_cert,
                $tipocierre_cert,
                $lblsolucionincidencia_cert,
                $lblfechanacimiento,
                $lbltipogenero,
                $lblformapago_cert,
                $detalleIncidencia,
                $idcertventa,
                $idventa){
        
            $fecharegistro = date("Y-m-d H:i:s");
            
            if(empty($idcertventa)){
                
 
            $query = $this->db->prepare("INSERT INTO yifi58ge_dbVENTAS.tblcertificacionventa(TipoCierre,SolucionIncidencia,FechaHoraREG,FormaPago,FechaNacimiento,Tipogenero,jsonIncidencias) VALUES(?,?,?,?,?,?,?)");
            $query->execute(array( $tipocierre_cert,
                $lblsolucionincidencia_cert,
                $fecharegistro,
                $lblformapago_cert,
                $lblfechanacimiento,
                $lbltipogenero,
                $detalleIncidencia));
            $idcertventa = $this->db->lastInsertId();
            
            $queryAsig = $this->db->prepare("UPDATE tblventa SET GestorCertVenta=?,FechaApertura=?, IdCertVenta=? WHERE IdVenta=?");
            $queryAsig->execute(array($lblasignado,$lblfechaapertura_cert,$idcertventa,$idventa));            

            if($idcertventa>0){
                   $respuesta=array(
                    'respuesta'=>'exito',
                    'IdCertVenta'=>$idcertventa,
                    'FechaApertura'=>$lblfechaapertura_cert
                    );
                }else{
                    $respuesta=array(
                    'respuesta'=>'error',
                    'IdCertVenta'=>$idcertventa,
                    'FechaApertura'=>$lblfechaapertura_cert
                    );
                }
            

            }else{


            $queryAsig = $this->db->prepare("UPDATE tblventa SET GestorCertVenta=?,FechaApertura=? WHERE IdVenta=?");
            $queryAsig->execute(array($lblasignado,$lblfechaapertura_cert,$idventa));
            
            $query = $this->db->prepare("UPDATE tblcertificacionventa SET 
            TipoCierre=?,
            SolucionIncidencia=?,
            FechaHoraREG=?,
            FormaPago=?,
            FechaNacimiento=?,
            Tipogenero=?,
            jsonIncidencias=?
            WHERE IdCertVenta=?");
            $query->execute(array(
                $tipocierre_cert,
                $lblsolucionincidencia_cert,
                $fecharegistro,
                $lblformapago_cert,
                $lblfechanacimiento,
                $lbltipogenero,
                $detalleIncidencia,
                $idcertventa));
            $respuestarow = $query->rowCount();
            
                if($respuestarow>0){
                   $respuesta=array(
                    'respuesta'=>'exito',
                    'IdCertVenta'=>$idcertventa,
                    'FechaApertura'=>$lblfechaapertura_cert
                    );
                }else{
                    $respuesta=array(
                    'respuesta'=>'error',
                    'IdCertVenta'=>$idcertventa,
                    'FechaApertura'=>$lblfechaapertura_cert
                    );
                }
            
            }
            
            return $respuesta;
    } 
    
    public function ingresarRespuestaComercial($idcertventa,$lblcomentario_comercial,$lblhorariosugerido2,$RespComercial='SI'){
    
            $query = $this->db->prepare("UPDATE yifi58ge_dbVENTAS.tblcertificacionventa SET ComentarioComercial=?,RespComercial=?,nuevohorarioSugerido=? WHERE IdCertVenta=?");
            $query->execute(array($lblcomentario_comercial,$RespComercial,$lblhorariosugerido2,$idcertventa));
            $respuesta = $query->rowCount();
            
            return $respuesta;
    }
    
    public function ingresarRespuestaComercialModal($idcertventa,$lblcomentario_comercial,$lblhorariosugerido2,$RespComercial='SI',$tipocierre_cert='',$matricula='',$idventa){
        
            $fecharegistro = date("Y-m-d H:i:s");
            
            if(empty($idcertventa)){
                
            $query = $this->db->prepare("INSERT INTO yifi58ge_dbVENTAS.tblcertificacionventa(ComentarioComercial,RespComercial,nuevohorarioSugerido) VALUES(?,?,?)");
            $query->execute(array($lblcomentario_comercial, $RespComercial,$lblhorariosugerido2));
            $respuesta = $this->db->lastInsertId(); 
            
            
            $query = $this->db->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET  IdCertVenta=? WHERE IdVenta=?");
            $query->execute(array($respuesta, $idventa));
            $respuesta2 = $query->rowCount();

            $queryHist = $this->db->prepare("INSERT INTO yifi58ge_dbVENTAS.tblcertificacioncomertario(IdVenta, HorarioSugerido, Comentario, TipoGestion, FechaHoraREG, Matricula) VALUES(?,?,?,?,?,?)");
            $queryHist->execute(array($idventa, $lblhorariosugerido2,$lblcomentario_comercial,$tipocierre_cert,$fecharegistro,$matricula));


            }else{
            $query = $this->db->prepare("UPDATE yifi58ge_dbVENTAS.tblcertificacionventa SET ComentarioComercial=?,RespComercial=?,nuevohorarioSugerido=? WHERE IdCertVenta=?");
            $query->execute(array($lblcomentario_comercial,$RespComercial,$lblhorariosugerido2,$idcertventa));
            $respuesta = $query->rowCount();

            $queryHist = $this->db->prepare("INSERT INTO yifi58ge_dbVENTAS.tblcertificacioncomertario(IdVenta, HorarioSugerido, Comentario, TipoGestion, FechaHoraREG, Matricula) VALUES(?,?,?,?,?,?)");
            $queryHist->execute(array($idventa, $lblhorariosugerido2,$lblcomentario_comercial,$tipocierre_cert,$fecharegistro,$matricula));            
            
            }
            
            return $respuesta;
    } 
    
    
    
	public function historialRespuestaComercialModal($idventa){

        $query = $this->db->prepare("SELECT IdCertCom, HorarioSugerido, Comentario, TipoGestion, FechaHoraREG, Matricula FROM yifi58ge_dbVENTAS.tblcertificacioncomertario WHERE IdVenta=?");
            
            $query->execute(array($idventa));
    		$retorno = [];
    		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
    			$retorno[] = $fila;
    		}

		return $retorno;
			
	}
	
	public function historialGestionlModal($idventa){

        $query = $this->db->prepare("SELECT MatriculaAsignada, FechaAsignacion, MatriculaGestor, FechaHoraRegistro, EstadoLlamada, Comentario, FechaHoraProgramacion, numerollamadas, TipoGestion FROM yifi58ge_dbVENTAS.tblgestioncertificacionventa WHERE IdCertVenta=?");
            $query->execute(array($idventa));
    		$retorno = [];
    		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
    			$retorno[] = $fila;
    		}

		return $retorno;
			
	} 	

  public function ingresarGestionModal($lblasignado=NULL,$lblfechaapertura_cert=NULL,$matricula,$modalestadollamada,$modalcomentario_cert,$modalfechahoraRellamada=NULL,$tipocierre_cert,$numerollamadas,$idcertventa,$idventa){
        
            $fecharegistro = date("Y-m-d H:i:s");
            
            
            if($modalestadollamada=='ProgramacionWhatsapp'){
                
            }else{
                $numerollamadas=$numerollamadas+1;
            }
            
            
            
            if(empty($idcertventa)){
                
            $query = $this->db->prepare("INSERT INTO yifi58ge_dbVENTAS.tblcertificacionventa(numerollamadas,FechaUltimaGestion) VALUES(?,?)");
            $query->execute(array($numerollamadas,$fecharegistro));
            $idcertventa = $this->db->lastInsertId(); 
                
            $queryHist = $this->db->prepare("INSERT INTO yifi58ge_dbVENTAS.tblgestioncertificacionventa(MatriculaAsignada, FechaAsignacion, MatriculaGestor, FechaHoraRegistro, EstadoLlamada, Comentario, FechaHoraProgramacion, numerollamadas, TipoGestion,IdCertVenta) VALUES(?,?,?,?,?,?,?,?,?,?)");
            $queryHist->execute(array($lblasignado,$lblfechaapertura_cert,$matricula,$fecharegistro,$modalestadollamada,$modalcomentario_cert,$modalfechahoraRellamada,$numerollamadas,$tipocierre_cert,$idcertventa));
            $IdGestionCert = $this->db->lastInsertId(); 
            
                
            $query = $this->db->prepare("UPDATE yifi58ge_dbVENTAS.tblgestioncertificacionventa SET  IdGestionCert=? WHERE IdCertVenta=?");
            $query->execute(array($IdGestionCert,$idcertventa));
            
            
            $query = $this->db->prepare("UPDATE yifi58ge_dbVENTAS.tblventa SET  IdCertVenta=? WHERE IdVenta=?");
            $query->execute(array($IdCertVenta, $idventa));
            $respuestarow = $query->rowCount();
            
                if($respuestarow>0){
                   $respuesta=array(
                    'respuesta'=>'exito',
                    'IdGestionCert'=>$IdGestionCert,
                    'numerollamadas'=>$numerollamadas
                    
                    );
                }else{
                    $respuesta=array(
                    'respuesta'=>'error',
                    'IdGestionCert'=>'',
                    'numerollamadas'=>0
                    );
                }


            }else{

            $queryHist = $this->db->prepare("INSERT INTO yifi58ge_dbVENTAS.tblgestioncertificacionventa(MatriculaAsignada, FechaAsignacion, MatriculaGestor, FechaHoraRegistro, EstadoLlamada, Comentario, FechaHoraProgramacion, numerollamadas, TipoGestion,IdCertVenta) VALUES(?,?,?,?,?,?,?,?,?,?)");
            $queryHist->execute(array($lblasignado,$lblfechaapertura_cert,$matricula,$fecharegistro,$modalestadollamada,$modalcomentario_cert,$modalfechahoraRellamada,$numerollamadas,$tipocierre_cert,$idcertventa));
            $IdGestionCert = $this->db->lastInsertId(); 

                
            $query = $this->db->prepare("UPDATE yifi58ge_dbVENTAS.tblcertificacionventa SET IdGestionCert=?,numerollamadas=?,FechaUltimaGestion=? WHERE IdCertVenta=?");
            $query->execute(array($IdGestionCert,$numerollamadas,$fecharegistro,$idcertventa));
            $respuestarow = $query->rowCount();

                if($respuestarow>0){
                   $respuesta=array(
                    'respuesta'=>'exito',
                    'IdGestionCert'=>$IdGestionCert,
                    'numerollamadas'=>$numerollamadas,
                    'fechaultimallamada'=>$fecharegistro
                    
                    );
                }else{
                    $respuesta=array(
                    'respuesta'=>'error',
                    'IdGestionCert'=>'',
                    'numerollamadas'=>0,
                    'fechaultimallamada'=>''
                    );
                }                      
            
            }
            
            return $respuesta;
    } 
    
    

    
    public function insertarCertificacionHistRespuestaComercial($idcertventa, $idventa, $gestor, $TipoAccion='Informacion',$lblcomentario_comercial,$lblhorariosugerido2,$RespComercial='SI'){
    
            $fechmod = date("Y-m-d H:i:s");
    
            $query = $this->db->prepare("INSERT INTO yifi58ge_dbVENTAS.tblcertificacionhist(IdCertificacionVenta, IdVenta, MatriculaGestor, TipoAccion,ComentarioComercial,RespComercial,nuevohorarioSugerido,FechaHoraREG) VALUES(?,?,?,?,?,?,?,?)");
            $query->execute(array($idcertventa, $idventa, $gestor, $TipoAccion,$lblcomentario_comercial,$RespComercial,$lblhorariosugerido2,$fechmod));
            $respuesta = $this->db->lastInsertId(); 
            return $respuesta;
    }    

    public function insertarCertificacion($lblfechacierre_certgrabar,$lbltipocierre_cert,$lblmotivoincidencia_cert,$hidden_inci_tecnica,$lblsolucionincidencia_cert,$lblformapago_cert,$lblcomentario_cert,$hidden_kitnoinstalado,$lblfechacorrecion_kitnoinstalado,$hidden_errorcomprobantepago,$lblfechacorrecion_errorcomprobantepago,$hidden_errorsegmento,$lblfechacorrecion_errorsegmento,$hidden_fueranomalcomercial,$lblfechacorrecion_fueranomalcomercial,$hidden_fueranormativatecnica,$lblfechacorrecion_fueranormativatecnica,$hidden_incidenciadatos,$lblfechacorrecion_incidenciadatos,$hidden_inconformidadfuncionamiento,$lblfechacorrecion_inconformidadfuncionamiento,$hidden_inconformidadpagoinicial,$lblfechacorrecion_inconformidadpagoinicial,$hidden_inconformidadpagomensual,$lblfechacorrecion_inconformidadpagomensual,$hidden_inconformidadtiempopermanencia,$lblfechacorrecion_inconformidadtiempopermanencia,$hidden_inconformidadubicaciondispositivos,$lblfechacorrecion_inconformidadubicaciondispositivos,$hidden_noconcefuncionamiento,$lblfechacorrecion_noconcefuncionamiento,$hidden_notienecontrato,$lblfechacorrecion_notienecontrato,$hidden_promesaspendientes,$lblfechacorrecion_promesaspendientes,$hidden_reclamocomercial,$lblfechacorrecion_reclamocomercial,$hidden_solicitabaja,$lblfechacorrecion_solicitabaja,$hidden_tarjetaafiliadanopertenecetitular,$lblfechacorrecion_tarjetaafiliadanopertenecetitular,$hidden_recepmanual,$lblfechacorrecion_recepmanual,$hidden_descargaapp,$lblfechacorrecion_descargaapp,$hidden_capacitado,$lblfechacorrecion_capacitado,$lblnumerollamadas,$FechaPendiente,$FechaPrimeraGestion,$FechaFinalizadoconIncidencia,$FechaResuelto){
    
            $fecharegistroventa = date("Y-m-d H:i:s");
    
            $query = $this->db->prepare("INSERT INTO yifi58ge_dbVENTAS.tblcertificacionventa(FechaCierre, TipoCierre, MotivoIncidencia, SolucionIncidencia, FechaHoraREG, IncidenciaTecnica,FormaPago,Comentario,kitnoinstalado,fechacorrecion_kitnoinstalado,errorcomprobantepago,fechacorrecion_errorcomprobantepago,errorsegmento,fechacorrecion_errorsegmento,fueranomalcomercial,fechacorrecion_fueranomalcomercial,fueranormativatecnica,fechacorrecion_fueranormativatecnica,incidenciadatos,fechacorrecion_incidenciadatos,inconformidadfuncionamiento,fechacorrecion_inconformidadfuncionamiento,inconformidadpagoinicial,fechacorrecion_inconformidadpagoinicial,inconformidadpagomensual,fechacorrecion_inconformidadpagomensual,inconformidadtiempopermanencia,fechacorrecion_inconformidadtiempopermanencia,inconformidadubicaciondispositivos,fechacorrecion_inconformidadubicaciondispositivos,noconcefuncionamiento,fechacorrecion_noconcefuncionamiento,notienecontrato,fechacorrecion_notienecontrato,promesaspendientes,fechacorrecion_promesaspendientes,reclamocomercial,fechacorrecion_reclamocomercial,solicitabaja,fechacorrecion_solicitabaja,tarjetaafiliadanopertenecetitular,fechacorrecion_tarjetaafiliadanopertenecetitular,recepmanual,fechacorrecion_recepmanual,descargaapp,fechacorrecion_descargaapp,capacitado,fechacorrecion_capacitado,numerollamadas,FechaPendiente,FechaPrimeraGestion,FechaFinalizadoconIncidencia,FechaResuelto) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $query->execute(array($lblfechacierre_certgrabar, $lbltipocierre_cert, $lblmotivoincidencia_cert, $lblsolucionincidencia_cert, $fecharegistroventa, $hidden_inci_tecnica,$lblformapago_cert,$lblcomentario_cert,$hidden_kitnoinstalado,$lblfechacorrecion_kitnoinstalado,$hidden_errorcomprobantepago,$lblfechacorrecion_errorcomprobantepago,$hidden_errorsegmento,$lblfechacorrecion_errorsegmento,$hidden_fueranomalcomercial,$lblfechacorrecion_fueranomalcomercial,$hidden_fueranormativatecnica,$lblfechacorrecion_fueranormativatecnica,$hidden_incidenciadatos,$lblfechacorrecion_incidenciadatos,$hidden_inconformidadfuncionamiento,$lblfechacorrecion_inconformidadfuncionamiento,$hidden_inconformidadpagoinicial,$lblfechacorrecion_inconformidadpagoinicial,$hidden_inconformidadpagomensual,$lblfechacorrecion_inconformidadpagomensual,$hidden_inconformidadtiempopermanencia,$lblfechacorrecion_inconformidadtiempopermanencia,$hidden_inconformidadubicaciondispositivos,$lblfechacorrecion_inconformidadubicaciondispositivos,$hidden_noconcefuncionamiento,$lblfechacorrecion_noconcefuncionamiento,$hidden_notienecontrato,$lblfechacorrecion_notienecontrato,$hidden_promesaspendientes,$lblfechacorrecion_promesaspendientes,$hidden_reclamocomercial,$lblfechacorrecion_reclamocomercial,$hidden_solicitabaja,$lblfechacorrecion_solicitabaja,$hidden_tarjetaafiliadanopertenecetitular,$lblfechacorrecion_tarjetaafiliadanopertenecetitular,$hidden_recepmanual,$lblfechacorrecion_recepmanual,$hidden_descargaapp,$lblfechacorrecion_descargaapp,$hidden_capacitado,$lblfechacorrecion_capacitado,$lblnumerollamadas,$FechaPendiente,$FechaPrimeraGestion,$FechaFinalizadoconIncidencia,$FechaResuelto));
            $respuesta = $this->db->lastInsertId(); 
            return $respuesta;
    }

	public function InformacionCorreoCertificacionIncidencia($idventa){

        $query = $this->db->prepare("SELECT 
            v.NContrato,
            v.CC,
            c.NombApellido as Cliente,
            vtacert.kitnoinstalado,
            vtacert.fechacorrecion_kitnoinstalado,
            vtacert.errorcomprobantepago,
            vtacert.fechacorrecion_errorcomprobantepago,
            vtacert.errorsegmento,
            vtacert.fechacorrecion_errorsegmento,
            vtacert.fueranomalcomercial,
            vtacert.fechacorrecion_fueranomalcomercial,
            vtacert.fueranormativatecnica,
            vtacert.fechacorrecion_fueranormativatecnica,
            vtacert.incidenciadatos,
            vtacert.fechacorrecion_incidenciadatos,
            vtacert.inconformidadfuncionamiento,
            vtacert.fechacorrecion_inconformidadfuncionamiento,
            vtacert.inconformidadpagoinicial,
            vtacert.fechacorrecion_inconformidadpagoinicial,
            vtacert.inconformidadpagomensual,
            vtacert.fechacorrecion_inconformidadpagomensual,
            vtacert.inconformidadtiempopermanencia,
            vtacert.fechacorrecion_inconformidadtiempopermanencia,
            vtacert.inconformidadubicaciondispositivos,
            vtacert.fechacorrecion_inconformidadubicaciondispositivos,
            vtacert.noconcefuncionamiento,
            vtacert.fechacorrecion_noconcefuncionamiento,
            vtacert.notienecontrato,
            vtacert.fechacorrecion_notienecontrato,
            vtacert.promesaspendientes,
            vtacert.fechacorrecion_promesaspendientes,
            vtacert.reclamocomercial,
            vtacert.fechacorrecion_reclamocomercial,
            vtacert.solicitabaja,
            vtacert.fechacorrecion_solicitabaja,
            vtacert.tarjetaafiliadanopertenecetitular,
            vtacert.fechacorrecion_tarjetaafiliadanopertenecetitular,
            vtacert.recepmanual,
            vtacert.fechacorrecion_recepmanual,
            vtacert.descargaapp,
            vtacert.fechacorrecion_descargaapp,
            vtacert.capacitado,
            vtacert.fechacorrecion_capacitado,
            vtacert.Comentario,
            vtacert.TipoCierre,
            vtacert.SolucionIncidencia,
            u.Correo CorreoComercial, 
            m.Correo CorreoJefeVenta
            FROM yifi58ge_dbVENTAS.tblventa v
            INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
            LEFT JOIN yifi58ge_dbVENTAS.tblcertificacionventa vtacert on vtacert.IdCertVenta=v.IdCertVenta
            LEFT JOIN yifi58ge_dbUSUARIO.tblusuario u ON v.IdUsuario = u.IdUsuario
    		LEFT JOIN yifi58ge_dbUSUARIO.tblusuario m ON u.Manager = m.Matricula
            WHERE v.IdVenta=?");
            
            $query->execute(array($idventa));
    		$retorno = [];
    		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
    			$retorno[] = $fila;
    		}

		return $retorno;
			
	}
	
	public function InformacionCorreoCertificacionIncidenciaModal($idventa){

        $query = $this->db->prepare("SELECT 
            v.NContrato,
            v.CC,
            c.NombApellido as Cliente,
            vtacert.jsonIncidencias,
            vtacert.TipoCierre,
            vtacert.SolucionIncidencia,
            u.Correo as CorreoComercial, 
            m.Correo as CorreoJefeVenta
            FROM yifi58ge_dbVENTAS.tblventa v
            INNER JOIN yifi58ge_dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
            LEFT JOIN yifi58ge_dbVENTAS.tblcertificacionventa vtacert on vtacert.IdCertVenta=v.IdCertVenta
            LEFT JOIN yifi58ge_dbUSUARIO.tblusuario u ON v.IdUsuario = u.IdUsuario
    		LEFT JOIN yifi58ge_dbUSUARIO.tblusuario m ON u.Manager = m.Matricula
            WHERE v.IdVenta=?");
            
            $query->execute(array($idventa));
    		$retorno = [];
    		while ($fila = $query->fetch(PDO::FETCH_ASSOC)) {
    			$retorno[] = $fila;
    		}

		return $retorno;
			
	}
	
    
    
//***************FIN CERTIFICACION DE VENTA    


}
