<?php
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Expose-Headers: Content-Length, X-JSON");
    header("Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS");
    header("Access-Control-Allow-Headers: *");
require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';

date_default_timezone_set('America/Lima');

$tipo       = $_FILES['archivo_csv']['type'];
$tamanio    = $_FILES['archivo_csv']['size'];
$archivotmp = $_FILES['archivo_csv']['tmp_name'];
$lineas     = file($archivotmp);

$i = 0;

foreach ($lineas as $linea) {
    $cantidad_registros = count($lineas);
    $cantidad_regist_agregados =  ($cantidad_registros - 1);
    $hoy = date("Y-m-d");
    if ($i != 0) {

        $datos = explode(";",$linea);
       
        $contrato = !empty($datos[0])  ? (sanitizaCampo($datos[0], 'sanitizeint|scapestring|htmlspecialchars',$con)) : '';
        $contrato = htmlspecialchars($contrato);
		$montoDeuda = !empty($datos[1])  ? (sanitizaCampo($datos[1], 'sanitizestring|scapestring|htmlspecialchars',$con)) : '0';
		$montoDeuda = htmlspecialchars($montoDeuda);
        $condicionAmpliar = !empty(trim(eliminar_acentos($datos[2])))  ? (sanitizaCampo(trim(eliminar_acentos($datos[2])), 'sanitizestring|scapestring|htmlspecialchars',$con)) : '';
        $condicionAmpliar = htmlspecialchars($condicionAmpliar);
        $formaPago = !empty(trim(eliminar_acentos($datos[3])))  ? (sanitizaCampo(trim(eliminar_acentos($datos[3])), 'sanitizestring|scapestring|htmlspecialchars',$con)) : '';
        $formaPago = htmlspecialchars($formaPago);

        if( !empty($contrato) ){
            $checkecontrato_duplicidad = $con->prepare("SELECT d.contrato FROM yifi58ge_dbVENTAS.tbldeudas d WHERE d.contrato=? ");
            $checkecontrato_duplicidad->bind_param('i',$contrato);
            $checkecontrato_duplicidad->execute();
            $checkecontrato_duplicidad->store_result();
            $cant_duplicidad = $checkecontrato_duplicidad->num_rows;
        }   
        
        //No existe Registros Duplicados
        if ( $cant_duplicidad == 0 ) { 
            
            $insertarData = $con->prepare("INSERT INTO yifi58ge_dbVENTAS.tbldeudas(contrato,montoDeuda,condicionAmpliar,formaPago,fechaUltimaModificacion) VALUES(?,?,?,?,?)");
            $insertarData->bind_param('issss',$contrato,$montoDeuda,$condicionAmpliar,$formaPago,$hoy);
            $insertarData->execute();
                
        } 
        /**Caso Contrario actualizo el o los Registros ya existentes*/
        else{
            $updateData =  $con->prepare("UPDATE yifi58ge_dbVENTAS.tbldeudas SET montoDeuda=?,condicionAmpliar=?,formaPago=?,fechaUltimaModificacion=? WHERE contrato = ? ");
            $updateData->bind_param('ssssi',$montoDeuda,$condicionAmpliar,$formaPago,$hoy,$contrato);
            $updateData->execute();
        
        } 
    }

    $i++;
}

    echo $cantidad_regist_agregados;