<?php
require dirname(__DIR__).'/ajax/is_logged.php';
require dirname(__DIR__).'/Connection/Conection.php';
require dirname(__DIR__).'/Model/ConexionReferidoRPPR.php';

date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}


if (isset($_POST['function']) && !empty($_POST['function'])) {

    $function = json_decode($_POST['function']);

    switch ($function->array) {
        case 'array1':
            $consulta = new ReferidoRPPR;
            $consulta->RegistrarReferido();
            break;
        case 'array2':
            $consulta = new ReferidoRPPR;
            $consulta->MostrarDatosReferido();
            break;
        case 'array3':
            $consulta = new ReferidoRPPR;
            $consulta->ListarColaboradores();
            break;
        case 'array4':
            $consulta = new ReferidoRPPR;
            $consulta->MostrarColaboradorporID();
            break;
        case 'array5':
            $consulta = new ReferidoRPPR;
            $consulta->ActualizarporEstado();
            break;
        case 'array6':
            $consulta = new ReferidoRPPR;
            $consulta->ActualizarDatos();
            break;
        case 'array7':
            $consulta = new ReferidoRPPR;
            $consulta->ActualizarImagenes();
            break;            
        default:
            echo "Error no se encontro la data";
            break;
    }

}



class ReferidoRPPR
{

    public function RegistrarReferido()
    {
        
        $function = json_decode($_POST['function']);
        

$PrimerNombre=htmlspecialchars($function->lblprimernombre);
if ($PrimerNombre == '' || empty($PrimerNombre)){
    $FechaNacimiento = NULL;
}
$SegundoNombre=htmlspecialchars($function->lblsegundonombre);
if ($SegundoNombre == '' || empty($SegundoNombre)){
    $SegundoNombre = NULL;
}
$ApellidoPaterno=htmlspecialchars($function->lblapellidopaterno);
$ApellidoMaterno=htmlspecialchars($function->lblapellidomaterno);
$TipoDocumento=htmlspecialchars($function->lbltipodoc);
$Documento=htmlspecialchars($function->lbldocumento);
$Telefono=htmlspecialchars($function->lbltelefono);
$Correo=htmlspecialchars($function->lblcorreo);
$FechaNacimiento=htmlspecialchars($function->lblfechanacimiento);
if ($FechaNacimiento == '' || empty($FechaNacimiento)){
    $FechaNacimiento = NULL;
} else {
    $FechaNacimiento=  myUrlEncode($FechaNacimiento);
    $FechaNacimiento=  format_date_Y_mm_dd(str_replace('/', '-', $FechaNacimiento));
}
$Direccion=htmlspecialchars($function->lbldireccion);
$Distrito=htmlspecialchars($function->Distrital);
$Provincia=htmlspecialchars($function->Provincial);
$Departamento=htmlspecialchars($function->Departamental);
$CodUbigeoReniec=htmlspecialchars($function->CodigoUbigeo);
$FechaHoraREG=date('Y-m-d H:i:s');
$MatriculaREG=htmlspecialchars($function->lblmatriculareg);
$EstadoReferido="PendienteValidacion";

$imagenes=$function->imagenes;


$conexion = new ConexionReferidoRPPR();

 $resultadoDuplicidad=$conexion->validarcolaborador($Documento);

if($resultadoDuplicidad>0){
    $resultado=array('respuesta'=>'duplicado','idReferido'=>$Documento);
    print_r(json_encode($resultado));
    exit();
    
}

        $resultadoRegistro = $conexion->registrarcolaborador(
                            $PrimerNombre,
                            $SegundoNombre,
                            $ApellidoPaterno,
                            $ApellidoMaterno,
                            $TipoDocumento,
                            $Documento,
                            $Telefono,
                            $Correo,
                            $FechaNacimiento,
                            $Direccion,
                            $Distrito,
                            $Provincia,
                            $Departamento,
                            $CodUbigeoReniec,
                            $FechaHoraREG,
                            $MatriculaREG,
                            $EstadoReferido,
                            $imagenes
                            );
                            
        if($resultadoRegistro>0){
            $resultado=array('respuesta'=>'exito','idReferido'=>$Documento);
        }else{
            $resultado=array('respuesta'=>'error','idReferido'=>'');
        }
        
        print_r(json_encode($resultado));

        
        
    }
    public function MostrarDatosReferido(){
        
        $function = json_decode($_POST['function']);
        
        $Documento=htmlspecialchars($function->lbldocumento);

        $conexion = new ConexionReferidoRPPR();
        
        $datos=$conexion->mostrardatoscolaborador($Documento);
        
        print_r(json_encode($datos[0]));
        
    }
    
    public function ListarColaboradores()
    {
        $function = json_decode($_POST['function']);

        $conexion = new ConexionReferidoRPPR();
        
        $datos=$conexion->mostrarTodosColaboradores($function);

        print_r(json_encode($datos));
        
    }
    
    public function MostrarColaboradorporID(){

        $function = json_decode($_POST['function']);
        
        $idColaborador=htmlspecialchars($function->idColaborador);
        
        $conexion = new ConexionReferidoRPPR();
        
        $datos=$conexion->mostrardatoscolaboradorporID($idColaborador);

        print_r(json_encode($datos));
        
    }

    public function ActualizarporEstado(){

        $function = json_decode($_POST['function']);
        
        $idColaborador=htmlspecialchars($function->idColaborador);
        $estado=htmlspecialchars($function->estado);
        
        $conexion = new ConexionReferidoRPPR();
        
        $datos=$conexion->actualizarporEstado($idColaborador,$estado);

        print_r(json_encode($datos));
        
    }

    public function ActualizarDatos(){

        $function = json_decode($_POST['function']);
        
$PrimerNombre=htmlspecialchars($function->lblprimernombre);
if ($PrimerNombre == '' || empty($PrimerNombre)){
    $FechaNacimiento = NULL;
}
$SegundoNombre=htmlspecialchars($function->lblsegundonombre);
if ($SegundoNombre == '' || empty($SegundoNombre)){
    $SegundoNombre = NULL;
}
$ApellidoPaterno=htmlspecialchars($function->lblapellidopaterno);
$ApellidoMaterno=htmlspecialchars($function->lblapellidomaterno);

$Telefono=htmlspecialchars($function->lbltelefono);
$Correo=htmlspecialchars($function->lblcorreo);
$FechaNacimiento=htmlspecialchars($function->lblfechanacimiento);
if ($FechaNacimiento == '' || empty($FechaNacimiento)){
    $FechaNacimiento = NULL;
} else {
    $FechaNacimiento=  myUrlEncode($FechaNacimiento);
    $FechaNacimiento=  format_date_Y_mm_dd(str_replace('/', '-', $FechaNacimiento));
}
$Direccion=htmlspecialchars($function->lbldireccion);
$Distrito=htmlspecialchars($function->Distrital);
$Provincia=htmlspecialchars($function->Provincial);
$Departamento=htmlspecialchars($function->Departamental);
$CodUbigeoReniec=htmlspecialchars($function->CodigoUbigeo);
$Observacion=htmlspecialchars($function->Observacion);
$idColaborador=htmlspecialchars($function->idColaborador);



        
        $conexion = new ConexionReferidoRPPR();
        
  $resultadoActualizado = $conexion->actualizarcolaborador(
                            $PrimerNombre,
                            $SegundoNombre,
                            $ApellidoPaterno,
                            $ApellidoMaterno,
                            $Telefono,
                            $Correo,
                            $FechaNacimiento,
                            $Direccion,
                            $Distrito,
                            $Provincia,
                            $Departamento,
                            $CodUbigeoReniec,
                            $Observacion,
                            $idColaborador
                            );
                            
        if($resultadoActualizado>0){
            $resultado=array('respuesta'=>'exito','idReferido'=>$Documento);
        }else{
            $resultado=array('respuesta'=>'error','idReferido'=>'');
        }
        
        print_r(json_encode($resultado));

        
    }


     public function ActualizarImagenes(){

        $function = json_decode($_POST['function']);
        

        $imagenes=$function->imagenes;
        $idColaborador=htmlspecialchars($function->idColaborador);
        
        $conexion = new ConexionReferidoRPPR();
        
        $resultadoActualizado = $conexion->actualizarcolaboradorimagenes(
                            $imagenes,
                            $idColaborador
                            );
                            
        if($resultadoActualizado>0){
            $resultado=array('respuesta'=>'exito','idReferido'=>'');
        }else{
            $resultado=array('respuesta'=>'error','idReferido'=>'');
        }
        
        print_r(json_encode($resultado));

        
    }

   
    
    
        

}


    function EnvioCorreo_Respuesta($arrayCliente,$correoenviomdp,$lblstatusafiliacion,$lblmotivoafiliacion){
        //ESTRUCTURA DEL CORREO ACTUALIZADO
        //DELEGADO
        //VARIABLES GLOBALES

        $NContrato=$arrayCliente[0]['NContrato'];
        $Cliente=$arrayCliente[0]['Cliente'];
        
        $arrayNombre=explode(" ",$Cliente);
        
        $NombresScoring=$arrayCliente[0]['NombresScoring'];
        $ApellidoPaternoScoring=$arrayCliente[0]['ApellidoPaternoScoring'];
        $ApellidoMaternoScoring=$arrayCliente[0]['ApellidoMaternoScoring'];
        $TipoDocumentoScoring=$arrayCliente[0]['TipoDocumentoScoring'];
        $DocumentoScoring=$arrayCliente[0]['DocumentoScoring'];
        
        if($TipoDocumentoScoring==6 || $TipoDocumentoScoring==""){
                    $TipoDocumentoScoring="0";
                    $DocumentoScoring="00000000";
                    if(count($arrayNombre)==1){
                        $NombresScoring=$arrayNombre[0];
                        $ApellidoPaternoScoring=" ";
                        $ApellidoMaternoScoring=" ";                    
                    }else if(count($arrayNombre)==2){
                        $NombresScoring=$arrayNombre[0];
                        $ApellidoPaternoScoring=$arrayNombre[1];
                        $ApellidoMaternoScoring=" ";   
                    }else{
                        $NombresScoring=$arrayNombre[0];
                        $ApellidoPaternoScoring=$arrayNombre[1];
                        $ApellidoMaternoScoring=$arrayNombre[2];
                    }         
            
        }else if($TipoDocumentoScoring==3){
                    $TipoDocumentoScoring=1;
                    $DocumentoScoring=substr($DocumentoScoring, 3);
        }else{
                    $TipoDocumentoScoring=0;
                    $DocumentoScoring=substr($DocumentoScoring, 3);
        }

        $url="";
        $url=$NContrato."-".$NombresScoring."-".$ApellidoPaternoScoring." ".$ApellidoMaternoScoring."-".$DocumentoScoring."-".$TipoDocumentoScoring."-".$correoenviomdp;
        
        if($lblstatusafiliacion=="RECHAZADO"){
        $titulo = "Solicitud de Afiliación Rechazada - Verisure Perú " . $NContrato;
        $codigo=400;
        $concatenado=$codigo."/".rawurlencode($lblmotivoafiliacion)."/".rawurlencode($url);
        }else if($lblstatusafiliacion=="AFILIADO"){
        $titulo = "Solicitud de Afiliación Aprobada - Verisure Perú " . $NContrato;
        $codigo=201;
        $concatenado=$codigo;
        }else{
        $titulo = "Solicitud de Afiliación En Proceso - Verisure Perú " . $NContrato;
        $codigo=200;
        $concatenado=$codigo;
        }



        $opts = array(
            'http'=>array(
            'method'=>"GET",
            'header'=>"User-Agent: api script\r\n"
        ));
        $context = stream_context_create($opts);
    
        $curl = curl_init();
        
        $dataSC= array (
          'GeneralData' => 
          array (
            'FromName' => 'Administración - Verisure Perú',
            'From' => 'administracion@verisure.pe',
            'To' => 
                array (
                  'Email' => 
                  array (
                    0 => $correoenviomdp
                  )
                ),
            'Cc' => 
                array (
                  'Email' => 
                    array (
                        0 => '',
                    )
                ),
            'Bcc' => 
                array (
                    'Email' => 
                        array (
                            0 => 'joseenrique.nanquen@verisure.pe'
                        )
                ),
            'Message' => 
                array (
                    'Subject' => $titulo,
                    'Classification' => 'T',
                    'Body' => 
                        array (
                            'Format' => 'html',
                            'Value' => file_get_contents("https://clientesverisure.com/apps/afiliacion-otros/email-otros/$concatenado",false,$context),
                        )
                ),
            'Options' => 
                array (
                  'OpenTracking' => 'true',
                  'ClickTracking' => 'true',
                  'TextHtmlTracking' => 'true',
                  'AutoTextBody' => 'false',
                )
          )
        );
        
        $dataSC_string = json_encode($dataSC);
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api2023.masterbase.com/UniqueMail/v3/verisuremktpe",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 60,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $dataSC_string,
            CURLOPT_HTTPHEADER => array(
                "authorization: Basic U2VjdXJpdHlfY2hlY2s6Njc1NC1TQDlxYTAjZDZVN2MzdzU=",
                "cache-control: no-cache",
                "content-type: application/json"
            ),
        ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
          return "cURL Error #:" . $err;
        } else {
          return $response;
        }    
    
    }



?>