<?php
require dirname(__DIR__).'/ajax/is_logged.php';
require dirname(__DIR__).'/Connection/Conection.php';
require dirname(__DIR__).'/Model/ConexionRPADavid.php';

date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}


if (isset($_POST['function']) && !empty($_POST['function'])) {

    $function = json_decode($_POST['function']);

    switch ($function->array) {
        case 'array1':
            $consulta = new RPA;
            $consulta->ObtenerAFILIACION();
            break;
        case 'array2':
            $consulta = new RPA;
            $consulta->CambioEstadoAFILIACION();
            break;
        case 'array3':
            $consulta = new RPA;
            $consulta->ListarRpa();
            break;
        // case 'array4':
        //     $consulta = new TVReferidos;
        //     $consulta->ObtenerTelefono();
        //     break;            
        // case 'array5':
        //     $consulta = new TVReferidos;
        //     $consulta->ObtenerDatosUsuario();
        //     break;
        // case 'array6':
        //     $consulta = new TVReferidos;
        //     $consulta->ActualizarClienteProspecto();
        //     break;            
        default:
            echo "Error no se encontro la data";
            break;
    }

}



class RPA
{
    public function ListarRpa()
    {

        $function = json_decode($_POST['function']);

        $conexion = new ConexionRPADavid();
        
        $datos=$conexion->ListarRpa($function);

        print_r(json_encode($datos)); 
        

    }

    public function ObtenerAFILIACION()
    {
        $function = json_decode($_POST['function']);
        $contrato=htmlspecialchars($function->contrato);
        
        $conexion = new ConexionRPA();

		$datosVisa_MasterCard = $conexion->getAfiliacionVisa_MasterCard($contrato);
		$datosOtros = $conexion->getAfiliacionOtros($contrato);
		$datos=array();
		
		$datosV=array();
		if(count($datosVisa_MasterCard)>0){
		    foreach($datosVisa_MasterCard as $clave => $valor){

            $estadoafiliacion=$valor['status'];
            $ACTION_DESCRIPTION=$valor['ACTION_DESCRIPTION'];
            $dataMap=$valor['dataMap'];

                if(isset($dataMap) && !empty($dataMap)){
                    $objAfiliacion=json_decode($dataMap, true);
                    if(isset($objAfiliacion['mensaje_autorizacion']['dataMap']['CARD'])){
                        $card=$objAfiliacion['mensaje_autorizacion']['dataMap']['CARD'];
                        $tipocuenta='Tarjeta';
                    }else{
                        $card='';
                        $tipocuenta='';
                    }
                }
            
                $datos[0]=[
                     'resultado'=>'encontrado',
                     'estadoafiliacion'=> $estadoafiliacion,
                     'ACTION_DESCRIPTION'=> $ACTION_DESCRIPTION,
                     'cardafiliacion'=> $card,
                     'tipocuentafiliacion'=> $tipocuenta,
                    ];
		        
		    } 
    
		}else{
		    
                $datos[0]=[
                     'resultado'=>'noencontrado',
                     'estadoafiliacion'=> 'Pendiente',
                     'ACTION_DESCRIPTION'=> '',
                     'cardafiliacion'=> '',
                     'tipocuentafiliacion'=> '',
                    ];		    
		    
		}
		
        $datosO=array();
        $variablecuenta=array('Diners Club','visa','mastercard','American Express');
		if(count($datosOtros)>0){
		    foreach($datosOtros as $clave => $valor){

            $idnmdp=$valor['id'];
            $estadoafiliacionmdp=$valor['status'];
            $motivomdp=$valor['motivo'];
            $cardmdp=$valor['numero'];
            $tipomdp=$valor['tipo'];
            $correoenviomdp=$valor['correo'];
            if(in_array($tipomdp,$variablecuenta)){
               $tipocuentamdp='Tarjeta'; 
            }else{
               $tipocuentamdp='Cuenta'; 
            }
            
                $datos[0]+=[
                    'resultadomdp'=>'encontrado',
                    'idnmdp'=> $idnmdp,
                    'estadoafiliacionmdp'=> $estadoafiliacionmdp,
                    'motivomdp'=> $motivomdp,
                    'cardmdp'=> $cardmdp,
                    'tipomdp'=> $tipomdp,
                    'correoenviomdp'=> $correoenviomdp,
                    'tipocuentamdp'=> $tipocuentamdp,
                    ];
		        
		    } 
    
		}else{

                $datos[0]+=[
                    'resultadomdp'=>'noencontrado',
                    'idnmdp'=> '',
                    'estadoafiliacionmdp'=> '',
                    'motivomdp'=> '',
                    'cardmdp'=> '',
                    'tipomdp'=> '',
                    'correoenviomdp'=> '',
                    'tipocuentamdp'=> '',
                    ];
		    
		}
		
// 		$datos = array_merge($datosV, $datosO);
		
        print_r(json_encode($datos));
        
    }

    public function CambioEstadoAFILIACION()
    {
        //ContratoPrueba:1579625
        $function = json_decode($_POST['function']);
        $idafiliacion=htmlspecialchars($function->idafiliacion);
        $lblstatusafiliacion=htmlspecialchars($function->lblstatusafiliacion);
        $lblmotivoafiliacion=htmlspecialchars($function->lblmotivoafiliacion);
        $correoenviomdp=htmlspecialchars($function->correoenviomdp);
        $contrato=htmlspecialchars($function->contrato);
        $fechahoramod = date("Y-m-d H:i:s");
        
        $conexion = new ConexionRPA();
        
    

        $resultadoAfiliacion = $conexion->actualizarAfiliacion($idafiliacion,$lblstatusafiliacion,$lblmotivoafiliacion,$fechahoramod);
        if($resultadoAfiliacion>0){
            $resultado=array('respuesta'=>'exito');
        }else{
            $resultado=array('respuesta'=>'error');
        }
        
        $afiliacionotros=$conexion->findAfiliacionOtros($contrato);
        if($afiliacionotros>0){
            $resultadoAfiliacionOtros=$conexion->actualizarAfiliacionOtros($afiliacionotros,$lblstatusafiliacion);
        }
        
        $datosClientesVentas=$conexion->getDatosClientesVentas($contrato);
        $datosC=array();
		if(count($datosClientesVentas)>0){
		    EnvioCorreo_Respuesta($datosClientesVentas,$correoenviomdp,$lblstatusafiliacion,$lblmotivoafiliacion);
		}
        

        
        print_r(json_encode($resultado));

        
        
    }


        

}


    function EnvioCorreo_Respuesta($arrayCliente,$correoenviomdp,$lblstatusafiliacion,$lblmotivoafiliacion){
        //ESTRUCTURA DEL CORREO ACTUALIZADO
        //DELEGADO
        //VARIABLES GLOBALES

        $NContrato=$arrayCliente[0]['NContrato'];
        $Cliente=$arrayCliente[0]['Cliente'];
        
        $arrayNombre=explode(" ",$Cliente);
        
        $NombresScoring=$arrayCliente[0]['NombresScoring'];
        $ApellidoPaternoScoring=$arrayCliente[0]['ApellidoPaternoScoring'];
        $ApellidoMaternoScoring=$arrayCliente[0]['ApellidoMaternoScoring'];
        $TipoDocumentoScoring=$arrayCliente[0]['TipoDocumentoScoring'];
        $DocumentoScoring=$arrayCliente[0]['DocumentoScoring'];
        
        if($TipoDocumentoScoring==6 || $TipoDocumentoScoring==""){
                    $TipoDocumentoScoring="0";
                    $DocumentoScoring="00000000";
                    if(count($arrayNombre)==1){
                        $NombresScoring=$arrayNombre[0];
                        $ApellidoPaternoScoring=" ";
                        $ApellidoMaternoScoring=" ";                    
                    }else if(count($arrayNombre)==2){
                        $NombresScoring=$arrayNombre[0];
                        $ApellidoPaternoScoring=$arrayNombre[1];
                        $ApellidoMaternoScoring=" ";   
                    }else{
                        $NombresScoring=$arrayNombre[0];
                        $ApellidoPaternoScoring=$arrayNombre[1];
                        $ApellidoMaternoScoring=$arrayNombre[2];
                    }         
            
        }else if($TipoDocumentoScoring==3){
                    $TipoDocumentoScoring=1;
                    $DocumentoScoring=substr($DocumentoScoring, 3);
        }else{
                    $TipoDocumentoScoring=0;
                    $DocumentoScoring=substr($DocumentoScoring, 3);
        }

        $url="";
        $url=$NContrato."-".$NombresScoring."-".$ApellidoPaternoScoring." ".$ApellidoMaternoScoring."-".$DocumentoScoring."-".$TipoDocumentoScoring."-".$correoenviomdp;
        
        if($lblstatusafiliacion=="RECHAZADO"){
        $titulo = "Solicitud de Afiliación Rechazada - Verisure Perú " . $NContrato;
        $codigo=400;
        $concatenado=$codigo."/".rawurlencode($lblmotivoafiliacion)."/".rawurlencode($url);
        }else if($lblstatusafiliacion=="AFILIADO"){
        $titulo = "Solicitud de Afiliación Aprobada - Verisure Perú " . $NContrato;
        $codigo=201;
        $concatenado=$codigo;
        }else{
        $titulo = "Solicitud de Afiliación En Proceso - Verisure Perú " . $NContrato;
        $codigo=200;
        $concatenado=$codigo;
        }



        $opts = array(
            'http'=>array(
            'method'=>"GET",
            'header'=>"User-Agent: api script\r\n"
        ));
        $context = stream_context_create($opts);
    
        $curl = curl_init();
        
        $dataSC= array (
          'GeneralData' => 
          array (
            'FromName' => 'Administración - Verisure Perú',
            'From' => 'administracion@verisure.pe',
            'To' => 
                array (
                  'Email' => 
                  array (
                    0 => $correoenviomdp
                  )
                ),
            'Cc' => 
                array (
                  'Email' => 
                    array (
                        0 => '',
                    )
                ),
            'Bcc' => 
                array (
                    'Email' => 
                        array (
                            0 => 'joseenrique.nanquen@verisure.pe'
                        )
                ),
            'Message' => 
                array (
                    'Subject' => $titulo,
                    'Classification' => 'T',
                    'Body' => 
                        array (
                            'Format' => 'html',
                            'Value' => file_get_contents("https://clientesverisure.com/apps/afiliacion-otros/email-otros/$concatenado",false,$context),
                        )
                ),
            'Options' => 
                array (
                  'OpenTracking' => 'true',
                  'ClickTracking' => 'true',
                  'TextHtmlTracking' => 'true',
                  'AutoTextBody' => 'false',
                )
          )
        );
        
        $dataSC_string = json_encode($dataSC);
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api2023.masterbase.com/UniqueMail/v3/verisuremktpe",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 60,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $dataSC_string,
            CURLOPT_HTTPHEADER => array(
                "authorization: Basic U2VjdXJpdHlfY2hlY2s6Njc1NC1TQDlxYTAjZDZVN2MzdzU=",
                "cache-control: no-cache",
                "content-type: application/json"
            ),
        ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
          return "cURL Error #:" . $err;
        } else {
          return $response;
        }    
    
    }



?>