<?php
require dirname(__DIR__).'/ajax/is_logged.php';
require dirname(__DIR__).'/Connection/Conection.php';
require dirname(__DIR__).'/Model/ConexionAmpliacion.php';

date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}


if (isset($_POST['function']) && !empty($_POST['function'])) {

    $function = json_decode($_POST['function']);

    switch ($function->array) {
        case 'array1':
            $consulta = new Ampliacion;
            $consulta->obtenerDatosClientes();
            break;
        case 'array2':
            $consulta = new Ampliacion;
            $consulta->obtenerDatosItem();
            break;
        case 'array3':
            $consulta = new Ampliacion;
            $consulta->obtenerDatosUnItem();
            break;
        case 'array4':
            $consulta = new Ampliacion;
            $consulta->envioCorreoCotizacion();
            break;
        case 'array5':
            $consulta= new Ampliacion;
            $consulta->ListarCotizacion();
            break;
        case 'array6':
            $consulta= new Ampliacion;
            $consulta->ListarCotizacion360();
            break;            
        default:
            echo "Error no se encontro la data";
            break;
    }

}



class Ampliacion
{

    public function obtenerDatosClientes()
    {
        $function = json_decode($_POST['function']);
        $contrato=htmlspecialchars($function->contrato);
        
        
        
        $conexion = new ConexionAmpliacion();

		$datosClientes = $conexion->obtenerInformacionCliente($contrato);
		$datosHistorico= $conexion->obtenerHistorialCotizacion($contrato);
        

		if (!empty($datosClientes)) {
				$resultado = array(
					'datosClientes' => $datosClientes,
					'datosHistorico' => $datosHistorico,
				
				);
		} else {
			$resultado = array();
		}        


        echo json_encode($resultado, JSON_NUMERIC_CHECK);

    }

    public function obtenerDatosItem()
    {
        $function = json_decode($_POST['function']);
        $q=htmlspecialchars($function->q);
        
        $conexion = new ConexionAmpliacion();
        
        $datosItem = $conexion->obtenerDatosItem($q);
        
		if (!empty($datosItem)) {

			foreach ($datosItem as $items) {
				$resultado[] = array(
					'IdItem' => (string) $items['IdItem'],
					'CodItem' => (string) $items['CodItem'],
					'Item' => (string) $items['Item'],
					'Precio' => (string) $items['Precio'],
					'P_CATALOGO' => (string) $items['P_CATALOGO'],
					'P_ALTO' => (string) $items['P_ALTO'],
					'P_MEDIO' => (string) $items['P_MEDIO'],
					'P_BAJO' => (string) $items['P_BAJO'],
					'P_SUPERVISOR' => (string) $items['P_SUPERVISOR'],
					'CuotaMes' => (string) $items['CuotaMes'],
					'id'=>$items['IdItem'],
					'text'=>$items['Item']
				);
			}		    
		    
		} else {
			$resultado = array();
		}         
        
        echo json_encode($resultado, JSON_NUMERIC_CHECK);
        

    }
    
    public function obtenerDatosUnItem()
    {
        $function = json_decode($_POST['function']);
        $Producto=htmlspecialchars($function->Producto);
        
        $conexion = new ConexionAmpliacion();
        
        $datosItem = $conexion->obtenerDatosUnItem($Producto);
        
		if (!empty($datosItem)) {

			foreach ($datosItem as $items) {
				$resultado= array(
					'IdItem' => (string) $items['IdItem'],
					'CodItem' => (string) $items['CodItem'],
					'Item' => (string) $items['Item'],
					'Precio' => (string) $items['Precio'],
					'P_CATALOGO' => (string) $items['P_CATALOGO'],
					'P_ALTO' => (string) $items['P_ALTO'],
					'P_MEDIO' => (string) $items['P_MEDIO'],
					'P_BAJO' => (string) $items['P_BAJO'],
					'P_SUPERVISOR' => (string) $items['P_SUPERVISOR'],
					'CuotaMes' => (string) $items['CuotaMes'],
					'id'=>$items['IdItem'],
					'text'=>$items['Item']
				);
			}		    
		    
		} else {
			$resultado = array();
		}         
        
        echo json_encode($resultado, JSON_NUMERIC_CHECK);
        

    }    

    public function envioCorreoCotizacion()
    {
        $function = json_decode($_POST['function']);
        $idAmpl=htmlspecialchars($function->idAmpl);
        $lblcorreoconsolidado=htmlspecialchars($function->lblcorreoconsolidado);
        

        $conexion = new ConexionAmpliacion();

		$arrayDatosEnvioCorreo = $conexion->obtenerDatosEnvioCorreo($idAmpl);
		$arrayDatosItemImagenesCotizacion = $conexion->obtenerItemImagenesCotizacion();
		
		$resultado=EnvioCorreo_Respuesta($arrayDatosEnvioCorreo,$lblcorreoconsolidado,$arrayDatosItemImagenesCotizacion,$idAmpl);
		
         

        echo json_encode($resultado, JSON_NUMERIC_CHECK);

    }    
    
    public function ListarCotizacion()
    {

        $function = json_decode($_POST['function']);

        $conexion = new ConexionAmpliacion();
        
        $datos=$conexion->mostrarTodosCotizaciones($function);

        print_r(json_encode($datos)); 
        

    }
    
    public function ListarCotizacion360(){
        $function = json_decode($_POST['function']);
        $matricula=htmlspecialchars($function->matricula);
        $perfil=htmlspecialchars($function->perfil);
        
        $conexion = new ConexionAmpliacion();
        
        $TotalAmpliacionesRealizadas=$conexion->obtenerTotalAmpliacionesRealizadas($matricula,$perfil);
        $TotalPendienteRespuesta=$conexion->obtenerTotalPendienteRespuesta($matricula,$perfil);
        $TotalPendienteInstalacion=$conexion->obtenerTotalPendienteInstalacion($matricula,$perfil);

        $datos=array(
            'TotalAmpliacionesRealizadas'=>$TotalAmpliacionesRealizadas,
            'TotalPendienteRespuesta'=>$TotalPendienteRespuesta,
            'TotalPendienteInstalacion'=>$TotalPendienteInstalacion
            );

        print_r(json_encode($datos)); 

    }


        

}


    function EnvioCorreo_Respuesta($arrayDatosEnvioCorreo,$lblcorreoconsolidado,$arrayDatosItemImagenesCotizacion,$idAmpl){

        date_default_timezone_set('America/Lima');
        $fechahoy=date("d/m/Y");
        
        $fecha_actual = date("d-m-Y");
        //sumo 1 día
        $promocion= date("d/m/Y",strtotime($fecha_actual."+ 7 days"));         

        //ESTRUCTURA DEL CORREO ACTUALIZADO
        //DELEGADO
        //VARIABLES GLOBALES
        if(count($arrayDatosEnvioCorreo)>0){

            $IdCliente=$arrayDatosEnvioCorreo[0]['IdCliente'];
            $IdGeografico=$arrayDatosEnvioCorreo[0]['IdGeografico'];
            $Distrito=$arrayDatosEnvioCorreo[0]['Distrito'];
            $Provincia=$arrayDatosEnvioCorreo[0]['Provincia'];
            $NombApellido=strtoupper($arrayDatosEnvioCorreo[0]['NombApellido']);
            $Telefonouno=$arrayDatosEnvioCorreo[0]['Telefonouno'];
            $Telefonodos=$arrayDatosEnvioCorreo[0]['Telefonodos'];
            $Correo=$arrayDatosEnvioCorreo[0]['Correo'];
            $Direccion=$arrayDatosEnvioCorreo[0]['Direccion'];
            $NCliente=$arrayDatosEnvioCorreo[0]['NCliente'];
            $Correodos=$arrayDatosEnvioCorreo[0]['Correodos'];
            $NAviso=$arrayDatosEnvioCorreo[0]['NAviso'];
            $Segmento=$arrayDatosEnvioCorreo[0]['Segmento'];
            $NMantenimiento=$arrayDatosEnvioCorreo[0]['NMantenimiento'];
            $GestorUpselling=$arrayDatosEnvioCorreo[0]['GestorUpselling'];
            $nombreGestorUpselling=$arrayDatosEnvioCorreo[0]['NombreGestor'];
            $CorreoGestor=$arrayDatosEnvioCorreo[0]['CorreoGestor'];
            $GestorUpsellingT=$arrayDatosEnvioCorreo[0]['Tecnico'];
            $nombreGestorUpsellingT=$arrayDatosEnvioCorreo[0]['NombreTecnico'];
            $CorreoGestorT=$arrayDatosEnvioCorreo[0]['CorreoTecnico'];
            $TelefonoGestorT=$arrayDatosEnvioCorreo[0]['TelefonoTecnico'];
            $Canal=$arrayDatosEnvioCorreo[0]['Canal'];
            $TipoCanal=$arrayDatosEnvioCorreo[0]['TipoCanal'];
            $EstadoAmp=$arrayDatosEnvioCorreo[0]['EstadoAmp'];
            $Campana=$arrayDatosEnvioCorreo[0]['Campana'];
            $ComentarioAmp=$arrayDatosEnvioCorreo[0]['ComentarioAmp'];
            $MesAmp=$arrayDatosEnvioCorreo[0]['MesAmp'];
            $IdCotizacion=$arrayDatosEnvioCorreo[0]['IdCotizacion'];
            $FormaPago=$arrayDatosEnvioCorreo[0]['FormaPago'];
            $PAI=$arrayDatosEnvioCorreo[0]['PAI'];
            $ExtraAutorizado=$arrayDatosEnvioCorreo[0]['ExtraAutorizado'];
            $MesesAutorizado=$arrayDatosEnvioCorreo[0]['MesesAutorizado'];
            $TotalUnidad=$arrayDatosEnvioCorreo[0]['TotalUnidad'];
            $TotalPrecio=$arrayDatosEnvioCorreo[0]['TotalPrecio'];
            $TotalCuota=$arrayDatosEnvioCorreo[0]['TotalCuota'];
            $ObjCotizacion=$arrayDatosEnvioCorreo[0]['ObjCotizacion'];
            $TotalExtra=$arrayDatosEnvioCorreo[0]['TotalExtra'];
            $CantidadExtras=$arrayDatosEnvioCorreo[0]['CantidadExtras'];
            $FechaPosibleVisita=$arrayDatosEnvioCorreo[0]['FechaPosibleVisita'];

            $ObjCotizacion=json_decode($ObjCotizacion, true);
            
            //Detalle ITEM de cotizacion
            $totalObjCotizacion=count($ObjCotizacion);
            $ObjTotalCuota=0;
            $ObjTotalPrecio=0.00;
            if($totalObjCotizacion>0){
            $contadorC=0;
            $Informacionitem="";
            


            foreach ($ObjCotizacion as $items) {
            	$contadorC++;
            	

                foreach ($arrayDatosItemImagenesCotizacion as $coditem) {
                    if ($coditem["IdItem"] === $items['Numero']) {
                        $informacionEncontrada = $coditem;
                        break; // Se encontró el valor, así que podemos salir del bucle
                    }
                }
                
                if ($informacionEncontrada !== null) {
                    $imagen = $informacionEncontrada['Imagen'];
                    $PDF=$informacionEncontrada['PDF'];
                } else {
                    $imagen="";
                    $PDF="";
                }                
            	
                $Informacionitem.='<tr>
              <td align="left" bgcolor="#f6f3f3" style="padding:0;Margin:0;padding-top:5px;background-color:#ffffff"><!--[if mso]><table style="width:600px" cellpadding="0" cellspacing="0"><tr><td style="width:121px, height: 100px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                 <tr>
                  <td class="es-m-p0r" align="center" style="padding:0;Margin:0;width:116px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0;font-size:0px"><a href="'.$PDF.'"><img class="adapt-img" src="'.$imagen.'" alt style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" height="90"></a></td>
                     </tr>
                   </table></td>
                  <td class="es-hidden" style="padding:0;Margin:0;width:5px"></td>
                 </tr>
               </table><!--[if mso]></td><td style="width:121px, height: 100px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                 <tr>
                  <td align="center" style="padding:0;Margin:0;width:116px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" class="h-auto" bgcolor="#ffffff" height="90" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#696969;font-size:14px">'.$items['Cantidad'].'</p></td>
                     </tr>
                   </table></td>
                  <td class="es-hidden" style="padding:0;Margin:0;width:5px"></td>
                 </tr>
               </table><!--[if mso]></td><td style="width:121px, height: 100px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                 <tr>
                  <td align="center" style="padding:0;Margin:0;width:116px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" class="h-auto" bgcolor="#ffffff" height="90" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#696969;font-size:14px">S/.'.number_format($items['PrecioAdicional'], 2, '.', '').'</p></td>
                     </tr>
                   </table></td>
                  <td class="es-hidden" style="padding:0;Margin:0;width:5px"></td>
                 </tr>
               </table><!--[if mso]></td><td style="width:121px, height: 100px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                 <tr>
                  <td align="center" style="padding:0;Margin:0;width:116px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" class="h-auto" bgcolor="#ffffff" height="90" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#696969;font-size:14px">S/.'.number_format($items['PrecioSubTotal'], 2, '.', '').'</p></td>
                     </tr>
                   </table></td>
                 </tr>
               </table><!--[if mso]></td><td style="width:5px"></td><td style="width:121px, height: 100px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-right" align="right" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                 <tr>
                  <td align="center" style="padding:0;Margin:0;width:116px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" class="h-auto" bgcolor="#ffffff" height="90" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#696969;font-size:14px">S/.'.number_format($items['CuotaMensual'], 2, '.', '').'</p></td>
                     </tr>
                   </table></td>
                 </tr>
               </table><!--[if mso]></td></tr></table><![endif]--></td>
             </tr>';
                
            	$ObjTotalPrecio+=$items['PrecioSubTotal'];
            	$ObjTotalCuota+=$items['CuotaMensual'];
            }            
            
                
            }
            
            
            
            if(($TipoCanal=="PostMantos" && $Canal=="Field") || $Canal=="Cotizacion"){
    
            $GestorUpselling=$GestorUpsellingT;
            $nombreGestorUpselling=$nombreGestorUpsellingT;
            $CorreoGestor=$CorreoGestorT;
            // $TelefonoGestor=$TelefonoGestorT;
            $TelefonoGestor="514-7320";
            $auximagen="elementos.png";
            $auxnom2="Sub Precio";
            $auxnom3="Precio Total (incl. IGV)";
            $axmensaje='<table>
                  <tbody>
                    <tr>
                      <p align="center" style="margin:0cm; margin-bottom:.0001pt; text-align:center; line-height:19.5pt">
                        <strong><span lang="ES-MX" style="font-size:16pt;color:#545454">
                        Para brindarle mayor detalle con respecto a su cotización, comuniquese al '.$TelefonoGestor.' o vía correo electrónico a '.$CorreoGestor.'
                        </span></strong></p>
                    </tr>
                  </tbody>
                </table>';
            $tituloPrecioDetalleItem="Precio por Unidad";
            $tituloTotalxPrecioDetalleItem="Precio Total por Unidad";
            $tituloTotalxPrecioDescuentoDetalleItem="Cuota por Unidad";
            }else{
            $GestorUpselling = $GestorUpselling;
            $nombreGestorUpselling=$nombreGestorUpselling;
            $CorreoGestor=$CorreoGestor;
            $TelefonoGestor="514-7320";
            $auximagen="extras.png";
            $auxnom2="Elementos";
            $auxnom3="Total Elementos";
            $auxmensaje='';
            $tituloPrecioDetalleItem="Precio S/IGV";
            $tituloTotalxPrecioDetalleItem="Total";
            $tituloTotalxPrecioDescuentoDetalleItem="Cuota";    
            }
            
            $TotalPrecioIGV=round($TotalPrecio*0.18, 2);
            $SumaTotalCoti=number_format(round($TotalPrecio+$TotalPrecioIGV, 2), 2, '.', '');
            
            $TotalCuotaIGV=round($TotalCuota*0.18, 2);
            $SumaTotalCuota=number_format(round($TotalCuota+$TotalCuotaIGV, 2), 2, '.', '');
                
        
            if($Segmento=="NEG"){
                $tiposeg="Negocio";
            }else{
                $tiposeg="Residencial";
            }
            
            $correosdeclientes = explode(",", $lblcorreoconsolidado);
            

$mensaje='<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:o="urn:schemas-microsoft-com:office:office" style="font-family:arial,  helvetica, sans-serif">
 <head>
  <meta charset="UTF-8">
  <meta content="width=device-width, initial-scale=1" name="viewport">
  <meta name="x-apple-disable-message-reformatting">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta content="telephone=no" name="format-detection">
  <title>Nuevo mensaje 3</title><!--[if (mso 16)]>
    <style type="text/css">
    a {text-decoration: none;}
    </style>
    <![endif]--><!--[if gte mso 9]><style>sup { font-size: 100% !important; }</style><![endif]--><!--[if gte mso 9]>
<xml>
    <o:OfficeDocumentSettings>
    <o:AllowPNG></o:AllowPNG>
    <o:PixelsPerInch>96</o:PixelsPerInch>
    </o:OfficeDocumentSettings>
</xml>
<![endif]-->
  <style type="text/css">
#outlook a {
	padding:0;
}
.es-button {
	mso-style-priority:100!important;
	text-decoration:none!important;
}
a[x-apple-data-detectors] {
	color:inherit!important;
	text-decoration:none!important;
	font-size:inherit!important;
	font-family:inherit!important;
	font-weight:inherit!important;
	line-height:inherit!important;
}
.es-desk-hidden {
	display:none;
	float:left;
	overflow:hidden;
	width:0;
	max-height:0;
	line-height:0;
	mso-hide:all;
}
@media only screen and (max-width:600px) {p, ul li, ol li, a { line-height:150%!important } h1, h2, h3, h1 a, h2 a, h3 a { line-height:120% } h1 { font-size:30px!important; text-align:left } h2 { font-size:24px!important; text-align:left } h3 { font-size:20px!important; text-align:left } .es-header-body h1 a, .es-content-body h1 a, .es-footer-body h1 a { font-size:30px!important; text-align:left } .es-header-body h2 a, .es-content-body h2 a, .es-footer-body h2 a { font-size:24px!important; text-align:left } .es-header-body h3 a, .es-content-body h3 a, .es-footer-body h3 a { font-size:20px!important; text-align:left } .es-menu td a { font-size:14px!important } .es-header-body p, .es-header-body ul li, .es-header-body ol li, .es-header-body a { font-size:14px!important } .es-content-body p, .es-content-body ul li, .es-content-body ol li, .es-content-body a { font-size:14px!important } .es-footer-body p, .es-footer-body ul li, .es-footer-body ol li, .es-footer-body a { font-size:14px!important } .es-infoblock p, .es-infoblock ul li, .es-infoblock ol li, .es-infoblock a { font-size:12px!important } *[class="gmail-fix"] { display:none!important } .es-m-txt-c, .es-m-txt-c h1, .es-m-txt-c h2, .es-m-txt-c h3 { text-align:center!important } .es-m-txt-r, .es-m-txt-r h1, .es-m-txt-r h2, .es-m-txt-r h3 { text-align:right!important } .es-m-txt-l, .es-m-txt-l h1, .es-m-txt-l h2, .es-m-txt-l h3 { text-align:left!important } .es-m-txt-r img, .es-m-txt-c img, .es-m-txt-l img { display:inline!important } .es-button-border { display:inline-block!important } a.es-button, button.es-button { font-size:18px!important; display:inline-block!important } .es-adaptive table, .es-left, .es-right { width:100%!important } .es-content table, .es-header table, .es-footer table, .es-content, .es-footer, .es-header { width:100%!important; max-width:600px!important } .es-adapt-td { display:block!important; width:100%!important } .adapt-img { width:100%!important; height:auto!important } .es-m-p0 { padding:0px!important } .es-m-p0r { padding-right:0px!important } .es-m-p0l { padding-left:0px!important } .es-m-p0t { padding-top:0px!important } .es-m-p0b { padding-bottom:0!important } .es-m-p20b { padding-bottom:20px!important } .es-mobile-hidden, .es-hidden { display:none!important } tr.es-desk-hidden, td.es-desk-hidden, table.es-desk-hidden { width:auto!important; overflow:visible!important; float:none!important; max-height:inherit!important; line-height:inherit!important } tr.es-desk-hidden { display:table-row!important } table.es-desk-hidden { display:table!important } td.es-desk-menu-hidden { display:table-cell!important } .es-menu td { width:1%!important } table.es-table-not-adapt, .esd-block-html table { width:auto!important } table.es-social { display:inline-block!important } table.es-social td { display:inline-block!important } .es-desk-hidden { display:table-row!important; width:auto!important; overflow:visible!important; max-height:inherit!important } .h-auto { height:auto!important } }
</style>
 </head>
 <body style="width:100%;font-family:arial,  helvetica, sans-serif;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;padding:0;Margin:0">
  <div class="es-wrapper-color" style="background-color:#F6F3F3"><!--[if gte mso 9]>
			<v:background xmlns:v="urn:schemas-microsoft-com:vml" fill="t">
				<v:fill type="tile" color="#f6f3f3"></v:fill>
			</v:background>
		<![endif]-->
   <table class="es-wrapper" width="100%" cellspacing="0" cellpadding="0" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;padding:0;Margin:0;width:100%;height:100%;background-repeat:repeat;background-position:center top;background-color:#F6F3F3">
     <tr>
      <td valign="top" style="padding:0;Margin:0">
       <table class="es-header" cellspacing="0" cellpadding="0" align="center" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%;background-color:transparent;background-repeat:repeat;background-position:center top">
         <tr>
          <td align="center" style="padding:0;Margin:0">
           <table class="es-header-body" cellspacing="0" cellpadding="0" bgcolor="#ffffff" align="center" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#FFFFFF;width:600px">
             <tr>
              <td align="left" style="padding:0;Margin:0">
               <table width="100%" cellspacing="0" cellpadding="0" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                 <tr>
                  <td valign="top" align="center" style="padding:0;Margin:0;width:600px">
                   <table width="100%" cellspacing="0" cellpadding="0" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0;font-size:0px"><img class="adapt-img" src="https://www.verismart.com.pe/verismart/img/cotizacion/images/top_1.png" alt style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" width="600"></td>
                     </tr>
                   </table></td>
                 </tr>
               </table></td>
             </tr>
             <tr>
              <td align="left" style="padding:0;Margin:0">
               <table width="100%" cellspacing="0" cellpadding="0" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                 <tr>
                  <td valign="top" align="center" style="padding:0;Margin:0;width:600px">
                   <table width="100%" cellspacing="0" cellpadding="0" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="left" style="padding:0;Margin:0;padding-bottom:15px;padding-left:25px;padding-right:25px"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#696969;font-size:14px"><strong>Estimado '.$NombApellido.',</strong><br><br>A continuación, encontrará el presupuesto para mejorar la seguridad de su hogar. Esperamos que sea de su agrado.</p></td>
                     </tr>
                   </table></td>
                 </tr>
               </table></td>
             </tr>
             <tr>
              <td align="left" bgcolor="#f6f3f3" style="padding:0;Margin:0;padding-top:5px;background-color:#f6f3f3"><!--[if mso]><table style="width:600px" cellpadding="0" cellspacing="0"><tr><td style="width:298px" valign="top"><![endif]-->
               <table class="es-left" cellspacing="0" cellpadding="0" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                 <tr>
                  <td class="es-m-p0r" valign="top" align="center" style="padding:0;Margin:0;width:298px">
                   <table width="100%" cellspacing="0" cellpadding="0" bgcolor="#ffffff" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#ffffff" role="presentation">
                     <tr>
                      <td align="center" style="padding:10px;Margin:0;font-size:0px"><img class="adapt-img" src="https://www.verismart.com.pe/verismart/img/cotizacion/images/datoscliente.png" alt style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" height="46"></td>
                     </tr>
                     <tr>
                      <td align="center" bgcolor="#ffffff" style="padding:0;Margin:0;padding-bottom:15px"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#696969;font-size:14px"><strong>Nombre:</strong> '.$NombApellido.'<br><strong>Código Cliente:</strong> '.$NCliente.'<br><strong>Teléfono:</strong> '.$Telefonouno.'</p></td>
                     </tr>
                   </table></td>
                 </tr>
               </table><!--[if mso]></td><td style="width:5px"></td><td style="width:297px" valign="top"><![endif]-->
               <table class="es-right" cellspacing="0" cellpadding="0" align="right" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                 <tr>
                  <td align="left" style="padding:0;Margin:0;width:297px">
                   <table width="100%" cellspacing="0" cellpadding="0" bgcolor="#ffffff" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#ffffff" role="presentation">
                     <tr>
                      <td align="center" style="padding:10px;Margin:0;font-size:0px"><img class="adapt-img" src="https://www.verismart.com.pe/verismart/img/cotizacion/images/datospresupuesto.png" alt style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" height="46"></td>
                     </tr>
                     <tr>
                      <td align="center" bgcolor="#ffffff" style="padding:0;Margin:0;padding-bottom:15px"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#696969;font-size:14px"><strong>No. Presu:</strong> '.$idAmpl.'<br><strong>Fecha:</strong> '.$fechahoy.'<br><strong>Válido hasta:</strong> '.$promocion.'</p></td>
                     </tr>
                   </table></td>
                 </tr>
               </table><!--[if mso]></td></tr></table><![endif]--></td>
             </tr>
           </table></td>
         </tr>
       </table>
       <table class="es-content" cellspacing="0" cellpadding="0" align="center" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%">
         <tr>
          <td align="center" style="padding:0;Margin:0">
           <table class="es-content-body" cellspacing="0" cellpadding="0" bgcolor="#ffffff" align="center" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#FFFFFF;width:600px">
             <tr>
              <td align="left" style="padding:0;Margin:0">
               <table width="100%" cellspacing="0" cellpadding="0" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                 <tr>
                  <td valign="top" align="center" style="padding:0;Margin:0;width:600px">
                   <table width="100%" cellspacing="0" cellpadding="0" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0;font-size:0px"><img class="adapt-img" src="https://www.verismart.com.pe/verismart/img/cotizacion/images/presupuesto_1.png" alt style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" width="600"></td>
                     </tr>
                   </table></td>
                 </tr>
               </table></td>
             </tr>
             <tr>
              <td align="left" bgcolor="#f6f3f3" style="padding:0;Margin:0;padding-top:5px;padding-bottom:5px;background-color:#f6f3f3"><!--[if mso]><table style="width:600px" cellpadding="0" cellspacing="0"><tr><td style="width:121px, height: 100px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                 <tr>
                  <td class="es-m-p0r es-m-p20b" align="center" style="padding:0;Margin:0;width:116px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:24px;color:#696969;font-size:16px"><strong>Producto</strong></p></td>
                     </tr>
                   </table></td>
                  <td class="es-hidden" style="padding:0;Margin:0;width:5px"></td>
                 </tr>
               </table><!--[if mso]></td><td style="width:121px, height: 100px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                 <tr>
                  <td class="es-m-p20b" align="center" style="padding:0;Margin:0;width:116px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:24px;color:#696969;font-size:16px"><strong>Cant.</strong></p></td>
                     </tr>
                   </table></td>
                  <td class="es-hidden" style="padding:0;Margin:0;width:5px"></td>
                 </tr>
               </table><!--[if mso]></td><td style="width:121px, height: 100px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                 <tr>
                  <td class="es-m-p20b" align="center" style="padding:0;Margin:0;width:116px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:24px;color:#696969;font-size:16px"><strong>Precio</strong></p></td>
                     </tr>
                   </table></td>
                  <td class="es-hidden" style="padding:0;Margin:0;width:5px"></td>
                 </tr>
               </table><!--[if mso]></td><td style="width:121px, height: 100px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                 <tr>
                  <td align="center" class="es-m-p20b" style="padding:0;Margin:0;width:116px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:24px;color:#696969;font-size:16px"><strong>Total</strong></p></td>
                     </tr>
                   </table></td>
                 </tr>
               </table><!--[if mso]></td><td style="width:5px"></td><td style="width:121px, height: 100px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-right" align="right" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                 <tr>
                  <td align="left" style="padding:0;Margin:0;width:116px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:24px;color:#696969;font-size:16px"><strong>Cuota*</strong></p></td>
                     </tr>
                   </table></td>
                 </tr>
               </table><!--[if mso]></td></tr></table><![endif]--></td>
             </tr>
            '.$Informacionitem.'
             <tr>
              <td align="left" bgcolor="#f6f3f3" style="padding:0;Margin:0;background-color:#f6f3f3"><!--[if mso]><table style="width:600px" cellpadding="0" cellspacing="0"><tr><td style="width:311px" valign="top"><![endif]-->
               <table class="es-left" cellspacing="0" cellpadding="0" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                 <tr>
                  <td class="es-m-p20b" align="left" style="padding:0;Margin:0;width:306px">
                   <table width="100%" cellspacing="0" cellpadding="0" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="left" class="h-auto" bgcolor="#ece5dc" height="104" style="Margin:0;padding-top:5px;padding-bottom:5px;padding-left:15px;padding-right:15px"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#696969;font-size:14px">Para brindarle mayor detalle con respecto a su cotización, comuniquese al <strong>514-7320</strong> o vía correo electrónico a <strong>'.$CorreoGestor.'</strong></p><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#333333;font-size:14px;display:none"><br></p></td>
                     </tr>
                   </table></td>
                  <td class="es-hidden" style="padding:0;Margin:0;width:5px"></td>
                 </tr>
               </table><!--[if mso]></td><td style="width:142px" valign="top"><![endif]-->
               <table class="es-left" cellspacing="0" cellpadding="0" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                 <tr>
                  <td class="es-m-p20b" align="left" style="padding:0;Margin:0;width:142px">
                   <table width="100%" cellspacing="0" cellpadding="0" bgcolor="#999999" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#999999" role="presentation">
                     <tr>
                      <td align="center" class="h-auto" bgcolor="#999999" height="50" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#ffffff;font-size:14px"><b>Cuota Mensual*</b></p></td>
                     </tr>
                     <tr>
                      <td align="center" style="padding:0;Margin:0;padding-top:5px;font-size:0" bgcolor="#f6f3f3">
                       <table border="0" width="5%" height="100%" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                         <tr>
                          <td style="padding:0;Margin:0;border-bottom:0px solid #cccccc;background:unset;height:1px;width:100%;margin:0px"></td>
                         </tr>
                       </table></td>
                     </tr>
                   </table></td>
                 </tr>
                 <tr>
                  <td class="es-m-p20b" align="left" style="padding:0;Margin:0;width:130px">
                   <table width="100%" cellspacing="0" cellpadding="0" bgcolor="#ec0a04" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#ec0a04" role="presentation">
                     <tr>
                      <td align="center" class="h-auto" height="50" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#ffffff;font-size:14px"><b>Total</b></p></td>
                     </tr>
                   </table></td>
                 </tr>
               </table><!--[if mso]></td><td style="width:5px"></td><td style="width:142px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-right" align="right" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                 <tr>
                  <td align="left" class="es-m-p20b" style="padding:0;Margin:0;width:142px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" class="h-auto" bgcolor="#999999" height="50" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#ffffff;font-size:14px"><strong>S/.'.number_format($ObjTotalCuota, 2, '.', '').'</strong></p></td>
                     </tr>
                   </table></td>
                 </tr>
                 <tr>
                  <td align="left" style="padding:0;Margin:0;width:130px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0;padding-top:5px;font-size:0" bgcolor="#f6f3f3">
                       <table border="0" width="5%" height="100%" cellpadding="0" cellspacing="0" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                         <tr>
                          <td style="padding:0;Margin:0;border-bottom:0px solid #cccccc;background:unset;height:1px;width:100%;margin:0px"></td>
                         </tr>
                       </table></td>
                     </tr>
                     <tr>
                      <td align="center" class="h-auto" bgcolor="#ec0a04" height="50" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#ffffff;font-size:14px"><strong>S/.'.number_format($ObjTotalPrecio, 2, '.', '').'</strong></p></td>
                     </tr>
                   </table></td>
                 </tr>
               </table><!--[if mso]></td></tr></table><![endif]--></td>
             </tr>
             <tr>
              <td align="left" bgcolor="#f6f3f3" style="padding:0;Margin:0;background-color:#f6f3f3">
               <table cellpadding="0" cellspacing="0" width="100%" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                 <tr>
                  <td align="center" valign="top" style="padding:0;Margin:0;width:600px">
                   <table cellpadding="0" cellspacing="0" width="100%" bgcolor="#f6f3f3" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#f6f3f3" role="presentation">
                     <tr>
                      <td align="center" style="padding:0;Margin:0;padding-top:5px;padding-bottom:5px;font-size:0px"><img class="adapt-img" src="https://www.verismart.com.pe/verismart/img/cotizacion/images/a55555.PNG" alt style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" width="600"></td>
                     </tr>
                   </table></td>
                 </tr>
               </table></td>
             </tr>
             <tr>
              <td align="left" style="padding:0;Margin:0;padding-top:20px;padding-left:20px;padding-right:20px">
               <table cellpadding="0" cellspacing="0" width="100%" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                 <tr>
                  <td align="center" valign="top" style="padding:0;Margin:0;width:560px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0;font-size:0px"><img class="adapt-img" src="https://www.verismart.com.pe/verismart/img/cotizacion/images/bancos_1.png" alt style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" width="560"></td>
                     </tr>
                     <tr>
                      <td align="center" style="padding:0;Margin:0;font-size:0px"><img class="adapt-img" src="https://www.verismart.com.pe/verismart/img/cotizacion/images/xss.png" alt style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" width="560"></td>
                     </tr>
                     <tr>
                      <td align="center" style="padding:0;Margin:0;font-size:0px"><img class="adapt-img" src="https://www.verismart.com.pe/verismart/img/cotizacion/images/a4333.png" alt style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" width="560"></td>
                     </tr>
                     <tr>
                      <td align="center" style="padding:0;Margin:0;font-size:0px"><img class="adapt-img" src="https://www.verismart.com.pe/verismart/img/cotizacion/images/a545454.png" alt style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" width="560"></td>
                     </tr>
                   </table></td>
                 </tr>
               </table></td>
             </tr>
             <tr>
              <td align="left" bgcolor="#f6f3f3" style="padding:0;Margin:0;padding-top:10px;padding-bottom:10px;background-color:#f6f3f3"><!--[if mso]><table style="width:600px" cellpadding="0" cellspacing="0"><tr><td style="width:282px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                 <tr>
                  <td class="es-m-p0r es-m-p20b" align="center" style="padding:0;Margin:0;width:262px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="left" class="h-auto" valign="middle" height="50" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:14px;color:#333333;font-size:14px">-------------------------------------------------------</p></td>
                     </tr>
                   </table></td>
                  <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                 </tr>
               </table><!--[if mso]></td><td style="width:37px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                 <tr>
                  <td class="es-m-p20b" align="center" style="padding:0;Margin:0;width:37px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0;font-size:0px"><img class="adapt-img" src="https://www.verismart.com.pe/verismart/img/cotizacion/images/icocontacto.png" alt style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" width="37"></td>
                     </tr>
                   </table></td>
                 </tr>
               </table><!--[if mso]></td><td style="width:20px"></td><td style="width:261px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-right" align="right" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                 <tr>
                  <td align="center" style="padding:0;Margin:0;width:261px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="left" class="h-auto" valign="middle" height="50" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:14px;color:#333333;font-size:14px">-------------------------------------------------------</p></td>
                     </tr>
                   </table></td>
                 </tr>
               </table><!--[if mso]></td></tr></table><![endif]--></td>
             </tr>
             <tr>
              <td align="left" bgcolor="#f6f3f3" style="Margin:0;padding-bottom:10px;padding-top:20px;padding-left:20px;padding-right:20px;background-color:#f6f3f3"><!--[if mso]><table style="width:560px" cellpadding="0" cellspacing="0"><tr><td style="width:194px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                 <tr>
                  <td class="es-m-p0r es-m-p20b" align="center" style="padding:0;Margin:0;width:174px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#333333;font-size:14px">E-mail</p><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#333333;font-size:14px;display:none">&nbsp;</p></td>
                     </tr>
                     <tr>
                      <td align="center" style="padding:0;Margin:0;font-size:0px"><img class="adapt-img" src="https://www.verismart.com.pe/verismart/img/cotizacion/images/icom.png" alt style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" height="45"></td>
                     </tr>
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#333333;font-size:14px"><a target="_blank" href="mailto:clientes@verisure.pe" style="-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;text-decoration:none;color:#333333;font-size:14px">clientes@verisure.pe</a></p></td>
                     </tr>
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#808080;font-size:14px">24h</p></td>
                     </tr>
                   </table></td>
                  <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                 </tr>
               </table><!--[if mso]></td><td style="width:173px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                 <tr>
                  <td class="es-m-p20b" align="center" style="padding:0;Margin:0;width:173px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#333333;font-size:14px">Teléfono</p><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#333333;font-size:14px;display:none"><br></p></td>
                     </tr>
                     <tr>
                      <td align="center" style="padding:0;Margin:0;font-size:0px"><img class="adapt-img" src="https://www.verismart.com.pe/verismart/img/cotizacion/images/icotelefono.png" alt style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" height="45"></td>
                     </tr>
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#333333;font-size:14px"><a target="_blank" style="-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;text-decoration:none;color:#202020;font-size:14px" href="tel:080021212">0 80 2 12 12</a></p></td>
                     </tr>
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#808080;font-size:14px">24h</p></td>
                     </tr>
                   </table></td>
                 </tr>
               </table><!--[if mso]></td><td style="width:20px"></td><td style="width:173px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-right" align="right" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                 <tr>
                  <td align="center" style="padding:0;Margin:0;width:173px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#333333;font-size:14px">Chat App MyVerisure</p><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#333333;font-size:14px;display:none"><br></p><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#333333;font-size:14px;display:none"><br></p></td>
                     </tr>
                     <tr>
                      <td align="center" style="padding:0;Margin:0;font-size:0px"><img class="adapt-img" src="https://www.verismart.com.pe/verismart/img/cotizacion/images/icchat.png" alt style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" height="45"></td>
                     </tr>
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#333333;font-size:14px">Lunes a Viernes</p></td>
                     </tr>
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#808080;font-size:14px">9:00 a.m. - 6:00 p.m.</p></td>
                     </tr>
                   </table></td>
                 </tr>
               </table><!--[if mso]></td></tr></table><![endif]--></td>
             </tr>
             <tr>
              <td align="left" bgcolor="#ffffff" style="padding:0;Margin:0;padding-top:10px;padding-bottom:10px;background-color:#ffffff">
               <table cellpadding="0" cellspacing="0" width="100%" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                 <tr>
                  <td align="center" valign="top" style="padding:0;Margin:0;width:600px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#ff0000;font-size:14px"><strong>Personas que protegen personas</strong></p></td>
                     </tr>
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#333333;font-size:14px">Síguenos en redes sociales</p><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#333333;font-size:14px;display:none"><br></p></td>
                     </tr>
                   </table></td>
                 </tr>
               </table></td>
             </tr>
           </table></td>
         </tr>
       </table>
       <table cellpadding="0" cellspacing="0" class="es-content" align="center" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%">
         <tr>
          <td align="center" style="padding:0;Margin:0">
           <table class="es-content-body" align="center" cellpadding="0" cellspacing="0" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:transparent;width:600px">
             <tr>
              <td align="left" style="padding:20px;Margin:0;border-radius:0px 0px 50px 50px;background-color:#ffffff" bgcolor="#ffffff"><!--[if mso]><table style="width:560px" cellpadding="0" cellspacing="0"><tr><td style="width:187px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                 <tr>
                  <td class="es-m-p0r" align="center" style="padding:0;Margin:0;width:187px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#ff0000;font-size:14px"><a target="_blank" style="-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;text-decoration:underline;color:#ff0000;font-size:14px" href="https://www.facebook.com/AlarmasVerisurePeru/">Facebook</a></p></td>
                     </tr>
                   </table></td>
                 </tr>
               </table><!--[if mso]></td><td style="width:186px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                 <tr>
                  <td align="center" style="padding:0;Margin:0;width:186px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#ff0000;font-size:14px"><a target="_blank" style="-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;text-decoration:underline;color:#ff0000;font-size:14px" href="https://www.youtube.com/channel/UCsC7LzKdqytaOQ58IL011eQ">Youtube</a></p></td>
                     </tr>
                   </table></td>
                 </tr>
               </table><!--[if mso]></td><td style="width:0px"></td><td style="width:187px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-right" align="right" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                 <tr>
                  <td align="center" style="padding:0;Margin:0;width:187px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:21px;color:#ff0000;font-size:14px"><a target="_blank" style="-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;text-decoration:underline;color:#ff0000;font-size:14px" href="https://www.instagram.com/verisurepe/">Instagram</a></p></td>
                     </tr>
                   </table></td>
                 </tr>
               </table><!--[if mso]></td></tr></table><![endif]--></td>
             </tr>
             <tr>
              <td align="left" style="padding:0;Margin:0;padding-top:20px;padding-left:20px;padding-right:20px">
               <table cellpadding="0" cellspacing="0" width="100%" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                 <tr>
                  <td align="center" valign="top" style="padding:0;Margin:0;width:560px">
                   <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                     <tr>
                      <td align="center" style="padding:0;Margin:0"><p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family:helvetica,  arial, verdana, sans-serif;line-height:14px;color:#a9a9a9;font-size:9px">Copyright © 2023 Verisure Peru, All rights reserved. Nuestra dirección es: Av. Primavera 1050 Oficina 501 – Santiago de Surco.</p></td>
                     </tr>
                   </table></td>
                 </tr>
               </table></td>
             </tr>
           </table></td>
         </tr>
       </table>
       <table class="es-footer" cellspacing="0" cellpadding="0" align="center" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%;background-color:transparent;background-repeat:repeat;background-position:center top">
         <tr>
          <td align="center" style="padding:0;Margin:0">
           <table class="es-footer-body" cellspacing="0" cellpadding="0" bgcolor="#ffffff" align="center" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#FFFFFF;width:600px">
             <tr>
              <td align="left" bgcolor="#f6f3f3" style="padding:0;Margin:0;background-color:#f6f3f3"><!--[if mso]><table style="width:600px" cellpadding="0" cellspacing="0"><tr><td style="width:311px" valign="top"><![endif]-->
               <table class="es-left" cellspacing="0" cellpadding="0" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
               </table><!--[if mso]></td><td style="width:142px" valign="top"><![endif]-->
               <table class="es-left" cellspacing="0" cellpadding="0" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
               </table><!--[if mso]></td><td style="width:5px"></td><td style="width:142px" valign="top"><![endif]-->
               <table cellpadding="0" cellspacing="0" class="es-right" align="right" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
               </table><!--[if mso]></td></tr></table><![endif]--></td>
             </tr>
           </table></td>
         </tr>
       </table></td>
     </tr>
   </table>
  </div>
 </body>
</html>';                     
          
            
        $titulo='COTIZACION N° CLIENTE - '.$NCliente;
        $opts = array(
            'http'=>array(
            'method'=>"GET",
            'header'=>"User-Agent: api script\r\n"
        ));
        $context = stream_context_create($opts);
    
        $curl = curl_init();            

        $dataSC= array (
          'GeneralData' => 
          array (
            'FromName' => $nombreGestorUpselling,
            'From' => $CorreoGestor,
            'To' => 
                array (
                  'Email' =>$correosdeclientes
                ),
            'Cc' => 
                array (
                  'Email' => 
                    array (
                        0 => '',
                    )
                ),
            'Bcc' => 
                array (
                    'Email' => 
                        array (
                            0 => 'joseenrique.nanquen@verisure.pe'
                        )
                ),
            'Message' => 
                array (
                    'Subject' => $titulo,
                    'Classification' => 'C',
                    'Body' => 
                        array (
                            'Format' => 'html',
                            'Value' => $mensaje,
                        )
                ),
            'Options' => 
                array (
                  'OpenTracking' => 'true',
                  'ClickTracking' => 'true',
                  'TextHtmlTracking' => 'true',
                  'AutoTextBody' => 'false',
                )
          )
        );
        
        $dataSC_string = json_encode($dataSC);
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api2023.masterbase.com/UniqueMail/v3/verisuremktpe",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 60,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $dataSC_string,
            CURLOPT_HTTPHEADER => array(
                "authorization: Basic U2VjdXJpdHlfY2hlY2s6Njc1NC1TQDlxYTAjZDZVN2MzdzU=",
                "cache-control: no-cache",
                "content-type: application/json"
            ),
        ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
          
          return $resultado=array('respuesta'=>'error','mensaje'=>'CURL Error #:' . $err);
        } else {
          return $resultado=array('respuesta'=>'exito','mensaje'=>$response);
        }             
            
        }else{
            $resultado=array('respuesta'=>'error','mensaje'=>'Error al obtener datos de la cotizacion');
        }
   
        

        
    
    }



?>