<?php

require_once 'config/db.php';
require_once 'config/conexion.php';
include 'helper/helper_validacion.php';



    if (isset($_GET['IdVenta'])) {
        $IdVenta = sanitizaCampo($_GET['IdVenta'], 'sanitizeint|scapestring|htmlspecialchars', $con);
        $IdVenta = htmlspecialchars($IdVenta);
    } else {
    	header("location: ./denegado.php");
    	exit;
    }

   if (isset($_GET['rc'])) {
        $rc = sanitizaCampo($_GET['rc'], 'sanitizeint|scapestring|htmlspecialchars', $con);
        $rc = htmlspecialchars($rc);
   }else{
        $rc=0;
   }
    

try{
    $stmt = $con->prepare( "SELECT
c.Telefonouno,
DATE_FORMAT(v.FechaVisita, '%d/%m/%y') FechaVisita, 
TIME_FORMAT(v.HoraVisita,'%r') HoraVisita,
c.Direccion,
g.Distrito,
u.Nombres,
u.Apellidos,
u.NumeroDoc,
u.Matricula,
u.Telefono,
u.Foto,
u.Estrellas
FROM dbVENTAS.tblventa v
INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
INNER JOIN dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
LEFT JOIN dbUSUARIO.tblusuario u on u.IdUsuario=v.IdUsuario
WHERE v.IdVenta=?");
        $stmt->bind_param('i', $IdVenta);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result(
            $Telefonouno,
            $FechaVisita,
            $HoraVisita,
            $Direccion,
            $Distrito,
            $Nombres,
            $Apellidos,
            $NumeroDoc,
            $Matricula,
            $Telefono,
            $Foto,
            $Estrellas);
        $stmt->fetch();

        if(empty($Foto)){
            $Foto="";
        }else{
            $Foto=$Foto;
        }        

        if(empty($Telefonouno)){
            $Telefonouno="";
        }else{
            $Telefonouno=$Telefonouno;
        }
        
        if(empty($Estrellas)){
            $Estrellas="4";
        }else{
            $Estrellas=$Estrellas;
        }        
        
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }    
    
?>


<!DOCTYPE html
    PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" style="font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif; overflow-x: visible !important;">

<head>
    <meta http-equiv="Content-Type" content="text/html charset=UTF-8">
    <meta name="viewport" content="width=480, user-scalable=1">
    <title>Alarmas Verisure</title>
    <link href="https://fonts.googleapis.com/css?family=Fira+Sans:400,700" rel="stylesheet">
    <!--[if gte mso 9]><style>sup { font-size: 100% !important; }</style><![endif]-->
    <style type="text/css">
        #outlook a {
            padding: 0;
        }

        .es-button {
            mso-style-priority: 100 !important;
            text-decoration: none !important;
        }

        a[x-apple-data-detectors] {
            color: inherit !important;
            text-decoration: none !important;
            font-size: inherit !important;
            font-family: inherit !important;
            font-weight: inherit !important;
            line-height: inherit !important;
        }

        .es-desk-hidden {
            display: none;
            float: left;
            overflow: hidden;
            width: 0;
            max-height: 0;f
            line-height: 0;
            mso-hide: all;
        }

        [data-ogsb] .es-button {
            border-width: 0 !important;
            padding: 10px 20px 10px 20px !important;
        }

        @media only screen and (max-width:600px) {
            p,
            ul li,
            ol li,
            a {
                line-height: 120% !important
            }
            h1,
            h2,
            h3,
            h1 a,
            h2 a,
            h3 a {
                line-height: 150% !important
            }
            h1 {
                font-size: 22px !important;
                text-align: center !important
            }
            h2 {
                font-size: 18px !important;
                text-align: center !important
            }
            h3 {
                font-size: 16px !important;
                text-align: center !important
            }
            .es-header-body h1 a,
            .es-content-body h1 a,
            .es-footer-body h1 a {
                font-size: 22px !important;
                text-align: center !important
            }
            .es-header-body h2 a,
            .es-content-body h2 a,
            .es-footer-body h2 a {
                font-size: 18px !important;
                text-align: center !important
            }
            .es-header-body h3 a,
            .es-content-body h3 a,
            .es-footer-body h3 a {
                font-size: 16px !important;
                text-align: center !important
            }
            .es-menu td a {
                font-size: 14px !important
            }
            .es-header-body p,
            .es-header-body ul li,
            .es-header-body ol li,
            .es-header-body a {
                font-size: 16px !important
            }
            .es-content-body p,
            .es-content-body ul li,
            .es-content-body ol li,
            .es-content-body a {
                font-size: 12px !important
            }
            .es-footer-body p,
            .es-footer-body ul li,
            .es-footer-body ol li,
            .es-footer-body a {
                font-size: 14px !important
            }
            .es-infoblock p,
            .es-infoblock ul li,
            .es-infoblock ol li,
            .es-infoblock a {
                font-size: 12px !important
            }
            *[class="gmail-fix"] {
                display: none !important
            }
            .es-m-txt-c,
            .es-m-txt-c h1,
            .es-m-txt-c h2,
            .es-m-txt-c h3 {
                text-align: center !important
            }
            .es-m-txt-r,
            .es-m-txt-r h1,
            .es-m-txt-r h2,
            .es-m-txt-r h3 {
                text-align: right !important
            }
            .es-m-txt-l,
            .es-m-txt-l h1,
            .es-m-txt-l h2,
            .es-m-txt-l h3 {
                text-align: left !important
            }
            .es-m-txt-r img,
            .es-m-txt-c img,
            .es-m-txt-l img {
                display: inline !important
            }
            .es-button-border {
                display: inline-block !important
            }
            a.es-button,
            button.es-button {
                font-size: 18px !important;
                display: inline-block !important
            }
            .es-adaptive table,
            .es-left,
            .es-right {
                width: 100% !important
            }
            .es-content table,
            .es-header table,
            .es-footer table,
            .es-content,
            .es-footer,
            .es-header {
                width: 100% !important;
                max-width: 600px !important
            }
            .es-adapt-td {
                display: block !important;
                width: 100% !important
            }
            .adapt-img {
                width: 100% !important;
                height: auto !important
            }
            .es-m-p0 {
                padding: 0 !important
            }
            .es-m-p0r {
                padding-right: 0 !important
            }
            .es-m-p0l {
                padding-left: 0 !important
            }
            .es-m-p0t {
                padding-top: 0 !important
            }
            .es-m-p0b {
                padding-bottom: 0 !important
            }
            .es-m-p20b {
                padding-bottom: 20px !important
            }
            .es-mobile-hidden,
            .es-hidden {
                display: none !important
            }
            tr.es-desk-hidden,
            td.es-desk-hidden,
            table.es-desk-hidden {
                width: auto !important;
                overflow: visible !important;
                float: none !important;
                max-height: inherit !important;
                line-height: inherit !important
            }
            tr.es-desk-hidden {
                display: table-row !important
            }
            table.es-desk-hidden {
                display: table !important
            }
            td.es-desk-menu-hidden {
                display: table-cell !important
            }
            .es-menu td {
                width: 1% !important
            }
            table.es-table-not-adapt,
            .esd-block-html table {
                width: auto !important
            }
            table.es-social {
                display: inline-block !important
            }
            table.es-social td {
                display: inline-block !important
            }
            .es-desk-hidden {
                display: table-row !important;
                width: auto !important;
                overflow: visible !important;
                max-height: inherit !important
            }
            .es-m-p5 {
                padding: 5px !important
            }
            .es-m-p5t {
                padding-top: 5px !important
            }
            .es-m-p5b {
                padding-bottom: 5px !important
            }
            .es-m-p5r {
                padding-right: 5px !important
            }
            .es-m-p5l {
                padding-left: 5px !important
            }
            .es-m-p10 {
                padding: 10px !important
            }
            .es-m-p10t {
                padding-top: 10px !important
            }
            .es-m-p10b {
                padding-bottom: 10px !important
            }
            .es-m-p10r {
                padding-right: 10px !important
            }
            .es-m-p10l {
                padding-left: 10px !important
            }
            .es-m-p15 {
                padding: 15px !important
            }
            .es-m-p15t {
                padding-top: 15px !important
            }
            .es-m-p15b {
                padding-bottom: 15px !important
            }
            .es-m-p15r {
                padding-right: 15px !important
            }
            .es-m-p15l {
                padding-left: 15px !important
            }
            .es-m-p20 {
                padding: 20px !important
            }
            .es-m-p20t {
                padding-top: 20px !important
            }
            .es-m-p20r {
                padding-right: 20px !important
            }
            .es-m-p20l {
                padding-left: 20px !important
            }
            .es-m-p25 {
                padding: 25px !important
            }
            .es-m-p25t {
                padding-top: 25px !important
            }
            .es-m-p25b {
                padding-bottom: 25px !important
            }
            .es-m-p25r {
                padding-right: 25px !important
            }
            .es-m-p25l {
                padding-left: 25px !important
            }
            .es-m-p30 {
                padding: 30px !important
            }
            .es-m-p30t {
                padding-top: 30px !important
            }
            .es-m-p30b {
                padding-bottom: 30px !important
            }
            .es-m-p30r {
                padding-right: 30px !important
            }
            .es-m-p30l {
                padding-left: 30px !important
            }
            .es-m-p35 {
                padding: 35px !important
            }
            .es-m-p35t {
                padding-top: 35px !important
            }
            .es-m-p35b {
                padding-bottom: 35px !important
            }
            .es-m-p35r {
                padding-right: 35px !important
            }
            .es-m-p35l {
                padding-left: 35px !important
            }
            .es-m-p40 {
                padding: 40px !important
            }
            .es-m-p40t {
                padding-top: 40px !important
            }
            .es-m-p40b {
                padding-bottom: 40px !important
            }
            .es-m-p40r {
                padding-right: 40px !important
            }
            .es-m-p40l {
                padding-left: 40px !important
            }
        }
    </style>
    <script src="admin/plugins/html2canvas/html2canvas.js" type="text/javascript"></script>    
</head>

<body style="width: 100%; font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif; text-size-adjust: 100%; padding: 0px; margin: 0px; overflow-y: scroll !important; visibility: visible !important;">
    <div class="es-wrapper-color" style="background-color:#F6F6F6">
        <!--[if gte mso 9]>
			<v:background xmlns:v="urn:schemas-microsoft-com:vml" fill="t">
				<v:fill type="tile" color="#f6f6f6"></v:fill>
			</v:background>
		<![endif]-->
        <?php if($rc!=0){?>
         <table class="es-wrapper" width="100%" cellspacing="0" cellpadding="0" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;padding:0;Margin:0;width:100%;height:100%;background-repeat:repeat;background-position:center top;background-color:#F6F6F6;padding-bottom: 10px;">
            <tbody>
                <tr>
                    <td align="center" style="padding-bottom:10px;Margin:0;font-family:'Fira Sans';background-color:#ffffff">
                    <button type="button" id="btnDescargarSC" style="background-color: #00a65a;border-color: #008d4c;border-radius: 3px;-webkit-box-shadow: none;box-shadow: none;border: 1px solid transparent;color: #fff;font-size: 18px;"> Descargar </button>
                    </td>
                </tr>
            </tbody>
        </table>
        
        <?php }?>		
        <table class="es-wrapper" width="100%" cellspacing="0" cellpadding="0" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;padding:0;Margin:0;width:100%;height:100%;background-repeat:repeat;background-position:center top;background-color:#F6F6F6">
            <tbody>
                <tr>
                    <td valign="top" style="padding:0;Margin:0">
                        <table cellpadding="0" cellspacing="0" class="es-content" align="center" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;table-layout:fixed !important;width:100%">
                            <tbody>
                                <tr>
                                    <td align="center" style="padding:0;Margin:0;font-family:'Fira Sans';background-color:#ffffff">
                                        <table id="divo" bgcolor="#f2f2f2" class="es-content-body" align="center" cellpadding="0" cellspacing="0" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;background-color:#ffffff;width:600px;font-family:'Fira Sans'">
                                            <tbody>
                                                <tr>
                                                    <td align="center" style="padding:0;Margin:0">
                                                        <table cellpadding="0" cellspacing="0" width="100%" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="center" valign="top" style="padding:0;Margin:0;width:600px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td align="center" style="padding:0;Margin:0;font-family:'Fira Sans';font-size:0px"><img src="https://www.verismart.com.pe/verismart/img/security_check_apertura/c_8521622842720110.png" alt="" style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic;font-family:'Fira Sans'"
                                                                                            width="600" class="adapt-img"></td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td align="left" style="padding:0;Margin:0;padding-top:20px;padding-left:20px;padding-right:20px">
                                                        <table cellpadding="0" cellspacing="0" width="100%" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="center" valign="top" style="padding:0;Margin:0;width:560px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td align="center" class="es-m-txt-c" style="padding:0;Margin:0">
                                                                                        <h1 style="Margin:0;line-height:42px;mso-line-height-rule:exactly;font-family:'Fira Sans', sans-serif;font-size:28px;font-style:normal;font-weight:normal;color:#fe0231"><strong>¡Hola!</strong></h1>
                                                                                    </td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td align="center" class="es-m-txt-c" style="padding:0;Margin:0">
                                                                                        <h1 style="Margin:0;line-height:33px;mso-line-height-rule:exactly;font-family:'Fira Sans', sans-serif;font-size:22px;font-style:normal;font-weight:normal;color:#180408">Yo seré el especialista de seguridad que te atenderá.</h1>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td align="center" bgcolor="#ffffff" style="padding:0;Margin:0;font-family:'Fira Sans';background-color:#ffffff">
                                                        <table cellpadding="0" cellspacing="0" width="100%" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                            <tbody>
                                                                <tr class="es-mobile-hidden">
                                                                    <td align="center" valign="top" style="padding:0;Margin:0;width:600px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td align="center" style="padding:0;Margin:0"><br></td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td align="center" bgcolor="#ffffff" style="padding:0;Margin:0;font-family:'Fira Sans';background-color:#ffffff">
                                                        <!--[if mso]><table style="width:600px" cellpadding="0" cellspacing="0"><tr><td style="width:155px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td class="es-m-p0r es-m-p20b" align="center" style="padding:0;Margin:0;width:155px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:290px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td class="es-m-p20b" align="center" style="padding:0;Margin:0;width:290px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td align="center" class="es-m-txt-c" style="padding:0;Margin:0;font-family:'Fira Sans';font-size:0px"><img src="<?php echo $Foto;?>"
                                                                                            alt="" style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic;font-family:'Fira Sans'" width="225"></td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:0px"></td><td style="width:155px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-right" align="right" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:155px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td></tr></table><![endif]-->
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="es-m-p0t es-m-p0r es-m-p0l" align="center" bgcolor="#ffffff" style="padding:0;Margin:0;padding-top:20px;padding-left:20px;padding-right:20px;font-family:'Fira Sans';background-color:#ffffff">
                                                        <table width="100%" cellspacing="0" cellpadding="0" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                            <tbody>
                                                                <tr>
                                                                    <td class="es-m-p0r" valign="top" align="center" style="padding:0;Margin:0;width:560px">
                                                                        <table width="100%" cellspacing="0" cellpadding="0" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td align="center" class="es-m-txt-c" style="padding:0;Margin:0">
                                                                                        <h1 style="Margin:0;line-height:39px;mso-line-height-rule:exactly;font-family:'Fira Sans', sans-serif;font-size:26px;font-style:normal;font-weight:normal;color:#180408"><strong><?php echo strtoupper($Nombres." ".$Apellidos);?></strong></h1>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td align="left" style="padding:0;Margin:0">
                                                        <table cellpadding="0" cellspacing="0" width="100%" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:600px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td align="center" style="padding:0;Margin:0">
                                                                                        <h1 style="Margin:0;line-height:30px;mso-line-height-rule:exactly;font-family:'Fira Sans', sans-serif;font-size:20px;font-style:normal;font-weight:normal;color:#020202;display:inline-block;text-align:center"><strong>Nº de matrícula:</strong> </h1><span style="font-family:'Fira Sans', sans-serif;color:black;font-size:20px;display:inline-block;text-align:center;line-height:30px"><?php echo $Matricula;?></span></td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td align="left" style="padding:0;Margin:0;padding-top:10px">
                                                        <!--[if mso]><table style="width:600px" cellpadding="0" cellspacing="0"><tr><td style="width:225px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" align="left" class="es-left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td class="es-m-p20b" align="center" valign="top" style="padding:0;Margin:0;width:205px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr class="es-mobile-hidden">
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                    <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:150px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" class="es-m-p20b" style="padding:0;Margin:0;width:150px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td align="center" style="padding:0;Margin:0;font-size:0px"><img src="https://www.verismart.com.pe/verismart/img/security_check_apertura/<?php if($Estrellas==5){echo '5-estrellas-SCH.png';}else if($Estrellas==4.75){echo '4-75-estrellas-SCH.png';}else if($Estrellas==4.5){echo '4-5-estrellas-SCH.png';}else if($Estrellas==4.25){echo '4-25-estrellas-SCH.png';}else{echo '4-estrellas-SCH.png';}?>"
                                                                                            alt="" style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" width="150"></td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:20px"></td><td style="width:205px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-right" align="right" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:205px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr class="es-mobile-hidden">
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td></tr></table><![endif]-->
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td align="left" style="padding:0;Margin:0">
                                                        <table cellpadding="0" cellspacing="0" width="100%" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="center" valign="top" style="padding:0;Margin:0;width:600px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td align="center" class="es-m-txt-c es-m-p0t" style="padding:0;Margin:0;padding-top:30px">
                                                                                        <h1 style="Margin:0;line-height:42px;mso-line-height-rule:exactly;font-family:'Fira Sans', sans-serif;font-size:28px;font-style:normal;font-weight:normal;color:#fe0231"><strong>Tienes una visita agendada:</strong></h1>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="es-m-p5t" align="left" style="padding:0;Margin:0;padding-top:15px">
                                                        <!--[if mso]><table style="width:600px" cellpadding="0" cellspacing="0"><tr><td style="width:100px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:80px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr class="es-mobile-hidden">
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                    <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:100px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:80px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr class="es-mobile-hidden">
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                    <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:220px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:200px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td align="center" style="padding:0;Margin:0">
                                                                                        <h1 style="Margin:0;line-height:20px;mso-line-height-rule:exactly;font-family:'Fira Sans', sans-serif;font-size:20px;font-style:normal;font-weight:normal;color:#000000;display:inline-block"><strong>Fecha:</strong></h1>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                    <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:80px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:80px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr class="es-mobile-hidden">
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:20px"></td><td style="width:80px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-right" align="right" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:80px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr class="es-mobile-hidden">
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td></tr></table><![endif]-->
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td align="left" style="padding:0;Margin:0">
                                                        <!--[if mso]><table style="width:600px" cellpadding="0" cellspacing="0"><tr><td style="width:100px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:80px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr class="es-mobile-hidden">
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                    <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:100px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:80px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr class="es-mobile-hidden">
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                    <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:220px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:200px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td align="center" style="padding:0;Margin:0">
                                                                                        <h2 style="Margin:0;line-height:20px;mso-line-height-rule:exactly;font-family:'Fira Sans', sans-serif;font-size:20px;font-style:normal;font-weight:normal;color:#010101;display:inline-block"><?php echo $FechaVisita;?></h2>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                    <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:80px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:80px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr class="es-mobile-hidden">
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:20px"></td><td style="width:80px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-right" align="right" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:80px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr class="es-mobile-hidden">
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td></tr></table><![endif]-->
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="es-m-p0" align="left" style="padding:0;Margin:0;padding-top:15px">
                                                        <!--[if mso]><table style="width:600px" cellpadding="0" cellspacing="0"><tr><td style="width:100px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:80px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr class="es-mobile-hidden">
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                    <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:100px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:80px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr class="es-mobile-hidden">
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                    <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:220px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:200px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td align="center" style="padding:0;Margin:0">
                                                                                        <h1 style="Margin:0;line-height:20px;mso-line-height-rule:exactly;font-family:'Fira Sans', sans-serif;font-size:20px;font-style:normal;font-weight:normal;color:#000000;display:inline-block"><strong>Hora:</strong></h1>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                    <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:80px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:80px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr class="es-mobile-hidden">
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:20px"></td><td style="width:80px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-right" align="right" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:80px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr class="es-mobile-hidden">
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td></tr></table><![endif]-->
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td align="left" style="padding:0;Margin:0">
                                                        <!--[if mso]><table style="width:600px" cellpadding="0" cellspacing="0"><tr><td style="width:100px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:80px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr class="es-mobile-hidden">
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                    <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:100px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:80px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr class="es-mobile-hidden">
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                    <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:220px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:200px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td align="center" style="padding:0;Margin:0">
                                                                                        <h2 style="Margin:0;line-height:20px;mso-line-height-rule:exactly;font-family:'Fira Sans', sans-serif;font-size:20px;font-style:normal;font-weight:normal;color:#000000;display:inline-block"><?php echo $HoraVisita;?></h2>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                    <td class="es-hidden" style="padding:0;Margin:0;width:20px"></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:80px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-left" align="left" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:left">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:80px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr class="es-mobile-hidden">
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td><td style="width:20px"></td><td style="width:80px" valign="top"><![endif]-->
                                                        <table cellpadding="0" cellspacing="0" class="es-right" align="right" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px;float:right">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:80px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr class="es-mobile-hidden">
                                                                                    <td align="left" style="padding:0;Margin:0">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:17px;color:#333333;font-size:14px"><br></p>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                        <!--[if mso]></td></tr></table><![endif]-->
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td align="left" style="padding:0;Margin:0">
                                                        <table cellpadding="0" cellspacing="0" width="100%" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                            <tbody>
                                                                <tr>
                                                                    <td align="left" style="padding:0;Margin:0;width:600px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td align="center" class="es-m-p5t" style="padding:0;Margin:0;padding-top:20px">
                                                                                        <h1 style="Margin:0;line-height:30px;mso-line-height-rule:exactly;font-family:'Fira Sans', sans-serif;font-size:20px;font-style:normal;font-weight:normal;color:#000000"><strong>Dirección:</strong></h1>
                                                                                    </td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td align="center" valign="top" style="padding:0;Margin:0;width:600px">
                                                                        <table cellpadding="0" cellspacing="0" width="100%" role="presentation" style="mso-table-lspace:0pt;mso-table-rspace:0pt;border-collapse:collapse;border-spacing:0px">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <td align="center" style="padding:0;Margin:0">
                                                                                        <h2 style="Margin:0;line-height:30px;mso-line-height-rule:exactly;font-family:'Fira Sans', sans-serif;font-size:20px;font-style:normal;font-weight:normal;color:#000000"><?php echo strtoupper($Direccion.' , '.$Distrito);?></h2>
                                                                                    </td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td align="center" class="es-m-p10t" style="padding:0;Margin:0;padding-bottom:20px;padding-top:40px;font-size:0px"><img class="adapt-img" src="https://www.verismart.com.pe/verismart/img/security_check_reasignacion/captura_de_pantalla_20230220_a_las_100404.png"
                                                                                            alt="" style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" width="380"></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td align="center" style="padding:0;Margin:0;font-size:0px"><img class="adapt-img" src="https://www.verismart.com.pe/verismart/img/security_check_reasignacion/captura_de_pantalla_20230224_a_las_154055.png"
                                                                                            alt="" style="display:block;border:0;outline:none;text-decoration:none;-ms-interpolation-mode:bicubic" width="600"></td>
                                                                                </tr>
                                                                                <?php if($rc==0){?>
                                                                                <tr>
                                                                                    <td align="center" class="es-m-txt-c es-m-p5t es-m-p5b" style="padding:0;Margin:0;padding-top:10px;padding-bottom:10px">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:13px;color:#a9a9a9;font-size:11px">Has recibido este correo electrónico por haber solicitado la visita de un especialista de seguridad de Verisure Perú. No respondas este correo, ya que se generó de
                                                                                            forma automática y la casilla no permite la recepción de los mismos.</p>
                                                                                    </td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td align="center" class="es-m-txt-c es-m-p0t es-m-p0b" style="padding:0;Margin:0;padding-top:10px;padding-bottom:10px">
                                                                                        <p style="Margin:0;-webkit-text-size-adjust:none;-ms-text-size-adjust:none;mso-line-height-rule:exactly;font-family: arial, &quot;helvetica neue&quot;, helvetica, sans-serif;line-height:13px;color:#ff0000;font-size:11px">Copyright 2023 Verisure Peru, All rights reserved.</p>
                                                                                    </td>
                                                                                </tr>
                                                                                <?php }?>
                                                                            </tbody>
                                                                        </table>
                                                                    </td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </tbody>
        </table>

    
    </div>
    
    <?php if($rc!=0){?>
      <script>

        document.getElementById("btnDescargarSC").addEventListener("click", function() {
                html2canvas(document.getElementById('divo')).then(canvas => {
                var Telefonouno='<?php echo $Telefonouno;?>';  
                var base64image = canvas.toDataURL("image/png");
        
                var a = document.createElement("a"); //Create <a>
                a.href = base64image; //Image Base64 Goes here
                a.download = Telefonouno+".png"; //File name Here
                a.click(); //Downloaded file          
        });          
            
    })
        </script>
<?php }?>        
    
</body>

</html>
