<?php
session_start();
if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
        }

if ($_SESSION['pztecconsulta']==0) {
     header("location: ./denegado.php");
		exit;
        }


date_default_timezone_set('America/Lima');
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}


include 'config/db.php';
include 'config/conexion.php';
require (__DIR__) . '/helper/helper_validacion.php';

/*
include 'config/dbsec.php';
include 'config/conexionsec.php';
*/
$rc=NULL;

if (isset($_GET['idventa'])) {

    $idventa = sanitizaCampo($_GET['idventa'], 'sanitizeint|scapestring|htmlspecialchars', $con);
	$idventa = htmlspecialchars($idventa);
	
    $rc = sanitizaCampo($_GET['rc'], 'sanitizestring|scapestring|htmlspecialchars', $con);
	$rc = htmlspecialchars($rc);
}

$sql_venta = $con->prepare("SELECT
    u.IdUsuario,
    v.Matricula,
    v.Comercial,
    v.CC,
    v.JefeVenta,
    CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta,
    v.EstadoVenta,
    v.CategoriaVenta,
    v.TipoVenta,
    v.Segmento,
    v.MesesAutorizado,
    v.NProspecto,
    v.NContrato,
    v.IdCliente,
    c.NombApellido Cliente,
    c.Correo,
    c.Telefonouno,
    c.Telefonodos,
    c.Direccion,
    c.Referencia,
    c.Interior,
    g.IdGeografico,
    g.Distrito,
    g.Provincia,
    v.PrecioKit,
    v.TotalExtra,
    v.ResumenVenta,
    v.ExtraAutorizado,
    v.FormaPago,
    v.N590,
    v.PAI,
    v.CCOriginal,
    agen.IdAgenda,
    agen.InstaladoX,
    agen.MatriculaTec,
    CONCAT(t.Nombres,' ',t.Apellidos) Instalador,
    t.LN LNInstalador,
    DATE_FORMAT(agen.FechaInst, '%d/%m/%Y') FechaInst, 
    TIME_FORMAT(agen.HoraInst,'%r') HoraInst,
    agen.Comentario,
    agen.MotivoInviable,
    agen.MotivoCancelada,
    agen.Repercusion,
    agen.RepercusionCosto,
    f.MotivoIncidencia,
    DATE_FORMAT(f.FechaRecepcionDOC, '%d/%m/%Y') FechaRecepcionDOC,
    DATE_FORMAT(f.FechaFacturacion, '%d/%m/%Y') FechaFacturacion,
    f.DOCOriginal,
    f.Segmentacion,
    f.Pago,
    f.Autoriza,
    f.DNI,
    f.ElementosCTOPS,
    f.DOCPAI,
    f.FaltaDOC,
    f.RehacerCTO,
    f.Afiliacion,
    f.Prospecto_NroGuia,
    f.FueraHora,
    v.TCGestor,
    v.TipoKIT,
    agen.FechaGestion,
    agen.FechaAgendamiento,
    agen.FechaInstalacion,
    sc.Nombres as NombresScoring,
    sc.ApellidoPaterno as ApellidoPaternoScoring,
    sc.ApellidoMaterno as ApellidoMaternoScoring,
    sc.TipoDocumento as TipoDocumentoScoring    
    FROM dbVENTAS.tblventa v 
    INNER JOIN dbUSUARIO.tblusuario u on v.IdUsuario=u.IdUsuario 
    INNER JOIN dbUSUARIO.tblarea a on a.IdArea=u.IdArea 
    INNER JOIN dbUSUARIO.tblusuario m on m.Matricula=u.Manager
    INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
    INNER JOIN dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
    INNER JOIN dbVENTAS.tblagenda agen on agen.IdVenta=v.IdVenta
    INNER JOIN dbVENTAS.tblfacturacion f on f.IdVenta=v.IdVenta
    LEFT JOIN dbUSUARIO.tblusuario t on t.Matricula=agen.MatriculaTec
    LEFT JOIN dbVENTAS.tbltmpscoring sc on sc.IdConsultaScoring=v.IdConsultaScoringRP    
    WHERE v.IdVenta=?");
    $sql_venta->bind_param('i',$idventa);
    $sql_venta->execute();
    $sql_venta->store_result();
    $sql_venta->bind_result(
        $IdUsuarioRow,
        $MatriculaRow,
        $ComercialRow,
        $CCRow,
        $JefeVentaRow,
        $NombJefeVentaRow,
        $EstadoVentaRow,
        $CategoriaVentaRow,
        $TipoVentaRow,
        $SegmentoRow,
        $MesesAutorizadoRow,
        $NProspectoRow,
        $NContratoRow,
        $IdClienteRow,
        $ClienteRow,
        $CorreoRow,
        $TelefonounoRow,
        $TelefonodosRow,
        $DireccionRow,
        $ReferenciaRow,
        $InteriorRow,
        $IdGeograficoRow,
        $DistritoRow,
        $ProvinciaRow,
        $PrecioKitRow,
        $TotalExtraRow,
        $ResumenVentaRow,
        $ExtraAutorizadoRow,
        $FormaPagoRow,
        $N590Row,
        $PAIRow,
        $CCOriginalRow,
        $IdAgendaRow,
        $InstaladoXRow,
        $MatriculaTecRow,
        $InstaladorRow,
        $LNInstaladorRow,
        $FechaInstRow, 
        $HoraInstRow,
        $ComentarioRow,
        $MotivoInviableRow,
        $MotivoCanceladaRow,
        $RepercusionRow,
        $RepercusionCostoRow,
        $MotivoIncidenciaRow,
        $FechaRecepcionDOCRow,
        $FechaFacturacionRow,
        $DOCOriginalRow,
        $SegmentacionRow,
        $PagoRow,
        $AutorizaRow,
        $DNIRow,
        $ElementosCTOPSRow,
        $DOCPAIRow,
        $FaltaDOCRow,
        $RehacerCTORow,
        $AfiliacionRow,
        $Prospecto_NroGuiaRow,
        $FueraHoraRow,
        $TCGestorRow,
        $TipoKITRow,
        $FechaGestionRow,
        $FechaAgendamientoRow,
        $FechaInstalacionRow,
        $NombresScoring,
        $ApellidoPaternoScoring,
        $ApellidoMaternoScoring,
        $TipoDocumentoScoring        
        );
    $numrows_venta = $sql_venta->num_rows;

if ($numrows_venta > 0) {
    while ($sql_venta->fetch()) {
        $idu= $IdUsuarioRow;  
        $matricula= $MatriculaRow;  
        $comercial= $ComercialRow;  
        $matjefe= $JefeVentaRow;  
        $jefeventa= $NombJefeVentaRow;  
        $dc= $CCRow;  
        $estadoventa= $EstadoVentaRow;  
        $categoriaventa= $CategoriaVentaRow;  
        $tipoventa= $TipoVentaRow;  
        $segmento= $SegmentoRow;  
        $mesesautorizados= $MesesAutorizadoRow;  
        $nprospecto= $NProspectoRow;  
        $ncontrato= $NContratoRow;  
        $idcliente= $IdClienteRow;  
        $cliente= $ClienteRow;  
        $correo= $CorreoRow;  
        $movil= $TelefonounoRow;  
        $fijo= $TelefonodosRow;  
        $direccion= $DireccionRow;  
        $preciokit= $PrecioKitRow;  
        $totalextra= $TotalExtraRow;  
        $resumenventa= $ResumenVentaRow;  
        $regaloutorizado= $ExtraAutorizadoRow;  
        $formadepago= $FormaPagoRow;  
        $n590= $N590Row;  
        $PAI= $PAIRow;  
        $idgeografico= $IdGeograficoRow;  
        $distrito= utf8_encode($DistritoRow);
        $provincia= $ProvinciaRow;  
        $costo= $RepercusionCostoRow;  
        $CCOriginal= $CCOriginalRow;  
        $lninstalador= $LNInstaladorRow;
        $idagenda= $IdAgendaRow;
        $instaladox= $InstaladoXRow;
        $matriculatec= $MatriculaTecRow;
        $nomreinstalador= $InstaladorRow;
        $fechainstalacionver= $FechaInstRow;
        $horainstalacionver= $HoraInstRow;
        $comentarioagenda= $ComentarioRow;
        $motivoinviable= $MotivoInviableRow;
        $motivocancelado= $MotivoCanceladaRow;
        $repercucion= $RepercusionRow;
        $factmotivoincidencia= $MotivoIncidenciaRow;
        $factfecharecepciondoc= $FechaRecepcionDOCRow;
        $factfechafacturacion= $FechaFacturacionRow;
        $factdocoriginal= $DOCOriginalRow;
        $factsegmentacion= $SegmentacionRow;
        $factpago= $PagoRow;
        $factautoriza= $AutorizaRow;
        $factdni= $DNIRow;
        $factelementosctops= $ElementosCTOPSRow;
        $factdocpai= $DOCPAIRow;
        $factfaltadoc= $FaltaDOCRow;
        $factrehacercto= $RehacerCTORow;
        $factafiliacion= $AfiliacionRow;
        $factprospecto_nroguia= $Prospecto_NroGuiaRow;
        $factfuerahora= $FueraHoraRow;
        $TCGestor= $TCGestorRow;
        $TipoKIT= $TipoKITRow;
        $Referencia= $ReferenciaRow;
        $Interior= $InteriorRow;
        $FechaGestion= $FechaGestionRow;
        $FechaAgendamiento= $FechaAgendamientoRow;
        $FechaInstalacion= $FechaInstalacionRow;
    }
    
}

$html=NULL;

$sql = $con->prepare("SELECT DISTINCT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) JefeVenta FROM dbUSUARIO.tblusuario u  where u.CC=? AND u.LN='11' AND (u.Categoria ='JE' OR u.Categoria ='COACH' OR u.Categoria ='DEL' or u.Categoria='JE/DEL'  ) LIMIT 50"); 
$sql->bind_param('i',$CCOriginal);
$sql->execute();
$sql->store_result();
$sql->bind_result(
    $MatriculaRow,
    $JefeVentaRow
    );


if ($sql->num_rows > 0) {
    $Matricula=$MatriculaRow;
    $JefeVenta=$JefeVentaRow;
    while ($sql->fetch()) {                
       if($Matricula==$matjefe){
               $html .= '<option value="'.$Matricula.'" selected>'.$Matricula.' - '.utf8_encode($JefeVenta).' </option>';
                }else{
$html .= '<option value="'.$Matricula.'">'.$Matricula.' - '.utf8_encode($JefeVenta).' </option>';
    }
}
}else{
     $html .= '<option>No se encontraron resultado</option>';
}


$html_tecnico=NULL;
if($lninstalador=="" || empty($lninstalador)){
$html_tecnico.= '<option></option>';
}else{

$sql_tecnico = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Instalador FROM dbUSUARIO.tblusuario u  
INNER JOIN dbUSUARIO.tblarea a on a.IdArea=u.IdArea
WHERE u.LN=?"); 
$sql_tecnico->bind_param('i',$lninstalador);
$sql_tecnico->execute();
$sql_tecnico->store_result();
$sql_tecnico->bind_result(
    $MatriculaRow,
    $InstaladorRow
    );


if ($sql_tecnico->num_rows > 0) {
    while ($sql_tecnico->fetch()) {                
        $Matricula=$MatriculaRow;
        $Instalador=$InstaladorRow;
if($Matricula==$matriculatec){
               $html_tecnico.= '<option value="'.$Matricula.'" selected>'.$Matricula.' - '.utf8_encode($Instalador).' </option>';
                }else{
$html_tecnico.= '<option value="'.$Matricula.'">'.$Matricula.' - '.utf8_encode($Instalador).' </option>';
}
    }
}else{
     $html_tecnico.= '<option>No se encontraron resultado</option>';
}

}

$IdAgenRepor=NULL;
$FechaGestion=NULL;
$FechaAgendamiento=NULL;
$FechaInstalacion=NULL;
$FechaCancelada=NULL;
$FechaInviable=NULL;
$FechaIlocalizable=NULL;
$sql_agendareport = $con->prepare("SELECT IdAgenRepor,FechaInstalada,FechaVenta,FechaPrimeraGestion,FechaProgramacion,FechaAgedamiento,FechaCancelada,FechaInviable,FechaIlocalizable FROM tblagendareporte WHERE IdVenta=? ORDER BY 1 DESC LIMIT 1"); 
$sql_agendareport->bind_param('i',$idventa);
$sql_agendareport->execute();
$sql_agendareport->store_result();
$sql_agendareport->bind_result(
    $IdAgenReporRow,
    $FechaInstaladaRow,
    $FechaVentaRow,
    $FechaPrimeraGestionRow,
    $FechaProgramacionRow,
    $FechaAgedamientoRow,
    $FechaCanceladaRow,
    $FechaInviableRow,
    $FechaIlocalizableRow
    );


if ($sql_agendareport->num_rows > 0) {
    while ($sql_agendareport->fetch()) {     
        $IdAgenRepor=$IdAgenReporRow;
        $FechaGestion=$FechaPrimeraGestionRow;
        $FechaAgendamiento=$FechaAgedamientoRow;
        $FechaInstalacion=$FechaInstaladaRow;
        $FechaCancelada=$FechaCanceladaRow;
        $FechaInviable=$FechaInviableRow;
        $FechaIlocalizable=$FechaIlocalizableRow;
    }
}


//INFORMACION AFILIACION


    $stmtsqlafiliacion = $con->prepare("SELECT status,ACTION_DESCRIPTION,dataMap FROM dbREFERIDO.tblafiliacion where beneficiaryId=?"); 
    // $resultafiliacion = mysqli_query($con, $sqlafiliacion);
    $stmtsqlafiliacion->bind_param('s',$ncontrato);
    $stmtsqlafiliacion->execute();
    $stmtsqlafiliacion->store_result();
    $stmtsqlafiliacion->bind_result(
        $estadoafiliacionRow,
        $ACTION_DESCRIPTIONRow,
        $dataMapRow
        );
    
    if ($stmtsqlafiliacion->num_rows > 0) {
        while ($stmtsqlafiliacion->fetch()) {     
            $estadoafiliacion = $estadoafiliacionRow;
            $ACTION_DESCRIPTION = $ACTION_DESCRIPTIONRow;
            $dataMap = $dataMapRow;
            if(isset($dataMap) && !empty($dataMap)){
                $objAfiliacion=json_decode($dataMap, true);
                if(isset($objAfiliacion['mensaje_autorizacion']['dataMap']['CARD'])){
                    $card=$objAfiliacion['mensaje_autorizacion']['dataMap']['CARD'];
                    $tipocuenta='Tarjeta';
                }else{
                    $card='';
                    $tipocuenta='';
                }
            }
        }
    }else{
         $estadoafiliacion='Pendiente';
         $ACTION_DESCRIPTION='';
         $dataMap='';
         $card='';
         $tipocuenta='';
    }

    $variablecuenta=array('Diners Club','visa','mastercard','American Express');
//INFORMACION AFILIACION
    $stmtsqlafiliacionmdp = $con->prepare("SELECT id,status,motivo,numero,tipo,correo FROM dbREFERIDO.tblmdpafiliacion where ncontrato=?"); 
    $stmtsqlafiliacionmdp->bind_param('s',$ncontrato);
    $stmtsqlafiliacionmdp->execute();
    $stmtsqlafiliacionmdp->store_result();
    $stmtsqlafiliacionmdp->bind_result(
        $idnmdpRow,
        $estadoafiliacionmdpRow,
        $motivomdpRow,
        $cardRow,
        $tipoRow,
        $correoenviomdpRow
        );
    
 
    if ($stmtsqlafiliacionmdp->num_rows> 0) {
        while ($stmtsqlafiliacionmdp->fetch()) {     
            $idnmdp=$idnmdpRow;
            $estadoafiliacionmdp=$estadoafiliacionmdpRow;
            $motivomdp=$motivomdpRow;
            $card=$cardRow;
            $tipo=$tipoRow;
            $correoenviomdp=$correoenviomdpRow;
            if(in_array($tipo,$variablecuenta)){
               $tipocuenta='Tarjeta'; 
            }else{
               $tipocuenta='Cuenta'; 
            }
        }
    }else{
            $idnmdp='';
            $estadoafiliacionmdp='';
            $motivomdp='';
            $tipo='';
            $correoenviomdp='';
            $tipocuenta='';
    }




?>


<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
       <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">


        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">

      
        
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->

        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
 <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
 
 <link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css"/>
  <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
  
 
        <style>

            .modal-header-danger {
                color:#fff;
                background-color: #e4002b;              
            }

           
            
            .dataTables_wrapper .myfilter .dataTables_filter{float:left}
            .dataTables_wrapper .mylength .dataTables_length{float:right}
            div.dataTables_scrollBody thead th {
                vertical-align: top;
            } 
            td {
                max-width: 250px;
                overflow: hidden;
                white-space: nowrap;
                text-overflow: ellipsis;

            }
            .espacio{
                height:10px;
            }
            
           .espacio2{
                height:15px;
            }


            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #frmEditarVenta .form-control{
                border-radius: 4px
            }

   
            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo { 
                color: #FFFFFF; 
                background-color: #444444; 
                border-color: #444444; 
            } 

            .btn-nuevo:hover, 
            .btn-nuevo:focus, 
            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                color: #FFFFFF; 
                background-color: #616161;  
                border-color: #444444; 
            } 

            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                background-image: none; 
            } 

            .btn-nuevo.disabled, 
            .btn-nuevo[disabled], 
            fieldset[disabled] .btn-nuevo, 
            .btn-nuevo.disabled:hover, 
            .btn-nuevo[disabled]:hover, 
            fieldset[disabled] .btn-nuevo:hover, 
            .btn-nuevo.disabled:focus, 
            .btn-nuevo[disabled]:focus, 
            fieldset[disabled] .btn-nuevo:focus, 
            .btn-nuevo.disabled:active, 
            .btn-nuevo[disabled]:active, 
            fieldset[disabled] .btn-nuevo:active, 
            .btn-nuevo.disabled.active, 
            .btn-nuevo[disabled].active, 
            fieldset[disabled] .btn-nuevo.active { 
                background-color: #444444; 
                border-color: #444444; 
            } 
   

        </style>
        
        
     <style>
       .main-header,.main-sidebar,.left-side{position:fixed}
       
      .main-header {
    top: 0;
    right: 0;
    left: 0
}
 .content-wrapper,
 .right-side {
    padding-top: 50px
}

@media (max-width:767px) {
     .content-wrapper,
     .right-side {
        padding-top: 100px
    }
}

.layout-boxed .wrapper {
    max-width: 100%
}

.wrapper {
    overflow: hidden
}

 .control-sidebar {
    position: fixed;
    height: 100%;
    overflow-y: auto;
    padding-bottom: 50px
}       
        
        

  </style>
       
       
        <style>
            

.ui-autocomplete {
    position: absolute;
    z-index: 1000;
    cursor: default;
    padding: 0;
    margin-top: 2px;
    list-style: none;
    font-size: 11px;
    font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
    background-color: #ffffff;
    border: 1px solid #ccc;
    -webkit-border-radius: 5px;
       -moz-border-radius: 5px;
            border-radius: 5px;
    -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
       -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
            box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
            
        z-index: 1051 !important;    
            
}





   hr {
  height: 4px;
  width: 100%;
  background-color: #ecf0f5;

}



hr {
    /* margin-top: 20px; */
    margin-bottom: 20px;
    border: 0;
    /* border-top: 1px solid #eee; */
}


hr {
    display: block;
    unicode-bidi: isolate;
    -webkit-margin-before: 0.5em;
    -webkit-margin-after: 0.5em;
    -webkit-margin-start: auto;
    -webkit-margin-end: auto;
    overflow: hidden;
    border-style: inset;
   
}

.box.box-custom {
    border-top-color: #ffffff;
}

.box {
    position: relative;
    border-radius: 3px;
    background: #ffffff;
    border-top: 3px solid #d2d6de;
    margin-bottom: 5px;
    width: 100%;
    box-shadow: 0 1px 1px rgba(0,0,0,0.1);
}
.ocultar{
    display:none;
}
        </style>
        

        



    </head>

    <body class="sidebar-collapse skin-red sidebar-mini">

 <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php




            $agenda = "active";
            include 'admin/main-sidebar.php';




            ?>


            <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        TÉCNICO
                    </h1>
                    <ol class="breadcrumb">
                        <li><a><i class="fa fa-dashboard"></i> Home</a></li>
                        <li><a href="consultatecnica.php">Consulta Técnica</a></li>
                        <li class="active">Editar de Venta</li>
                    </ol>


                </section>
                
                

                <!-- Main content -->
                <section class="content">
                    
                    
                    <div class="row">
                        <div class="col-md-2"></div>
                        
                        <div class="col-md-8">
                                <!-- /.box-header -->
                            <div class="box box-danger">
                                <div class="box-header">
                                    <div class="form-horizontal">
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <h3 class="col-sm-12 col-xs-12 box-title" style="text-align:left;">EDITAR <?php 
                                                                            if ($categoriaventa == "Online"){
                                                                                $nombc="VENTA ONLINE";
                                                                            }else if($categoriaventa == "Ficha"){
                                                                                $nombc="VENTA FICHA";
                                                                            }else{
                                                                                $nombc="VENTA DELEGACIÓN";
                                                                            }
                                                                             echo $nombc." - ".$nprospecto." | ".$ncontrato ?></h3>
                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="box-tools pull-right">
                                            <?php if($estadoventa=='Facturada' || $nombacceso=='test' || $estadoventa=='InstaladaTEC'){
                                                 }else{ ?>
                                                    <a class="btn btn-nuevo btn-sm" id="btnGuardarEditarVenta" href="#"><i class="fa fa-save"></i></a>
                                               <?php   } ?>
                                         <a  href="consultatecnica.php" class="btn btn-danger btn-sm" ><i class="fa fa-reply"></i></a>
                                    </div>

                                  
                                </div>
                                <div class="espacio"></div>
                            </div>
                            
                            <input type="hidden" id="idVenta" name="" value="<?php echo $idventa;?>">
                            <input type="hidden" id="estadoVenta" name="" value="<?php echo $estadoventa;?>">
                            <input type="hidden" id="matriculaUsuario" name="" value="<?php echo $matriculausuario;?>">
                            <input type="hidden" id="Matricula" name="" value="<?php echo $matricula;?>">
                            <input type="hidden" id="Dc" name="" value="<?php echo $dc;?>">
                            <input type="hidden" id="matJefe" name="" value="<?php echo $matjefe;?>">
                            <input type="hidden" id="TcGestor" name="" value="<?php echo $TCGestor;?>">
                            
                            <form id="frmEditarVenta" method="POST">
                                <input type="hidden" id="FechaGestion" name="FechaGestion" value="<?php echo $FechaGestion;?>">
                                <input type="hidden" id="FechaAgendamiento" name="FechaAgendamiento" value="<?php echo $FechaAgendamiento;?>">
                                <input type="hidden" id="FechaInstalacion" name="FechaInstalacion" value="<?php echo $FechaInstalacion;?>">
                                <input type="hidden" id="FechaCancelada" name="FechaCancelada" value="<?php echo $FechaCancelada;?>">
                                <input type="hidden" id="FechaInviable" name="FechaInviable" value="<?php echo $FechaInviable;?>">
                                <input type="hidden" id="FechaIlocalizable" name="FechaIlocalizable" value="<?php echo $FechaIlocalizable;?>">                                            
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                       <h5>INFORMACION DE VENTA</h5>
                        
                                      <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                        
                                      </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                          <div class="form-horizontal">
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblmatricula">MATRICULA:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                       <input name="lblmatricula" id="lblmatricula" class="form-control input-sm" value="<?php echo $matricula;?>" style="width: 100%;" readonly="readonly">
                                                        <input id="lblidusuario" name="lblidusuario" value="<?php echo $idu;?>" hidden="">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnombcomercial">COMERCIAL: <span style="color:red"> * </span></label>
                                                            <div class="col-sm-8 col-xs-8">
                                                            <input name="lblnombcomercial" id="lblnombcomercial" class="form-control input-sm" style="width: 100%;" value="<?php echo $comercial;?>" readonly="readonly" >
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbldc">DC:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <input name="lbldc" id="lbldc" class="form-control input-sm" style="width: 100%;" value="<?php echo $dc;?>" readonly="readonly" >
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnombcomercial">JEFE VENTA:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                    <select class="form-control input-sm" name="lbljefeventa" id="lbljefeventa" style="width: 100%;" disabled="disabled">
                                                                        <?php echo $html;?>
                                                                    </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblestadoventa">ESTADO VENTA:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                       <select name="lblestadoventa" id="lblestadoventa" class="form-control input-sm">
                                                                       <option>Seleccione</option>
<?php
 if ($estadoventa == "AgendadaTEC" || $estadoventa == "InstaladaTEC" ){
?>
<option value="AgendadaTEC"<?php if ($estadoventa == "AgendadaTEC") {echo "selected";}?> hidden>AgendadaTEC</option>
<option value="InstaladaTEC"<?php if ($estadoventa == "InstaladaTEC") {echo "selected";}?>>InstaladaTEC</option>
<?php
 }
if ($estadoventa == "AgendadaDEL" || $estadoventa == "InstaladaDEL" || $estadoventa == "NoInstalada"){
?>
<option value="AgendadaDEL"<?php if ($estadoventa == "AgendadaDEL") {echo "selected";}?>>AgendadaDEL</option>
<option value="InstaladaDEL"<?php if ($estadoventa == "InstaladaDEL") {echo "selected";}?>>InstaladaDEL</option>
<option value="NoInstalada"<?php if ($estadoventa == "NoInstalada") {echo "selected";}?> hidden>NoInstalada</option>
<option value="Instalada"<?php if ($estadoventa == "Instalada") {echo "selected";}?>>Instalada</option>
<option value="Cancelada"<?php if ($estadoventa == "Cancelada") {echo "selected";}?>>Cancelada</option>
<?php
 }
 if ($estadoventa == "Instalada"){
?>
<option value="Instalada"<?php if ($estadoventa == "Instalada") {echo "selected";}?>>Instalada</option>
<?php
 }
  if ($estadoventa == "PendienteData"){
?>
<option value="PendienteData"<?php if ($estadoventa == "PendienteData") {echo "selected";}?>>PendienteData</option>
<?php
 }
  if ($estadoventa == "PendienteAgenda"){
?>
 <option value="PendienteAgenda"<?php if ($estadoventa == "PendienteAgenda") {echo "selected";}?>>PendienteAgenda</option>
<?php
 }
  if ($estadoventa == "IncidenciaGestCorreo"){
?>
<option value="IncidenciaGestCorreo"<?php if ($estadoventa == "IncidenciaGestCorreo") {echo "selected";}?> hidden="">IncidenciaGestCorreo</option>
<?php
 }
  if ($estadoventa == "IncidenciaGestValija"){
?>                                                                           
 <option value="IncidenciaGestValija"<?php if ($estadoventa == "IncidenciaGestValija") {echo "selected";}?> hidden="">IncidenciaGestValija</option>
<?php
 }
  if ($estadoventa == "Postergada"){
?>                                                                           
<option value="Postergada"<?php if ($estadoventa == "Postergada") {echo "selected";}?>>Postergada</option>
<?php
 }
  if ($estadoventa == "Ilocalizable"){
?>
<option value="Ilocalizable"<?php if ($estadoventa == "Ilocalizable") {echo "selected";}?>>Ilocalizable</option>
<?php
 }
  if ($estadoventa == "Inviable"){
?>
<option value="Inviable"<?php if ($estadoventa == "Inviable") {echo "selected";}?>>Inviable</option>
<?php
 }
  if ($estadoventa == "Facturada"){
?>
<option value="Facturada"<?php if ($estadoventa == "Facturada") {echo "selected";}?> hidden="">Facturada</option>
<?php
 }
  if ($estadoventa == "PorFacturar"){
?>
<option value="PorFacturar"<?php if ($estadoventa == "PorFacturar") {echo "selected";}?> hidden="">PorFacturar</option>
<?php
 }
  if ($estadoventa == "DocEnvi"){
?>
<option value="DocEnvi"<?php if ($estadoventa == "DocEnvi") {echo "selected";}?> hidden="">DocEnvi</option>
<?php
 }
  if ($estadoventa == "Incidencia"){
?>
 <option value="Incidencia"<?php if ($estadoventa == "Incidencia") {echo "selected";}?> hidden="">Incidencia</option>
<?php
 }
  if ($estadoventa == "Cancelada"){
?>
<option value="Cancelada"<?php if ($estadoventa == "Cancelada") {echo "selected";}?>>Cancelada</option>
<?php
 }
  if ($estadoventa == "NoDoc"){
?>
<option value="NoDoc"<?php if ($estadoventa == "NoDoc") {echo "selected";}?> hidden="">NoDoc</option>
<?php
 }
  if ($estadoventa == "Desmontada"){
?>

<option value="Desmontada"<?php if ($estadoventa == "Desmontada") {echo "selected";}?> hidden="">Desmontada</option>
<?php
 }
  
?>
                                                                               
                                                                            </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnombcomercial">RECURSO:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                    <select name="lbltipoventa" id="lbltipoventa" class="form-control input-sm" disabled="disabled">
                                                                                <option>Seleccione</option>
                                                                                <option value="RE"<?php if ($tipoventa == "RE") {echo "selected";}?>>RE</option>
                                                                                <option value="RP"<?php if ($tipoventa == "RP") {echo "selected";}?>>RP</option>
                                                                                <option value="RPPA"<?php if ($tipoventa == "RPPA") {echo "selected";}?>>RPPA</option>
                                                                                <option value="RPPR"<?php if ($tipoventa == "RPPR") {echo "selected";}?>>RPPR</option>
                                                                                <option value="RPMKT"<?php if ($tipoventa == "RPMKT") {echo "selected";}?>>RPMKT</option>
                                                                                <option value="RPTMK"<?php if ($tipoventa == "RPTMK") {echo "selected";}?>>RPTMK</option>
                                                                                <option value="RPGGCC"<?php if ($tipoventa == "RPGGCC") {echo "selected";}?>>RPGGCC</option>
                                                                                <option value="REGGCC"<?php if ($tipoventa == "REGGCC") {echo "selected";}?>>REGGCC</option>
                                                                    </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblsegmento">SEGMENTO:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <select class="form-control input-sm" name="lblsegmento" id="lblsegmento" disabled="disabled">
                                                                                <option>Seleccione</option>
                                                                                 <option value="RES"<?php if ($segmento == "RES") {echo "selected";}?>>RES</option>
                                                                                  <option value="NEG"<?php if ($segmento == "NEG") {echo "selected";}?>>NEG</option>
                                                                         
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnombcomercial">590:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                    <div class="input-group">
                                                                        <div class="input-group-addon input-sm">
                                                                            <i class="fa fa-calendar"></i>
                                                                        </div>
                                                                        <input type="text" class="form-control pull-right input-sm" id="mesano" value="<?php echo $n590;?>" name="lbl590" disabled="disabled">
                                                                    </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnprospecto">N° PROSPECTO:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <input type="text" class="form-control input-sm" name="lblnprospecto" id="lblnprospecto" data-inputmask='"mask": "999999"' value="<?php echo $nprospecto;?>" data-mask readonly="readonly">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblncontrato">N° CONTRATO:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                 <input type="text" class="form-control input-sm" name="lblncontrato" id="lblncontrato" data-inputmask='"mask": "9999999"' value="<?php echo $ncontrato;?>" data-mask readonly="readonly">
                                                                       
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnprospecto">CLIENTE:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <input name="lblnombcliente" class="form-control input-sm" id="lblnombcliente" value="<?php echo $cliente;?>" style="width: 100%;" readonly="readonly"/></td>
                                                                        <input id="lblidcliente" name="lblidcliente" value="<?php echo $idcliente;?>" hidden="">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblncontrato">CORREO:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                 <input type="text"  class="form-control input-sm" id="lblcorreo" value="<?php echo $correo;?>" name="lblcorreo" readonly="readonly">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>                                                 
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnprospecto">DIRECCIÓN:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <textarea class="form-control input-sm" name="lbldireccion" id="lbldireccion" rows="3" style="resize:none" placeholder="Ingresar..." readonly="readonly"><?php echo $direccion;?></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblncontrato">DISTRITO:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                 <select class="form-control selectdistrito input-sm" name="lbldistrito" id="lbldistrito" style="width: 100%;" disabled="disabled">
                                                                            <option value="<?php echo $idgeografico; ?>"><?php echo $distrito.' - '.$provincia; ?></option>
                                                                           
                                                                            </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinterior">INTERIOR:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <input type="text" class="form-control input-sm" name="lblinterior" id="lblinterior" value="<?php echo $Interior; ?>" disabled>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblreferencia">REFERENCIA:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                  <div class="input-group" style="display: flex">
                                                                                <input type="text" class="form-control input-sm" id="lblreferencia" name="lblreferencia" value="<?php echo $Referencia; ?>" disabled>
                                                                            </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblmovil">TELEFONO UNO:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <input type="text" class="form-control input-sm" name="lblmovil" id="lblmovil" value="<?php echo $movil;?>"  readonly="readonly"/>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfijo">TELEFONO DOS:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                  <div class="input-group" style="display: flex">
                                                                                <input type="text" class="form-control input-sm" name="lblfijo" id="lblfijo" value="<?php echo $fijo;?>" readonly="readonly"/>
                                                                    </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnprospecto">RESUMEN INST.:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <textarea class="form-control input-sm" name="lblresumenventa" id="lblresumenventa" rows="3" style="resize:none"  placeholder="Ingresar..." readonly="readonly"><?php  if($TipoKIT == '' || $TipoKIT == NULL){
                                                                                        echo $resumenventa;
                                                                                    } else {
                                                                                        $posicion_coincidencia = strripos($resumenventa, $TipoKIT);
                                                                                        if ($posicion_coincidencia === false){
                                                                                            echo "Kit ".$TipoKIT." + ".$resumenventa;    
                                                                                        } else {
                                                                                            echo $resumenventa;
                                                                                        }
                                                                                    }?></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblncontrato">REGALO AUTORIZADO:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                  <div class="input-group" style="display: flex">
                                                                               <select class="form-control input-sm" name="lblextraautorizado" id="lblextraautorizado" disabled="disabled">
                                                                                <option>Seleccione</option>
                                                                                <option value="Ninguno"<?php if ($regaloutorizado == "Ninguno") {echo "selected";}?>>Ninguno</option>
                                                                                <option value="Mando a distancia"<?php if ($regaloutorizado == "Mando a distancia") {echo "selected";}?>>Mando a distancia</option>
                                                                                <option value="Magnetico"<?php if ($regaloutorizado == "Magnetico") {echo "selected";}?>>Magnetico</option>
                                                                                <option value="Pulsador"<?php if ($regaloutorizado == "Pulsador") {echo "selected";}?>>Pulsador</option>
                                                                            </select>
                                                                    </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnprospecto">CLOSING PACK:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                            <select class="form-control input-sm" name="lblclosingpack" id="lblclosingpack">
        														<option value="" disabled selected>Seleccione</option>
        														<option value="Ninguno">Ninguno</option>
        														<option value="ZeroVision">ZeroVision</option>
        														<option value="3Magnetico">3Magnetico</option>
        														<option value="2Magnetico">2Magnetico</option>
        														<option value="1Magnetico">1Magnetico</option>
        														<option value="1FOTO">1FOTO</option>
        														<option value="1MG+1FOTO">1MG+1FOTO</option>
        														<option value="1OPDI">1OPDI</option>
        													</select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                

                                                                        <input type="hidden" id="NombresScoring" name="NombresScoring" value="<?php echo $NombresScoring;?>"/>
                                                                        <input type="hidden" id="ApellidoPaternoScoring" name="ApellidoPaternoScoring" value="<?php echo $ApellidoPaternoScoring;?>"/>
                                                                        <input type="hidden" id="ApellidoMaternoScoring" name="ApellidoMaternoScoring" value="<?php echo $ApellidoMaternoScoring;?>"/>
                                                                        <input type="hidden" id="TipoDocumentoScoring" name="TipoDocumentoScoring" value="<?php echo $TipoDocumentoScoring;?>"/>
                                                                        <input type="hidden" class="form-control input-sm" name="lbldocumentoscoring" id="lbldocumentoscoring" maxlength="11" onkeypress="return event.charCode >= 48 && event.charCode <= 57" value="<?php echo $DocumentoScoring;?>"  readonly="readonly" >
                                                
                                                
                                           </div>   
                                        
            </div>
            <!-- /.box-body -->

          </div>
                                                          

                                                                   
                                                                   <div class="box box-custom">
            <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
               <h5>INFORMACION DE AGENDA</h5>

              <div class="box-tools pull-right">
                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                </button>
                
              </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
                                          <div class="form-horizontal">
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">INSTALADOX:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                    <select class="form-control input-sm" name="lblinstaladox" id="lblinstaladox" disabled="disabled">
                                                                                <option value="">Seleccione</option>
                                                                                 <option value="TEC"<?php if ($instaladox == "TEC") {echo "selected";}?>>TEC</option>
                                                                                <option value="DEL"<?php if ($instaladox == "DEL") {echo "selected";}?>>DEL</option>
                                                                            </select>
                                                                            
                                                                            <input id="lblidagenda" name="lblidagenda" value="<?php echo $idagenda;?>" hidden="">
                                                                            <input id="lblIdAgenRepor" name="lblIdAgenRepor" value="<?php echo $IdAgenRepor;?>" hidden="">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbltecnico">TÉCNICO: <span style="color:red"> * </span></label>
                                                            <div class="col-sm-8 col-xs-8">
                                                           <select name="lbltecnico" id="lbltecnico" class="form-control cbxtecnico input-sm" style="width: 100%;" disabled="disabled">
                                                                                <?php echo $html_tecnico;?>
                                                                            </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="fechainst">F.INSTALACIÓN:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                   <div class="input-group" id="fi" >
                                                                                <div class="input-group-addon input-sm">
                                                                                    <i class="fa fa-calendar"></i>
                                                                                </div>
                                                                                <input type="text" class="form-control pull-right input-sm" id="fechainst" value="<?php echo $fechainstalacionver;?>"  name="lblfinstalacion" data-inputmask="'alias': 'dd/mm/yyyy'" disabled="disabled" data-mask>
                                                                            </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblhinstalacion">H.INSTALACIÓN:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                    <div class="bootstrap-timepicker timepicker">
                                                                             <div class="input-group">
                                                                                 <input type="text" class="form-control input-sm" placeholder="12:00 AM" name="lblhinstalacion" id="horainst" value="<?php echo $horainstalacionver;?>" disabled="disabled">
                                                                                    <div class="input-group-addon input-sm">
                                                                                        <i class="fa fa-clock-o"></i>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div> 

                                                <div class="form-group ocultar" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblrepercucion">REPERCUCIÓN:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                   <select class="form-control input-sm" name="lblrepercucion" id="lblrepercucion">
                                                    <option value="">Seleccione</option>
         <option value="Ninguno"<?php if ($repercucion== "Ninguno") {echo "selected";}?>>Ninguno</option>
         <option value="Noventa"<?php if ($repercucion== "Noventa") {echo "selected";}?>>No venta</option>
        <option value="Clienteausente"<?php if ($repercucion== "Clienteausente") {echo "selected";}?>>Cliente ausente</option>
       <option value="Nodeseaelservicio"<?php if ($repercucion== "Nodeseaelservicio") {echo "selected";}?>>No desea el servicio</option>
       <option value="Lugarenobras"<?php if ($repercucion== "Lugarenobras") {echo "selected";}?>>Lugar en obras</option>
       <option value="Nodisponedetiempo"<?php if ($repercucion== "Nodisponedetiempo") {echo "selected";}?>>No dispone de tiempo</option>
       <option value="Cobertura"<?php if ($repercucion== "Cobertura") {echo "selected";}?>>Cobertura</option>
       <option value="MotivosEconomicos"<?php if ($repercucion== "MotivosEconomicos") {echo "selected";}?>>Motivos Económicos</option>
       <option value="MotivosPersonales"<?php if ($repercucion== "MotivosPersonales") {echo "selected";}?>>Motivos Personales</option>
       <option value="RetrasoTecnico"<?php if ($repercucion== "RetrasoTecnico") {echo "selected";}?>>Retraso Técnico</option>

                                                                            </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcosto">REPERCUSIÓN COSTO:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                <select class="form-control input-sm" name="lblcosto" id="lblcosto">
                                                                        <option value="">Seleccione</option>
                                                                         <option value="Ninguno"<?php if ($costo== "Ninguno") {echo "selected";}?> disabled="disabled" >Ninguno</option>
                                                                         <option value="SI"<?php if ($costo== "SI") {echo "selected";}?> >SI</option>
                                                                         <option value="NO"<?php  if ($costo== "NO") {echo "selected";}?>>NO</option>
                                                                 </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="form-group" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblrepercucion">COMENTARIO:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                   <textarea class="form-control input-sm" name="lblcomentarioagenda" id="lblcomentarioagenda" maxlength="550" rows="3" style="resize:none" placeholder="Ingresar..."><?php echo $comentarioagenda;?></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcosto">LOG CAMBIOS:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                               <a class="btn btn-danger btn-sm"  href="#" data-toggle="modal" id="logcambios" data-target="#modal-default"><i class="fa fa-pencil-square-o"></i> Log Cambios</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                         <div class="form-group ocultar" style="margin-bottom: 0px;">
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblrepercucion">MOTIVO INVIABLE:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                                   <select class="form-control input-sm" name="lblinviable" id="lblinviable">
                                                    <option value="">Seleccione</option>
         <option value="SEÑALES OPTIMAS/RADIO FRECUENCIA"<?php if (utf8_encode($motivoinviable)== "SEÑALES OPTIMAS/RADIO FRECUENCIA") {echo "selected";}?>>SEÑALES OPTIMAS/RADIO FRECUENCIA</option>
         <option value="COBERTURA"<?php if ($motivoinviable== "COBERTURA") {echo "selected";}?>>COBERTURA</option>
   
                                                                            </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-6 col-md-6">
                                                        <div class="form-group">
                                                            <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcosto">MOTIVO CANCELADO:</label>
                                                            <div class="col-sm-8 col-xs-8">
                                                               <textarea class="form-control input-sm" name="lblcancelado" id="lblcancelado" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $motivocancelado;?></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                
                                            </div>        
            
                                    </div>
                                    <!-- /.box-body -->
                        
                                  </div>
                                                               
                                                            

                                                                   <div class="box box-custom <?php if($estadoventa=='InstaladaTEC'){}else{ echo 'ocultar';}?>">
            <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
              <h5>INFORMACION DE FACTURACIÓN</h5>

              <div class="box-tools pull-right">
                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                </button>
                
              </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
          <table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">
              
                                                                  <?php  
                                                                   if($estadoventa=='InstaladaDEL' || $estadoventa=='InstaladaTEC' || $estadoventa=='IncidenciaAuditoria' || $estadoventa=='Instalada' || $estadoventa=='IncidenciaGestCorreo' || $estadoventa=='IncidenciaGestValija' || $estadoventa=='Facturada' || $estadoventa=='PorFacturar' || $estadoventa=='DocEnvi'  || $estadoventa=='Incidencia' || $estadoventa=='NoDoc'){
                                                                   ?>
                                                                    <tr>
                                                                        <td style="width:15%;font-size: 12px;"><span class="ocultar">PAGO:</span></td>
                                                                        <td style="width:25%">
                                                                        <a class="btn btn-danger btn-social btn-sm ocultar"  data-toggle="modal" id="btnrealizarpago" data-target="#modal-mediodepago"> <i class="fa fa-credit-card"></i> Realizar Pago </a>
                                                                        <a class="btn btn-nuevo btn-social btn-sm"  data-toggle="modal" id="btnenviarcorreoafiliar" data-target="#modal-enviarcorreoafiliar"> <i class="fa fa-envelope-o"></i> Enviar Afiliacion </a>
                                                                        </td>
                                                                        <td style="width:10%"></td>
                                                                        
                                                                        <td colspan="3" style="width:42%">
                                                                        
                                                                            <label class="label label-danger" style="font-size:12px">ESTADO DE AFILIACION</label>
                                                                            <?php if(isset($idnmdp) && !empty($idnmdp) && ($tipo!='visa' || $tipo!='mastercard')){?>
                                                                            <a class="label label-default"  data-toggle="modal" data-target="#modal-mdpafiliacion" id="btneditaafi" style="font-size:12px"> <?php if($estadoafiliacionmdp=='ENPROCESO'){echo 'ENPROCESO';}else if($estadoafiliacionmdp=='AFILIADO'){echo 'AFILIADO';}else if($estadoafiliacionmdp=='RECHAZADO'){echo "RECHAZADO:".$motivomdp;}else{echo 'PENDIENTE';}?></a>
                                                                            <?php }else{?>
                                                                            <label class="label label-default" style="font-size:12px"><?php if($estadoafiliacion=="NOREGISTRADO"){ echo "RECHAZADO:".$ACTION_DESCRIPTION;}else if($estadoafiliacion=='REGISTRADO'){echo 'AFILIADO';}else if($estadoafiliacionmdp=='ENPROCESO'){echo 'ENPROCESO';}else if($estadoafiliacionmdp=='AFILIADO'){echo 'AFILIADO';}else if($estadoafiliacionmdp=='RECHAZADO'){echo "RECHAZADO:".$motivomdp;}else{echo 'PENDIENTE';}?></label>
                                                                            <?php }?>
                                                                            <input type="hidden" id="idafiliacion"  value="<?php echo $idnmdp;?>"/>
                                                                            <input type="hidden" id="statusafiliacion"  value="<?php echo $estadoafiliacionmdp;?>"/>
                                                                            <input type="hidden" id="correoenviomdp"  value="<?php echo $correoenviomdp;?>"/>
                                                                            <?php if(isset($card) && !empty($card)){?>
                                                                            <label class="label label-default" style="font-size:12px"><?php echo $tipocuenta.' '.$card;?></label>
                                                                            <?php }
                                                                            
                                                                        ?>
                                                                        </td>
                                                                    </tr>
                                                                     <tr class="espacio"></tr>
                                                                     <?php }?>                
                                                                    <tr>
                                                                        <td style="width:15%;font-size: 12px">MOTIVO INCIDENCIA:</td>
                                                                        <td colspan="7" style="width:77%"><textarea class="form-control input-sm" name="lblmotivoincidencia" id="lblmotivoincidencia" rows="1" style="resize:none" placeholder="Ingresar..." disabled="disabled"><?php echo $factmotivoincidencia;?></textarea></td>
                                                                    </tr>
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:15%;font-size: 12px">FECHA RECEPCION DOC.:</td>
                                                                        <td style="width:25%"><div class="input-group">
                                                                                <div class="input-group-addon input-sm">
                                                                                    <i class="fa fa-calendar"></i>
                                                                                </div>
                                                                                <input type="text" class="form-control pull-right input-sm" id="lblfecharecpciondoc"  name="lblfecharecpciondoc" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask value="<?php echo $factfecharecepciondoc;?>" disabled="disabled" >
                                                                            </div>
                                                                        </td>
                                                                        <td style="width:10%"></td>
                                                                        <td style="width:15%;font-size: 12px">FECHA DE FACTURACIÓN: <span style="font-size: 12px; color:red ">(*)</span></td>
                                                                        <td style="width:2%"></td>
                                                                        <td style="width:25%"><div class="input-group">
                                                                                <div class="input-group-addon input-sm">
                                                                                    <i class="fa fa-calendar"></i>
                                                                                </div>
                                                                                <input type="text" class="form-control pull-right input-sm" id="lblfechafacturacion"  name="lblfechafacturacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask value="<?php echo $factfechafacturacion;?>" disabled="disabled" />
                                                                            </div></td>
                                                                    </tr>
                </table>
                
                <table cellspacing="0"  style="width:100%;border-collapse: separate;padding: 20px">

                  
                                                                     
                                                                    <tr>
                                                                        <td style="font-size: 12px; color:red ">MOTIVOS DE INCIDENCIA (*):</td>
                                                                    </tr>
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:8%;font-size: 12px">DOC. ORIGINAL:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactdocoriginal" id="lblfactdocoriginal" value="<?php echo $factdocoriginal;?>" disabled="disabled" /></td>
                                                                        <td style="width:8%"></td>
                                                                        <td style="width:8%;font-size: 12px">FALTA DNI:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactdni" id="lblfactdni" value="<?php echo $factdni;?>" disabled="disabled" /></td>
                                                                        <td style="width:8%"></td>
                                                                        <td style="width:8%;font-size: 12px">REHACER CTO:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactrehacercto" id="lblfactrehacercto" value="<?php echo $factrehacercto;?>" disabled="disabled" /></td>
                                                                    </tr>
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:8%;font-size: 12px">SEGMENTACIÓN:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactsegmentacion" id="lblfactsegmentacion" value="<?php echo $factsegmentacion;?>" disabled="disabled" /></td>
                                                                        <td style="width:8%"></td>
                                                                        <td style="width:8%;font-size: 12px">ELEMENTOS CTO PS:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactelementosctops" id="lblfactelementosctops" value="<?php echo $factelementosctops;?>" disabled="disabled" /></td>
                                                                        <td style="width:8%"></td>
                                                                        <td style="width:8%;font-size: 12px">AFILIACION:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactafiliacion" id="lblfactafiliacion" value="<?php echo $factafiliacion;?>" disabled="disabled" /></td>
                                                                    </tr>
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:8%;font-size: 12px">PAGO:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactpago" id="lblfactpago" value="<?php echo $factpago;?>" disabled="disabled" /></td>   
                                                                        <td style="width:8%"></td>
                                                                        <td style="width:8%;font-size: 12px">DOC PAI:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactdocpai" id="lblfactdocpai" value="<?php echo $factdocpai;?>" disabled="disabled" /></td>
                                                                        <td style="width:8%"></td>
                                                                        <td style="width:8%;font-size: 12px">PROSPECTO/NRO GUIA:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactprospecto_nroguia" id="lblfactprospecto_nroguia" value="<?php echo $factprospecto_nroguia;?>" disabled="disabled" /></td>
                                                                    </tr>
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:8%;font-size: 12px">AUTORIZA:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactautoriza" id="lblfactautoriza" value="<?php echo $factautoriza;?>" disabled="disabled" /></td>
                                                                        <td style="width:8%"></td>
                                                                        <td style="width:8%;font-size: 12px">FALTA DOC (P.A./CTO):</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactfaltadoc" id="lblfactfaltadoc" value="<?php echo $factfaltadoc;?>" disabled="disabled" /></td>
                                                                        <td style="width:8%"></td>
                                                                        <td style="width:8%;font-size: 12px">FUERA DE HORA:</td>
                                                                        <td style="width:6%"><input type="text" class="form-control input-sm" name="lblfactfuerahora" id="lblfactfuerahora" value="<?php echo $factfuerahora;?>" disabled="disabled" /></td>
                                                                    </tr>
                    </table> 
            </div>
            <!-- /.box-body -->
       
          </div>
            
                                                            </form>
                                
            
                                
           
                            </div>
                            
                            

                        
                        
                         <div class="col-md-2"></div>

                        
                    </div>
                    
                    
                       <div class="modal fade" id="modal-default">

                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <div class="modal-header modal-header-danger">
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                <h4>GESTIONES DE AGENDAMIENTO</h4>
                            </div>
                            <div class="modal-body" id="vistaboy">
                                
                                  <div id="myGrid"  style="height: 100%" class="ag-theme-fresh"></div>
                                <div  id="ningunresultado"></div>
                   
              </div> 
                                
                              <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
             
              </div>                  
                            </div>
                            


                        </div>  
                        <!-- /.modal-content -->

                    </div>
                    <!-- /.modal-dialog -->
                </div>
                <!-- /.modal -->
                    

<div class="modal fade" id="modal-enviarcorreoafiliar" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header modal-header-danger">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-enviocorreo-title">ENVIAR A AFILIAR</h4>
                    </div>
                    <div class="modal-body">
                        <form id="form_enviocorreo" methodo="POST">
                            <div class="form-group">
                            <label for="exampleInputEmail1">CORREO:</label>
                            <input type="email" class="form-control" id="InputCorreo" placeholder="Escribir correo">
                            </div>
                        </form>
                    </div>
                    <div class="modal-footer">
                            <button type="button" class="btn btn-default" id="ModEnviarCerrar" data-dismiss="modal">Cerrar</button>
                            <button type="button" class="btn btn-danger" id="ModEnviar">Enviar</button>
                    </div>
                </div>
            </div>
        </div>
                    
         
                </section>
                <!-- /.content -->
                
                
                
                
                
             

<?php include 'modalpassword.php';?>




            </div>
            <!-- /.content-wrapper -->
           


            <div class="control-sidebar-bg"></div>
        </div>
        <!-- ./wrapper -->
        
        
                
                
                
        <!-- jQuery v1.11 -->
  
        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>

        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>
        $.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>

       <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>
        
        

  
         <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
        
        
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>

       
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
       <!-- bootstrap time picker -->
       <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>
     
         <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>        
        
        <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.19.2/moment.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.19.2/locale/es.js"></script>
       

 <script>



    var columnDefs = [
                 {headerName: 'FechaHoraREG', field: 'FechaHoraREG', width: 140},
        {headerName: 'FechaInst', field: 'FechaInst', width: 130, pinned: 'left'},
        {headerName: 'HoraInst', field: 'HoraInst', width: 105, pinned: 'left'},
        {headerName: 'InstaladoX', field: 'InstaladoX', width: 100},
        {headerName: 'MatriculaTec', field: 'MatriculaTec', width: 110},
        {headerName: 'Repercusion', field: 'Repercusion', width: 130},
{headerName: 'R.Costo', field: 'RepercusionCosto', width: 90},
{headerName: 'MotivoInviable', field: 'MotivoInviable', width: 150},
{headerName: 'Comentario', field: 'Comentario', width: 200},
{headerName: 'EstadoVenta', field: 'EstadoVenta', width: 120},
{headerName: 'NContrato', field: 'NContrato', width: 120},
{headerName: 'Gestor', field: 'GestorAgenda', width: 120}
    ];

    var gridOptions = {
        columnDefs: columnDefs,
        rowData: null,
        enableFilter: true,
        enableColResize: true,
        localeText: {
            // for filter panel
            page: 'página',
            more: 'Más',
            to: 'a',
            of: 'de',
            next: 'Siguiente',
            last: 'Último',
            first: 'Primero',
            previous: 'Anterior',
            loadingOoo: 'Cargando...',
            // for set filter
            selectAll: 'Seleccionar todo',
            searchOoo: 'Buscando...',
            blanks: 'Espacios en blanco',
            // for number filter and text filter
            filterOoo: 'Filtrar...',
            applyFilter: 'Aplicar Filtro',
            // for number filter
            equals: 'Igual',
            notEqual: 'No es igual',
            lessThanOrEqual: 'Menor o igual',
            greaterThanOrEqual: 'Mayor que o igual',
            inRange: 'En el rango',
            lessThan: 'Menos que',
            greaterThan: 'Mas grande que',
            // for text filter
            contains: 'Contiene',
            startsWith: 'Comienza con',
            endsWith: 'Termina con',
            notContains:'No contiene',
            // the header of the default group column
            group: 'Grupo',
            // tool panel
            columns: 'columnas',
            rowGroupColumns: 'Grupo columnas',
            rowGroupColumnsEmptyMessage: 'No hay resultado',
            valueColumns: 'Columna de valor',
            pivotMode: 'Modo pivote',
            groups: 'grupos',
            values: 'valor',
            pivots: 'pivote',
            valueColumnsEmptyMessage: 'No hay resultado',
            pivotColumnsEmptyMessage: 'No hay resultado',
            // other
            noRowsToShow: '<div class="callout callout-danger">\n\
<span class="pull-left">\n\
<img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
</span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
<strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
<p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
<br></div>'


            ,
            // enterprise menu
            pinColumn: 'Aclar columna',
            valueAggregation: 'Agregar valor',
            autosizeThiscolumn: 'Auto tamaño esta columna ',
            autosizeAllColumns: 'Auto tamaño todas columnas',
            groupBy: 'Agrupar',
            ungroupBy: 'Agrupar uno',
            resetColumns: 'Restaurar Columnas',
            expandAll: 'expandir todo',
            collapseAll: 'desplegar todo',
            toolPanel: 'Panel de Heramientas',
            export: 'Exportar',
            csvExport: 'Exportar CSV',
            excelExport: 'Exportar Excel',
            // enterprise menu pinning
            pinLeft: 'Anclar a derecha',
            pinRight: 'Anclar a izquierda',
            noPin: 'Desanclar',
            // enterprise menu aggregation and status panel
            sum: 'Sumar',
            min: 'Minimo',
            max: 'Maximo',
            first: 'Primero',
                    last: 'Ultimo',
                    none: 'Nada',
            count: 'Contador',
            average: 'Promedio',
            // standard menu
            copy: 'Copiar',
            copyWithHeaders: 'Copiar Cabecera',
            ctrlC: 'Ctrl+C',
            paste: 'Pegar',
            ctrlV: 'Ctrl+V'
        },
        enableSorting: true
    };




    function onFilterChanged(value) {
        gridOptions.api.setQuickFilter(value);
    }
    function listar() {
     var idventa=$("#idVenta").val();
        $.ajax({
            url: 'ajax/findDataHisAgenda.php?idventa='+idventa,
            success: function (data) {

                if (data == 1) {
                    var gridDiv = document.querySelector('#myGrid');
                    new agGrid.Grid(gridDiv, gridOptions);

                    agGrid.simpleHttpRequest({url: 'ajax/selectListarHistAgenda.php?idventa='+idventa}).then(function (data) {

                        gridOptions.api.setRowData(data);
                    });
                    $('#vistaboy').height(function (index, height) {

                        return $(window).height() * 35 / 100;
                    });
                   
                } else {

                    $("#ningunresultado").html(data);

                    var gridDiv = document.querySelector('#myGrid');
                    new agGrid.Grid(gridDiv, gridOptions);

                    agGrid.simpleHttpRequest({url: 'ajax/selectListarHistAgenda.php?idventa='+idventa}).then(function (data) {

                        gridOptions.api.setRowData(data);
                    });



                    $('#myGrid').hide("fast");

                }





            }
        });
    }
     var refresh = function () {
var idventa=$("#idVenta").val();
        $.ajax({
            url: 'ajax/findDataHisAgenda.php?idventa='+idventa,
            success: function (data) {

                if (data == 1) {

                    var gridDiv = document.querySelector('#myGrid');
                    agGrid.simpleHttpRequest({url: 'ajax/selectListarHistAgenda.php?idventa='+idventa}).then(function (data) {
                        gridOptions.api.setRowData(data);
                    });
                    $('#vistaboy').height(function (index, height) {

                        return $(window).height() * 35 / 100;
                    });
                    $("#ningunresultado").hide("fast");
                    $('#myGrid').show(200);
                } else {

                    $("#ningunresultado").html(data);
                    $('#myGrid').hide("fast");

                }





            }
        });

    }

// setup the grid after the page has finished loading
    document.addEventListener('DOMContentLoaded', function () {

        listar();

    });
    


   


    </script>

         <script>
            $(function () {
                
                $("#lbldc").change(function () {
           $("#lbldc option:selected").each(function () {
           var lbldc = $(this).val();
            $.post("./ajax/selectJefeVenta.php", { lbldc: lbldc }, function(data){
                $("#lbljefeventa").html(data);
            });            
        });

   });


                $("#lblinstaladox").change(function () {
           $("#lblinstaladox option:selected").each(function () {
           var lblinstaladox= $(this).val();
            $.post("./ajax/selectTecnico.php", { lblinstaladox: lblinstaladox }, function(data){
                $("#lbltecnico").html(data);
            });            
        });

   });
   
                     $("#lblestadoventa").change(function () {
                    var condiciones = $("#lblestadoventa").val();
                    bloquear(condiciones);

                   
                        
                });

                 
                $('#lblmatricula').on('keyup', function () {
                    var dato = $('#lblmatricula').val();
                    var url = 'ajax/findMatricula.php';
                    $.ajax({
                        type: 'POST',
                        url: url,
                        data: 'dato=' + dato,
                        success: function (datos) {
                            $('.mensajematricula').html(datos);
                        }
                    });
                    return false;
                });
               
               $("#lblmatricula").autocomplete({
                    source: "./ajax/selectMatricula.php",
                    minLength: 2,
                    select: function (event, ui) {
                        event.preventDefault();
                        $('#lblidusuario').val(ui.item.idusuario);
                        $('#lblmatricula').val(ui.item.matricula);
                        $('#lblnombcomercial').val(ui.item.comercial);
//                        $('#lbldc').val(ui.item.dc);
//                        $('#lbljefeventa').val(ui.item.jefe);
                     
                    }
                });

                $("#lblmatricula").on("keydown", function (event) {
                    if (event.keyCode == $.ui.keyCode.LEFT || event.keyCode == $.ui.keyCode.RIGHT || event.keyCode == $.ui.keyCode.UP || event.keyCode == $.ui.keyCode.DOWN || event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE)
                    {
                        $('#lblidusuario').val("");
                        $('#lblmatricula').val("");
                        $('#lblnombcomercial').val("");
//                        $('#lbldc').val("");
//                        $('#lbljefeventa').val("");

                    }
                    if (event.keyCode == $.ui.keyCode.DELETE) {
                        $('#lblmatricula').val("");
                        $('#lblidusuario').val("");
                        $('#lblnombcomercial').val("");
//                        $('#lbldc').val("");
//                        $('#lbljefeventa').val("");
                    }
                });

            });


        </script>

        <script>
                                                                            $(document).ready(function () {
                                                                                
                                                                               var estadoVenta = $("#estadoVenta").val();
                                                                                bloquear(estadoVenta);

                                                                                var alterClass = function () {
                                                                                    var ww = document.body.clientWidth;
                                                                                    if (ww < 767) {
                                                                                        $('body').removeClass('sidebar-collapse');
                                                                                    } else if (ww >= 768) {
                                                                                        $('body').addClass('sidebar-collapse');
                                                                                    }
                                                                                    ;
                                                                                };

                                                                                $(window).resize(function () {
                                                                                    alterClass();
                                                                                });
                                                                                //Fire it when the page first loads:
                                                                                alterClass();


                                                                                $('#btnGuardarEditarVenta').click(function () {
                                                                                    var gestor=$("#matriculaUsuario").val();
                                                                                    var catgventa=$('#lblcategoria').val();
                                                                                    var ediventa=$("#idVenta").val();;
                                                                                    var matriculacomercial=$("#Matricula").val();
                                                                                    var cccomercial=$("#Dc").val();
                                                                                    var matriculajefe=$("#matJefe").val();
                                                                                    var tcgestor=$("#TcGestor").val();
 //Algunas variables por default de alertify
alertify.defaults.theme.ok = "btn btn-nuevo";
alertify.defaults.theme.cancel = "btn btn-danger";

var lastX,lastY;
    alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea guardar los cambios que ha realizado?', function(){ if (validaForm()) {
                        // Primero validará el formulario.

                        var datos = $('#frmEditarVenta').serialize();
                        $.ajax({
                            type: 'POST',
                            url: 'ajax/updateAttec.php',
                            data: "lblidventa="+ediventa+"&gestor="+gestor+"&matriculacomercial="+matriculacomercial+"&cccomercial="+cccomercial+"&matriculajefe="+matriculajefe+"&tcgestor="+tcgestor+"&"+datos,
                            success: function (r) {
                                if (r == 1) {
                                     alertify.success("Modificado con exito");
                                     enviarEncuesta();
                                        Swal.fire({
                                            title: 'Modificado con exito',
                                            icon: 'success',
                                            showCancelButton: false,
                                            allowOutsideClick: false,
                                            allowEscapeKey: false,                                            
                                            confirmButtonColor: '#3085d6',
                                            confirmButtonText: 'OK'
                                        }).then((result) => {
                                            if (result.isConfirmed) {
                                                location.reload();
                                            }
                                        });
                                        
                                }
                                else if (r == 2) {
                                    alertify.warning("Contrato Duplicado");
                                }
                                else if (r == 0) {
                                    alertify.warning("No se realizaron modificaciones");
                                }
                                else {
                                    alertify.error("Fallo el server");
                                }
                            }
                        });
                    } }
                , function(){ alertify.error('No se han guardado los cambios')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
        
            lastX = window.scrollX;
        lastY = window.scrollY;
      },
      'onfocus':function(){
        window.scrollTo(lastX, lastY);
      }  }).show(); 
                                                                                    
                                                
                                                                                
                                                                                });
                                                                                
                                                                                $('.selectdistrito').select2({
                                                                                    placeholder: 'Seleccione Distrito - Provincia',
                                                                                    allowClear: true,
                                                                                    language: {
                                                                                        errorLoading: function () {
                                                                                            return "La carga falló";
                                                                                        },
                                                                                        noResults: function () {
                                                                                            return "No hay resultado";
                                                                                        },
                                                                                        searching: function () {

                                                                                            return "Buscando..";
                                                                                        }
                                                                                    },
                                                                                    ajax: {
                                                                                        url: 'ajax/selectDistrito.php',
                                                                                        dataType: 'json',
                                                                                        delay: 250,
                                                                                        processResults: function (data) {
                                                                                            return {
                                                                                                results: data
                                                                                            };
                                                                                        },
                                                                                        cache: true
                                                                                    }
                                                                                });
                                                                                
                                                                                
                                                                                 $('.cbxtecnico').select2({
                                                                                    placeholder: 'Seleccione',
                                                                                    allowClear: true,
                                                                                    language: {
                                                                                        errorLoading: function () {
                                                                                            return "La carga falló";
                                                                                        },
                                                                                        noResults: function () {
                                                                                            return "No hay resultado";
                                                                                        },
                                                                                        searching: function () {

                                                                                            return "Buscando..";
                                                                                        }
                                                                                    }
                                                                                });
                                                                              
                                                                              
                                                                                $('#datemask').inputmask('dd/mm/yyyy', {'placeholder': 'dd/mm/yyyy'});
                                                               
                                                                  $('#lblfecharecpciondoc').datepicker({
                                                                                    autoclose: true,
                                                                                    language: 'es',
                                                                                    firstDay: 1
                                                                                });
                                                                                  $('#lblfechafacturacion').datepicker({
                                                                                    autoclose: true,
                                                                                    language: 'es',
                                                                                    firstDay: 1
                                                                                });
                                                               
                                                                                //Money Euro
                                                                                $('[data-mask]').inputmask();
                                                                                //Date picker
                                                                                $('#fechainst').datepicker({
                                                                                    autoclose: true,
                                                                                    language: 'es',
                                                                                    firstDay: 1
                                                                                });
                                                                                //Date picker
                                                                                $('#horainst').timepicker({
defaultTime:false,                                                                                    
showInputs: true,
                                                                                     minuteStep: 1
                                                                                  
                                                                              });
                                                                              
                                                                                $('#mesano').datepicker({
                                                                                    autoclose: true,
                                                                                    language: 'en',
                                                                                    firstDay: 1, format: 'M-yyyy',
                                                                                    viewMode: "years",
                                                                                    minViewMode: "months"

                                                                                });
                                                                                
                                                                                $('#logcambios').click(function () {
                                                                                    refresh();
                                                                                });


 <?php include 'jspassword.php';?>

                                                                                               
                                        
                                                                            });
                                                                            

<?php include 'jsfuncionpassword.php';?>
                                                                             var  bloquear = function (condiciones){
                                                                           
                                                                           $('#tinviable').hide();
                        $('#lblinviable').hide();
                         $('#lblinviable').disabled=true;
                        $('#tinviableespacio').hide();
                        
                        $('#tcancelado').hide();
                        $('#lblcancelado').hide();
                         $('#lblcancelado').disabled=true;
                        $('#tcanceladoespacio').hide();
                        
                         $('#lblncontrato').attr("readonly", "readonly");
                        
                                                                           
                    if (condiciones == "Inviable") {
                        $('#tinviable').show();
                        $('#lblinviable').show();
                        $('#lblinviable').show();
                        $('#lblinviable').disabled=false;
                        $('#tinviableespacio').show();
                        $('#lblncontrato').removeAttr("readonly");
                        
                    }else if(condiciones=="Cancelado"){
                        $('#tcancelado').show();
                        $('#lblcancelado').show();
                        $('#lblcancelado').disabled=false;
                        $('#tcanceladoespacio').show();
                    
                    }  else if(condiciones=="Instalada" || condiciones=="InstaladaDEL" || condiciones=="InstaladaTEC"){
                      
                       $('#lblncontrato').removeAttr("readonly");
                    
                    }   
                    else {
                        $('#tinviable').hide();
                        $('#lblinviable').hide();
                         $('#lblinviable').disabled=true;
                        $('#tinviableespacio').hide();
                        
                        $('#tcancelado').hide();
                        $('#lblcancelado').hide();
                         $('#lblcancelado').disabled=true;
                        $('#tcanceladoespacio').hide();
                        
                        $('#lblncontrato').attr("readonly", "readonly");
                       
                    }
    
    }
                

function validaForm() {


                // Campos de texto
                if ($("#frmEditarVenta #lblmatricula").val() == "") {
                    alertify.warning("Por favor ingresar la Matricula correspondiente");
                    $("#frmEditarVenta #lblmatricula").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmEditarVenta #lblnombcomercial").val() == "") {
                    alertify.warning("Por favor ingresar la Matricula valida");
                    $("#frmEditarVenta #lblmatricula").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                 if ($("#frmEditarVenta #lbldc").val() == "" || $("#frmEditarVenta #lbldc").val() == "Seleccione" ) {
                    alertify.warning("Por favor ingresar CC correcto");
                    $("#frmEditarVenta #lbldc").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
 
                if ($("#frmEditarVenta #lbljefeventa").val() == "" || $("#frmEditarVenta #lbljefeventa").val() == "No se encontraron resultado") {
                    alertify.warning("Por favor revisar Jefe de Estructura Comercial");
                    $("#frmEditarVenta #lbljefeventa").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }

                
                if ($("#frmEditarVenta #lblestadoventa").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Estado de Venta correcto");
                    $("#frmEditarVenta #lblestadoventa").focus();
                    return false;
                }

                
                    if ($("#frmEditarVenta #lblestadoventa").val() == "Cancelada") {
                      if ($("#frmEditarVenta #lblcomentarioagenda").val() == "") {
                             alertify.warning("Por favor ingresar comentario");
                             $("#frmEditarVenta #lblcomentarioagenda").focus();
                            return false;
                        }
                        
                        if ($("#frmEditarVenta #lblrepercucion").val() == "" || $("#frmEditarVenta #lblrepercucion").val() == "Seleccione") {
                             alertify.warning("Por favor ingresar Repercucion correspondiente");
                             $("#frmEditarVenta #lblrepercucion").focus();
                            return false;
                        }
                        
                        
                        if ($("#frmEditarVenta #lblcosto").val() == "" || $("#frmEditarVenta #lblcosto").val() == "Seleccione") {
                             alertify.warning("Por favor ingresar Costo Repercucion (SI/NO) ");
                             $("#frmEditarVenta #lblcosto").focus();
                            return false;
                        }

                    }
                    
                    if ($('#frmEditarVenta #lblestadoventa').val() == 'Instalada' || $('#frmEditarVenta #lblestadoventa').val() == 'InstaladaDEL' || $('#frmEditarVenta #lblestadoventa').val() == 'InstaladaTEC'){
                        if($('#frmEditarVenta #lblncontrato').val() == ''){
                            alertify.warning("Por favor ingresar NContrato");
                            $('#frmEditarVenta #lblncontrato').focus();
                            return false;
                        }
                    }

             if ($("#frmEditarVenta #lblestadoventa").val() == "Inviable") {
                    if ($("#frmEditarVenta #lblcomentarioagenda").val() == "") {
                        alertify.warning("Por favor ingresar comentario");
                        $("#frmEditarVenta #lblcomentarioagenda").focus();
                        return false;
                    }

if ($("#frmEditarVenta #lblrepercucion").val() == "" || $("#frmEditarVenta #lblrepercucion").val() == "Seleccione") {
 alertify.warning("Por favor ingresar Repercucion correspondiente");
 $("#frmEditarVenta #lblrepercucion").focus();
return false;
}


if ($("#frmEditarVenta #lblcosto").val() == "" || $("#frmEditarVenta #lblcosto").val() == "Seleccione") {
 alertify.warning("Por favor ingresar Costo Repercucion (SI/NO) ");
 $("#frmEditarVenta #lblcosto").focus();
return false;
}

if ($("#frmEditarVenta #lblinviable").val() == "" || $("#frmEditarVenta #lblinviable").val() == "Seleccione") {
 alertify.warning("Por favor ingresar Inviable correspondiente");
 $("#frmEditarVenta #lblinviable").focus();
return false;
}

}        





                if ($("#frmEditarVenta #lbltipoventa").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Recurso correcto");
                    $("#frmEditarVenta #lbltipoventa").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblsegmento").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Segmento correcto");
                    $("#frmEditarVenta #lblsegmento").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblmesesautorizados").val() == "") {
                    alertify.warning("Por favor ingresar MesAutorizado.Si no tuviese coloque: 0");
                    $("#frmEditarVenta #lblmesesautorizados").focus();
                    return false;
                }

                if ($("#frmEditarVenta #lblnombcliente").val() == "") {
                    alertify.warning("Por favor ingresar Nombre del Cliente");
                    $("#frmEditarVenta #lblnombcliente").focus();
                    return false;
                }
                /*
                if ($("#frmEditarVenta #lblcorreo").val() == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test($("#frmEditarVenta #lblcorreo").val())) {
                    alertify.warning("Por favor ingresar correo válido");
                    $("#frmEditarVenta #lblcorreo").focus();
                    return false;
                }
            */    
                if ($("#frmEditarVenta #lbldireccion").val() == "") {
                    alertify.warning("Por favor ingresar la Direccion del Cliente");
                    $("#frmEditarVenta #lbldireccion").focus();
                    return false;
                }

                if ($("#frmEditarVenta #lbldistrito").val() =="") {
                    alertify.warning("Por favor ingresar Distrito correcto");
                    $("#frmEditarVenta #lbldistrito").select2('open');
                    return false;
                }
                
                 
                if ($("#frmEditarVenta #lblmovil").val() == "") {
                    alertify.warning("Por favor ingresar Telefono, de caso contrario digite: 0");
                    $("#frmEditarVenta #lblmovil").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblpreciokit").val() == "") {
                    alertify.warning("Por favor ingresar Precio del KIT");
                    $("#frmEditarVenta #lblpreciokit").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lbltotalextra").val() == "") {
                    alertify.warning("Por favor ingresar Total de Extra, de caso contrario digite: 0");
                    $("#frmEditarVenta #lbltotalextra").focus();
                    return false;
                }

                if ($("#frmEditarVenta #lblresumenventa").val() == "") {
                    alertify.warning("Por favor ingresar Resumen de Venta");
                    $("#frmEditarVenta #lblresumenventa").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblformadepago").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Forma de Pago");
                    $("#frmEditarVenta #lblformadepago").focus();
                    return false;
                }
                if ($("#frmEditarVenta #mesano").val() == "") {
                    alertify.warning("Por favor ingresar 590");
                    $("#frmEditarVenta #mesano").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblPAI").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar PAI");
                    $("#frmEditarVenta #lblPAI").focus();
                    return false;
                }

                return true; 
            }

                                                  
                                                                            var calcDataTableHeight = function () {
                                                                                return $(window).height() * 65 / 100;
                                                                            };

                                                                  
                                                                            function filterFloat(evt, input) {
                                                                                // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
                                                                                var key = window.Event ? evt.which : evt.keyCode;
                                                                                var chark = String.fromCharCode(key);
                                                                                var tempValue = input.value + chark;
                                                                                if (key >= 48 && key <= 57) {
                                                                                    if (filter(tempValue) === false) {
                                                                                        return false;
                                                                                    } else {
                                                                                        return true;
                                                                                    }
                                                                                } else {
                                                                                    if (key == 8 || key == 13 || key == 0) {
                                                                                        return true;
                                                                                    } else if (key == 46) {
                                                                                        if (filter(tempValue) === false) {
                                                                                            return false;
                                                                                        } else {
                                                                                            return true;
                                                                                        }
                                                                                    } else {
                                                                                        return false;
                                                                                    }
                                                                                }
                                                                            }

                                                                            function filter(__val__) {
                                                                                var preg = /^([0-9]+\.?[0-9]{0,2})$/;
                                                                                if (preg.test(__val__) === true) {
                                                                                    return true;
                                                                                } else {
                                                                                    return false;
                                                                                }

                                                                            }
                                                                            


                                                                            

        </script>

<script>
            $('#btnenviarcorreoafiliar').click(function(e){
                const correo=$('#lblcorreo').val();
                $('#InputCorreo').val(correo);
                var nombcliente=getCleanedString($('#lblnombcliente').val().trim());
                console.log(nombcliente);                
            });
            
            $('#ModEnviar').click(function(e){
                var arrayNombre;
                const correo=$('#InputCorreo').val();
                var contrato=$('#lblncontrato').val();
                var nombcliente=getCleanedString($('#lblnombcliente').val().trim());
                arrayNombre=nombcliente.split(' ');
                var NombresScoring=getCleanedString($('#NombresScoring').val());
                var ApellidoPaternoScoring=getCleanedString($('#ApellidoPaternoScoring').val());
                var ApellidoMaternoScoring=getCleanedString($('#ApellidoMaternoScoring').val());
                var TipoDocumentoScoring=$('#TipoDocumentoScoring').val();
                var DocumentoScoring=$('#lbldocumentoscoring').val();
                if(TipoDocumentoScoring==6 || TipoDocumentoScoring==""){
                    TipoDocumentoScoring="0";
                    DocumentoScoring="00000000";
                    if(arrayNombre.length==1){
                        NombresScoring=arrayNombre[0];
                        ApellidoPaternoScoring=" ";
                        ApellidoMaternoScoring=" ";                    
                    }else if(arrayNombre.length==2){
                        NombresScoring=arrayNombre[0];
                        ApellidoPaternoScoring=arrayNombre[1];
                        ApellidoMaternoScoring=" ";   
                    }else{
                        NombresScoring=arrayNombre[0];
                        ApellidoPaternoScoring=arrayNombre[1];
                        ApellidoMaternoScoring=arrayNombre[2];
                    }                    
                }else if(TipoDocumentoScoring==3){
                    TipoDocumentoScoring=1;
                    DocumentoScoring=DocumentoScoring.substring(3);
                }else{
                    TipoDocumentoScoring=0;
                    DocumentoScoring=DocumentoScoring.substring(3);
                }
                console.log(DocumentoScoring);
            
                var url;
                var nombrecompleto;
                if (correo == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test(correo)) {
                    Swal.fire({
                    type: 'warning',
                    title: '¡Advertencia!',
                    text: 'Verificar el correo a enviar la afiliacion',
                    })
                }else if(correo.split('@')[1].toLowerCase()=="verisure.pe"){
                    Swal.fire({
                    type: 'warning',
                    title: '¡Advertencia!',
                    text: 'Ingresar diferente al dominio de correo: @verisure.pe',
                    })
                 
                }else{

                    nombrecompleto=NombresScoring+" "+ApellidoPaternoScoring+" "+ApellidoMaternoScoring;
                    url="https://clientesverisure.com/apps/afiliacion/"+contrato+"/"+NombresScoring+"/"+ApellidoPaternoScoring+" "+ApellidoMaternoScoring+"/"+DocumentoScoring+"/"+TipoDocumentoScoring+"/"+correo;
                    var datos = {
                         correo:correo,
                         contrato:contrato,
                         nombrecompleto:encodeURIComponent(nombrecompleto),
                         url:encodeURIComponent(url)
                     }
                    $.ajax({
                        type: 'POST',
                        url: 'ajax/correoenvioAfiliacion.php',
                        data: datos,
                        dataType: "Json",
                        success: function(r) {

                            console.log(r);

                            if (r.respuesta == "exito") {
                                    swal.fire({
                                        title: 'Enviado!',
                                        text: 'El mensaje ha sido enviado exitosamente',
                                        type: 'success'
                                    });

                            } else {
                                    swal.fire({
                                        title: 'Error!',
                                        text: 'Ha ocurrido un error en el envio,intentalo más tarde',
                                        type: 'error'
                                    });
                            }
                            $('#modal-enviarcorreoafiliar').modal('hide');                            
                        }
                    });
                }             

            });
            
        function getCleanedString(cadena){
           // Definimos los caracteres que queremos eliminar
           var specialChars = "!@#$^&%*()+=-[]\/{}|:<>?,.";
        
           // Los eliminamos todos
           for (var i = 0; i < specialChars.length; i++) {
               cadena= cadena.replace(new RegExp("\\" + specialChars[i], 'gi'), '');
           }   
        
           // Lo queremos devolver limpio en minusculas
           cadena = cadena.toLowerCase();

           // Quitamos acentos y "ñ". Fijate en que va sin comillas el primer parametro
           cadena = cadena.replace(/á/gi,"a");
           cadena = cadena.replace(/é/gi,"e");
           cadena = cadena.replace(/í/gi,"i");
           cadena = cadena.replace(/ó/gi,"o");
           cadena = cadena.replace(/ú/gi,"u");
           cadena = cadena.replace(/ñ/gi,"n");
           
           cadena = cadena.toUpperCase();
           
           return cadena;
        }                
            
</script>        
        

        <script>
            function enviarEncuesta(){
                const lblestadoventa = $('#lblestadoventa').val();
                
                if(lblestadoventa === 'Instalada' || lblestadoventa === 'InstaladaTEC'){
                    
                    let lblcorreo = $('#lblcorreo').val();
                    let lblnombcliente = $('#lblnombcliente').val();
                    let lblmovil = $('#lblmovil').val();
                    let lblncontrato = $('#lblncontrato').val();
                    let fechainst = moment($('#fechainst').val(), 'DD/MM/YYYY').format('DD-MM-YYYY');
                    let lblmatricula = $('#lblmatricula').val();
                    let lbldc = `PE${$('#lbldc').val()}`;
                    
                    let lbldistrito = $('#lbldistrito option:selected').text();
                    let arraylbldistrito = lbldistrito.split(" - ");
                    let distrito = arraylbldistrito[0];
                    let provincia = arraylbldistrito[1];
                    
                    let lblsegmento = $('#lblsegmento').val();
                    let lbltipoventa = $('#lbltipoventa').val();
                    
                    moment.locale('es');
                    let mesinst = moment($('#fechainst').val(), 'DD/MM/YYYY').format('MMMM');
                    
                    data = {
                      "campaign_id": 309162,
                      "survey_id":335464,
                      "respondent_email": lblcorreo,
                      "respondent_name": lblnombcliente,
                      "respondent_phone": lblmovil,
                      "respondent_expiration_days": 10,
                      "numero_de_instalacion": lblncontrato,
                      "fecha_instalacion": fechainst,
                      "matricula_vendedor": lblmatricula,
                      "delegacion": lbldc,
                      "city": distrito,
                      "state_description": provincia,
                      "segmento": lblsegmento,
                      "recurso": lbltipoventa,
                      "mes_de_instalacion": mesinst,
                      "apellido": " "
                    }
                    
                    fetch('https://qservus.redcalidad.com/api/addrespondent/', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Authorization': 'Token 69091bedd687e3b2da71f0d804df3853242a493c'
                        },
                        body: JSON.stringify(data),
                    })
                    .then(response => response.json())
                    .then(data => {
                      console.log('Success:', data);
                    })
                    .catch((error) => {
                      console.error('Error:', error);
                    });

                }
            }
        </script>





    </body>
</html>

<?php 

$sql_venta->close();
$result->close();
$result_tecnico->close();

?>
