<?php
    
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
    }
    
    date_default_timezone_set('America/Lima');
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }
    
    include 'config/db.php';
    include 'config/conexion.php';
    
?>

<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
       <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
        <!-- DataTables -->
        <link rel="stylesheet" href="admin/bower_components/datatables.net-bs/css/dataTables.bootstrap.min.css">
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
        <link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css"/>
        <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>

        <style>

            .tbinput {
                background: none!important;
                border: none;
                -webkit-appearance: none;
            }

            .classMantenimiento, .ClsLlamada, .clsInfoCTz, .clsNInt, .clsNIntMot, .clsNProc{
                display: none;
            }

            .ocultar {
                display: none;
            }

            .selected{
                background-color: #e0e0e0;
            }

            .subtitulo{
                text-decoration: underline;
                font-weight: bold;
            }

            label{
                font-weight: normal;
                font-size: 12px;
                text-align: left!important;
            }

            .botonTabla{
                background:none;
                border:none;
                display: none;
            }

            .swal2-popup{
                font-size: 1.5rem!important;
            }

            .swal2-styled.swal2-confirm{
                background-color: #e4002b!important;
            }

            .bordeRojo{
                border: 1px solid #e4002b;
            }

            .obligatorio{
                display: none;
                color: red;
            }

            .derecha{
                text-align: right;
            }

            #tinviable, #tinviableespacio, #tcanceladoespacio, #tcancelado{
                display: none;
            }

            .modal-header-danger {
                color:#fff;
                background-color: #e4002b;
            }


            .preloader{
                background-color:#FFF;
                width: 100%;
                height: 100%;
                position: absolute;
                z-index: 1;
            }

            .dataTables_wrapper .myfilter .dataTables_filter{float:left}
            .dataTables_wrapper .mylength .dataTables_length{float:right}
            div.dataTables_scrollBody thead th {
                vertical-align: top;
            }
            td {
                max-width: 250px;
                overflow: hidden;
                white-space: nowrap;
                text-overflow: ellipsis;

            }
            .espacio{
                height:10px;
            }

           .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }


            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #frmEditarVenta .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: auto;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 200%;

            }
            #slider section{
                width: 100%;
            }


            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo {
                color: #FFFFFF;
                background-color: #444444;
                border-color: #444444;
            }

            .btn-nuevo:hover,
            .btn-nuevo:focus,
            .btn-nuevo:active,
            .btn-nuevo.active,
            .open .dropdown-toggle.btn-nuevo {
                color: #FFFFFF;
                background-color: #616161;
                border-color: #444444;
            }

            .btn-nuevo:active,
            .btn-nuevo.active,
            .open .dropdown-toggle.btn-nuevo {
                background-image: none;
            }

            .btn-nuevo.disabled,
            .btn-nuevo[disabled],
            fieldset[disabled] .btn-nuevo,
            .btn-nuevo.disabled:hover,
            .btn-nuevo[disabled]:hover,
            fieldset[disabled] .btn-nuevo:hover,
            .btn-nuevo.disabled:focus,
            .btn-nuevo[disabled]:focus,
            fieldset[disabled] .btn-nuevo:focus,
            .btn-nuevo.disabled:active,
            .btn-nuevo[disabled]:active,
            fieldset[disabled] .btn-nuevo:active,
            .btn-nuevo.disabled.active,
            .btn-nuevo[disabled].active,
            fieldset[disabled] .btn-nuevo.active {
                background-color: #444444;
                border-color: #444444;
            }

        </style>

        <style>
            .main-header,.main-sidebar,.left-side{
                position:fixed
            }
            
            .main-header {
                top: 0;
                right: 0;
                left: 0
            }
            
            .content-wrapper,
            .right-side {
                padding-top: 50px
            }
            
            @media (max-width:767px) {
                 .content-wrapper,
                 .right-side {
                    padding-top: 100px
                }
            }
            
            .layout-boxed .wrapper {
                max-width: 100%
            }
            
            .wrapper {
                overflow: hidden
            }
            
            .control-sidebar {
                position: fixed;
                height: 100%;
                overflow-y: auto;
                padding-bottom: 50px
            }
        </style>

        <style>
            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                   -moz-border-radius: 5px;
                        border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                   -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                        box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
            
                    z-index: 1051 !important;
            
            }
            
            hr {
              height: 4px;
              width: 100%;
              background-color: #ecf0f5;
            
            }

            hr {
                /* margin-top: 20px; */
                margin-bottom: 20px;
                border: 0;
                /* border-top: 1px solid #eee; */
            }
            
            hr {
                display: block;
                unicode-bidi: isolate;
                -webkit-margin-before: 0.5em;
                -webkit-margin-after: 0.5em;
                -webkit-margin-start: auto;
                -webkit-margin-end: auto;
                overflow: hidden;
                border-style: inset;
            
            }

            .box.box-custom {
                border-top-color: #ffffff;
            }
            
            .box {
                position: relative;
                border-radius: 3px;
                background: #ffffff;
                border-top: 3px solid #d2d6de;
                margin-bottom: 5px;
                width: 100%;
                box-shadow: 0 1px 1px rgba(0,0,0,0.1);
            }

        </style>
                
        <style>
            .btn-blanco {
              background-color: white;
            }
    
            .btn-blanco{
              border: none;
            }
    
            .btn-blanco i{
              color: #E4002B;
            }
    
            .blanco-sinborde{
              background: white!important;
              border: none;
            }
            
            .info-tec label{
                text-align:left; 
                padding: 8px 15px;    
            }
            
            .info-tec button{
                padding: 4px 10px; 
                font-size: 16px;    
            }
            
            .info-tec p{
                padding: 4px 10px; 
                font-size: 16px; 
                font-weight: 600;
                display: inline-block;
            }
            
            
            .texto-derecha{
                text-align: right;
            }
    
        </style>
        
        <style>
            .red{
                color: #E4002B;
            }
            .green{
                color: green;
            }
            .orange{
                color: orange;
            }
            
            .detalleSolicitud__div{
                border-bottom: 1px solid lightgray;
                padding: 8px 0px;
            }
            
            label{
                text-transform: uppercase;
            }
            
            .detalle-solicitud-grid {
                display: grid;
                grid-template-columns: 1fr 6fr;
            }
            
            .detalleSolicitud__div{
                margin-bottom: 0px;
            }
            
            .detalleSolicitud__div label{
                font-weight: bold;
                font-size: 13px;
            }
            
           @media (max-width:1600px) {
                ::placeholder {
                  font-size: 0.8em;
                }
            }
            
        </style>

    </head>

    <body class="sidebar-collapse skin-red sidebar-mini">

         <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php include 'admin/main-sidebar.php'; ?>

            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        F.U.C
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="dashboard1.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li class="active">Editar F.U.C</li>
                    </ol>
                </section>
                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        <!--<div class="col-md-2"></div> -->
                        <div class="col-md-12">
                            <div class="box box-danger">
                                <div class="box-header">
                                    <h3 class="box-title">F.U.C N° - </h3>
                                    <div class="box-tools pull-right">
                                        <button class="btn btn-nuevo btn-sm" id="btnGuardar"><i class="fa fa-save"></i> Guardar</button>
                                        <a href="reclamos.php" class="btn btn-danger btn-sm" ><i class="fa fa-reply"></i> Regresar</a>
                                    </div>
                                </div>
                                <div class="espacio"></div>
                            </div>
                            <div id="frmEditarSolicitud" method="post">
                                <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                        <h5>INFORMACION DE LA SOLICITUD</h5>
                                        <div class="box-tools pull-aca right">
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                        </div>
                                    </div>
                                    <div class="box-body">
                                        <!-- DATOS DEL CLIENTE -->
                                        <div class="form-horizontal" style="padding: 10px 20px 0">
                                            <div>
                                                <h5 class="subtitulo">DATOS GENERALES DEL CLIENTE</h5>
                                            </div>
                                            <div class="form-group">
                                                <label class="col-lg-1 control-label" style="padding-left: 35px;">NCONTRATO:<span style="color:red"> * </span></label>
                                                <div class="col-lg-2">
                                                  <input type="tel" class="form-control input-sm" name="ncliente" id="ncliente" value="" maxlength="15">
                                                </div>
                                                <label class="col-lg-1 control-label">CLIENTE:<span style="color:red"> * </span></label>
                                                <div class="col-lg-2">
                                                    <input  class="form-control input-sm" name="nombcliente" id="nombcliente" value="" style="width: 100%;" maxlength="100"  />
                                                </div>
                                                <label class="col-lg-1 control-label" style="padding-left: 35px;">CORREO:<span style="color:red"> * </span> </label>
                                                <div class="col-lg-2">
                                                  <input type="email"  class="form-control input-sm" id="correo" value="" name="correo" maxlength="100">
                                                </div>
                                                <label class="col-lg-1 control-label">CORREO 2:</label>
                                                <div class="col-lg-2">
                                                    <input type="email"  class="form-control input-sm" id="correo2" value="" name="correo2" maxlength="100">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="col-lg-1 control-label" style="padding-left: 35px;">TELEFONO:<span style="color:red"> * </span> </label>
                                                <div class="col-lg-2">
                                                    <input type="text"  class="form-control input-sm" id="telefono" value="" name="telefono" maxlength="10">
                                                </div>
                                            </div>
                                        </div>
                                        <!--DATOS DE LA SOLICITUD -->
                                        <div class="form-horizontal" style="padding: 10px 20px 0">
                                            <div>
                                                <h5 class="subtitulo">DATOS DE LA SOLICITUD</h5>
                                            </div>
                                            <div class="detalleSolicitud">
                                                <div class="box box-danger">
                                                    <div class="box-header"><h4>SOLICITUDES</h4></div>
                                                    <div class="box-body" style="padding-bottom: 0px">
                                                    <div class="form-group detalleSolicitud__div" style="border-bottom: 0px;">
                                                        <label class="col-lg-2 control-label" style="padding-left: 35px;">ENVIO DE FACTURAS:</label>
                                                        <div class="col-lg-1">
                                                            <input type="checkbox" class="flat-red" id="envioFacturas" name="envioFacturas">
                                                        </div>
                                                        
                                                        <div class="col-lg-1">
                                                            <input type="text" class="form-control input-sm" placeholder="FACTURA 1" id="factura1" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                        </div>
                                                        <div class="col-lg-1">
                                                            <input type="text" class="form-control input-sm" placeholder="FACTURA 2" id="factura2" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                        </div>
                                                        <div class="col-lg-1">
                                                            <input type="text" class="form-control input-sm" placeholder="FACTURA 3" id="factura3" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                        </div>
                                                        <div class="col-lg-1">
                                                            <input type="text" class="form-control input-sm" placeholder="FACTURA 4" id="factura4" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                        </div>
                                                        <div class="col-lg-1">
                                                            <input type="text" class="form-control input-sm" placeholder="FACTURA 5" id="factura5" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                        </div>
                                                        <div class="col-lg-1">
                                                            <input type="text" class="form-control input-sm" placeholder="FACTURA 6" id="factura6" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                        </div>
                                                        <div class="col-lg-1">
                                                            <input type="text" class="form-control input-sm" placeholder="FACTURA 7" id="factura7" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                        </div>
                                                        <div class="col-lg-1">
                                                            <input type="text" class="form-control input-sm" placeholder="FACTURA 8" id="factura8" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                        </div>
                                                        <div class="col-lg-1">
                                                            <input type="text" class="form-control input-sm" placeholder="FACTURA 9" id="factura9" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                        </div>                                                        
                                                    </div>
                                                    <div class="form-group detalleSolicitud__div">
                                                        <label class="col-lg-2 control-label" style="padding-left: 35px;"></label>
                                                        <div class="col-lg-1">
                                                            
                                                        </div>
                                                        <div class="col-lg-1">
                                                            <input type="text" class="form-control input-sm" placeholder="FACTURA 10" id="factura10" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                        </div>                                                        
                                                    </div>                                                    
                                                        <div class="form-group detalleSolicitud__div" style="border-bottom: 0px;">
                                                    <label class="col-lg-2 control-label" style="padding-left: 35px;">REGISTRO DE TARJETA:</label>
                                                    <div class="col-lg-1">
                                                        <input type="checkbox" class="flat-red" id="registroTarjeta" name="registroTarjeta">
                                                    </div>
                                                    <div class="col-lg-2">
                                                       <select class="form-control input-sm" id="banco" >
                                                            <option value="" selected disabled>BANCO</option>
                                                            <option value="PE-VI">PE-VI</option>
                                                            <option value="PE-MC">PE-MC</option>
                                                            <option value="PE-AM">PE-AM</option>
                                                            <option value="PE-DC">PE-DC</option>
                                                            <option value="BCP">BCP</option>
                                                            <option value="Interbank">Interbank</option>
                                                            <option value="Scotiabank">Scotiabank</option>
                                                            <option value="BBVA">BBVA</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-lg-2">
                                                        <select class="form-control input-sm" id="tipo">
                                                            <option value="" selected disabled>TIPO</option>
                                                            <option value="TC">TC</option>
                                                            <option value="TD">TD</option>
                                                            <option value="CC" hidden>CC</option>
                                                            <option value="Ahorro">Ahorro</option>
                                                            <option value="Corriente">Corriente</option>                                                            
                                                        </select>
                                                    </div>
                                                   <div class="col-lg-2">
                                                        <input type="text" class="form-control input-sm" placeholder="NUMERO TARJETA" id="ntarjeta" maxlength="20" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                    </div>                                                    
                                                    <div class="col-lg-1">
                                                        <select class="form-control input-sm" id="añoFV">
                                                            <option value="" disabled selected>AÑO</option>
                                                            <option value="2022">2022</option>
                                                            <option value="2023">2023</option>
                                                            <option value="2024">2024</option>
                                                            <option value="2025">2025</option>
                                                            <option value="2026">2026</option>
                                                            <option value="2027">2027</option>
                                                            <option value="2028">2028</option>
                                                            <option value="2029">2029</option>
                                                            <option value="2030">2030</option>
                                                        </select>
                                                    </div>
 
                                                    <div class="col-lg-1">

                                                        <select class="form-control input-sm" id="mesFV">
                                                            <option value="" disabled selected>MES</option>
                                                            <option value="1">1</option>
                                                            <option value="2">2</option>
                                                            <option value="3">3</option>
                                                            <option value="4">4</option>
                                                            <option value="5">5</option>
                                                            <option value="6">6</option>
                                                            <option value="7">7</option>
                                                            <option value="8">8</option>
                                                            <option value="9">9</option>
                                                            <option value="10">10</option>
                                                            <option value="11">11</option>
                                                            <option value="12">12</option>
                                                        </select>
                                                    </div>
                                                   
                                                    
                                                </div>

                                                    <div class="form-group detalleSolicitud__div">
                                                        <label class="col-lg-2 control-label" style="padding-left: 35px;"></label>
                                                        <div class="col-lg-1">
                                                            
                                                        </div>
                                                        <div class="col-lg-2">
                                                                <select class="form-control input-sm" name="TipoDocumento" id="TipoDocumento">
                                                                    <option value="" selected disabled>TIPODOCUMENTO</option>
                                                                    <option value="DNI">DNI</option>
                                                                    <option value="RUC">RUC</option>
                                                                </select> 
                                                        </div>
                                                        <div class="col-lg-2">
                                                            <input type="text" class="form-control input-sm" placeholder="DOCUMENTO" id="Documento" maxlength="11">
                                                        </div>                                                     
                                                        <div class="col-lg-2">
                                                            <input type="text" class="form-control input-sm" placeholder="NOMBRE TITULAR" id="nombreTitular" maxlength="100">
                                                        </div>
                                                    </div>  
                                                
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">FORMATO DE AFILIACIÓN:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="formatoAfiliacion" name="formatoAfiliacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">CAMBIO DE MODALIDAD DE PAGO A CF:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="cambioModalidadPagoCF" name="cambioModalidadPagoCF">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Estado de cuenta:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="estadoCuenta" name="estadoCuenta">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="estadoCuenta__observacion">
                                                            </div>                                                            
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Envío de copia de contrato:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="EnvioCopiaContrato" name="EnvioCopiaContrato">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Carta de no adeudo:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="CartaNoAdeudo" name="CartaNoAdeudo">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Solicitud de reconexión:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="solicitudReconexion" name="solicitudReconexion">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="SR__OBSERVACION">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Traspaso de saldos N°1:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="traspasoSaldos_1" name="traspasoSaldos_1">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="FACTURA INICIAL" id="TS__facturainicial_1" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="FACTURA FINAL" id="TS__facturafinal_1" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="MONTO" id="TS__monto_1" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                            </div>
                                                            <div class="col-lg-2    ">
                                                                <input type="date" class="form-control input-sm" placeholder="FECHA DE PAGO" id="TS__fechapago_1">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Traspaso de saldos N°2:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="traspasoSaldos_2" name="traspasoSaldos_2">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="FACTURA INICIAL" id="TS__facturainicial_2" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="FACTURA FINAL" id="TS__facturafinal_2" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="MONTO" id="TS__monto_2" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                            </div>
                                                            <div class="col-lg-2    ">
                                                                <input type="date" class="form-control input-sm" placeholder="FECHA DE PAGO" id="TS__fechapago_2">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Traspaso de saldos N°3:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="traspasoSaldos_3" name="traspasoSaldos_3">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="FACTURA INICIAL" id="TS__facturainicial_3" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="FACTURA FINAL" id="TS__facturafinal_3" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="MONTO" id="TS__monto_3" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                            </div>
                                                            <div class="col-lg-2    ">
                                                                <input type="date" class="form-control input-sm" placeholder="FECHA DE PAGO" id="TS__fechapago_3">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Traspaso de saldos N°4:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="traspasoSaldos_4" name="traspasoSaldos_4">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="FACTURA INICIAL" id="TS__facturainicial_4" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="FACTURA FINAL" id="TS__facturafinal_4" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="MONTO" id="TS__monto_4" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                            </div>
                                                            <div class="col-lg-2    ">
                                                                <input type="date" class="form-control input-sm" placeholder="FECHA DE PAGO" id="TS__fechapago_4">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Cliente fallecido:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="clienteFallecido" name="clienteFallecido">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="CF__observacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Devolución de equipos:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="devolucionEquipos" name="devolucionEquipos">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="DE__observacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Facturación adelantada(Pago anticipado):</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="facturacionAdelantada" name="facturacionAdelantada">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="MESES A FACTURAR" id="mesesFacturar">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Actualización de datos( Cel - correo monitoring):</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="actualizacionDatosCelCorreo" name="actualizacionDatosCelCorreo">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="ADCC__Observacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Traslado:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="traslado" name="traslado">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="T__observacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Incremento cuota IPC + programador/ guardian:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="incrementoCuotaIPC" name="incrementoCuotaIPC">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="ICIPC__observacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Solicitud de Cambio de Titularidad con deuda:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="solicitudCambioTitularidadconDeuda" name="solicitudCambioTitularidadconDeuda">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="SCTCD__observacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Solicitud cambio titularidad sin deuda(mismo cliente):</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="solicitudCambioTitularidadsinDeudaMismoCliente" name="solicitudCambioTitularidadsinDeudaMismoCliente">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                                <label class="col-lg-2 control-label" style="padding-left: 35px; font-weight: bold; font-size: 13px">Solicitud cambio titularidad sin deuda(diferente cliente):</label>
                                                                <div class="col-lg-1">
                                                                    <input type="checkbox" class="flat-red" id="solicitudCambioTitularidadsinDeudaDiferenteCliente" name="solicitudCambioTitularidadsinDeudaDiferenteCliente">
                                                                </div>
                                                                <div class="col-lg-1    ">
                                                                    <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="SCTSDDC__observacion">
                                                                </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Certificado de operatividad:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="CertificadoOperatividad" name="CertificadoOperatividad">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="CertificadoOperatividad__observacion">
                                                            </div>
                                                        </div>

                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Reubicación de dispositivos:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="Reubicaciondedispositivos" name="Reubicaciondedispositivos">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="Reubicaciondedispositivos__observacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">No retirar beneficio por forma de pago:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="No_retirar_beneficio_formapago" name="No_retirar_beneficio_formapago">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="No_retirar_beneficio_formapago__observacion">
                                                            </div>
                                                        </div>                                                        
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Capacitación de servicio:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="CapacitaciondeServicio" name="CapacitaciondeServicio">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="CapacitaciondeServicio__observacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Ampliaciones:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="Ampliaciones" name="Ampliaciones">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="Ampliaciones__observacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div" style="border-bottom-color: #ffffff;">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Cambio de correo Billing:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="CambiodecorreoBilling" name="CambiodecorreoBilling">
                                                            </div>
                                                            <div class="col-lg-2">
                                                                <input type="text" class="form-control input-sm" placeholder="EMAIL 1" id="email1">
                                                            </div>
                                                            <div class="col-lg-2">
                                                                <input type="text" class="form-control input-sm" placeholder="EMAIL 2" id="email2">
                                                            </div>
                                                        </div>                                                        
                                                    </div>
                                                </div>
                                                <div class="box box-danger">
                                                    <div class="box-head"><h4>RECLAMOS</h4></div>
                                                    <div class="box-body" style="padding-bottom: 0px">
                                                        <!--
                                                        
                                                       
                                                        <div class="form-group detalleSolicitud__div">
                                                                <label class="col-lg-2 control-label" style="padding-left: 35px;">Reclamo de facturación:</label>
                                                                <div class="col-lg-1">
                                                                    <input type="checkbox" class="flat-red" id="reclamoFacturacion" name="reclamoFacturacion">
                                                                </div>
                                                                <div class="col-lg-1">
                                                                    <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="RF__observacion">
                                                                </div>
                                                                <div class="col-lg-2">
                                                                    <div class="detalle-solicitud-grid">
                                                                        <input type="checkbox" class="minimal-red" id="RF__errorDatos">
                                                                        <label>Error en datos </label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-2">
                                                                    <div class="detalle-solicitud-grid">
                                                                    <input type="checkbox" class="minimal-red" id="RF__ofertanoaplicada">
                                                                    <label>Oferta no aplicada</label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-2">
                                                                    <div style="display: grid; grid-template-columns: 1fr 6fr;">
                                                                        <input type="checkbox" class="minimal-red" id="RF__descuentoformapago">
                                                                        <label>Descuento por la forma de pago (TD,TC,CF)</label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-lg-2">
                                                                    <div style="display: grid; grid-template-columns: 1fr 6fr;">
                                                                        <input type="checkbox" class="minimal-red" id="RF__reclamoAmpliacionesFacturacion">
                                                                        <label>Reclamo Ampliaciones Facturación</label>
                                                                    </div>
                                                                </div>
                                                            
                                                        </div>
                                                         
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Reclamo MDP :</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="reclamoMDP" name="reclamoMDP">
                                                            </div>
                                                            <div class="col-lg-1">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="RMDP__observacion">
                                                            </div>
                                                            <div class="col-lg-2">
                                                                <div class="detalle-solicitud-grid">
                                                                    <input type="checkbox" class="minimal-red" id="RMDP_reclamoDevolucionDinero">
                                                                    <label>Reclamo devolución dinero</label>
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-2">
                                                                <div class="detalle-solicitud-grid">
                                                                    <input type="checkbox" class="minimal-red" id="RMDP_reclamoCargosDobles">
                                                                    <label>Reclamo cargos dobles</label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        -->
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Reclamo demora dev. de dinero:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="reclamoDemoraDevDinero" name="reclamoDemoraDevDinero">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="RDDD__observacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Reclamo por oferta no aplica:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="reclamoOfertaNoAplica" name="reclamoOfertaNoAplica">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="RONA__observacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Reclamo por dscto forma de pago no aplicada:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="reclamoDsctoFormaPagoAplicada" name="reclamoDsctoFormaPagoAplicada">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="RDFPA__observacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px; font-weight: bold; font-size: 13px">Reclamo por Gestión de baja (penalidad/última fecha cobrable):</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="reclamoGestionBaja" name="reclamoGestionBaja">
                                                            </div>
                                                            <div class="col-lg-1">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="RGB__observaciones">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Reclamo por vigencia/PAI/Tarifa de contrato:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="reclamoVigenciaPaiTarifa" name="reclamoVigenciaPaiTarifa">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="RVPT__observacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Reclamo error datos(nombre,direccion,taxno):</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="reclamoErrorDatos" name="reclamoErrorDatos">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="RED__observacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Reclamo costo/monitoreo ampliacion:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="reclamoCostoMonitoreo" name="reclamoCostoMonitoreo">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="RCM__observacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Reclamo comercial  (oferta no registrada en cto):</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="reclamoComercial" name="reclamoComercial">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="RC__observacion">
                                                            </div>
                                                        </div>
                                                        
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Reclamo por error en detalle de comprobante:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="reclamoErrorDatalleComprobante" name="reclamoErrorDatalleComprobante">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="REDC__observacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Reclamo cobro doble:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="reclamoCobroDoble" name="reclamoCobroDoble">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="RCD__observacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Reclamo INDECOPI (Legal) :</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="reclamoIndecopiLegal" name="reclamoIndecopiLegal">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="RII__observacion">
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">Reclamo de servicio:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="reclamoServicio" name="reclamoServicio">
                                                            </div>
                                                            <div class="col-lg-1    ">
                                                                <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="RS__observacion">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="box box-danger">
                                                    <div class="box-head">
                                                        <h4>OTROS</h4>
                                                    </div>
                                                    <div class="box-body">
                                                        <div class="form-group detalleSolicitud__div">
                                                        <label class="col-lg-2 control-label" style="padding-left: 35px;">Condonación:</label>
                                                        <div class="col-lg-1">
                                                            <input type="checkbox" class="flat-red" id="Condonacion" name="Condonacion">
                                                        </div>
                                                        <div class="col-lg-1">
                                                            <input type="number" class="form-control input-sm" placeholder="MONTO A CONDONAR" id="montoCondonar" >
                                                        </div>
                                                        <div class="col-lg-1">
                                                            <select class="form-control input-sm" id="campaña">
                                                                <option value="" selected disabled>CAMPAÑA</option>
                                                                <option value="XCAN6">XCAN6 : 50% de dscto</option>
                                                                <option value="XMOR6">XMOR6 : 50% de dscto</option>
                                                                <option value="Clientes de baja - Cobintel">Clientes de baja - Cobintel</option>
                                                            </select>                                                            
                                                        </div>
                                                        <div class="col-lg-2">
                                                            <input type="date" class="form-control input-sm" placeholder="FECHA DE PAGO" id="fechaPago">
                                                        </div>
                                                        <div class="col-lg-1">
                                                            <input type="text" class="form-control input-sm" placeholder="MES DE CAMPAÑA" id="mesCampaña">
                                                        </div>
                                                        <div class="col-lg-1">
                                                            <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="campaña__observacion">
                                                        </div>
                                                    </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            
                                                                <label class="col-lg-2 control-label" style="padding-left: 35px; font-weight: bold; font-size: 13px">Solicitudes de baja:</label>
                                                                <div class="col-lg-1">
                                                                    <input type="checkbox" class="flat-red" id="solicitudBaja" name="solicitudBaja">
                                                                </div>
                                                                <div class="col-lg-1">
                                                                    <input type="text" class="form-control input-sm" placeholder="NOMBRE" id="SB__nombre">
                                                                </div>
                                                                <div class="col-lg-2">
                                                                    <select class="form-control input-sm" id="SB__motivoBaja">
                                                                        <option value="" selected disabled>MOTIVO DE BAJA</option>
                                                                        <option value="Motivo economico">Motivo económico</option>
                                                                        <option value="Falta de uso">Falta de uso</option>
                                                                        <option value="Mejor propuesta de competencia">Mejor propuesta de competencia</option>
                                                                        <option value="Cambio de domicilio o cese de negocio">Cambio de domicilio o cese de negocio</option>
                                                                        <option value="Subida de cuota">Subida de cuota</option>
                                                                        <option value="Reclamo comercial">Reclamo comercial</option>
                                                                        <option value="Reclamo servicio">Reclamo servicio</option>
                                                                        <option value="Falta de cobertura">Falta de cobertura</option>
                                                                    </select> 
                                                                </div>
                                                                <div class="col-lg-1">
                                                                    <input type="text" class="form-control input-sm" placeholder="TELEFONO" id="SB__telefono">
                                                                </div>
                                                                <div class="col-lg-1">
                                                                    <input type="text" class="form-control input-sm" placeholder="OBSERVACION" id="SB__observacion">
                                                                </div>
                                                            
                                                        </div>
                                                         <div class="form-group detalleSolicitud__div">
                                                    <label class="col-lg-2 control-label" style="padding-left: 35px;">COMPROMISO DE PAGO N°1:</label>
                                                    <div class="col-lg-1">
                                                        <input type="checkbox" class="flat-red" id="registroCompromisoPago" name="registroCompromisoPago">
                                                    </div>
                                                    <div class="col-lg-1">
                                                        <input type="number" class="form-control input-sm" placeholder="MONTO CUOTA" id="montocuota">
                                                    </div>
                                                    <div class="col-lg-2">
                                                        <input type="text" class="form-control input-sm" placeholder="FACTURA INTERNA CUOTA" id="facturainternacuota" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                    </div>
                                                    <div class="col-lg-1">
                                                        <input type="number" class="form-control input-sm" placeholder="MONTO PAI" id="montoPAI">
                                                    </div>
                                                    <div class="col-lg-2">
                                                        <input type="text" class="form-control input-sm" placeholder="FACTURA INTERNA PAI" id="facturainternaPAI" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                    </div>
                                                    <div class="col-lg-2">
                                                        <input type="date" class="form-control input-sm" placeholder="FECHA CARGO" id="fechapagoCompromisoPago">
                                                    </div>
                                                    <div class="col-lg-1">
                                                        <select class="form-control input-sm" id="bancoCompromisoPago">
                                                            <option value="" selected disabled>BANCO</option>
                                                            <option value="PE-VI">PE-VI</option>
                                                            <option value="PE-MC">PE-MC</option>
                                                            <option value="PE-AM">PE-AM</option>
                                                            <option value="PE-DC">PE-DC</option>
                                                            <option value="BCP">BCP</option>
                                                            <option value="Interbank">Interbank</option>
                                                            <option value="Scotiabank">Scotiabank</option>
                                                            <option value="BBVA">BBVA</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">COMPROMISO DE PAGO N°2:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="registroCompromisoPago_2" name="registroCompromisoPago_2">
                                                            </div>
                                                            <div class="col-lg-1">
                                                                <input type="number" class="form-control input-sm" placeholder="MONTO CUOTA" id="montocuota_2">
                                                            </div>
                                                            <div class="col-lg-2">
                                                                <input type="text" class="form-control input-sm" placeholder="FACTURA INTERNA CUOTA" id="facturainternacuota_2" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                            </div>
                                                            <div class="col-lg-1">
                                                                <input type="number" class="form-control input-sm" placeholder="MONTO PAI" id="montoPAI_2">
                                                            </div>
                                                            <div class="col-lg-2">
                                                                <input type="text" class="form-control input-sm" placeholder="FACTURA INTERNA PAI" id="facturainternaPAI_2" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                            </div>
                                                            <div class="col-lg-2">
                                                                <input type="date" class="form-control input-sm" placeholder="FECHA CARGO" id="fechapagoCompromisoPago_2">
                                                            </div>
                                                            <div class="col-lg-1">
                                                                <select class="form-control input-sm" id="bancoCompromisoPago_2">
                                                                    <option value="" selected disabled>BANCO</option>
                                                                    <option value="PE-VI">PE-VI</option>
                                                                    <option value="PE-MC">PE-MC</option>
                                                                    <option value="PE-AM">PE-AM</option>
                                                                    <option value="PE-DC">PE-DC</option>
                                                                    <option value="BCP">BCP</option>
                                                                    <option value="Interbank">Interbank</option>
                                                                    <option value="Scotiabank">Scotiabank</option>
                                                                    <option value="BBVA">BBVA</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">COMPROMISO DE PAGO N°3:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="registroCompromisoPago_3" name="registroCompromisoPago_3">
                                                            </div>
                                                            <div class="col-lg-1">
                                                                <input type="number" class="form-control input-sm" placeholder="MONTO CUOTA" id="montocuota_3">
                                                            </div>
                                                            <div class="col-lg-2">
                                                                <input type="text" class="form-control input-sm" placeholder="FACTURA INTERNA CUOTA" id="facturainternacuota_3" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                            </div>
                                                            <div class="col-lg-1">
                                                                <input type="number" class="form-control input-sm" placeholder="MONTO PAI" id="montoPAI_3">
                                                            </div>
                                                            <div class="col-lg-2">
                                                                <input type="text" class="form-control input-sm" placeholder="FACTURA INTERNA PAI" id="facturainternaPAI_3" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                            </div>
                                                            <div class="col-lg-2">
                                                                <input type="date" class="form-control input-sm" placeholder="FECHA CARGO" id="fechapagoCompromisoPago_3">
                                                            </div>
                                                            <div class="col-lg-1">
                                                                <select class="form-control input-sm" id="bancoCompromisoPago_3">
                                                                    <option value="" selected disabled>BANCO</option>
                                                                    <option value="PE-VI">PE-VI</option>
                                                                    <option value="PE-MC">PE-MC</option>
                                                                    <option value="PE-AM">PE-AM</option>
                                                                    <option value="PE-DC">PE-DC</option>
                                                                    <option value="BCP">BCP</option>
                                                                    <option value="Interbank">Interbank</option>
                                                                    <option value="Scotiabank">Scotiabank</option>
                                                                    <option value="BBVA">BBVA</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="form-group detalleSolicitud__div" style="border-bottom-color: #ffffff;">
                                                            <label class="col-lg-2 control-label" style="padding-left: 35px;">COMPROMISO DE PAGO N°4:</label>
                                                            <div class="col-lg-1">
                                                                <input type="checkbox" class="flat-red" id="registroCompromisoPago_4" name="registroCompromisoPago_4">
                                                            </div>
                                                            <div class="col-lg-1">
                                                                <input type="number" class="form-control input-sm" placeholder="MONTO CUOTA" id="montocuota_4">
                                                            </div>
                                                            <div class="col-lg-2">
                                                                <input type="text" class="form-control input-sm" placeholder="FACTURA INTERNA CUOTA" id="facturainternacuota_4" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                            </div>
                                                            <div class="col-lg-1">
                                                                <input type="number" class="form-control input-sm" placeholder="MONTO PAI" id="montoPAI_4">
                                                            </div>
                                                            <div class="col-lg-2">
                                                                <input type="text" class="form-control input-sm" placeholder="FACTURA INTERNA PAI" id="facturainternaPAI_4" oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*)\./g, '$1');">
                                                            </div>
                                                            <div class="col-lg-2">
                                                                <input type="date" class="form-control input-sm" placeholder="FECHA CARGO" id="fechapagoCompromisoPago_4">
                                                            </div>
                                                            <div class="col-lg-1">
                                                                <select class="form-control input-sm" id="bancoCompromisoPago_4">
                                                                    <option value="" selected disabled>BANCO</option>
                                                                    <option value="PE-VI">PE-VI</option>
                                                                    <option value="PE-MC">PE-MC</option>
                                                                    <option value="PE-AM">PE-AM</option>
                                                                    <option value="PE-DC">PE-DC</option>
                                                                    <option value="BCP">BCP</option>
                                                                    <option value="Interbank">Interbank</option>
                                                                    <option value="Scotiabank">Scotiabank</option>
                                                                    <option value="BBVA">BBVA</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>

            <div class="control-sidebar-bg"></div>
        </div><!-- ./wrapper -->

        <!-- jQuery v1.11 -->
        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>
        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>$.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>
        <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>
        <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <!-- bootstrap toogle -->
        <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>
        <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <!-- SweetAlert -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <!-- DataTables -->
        <script src="admin/bower_components/datatables.net/js/jquery.dataTables.min.js"></script>
        <script src="admin/bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
        <!-- iCheck 1.0.1 -->
        <script src="admin//plugins/iCheck/icheck.min.js"></script>
        <!-- CONSTANTES GLOBALES -->
        <script>
            const queryString = window.location.search;
            const urlParams = new URLSearchParams(queryString);
            const idCliente = urlParams.get('idcliente');

        </script>
            
        <script>
            $('.select2').select2();
            
            //Red color scheme for iCheck
            $('input[type="checkbox"].minimal-red, input[type="radio"].minimal-red').iCheck({
              checkboxClass: 'icheckbox_minimal-red',
              radioClass   : 'iradio_minimal-red'
            })
            
            //Flat red color scheme for iCheck
            $('input[type="checkbox"].flat-red, input[type="radio"].flat-red').iCheck({
              checkboxClass: 'icheckbox_flat-red',
              radioClass   : 'iradio_flat-red'
            })
            
            $('#mesCampaña').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1, format: 'M-yyyy',
                    viewMode: "years",
                    minViewMode: "months"
                });
            
        </script>
        
        
        <script>
            $('#btnGuardar').on('click', function(){
                
                const ncliente = $('#ncliente').val();
                const nombcliente = $('#nombcliente').val();
                const correo = $('#correo').val();
                const correo2 = $('#correo2').val();
                const telefono = $('#telefono').val();
                
                const arregloDetalle = generarDetalle();
                let lista = '<ul>';
                
                if(!arregloDetalle){
                    return;
                }
                
                if(arregloDetalle.length == 0){
                    Swal.fire('Sin solicitudes!', 'No hay solicitudes registradas', 'error');
                    return;
                }
                
                arregloDetalle.forEach(datos => {
                    const {solicitud} =  datos;
                    
                    lista += `<li>${solicitud}</li>`;
                    
                })
                
                lista += '</ul>';
                
                console.log(arregloDetalle);

                const datos = {
                    ncliente,
                    nombcliente,
                    correo,
                    correo2,
                    telefono,
                    arregloDetalle
                }
                
                console.log(datos);
                
                //return;
                
                Swal.fire({
                    title: '¿Deseas guardar las solicitudes seleccionadas?',
                    html: lista,
                    icon: 'question',
                    showCancelButton: true,
                    confirmButtonText: `Guardar`
                }).then((result) => {
                    /* Read more about isConfirmed, isDenied below */
                    if (result.isConfirmed) {
                        //Swal.fire('Guardado!', '', 'success')
                        $.ajax({
                            url: 'ajax/insertSolicitudesReclamo.php',
                            type: 'POST',
                            data: datos,
                            dataType:"json", 
                            success: function (data) {
                                Swal.fire(
                                  'Registrado!',
                                  'Se ha registrado correctamente la solicitud de reclamo',
                                  'success'
                                ).then((result) => {
                                  /* Read more about isConfirmed, isDenied below */
                                  if (result.isConfirmed) {
                                        window.location.href = "https://www.verismart.com.pe/verismart/reclamos.php";
                                  }
                                })
                            }
                        });
                    } 
                })
            })
        </script>
        
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                console.log(idCliente);
                if(idCliente != null){
                    cargarDatos(idCliente);
                }
                
            });
        </script>
        
        <script>
            function cargarDatos(idCliente){
                
                $.ajax({
                        url: 'ajax/findCliente_v2.php',
                        type: 'POST',
                        data: {idcli: idCliente},
                        dataType:"json", 
                        success: function (data) {
                            console.log(data);
                            const {NCliente, NombApellido, Correo, Correodos, Telefonouno} = data;
                            
                            $('#ncliente').val(NCliente);
                            $('#nombcliente').val(NombApellido);
                            $('#correo').val(Correo);
                            $('#correo2').val(Correodos);
                            $('#telefono').val(Telefonouno);
                        }
                    });
            }
            
            function controladorSolicitud(tipoSolicitud){
                console.log(tipoSolicitud);
                if(tipoSolicitud === "envioFacturas"){
                    $('.envioFacturas').removeClass('ocultar');
                    $('.registroTarjetas').addClass('ocultar');
                    $('.condonacion').addClass('ocultar');
                    $('.solicitudBaja').addClass('ocultar');
                    $('.solicitudReconexion').addClass('ocultar');
                    $('.traspasoSaldos').addClass('ocultar');
                    $('.clienteFallecido').addClass('ocultar');
                    $('.devolucionEquipos').addClass('ocultar');
                } else if(tipoSolicitud === "registroTarjeta"){
                    $('.envioFacturas').addClass('ocultar');
                    $('.registroTarjetas').removeClass('ocultar');
                    $('.condonacion').addClass('ocultar');
                    $('.solicitudBaja').addClass('ocultar');
                    $('.solicitudReconexion').addClass('ocultar');
                    $('.traspasoSaldos').addClass('ocultar');
                    $('.clienteFallecido').addClass('ocultar');
                    $('.devolucionEquipos').addClass('ocultar');
                }  else if(tipoSolicitud === "condonacion"){
                    $('.envioFacturas').addClass('ocultar');
                    $('.registroTarjetas').addClass('ocultar');
                    $('.condonacion').removeClass('ocultar');
                    $('.solicitudBaja').addClass('ocultar');
                    $('.solicitudReconexion').addClass('ocultar');
                    $('.traspasoSaldos').addClass('ocultar');
                    $('.clienteFallecido').addClass('ocultar');
                    $('.devolucionEquipos').addClass('ocultar');
                } else if(tipoSolicitud === "solicitudBaja"){
                    $('.envioFacturas').addClass('ocultar');
                    $('.registroTarjetas').addClass('ocultar');
                    $('.condonacion').addClass('ocultar');
                    $('.solicitudBaja').removeClass('ocultar');
                    $('.solicitudReconexion').addClass('ocultar');
                    $('.traspasoSaldos').addClass('ocultar');
                    $('.clienteFallecido').addClass('ocultar');
                    $('.devolucionEquipos').addClass('ocultar');
                } else if(tipoSolicitud === "solicitudReconexion"){
                    $('.envioFacturas').addClass('ocultar');
                    $('.registroTarjetas').addClass('ocultar');
                    $('.condonacion').addClass('ocultar');
                    $('.solicitudBaja').addClass('ocultar');
                    $('.solicitudReconexion').removeClass('ocultar');
                    $('.traspasoSaldos').addClass('ocultar');
                    $('.clienteFallecido').addClass('ocultar');
                    $('.devolucionEquipos').addClass('ocultar');
                } else if(tipoSolicitud === "traspasoSaldos"){
                    $('.envioFacturas').addClass('ocultar');
                    $('.registroTarjetas').addClass('ocultar');
                    $('.condonacion').addClass('ocultar');
                    $('.solicitudBaja').addClass('ocultar');
                    $('.solicitudReconexion').addClass('ocultar');
                    $('.traspasoSaldos').removeClass('ocultar');
                    $('.clienteFallecido').addClass('ocultar');
                    $('.devolucionEquipos').addClass('ocultar');
                } else if(tipoSolicitud === "clienteFallecido"){
                    $('.envioFacturas').addClass('ocultar');
                    $('.registroTarjetas').addClass('ocultar');
                    $('.condonacion').addClass('ocultar');
                    $('.solicitudBaja').addClass('ocultar');
                    $('.solicitudReconexion').addClass('ocultar');
                    $('.traspasoSaldos').addClass('ocultar');
                    $('.clienteFallecido').removeClass('ocultar');
                    $('.devolucionEquipos').addClass('ocultar');
                } else if(tipoSolicitud === "devolucionEquipos"){
                    $('.envioFacturas').addClass('ocultar');
                    $('.registroTarjetas').addClass('ocultar');
                    $('.condonacion').addClass('ocultar');
                    $('.solicitudBaja').addClass('ocultar');
                    $('.solicitudReconexion').addClass('ocultar');
                    $('.traspasoSaldos').addClass('ocultar');
                    $('.clienteFallecido').addClass('ocultar');
                    $('.devolucionEquipos').removeClass('ocultar');
                }
                else {
                    $('.envioFacturas').addClass('ocultar');
                    $('.registroTarjetas').addClass('ocultar');
                    $('.condonacion').addClass('ocultar');
                    $('.solicitudBaja').addClass('ocultar');
                    $('.solicitudReconexion').addClass('ocultar');
                }
            }
            
            function validarSolicitud(tipoSolicitud){
                console.log(tipoSolicitud);
                
                if(tipoSolicitud === '' || tipoSolicitud === null){
                    Swal.fire({
                      position: 'top-end',
                      icon: 'error',
                      title: 'Elegir tipo de solicitud de reclamo',
                      showConfirmButton: false,
                      timer: 1500
                    })
                    
                    return false;
                }
                
                return true;
            }
            
            function generarDetalle(){
                const envioFacturas = $('#envioFacturas').prop('checked');
                const registroTarjeta = $('#registroTarjeta').prop('checked');
                const formatoAfiliacion = $('#formatoAfiliacion').prop('checked');
                const cambioModalidadPagoCF = $('#cambioModalidadPagoCF').prop('checked');
                const Condonacion = $('#Condonacion').prop('checked');
                const solicitudBaja = $('#solicitudBaja').prop('checked');
                
                const estadoCuenta = $('#estadoCuenta').prop('checked');
                const EnvioCopiaContrato = $('#EnvioCopiaContrato').prop('checked');
                const CartaNoAdeudo = $('#CartaNoAdeudo').prop('checked');
                const solicitudReconexion = $('#solicitudReconexion').prop('checked');
                
                const traspasoSaldos_1 = $('#traspasoSaldos_1').prop('checked');
                const traspasoSaldos_2 = $('#traspasoSaldos_2').prop('checked');
                const traspasoSaldos_3 = $('#traspasoSaldos_3').prop('checked');
                const traspasoSaldos_4 = $('#traspasoSaldos_4').prop('checked');
                
                const clienteFallecido = $('#clienteFallecido').prop('checked');
                const devolucionEquipos = $('#devolucionEquipos').prop('checked');
                const facturacionAdelantada = $('#facturacionAdelantada').prop('checked');
                const actualizacionDatosCelCorreo = $('#actualizacionDatosCelCorreo').prop('checked');
                
                const traslado = $('#traslado').prop('checked');
                const incrementoCuotaIPC = $('#incrementoCuotaIPC').prop('checked');
                const solicitudCambioTitularidadconDeuda = $('#solicitudCambioTitularidadconDeuda').prop('checked');
                const solicitudCambioTitularidadsinDeudaMismoCliente = $('#solicitudCambioTitularidadsinDeudaMismoCliente').prop('checked');
                const solicitudCambioTitularidadsinDeudaDiferenteCliente = $('#solicitudCambioTitularidadsinDeudaDiferenteCliente').prop('checked');
                
                const reclamoServicio = $('#reclamoServicio').prop('checked');
                const reclamoComercial = $('#reclamoComercial').prop('checked');
                const reclamoFacturacion = $('#reclamoFacturacion').prop('checked');
                const reclamoMDP = $('#reclamoMDP').prop('checked');
                const reclamoIndecopiLegal = $('#reclamoIndecopiLegal').prop('checked');
                const reclamoGestionBaja = $('#reclamoGestionBaja').prop('checked');
                
                const reclamoDemoraDevDinero = $('#reclamoDemoraDevDinero').prop('checked');
                const reclamoOfertaNoAplica = $('#reclamoOfertaNoAplica').prop('checked');
                const reclamoDsctoFormaPagoAplicada = $('#reclamoDsctoFormaPagoAplicada').prop('checked');
                const reclamoVigenciaPaiTarifa = $('#reclamoVigenciaPaiTarifa').prop('checked');
                const reclamoErrorDatos = $('#reclamoErrorDatos').prop('checked');
                const reclamoCostoMonitoreo = $('#reclamoCostoMonitoreo').prop('checked');
                const reclamoErrorDatalleComprobante = $('#reclamoErrorDatalleComprobante').prop('checked');
                const reclamoCobroDoble = $('#reclamoCobroDoble').prop('checked');
                
                //AÑADIDO 25-08-2021
                const registroCompromisoPago = $('#registroCompromisoPago').prop('checked');
                const registroCompromisoPago_2 = $('#registroCompromisoPago_2').prop('checked');
                const registroCompromisoPago_3 = $('#registroCompromisoPago_3').prop('checked');
                const registroCompromisoPago_4 = $('#registroCompromisoPago_4').prop('checked');
                const CertificadoOperatividad = $('#CertificadoOperatividad').prop('checked');
                const Reubicaciondedispositivos = $('#Reubicaciondedispositivos').prop('checked');
                const No_retirar_beneficio_formapago = $('#No_retirar_beneficio_formapago').prop('checked');
                
                const CapacitaciondeServicio = $('#CapacitaciondeServicio').prop('checked');
                const Ampliaciones = $('#Ampliaciones').prop('checked');
                const CambiodecorreoBilling=$('#CambiodecorreoBilling').prop('checked');

                
                let arregloDatosSolicitud = [];
                let solicitud;
                
                if(envioFacturas){
                    solicitud = 'envioFacturas';
                    const factura1 = $('#factura1').val();
                    const factura2 = $('#factura2').val();
                    const factura3 = $('#factura3').val();
                    const factura4 = $('#factura4').val();
                    const factura5 = $('#factura5').val();
                    const factura6 = $('#factura6').val();
                    const factura7 = $('#factura7').val();
                    const factura8 = $('#factura8').val();
                    const factura9 = $('#factura9').val();
                    const factura10 = $('#factura10').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                            'columna1': factura1,
                            'columna2':factura2,
                            'columna3':factura3,
                            'columna4':factura4,
                            'columna5':factura5,
                            'columna6':factura6,
                            'columna7':factura7,
                            'columna8':factura8,
                            'columna9':factura9,
                            'columna10':factura10
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(registroTarjeta){
                    solicitud = 'registroTarjeta';
                    const ntarjeta = $('#ntarjeta').val();
                    const mesFV = $('#mesFV').val();
                    const añoFV = $('#añoFV').val();
                    const tipo = $('#tipo').val();
                    const banco = $('#banco').val();
                    
                    const TipoDocumento = $('#TipoDocumento').val();
                    const Documento = $('#Documento').val();
                    const nombreTitular = $('#nombreTitular').val();
                
                    if(ntarjeta == ''){
                        Swal.fire('Error', 'Por favor, ingresar número de tarjeta', 'error');
                        return false;
                    } else {
                        if(banco=='' || banco==null){
                            Swal.fire('Error', 'Por favor, ingresar Banco', 'error');
                            return false;
                        }
                        if(tipo=='' || tipo==null){
                            Swal.fire('Error', 'Por favor, tipo de Tarjeta', 'error');
                            return false;
                        }

                        if(ntarjeta.length <= 14 && ntarjeta.length > 16){
                            Swal.fire('Error', 'Por favor, verificar la cantidad de digitos de la tarjeta', 'error');
                            return false;
                        } 
                        
                        if(banco=='PE-VI' || banco=='PE-MC' || banco=='PE-AM' || banco=='PE-DC'){
                            if(añoFV=='' || añoFV==null){
                                Swal.fire('Error', 'Por favor, ingresar Año de vencimiento', 'error');
                                return false;
                            }                        
                            if(mesFV=='' || mesFV==null){
                                Swal.fire('Error', 'Por favor, ingresar Mes de vencimiento', 'error');
                                return false;
                            }
                        }                        

                        if(TipoDocumento=='' || TipoDocumento==null){
                            Swal.fire('Error', 'Por favor, ingresar Tipo Documento', 'error');
                            return false;
                        }
                        if(Documento=='' || Documento==null){
                            Swal.fire('Error', 'Por favor, ingresar Documento', 'error');
                            return false;
                        }
                        if(nombreTitular=='' || nombreTitular==null){
                            Swal.fire('Error', 'Por favor, ingresar Titular', 'error');
                            return false;
                        }                        


                        
                    }
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1':ntarjeta,
                        'columna2':mesFV,
                        'columna3':añoFV,
                        'columna4':tipo,
                        'columna5':banco,
                        'columna6':TipoDocumento,
                        'columna7':Documento,
                        'columna8':nombreTitular,
                        'columna9':'',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
            
                }
                
                if(formatoAfiliacion){
                    solicitud = 'formatoAfiliacion';
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': '',
                        'columna2':'',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(cambioModalidadPagoCF){
                    solicitud = 'cambioModalidadPagoCF';
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': '',
                        'columna2':'',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(Condonacion){
                    solicitud = 'Condonacion';
                    
                    const montoCondonar = $('#montoCondonar').val();
                    const campaña = $('#campaña').val();
                    const fechaPago = $('#fechaPago').val();
                    const mesCampaña = $('#mesCampaña').val();
                    const campaña__observacion = $('#campaña__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': montoCondonar,
                        'columna2': campaña,
                        'columna3': fechaPago,
                        'columna4': mesCampaña,
                        'columna5': campaña__observacion,
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(solicitudBaja){
                    solicitud = 'solicitudBaja';
                    
                    const SB__nombre = $('#SB__nombre').val();
                    const SB__motivoBaja = $('#SB__motivoBaja').val();
                    const SB__telefono = $('#SB__telefono').val();
                    const SB__observacion = $('#SB__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': SB__nombre,
                        'columna2': SB__motivoBaja,
                        'columna3': SB__telefono,
                        'columna4': SB__observacion,
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(estadoCuenta){
                    solicitud = 'estadoCuenta';
                    const estadoCuenta__observacion = $('#estadoCuenta__observacion').val();
                    
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': estadoCuenta__observacion,
                        'columna2':'',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(EnvioCopiaContrato){
                    solicitud = 'EnvioCopiaContrato';
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': '',
                        'columna2':'',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(CartaNoAdeudo){
                    solicitud = 'CartaNoAdeudo';
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': '',
                        'columna2':'',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(solicitudReconexion){
                    solicitud = 'solicitudReconexion';
                    
                    const SR__OBSERVACION = $('#SR__OBSERVACION').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': SR__OBSERVACION,
                        'columna2':'',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(traspasoSaldos_1){
                    solicitud = 'traspasoSaldos_1';
                    
                    const TS__facturainicial_1 = $('#TS__facturainicial_1').val();
                    const TS__facturafinal_1 = $('#TS__facturafinal_1').val();
                    const TS__monto_1 = $('#TS__monto_1').val();
                    const TS__fechapago_1 = $('#TS__fechapago_1').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': TS__facturainicial_1,
                        'columna2': TS__facturafinal_1,
                        'columna3': TS__monto_1,
                        'columna4': TS__fechapago_1,
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                if(traspasoSaldos_2){
                    solicitud = 'traspasoSaldos 2';
                    
                    const TS__facturainicial_2 = $('#TS__facturainicial_2').val();
                    const TS__facturafinal_2 = $('#TS__facturafinal_2').val();
                    const TS__monto_2 = $('#TS__monto_2').val();
                    const TS__fechapago_2 = $('#TS__fechapago_2').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': TS__facturainicial_2,
                        'columna2': TS__facturafinal_2,
                        'columna3': TS__monto_2,
                        'columna4': TS__fechapago_2,
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                if(traspasoSaldos_3){
                    solicitud = 'traspasoSaldos 3';
                    
                    const TS__facturainicial_3 = $('#TS__facturainicial_3').val();
                    const TS__facturafinal_3 = $('#TS__facturafinal_3').val();
                    const TS__monto_3 = $('#TS__monto_3').val();
                    const TS__fechapago_3 = $('#TS__fechapago_3').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': TS__facturainicial_3,
                        'columna2': TS__facturafinal_3,
                        'columna3': TS__monto_3,
                        'columna4': TS__fechapago_3,
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                if(traspasoSaldos_4){
                    solicitud = 'traspasoSaldos 4';
                    
                    const TS__facturainicial_4 = $('#TS__facturainicial_4').val();
                    const TS__facturafinal_4 = $('#TS__facturafinal_4').val();
                    const TS__monto_4 = $('#TS__monto_4').val();
                    const TS__fechapago_4 = $('#TS__fechapago_4').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': TS__facturainicial_4,
                        'columna2': TS__facturafinal_4,
                        'columna3': TS__monto_4,
                        'columna4': TS__fechapago_4,
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(clienteFallecido){
                    solicitud = 'clienteFallecido';
                    
                    const CF__observacion = $('#CF__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': CF__observacion,
                        'columna2':'',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(devolucionEquipos){
                    solicitud = 'devolucionEquipos';
                    
                    const DE__observacion = $('#DE__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': DE__observacion,
                        'columna2':'',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(facturacionAdelantada){
                    solicitud = 'facturacionAdelantada';
                    
                    const mesesFacturar = $('#mesesFacturar').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': mesesFacturar,
                        'columna2':'',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(actualizacionDatosCelCorreo){
                    solicitud = 'actualizacionDatosCelCorreo';
                    
                    const ADCC__Observacion = $('#ADCC__Observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': ADCC__Observacion,
                        'columna2':'',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(traslado){
                    solicitud = 'traslado';
                    
                    const T__observacion = $('#T__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': T__observacion,
                        'columna2':'',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(incrementoCuotaIPC){
                    solicitud = 'incrementoCuotaIPC';
                    
                    const ICIPC__observacion = $('#ICIPC__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': ICIPC__observacion,
                        'columna2':'',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(solicitudCambioTitularidadconDeuda){
                    solicitud = 'solicitudCambioTitularidadconDeuda';
                    
                    const SCTCD__observacion = $('#SCTCD__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': SCTCD__observacion,
                        'columna2':'',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(solicitudCambioTitularidadsinDeudaMismoCliente){
                    solicitud = 'solicitudCambioTitularidadsinDeudaMismoCliente';
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': '',
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(solicitudCambioTitularidadsinDeudaDiferenteCliente){
                    solicitud = 'solicitudCambioTitularidadsinDeudaDiferenteCliente';
                    
                    const SCTSDDC__observacion = $('#SCTSDDC__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': SCTSDDC__observacion,
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(reclamoServicio){
                    solicitud = 'reclamoServicio';
                    
                    const RS__observacion = $('#RS__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': RS__observacion,
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(reclamoComercial){
                    solicitud = 'reclamoComercial';
                    
                    const RC__observacion = $('#RC__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': RC__observacion,
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                /*
                if(reclamoFacturacion){
                    solicitud = 'reclamoFacturacion';
                    
                    const RF__observacion = $('#RF__observacion').val();
                    
                    const RF__errorDatos = $('#RF__errorDatos').prop('checked');
                    const RF__ofertanoaplicada = $('#RF__ofertanoaplicada').prop('checked');
                    const RF__descuentoformapago = $('#RF__descuentoformapago').prop('checked');
                    const RF__reclamoAmpliacionesFacturacion = $('#RF__reclamoAmpliacionesFacturacion').prop('checked');
                    
                    const val_RF__errorDatos = convertirOpcion(RF__errorDatos);
                    const val_RF__ofertanoaplicada = convertirOpcion(RF__ofertanoaplicada);
                    const val_RF__descuentoformapago = convertirOpcion(RF__descuentoformapago);
                    const val_RF__reclamoAmpliacionesFacturacion = convertirOpcion(RF__reclamoAmpliacionesFacturacion);
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': RF__observacion,
                        'columna2': val_RF__errorDatos,
                        'columna3': val_RF__ofertanoaplicada,
                        'columna4': val_RF__descuentoformapago,
                        'columna5': val_RF__reclamoAmpliacionesFacturacion,
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                
                if(reclamoMDP){
                    solicitud = 'reclamoMDP';
                    
                    const RMDP__observacion = $('#RMDP__observacion').val();
                    
                    const RMDP_reclamoDevolucionDinero = $('#RMDP_reclamoDevolucionDinero').prop('checked');
                    const RMDP_reclamoCargosDobles = $('#RMDP_reclamoCargosDobles').prop('checked');
                    
                    const val_RMDP_reclamoDevolucionDinero = convertirOpcion(RMDP_reclamoDevolucionDinero);
                    const val_RMDP_reclamoCargosDobles = convertirOpcion(RMDP_reclamoCargosDobles);
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': RMDP__observacion,
                        'columna2': val_RMDP_reclamoDevolucionDinero,
                        'columna3': val_RMDP_reclamoCargosDobles,
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                */
                
                if(reclamoIndecopiLegal){
                    solicitud = 'reclamoIndecopiLegal';
                    
                    const RII__observacion = $('#RII__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': RII__observacion,
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(reclamoGestionBaja){
                    solicitud = 'reclamoGestionBaja';
                    
                    const RGB__observaciones = $('#RGB__observaciones').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': RGB__observaciones,
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                //NUEVOS RECLAMOS
                if(reclamoDemoraDevDinero){
                    solicitud = 'reclamoDemoraDevDinero';
                    
                    const RDDD__observacion = $('#RDDD__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': RDDD__observacion,
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(reclamoOfertaNoAplica){
                    solicitud = 'reclamoOfertaNoAplica';
                    
                    const RONA__observacion = $('#RONA__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': RONA__observacion,
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(reclamoDsctoFormaPagoAplicada){
                    solicitud = 'reclamoDsctoFormaPagoAplicada';
                    
                    const RDFPA__observacion = $('#RDFPA__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': RDFPA__observacion,
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(reclamoVigenciaPaiTarifa){
                    solicitud = 'reclamoVigenciaPaiTarifa';
                    
                    const RVPT__observacion = $('#RVPT__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': RVPT__observacion,
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(reclamoErrorDatos){
                    solicitud = 'reclamoErrorDatos';
                    
                    const RED__observacion = $('#RED__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': RED__observacion,
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(reclamoCostoMonitoreo){
                    solicitud = 'reclamoCostoMonitoreo';
                    
                    const RCM__observacion = $('#RCM__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': RCM__observacion,
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(reclamoErrorDatalleComprobante){
                    solicitud = 'reclamoErrorDatalleComprobante';
                    
                    const REDC__observacion = $('#REDC__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': REDC__observacion,
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(reclamoCobroDoble){
                    solicitud = 'reclamoCobroDoble';
                    
                    const RCD__observacion = $('#RCD__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': RCD__observacion,
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                //FIN
                
                if(registroCompromisoPago){
                    solicitud = 'registroCompromisoPago';
                    const montocuota = $('#montocuota').val();
                    const facturainternacuota = $('#facturainternacuota').val();
                    const montoPAI = $('#montoPAI').val();
                    const facturainternaPAI = $('#facturainternaPAI').val();
                    const fechapagoCompromisoPago = $('#fechapagoCompromisoPago').val();
                    const bancoCompromisoPago = $('#bancoCompromisoPago').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1':montocuota,
                        'columna2':facturainternacuota,
                        'columna3':montoPAI,
                        'columna4':facturainternaPAI,
                        'columna5':fechapagoCompromisoPago,
                        'columna6':bancoCompromisoPago,
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
            
                }
                if(registroCompromisoPago_2){
                    solicitud = 'registroCompromisoPago_2';
                    const montocuota_2 = $('#montocuota_2').val();
                    const facturainternacuota_2 = $('#facturainternacuota_2').val();
                    const montoPAI_2 = $('#montoPAI_2').val();
                    const facturainternaPAI_2 = $('#facturainternaPAI_2').val();
                    const fechapagoCompromisoPago_2 = $('#fechapagoCompromisoPago_2').val();
                    const bancoCompromisoPago_2 = $('#bancoCompromisoPago_2').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1':montocuota_2,
                        'columna2':facturainternacuota_2,
                        'columna3':montoPAI_2,
                        'columna4':facturainternaPAI_2,
                        'columna5':fechapagoCompromisoPago_2,
                        'columna6':bancoCompromisoPago_2,
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
            
                }
                if(registroCompromisoPago_3){
                    solicitud = 'registroCompromisoPago_3';
                    const montocuota_3 = $('#montocuota_3').val();
                    const facturainternacuota_3 = $('#facturainternacuota_3').val();
                    const montoPAI_3 = $('#montoPAI_3').val();
                    const facturainternaPAI_3 = $('#facturainternaPAI_3').val();
                    const fechapagoCompromisoPago_3 = $('#fechapagoCompromisoPago_3').val();
                    const bancoCompromisoPago_3 = $('#bancoCompromisoPago_3').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1':montocuota_3,
                        'columna2':facturainternacuota_3,
                        'columna3':montoPAI_3,
                        'columna4':facturainternaPAI_3,
                        'columna5':fechapagoCompromisoPago_3,
                        'columna6':bancoCompromisoPago_3,
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
            
                }
                if(registroCompromisoPago_4){
                    solicitud = 'registroCompromisoPago_4';
                    const montocuota_4 = $('#montocuota_4').val();
                    const facturainternacuota_4 = $('#facturainternacuota_4').val();
                    const montoPAI_4 = $('#montoPAI_4').val();
                    const facturainternaPAI_4 = $('#facturainternaPAI_4').val();
                    const fechapagoCompromisoPago_4 = $('#fechapagoCompromisoPago_4').val();
                    const bancoCompromisoPago_4 = $('#bancoCompromisoPago_4').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1':montocuota_4,
                        'columna2':facturainternacuota_4,
                        'columna3':montoPAI_4,
                        'columna4':facturainternaPAI_4,
                        'columna5':fechapagoCompromisoPago_4,
                        'columna6':bancoCompromisoPago_4,
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
            
                }
                if(CertificadoOperatividad){
                    solicitud = 'CertificadoOperatividad';
                    
                    const CertificadoOperatividad__observacion = $('#CertificadoOperatividad__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': CertificadoOperatividad__observacion,
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }                
                if(Reubicaciondedispositivos){
                    solicitud = 'Reubicaciondedispositivos';
                    
                    const Reubicaciondedispositivos__observacion = $('#Reubicaciondedispositivos__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': Reubicaciondedispositivos__observacion,
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                
                if(No_retirar_beneficio_formapago){
                    solicitud = 'No_retirar_beneficio_formapago';
                    
                    const No_retirar_beneficio_formapago__observacion = $('#No_retirar_beneficio_formapago__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': No_retirar_beneficio_formapago__observacion,
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }                
                if(CapacitaciondeServicio){
                    solicitud = 'CapacitaciondeServicio';
                    
                    const CapacitaciondeServicio__observacion = $('#CapacitaciondeServicio__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': CapacitaciondeServicio__observacion,
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                if(Ampliaciones){
                    solicitud = 'Ampliaciones';
                    
                    const Ampliaciones__observacion = $('#Ampliaciones__observacion').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': Ampliaciones__observacion,
                        'columna2': '',
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }
                if(CambiodecorreoBilling){
                    solicitud = 'CambiodecorreoBilling';
                    
                    const email1 = $('#email1').val();
                    const email2 = $('#email2').val();
                    
                    datos = {
                        solicitud,
                        detalle: {
                        'columna1': email1,
                        'columna2': email2,
                        'columna3': '',
                        'columna4': '',
                        'columna5': '',
                        'columna6': '',
                        'columna7': '',
                        'columna8': '',
                        'columna9': '',
                        'columna10': ''
                        }
                    };
                    
                    arregloDatosSolicitud = [...arregloDatosSolicitud, datos];
                }                
 
                return arregloDatosSolicitud;
            }
            
            function convertirOpcion(input){
                if(input){
                    return 'SI';
                } else {
                    return 'NO';
                }
            }
        </script>

    </body>

</html>