<?php
session_start();
if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
        }


if ($_SESSION['pzcallrpporasignar']==0) {
     header("location: ./denegado.php");
		exit;
        }

date_default_timezone_set('America/Lima');
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

include 'config/db.php';
include 'config/conexion.php';
include 'helper/helper_validacion.php';

if (isset($_GET['idprospectorp'])) {
    $idprospectorp = sanitizaCampo($_GET['idprospectorp'], 'sanitizeint|scapestring|htmlspecialchars', $con);
    $idprospectorp = htmlspecialchars($idprospectorp);
} else {
    	header("location: ./denegado.php");
    	exit;
}

if (isset($_GET['tipo'])) {
    $tipo = htmlspecialchars($_GET['tipo']);
} else {
    $tipo = '';
}


if (isset($_GET['rc'])) {
    $rc=htmlspecialchars($_GET['rc']);  
}else{
    $rc="";  
}



    try{
        $stmt = $con->prepare( "SELECT 
   u.IdUsuario,
    p.Matricula,
    p.Comercial,
    p.CC,
    p.JefeVenta,
    CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta,
    p.EstadoProspecto,
    p.EstadoVenta,
    p.CategoriaVenta,
    p.TipoVenta,
    p.Segmento,
    p.MesesAutorizado,
    p.NProspecto,
    p.IdCliente,
    c.NombApellido Cliente,
    c.Correo,
    c.Telefonouno,
    c.Telefonodos,
    c.Direccion,
    DATE_FORMAT(p.FechaVisitaRP,'%d/%m/%Y') FechaVisitaRP,
	TIME_FORMAT(p.HoraVisitaRP,'%r') HoraVisitaRP,
    p.MesVisitaRP,
    g.IdGeografico,
    g.Distrito,
    g.Provincia,
    p.PrecioKit,
    p.TotalExtra,
    p.ResumenProspecto,
    p.ExtraAutorizado,
    p.FormaPago,
    p.PAI,
    p.N590,
    p.ComentarioProspectoRP,
    p.ComentarioCallRP,
    p.ComentarioVisita,
    p.GestorContactRP,
    p.CheckinRP,
    u.Estado,
    p.FechaGestion
FROM dbVENTAS.tblprospectorp p
LEFT JOIN dbUSUARIO.tblusuario u on p.IdUsuario=u.IdUsuario 
LEFT JOIN dbUSUARIO.tblarea a on a.IdArea=u.IdArea 
LEFT JOIN dbUSUARIO.tblusuario m on m.Matricula=u.Manager
INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=p.IdCliente
INNER JOIN dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
WHERE p.IdProspectoRP=?");
        $stmt->bind_param('i', $idprospectorp);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($idu,
$matricula,
$comercial,
$dc,
$matjefe,
$jefeventa,
$estadoprospecto,
$estadoventa,
$categoriaventa,
$tipoventa,
$segmento,
$mesesautorizados,
$nprospecto,
$idcliente,
$cliente,
$correo,
$movil,
$fijo,
$direccion,
$fvisita,
$hvisita,
$mesvisita,
$idgeografico,
$distrito,
$provincia,
$preciokit,
$totalextra,
$resumenventa,
$regaloutorizado,
$formadepago,
$PAI,
$n590,
$comentarioprospecto,
$comentariocallrp,
$comentariovisita,
$gestorcontactrp,
$CheckinRP,
$EstadoComercial,
$FechaGestion);
        $stmt->fetch();

        $lninstalador="";
        $idagenda="";
        $instaladox="";
        $matriculatec="";
        $nomreinstalador="";
        $fechainstalacionver="";
        $horainstalacionver="";
        $comentarioagenda='';
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }


    $html=NULL;
    try {
        
    $stmtJE = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) JefeVenta FROM dbUSUARIO.tblusuario u  where u.CC=? AND u.LN='11' AND (u.Categoria ='JE' OR u.Categoria ='COACH' OR u.Categoria ='DEL' or u.Categoria='JE/DEL' or u.Categoria='GERENTE TERRITORIAL') LIMIT 50");
    $stmtJE->bind_param('i', $dc);
    $stmtJE->execute();
    $stmtJE->store_result();
    $stmtJE->bind_result($MatriculaJE,$JefeVentaJE);

    if($stmtJE->num_rows>0){
        while( $row = $stmtJE->fetch()){
            if($MatriculaJE==$matjefe){
               $html .= '<option value="'.$MatriculaJE.'" selected>'.$MatriculaJE.' - '.utf8_encode($JefeVentaJE).' </option>';
            }else{
               $html .= '<option value="'.$MatriculaJE.'">'.$MatriculaJE.' - '.utf8_encode($JefeVentaJE).' </option>';            
            }       
        }
    }else{
        $html .= '<option>No se encontraron resultado</option>';
    }
    
    $stmtJE->close();
 
    } catch (\Exception $e) {
      
    }

$html_tecnico=NULL;
if($lninstalador=="" || empty($lninstalador)){
$html_tecnico.= '<option></option>';
}else{

    try {
        
    $stmtTecnico = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Instalador FROM dbUSUARIO.tblusuario u INNER JOIN dbUSUARIO.tblarea a on a.IdArea=u.IdArea");
    $stmtTecnico->execute();
    $stmtTecnico->store_result();
    $stmtTecnico->bind_result($MatriculaTEC,$InstaladorTEC);

    if($stmtTecnico->num_rows>0){
        while( $row = $stmtTecnico->fetch()){
            if($MatriculaTEC==$matriculatec){
               $html_tecnico .= '<option value="'.$MatriculaTEC.'" selected>'.$MatriculaTEC.' - '.utf8_encode($InstaladorTEC).' </option>';
            }else{
               $html_tecnico .= '<option value="'.$MatriculaTEC.'">'.$MatriculaTEC.' - '.utf8_encode($InstaladorTEC).' </option>';            
            }       
        }
    }else{
        $html_tecnico .= '<option>No se encontraron resultado</option>';
    }
    
    $stmtTecnico->close();
 
    } catch (\Exception $e) {
      
    }

}



?>


<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
       <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
 

        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">

      
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->

        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
 <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
 
 <link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css"/>
  <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
        
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>
  
 
        <style>


             .lblverllamada{
                display:none;
            }
            .lblvermotivonoaceptavisita{
                display:none;
            }
            .lblver590{
                 display:none;
            }

            .modal-header-danger {
                color:#fff;
                background-color: #e4002b;              
            }


            .preloader{
                background-color:#FFF;
                width: 100%;
                height: 100%;
                position: absolute;
                z-index: 1;
            }

            .dataTables_wrapper .myfilter .dataTables_filter{float:left}
            .dataTables_wrapper .mylength .dataTables_length{float:right}
            div.dataTables_scrollBody thead th {
                vertical-align: top;
            } 
            td {
                max-width: 250px;
                overflow: hidden;
                white-space: nowrap;
                text-overflow: ellipsis;

            }
            .espacio{
                height:10px;
            }
            
           .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }


            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #frmEditarVenta .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: auto;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 200%;

            }
            #slider section{
                width: 100%;
            }


            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;font-size: 12px;
                padding:4px 6px;
            }

            .btn-nuevo { 
                color: #FFFFFF; 
                background-color: #444444; 
                border-color: #444444; 
            } 

            .btn-nuevo:hover, 
            .btn-nuevo:focus, 
            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                color: #FFFFFF; 
                background-color: #616161;  
                border-color: #444444; 
            } 

            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                background-image: none; 
            } 

            .btn-nuevo.disabled, 
            .btn-nuevo[disabled], 
            fieldset[disabled] .btn-nuevo, 
            .btn-nuevo.disabled:hover, 
            .btn-nuevo[disabled]:hover, 
            fieldset[disabled] .btn-nuevo:hover, 
            .btn-nuevo.disabled:focus, 
            .btn-nuevo[disabled]:focus, 
            fieldset[disabled] .btn-nuevo:focus, 
            .btn-nuevo.disabled:active, 
            .btn-nuevo[disabled]:active, 
            fieldset[disabled] .btn-nuevo:active, 
            .btn-nuevo.disabled.active, 
            .btn-nuevo[disabled].active, 
            fieldset[disabled] .btn-nuevo.active { 
                background-color: #444444; 
                border-color: #444444; 
            } 
            

input[type=number]::-webkit-outer-spin-button,

input[type=number]::-webkit-inner-spin-button {

    -webkit-appearance: none;

    margin: 0;

}

 

input[type=number] {

    -moz-appearance:textfield;

}
        </style>
        
        <style>
       .main-header,.main-sidebar,.left-side{position:fixed}
       
      .main-header {
    top: 0;
    right: 0;
    left: 0
}
 .content-wrapper,
 .right-side {
    padding-top: 50px
}

@media (max-width:767px) {
     .content-wrapper,
     .right-side {
        padding-top: 100px
    }
}

.layout-boxed .wrapper {
    max-width: 100%
}

.wrapper {
    overflow: hidden

 .control-sidebar {
    position: fixed;
    height: 100%;
    overflow-y: auto;
    padding-bottom: 50px
}       
        
        

  </style>
     
       
       
        <style>
            

.ui-autocomplete {
    position: absolute;
    z-index: 1000;
    cursor: default;
    padding: 0;
    margin-top: 2px;
    list-style: none;
    font-size: 11px;
    font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
    background-color: #ffffff;
    border: 1px solid #ccc;
    -webkit-border-radius: 5px;
       -moz-border-radius: 5px;
            border-radius: 5px;
    -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
       -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
            box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
            
        z-index: 1051 !important;    
            
}





   hr {
  height: 4px;
  width: 100%;
  background-color: #ecf0f5;

}



hr {
    /* margin-top: 20px; */
    margin-bottom: 20px;
    border: 0;
    /* border-top: 1px solid #eee; */
}


hr {
    display: block;
    unicode-bidi: isolate;
    -webkit-margin-before: 0.5em;
    -webkit-margin-after: 0.5em;
    -webkit-margin-start: auto;
    -webkit-margin-end: auto;
    overflow: hidden;
    border-style: inset;
   
}

.box.box-custom {
    border-top-color: #ffffff;
}

.box {
    position: relative;
    border-radius: 3px;
    background: #ffffff;
    border-top: 3px solid #d2d6de;
    margin-bottom: 5px;
    width: 100%;
    box-shadow: 0 1px 1px rgba(0,0,0,0.1);
}

        </style>
        
        
    </head>

    <body class="sidebar-collapse skin-red sidebar-mini">
        <input type="hidden" id="tipoEntrada" name="tipoEntrada" value="<?php echo $tipo; ?>">
        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php
            $callrp="active";
            include 'admin/main-sidebar.php';
            ?>
            <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        RPTMK
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li class="active">Editar RPTMK</li>
                    </ol>
                  </section>
                <!-- Main content -->
                <section class="content">
                        <div class="row">
                            <div class="col-md-2"></div>
                            <div class="col-md-8">
                                <!-- /.box-header -->
                                <div class="box box-danger">
                                    <div class="box-header">
                                        <table  style="width:90%;">
                            
                                                                <tr>
                                                                    <td style="width: 7%;">
                            
                            
                            
                                             
                                                                                  
                                          <h3 class="box-title cattitle">
                            
                                                                <?php 
                                                                                                        if ($categoriaventa == "ProspectoRP"){
                                                                                                            $nombc="NUEVO PROSPECTO RP - ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "Ficha"){
                                                                                                            $nombc="VENTA ONLINE - ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "Online"){
                                                                                                            $nombc="VENTA FICHA - ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "Delegacion"){
                                                                                                            $nombc="VENTA DELEGACIÓN - ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "NoVendida"){
                                                                                                            $nombc="NO VENDIDA - ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "Cancelada"){
                                                                                                            $nombc="CANCELADA - ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "VisitaAceptada"){
                                                                                                            $nombc="VISITA ACEPTADA RP - ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "NoAceptaVisita"){
                                                                                                            $nombc="NO ACEPTA VISITA - ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "NoContesta"){
                                                                                                            $nombc="NO CONTESTA - ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "DevolverLlamada"){
                                                                                                            $nombc="DEVOLVER LLAMADA - ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "ClienteError"){
                                                                                                            $nombc="CLIENTE ERROR - ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "TelefonoError"){
                                                                                                            $nombc="TELEFONO ERROR - ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "ZSCC"){
                                                                                                            $nombc="ZSCC - ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "Provincia"){
                                                                                                            $nombc="POR PROVINCIA - ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "Inviable"){
                                                                                                            $nombc="INVIABLE - ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "Rechazada"){
                                                                                                            $nombc="RECHAZADA - ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "VRPAsignada"){
                                                                                                            $nombc="VISITA ASIGNADA RP - ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "ClienteVerisure"){
                                                                                                            $nombc="CLIENTE VERISURE - ".$idprospectorp;       
                                                                                                        }else if($categoriaventa == "AnuladaOP"){
                                                                                                            $nombc="ANULADA POR OPERADOR- ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "AnuladaCLI"){
                                                                                                            $nombc="ANULADA POR CLIENTE- ".$idprospectorp;
                                                                                                        }else if($categoriaventa == "AnuladaTEC"){
                                                                                                            $nombc="ANULADA POR TÉCNICO- ".$idprospectorp;
                                                                                                        }else{
                                                                                                            $nombc="";
                                                                                                        }
                                                                                                         echo $nombc; ?></h3>
                            
                            
                                         <input id="lblcat" name="lblcat" value="<?php echo $categoriaventa;?>" hidden="">
                            
                            
                                            </td>
                                                                    
                                                                    
                                                </tr>
                                        </table>
                                        <div class="box-tools pull-right">
                                                <a class="btn btn-default btn-sm" id="ModEnviar" name="ModEnviar"><i class="fa fa-envelope"></i> Descargar</a>
                                                <a download="message.eml" id="downloadlink" class="btn btn-nuevo" style="display: none">Descargar</a>
                                                <?php if($estadoventa=='Facturada' || $nombacceso=='test' || $categoriaventa=='Ficha' || $categoriaventa=='Online' || $categoriaventa=='Delegacion' || $categoriaventa== 'NoVendida'  ){
                                                 }else{ ?>
                                                    <a class="btn btn-nuevo btn-sm" id="btnGuardarEditarVenta" href="#"><i class="fa fa-save"></i></a>
                                               <?php   }
                                               
                                                if($EstadoComercial=='Activo'){ 
                                               ?>
                                                    <a href="callrpgestionados.php" class="btn btn-danger btn-sm" ><i class="fa fa-reply"></i> </a>
                                                <?php }else if($rc=='ex'){
                                                 ?>   
                                                 <a href="asignarvisita.php" class="btn btn-danger btn-sm" ><i class="fa fa-reply"></i> </a>
                                               <?php }else { ?>
                                                    <a href="callrpporasignar.php" class="btn btn-danger btn-sm" ><i class="fa fa-reply"></i> </a>
                                                <?php } ?>
                                        </div>
                                    </div>
                                    <div class="espacio"></div>
                                </div>
                                <form id="frmEditarVenta" method="POST">
                                    <input id="lblidprospectorp" name="lblidprospectorp" value="<?php echo $idprospectorp;?>" hidden=""> 
                                    <!-- DIV INFORMACION CLIENTE -->
                                    <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                       <h5>INFORMACION DEL PROSPECTO</h5>
                            
                                      <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                        
                                      </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                                                                        
                                                                                        <table cellspacing="0"  style="width:100%;border-collapse: separate;padding: 20px;" >
                                                                                            <?php if ($tipo <> 'porasignar') { ?>
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">CHECK-IN:</td>
                                                                                                <td style="width:25%;">
                                                                                                    <input type="checkbox" name="checki" id="checki" <?php if($CheckinRP=="SI"){echo 'checked';}else{echo '';}?> data-size="small">
                                                                                                    <input type="hidden" name="hidden_checki" id="hidden_checki" value="<?php echo $CheckinRP; ?>">
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px"></td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"></td>
                                                                                            </tr> 
                                                                                            <tr class="espacio"></tr>
                                                                                            <?php } ?>
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">MATRICULA: <span style="color:red"> * </span></td>
                                                                                                <td style="width:25%;">
                                                                                                    <?php if ($EstadoComercial == 'Activo') { ?>
                                                                                                     <div class="input-group">
                                                                                                        <span class="input-group-addon" style="color: green" title="ACTIVO"><i class="fa fa-check"></i></span>
                                                                                                        <input name="lblmatricula" id="lblmatricula" class="form-control input-sm" value="<?php echo $matricula;?>" style="width: 100%;" readonly="readonly">
                                                                                                        <input id="lblidusuario" name="lblidusuario" value="<?php echo $idu;?>" hidden=""> 
                                                                                                    </div>
                                                                                                    <?php } else { ?>
                                                                                                    <div class="input-group">
                                                                                                        <span class="input-group-addon" style="color: red" title="CESADO"><i class="fa fa-exclamation"></i></span>
                                                                                                        <input name="lblmatricula" id="lblmatricula" class="form-control input-sm" value="<?php echo $matricula;?>" style="width: 100%;" readonly="readonly">
                                                                                                        <input id="lblidusuario" name="lblidusuario" value="<?php echo $idu;?>" hidden=""> 
                                                                                                    </div>
                                                                                                    <?php } ?>
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">COMERCIAL: <span style="color:red"> * </span></td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"><input name="lblnombcomercial" id="lblnombcomercial" class="form-control input-sm" style="width: 100%;" value="<?php echo $comercial;?>" readonly="readonly" disabled></td>
                                                                                            </tr>
                                                                                            <tr class="espacio"></tr>
                                                                                           <tr>
                                                                                                <td style="width:15%;font-size: 12px">DC: <span style="color:red"> * </span></td>
                            
                                                                                                <td style="width:25%;">
                                                                                                 <select class="form-control input-sm" name="lbldc" id="lbldc" style="width: 100%;" readonly="readonly" disabled>
                                                        <?php if ($dc == "150") { ?>
														<option value="150" <?php if ($dc == "150") {
															echo "selected";
															} ?>>150</option>
														<?php } else if ($dc == "151") { ?>
														<option value="151" <?php if ($dc == "151") {
															echo "selected";
															} ?>>151</option>
														<?php } else if ($dc == "152") { ?>
														<option value="152" <?php if ($dc == "152") {
															echo "selected";
															} ?>>152</option>
														<?php } else if ($dc == "153") { ?>
														<option value="153" <?php if ($dc == "153") {
															echo "selected";
															} ?>>153</option>
														<?php } else if ($dc == "154") { ?>
														<option value="154" <?php if ($dc == "154") {
															echo "selected";
															} ?>>154</option>
														<?php } else if ($dc == "155") { ?>
														<option value="155" <?php if ($dc == "155") {
															echo "selected";
															} ?>>155</option>
														<?php } else if ($dc == "156") { ?>
														<option value="156" <?php if ($dc == "156") {
															echo "selected";
															} ?>>156</option>
														<?php } else if ($dc == "157") { ?>
														<option value="157" <?php if ($dc == "157") {
															echo "selected";
															} ?>>157</option>
														<?php } else if ($dc == "158") { ?>
														<option value="158" <?php if ($dc == "158") {
															echo "selected";
															} ?>>158</option>
														<?php } else if ($dc == "159") { ?>
														<option value="159" <?php if ($dc == "159") {
															echo "selected";
															} ?>>159</option>
														<?php } else if ($dc == "200") { ?>
														<option value="200" <?php if ($dc == "200") {
															echo "selected";
															} ?>>200</option>
														<?php } else if ($dc == "140") { ?>
														<option value="140" <?php if ($dc == "140") {
															echo "selected";
															} ?>>140</option>
														<?php } else if ($dc == "141") { ?>
														<option value="141" <?php if ($dc == "141") {
															echo "selected";
															} ?>>141</option>
														<?php } else if ($dc == "121") { ?>
														<option value="121" <?php if ($dc == "121") {
															echo "selected";
															} ?>>121</option>
														<?php } else if ($dc == "80") { ?>
														<option value="80" <?php if ($dc == "80") {
															echo "selected";
															} ?>>80</option>
														<?php } else if ($dc == "250") { ?>
														<option value="250" <?php if ($dc == "250") {
															echo "selected";
															} ?>>250</option>
														<?php } else if ($dc == "251") { ?>
														<option value="251" <?php if ($dc == "251") {
															echo "selected";
															} ?>>251</option>
														<?php } else if ($dc == "120") { ?>
														<option value="120" <?php if ($dc == "120") {
															echo "selected";
															} ?>>120</option>
														<?php } else if ($dc == "100") { ?>
														<option value="100" <?php if ($dc == "100") {
															echo "selected";
															} ?>>100</option>
														<?php } else if ($dc == "40") { ?>
														<option value="40" <?php if ($dc == "40") {
															echo "selected";
															} ?>>40</option>
														<?php } else if ($dc == "41") { ?>
														<option value="41" <?php if ($dc == "41") {
															echo "selected";
															} ?>>41</option>
														<?php } else if ($dc == "42") { ?>
														<option value="42" <?php if ($dc == "42") {
															echo "selected";
															} ?>>42</option>
														<?php } else if ($dc == "511") { ?>
														<option value="511" <?php if ($dc == "511") {
															echo "selected";
															} ?>>511</option>
														<?php } else if ($dc == "512") { ?>
														<option value="512" <?php if ($dc == "512") {
															echo "selected";
															} ?>>512</option>
														<?php } else if ($dc == "513") { ?>
														<option value="513" <?php if ($dc == "513") {
															echo "selected";
															} ?>>513</option>
														<?php } else if ($dc == "500") { ?>
														<option value="500" <?php if ($dc == "500") {
															echo "selected";
															} ?>>500</option>
														<?php } else if ($dc == "599") { ?>
														<option value="599" <?php if ($dc == "599") {
															echo "selected";
															} ?>>599</option>
														<?php } else if ($dc == "252") { ?>
														<option value="252" <?php if ($dc == "252") {echo "selected";}?>>252</option>
														<?php } else if ($dc == "20") { ?>
														<option value="20" <?php if ($dc == "20") {echo "selected";}?>>20</option>

														<?php } else if ($dc == "601") { ?>
														<option value="601" <?php if ($dc == "601") {echo "selected";}?>>601</option>
														<?php } else if ($dc == "602") { ?>
														<option value="602" <?php if ($dc == "602") {echo "selected";}?>>602</option>														
														<?php } else if ($dc == "701") { ?>
														<option value="701" <?php if ($dc == "701") {echo "selected";}?>>701</option>
														<?php } else if ($dc == "702") { ?>
														<option value="702" <?php if ($dc == "702") {echo "selected";}?>>702</option>
														<?php } else if ($dc == "901") { ?>
														<option value="901" <?php if ($dc == "901") {echo "selected";}?>>901</option>														

														<?php } else if ($dc == "130") { ?>
														<option value="130" <?php if ($dc == "130") {echo "selected";}?>>130</option>	
														<?php } else if ($dc == "230") { ?>
														<option value="230" <?php if ($dc == "230") {echo "selected";}?>>230</option>
														<?php } else if ($dc == "60") { ?>
														<option value="60" <?php if ($dc == "60") {echo "selected";}?>>60</option>														
														
														<?php } else { ?>
														<option value="" selected></option>
														<?php } ?>
                                                                                                        
                                                                                                        
                            
                                                                                                   </select></td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">JEFE VENTA: <span style="color:red"> * </span></td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%">
                                                                                                
                                                                                                    <select class="form-control input-sm" name="lbljefeventa" id="lbljefeventa" style="width: 100%;" readonly="readonly" disabled>
                                                                                                        <?php echo $html;?>
                                                                                                    </select>
                                                                                            </tr>
                                                                                            
                            <tr class="espacio"></tr>
                                         <tr>
                                                                                                <td style="width:15%;font-size: 12px">CLIENTE: <span style="color:red"> * </span></td>
                            
                                                                                                <td style="width:25%;"><input name="lblnombcliente" class="form-control input-sm" id="lblnombcliente" value="<?php echo $cliente;?>" style="width: 100%;"/></td>
                                                                                                 <input id="lblidcliente" name="lblidcliente" value="<?php echo $idcliente;?>" hidden="">
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">CORREO: <span style="color:red"> * </span></td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"><input type="text"  class="form-control input-sm" id="lblcorreo" value="<?php echo $correo;?>" name="lblcorreo"></td>
                                                                                            </tr>
                                                                                          
                                                                                            <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">DIRECCIÓN: <span style="color:red"> * </span>:</td>
                            
                                                                                                <td colspan="3" style="width:50%"><textarea class="form-control input-sm" name="lbldireccion" id="lbldireccion" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $direccion;?></textarea></td>
                            
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"><select class="form-control selectdistrito input-sm" name="lbldistrito" id="lbldistrito" style="width: 100%;">
                                                                                                    <option value="<?php echo $idgeografico; ?>"><?php echo $distrito.' - '.$provincia; ?></option>
                                                                                                    </select></td>
                                                                                            </tr> 
                                                                                            <tr class="espacio"></tr>
                                                                                            <tr>
                                                                                                <td style="width:15%;font-size: 12px">TELEFONO UNO: <span style="color:red"> * </span></td>
                            
                                                                                                <td style="width:25%"><input type="tel" class="form-control input-sm" name="lblmovil" id="lblmovil" value="<?php echo $movil;?>"  data-inputmask='"mask": "999999999"'  data-mask disabled>
                                                                                                </td>
                                                                                                <td style="width:10%"></td>
                                                                                                <td style="width:15%;font-size: 12px">TELEFONO DOS:</td>
                                                                                                <td style="width:2%"></td>
                                                                                                <td style="width:25%"><input type="tel" class="form-control input-sm" name="lblfijo" id="lblfijo" value="<?php echo $fijo;?>" data-inputmask='"mask": "999999999"'  data-mask>
                                                                                                </td>
                                                                                            </tr> 
                            
                                                                                        </table>
                                    </div>
                                    <!-- /.box-body -->
                            
                                  </div>
                                    <!-- DIV INFORMACION CALL RP -->
                                    <div class="box box-custom">
                                    <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                       <h5>INFORMACION DE RPTMK</h5>
                            
                                      <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                        
                                      </div>
                                    </div>
                                    <!-- /.box-header -->
                                    <div class="box-body">
                                        <table cellspacing="0"  style="width:100%;border-collapse: separate;padding: 20px;">
                                            <tr>
                                                <td style="width:15%;font-size: 12px">GESTOR BACKOFFICE RP:</td>
                                                <td style="width:25%"><input name="lblgestorbackofficerp" class="form-control input-sm" id="lblgestorbackofficerp" value="<?php echo $matriculausuario." - ".$nombreusuario;?>" style="width: 100%;" readonly="readonly"/>
                                                                      <input name="lblmatgestorbackofficerp" id="lblmatgestorbackofficerp" value="<?php echo $matriculausuario;?>" hidden="">
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px"></td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                </td>
                                            </tr>
                                             <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">GESTOR CONTACT RP:</td>
                                                <?php
                                                
                                                $sqlcontact = "SELECT DISTINCT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) GestorContact FROM dbUSUARIO.tblusuario u  where u.Matricula='".$gestorcontactrp."' LIMIT 1"; 
$resultcontact = mysqli_query($con, $sqlcontact);

if (mysqli_num_rows($resultcontact)> 0) {
    while ($rowge = mysqli_fetch_assoc($resultcontact)) {                
               $Matriculagest=$rowge['Matricula'];
               $nombregest=$rowge['GestorContact'];
}
}
                                                
                                                ?>
                                                <td style="width:25%"><input name="lblgestorcontactrp" class="form-control input-sm" id="lblgestorcontactrp" value="<?php echo $Matriculagest." - ".$nombregest;?>" style="width: 100%;" readonly="readonly"/>
                                                <input type="hidden" name="lblgestorcontactrpOriginal" id="lblgestorcontactrpOriginal" value="<?php echo $Matriculagest; ?>"
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">RECURSO: <span style="color:red"> * </span></td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"> <input type="text" class="form-control pull-right input-sm" id="lbltiventa"  name="lbltiventa" value="RPTMK" readonly="readonly">
                                                </td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">ESTADO DE PROSPECTO: <span style="color:red"> * </span></td>
                                                <td style="width:25%;"><select name="lblestadoprospecto" id="lblestadoprospecto" class="form-control input-sm">
                                                        <?php
                                                         if ($estadoprospecto == "ProspectoRP"){
                                                        ?>
                                                        <option value="ProspectoRP"<?php if ($estadoprospecto == "ProspectoRP") {echo "selected";}?> hidden="" disabled="disabled">ProspectoRP</option>
                                                        <option value="VisitaAceptada">Visita Aceptada</option>
                                                        <option value="NoAceptaVisita">No Acepta Visita</option>
                                                        <option value="NoContesta">No Contesta</option>
                                                        <option value="DevolverLlamada">Devolver Llamada</option>
                                                        <option value="ClienteError">Cliente Error</option>
                                                        <option value="TelefonoError">Telefono Error</option>
                                                        <option value="ZSCC">ZSCC</option>
                                                        <option value="Provincia">Provincia</option>
                                                        <option value="Inviable">Inviable</option>
                                                        <option value="Rechazada">Rechazada</option>
                                                        <option value="ClienteVerisure">Cliente Verisure</option>
                                                        <?php
                                                         }
                                                        if ($estadoprospecto == "NoAceptaVista" || $estadoprospecto == "NoContesta" ||
                                                        $estadoprospecto == "DevolverLlamada" || $estadoprospecto == "ClienteError" || $estadoprospecto == "TelefonoError" || $estadoprospecto == "ZSCC" || 
                                                        $estadoprospecto == "Provincia" || $estadoprospecto == "Inviable" || $estadoprospecto == "Rechazada" || $estadoprospecto=="ClienteVerisure"  ){
                                                        ?>
                                                        <option value="NoAceptaVisita" <?php if ($estadoprospecto == "NoAceptaVisita") {echo "selected";}?>>No Acepta Visita</option>
                                                        <option value="NoContesta" <?php if ($estadoprospecto == "NoContesta") {echo "selected";}?>>No Contesta</option>
                                                        <option value="DevolverLlamada" <?php if ($estadoprospecto == "DevolverLlamada") {echo "selected";}?>>Devolver Llamada</option>
                                                        <option value="ClienteError" <?php if ($estadoprospecto == "ClienteError") {echo "selected";}?>>Cliente Error</option>
                                                        <option value="TelefonoError" <?php if ($estadoprospecto == "TelefonoError") {echo "selected";}?>>Telefono Error</option>
                                                        <option value="ZSCC" <?php if ($estadoprospecto == "ZSCC") {echo "selected";}?>>ZSCC</option>
                                                        <option value="Provincia" <?php if ($estadoprospecto == "Provincia") {echo "selected";}?>>Provincia</option>
                                                        <option value="Inviable" <?php if ($estadoprospecto == "Inviable") {echo "selected";}?>>Inviable</option>
                                                        <option value="Rechazada" <?php if ($estadoprospecto == "Rechazada") {echo "selected";}?>>Rechazada</option>
                                                        <option value="ClienteVerisure" <?php if ($estadoprospecto == "ClienteVerisure") {echo "selected";}?>>Cliente Verisure</option>
                            
                                                         <?php
                                                         }  if ($estadoprospecto == "VisitaAceptada" || $estadoprospecto == "VRPAsignada" || $estadoprospecto == "AnuladaOP" || $estadoprospecto == "AnuladaCLI" || $estadoprospecto == "AnuladaTEC"){
                                                        ?>
                                                       <option value="VisitaAceptada" <?php if ($estadoprospecto == "VisitaAceptada") {echo "selected";}?> hidden="" disabled>Visita Aceptada</option>
                                                       <option value="VRPAsignada" <?php if ($estadoprospecto == "VRPAsignada") {echo "selected";}?>>VRP Asignada</option>
                                                       <option value="AnuladaOP" <?php if ($estadoprospecto == "AnuladaOP") {echo "selected";}?>>AnuladaOP</option>
                                                       <option value="AnuladaCLI" <?php if ($estadoprospecto == "AnuladaCLI") {echo "selected";}?>>AnuladaCLI</option>
                                                       <option value="AnuladaTEC" <?php if ($estadoprospecto == "AnuladaTEC") {echo "selected";}?>>AnuladaTEC</option>
                            
                                                        <?php
                                                         }  if ($estadoprospecto == "Vendida" || $estadoprospecto == "NoVendida" ){
                                                        ?>
                                                        <option value="Vendida" <?php if ($estadoprospecto == "Vendida") {echo "selected";}?>>Vendida</option>
                                                        <option value="NoVendida" <?php if ($estadoprospecto == "NoVendida") {echo "selected";}?>>NoVendida</option>
                                                        
                                                        <?php
                                                             }
                                                            ?>          
                                                    </select> 
                                                    <input id="lblestadoprospec" name="lblestadoprospec" value="<?php echo $estadoprospecto;?>"  hidden="" />
                                                    <input type="hidden" id="lblfechagestion" name="lblfechagestion" value="<?php echo $FechaGestion; ?>" />
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px"><span class="lblvervisita">MES VISITA:</span></td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"><div class="lblvervisita">
                                                    <div class="input-group">
                                                        <div class="input-group-addon input-sm">
                                                            <i class="fa fa-calendar"></i>
                                                        </div>
                                                    <input name="lblmesvisita" class="form-control input-sm" id="lblmesvisit" value="<?php echo $mesvisita;?>" style="width: 100%;"/> 
                                                    </div> 
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr class="espacio lblvervisita"></tr>
                                            <tr class="lblvervisita">
<td style="width:15%;font-size: 12px">FECHA VISITA: <span style="color:red"> * </span></td>

<td style="width:25%"> <div class="input-group">
            <div class="input-group-addon input-sm">
                <i class="fa fa-calendar"></i>
            </div>
            <input type="text" class="form-control pull-right input-sm" id="lblfvisita"  name="lblfvisita" value="<?php echo $fvisita;?>"  data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
        </div>

</td>
<td style="width:10%"></td>
<td style="width:15%;font-size: 12px">HORA VISITA: <span style="color:red"> * </span></td>
<td style="width:2%"></td>
<td style="width:25%">
<div class="bootstrap-timepicker timepicker">
         <div class="input-group">
             <input type="text" class="form-control input-sm" placeholder="12:00 AM" name="lblhvisita" id="lblhvisita" value="<?php echo $hvisita;?>"  >
                <div class="input-group-addon input-sm">
                    <i class="fa fa-clock-o"></i>
                </div>
            </div>
        </div>

</td>
</tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">COMENTARIO CALL RP: <span style="color:red"> * </span></td>
                            
                                                <td colspan="5" style="width:77%"><textarea class="form-control input-sm" name="lblcomentariocallrp" id="lblcomentariocallrp" rows="2" style="resize:none" placeholder="Ingresar..." readonly="readonly"><?php echo $comentariocallrp;?></textarea></td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">MATRICULA VISITA: <span style="color:red"> * </span></td>
                                                <td style="width:25%;"><input name="lblmatriculaVA" id="lblmatriculaVA" class="form-control input-sm" <?php if($EstadoComercial=='Activo'){ ?> value="<?php echo $matricula;?>" <?php } ?> style="width: 100%;"/>
                                                    <input id="lblidusuarioVA" name="lblidusuarioVA" <?php if($EstadoComercial=='Activo'){ ?> value="<?php echo $idu;?>" <?php } ?>  hidden="">
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">COMERCIAL VISITA: <span style="color:red"> * </span></td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%"><input name="lblnombcomercialVA" id="lblnombcomercialVA" class="form-control input-sm" style="width: 100%;" <?php if($EstadoComercial=='Activo'){ ?> value="<?php echo $comercial;?>" <?php } ?>  readonly="readonly"></td>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">DC: <span style="color:red"> * </span></td>
                            
                                                <td style="width:25%;">
                                                
                                                    <select class="form-control input-sm" name="lbldcVA" id="lbldcVA" style="width: 100%;">
                                                            <option>Seleccione</option>


														<option value="150" <?php if ($dc == "150") {
															echo "selected";
															} ?>>150</option>

														<option value="151" <?php if ($dc == "151") {
															echo "selected";
															} ?>>151</option>

														<option value="152" <?php if ($dc == "152") {
															echo "selected";
															} ?>>152</option>

														<option value="153" <?php if ($dc == "153") {
															echo "selected";
															} ?>>153</option>

														<option value="154" <?php if ($dc == "154") {
															echo "selected";
															} ?>>154</option>

														<option value="155" <?php if ($dc == "155") {
															echo "selected";
															} ?>>155</option>

														<option value="156" <?php if ($dc == "156") {
															echo "selected";
															} ?>>156</option>

														<option value="157" <?php if ($dc == "157") {
															echo "selected";
															} ?>>157</option>

														<option value="158" <?php if ($dc == "158") {
															echo "selected";
															} ?>>158</option>

														<option value="159" <?php if ($dc == "159") {
															echo "selected";
															} ?>>159</option>

														<option value="200" <?php if ($dc == "200") {
															echo "selected";
															} ?>>200</option>

														<option value="140" <?php if ($dc == "140") {
															echo "selected";
															} ?>>140</option>

														<option value="141" <?php if ($dc == "141") {
															echo "selected";
															} ?>>141</option>

														<option value="121" <?php if ($dc == "121") {
															echo "selected";
															} ?>>121</option>

														<option value="80" <?php if ($dc == "80") {
															echo "selected";
															} ?>>80</option>

														<option value="250" <?php if ($dc == "250") {
															echo "selected";
															} ?>>250</option>

														<option value="251" <?php if ($dc == "251") {
															echo "selected";
															} ?>>251</option>

														<option value="120" <?php if ($dc == "120") {
															echo "selected";
															} ?>>120</option>

														<option value="100" <?php if ($dc == "100") {
															echo "selected";
															} ?>>100</option>

														<option value="40" <?php if ($dc == "40") {
															echo "selected";
															} ?>>40</option>

														<option value="41" <?php if ($dc == "41") {
															echo "selected";
															} ?>>41</option>

														<option value="42" <?php if ($dc == "42") {
															echo "selected";
															} ?>>42</option>

														<option value="513" <?php if ($dc == "513") {
															echo "selected";
															} ?>>513</option>

														<option value="500" <?php if ($dc == "500") {
															echo "selected";
															} ?>>500</option>
														<option value="599" <?php if ($dc == "599") {
															echo "selected";
															} ?>>599</option>
														
														<option value="252" <?php if ($dc == "252") {echo "selected";}?>>252</option>
														
														<option value="20" <?php if ($dc == "20") {echo "selected";}?>>20</option>

														
														<option value="601" <?php if ($dc == "601") {echo "selected";}?>>601</option>
														<option value="602" <?php if ($dc == "602") {echo "selected";}?>>602</option>
														
														<option value="701" <?php if ($dc == "701") {echo "selected";}?>>701</option>
														
														<option value="702" <?php if ($dc == "702") {echo "selected";}?>>702</option>
														
														<option value="901" <?php if ($dc == "901") {echo "selected";}?>>901</option>														

														
														<option value="130" <?php if ($dc == "130") {echo "selected";}?>>130</option>	
														
														<option value="230" <?php if ($dc == "230") {echo "selected";}?>>230</option>
														<option value="60" <?php if ($dc == "60") {echo "selected";}?>>60</option>
														
                                                    </select>
                                               
                                                </td>
                                                <td style="width:10%"></td>
                                                <td style="width:15%;font-size: 12px">JEFE VENTA: <span style="color:red"> * </span></td>
                                                <td style="width:2%"></td>
                                                <td style="width:25%">
                                                    
                                                    <?php $JVvisita=NULL; 
                                                    
                                                    $sql_JVvisita = "SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) JefeVenta FROM dbUSUARIO.tblusuario u  where u.CC='".$dc."' AND u.LN='11' AND (u.Categoria ='JE' OR u.Categoria ='COACH' OR u.Categoria ='DEL') LIMIT 50"; 
                                                    $result_JVvisita = mysqli_query($con, $sql_JVvisita);
                                                    
                                                    if (mysqli_num_rows($result_JVvisita)> 0) {
                                                        while ($row_visita = mysqli_fetch_assoc($result_JVvisita)) {                
                                                           if($row_visita['Matricula']==$matjefe){
                                                                   $JVvisita .= '<option value="'.$row_visita['Matricula'].'" selected>'.$row_visita['Matricula'].' - '.utf8_encode($row_visita['JefeVenta']).' </option>';
                                                                    }else{
                                                    $JVvisita .= '<option value="'.$row_visita['Matricula'].'">'.$row_visita['Matricula'].' - '.utf8_encode($row_visita['JefeVenta']).' </option>';
                                                        }
                                                    }
                                                    }else{
                                                         $JVvisita .= '<option>No se encontraron resultado</option>';
                                                    }
                                                    
                                                    ?>
                                                    <select class="form-control input-sm" name="lbljefeventaVA" id="lbljefeventaVA" style="width: 100%;">
                                                        <?php echo $JVvisita; ?>
                                                    </select>
                                            </tr>
                                            <tr class="espacio"></tr>
                                            <tr>
                                                <td style="width:15%;font-size: 12px">COMENTARIO VISITA: <span style="color:red"> * </span></td>
                                                <?php if($EstadoComercial=='Activo'){ ?>
                                                <td colspan="5" style="width:77%"><textarea class="form-control input-sm" name="lblcomentarioVisita" id="lblcomentarioVisita" rows="2" style="resize:none" placeholder="Ingresar..."><?php echo $comentariocallrp;?></textarea></td>
                                                <?php } else { ?>
                                                <td colspan="5" style="width:77%"><textarea class="form-control input-sm" name="lblcomentarioVisita" id="lblcomentarioVisita" rows="2" style="resize:none" placeholder="Ingresar..."><?php echo $comentariovisita;?></textarea></td>
                                                <?php } ?>
                                            </tr>
                                             <tr class="espacio"></tr>
    <tr>
<td style="width:15%;font-size: 12px"></td>

<td style="width:25%"><a class="btn btn-danger btn-sm"  href="#" data-toggle="modal" id="logcallrp" data-target="#modal-cambios"><i class="fa fa-pencil-square-o"></i> Log Cambios</a></td>
<td style="width:10%"></td>
<td style="width:15%;font-size: 12px"></td>
<td style="width:2%"></td>
<td style="width:25%">
</td>
</tr>  
                                        </table>
                                    </div>
                                    <!-- /.box-body -->
                            
                                  </div>
                                    <!-- DIV INFORMACION OFERTA -->
                                    <div class="box box-custom">
            <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
               <h5>INFORMACION DE LA OFERTA</h5>

              <div class="box-tools pull-right">
                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                </button>
                
              </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table cellspacing="0"  style="width:100%;border-collapse: separate;padding: 20px;" >
<tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:15%;font-size: 12px">MESES AUTORIZADOS:</td>
                                                                        <td style="width:25%;"><input type="number" maxlength="3" class="form-control input-sm" id="lblmesesautorizados" name="lblmesesautorizados"  value="<?php echo $mesesautorizados;?>" onkeypress="return filterFloat(event, this);" disabled="disabled">
                                                                        </td>
                                                                        <td style="width:10%"></td>
                                                                        <td style="width:15%;font-size: 12px">SEGMENTO:</td>
                                                                        <td style="width:2%"></td>
                                                                        <td style="width:25%"><select class="form-control input-sm" name="lblsegmento" id="lblsegmento">
                                                                                <option>Seleccione</option>
                                                                                 <option value="RES"<?php if ($segmento == "RES") {echo "selected";}?>>RES</option>
                                                                                  <option value="NEG"<?php if ($segmento == "NEG") {echo "selected";}?>>NEG</option>
                                                                            </select></td>
                                                                    </tr>                                                            
 <tr class="espacio"></tr>
                                                                     <tr>
                                                                        <td style="width:15%;font-size: 12px">PRECIO KIT:</td>
                                                                        <td style="width:25%;"><div class="input-group">
                                                                                <div class="input-group-addon input-sm">
                                                                                    <i class="">S/.</i>
                                                                                </div>
                                                                               <input type="number" class="form-control input-sm" name="lblpreciokit" id="lblpreciokit" value="<?php echo $preciokit;?>" onkeypress="return filterFloat(event, this);" disabled="disabled">
                                                                            </div>
                                                                        </td>
                                                                        <td style="width:10%"></td>
                                                                        <td style="width:15%;font-size: 12px">TOTAL EXTRA:</td>
                                                                        <td style="width:2%"></td>
                                                                        <td style="width:25%"><div class="input-group">
                                                                                <div class="input-group-addon input-sm">
                                                                                    <i class="">S/.</i>
                                                                                </div>
                                                                               <input type="number" class="form-control input-sm" name="lbltotalextra" id="lbltotalextra" value="<?php echo $totalextra;?>" onkeypress="return filterFloat(event, this);" disabled="disabled">
                                                                            </div></td>
                                                                    </tr>
                                                                   <tr class="espacio"></tr> 

                                                                     <tr>
                                                                        <td style="width:15%;font-size: 12px">RESUMEN INST.:</td>

                                                                        <td colspan="5" style="width:77%"><textarea class="form-control input-sm" name="lblresumenventa" id="lblresumenventa" rows="1" style="resize:none" disabled="disabled"  placeholder="Ingresar..."><?php echo $resumenventa;?></textarea></td>

                                                                    </tr>
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:15%;font-size: 12px">REGALO AUTORIZADO:</td>

                                                                        <td style="width:25%;font-size: 12px"><select class="form-control input-sm" name="lblextraautorizado" id="lblextraautorizado" disabled="disabled">
                                                                                <option>Seleccione</option>
<option value="Ninguno"<?php if ($regaloutorizado == "Ninguno") {echo "selected";}?>>Ninguno</option>
                                                                                 <option value="Mando a distancia"<?php if ($regaloutorizado == "Mando a distancia") {echo "selected";}?>>Mando a distancia</option>
                                                                                  <option value="Magnetico"<?php if ($regaloutorizado == "Magnetico") {echo "selected";}?>>Magnetico</option>
                                                                                   <option value="Pulsador"<?php if ($regaloutorizado == "Pulsador") {echo "selected";}?>>Pulsador</option>
                                                                              

                                                                            </select>
                                                                        </td>
                                                                        <td style="width:10%"></td>
                                                                        <td style="width:15%;font-size: 12px">FORMA DE PAGO:</td>
                                                                        <td style="width:2%"></td>
                                                                        <td style="width:25%">
                                                                          <select class="form-control input-sm" name="lblformadepago" id="lblformadepago" disabled="disabled">
<option value="">Seleccione</option> 
                                                                                <option value="Cheque" <?php if ($formadepago == "Cheque") {echo "selected";}?>>Cheque</option>
                                                                                 <option value="Deposito" <?php if ($formadepago == "Deposito") {echo "selected";}?>>Depósito</option>
                                                                                <option value="Transferencia" <?php if ($formadepago == "Transferencia") {echo "selected";}?>>Transferencia</option>
                                                                                <option value="TransferenciaInterbancaria" <?php if ($formadepago == "TransferenciaInterbancaria") {echo "selected";}?>>Transferencia Interbancaria</option>
                                                                                <option value="PagoPOSVisa" <?php if ($formadepago == "PagoPOSVisa") {echo "selected";}?>>Pago POSVisa</option>
                                                                                <option value="PagoPOSMC" <?php if ($formadepago == "PagoPOSMC") {echo "selected";}?>>Pago POSMC</option>
                                                                                <option value="TarjetadeCredito" <?php if ($formadepago == "TarjetadeCredito") {echo "selected";}?>>Tarjeta de Crédito</option>
                                                                                <option value="PagoPasarella" <?php if ($formadepago == "PagoPasarella") {echo "selected";}?>>Pago Pasarella</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr> 
                                                                    <tr class="espacio"></tr>
                                                                    <tr>
                                                                        <td style="width:15%;font-size: 12px">PAI:</td>
                                                                        <td style="width:25%;"><select class="form-control input-sm" name="lblPAI" id="lblPAI" disabled="disabled">
                                                                                <option>Seleccione</option>
                                                                                <option value="BBVA-DIN"<?php if ($PAI == "BBVA-DIN") {echo "selected";}?>>BBVA-DIN</option>
                                                                                <option value="PAI 30x36"<?php if ($PAI == "PAI 30x36") {echo "selected";}?>>PAI 30x36</option>
                                                                                <option value="NO"<?php if ($PAI == "NO") {echo "selected";}?>>NO</option>
                                                                            </select>
                                                                        </td>
                                                                        <td style="width:10%"></td>
                                                                        <td style="width:15%;font-size: 12px"></td>
                                                                        <td style="width:2%"></td>
                                                                        <td style="width:25%"></td>
                                                                    </tr>
                                                                   <tr class="espacio"></tr>
                                                                     <tr>
                                                                        <td style="width:15%;font-size: 12px">COMENTARIO RP:</td>

                                                                        <td colspan="5" style="width:77%"><textarea class="form-control input-sm" name="lblcomentarioprospecto" id="lblcomentarioprospecto" rows="2" style="resize:none" placeholder="Ingresar..." disabled="disabled"><?php echo $comentarioprospecto;?></textarea></td>

                                                                    </tr>

                                                                </table>
            </div>
            <!-- /.box-body -->

          </div>

                                </form>
                            </div>
                        </div>
                        <div class="col-md-2"></div>
                </section>
                <!-- /.content -->
                
                
                <div class="modal fade" id="modal-cambios">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header modal-header-danger">
                                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                        <h4 style="font-weight: bold">LOG CALLRP</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="vistaboy2">
                                            <div id="myGrid2"  style="height: 100%" class="ag-theme-fresh"></div>
                                            <div  id="ningunresultado2"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                
                
            </div>
            <!-- /.content-wrapper -->
            <div class="control-sidebar-bg"></div>
            <!-- ./wrapper -->
        </div>
        <!-- jQuery v1.11 -->
  
        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>

        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>
        $.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>

       <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>
        <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
        
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>

       
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
       <!-- bootstrap time picker -->
       <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>
     
         <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <!-- Notificaciones -->
        <script src="js/notificaciones.js" type="text/javascript"></script>
        
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>
        
        <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>
        
        <script>
            
    var columnDefsLog = [
         {headerName: 'IDHIST', field: 'IdProspectoRPHist', width: 80, cellRenderer: function (params) {
        return "<div style='text-align: center;'>" + params.value + "</div>";
        }},
        {headerName: 'ID', field: 'IdProspectoRP', width: 75, cellRenderer: function (params) {
        return "<div style='text-align: center;'>" + params.value + "</div>";
        }},
        {headerName: 'FREGISTRO', field: 'FechaHoraREG', width: 150, cellRenderer: function (params) {
        return "<div style='text-align: center;'>" + params.value + "</div>";
        }},
        {headerName: 'RECURSO', field: 'TipoVenta', width: 100, cellRenderer: function (params) {
                switch (params.value) {
                    case 'RE':
                        return "<div style='text-align: center;'><span class='label label-primary'>" + params.value + "</span></div>";
                        break;
                    case 'RP':
                        return "<div style='text-align: center;'><span class='label label-danger'>" + params.value + "</span></div>";
                        break;
                    case 'RPPA':
                        return "<div style='text-align: center;'><span class='label label-danger'>" + params.value + "</span></div>";
                        break;
                    case 'RPPR':
                        return "<div style='text-align: center;'><span class='label label-danger'>" + params.value + "</span></div>";
                        break;
                    case 'RPTMK':
                        return "<div style='text-align: center;'><span class='label label-danger'>" + params.value + "</span></div>";
                        break;
                }
        }},

        
                {headerName: 'ESTADO', field: 'EstadoProspecto', width: 150, cellRenderer: function (params) {
        return "<div style='text-align: center;'>" + params.value + "</div>";
        }},
        
                {headerName: 'COMETARIOCALLRP', field: 'ComentarioCallRP', width: 220, cellRenderer: function (params) {
        return "<div style='text-align: left;'>" + params.value + "</div>";
        }},
                {headerName: 'CONTACTRP', field: 'GestorContactRP', width: 120, cellRenderer: function (params) {
        return "<div style='text-align: center;'>" + params.value + "</div>";
        }},
        
                {headerName: 'FRELLAMADA', field: 'FechaRellamada', width: 150, cellRenderer: function (params) {
        return "<div style='text-align: center;'>" + params.value + "</div>";
        }},
        
                {headerName: 'HRELLAMADA', field: 'HoraRellamada', width: 150, cellRenderer: function (params) {
        return "<div style='text-align: center;'>" + params.value + "</div>";
        }},
                {headerName: 'BACKOFFICE', field: 'GestorBackOffice', width: 170, cellRenderer: function (params) {
        return "<div style='text-align: center;'>" + params.value + "</div>";
        }},
        
                        {headerName: 'FVISITARP', field: 'FechaVisitaRP', width: 170, cellRenderer: function (params) {
        return "<div style='text-align: center;'>" + params.value + "</div>";
        }},
        
                        {headerName: 'HVISIITARP', field: 'HoraVisitaRP', width: 150, cellRenderer: function (params) {
        return "<div style='text-align: center;'>" + params.value + "</div>";
        }},
                        {headerName: 'MOVITIVONOACEPTA', field: 'MotivoNoAceptaVisita', width: 150, cellRenderer: function (params) {
        return "<div style='text-align: center;'>" + params.value + "</div>";
        }},
        
                        {headerName: 'COMPETENCIA', field: 'Competencia', width: 150, cellRenderer: function (params) {
        return "<div style='text-align: center;'>" + params.value + "</div>";
        }}
        
        
        ];
        var gridOptionsLog = {
                    columnDefs: columnDefsLog,
                    onPaginationChanged: onPaginationChangedLog,
                    rowData: null,
                    enableFilter: true,
                    enableColResize: true,
                    localeText: {
                        // for filter panel
                        page: 'página',
                        more: 'Más',
                        to: 'a',
                        of: 'de',
                        next: 'Siguiente',
                        last: 'Último',
                        first: 'Primero',
                        previous: 'Anterior',
                        loadingOoo: 'Cargando...',
                        // for set filter
                        selectAll: 'Seleccionar todo',
                        searchOoo: 'Buscando...',
                        blanks: 'Espacios en blanco',
                        // for number filter and text filter
                        filterOoo: 'Filtrar...',
                        applyFilter: 'Aplicar Filtro',
                        // for number filter
                        equals: 'Igual',
                        notEqual: 'No es igual',
                        lessThanOrEqual: 'Menor o igual',
                        greaterThanOrEqual: 'Mayor que o igual',
                        inRange: 'En el rango',
                        lessThan: 'Menos que',
                        greaterThan: 'Mas grande que',
                        // for text filter
                        contains: 'Contiene',
                        startsWith: 'Comienza con',
                        endsWith: 'Termina con',
                        notContains:'No contiene',
                        // the header of the default group column
                        group: 'Grupo',
                        // tool panel
                        columns: 'columnas',
                        rowGroupColumns: 'Grupo columnas',
                        rowGroupColumnsEmptyMessage: 'No hay resultado',
                        valueColumns: 'Columna de valor',
                        pivotMode: 'Modo pivote',
                        groups: 'grupos',
                        values: 'valor',
                        pivots: 'pivote',
                        valueColumnsEmptyMessage: 'No hay resultado',
                        pivotColumnsEmptyMessage: 'No hay resultado',
                        // other
                        noRowsToShow: '<div class="callout callout-danger">\n\
                        <span class="pull-left">\n\
                        <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
                        </span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
                        <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
                        <br></div>'
            
            
                        ,
                        // enterprise menu
                        pinColumn: 'Aclar columna',
                        valueAggregation: 'Agregar valor',
                        autosizeThiscolumn: 'Auto tamaño esta columna ',
                        autosizeAllColumns: 'Auto tamaño todas columnas',
                        groupBy: 'Agrupar',
                        ungroupBy: 'Agrupar uno',
                        resetColumns: 'Restaurar Columnas',
                        expandAll: 'expandir todo',
                        collapseAll: 'desplegar todo',
                        toolPanel: 'Panel de Heramientas',
                        export: 'Exportar',
                        csvExport: 'Exportar CSV',
                        excelExport: 'Exportar Excel',
                        // enterprise menu pinning
                        pinLeft: 'Anclar a derecha',
                        pinRight: 'Anclar a izquierda',
                        noPin: 'Desanclar',
                        // enterprise menu aggregation and status panel
                        sum: 'Sumar',
                        min: 'Minimo',
                        max: 'Maximo',
                        first: 'Primero',
                                last: 'Ultimo',
                                none: 'Nada',
                        count: 'Contador',
                        average: 'Promedio',
                        // standard menu
                        copy: 'Copiar',
                        copyWithHeaders: 'Copiar Cabecera',
                        ctrlC: 'Ctrl+C',
                        paste: 'Pegar',
                        ctrlV: 'Ctrl+V'
                    },
                    enableSorting: true
                };

        function onPaginationChangedLog(params) {
                
          this.gridRowCount = params.api.paginationGetRowCount();
                     $("#count").html(this.gridRowCount);
        }
            
        function listarLog() {
            var idpros = $('#lblidprospectorp').val();
            $.ajax({
                url: 'ajax/findDataCallRPcambios.php',
                type: 'Post',
                data: {idpros: idpros},
                success: function (data) {

                   
                   if (data == 1){
                       
                        var gridDiv = document.querySelector('#myGrid2');
                        new agGrid.Grid(gridDiv, gridOptionsLog);
    
                        agGrid.simpleHttpRequest({url: 'ajax/selectListarCallRPcambios.php?idpros='+idpros}).then(function (data) {
    
                            gridOptionsLog.api.setRowData(data);
                        });
                        $('#vistaboy2').height(function (index, height) {
                            return $(window).height() * 40 / 100;
                        });
                   } else {
                        $("#ningunresultado2").html(data);

                        var gridDiv = document.querySelector('#myGrid2');
                        new agGrid.Grid(gridDiv, gridOptionsLog);
    
                        agGrid.simpleHttpRequest({url: 'ajax/selectListarCallRPcambios.php?idpros='+idpros}).then(function (data) {
    
                        gridOptionsLog.api.setRowData(data);
                        });
    
                        $('#myGrid2').hide("fast");
                   }
                }
            })
        }
            
        </script>
   
        <script>
        $("#lbldcVA").change(function () {
           $("#lbldcVA option:selected").each(function () {
               var lbldc = $(this).val();
                $.post("./ajax/selectJefeVenta.php", { lbldc: lbldc }, function(data){
                    $("#lbljefeventaVA").html(data);
                });            
                });
            });
        
            $('#lblmatriculaVA').on('keyup', function () {
                var dato = $('#lblmatriculaVA').val();
                var url = 'ajax/findMatricula.php';
                $.ajax({
                    type: 'POST',
                    url: url,
                    data: 'dato=' + dato,
                    success: function (datos) {
                        $('.mensajematricula').html(datos);
                    }
                });
                return false;
            });
               
            $("#lblmatriculaVA").autocomplete({
                source: "./ajax/selectMatricula.php",
                minLength: 2,
                select: function (event, ui) {
                    event.preventDefault();
                    $('#lblidusuarioVA').val(ui.item.idusuario);
                    $('#lblmatriculaVA').val(ui.item.matricula);
                    $('#lblnombcomercialVA').val(ui.item.comercial);
//                        $('#lbldc').val(ui.item.dc);
//                        $('#lbljefeventa').val(ui.item.jefe);
                 
                }
            });

            $("#lblmatriculaVA").on("keydown", function (event) {
                if (event.keyCode == $.ui.keyCode.LEFT || event.keyCode == $.ui.keyCode.RIGHT || event.keyCode == $.ui.keyCode.UP || event.keyCode == $.ui.keyCode.DOWN || event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE)
                {
                    $('#lblidusuarioVA').val("");
                    $('#lblmatriculaVA').val("");
                    $('#lblnombcomercialVA').val("");
//                        $('#lbldc').val("");
//                        $('#lbljefeventa').val("");

                }
                if (event.keyCode == $.ui.keyCode.DELETE) {
                    $('#lblmatriculaVA').val("");
                    $('#lblidusuarioVA').val("");
                    $('#lblnombcomercialVA').val("");
//                        $('#lbldc').val("");
//                        $('#lbljefeventa').val("");
                }
            });

        </script>

        <script>
            $(function () {
                
            $('#checki').bootstrapToggle({
                on:'SI',
                off:'NO',
                onstyle:'success',
                offstyle:'danger'
            });
            
            $('#checki').change(function(){
              if($(this).prop('checked')){
                 $('#hidden_checki').val('SI');
              }else{
                $('#hidden_checki').val('NO');
               }
            });
                
            $("#lbldc").change(function () {
                   $("#lbldc option:selected").each(function () {
                   var lbldc = $(this).val();
                    $.post("./ajax/selectJefeVenta.php", { lbldc: lbldc }, function(data){
                        $("#lbljefeventa").html(data);
                    });            
                });
            
            });

            $("#lblinstaladox").change(function () {
                   $("#lblinstaladox option:selected").each(function () {
                   var lblinstaladox= $(this).val();
                    $.post("./ajax/selectTecnico.php", { lblinstaladox: lblinstaladox }, function(data){
                        $("#lbltecnico").html(data);
                    });            
                });
            
            });
   
            $("#lblestadoventa").change(function () {
                var condiciones = $("#lblestadoventa").val();
            $("#lblestventa").val(condiciones);
                bloquear(condiciones);
                    
            });


$("#lblestadoprospecto").change(function(){
     var estadoprospecto = $("#lblestadoprospecto").val();
     var idprospectorp=$("#lblidprospectorp").val();
     if(estadoprospecto=="ProspectoRP"){
         $(".cattitle").text("ProspectoRP");
     }else if(estadoprospecto=="VisitaAceptada"){
         $(".cattitle").text("VISITA ACEPTADA RP - "+idprospectorp);
           $('.lblvervisita').show();
           $('.lblverllamada').hide();
           $('.lblvermotivonoaceptavisita').hide();
            $("#lblcat").val("VisitaAceptada");
     }else if(estadoprospecto=="NoAceptaVisita"){
        $(".cattitle").text("NO ACEPTA VISITA - "+idprospectorp);
                   $('.lblvervisita').hide();
           $('.lblverllamada').hide();
           $('.lblvermotivonoaceptavisita').show();
           $("#lblcat").val("NoAceptaVisita");
     }else if(estadoprospecto=="NoContesta"){
        $(".cattitle").text("NO CONTESTA - "+idprospectorp);
         $('.lblvervisita').hide();
           $('.lblverllamada').hide();
           $('.lblvermotivonoaceptavisita').hide();
           $("#lblcat").val("NoContesta");
     }else if(estadoprospecto=="DevolverLlamada"){
        $(".cattitle").text("DEVOLVER LLAMADA - "+idprospectorp);
                 $('.lblvervisita').hide();
           $('.lblverllamada').show();
           $('.lblvermotivonoaceptavisita').hide();
            $("#lblcat").val("DevolverLlamada");
     }else if(estadoprospecto=="ClienteError"){
        $(".cattitle").text("CLIENTE ERROR - "+idprospectorp);
                 $('.lblvervisita').hide();
           $('.lblverllamada').hide();
           $('.lblvermotivonoaceptavisita').hide();
             $("#lblcat").val("ClienteError");
     }else if(estadoprospecto=="TelefonoError"){
        $(".cattitle").text("TELEFONO ERROR - "+idprospectorp);
                 $('.lblvervisita').hide();
           $('.lblverllamada').hide();
           $('.lblvermotivonoaceptavisita').hide();
             $("#lblcat").val("TelefonoError");
     }else if(estadoprospecto=="ZSCC"){
        $(".cattitle").text("ZSCC - "+idprospectorp);
                 $('.lblvervisita').hide();
           $('.lblverllamada').hide();
           $('.lblvermotivonoaceptavisita').hide();
           $("#lblcat").val("ZSCC");
     }else if(estadoprospecto=="Provincia"){
        $(".cattitle").text("PROVINCIA RP - "+idprospectorp);
                 $('.lblvervisita').hide();
           $('.lblverllamada').hide();
           $('.lblvermotivonoaceptavisita').hide();
            $("#lblcat").val("Provincia");
     }else if(estadoprospecto=="Inviable"){
        $(".cattitle").text("INVIABLE - "+idprospectorp);
                 $('.lblvervisita').hide();
           $('.lblverllamada').hide();
           $('.lblvermotivonoaceptavisita').hide();
             $("#lblcat").val("Inviable");
     }else if(estadoprospecto=="Rechazada"){
        $(".cattitle").text("RECHAZADA - "+idprospectorp);
                 $('.lblvervisita').hide();
           $('.lblverllamada').hide();
           $('.lblvermotivonoaceptavisita').hide();
             $("#lblcat").val("Rechazada");
     }else if(estadoprospecto=="ClienteVerisure"){
        $(".cattitle").text("CLIENTE VERISURE - "+idprospectorp);
                 $('.lblvervisita').hide();
           $('.lblverllamada').hide();
           $('.lblvermotivonoaceptavisita').hide();
             $("#lblcat").val("ClienteVerisure");
             $('.lblcompetencia').hide();
    } else if(estadoprospecto=="VRPAsignada"){
        $(".cattitle").text("VISITA ASIGNADA RP - "+idprospectorp);
                 $('.lblvervisita').show();
           $('.lblverllamada').hide();
           $('.lblvermotivonoaceptavisita').hide();
            $("#lblcat").val("VRPAsignada");
     }else if(estadoprospecto=="AnuladaOP"){
        $(".cattitle").text("ANULADA POR OPERADOR - "+idprospectorp);
                 $('.lblvervisita').show();
           $('.lblverllamada').hide();
           $('.lblvermotivonoaceptavisita').hide();
           $("#lblcat").val("AnuladaOP");
     }else if(estadoprospecto=="AnuladaCLI"){
        $(".cattitle").text("ANULADA POR CLIENTE - "+idprospectorp);
                 $('.lblvervisita').show();
           $('.lblverllamada').hide();
           $('.lblvermotivonoaceptavisita').hide();
             $("#lblcat").val("AnuladaCLI");
      }else if(estadoprospecto=="AnuladaTEC"){
        $(".cattitle").text("ANULADA POR TECNICO - "+idprospectorp);
                 $('.lblvervisita').show();
           $('.lblverllamada').hide();
           $('.lblvermotivonoaceptavisita').hide();
           $("#lblcat").val("AnuladaTEC");
     }
    
});

 $("#lbltipoventa").change(function () {
   var tps= $("#lbltipoventa").val();
    $("#lbltiventa").val(tps);

                });

          $("#lblcategoria").change(function () {
                    var categoria = $("#lblcategoria").val();
                     var recurso=$("#lbltiventa").val();
                     $("#lblcat").val(categoria);
                 
if(categoria =="ProspectoRP"){

$("#lblestadoprospecto").val("ProspectoRP");
$("#lblestventa").val("");

               }

if(categoria =="Ficha"){

$("#lblestadoprospecto").val("Vendida");
$("#lblestventa").val("PendienteAgenda");
     
               }
 if(categoria =="Online"){
$("#lblestadoprospecto").val("Vendida");
$("#lblestventa").val("PendienteData");
             
             }
 if(categoria =="Delegacion"){

$("#lblestadoprospecto").val("Vendida");
$("#lblestventa").val("AgendadaDEL");

             }
 
if(categoria =="NoVendida"){

$("#lblestadoprospecto").val("NoVendida");
$("#lblestventa").val("NoVendida");

             }   

                });
   

   
                $('#lblmatricula').on('keyup', function () {
                    var dato = $('#lblmatricula').val();
                    var url = 'ajax/findMatricula.php';
                    $.ajax({
                        type: 'POST',
                        url: url,
                        data: 'dato=' + dato,
                        success: function (datos) {
                            $('.mensajematricula').html(datos);
                        }
                    });
                    return false;
                });
               
               $("#lblmatricula").autocomplete({
                    source: "./ajax/selectMatricula.php",
                    minLength: 2,
                    select: function (event, ui) {
                        event.preventDefault();
                        $('#lblidusuario').val(ui.item.idusuario);
                        $('#lblmatricula').val(ui.item.matricula);
                        $('#lblnombcomercial').val(ui.item.comercial);
//                        $('#lbldc').val(ui.item.dc);
//                        $('#lbljefeventa').val(ui.item.jefe);
                     
                    }
                });

                $("#lblmatricula").on("keydown", function (event) {
                    if (event.keyCode == $.ui.keyCode.LEFT || event.keyCode == $.ui.keyCode.RIGHT || event.keyCode == $.ui.keyCode.UP || event.keyCode == $.ui.keyCode.DOWN || event.keyCode == $.ui.keyCode.DELETE || event.keyCode == $.ui.keyCode.BACKSPACE)
                    {
                        $('#lblidusuario').val("");
                        $('#lblmatricula').val("");
                        $('#lblnombcomercial').val("");
//                        $('#lbldc').val("");
//                        $('#lbljefeventa').val("");

                    }
                    if (event.keyCode == $.ui.keyCode.DELETE) {
                        $('#lblmatricula').val("");
                        $('#lblidusuario').val("");
                        $('#lblnombcomercial').val("");
//                        $('#lbldc').val("");
//                        $('#lbljefeventa').val("");
                    }
                });

            });


        </script>
        
        <script>
            $(document).ready(function () {
                


                notificacion();
                                                                                
                bloquear('<?php echo $estadoventa; ?>');

                var alterClass = function () {
                    var ww = document.body.clientWidth;
                    if (ww < 767) {
                        $('body').removeClass('sidebar-collapse');
                    } else if (ww >= 768) {
                        $('body').addClass('sidebar-collapse');
                    }
                    ;
                };

                $(window).resize(function () {
                    alterClass();
                });
                //Fire it when the page first loads:
                alterClass();
                
                $('#btnGuardarEditarVenta').click(function () {
                    var gestor='<?php echo $matriculausuario; ?>';
                    var catgventa=$('#lblcat').val();
                    var idprospectorp=$('#lblidprospectorp').val();
                    
                 //Algunas variables por default de alertify
                alertify.defaults.theme.ok = "btn btn-nuevo";
                alertify.defaults.theme.cancel = "btn btn-danger";
                
                if (catgventa == 'VisitaAceptada'){
                    Swal.fire(
                      'Alerta!',
                      'Debes modificar el ESTADO del prospecto',
                      'warning'
                    )
                } else {
                
                var lastX,lastY;
                alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea guardar los cambios que ha realizado?', function(){ if (validaForm()) {
                // Primero validará el formulario.

                        var datos = $('#frmEditarVenta').serialize();
                        console.log(datos);
                        console.log(idprospectorp);
                        console.log(catgventa);
                        console.log(gestor);
                        $.ajax({
                            type: 'POST',
                            url: 'ajax/updateCallRP_v2.php',
                            data: "lblcategoria=" + catgventa + "&lblidprospectorp="+idprospectorp+"&gestor="+gestor+"&"+datos,
                            success: function (r) {
                                if (r == 1) {

                                     alertify.success("Modificado con exito");
                                
                                }else if(r==5){
                                    
                                    alertify.success("Modificado con exito");
                                   
                                }else if(r==6){
                                    alertify.success("Grabado con exito la venta");
                                }
                                else if(r==7){
                                  
                                    alertify.success("Grabado con exito la venta");

                                }

                                else if(r==2){
                                    alertify.warning("No se puede realizar cambios");
                                   
                                }else {
                                    alertify.error("Fallo el server");
                                   
                                }
                            }
                        });
                    } }
                , function(){ alertify.error('No se han guardado los cambios')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
        
            lastX = window.scrollX;
        lastY = window.scrollY;
      },
                'onfocus':function(){
        window.scrollTo(lastX, lastY);
      }  }).show(); 
                
                }                                                                    
                                                
                                                                                
                                                                                });
                                                                                
                                                                                $('.selectdistrito').select2({
                                                                                    placeholder: 'Seleccione Distrito - Provincia',
                                                                                    allowClear: true,
                                                                                    language: {
                                                                                        errorLoading: function () {
                                                                                            return "La carga falló";
                                                                                        },
                                                                                        noResults: function () {
                                                                                            return "No hay resultado";
                                                                                        },
                                                                                        searching: function () {

                                                                                            return "Buscando..";
                                                                                        }
                                                                                    },
                                                                                    ajax: {
                                                                                        url: 'ajax/selectDistrito.php',
                                                                                        dataType: 'json',
                                                                                        delay: 250,
                                                                                        processResults: function (data) {
                                                                                            return {
                                                                                                results: data
                                                                                            };
                                                                                        },
                                                                                        cache: true
                                                                                    }
                                                                                });


                                                                                
                                                                                 $('.cbxtecnico').select2({
                                                                                    placeholder: 'Seleccione',
                                                                                    allowClear: true,
                                                                                    language: {
                                                                                        errorLoading: function () {
                                                                                            return "La carga falló";
                                                                                        },
                                                                                        noResults: function () {
                                                                                            return "No hay resultado";
                                                                                        },
                                                                                        searching: function () {

                                                                                            return "Buscando..";
                                                                                        }
                                                                                    }
                                                                                });
                                                                              
                                                                              
                                                                                $('#datemask').inputmask('dd/mm/yyyy', {'placeholder': 'dd/mm/yyyy'});
                                                                                $('#lblfvisita').datepicker({
                                                                                    autoclose: true,
                                                                                    language: 'es',
                                                                                    firstDay: 1
                                                                                });
                                                                                $('#lblhvisita').timepicker({
                                                                                defaultTime:false,                                                                                    
                                                                                showInputs: true,
                                                                                     minuteStep: 1
                                                                                  
                                                                              });
                                                                                 $('#lblfllamada').datepicker({
                                                                                    autoclose: true,
                                                                                    language: 'es',
                                                                                    firstDay: 1
                                                                                });
                                                                                $('#lblhllamada').timepicker({
                                                                                defaultTime:false,                                                                                    
                                                                                showInputs: true,
                                                                                     minuteStep: 1
                                                                                  
                                                                              });

                                                               
                                                                               $('#lblmesvisit').datepicker({
             
                                                                                autoclose: true,
                                                                                language: 'en',
                                                                                firstDay: 1, format: 'M-yyyy',
                                                                                viewMode: "years",
                                                                                minViewMode: "months",
                                                                                orientation: 'bottom'
                                                                
                                                                            });
                                                                                  $('#lblfecharecpciondoc').datepicker({
                                                                                    autoclose: true,
                                                                                    language: 'es',
                                                                                    firstDay: 1
                                                                                });
                                                                                  $('#lblfechafacturacion').datepicker({
                                                                                    autoclose: true,
                                                                                    language: 'es',
                                                                                    firstDay: 1
                                                                                });
                                                                                //Money Euro
                                                                                $('[data-mask]').inputmask();
                                                                                //Date picker
                                                                                $('#fechainst').datepicker({
                                                                                    autoclose: true,
                                                                                    language: 'es',
                                                                                    firstDay: 1
                                                                                });
                                                                                //Date picker
                                                                                $('#horainst').timepicker({
                                                                                     defaultTime:false,
                                                                                    showInputs: true,
                                                                                     minuteStep: 1
                                                                              });
                                                                              
                                                                                $('#mesano').datepicker({
                                                                                    autoclose: true,
                                                                                    language: 'en',
                                                                                    firstDay: 1, format: 'M-yyyy',
                                                                                    viewMode: "years",
                                                                                    minViewMode: "months"

                                                                                });

                                                                          $('#logcallrp').click(function () {
            $('#myGrid2').html('');
            listarLog();
        })
                                        
            $('#ModEnviar').on('click', function(){
                                //textbox = document.getElementById('textbox');
                                var idprospectorp=$('#lblidprospectorp').val();
                                //Algunas variables por default de alertify
                                alertify.defaults.theme.ok = "btn btn-nuevo";
                                alertify.defaults.theme.cancel = "btn btn-danger";
                                var lastX,lastY;
                                alertify.confirm('<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>', '¿Desea descargar el archivo de envio?', function(){
                                        // Primero validará el formulario.
                                        var datos = {idprospectorp:idprospectorp};
                                        console.log(datos);
                                        $.ajax({
                                           type: 'POST',
                                           url: 'ajax/correoenviovisitaTMK.php',
                                           data: datos,
                                           success: function (r) {
                                               console.log(r);
                                               
                                               var link = document.getElementById('downloadlink');
                                                link.href = makeTextFile(r);
                                                //link.style.display = 'block';
                
                                                download("correo_"+idprospectorp+".eml", makeTextFile(r));
                
                                           }
                                        });
                                }, function(){ alertify.error('Se ha cancelado el envio de correo')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
                                    lastX = window.scrollX;
                                    lastY = window.scrollY;
                                },
                                'onfocus':function(){
                                    window.scrollTo(lastX, lastY);
                                }  }).show();
                            })                                          
                                                                            });
                                                                            
                var Frmmodificado;                                                
                                                                            
                $('input,select').on('change', function () {
                    Frmmodificado = true;
                });
                                                                            
      

                                                                            var  bloquear = function (condiciones){
                                                                           
                       $('#tinviable').hide();
                        $('#lblinviable').hide();
                         $('#lblinviable').disabled=true;
                        $('#tinviableespacio').hide();
                        
                        $('#tcancelado').hide();
                        $('#lblcancelado').hide();
                         $('#lblcancelado').disabled=true;
                        $('#tcanceladoespacio').hide();
                        
                                                                           
                    if (condiciones == "Inviable") {
                        $('#tinviable').show();
                        $('#lblinviable').show();
                        $('#lblinviable').show();
                        $('#lblinviable').disabled=false;
                        $('#tinviableespacio').show();
                        
                    }else if(condiciones=="AgendadaTEC" || condiciones=="Instalada" || condiciones=="Facturada" || condiciones=="Incidencia" || condiciones=="IncidenciaGestCorreo" || condiciones=="IncidenciaGestValija" || condiciones=="NoDoc" || condiciones=="DocEnvi" ){
                           $('#lblcategoria')[0].disabled=true;  

                      }


                    else if(condiciones=="Cancelado"){
                        $('#tcancelado').show();
                        $('#lblcancelado').show();
                        $('#lblcancelado').disabled=false;
                        $('#tcanceladoespacio').show();
                    
                    } 
                    else {
                        $('#tinviable').hide();
                        $('#lblinviable').hide();
                         $('#lblinviable').disabled=true;
                        $('#tinviableespacio').hide();
                        
                        $('#tcancelado').hide();
                        $('#lblcancelado').hide();
                         $('#lblcancelado').disabled=true;
                        $('#tcanceladoespacio').hide();
                       
                    }
    
    }




 
                                                                        
          function validaForm() {
                // Campos de texto
                if ($("#frmEditarVenta #lblmatricula").val() == "") {
                    alertify.warning("Por favor ingresar la Matricula correspondiente");
                    $("#frmEditarVenta #lblmatricula").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmEditarVenta #lblmatriculaVA").val() =="") {
                    alertify.warning("Por favor ingresar la Matricula correspondiente");
                    $("#frmEditarVenta #lblmatriculaVA").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lbldcVA").val() == "Seleccione"){
                    alertify.warning("Por favor ingresar la DC correspondiente");
                    return false;
                }
                if ($("#frmEditarVenta #lblnombcomercial").val() == "") {
                    alertify.warning("Por favor ingresar la Matricula valida");
                    $("#frmEditarVenta #lblmatricula").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                 if ($("#frmEditarVenta #lbldc").val() == "" || $("#frmEditarVenta #lbldc").val() == "Seleccione" ) {
                    alertify.warning("Por favor ingresar CC correcto");
                    $("#frmEditarVenta #lbldc").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
 
                if ($("#frmEditarVenta #lbljefeventa").val() == "" || $("#frmEditarVenta #lbljefeventa").val() == "No se encontraron resultado") {
                    alertify.warning("Por favor revisar Jefe de Estructura Comercial");
                    $("#frmEditarVenta #lbljefeventa").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }


                if ($("#frmEditarVenta #lblnombcliente").val() == "") {
                    alertify.warning("Por favor ingresar Nombre del Cliente");
                    $("#frmEditarVenta #lblnombcliente").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblcorreo").val() == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test($("#frmEditarVenta #lblcorreo").val())) {
                    alertify.warning("Por favor ingresar correo válido");
                    $("#frmEditarVenta #lblcorreo").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lbldireccion").val() == "") {
                    alertify.warning("Por favor ingresar la Direccion del Cliente");
                    $("#frmEditarVenta #lbldireccion").focus();
                    return false;
                }

                if ($("#frmEditarVenta #lbldistrito").val() =="") {
                    alertify.warning("Por favor ingresar Distrito correcto");
                 
                    $("#frmEditarVenta #lbldistrito").select2('open');
                    return false;
                }
                   
                if ($("#frmEditarVenta #lblmovil").val() == "") {
                    alertify.warning("Por favor ingresar Telefono, de caso contrario digite: 0");
                    $("#frmEditarVenta #lblmovil").focus();
                    return false;
                }

                 if ($("#lblcat").val() == "Ficha") {
                                            if ($("#frmEditarVenta #lblpreciokit").val() == "") {
                                                alertify.warning("Por favor ingresar Precio del KIT");
                                                $("#frmEditarVenta #lblpreciokit").focus();
                                                return false;
                                            }
                                            if ($("#frmEditarVenta #lbltotalextra").val() == "") {
                                                alertify.warning("Por favor ingresar Total de Extra, de caso contrario digite: 0");
                                                $("#frmEditarVenta #lbltotalextra").focus();
                                                return false;
                                            }

                                            if ($("#frmEditarVenta #lblresumenventa").val() == "") {
                                                alertify.warning("Por favor ingresar Resumen de Venta");
                                                $("#frmEditarVenta #lblresumenventa").focus();
                                                return false;
                                            }
                                            if ($("#frmEditarVenta #lblformadepago").val() == "Seleccione") {
                                                alertify.warning("Por favor ingresar Forma de Pago");
                                                $("#frmEditarVenta #lblformadepago").focus();
                                                return false;
                                            }
                                            if ($("#frmEditarVenta #mesano").val() == "") {
                                                alertify.warning("Por favor ingresar 590");
                                                $("#frmEditarVenta #mesano").focus();
                                                return false;
                                            }
                                            if ($("#frmEditarVenta #lblPAI").val() == "Seleccione") {
                                                alertify.warning("Por favor ingresar PAI");
                                                $("#frmEditarVenta #lblPAI").focus();
                                                return false;
                                            }

                                            if ($("#frmEditarVenta #lblestadoventa").val() == "Seleccione" || $("#frmEditarVenta #lblestadoventa").val() == "") {
                                                alertify.warning("Por favor ingresar Estado de Venta correcto");
                                                $("#frmEditarVenta #lblestadoventa").focus();
                                                return false;
                                            }
                                            if ($("#frmEditarVenta #lbltipoventa").val() == "Seleccione") {
                                                alertify.warning("Por favor ingresar Recurso correcto");
                                                $("#frmEditarVenta #lbltipoventa").focus();
                                                return false;
                                            }
                                            if ($("#frmEditarVenta #lblsegmento").val() == "Seleccione") {
                                                alertify.warning("Por favor ingresar Segmento correcto");
                                                $("#frmEditarVenta #lblsegmento").focus();
                                                return false;
                                            }
                                            if ($("#frmEditarVenta #lblmesesautorizados").val() == "") {
                                                alertify.warning("Por favor ingresar MesAutorizado.Si no tuviese coloque: 0");
                                                $("#frmEditarVenta #lblmesesautorizados").focus();
                                                return false;
                                            }

                }

                if ($("#lblcat").val() == "Delegacion") {
                           if ($("#frmEditarVenta #lblpreciokit").val() == "") {
                    alertify.warning("Por favor ingresar Precio del KIT");
                    $("#frmEditarVenta #lblpreciokit").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lbltotalextra").val() == "") {
                    alertify.warning("Por favor ingresar Total de Extra, de caso contrario digite: 0");
                    $("#frmEditarVenta #lbltotalextra").focus();
                    return false;
                }

                if ($("#frmEditarVenta #lblresumenventa").val() == "") {
                    alertify.warning("Por favor ingresar Resumen de Venta");
                    $("#frmEditarVenta #lblresumenventa").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblformadepago").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Forma de Pago");
                    $("#frmEditarVenta #lblformadepago").focus();
                    return false;
                }
                if ($("#frmEditarVenta #mesano").val() == "") {
                    alertify.warning("Por favor ingresar 590");
                    $("#frmEditarVenta #mesano").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblPAI").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar PAI");
                    $("#frmEditarVenta #lblPAI").focus();
                    return false;
                }

                if ($("#frmEditarVenta #lblestadoventa").val() == "Seleccione" || $("#frmEditarVenta #lblestadoventa").val() == "") {
                    alertify.warning("Por favor ingresar Estado de Venta correcto");
                    $("#frmEditarVenta #lblestadoventa").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lbltipoventa").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Recurso correcto");
                    $("#frmEditarVenta #lbltipoventa").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblsegmento").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Segmento correcto");
                    $("#frmEditarVenta #lblsegmento").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblmesesautorizados").val() == "") {
                    alertify.warning("Por favor ingresar MesAutorizado.Si no tuviese coloque: 0");
                    $("#frmEditarVenta #lblmesesautorizados").focus();
                    return false;
                }

                if ($("#frmEditarVenta #lblinstaladox").val() == "" || $("#frmEditarVenta #lblinstaladox").val() == "Seleccione" || $("#frmEditarVenta #lblinstaladox").val() == "TEC" ) {
                    alertify.warning("Por favor seleccionar Instaladox: DEL");
                    $("#frmEditarVenta #lblinstaladox").focus();
                    return false;
                }


                if ($("#frmEditarVenta #lbltecnico").val() =="") {
                    alertify.warning("Por favor seleccionar el instalador");
                 
                    $("#frmEditarVenta #lbltecnico").select2('open');
                    return false;
                }

                if ($("#frmEditarVenta #fechainst").val() == "") {
                    alertify.warning("Por favor ingresar Fecha de Instalacion");
                    $("#frmEditarVenta #fechainst").focus();
                    return false;
                }


                if ($("#frmEditarVenta #horainst").val() == "") {
                    alertify.warning("Por favor ingresar Hora de Instalacion");
                    $("#frmEditarVenta #horainst").focus();
                    return false;
                }
                
               
                
                }
                
                if ($("#frmEditarVenta #lblcat").val() == "VisitaAceptada") {
                     alertify.warning("Por favor cambiar el estado de Prospecto");
                     $("#frmEditarVenta #lblestadoprospecto").focus();
                     return false;
                }
                return true; 
                
            }

            var calcDataTableHeight = function () {
                return $(window).height() * 65 / 100;
            };

  
            function filterFloat(evt, input) {
                // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
                var key = window.Event ? evt.which : evt.keyCode;
                var chark = String.fromCharCode(key);
                var tempValue = input.value + chark;
                if (key >= 48 && key <= 57) {
                    if (filter(tempValue) === false) {
                        return false;
                    } else {
                        return true;
                    }
                } else {
                    if (key == 8 || key == 13 || key == 0) {
                        return true;
                    } else if (key == 46) {
                        if (filter(tempValue) === false) {
                            return false;
                        } else {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
            }

            function filter(__val__) {
                var preg = /^([0-9]+\.?[0-9]{0,2})$/;
                if (preg.test(__val__) === true) {
                    return true;
                } else {
                    return false;
                }

            }
        </script>
        <!-- DESCARGAR ARCHIVO PARA ENVIO CORREO -->
        <script>
            var textFile = null,
            makeTextFile = function (text) {
              var data = new Blob([text], {type: 'text/plain'});
              if (textFile !== null) {
                window.URL.revokeObjectURL(textFile);
              }
              textFile = window.URL.createObjectURL(data);
              return textFile;
            };

            var create = document.getElementById('create'),
            textbox = document.getElementById('textbox');
            /*
              create.addEventListener('click', function () {

              }, false);
              */

              function download(nombre, url) {
                  var link= document.createElement('a');
                  link.setAttribute('href', url);
                  link.setAttribute('download', nombre);
                  link.click();
              }
        </script>         
        
    </body>
</html>