<?php
session_start();
if (!isset($_SESSION['user_login_status'])) {
    header("location: ./login/index.php");
    exit;
}


if (($_SESSION['pztecattec'] + $_SESSION['pztecpendiente']) == 0) {
    header("location: ./denegado.php");
    exit;
}



date_default_timezone_set('America/Lima');
function myUrlEncode($string)
{
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}


include 'config/db.php';
include 'config/conexion.php';
require_once 'helper/helper_validacion.php';
/*
include 'config/dbsec.php';
include 'config/conexionsec.php';
*/
$rc = NULL;

if (isset($_GET['idventa'])) {
    
    $idventa = sanitizaCampo($_GET['idventa'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $idventa = htmlspecialchars($idventa);

    $rc = sanitizaCampo($_GET['rc'], 'sanitizestring|scapestring|htmlspecialchars',$con);
    $rc = htmlspecialchars($rc);
}

$sql_venta = $con->prepare("SELECT
    u.IdUsuario,
    v.Matricula,
    v.Comercial,
    v.CC,
    v.JefeVenta,
    CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta,
    v.EstadoVenta,
    v.CategoriaVenta,
    v.TipoVenta,
    v.Segmento,
    v.MesesAutorizado,
    v.NProspecto,
    v.NContrato,
    v.IdCliente,
    c.NombApellido Cliente,
    c.Correo,
    c.Telefonouno,
    c.Telefonodos,
    c.Direccion,
    c.Referencia,
    c.Interior,
    g.IdGeografico,
    g.Distrito,
    g.Provincia,
    v.PrecioKit,
    v.TotalExtra,
    v.ResumenVenta,
    v.ExtraAutorizado,
    v.FormaPago,
    v.N590,
    v.PAI,
    v.CCOriginal,
    agen.IdAgenda,
    agen.InstaladoX,
    agen.MatriculaTec,
    CONCAT(t.Nombres,' ',t.Apellidos) Instalador,
    t.LN LNInstalador,
    DATE_FORMAT(agen.FechaInst, '%d/%m/%Y') FechaInst, 
    TIME_FORMAT(agen.HoraInst,'%r') HoraInst,
    agen.Comentario,
    agen.MotivoInviable,
    agen.MotivoCancelada,
    agen.Repercusion,
    agen.RepercusionCosto,
    f.MotivoIncidencia,
    DATE_FORMAT(f.FechaRecepcionDOC, '%d/%m/%Y') FechaRecepcionDOC,
    DATE_FORMAT(f.FechaFacturacion, '%d/%m/%Y') FechaFacturacion,
    f.DOCOriginal,
    f.Segmentacion,
    f.Pago,
    f.Autoriza,
    f.DNI,
    f.ElementosCTOPS,
    f.DOCPAI,
    f.FaltaDOC,
    f.RehacerCTO,
    f.Afiliacion,
    f.Prospecto_NroGuia,
    f.FueraHora,
    v.TCGestor,
    v.TipoKIT,
    agen.FechaGestion,
    agen.FechaAgendamiento,
    agen.FechaInstalacion,
    att.IdAttec,
    DATE_FORMAT(att.FechaAuditoria, '%d/%m/%Y') FechaAuditoria,
    att.EstadoAttec,
    att.DatosSbn,
    att.DatosSbn_NoCoincide,
    DATE_FORMAT(att.F_CorreccionDatosSbn, '%d/%m/%Y') F_CorreccionDatosSbn,
    att.SegIncorrecto,
    DATE_FORMAT(att.F_CorreccionSegIncorrecto, '%d/%m/%Y') F_CorreccionSegIncorrecto,
    att.Seg_DebeDecir,
    att.Imagen,
    DATE_FORMAT(att.F_Imagen, '%d/%m/%Y') F_Imagen,
    att.Imagen_Motivo,
    att.IngresoProgramacion,
    DATE_FORMAT(att.F_CorreccionIngresoProgramacion, '%d/%m/%Y') F_CorreccionIngresoProgramacion,
    att.FallosCobertura,
    DATE_FORMAT(att.F_CorreccionFallosCobertura, '%d/%m/%Y') F_CorreccionFallosCobertura,
    att.MissingTest,
    DATE_FORMAT(att.F_CorreccionMissingTest, '%d/%m/%Y') F_CorreccionMissingTest,
    att.ZeroVision,
    DATE_FORMAT(att.F_CorreccionZeroVision, '%d/%m/%Y') F_CorreccionZeroVision,
    att.FalloSupervision,
    DATE_FORMAT(att.F_CorreccionFalloSupervision, '%d/%m/%Y') F_CorreccionFalloSupervision,
    att.FalloSupervision_Dispotivos,
    att.Tamper,
    DATE_FORMAT(att.F_CorreccionTamper, '%d/%m/%Y') F_CorreccionTamper,
    att.Tamper_Dispotivos,
    att.Comentario as ComentarioAttec,
    att.Zerovision_motivo,
    v.IdCertVenta,
    v.FechaApertura,
    DATE_FORMAT(vtacert.FechaCierre,'%d/%m/%Y') FechaCierre,
    vtacert.TipoCierre,
    vtacert.MotivoIncidencia as MotivoIncidenciaCert,
    vtacert.SolucionIncidencia,
    vtacert.IncidenciaTecnica,
    vtacert.FormaPago as FormaPagoCert,
    vtacert.Comentario as ComentarioCert,
    v.GestorCertVenta,
    CONCAT(cer.Nombres,' ',cer.Apellidos) NombGestorCertVenta,
    att.MG_01_retardo,
    DATE_FORMAT(att.F_CorreccionMG_01_retardo, '%d/%m/%Y') F_CorreccionMG_01_retardo
    FROM dbVENTAS.tblventa v 
    INNER JOIN dbUSUARIO.tblusuario u on v.IdUsuario=u.IdUsuario 
    INNER JOIN dbUSUARIO.tblarea a on a.IdArea=u.IdArea 
    INNER JOIN dbUSUARIO.tblusuario m on m.Matricula=u.Manager
    INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
    INNER JOIN dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
    INNER JOIN dbVENTAS.tblagenda agen on agen.IdVenta=v.IdVenta
    INNER JOIN dbVENTAS.tblfacturacion f on f.IdVenta=v.IdVenta
    LEFT JOIN dbUSUARIO.tblusuario t on t.Matricula=agen.MatriculaTec
    LEFT JOIN dbVENTAS.tblattec att on att.IdVenta=v.IdVenta
    LEFT JOIN dbVENTAS.tblcertificacionventa vtacert on vtacert.IdCertVenta=v.IdCertVenta
    LEFT JOIN dbUSUARIO.tblusuario cer on cer.Matricula=v.GestorCertVenta    
    WHERE v.IdVenta=?");
    $sql_venta->bind_param('i',$idventa);
    $sql_venta->execute();
    $sql_venta->store_result();
    $sql_venta->bind_result(
    $IdUsuarioRow,
    $MatriculaRow,
    $ComercialRow,
    $CCRow,
    $JefeVentaRow,
    $NombJefeVentaRow,
    $EstadoVentaRow,
    $CategoriaVentaRow,
    $TipoVentaRow,
    $SegmentoRow,
    $MesesAutorizadoRow,
    $NProspectoRow,
    $NContratoRow,
    $IdClienteRow,
    $ClienteRow,
    $CorreoRow,
    $TelefonounoRow,
    $TelefonodosRow,
    $DireccionRow,
    $ReferenciaRow,
    $InteriorRow,
    $IdGeograficoRow,
    $DistritoRow,
    $ProvinciaRow,
    $PrecioKitRow,
    $TotalExtraRow,
    $ResumenVentaRow,
    $ExtraAutorizadoRow,
    $FormaPagoRow,
    $N590Row,
    $PAIRow,
    $CCOriginalRow,
    $IdAgendaRow,
    $InstaladoXRow,
    $MatriculaTecRow,
    $InstaladorRow,
    $LNInstaladorRow,
    $FechaInstRow, 
    $HoraInstRow,
    $ComentarioRow,
    $MotivoInviableRow,
    $MotivoCanceladaRow,
    $RepercusionRow,
    $RepercusionCostoRow,
    $MotivoIncidenciaRow,
    $FechaRecepcionDOCRow,
    $FechaFacturacionRow,
    $DOCOriginalRow,
    $SegmentacionRow,
    $PagoRow,
    $AutorizaRow,
    $DNIRow,
    $ElementosCTOPSRow,
    $DOCPAIRow,
    $FaltaDOCRow,
    $RehacerCTORow,
    $AfiliacionRow,
    $Prospecto_NroGuiaRow,
    $FueraHoraRow,
    $TCGestorRow,
    $TipoKITRow,
    $FechaGestionRow,
    $FechaAgendamientoRow,
    $FechaInstalacionRow,
    $IdAttecRow,
    $FechaAuditoriaRow,
    $EstadoAttecRow,
    $DatosSbnRow,
    $DatosSbn_NoCoincideRow,
    $F_CorreccionDatosSbnRow,
    $SegIncorrectoRow,
    $F_CorreccionSegIncorrectoRow,
    $Seg_DebeDecirRow,
    $ImagenRow,
    $F_ImagenRow,
    $Imagen_MotivoRow,
    $IngresoProgramacionRow,
    $F_CorreccionIngresoProgramacionRow,
    $FallosCoberturaRow,
    $F_CorreccionFallosCoberturaRow,
    $MissingTestRow,
    $F_CorreccionMissingTestRow,
    $ZeroVisionRow,
    $F_CorreccionZeroVisionRow,
    $FalloSupervisionRow,
    $F_CorreccionFalloSupervisionRow,
    $FalloSupervision_DispotivosRow,
    $TamperRow,
    $F_CorreccionTamperRow,
    $Tamper_DispotivosRow,
    $ComentarioAttecRow,
    $Zerovision_motivoRow,
    $idcertventa, $FechaApertura, $FechaCierre, $TipoCierre, $MotivoIncidencia, $SolucionIncidencia, $inci_tecnica, $FormaPagoCert, $ComentarioCert, $GestorCertVenta, $NombGestorCertVenta,$MG_01_retardo,$F_CorreccionMG_01_retardo
        );
        
$numrows_venta = $sql_venta->num_rows;

if ($numrows_venta > 0) {
    while ($sql_venta->fetch()) {
        $idu = $IdUsuarioRow;
        $matricula = $MatriculaRow;
        $comercial = $ComercialRow;
        $matjefe = $JefeVentaRow;
        $jefeventa = $NombJefeVentaRow;
        $dc = $CCRow;
        $estadoventa = $EstadoVentaRow;
        $categoriaventa = $CategoriaVentaRow;
        $tipoventa = $TipoVentaRow;
        $segmento = $SegmentoRow;
        $mesesautorizados = $MesesAutorizadoRow;
        $nprospecto = $NProspectoRow;
        $ncontrato = $NContratoRow;
        $idcliente = $IdClienteRow;
        $cliente = $ClienteRow;
        $correo = $CorreoRow;
        $movil = $TelefonounoRow;
        $fijo = $TelefonodosRow;
        $direccion = $DireccionRow;
        $preciokit = $PrecioKitRow;
        $totalextra = $TotalExtraRow;
        $resumenventa = $ResumenVentaRow;
        $regaloutorizado = $ExtraAutorizadoRow;
        $formadepago = $FormaPagoRow;
        $n590 = $N590Row;
        $PAI = $PAIRow;
        $idgeografico = $IdGeograficoRow;
        $distrito = utf8_encode($DistritoRow);
        $provincia = $ProvinciaRow;
        $costo = $RepercusionCostoRow;
        $CCOriginal = $CCOriginalRow;
        $lninstalador = $LNInstaladorRow;
        $idagenda = $IdAgendaRow;
        $instaladox = $InstaladoXRow;
        $matriculatec = $MatriculaTecRow;
        $nomreinstalador = $InstaladorRow;
        $fechainstalacionver = $FechaInstRow;
        $horainstalacionver = $HoraInstRow;
        $comentarioagenda = $ComentarioRow;
        $motivoinviable = $MotivoInviableRow;
        $motivocancelado = $MotivoCanceladaRow;
        $repercucion = $RepercusionRow;
        $factmotivoincidencia = $MotivoIncidenciaRow;
        $factfecharecepciondoc = $FechaRecepcionDOCRow;
        $factfechafacturacion = $FechaFacturacionRow;
        $factdocoriginal = $DOCOriginalRow;
        $factsegmentacion = $SegmentacionRow;
        $factpago = $PagoRow;
        $factautoriza = $AutorizaRow;
        $factdni = $DNIRow;
        $factelementosctops = $ElementosCTOPSRow;
        $factdocpai = $DOCPAIRow;
        $factfaltadoc = $FaltaDOCRow;
        $factrehacercto = $RehacerCTORow;
        $factafiliacion = $AfiliacionRow;
        $factprospecto_nroguia = $Prospecto_NroGuiaRow;
        $factfuerahora = $FueraHoraRow;
        $TCGestor = $TCGestorRow;
        $TipoKIT = $TipoKITRow;
        $Referencia = $ReferenciaRow;
        $Interior = $InteriorRow;
        $FechaGestion =$FechaGestionRow;
        $FechaAgendamiento =$FechaAgendamientoRow;
        $FechaInstalacion =$FechaInstalacionRow;
        $idattec =$IdAttecRow;
        $FechaAuditoria =$FechaAuditoriaRow;
        $EstadoAttec =$EstadoAttecRow;
        $DatosSbn =$DatosSbnRow;
        $DatosSbn_NoCoincide =$DatosSbn_NoCoincideRow;
        $F_CorreccionDatosSbn =$F_CorreccionDatosSbnRow;
        $SegIncorrecto =$SegIncorrectoRow;
        $F_CorreccionSegIncorrecto =$F_CorreccionSegIncorrectoRow;
        $Seg_DebeDecir =$Seg_DebeDecirRow;
        $Imagen =$ImagenRow;
        $F_Imagen =$F_ImagenRow;
        $Imagen_Motivo =$Imagen_MotivoRow;
        $IngresoProgramacion =$IngresoProgramacionRow;
        $F_CorreccionIngresoProgramacion =$F_CorreccionIngresoProgramacionRow;
        $FallosCobertura =$FallosCoberturaRow;
        $F_CorreccionFallosCobertura =$F_CorreccionFallosCoberturaRow;
        $MissingTest =$MissingTestRow;
        $F_CorreccionMissingTest =$F_CorreccionMissingTestRow;
        $ZeroVision =$ZeroVisionRow;
        $F_CorreccionZeroVision =$F_CorreccionZeroVisionRow;
        $FalloSupervision =$FalloSupervisionRow;
        $F_CorreccionFalloSupervision =$F_CorreccionFalloSupervisionRow;
        $FalloSupervision_Dispotivos =$FalloSupervision_DispotivosRow;
        $Tamper =$TamperRow;
        $F_CorreccionTamper =$F_CorreccionTamperRow;
        $Tamper_Dispotivos =$Tamper_DispotivosRow;
        $ComentarioAttec=$ComentarioAttecRow;
        $Zerovision_motivo=$Zerovision_motivoRow;
        
        if(!empty($GestorCertVenta)){
    	     $htmlGestor='<option value="'.$GestorCertVenta.'" selected>'.$GestorCertVenta.' - '.$NombGestorCertVenta.'</option>';
    	 }else{
    	     $htmlGestor='<option value="" selected>Seleccione</option>';
    	 }  
        
    }
}

$html = NULL;

$sql = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) JefeVenta FROM dbUSUARIO.tblusuario u  where u.CC=? AND u.LN='11' AND (u.Categoria ='JE' OR u.Categoria ='COACH' OR u.Categoria ='DEL' or u.Categoria='JE/DEL' or u.Categoria='GERENTE TERRITORIAL' ) LIMIT 50");
$sql->bind_param('i',$CCOriginal);
$sql->execute();
$sql->store_result();
$sql->bind_result(
    $MatriculaRow,
    $JefeVentaRow
    );


if ($sql->num_rows > 0) {
    while ($sql->fetch()) {
        $Matricula = $MatriculaRow;
        $JefeVenta = $JefeVentaRow;
        if ($Matricula == $matjefe) {
            $html .= '<option value="' . $Matricula . '" selected>' . $Matricula . ' - ' . utf8_encode($JefeVenta) . ' </option>';
        } else {
            $html .= '<option value="' . $Matricula . '">' . $Matricula . ' - ' . utf8_encode($JefeVenta) . ' </option>';
        }
    }
} else {
    $html .= '<option>No se encontraron resultado</option>';
}

$html_tecnico = NULL;
if ($lninstalador == "" || empty($lninstalador)) {
    $html_tecnico .= '<option></option>';
} else {

    $sql_tecnico = $con->prepare("SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Instalador FROM dbUSUARIO.tblusuario u  
INNER JOIN dbUSUARIO.tblarea a on a.IdArea=u.IdArea
WHERE u.LN=?");
$sql_tecnico->bind_param('i',$lninstalador);
$sql_tecnico->execute();
$sql_tecnico->store_result();
$sql_tecnico->bind_result(
    $MatriculaRow,
    $InstaladorRow
    );
    

    if ($sql_tecnico->num_rows > 0) {
        while ($sql_tecnico->fetch()) {
            $Matricula = $MatriculaRow;
            $Instalador = $InstaladorRow;
            if ($Matricula == $matriculatec) {
                $html_tecnico .= '<option value="' . $Matricula . '" selected>' . $Matricula . ' - ' . utf8_encode($Instalador) . ' </option>';
            } else {
                $html_tecnico .= '<option value="' . $Matricula . '">' . $Matricula . ' - ' . utf8_encode($Instalador) . ' </option>';
            }
        }
    } else {
        $html_tecnico .= '<option>No se encontraron resultado</option>';
    }
}

$IdAgenRepor = NULL;
$FechaGestion = NULL;
$FechaAgendamiento = NULL;
$FechaInstalacion = NULL;
$FechaCancelada = NULL;
$FechaInviable = NULL;
$FechaIlocalizable = NULL;

$sql_agendareport = $con->prepare("SELECT IdAgenRepor,FechaInstalada,FechaVenta,FechaPrimeraGestion,FechaProgramacion,FechaAgedamiento,FechaCancelada,FechaInviable,FechaIlocalizable FROM tblagendareporte WHERE IdVenta=? ORDER BY 1 DESC LIMIT 1");
$sql_agendareport->bind_param('i',$idventa);
$sql_agendareport->execute();
$sql_agendareport->store_result();
$sql_agendareport->bind_result(
    $IdAgenReporRow,
    $FechaInstaladaRow,
    $FechaVentaRow,
    $FechaPrimeraGestionRow,
    $FechaProgramacionRow,
    $FechaAgedamientoRow,
    $FechaCanceladaRow,
    $FechaInviableRow,
    $FechaIlocalizableRow
    );


if ($sql_agendareport->num_rows > 0) {
    while ($sql_agendareport->fetch()) {
        $IdAgenRepor = $IdAgenReporRow;
        $FechaGestion = $FechaPrimeraGestionRow;
        $FechaAgendamiento = $FechaAgedamientoRow;
        $FechaInstalacion = $FechaInstaladaRow;
        $FechaCancelada = $FechaCanceladaRow;
        $FechaInviable = $FechaInviableRow;
        $FechaIlocalizable = $FechaIlocalizableRow;
    }
}


$IdAttecRepor=NULL;
$FechaInstaladaDEL=NULL;
$FechaGestionAttec=NULL;
$FechaAuditadaOK=NULL;
$FechaObservada=NULL;
$FechaAuditadaResuelta=NULL;
$FechaInstaladaSinAuditar=NULL;
$FechaNoInstalada=NULL;
$FechaObservadaInstalada=NULL;
$FechaDesmontada=NULL;

$sql_attecreport = $con->prepare("SELECT IdAttecRepor,FechaInstaladaDEL,FechaPrimeraGestion,FechaAuditadaOK,FechaObservada,FechaAuditadaResuelta,FechaInstaladaSinAuditar,FechaNoInstalada,FechaObservadaInstalada,FechaDesmontada FROM tblattecreporte WHERE IdVenta=? ORDER BY 1 DESC LIMIT 1"); 
$sql_attecreport->bind_param('i',$idventa);
$sql_attecreport->execute();
$sql_attecreport->store_result();
$sql_attecreport->bind_result(
    $IdAttecReporRow,
    $FechaInstaladaDELRow,
    $FechaPrimeraGestionRow,
    $FechaAuditadaOKRow,
    $FechaObservadaRow,
    $FechaAuditadaResueltaRow,
    $FechaInstaladaSinAuditarRow,
    $FechaNoInstaladaRow,
    $FechaObservadaInstaladaRow,
    $FechaDesmontadaRow
    );



if ($sql_attecreport->num_rows > 0) {
    while ($sql_attecreport->fetch()) {

        $IdAttecRepor=$IdAttecReporRow;
        $FechaInstaladaDEL=$FechaInstaladaDELRow;
        $FechaGestionAttec=$FechaPrimeraGestionRow;
        $FechaAuditadaOK=$FechaAuditadaOKRow;
        $FechaObservada=$FechaObservadaRow;
        $FechaAuditadaResuelta=$FechaAuditadaResueltaRow;
        $FechaInstaladaSinAuditar=$FechaInstaladaSinAuditarRow;
        $FechaNoInstalada=$FechaNoInstaladaRow;
        $FechaObservadaInstalada=$FechaObservadaInstaladaRow;
        $FechaDesmontada=$FechaDesmontadaRow;

    }
}



?>


<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Verisure | VeriSmart</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png">
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">


    <!-- bootstrap datepicker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
    <!-- iCheck for checkboxes and radio inputs -->
    <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
    <!-- Bootstrap time Picker -->
    <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">



    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->

    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">

    <!-- BOOTSTRAP TOOGLE -->
    <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css" />

    <link href="admin/bower_components/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.min.css" rel="stylesheet" type="text/css" />
    <!-- Alertifyjs -->
    <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css" />


    <style>
        .modal-header-danger {
            color: #fff;
            background-color: #e4002b;
        }



        .dataTables_wrapper .myfilter .dataTables_filter {
            float: left
        }

        .dataTables_wrapper .mylength .dataTables_length {
            float: right
        }

        div.dataTables_scrollBody thead th {
            vertical-align: top;
        }

        td {
            max-width: 250px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;

        }

        .espacio {
            height: 10px;
        }

        .espacio2 {
            height: 15px;
        }


        .caption h4 {
            margin-top: -10px;
            font-size: 13px;
            font-weight: bold;
        }

        .caption p {
            color: #777;
            font-size: 13px;
        }

        .caption a {
            color: #777;
            font-size: 10px;
        }


        #frmEditarVenta .form-control {
            border-radius: 4px
        }


        .select2-container--default .select2-selection--single {

            border: 1px solid #d2d6de;
            border-radius: 4px;
            font-size: 12px;
            padding: 4px 6px;
        }

        .btn-nuevo {
            color: #FFFFFF;
            background-color: #444444;
            border-color: #444444;
        }

        .btn-nuevo:hover,
        .btn-nuevo:focus,
        .btn-nuevo:active,
        .btn-nuevo.active,
        .open .dropdown-toggle.btn-nuevo {
            color: #FFFFFF;
            background-color: #616161;
            border-color: #444444;
        }

        .btn-nuevo:active,
        .btn-nuevo.active,
        .open .dropdown-toggle.btn-nuevo {
            background-image: none;
        }

        .btn-nuevo.disabled,
        .btn-nuevo[disabled],
        fieldset[disabled] .btn-nuevo,
        .btn-nuevo.disabled:hover,
        .btn-nuevo[disabled]:hover,
        fieldset[disabled] .btn-nuevo:hover,
        .btn-nuevo.disabled:focus,
        .btn-nuevo[disabled]:focus,
        fieldset[disabled] .btn-nuevo:focus,
        .btn-nuevo.disabled:active,
        .btn-nuevo[disabled]:active,
        fieldset[disabled] .btn-nuevo:active,
        .btn-nuevo.disabled.active,
        .btn-nuevo[disabled].active,
        fieldset[disabled] .btn-nuevo.active {
            background-color: #444444;
            border-color: #444444;
        }
    </style>


    <style>
        .main-header,
        .main-sidebar,
        .left-side {
            position: fixed
        }

        .main-header {
            top: 0;
            right: 0;
            left: 0
        }

        .content-wrapper,
        .right-side {
            padding-top: 50px
        }

        @media (max-width:767px) {

            .content-wrapper,
            .right-side {
                padding-top: 100px
            }
        }

        .layout-boxed .wrapper {
            max-width: 100%
        }
    </style>


    <style>
        .ui-autocomplete {
            position: absolute;
            z-index: 1000;
            cursor: default;
            padding: 0;
            margin-top: 2px;
            list-style: none;
            font-size: 11px;
            font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
            background-color: #ffffff;
            border: 1px solid #ccc;
            -webkit-border-radius: 5px;
            -moz-border-radius: 5px;
            border-radius: 5px;
            -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
            -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
            box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);

            z-index: 1051 !important;

        }

        hr {
            height: 4px;
            width: 100%;
            background-color: #ecf0f5;
            margin-bottom: 20px;
            border: 0;

        }

        hr {
            display: block;
            unicode-bidi: isolate;
            -webkit-margin-before: 0.5em;
            -webkit-margin-after: 0.5em;
            -webkit-margin-start: auto;
            -webkit-margin-end: auto;
            overflow: hidden;
            border-style: inset;

        }

        .box.box-custom {
            border-top-color: #ffffff;
        }

        .box {
            position: relative;
            border-radius: 3px;
            background: #ffffff;
            border-top: 3px solid #d2d6de;
            margin-bottom: 5px;
            width: 100%;
            box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
        }


        .ocultar {
            display: none;
        }

        label {
            font-weight: 400;
            font-size: 12px;
        }

        .subtitulo {
            text-decoration: underline;
            font-weight: bold;
        }

        .centrar-texto {
            text-align: center;
        }
    </style>
    <style>
        .toggle.ios,
        .toggle-on.ios,
        .toggle-off.ios {
            border-radius: 20px;
        }

        .toggle.ios .toggle-handle {
            border-radius: 20px;
        }
    </style>
</head>

<body class="sidebar-collapse skin-red sidebar-mini">

    <div class="wrapper">
        <!-- Header -->
        <?php include 'admin/header.php'; ?>
        <!-- Left side column. contains the logo and sidebar -->
        <?php
        $agenda = "active";
        include 'admin/main-sidebar.php';
        ?>


        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    ATTEC
                </h1>
                <ol class="breadcrumb">
                    <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                    <li><a href="<?php if ($rc == 'pendiente') {
                                        echo 'agendapendiente.php';
                                    } else if ($rc == 'aggestionados') {
                                        echo 'agendagestionados.php';
                                    } else if ($rc == 'attec') {
                                        echo 'attec.php';
                                    } else if ($rc == 'attecpendiente') {
                                        echo 'attecauditoria.php';
                                    } else if ($rc == 'attecobservada') {
                                        echo 'attecauditoria.php';
                                    } else {
                                        echo 'agenda.php';
                                    }
                                    ?>">ATTEC</a></li>
                    <li class="active">Editar de ATTEC</li>
                </ol>


            </section>
            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-md-2"></div>
                    <div class="col-md-8">
                        <div class="box box-danger">
                            <div class="box-header">

                                <div class="form-horizontal">
                                    <div class="form-group" style="margin-bottom: 0px;">
                                        <div class="col-sm-6 col-md-6">
                                            <div class="form-group">
                                                <h3 class="col-sm-12 col-xs-12 box-title" style="text-align:left;">EDITAR</h3>
                                                <div class="col-sm-12 col-xs-12">
                                                    <h3 class="box-title"><?php
                                                                            if ($categoriaventa == "Online") {
                                                                                $nombc = "VENTA ONLINE";
                                                                            } else if ($categoriaventa == "Ficha") {
                                                                                $nombc = "VENTA FICHA";
                                                                            } else {
                                                                                $nombc = "VENTA DELEGACIÓN";
                                                                            }
                                                                            echo $nombc . " - " . $nprospecto . " | " . $ncontrato ?></h3>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="box-tools pull-right">

                                    <?php if ($estadoventa == 'PorFacturar' || $estadoventa == 'Facturada' || $nombacceso == 'test') {
                                    } else { ?>
                                        <a class="btn btn-nuevo btn-sm" id="btnGuardarEditarVenta" href="#"><i class="fa fa-save"></i> Guardar</a>

                                    <?php   } ?>

                                    <a href="<?php if ($rc == 'pendiente') {
                                                    echo 'agendapendiente.php';
                                                } else if ($rc == 'aggestionados') {
                                                    echo 'agendagestionados.php';
                                                } else if ($rc == 'attec') {
                                                    echo 'attec.php';
                                                } else if ($rc == 'attecpendiente') {
                                                    echo 'attecauditoria.php';
                                                } else if ($rc == 'attecobservada') {
                                                    echo 'attecauditoria.php';                                                    
                                                } else {
                                                    echo 'agenda.php';
                                                }

                                                ?>" class="btn btn-danger btn-sm"><i class="fa fa-reply"></i>
                                        Regresar</a>


                                </div>
                            </div>
                        </div>
                        <form id="frmEditarVenta" method="POST">
                            <input type="hidden" id="FechaGestion" name="FechaGestion" value="<?php echo $FechaGestion; ?>">
                            <input type="hidden" id="FechaAgendamiento" name="FechaAgendamiento" value="<?php echo $FechaAgendamiento; ?>">
                            <input type="hidden" id="FechaInstalacion" name="FechaInstalacion" value="<?php echo $FechaInstalacion; ?>">
                            <input type="hidden" id="FechaCancelada" name="FechaCancelada" value="<?php echo $FechaCancelada; ?>">
                            <input type="hidden" id="FechaInviable" name="FechaInviable" value="<?php echo $FechaInviable; ?>">
                            <input type="hidden" id="FechaIlocalizable" name="FechaIlocalizable" value="<?php echo $FechaIlocalizable; ?>">
                            <input type="hidden" id="idattec" value="<?php if (isset($idattec)) {
                                                                            echo $idattec;
                                                                        } else {
                                                                        } ?>">
                            <!-- INFORMACION DE LA VENTA -->
                            <div class="box box-custom">
                                <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                    <h5>INFORMACION DE VENTA</h5>

                                    <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>

                                    </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                    <div class="form-horizontal">
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblmatricula">MATRICULA:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input name="lblmatricula" id="lblmatricula" class="form-control input-sm" value="<?php echo $matricula; ?>" style="width: 100%;" readonly="readonly" />
                                                        <input id="lblidusuario" name="lblidusuario" value="<?php echo $idu; ?>" hidden="">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnombcomercial">COMERCIAL:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input name="lblnombcomercial" id="lblnombcomercial" class="form-control input-sm" style="width: 100%;" value="<?php echo $comercial; ?>" readonly="readonly" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbldc">DC:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input name="lbldc" id="lbldc" class="form-control input-sm" style="width: 100%;" value="<?php echo $dc; ?>" readonly="readonly" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbljefeventa">JEFE VENTA:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm" name="lbljefeventa" id="lbljefeventa" style="width: 100%;" disabled="disabled">
                                                            <?php echo $html; ?>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblestadoventa">ESTADO VENTA:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <select name="lblestadoventa" id="lblestadoventa" class="form-control input-sm" disabled="disabled">
                                                            <option>Seleccione</option>
                                                            <?php
                                                            if ($estadoventa == "AgendadaTEC") {
                                                            ?>
                                                                <option value="AgendadaTEC" <?php if ($estadoventa == "AgendadaTEC") {
                                                                                                echo "selected";
                                                                                            } ?>>
                                                                    AgendadaTEC</option>
                                                                <option value="Instalada" <?php if ($estadoventa == "Instalada") {
                                                                                                echo "selected";
                                                                                            } ?>>
                                                                    Instalada</option>
                                                                <option value="Cancelada" <?php if ($estadoventa == "Cancelada") {
                                                                                                echo "selected";
                                                                                            } ?>>
                                                                    Cancelada</option>


                                                            <?php
                                                            }
                                                            if ($estadoventa == "AgendadaDEL" || $estadoventa == "InstaladaDEL" || $estadoventa == "InstaladaTEC") {
                                                            ?>
                                                                <option value="AgendadaDEL" <?php if ($estadoventa == "AgendadaDEL") {
                                                                                                echo "selected";
                                                                                            } ?>>
                                                                    AgendadaDEL</option>
                                                                <option value="InstaladaDEL" <?php if ($estadoventa == "InstaladaDEL") {
                                                                                                    echo "selected";
                                                                                                } ?>>
                                                                    
                                                                    InstaladaDEL</option>
                                                                <option value="InstaladaTEC" <?php if ($estadoventa == "InstaladaTEC") {
                                                                                                    echo "selected";
                                                                                                } ?>>
                                                                    
                                                                    InstaladaTEC</option>                                                                    
                                                                <option value="Instalada" <?php if ($estadoventa == "Instalada") {
                                                                                                echo "selected";
                                                                                            } ?>>
                                                                    Instalada</option>
                                                                <option value="Cancelada" <?php if ($estadoventa == "Cancelada") {
                                                                                                echo "selected";
                                                                                            } ?>>
                                                                    Cancelada</option>



                                                            <?php
                                                            }
                                                            if ($estadoventa == "PendienteData") {
                                                            ?>
                                                                <option value="PendienteData" <?php if ($estadoventa == "PendienteData") {
                                                                                                    echo "selected";
                                                                                                } ?>>
                                                                    PendienteData</option>
                                                            <?php
                                                            }
                                                            if ($estadoventa == "PendienteAgenda") {
                                                            ?>
                                                                <option value="PendienteAgenda" <?php if ($estadoventa == "PendienteAgenda") {
                                                                                                    echo "selected";
                                                                                                } ?>>
                                                                    PendienteAgenda</option>
                                                            <?php
                                                            }
                                                            if ($estadoventa == "IncidenciaGestCorreo") {
                                                            ?>
                                                                <option value="IncidenciaGestCorreo" <?php if ($estadoventa == "IncidenciaGestCorreo") {
                                                                                                            echo "selected";
                                                                                                        } ?> hidden="">IncidenciaGestCorreo</option>
                                                            <?php
                                                            }
                                                            if ($estadoventa == "IncidenciaGestValija") {
                                                            ?>
                                                                <option value="IncidenciaGestValija" <?php if ($estadoventa == "IncidenciaGestValija") {
                                                                                                            echo "selected";
                                                                                                        } ?> hidden="">IncidenciaGestValija</option>
                                                            <?php
                                                            }
                                                            if ($estadoventa == "Postergada") {
                                                            ?>
                                                                <option value="Postergada" <?php if ($estadoventa == "Postergada") {
                                                                                                echo "selected";
                                                                                            } ?>>
                                                                    Postergada</option>
                                                            <?php
                                                            }
                                                            if ($estadoventa == "Ilocalizable") {
                                                            ?>
                                                                <option value="Ilocalizable" <?php if ($estadoventa == "Ilocalizable") {
                                                                                                    echo "selected";
                                                                                                } ?>>
                                                                    Ilocalizable</option>
                                                            <?php
                                                            }
                                                            if ($estadoventa == "Inviable") {
                                                            ?>
                                                                <option value="Inviable" <?php if ($estadoventa == "Inviable") {
                                                                                                echo "selected";
                                                                                            } ?>>
                                                                    Inviable</option>
                                                            <?php
                                                            }
                                                            if ($estadoventa == "Facturada") {
                                                            ?>
                                                                <option value="Facturada" <?php if ($estadoventa == "Facturada") {
                                                                                                echo "selected";
                                                                                            } ?> hidden="">Facturada</option>
                                                            <?php
                                                            }
                                                            if ($estadoventa == "PorFacturar") {
                                                            ?>
                                                                <option value="PorFacturar" <?php if ($estadoventa == "PorFacturar") {
                                                                                                echo "selected";
                                                                                            } ?> hidden="">PorFacturar</option>
                                                            <?php
                                                            }
                                                            if ($estadoventa == "DocEnvi") {
                                                            ?>
                                                                <option value="DocEnvi" <?php if ($estadoventa == "DocEnvi") {
                                                                                            echo "selected";
                                                                                        } ?> hidden="">DocEnvi</option>
                                                            <?php
                                                            }
                                                            if ($estadoventa == "Incidencia") {
                                                            ?>
                                                                <option value="Incidencia" <?php if ($estadoventa == "Incidencia") {
                                                                                                echo "selected";
                                                                                            } ?> hidden="">Incidencia</option>
                                                            <?php
                                                            }
                                                            if ($estadoventa == "Cancelada") {
                                                            ?>
                                                                <option value="Cancelada" <?php if ($estadoventa == "Cancelada") {
                                                                                                echo "selected";
                                                                                            } ?>>
                                                                    Cancelada</option>
                                                            <?php
                                                            }
                                                            if ($estadoventa == "NoDoc") {
                                                            ?>
                                                                <option value="NoDoc" <?php if ($estadoventa == "NoDoc") {
                                                                                            echo "selected";
                                                                                        } ?> hidden="">NoDoc</option>
                                                            <?php
                                                            }
                                                           
                                                            ?>
                                                            <option value="Instalada" <?php if ($estadoventa == "Instalada") {
                                                                                                echo "selected";
                                                                                            } ?>>
                                                                    Instalada</option>
                                                                <option value="IncidenciaAuditoria" <?php if ($estadoventa == "IncidenciaAuditoria") {
                                                                                                        echo "selected";
                                                                                                    } ?>>
                                                                    IncidenciaAuditoria</option>
                                                                <option value="NoInstalada" <?php if ($estadoventa == "NoInstalada") {
                                                                                                        echo "selected";
                                                                                                    } ?>>
                                                                    NoInstalada</option>
                                                                <option value="Desmontada" <?php if ($estadoventa == "Desmontada") {
                                                                                                        echo "selected";
                                                                                                    } ?>>
                                                                    Desmontada</option>                                                            
                                                            
                                                            <input type="hidden" value="<?php echo $estadoventa; ?>" id="hidestadoventa" name="hidestadoventa" />
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbljefeventa">RECURSO:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input name="lbltipoventa" id="lbltipoventa" class="form-control input-sm" style="width: 100%;" value="<?php echo $tipoventa; ?>" readonly="readonly" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblsegmento">SEGMENTO:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm" name="lblsegmento" id="lblsegmento" disabled="disabled">
                                                            <option>Seleccione</option>
                                                            <option value="RES" <?php if ($segmento == "RES") {
                                                                                    echo "selected";
                                                                                } ?>>RES</option>
                                                            <option value="NEG" <?php if ($segmento == "NEG") {
                                                                                    echo "selected";
                                                                                } ?>>NEG</option>

                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnombcomercial">590:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="mesano" value="<?php echo $n590; ?>" name="lbl590" disabled="disabled">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnprospecto">N° PROSPECTO:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" name="lblnprospecto" id="lblnprospecto" data-inputmask='"mask": "999999"' value="<?php echo $nprospecto; ?>" data-mask readonly="readonly">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblncontrato">N° CONTRATO:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" name="lblncontrato" id="lblncontrato" data-inputmask='"mask": "9999999"' value="<?php echo $ncontrato; ?>" data-mask readonly="readonly">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblmatricula">CLIENTE:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input name="lblnombcliente" class="form-control input-sm" id="lblnombcliente" value="<?php echo $cliente; ?>" style="width: 100%;" readonly="readonly" /></td>
                                                        <input id="lblidcliente" name="lblidcliente" value="<?php echo $idcliente; ?>" hidden="">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnombcomercial">CORREO:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" id="lblcorreo" value="<?php echo $correo; ?>" name="lblcorreo" readonly="readonly">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbldireccion">DIRECCIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <textarea class="form-control input-sm" name="lbldireccion" id="lbldireccion" rows="1" style="resize:none" placeholder="Ingresar..." readonly="readonly"><?php echo $direccion; ?></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbldistrito">DISTRITO:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control selectdistrito input-sm" name="lbldistrito" id="lbldistrito" style="width: 100%;" disabled="disabled">
                                                            <option value="<?php echo $idgeografico; ?>">
                                                                <?php echo $distrito . ' - ' . $provincia; ?></option>

                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinterior">INTERIOR:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" name="lblinterior" id="lblinterior" value="<?php echo $Interior; ?>" disabled>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnombcomercial">REFERENCIA:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group" style="display: flex">
                                                            <input type="text" class="form-control input-sm" id="lblreferencia" name="lblreferencia" value="<?php echo $Referencia; ?>" disabled>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblmovil">TELEFONO UNO:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" name="lblmovil" id="lblmovil" value="<?php echo $movil; ?>" readonly="readonly" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblnombcomercial">TELEFONO DOS:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" name="lblfijo" id="lblfijo" value="<?php echo $fijo; ?>" readonly="readonly" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblmatricula">RESUMEN INST.:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <textarea class="form-control input-sm" name="lblresumenventa" id="lblresumenventa" rows="2" style="resize:none" placeholder="Ingresar..." readonly="readonly"><?php if ($TipoKIT == '' || $TipoKIT == NULL) {
                                                                                                                                                                                                                            echo $resumenventa;
                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                            $posicion_coincidencia = strripos($resumenventa, $TipoKIT);
                                                                                                                                                                                                                            if ($posicion_coincidencia === false) {
                                                                                                                                                                                                                                echo "Kit " . $TipoKIT . " + " . $resumenventa;
                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                echo $resumenventa;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        } ?></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblextraautorizado">REGALO AUTORIZADO:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm" name="lblextraautorizado" id="lblextraautorizado" disabled="disabled">
                                                            <option>Seleccione</option>
                                                            <option value="Ninguno" <?php if ($regaloutorizado == "Ninguno") {
                                                                                        echo "selected";
                                                                                    } ?>>
                                                                Ninguno</option>

                                                            <option value="Mando a distancia" <?php if ($regaloutorizado == "Mando a distancia") {
                                                                                                    echo "selected";
                                                                                                } ?>>
                                                                Mando a distancia</option>
                                                            <option value="Magnetico" <?php if ($regaloutorizado == "Magnetico") {
                                                                                            echo "selected";
                                                                                        } ?>>
                                                                Magnetico</option>
                                                            <option value="Pulsador" <?php if ($regaloutorizado == "Pulsador") {
                                                                                            echo "selected";
                                                                                        } ?>>
                                                                Pulsador</option>


                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- /.box-body -->
                            </div>
                            <!-- INFORMACION DE LA AGENDA -->
                            <div class="box box-custom">
                                <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                    <h5>INFORMACION DE AGENDA</h5>

                                    <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>

                                    </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                    <div class="form-horizontal">
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">INSTALADOX: <span style="color:red"> * </span></label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm" name="lblinstaladox" id="lblinstaladox" disabled="disabled">
                                                            <option value="">Seleccione</option>
                                                            <option value="TEC" <?php if ($instaladox == "TEC") {
                                                                                    echo "selected";
                                                                                } ?>>TEC
                                                            </option>
                                                            <option value="DEL" <?php if ($instaladox == "DEL") {
                                                                                    echo "selected";
                                                                                } ?>>DEL
                                                            </option>
                                                        </select>

                                                        <input id="lblidagenda" name="lblidagenda" value="<?php echo $idagenda; ?>" hidden="">
                                                        <input id="lblIdAgenRepor" name="lblIdAgenRepor" value="<?php echo $IdAgenRepor; ?>" hidden="">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lbltecnico">TÉCNICO: <span style="color:red"> * </span></label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <select name="lbltecnico" id="lbltecnico" class="form-control cbxtecnico input-sm" style="width: 100%;" disabled="disabled">
                                                            <?php echo $html_tecnico; ?>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="fechainst">F.INSTALACIÓN: <span style="color:red"> * </span></label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="fechainst" value="<?php echo $fechainstalacionver; ?>" name="lblfinstalacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblhinstalacion">H.INSTALACIÓN: <span style="color:red"> * </span></label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="bootstrap-timepicker timepicker">
                                                            <div class="input-group">
                                                                <input type="text" class="form-control input-sm" placeholder="12:00 AM" name="lblhinstalacion" id="horainst" value="<?php echo $horainstalacionver; ?>">
                                                                <div class="input-group-addon input-sm">
                                                                    <i class="fa fa-clock-o"></i>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblrepercucion">MOTIVO AGENDA:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm" name="lblrepercucion" id="lblrepercucion" disabled>
                                                            <option value="">Seleccione</option>
                                                            <option value="Ninguno" <?php if ($repercucion == "Ninguno") {
                                                                                        echo "selected";
                                                                                    } ?>>Ninguno
                                                            </option>
                                                            <option value="Noventa" <?php if ($repercucion == "Noventa") {
                                                                                        echo "selected";
                                                                                    } ?>>No
                                                                venta</option>
                                                            <option value="Clienteausente" <?php if ($repercucion == "Clienteausente") {
                                                                                                echo "selected";
                                                                                            } ?>>
                                                                Cliente ausente</option>
                                                            <option value="Nodeseaelservicio" <?php if ($repercucion == "Nodeseaelservicio") {
                                                                                                    echo "selected";
                                                                                                } ?>>
                                                                No desea el servicio</option>
                                                            <option value="Lugarenobras" <?php if ($repercucion == "Lugarenobras") {
                                                                                                echo "selected";
                                                                                            } ?>>
                                                                Lugar en obras</option>
                                                            <option value="Nodisponedetiempo" <?php if ($repercucion == "Nodisponedetiempo") {
                                                                                                    echo "selected";
                                                                                                } ?>>
                                                                No dispone de tiempo</option>
                                                            <option value="Cobertura" <?php if ($repercucion == "Cobertura") {
                                                                                            echo "selected";
                                                                                        } ?>>
                                                                Cobertura</option>
                                                            <option value="MotivosEconomicos" <?php if ($repercucion == "MotivosEconomicos") {
                                                                                                    echo "selected";
                                                                                                } ?>>
                                                                Motivos Económicos</option>
                                                            <option value="MotivosPersonales" <?php if ($repercucion == "MotivosPersonales") {
                                                                                                    echo "selected";
                                                                                                } ?>>
                                                                Motivos Personales</option>
                                                            <option value="RetrasoTecnico" <?php if ($repercucion == "RetrasoTecnico") {
                                                                                                echo "selected";
                                                                                            } ?>>
                                                                Retraso Técnico</option>

                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcosto">COSTO DESPLAZAMIENTO:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm" name="lblcosto" id="lblcosto" disabled>
                                                            <option value="">Seleccione</option>
                                                            <option value="Ninguno" <?php if ($costo == "Ninguno") {
                                                                                        echo "selected";
                                                                                    } ?> disabled="disabled">Ninguno</option>
                                                            <option value="SI" <?php if ($costo == "SI") {
                                                                                    echo "selected";
                                                                                } ?>>SI
                                                            </option>
                                                            <option value="NO" <?php if ($costo == "NO") {
                                                                                    echo "selected";
                                                                                } ?>>NO
                                                            </option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">

                                            <div class="col-sm-6 col-md-8">
                                                <div class="form-group">
                                                    <label class="col-md-3 col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcomentarioagenda">COMENTARIO: <span style="color:red"> * </span></label>
                                                    <div class="col-md-9 col-sm-8 col-xs-8">
                                                        <textarea class="form-control input-sm" name="lblcomentarioagenda" id="lblcomentarioagenda" rows="2" style="resize:none" placeholder="Ingresar..." disabled><?php echo utf8_encode($comentarioagenda); ?></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-4">
                                                <div class="form-group">
                                                    <label class="col-md-4 col-sm-4 col-xs-4 control-label" style="text-align:left;" for="logcambios">LOG CAMBIOS: <span style="color:red"> * </span></label>
                                                    <div class="col-md-4 col-sm-8 col-xs-8">
                                                        <a class="btn btn-danger btn-sm" href="#" data-toggle="modal" id="logcambios" data-target="#modal-default"><i class="fa fa-pencil-square-o"></i> Log Cambios</a>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;display:none;">
                                            <div class="col-sm-6 col-md-6" id="tinviable">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinviable">MOTIVO INVIABLE:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <textarea class="form-control input-sm" name="lblinviable" id="lblinviable" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo utf8_encode($motivoinviable); ?></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6" id="tcancelado">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcancelado">MOTIVO CANCELADO:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <textarea class="form-control input-sm" name="lblcancelado" id="lblcancelado" rows="1" style="resize:none" placeholder="Ingresar..."><?php echo $motivocancelado; ?></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.box-body -->
                            </div>
                            <!-- INFORMACION DE AUDITORIA -->
                            <div class="box box-custom">
                            <input type="hidden" id="lblIdAttecRepor" name="lblIdAttecRepor" value="<?php echo $IdAttecRepor; ?>">
                            <input type="hidden" id="FechaGestionAttec" name="FechaGestionAttec" value="<?php echo $FechaGestionAttec; ?>">
                            <input type="hidden" id="FechaAuditadaOK" name="FechaAuditadaOK" value="<?php echo $FechaAuditadaOK; ?>">
                            <input type="hidden" id="FechaObservada" name="FechaObservada" value="<?php echo $FechaObservada; ?>">
                            <input type="hidden" id="FechaAuditadaResuelta" name="FechaAuditadaResuelta" value="<?php echo $FechaAuditadaResuelta; ?>">
                            <input type="hidden" id="FechaInstaladaSinAuditar" name="FechaInstaladaSinAuditar" value="<?php echo $FechaInstaladaSinAuditar; ?>">
                            <input type="hidden" id="FechaNoInstalada" name="FechaNoInstalada" value="<?php echo $FechaNoInstalada; ?>">
                            <input type="hidden" id="FechaObservadaInstalada" name="FechaObservadaInstalada" value="<?php echo $FechaObservadaInstalada; ?>">
                            <input type="hidden" id="FechaDesmontada" name="FechaDesmontada" value="<?php echo $FechaDesmontada; ?>">
                            
                                <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                    <h5>INFORMACION DE ATTEC</h5>

                                    <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>

                                    </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                    <div class="form-horizontal">
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="FechaInstaladaDEL">FECHA INSTALADEL:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="FechaInstaladaDEL" value="<?php echo $FechaInstaladaDEL; ?>" name="FechaInstaladaDEL" readonly>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechaautidoria">FECHA AUDITORÍA:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechaautidoria" value="<?php echo $FechaAuditoria; ?>" name="lblfechaautidoria" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblestadoattec">ESTADO ATTEC:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <select class="form-control input-sm" name="lblestadoattec" id="lblestadoattec">
                                                            <option value="">Seleccione</option>
                                                            <option value="Observada" <?php if ($EstadoAttec == "Observada") {
                                                                                            echo "selected";
                                                                                        } ?>>Observada</option>
                                                            <option value="AuditadaOK" <?php if ($EstadoAttec == "AuditadaOK") {
                                                                                            echo "selected";
                                                                                        } ?> <?php if ($EstadoAttec == "Observada" || $EstadoAttec == "InstaladaSinAuditar") {
                                                                                            echo "hidden";
                                                                                        } ?> >AuditadaOK</option>
                                                            <option value="AuditadaResuelta" <?php if ($EstadoAttec == "AuditadaResuelta") {
                                                                                                    echo "selected";
                                                                                        } ?> <?php if ($EstadoAttec == "" || $EstadoAttec == "AuditadaOK" || $EstadoAttec == "InstaladaSinAuditar") {
                                                                                            echo "hidden";
                                                                                        } ?> >AuditadaResuelta</option>
                                                            <option value="InstaladaSinAuditar" <?php if ($EstadoAttec == "InstaladaSinAuditar") {
                                                                                                    echo "selected";
                                                                                                } ?><?php if ($EstadoAttec == "Observada") {
                                                                                            echo "hidden";
                                                                                        } ?>>InstaladaSinAuditar</option>
                                                            <option value="ObservadaInstalada" <?php if ($EstadoAttec == "ObservadaInstalada") {
                                                                                                    echo "selected";
                                                                                                } ?><?php if ($EstadoAttec == "" || $EstadoAttec == "AuditadaOK") {
                                                                                            echo "hidden";
                                                                                        } ?>>ObservadaInstalada</option>                                                                                        
                                                                                        
                                                                                        
                                                            <option value="NoInstalada" <?php if ($EstadoAttec == "NoInstalada") {
                                                                                                    echo "selected";
                                                                                                } ?>>NoInstalada</option>
                                                            <option value="Desmontaje" <?php if ($EstadoAttec == "Desmontaje") {
                                                                                                    echo "selected";
                                                                                                } ?>>Desmontaje</option>                                                                                        
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div>
                                            <h5 class="subtitulo" style="font-size: 12px; color:red">INCIDENCIAS (*):</h5>
                                        </div>
                                        <input type="hidden" id="datosFalloSupervision" value='<?php echo $FalloSupervision_Dispotivos; ?>'>
                                        <input type="hidden" id="datosExtras" value='<?php echo $Tamper_Dispotivos; ?>'>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="datossbn">DATOS SBN:</label>
                                                    <div class="col-sm-8 col-xs-8">

                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                            <input type="checkbox" name="datossbn" id="datossbn" data-size="small" data-style="ios" <?php if ($DatosSbn == "SI") {
                                                                                                                                                        echo 'checked';
                                                                                                                                                    } else {
                                                                                                                                                        echo '';
                                                                                                                                                    } ?> />
                                                            <input type="hidden" name="hidden_datossbn" id="hidden_datossbn" value="<?php if ($DatosSbn == "SI") {
                                                                                                                                        echo 'SI';
                                                                                                                                    } else {
                                                                                                                                        echo 'NO';
                                                                                                                                    } ?>">
                                                            </div>
                                                            <div class="col-lg-6 col-md-8 col-sm-8 col-xs-8 datossbn <?php if($DatosSbn == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                                <select class="form-control input-sm" name="lbldatossbncorreccion" id="lbldatossbncorreccion">
                                                                    <option value="">NO COINCIDE</option>
                                                                    <option value="Direccion" <?php if ($DatosSbn_NoCoincide == "Direccion") {
                                                                                            echo "selected";
                                                                                        } ?>>Direccion</option>
                                                                    <option value="Distrito" <?php if ($DatosSbn_NoCoincide == "Distrito") {
                                                                                            echo "selected";
                                                                                        } ?>>Distrito</option>
                                                                    <option value="Segmento" <?php if ($DatosSbn_NoCoincide == "Segmento") {
                                                                                            echo "selected";
                                                                                        } ?>>Segmento</option>                                                                                        
                                                                </select>
                                                            </div>
                                                        </div>                                                                                                                                
                                                                                                                                
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_datossbn">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_datossbn" value="<?php echo $F_CorreccionDatosSbn; ?>" name="lblfechacorrecion_datossbn" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask <?php if($DatosSbn == "SI") {echo '';} else {echo 'disabled';} ?>>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="imagen">IMAGEN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="imagen" id="imagen" data-size="small" data-style="ios" <?php if ($Imagen == "SI") {
                                                                                                                                                    echo 'checked';
                                                                                                                                                } else {
                                                                                                                                                    echo '';
                                                                                                                                                } ?>/>
                                                                <input type="hidden" name="hidden_imagen" id="hidden_imagen" value="<?php if ($Imagen == "SI") {
                                                                                                                                    echo 'SI';
                                                                                                                                } else {
                                                                                                                                    echo 'NO';
                                                                                                                                } ?>">
                                                            </div>
                                                            <div class="col-lg-6 col-md-8 col-sm-8 col-xs-8 imagen <?php if($Imagen == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                                <select class="form-control input-sm" name="lblimagen_motivo" id="lblimagen_motivo">
                                                                    <option value="">MOTIVO</option>
                                                                    <option value="Zona Abierta" <?php if ($Imagen_Motivo == "Zona Abierta") {
                                                                                            echo "selected";
                                                                                        } ?>>Zona Abierta</option>
                                                                    <option value="Enfoque Calle" <?php if ($Imagen_Motivo == "Enfoque Calle") {
                                                                                            echo "selected";
                                                                                        } ?>>Enfoque Calle</option>
                                                                    <option value="Sensor no fijado" <?php if ($Imagen_Motivo == "Sensor no fijado") {
                                                                                            echo "selected";
                                                                                        } ?>>Sensor no fijado</option>
                                                                    <option value="Sensor Obstruido" <?php if ($Imagen_Motivo == "Sensor Obstruido") {
                                                                                            echo "selected";
                                                                                        } ?>>Sensor Obstruido</option>
                                                                    <option value="Zona Inviable" <?php if ($Imagen_Motivo == "Zona Inviable") {
                                                                                            echo "selected";
                                                                                        } ?>>Zona Inviable</option>                                                                                          
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_imagen">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_imagen" value="<?php echo $F_Imagen; ?>" name="lblfechacorrecion_imagen" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask <?php if($Imagen == "SI") {echo '';} else {echo 'disabled';} ?>>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>                                        
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="segincorrecto">SEGMENTO INCORRECTO:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                <input type="checkbox" name="segincorrecto" id="segincorrecto" data-size="small" data-style="ios" <?php if ($SegIncorrecto == "SI") {
                                                                                                                                                    echo 'checked';
                                                                                                                                                } else {
                                                                                                                                                    echo '';
                                                                                                                                                } ?> />
                                                                <input type="hidden" name="hidden_segincorrecto" id="hidden_segincorrecto" value="<?php if ($SegIncorrecto == "SI") {
                                                                                                                                    echo 'SI';
                                                                                                                                } else {
                                                                                                                                    echo 'NO';
                                                                                                                                } ?>">
                                                            </div>
                                                            <div class="col-lg-6 col-md-8 col-sm-8 col-xs-8 segcorrecion <?php if($SegIncorrecto == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                                <select class="form-control input-sm" name="lblsegmentocorreccion" id="lblsegmentocorreccion">
                                                                    <option value="">DEBE DECIR</option>
                                                                    <option value="RES" <?php if ($Seg_DebeDecir == "RES") {
                                                                                            echo "selected";
                                                                                        } ?>>RES</option>
                                                                    <option value="NEG" <?php if ($Seg_DebeDecir == "NEG") {
                                                                                            echo "selected";
                                                                                        } ?>>NEG</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_segincorrecto">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_segincorrecto" value="<?php echo $F_CorreccionSegIncorrecto; ?>" name="lblfechacorrecion_segincorrecto" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask <?php if($SegIncorrecto == "SI") {echo '';} else {echo 'disabled';} ?>>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="tamper">TAMPER (MANIPULACIÓN):</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="checkbox" name="tamper" id="tamper" data-size="small" data-style="ios" <?php if ($Tamper == "SI") {
                                                                                                                                                    echo 'checked';
                                                                                                                                                } else {
                                                                                                                                                    echo '';
                                                                                                                                                } ?>/>
                                                        <input type="hidden" name="hidden_tamper" id="hidden_tamper" value="<?php if ($Tamper == "SI") {
                                                                                                                                    echo 'SI';
                                                                                                                                } else {
                                                                                                                                    echo 'NO';
                                                                                                                                } ?>">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_datossbn">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_tamper" value="<?php echo $F_CorreccionTamper; ?>" name="lblfechacorrecion_tamper" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask <?php if($Tamper == "SI") {echo '';} else {echo 'disabled';} ?>>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group tamper <?php if ($Tamper == "SI") {echo '';} else { echo 'ocultar';} ?>" style="margin-bottom: 0px;">
                                            <div class="col-sm-2 col-md-2">
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="box-body">
                                                    <div class="row">
                                                        <label for="cboProducto" class="col-md-2 control-label">DISPOSITVO:</label>
                                                        <div class="col-md-4">
                                                            <select class="form-control input-sm" id="cboProducto" name="cboProducto" style="width: 100%">
                                                                <option value="" disabled selected>--Seleccione--</option>
                                                                <?php
                                                                $query = "SELECT IdItem, CodItem, Item, Precio, CuotaMes
                                                                FROM dbVENTAS.tblitem
                                                                where CategoriaItem = 'attec' and Estado = 'Activo' || IdItem = 115";
                                                                $resultado = $con->query($query);

                                                                while ($data = $resultado->fetch_assoc()) {
                                                                ?>
                                                                    <option value="<?php echo $data['IdItem']; ?>"><?php echo $data['Item']; ?></option>
                                                                <?php } ?>
                                                            </select>
                                                            <input type="hidden" id="hidProducto" name="hidProducto">
                                                        </div>


                                                        <label for="cantidadProductos" class="col-md-2 control-label">CANTIDAD:</label>
                                                        <div class="col-md-2">
                                                            <input type="number" class="form-control input-sm" id="cantidadProductos" name="cantidadProductos">
                                                        </div>
                                                        <div class="col-md-2">
                                                            <button type="button" class="btn btn-danger btn-sm pull-right" id="btnAgregar" name="btnAgregar"><i class="fa fa-plus"></i>&nbsp AGREGAR </button>
                                                        </div>


                                                    </div>
                                                    <div class="row">
                                                        <div id="listaExtras" class="col-md-12">

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>

                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="ingresoprogramacion">INGRESO A PROGRAMACIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="checkbox" name="ingresoprogramacion" id="ingresoprogramacion" data-size="small" data-style="ios" <?php if ($IngresoProgramacion == "SI") {
                                                                                                                                                    echo 'checked';
                                                                                                                                                } else {
                                                                                                                                                    echo '';
                                                                                                                                                } ?>/>
                                                        <input type="hidden" name="hidden_ingresoprogramacion" id="hidden_ingresoprogramacion" value="<?php if ($IngresoProgramacion == "SI") {
                                                                                                                                    echo 'SI';
                                                                                                                                } else {
                                                                                                                                    echo 'NO';
                                                                                                                                } ?>">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_ingresoprogramacion">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_ingresoprogramacion" value="<?php echo $F_CorreccionIngresoProgramacion; ?>" name="lblfechacorrecion_ingresoprogramacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask <?php if($IngresoProgramacion == "SI") {echo '';} else {echo 'disabled';} ?>>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="hidden_falloscomunicacion">FALLOS DE COMUNICACIÓN (COBERTURA):</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="checkbox" name="falloscomunicacion" id="falloscomunicacion" data-size="small" data-style="ios" <?php if ($FallosCobertura == "SI") {
                                                                                                                                                    echo 'checked';
                                                                                                                                                } else {
                                                                                                                                                    echo '';
                                                                                                                                                } ?>/>
                                                        <input type="hidden" name="hidden_falloscomunicacion" id="hidden_falloscomunicacion" value="<?php if ($FallosCobertura == "SI") {
                                                                                                                                    echo 'SI';
                                                                                                                                } else {
                                                                                                                                    echo 'NO';
                                                                                                                                } ?>">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_falloscomunicacion">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_falloscomunicacion" value="<?php echo $F_CorreccionFallosCobertura; ?>" name="lblfechacorrecion_falloscomunicacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask <?php if($FallosCobertura == "SI") {echo '';} else {echo 'disabled';} ?>>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group" style="margin-bottom: 0px;">
                                          
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="segincorrecto">ZERO VISION:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="form-group" style="margin-bottom: 0px;">
                                                            <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
                                                                                                                        <input type="checkbox" name="zerovision" id="zerovision" data-size="small" data-style="ios" <?php if ($ZeroVision == "SI") {
                                                                                                                                                    echo 'checked';
                                                                                                                                                } else {
                                                                                                                                                    echo '';
                                                                                                                                                } ?>/>
                                                        <input type="hidden" name="hidden_zerovision" id="hidden_zerovision" value="<?php if ($ZeroVision == "SI") {
                                                                                                                                    echo 'SI';
                                                                                                                                } else {
                                                                                                                                    echo 'NO';
                                                                                                                                } ?>">
                                                            </div>
                                                            <div class="col-lg-6 col-md-8 col-sm-8 col-xs-8 zerovisioncorrecion <?php if($ZeroVision == "SI") {echo '';} else {echo 'ocultar';} ?>">
                                                                <select class="form-control input-sm" name="lblzerovisioncorreccion" id="lblzerovisioncorreccion">
                                                                    <option value="" disabled selected>MOTIVO</option>
                                                                    <option value="Panel Apagado" <?php if ($Zerovision_motivo == "Panel Apagado") {
                                                                                            echo "selected";
                                                                                        } ?>>Panel Apagado</option>
                                                                    <option value="Trigger Key" <?php if ($Zerovision_motivo == "Trigger Key") {
                                                                                            echo "selected";
                                                                                        } ?>>Trigger Key</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>                                            
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_datossbn">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_zerovision" value="<?php echo $F_CorreccionZeroVision; ?>" name="lblfechacorrecion_zerovision" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask <?php if($ZeroVision == "SI") {echo '';} else {echo 'disabled';} ?>>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">FALLO DE SUPERVISION:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="checkbox" name="fallosupervision" id="fallosupervision" data-size="small" data-style="ios" <?php if ($FalloSupervision == "SI") {
                                                                                                                                                    echo 'checked';
                                                                                                                                                } else {
                                                                                                                                                    echo '';
                                                                                                                                                } ?>/>
                                                        <input type="hidden" name="hidden_fallosupervision" id="hidden_fallosupervision" value="<?php if ($FalloSupervision == "SI") {
                                                                                                                                    echo 'SI';
                                                                                                                                } else {
                                                                                                                                    echo 'NO';
                                                                                                                                } ?>">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_fallosupervision">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_fallosupervision" value="<?php echo $F_CorreccionFalloSupervision; ?>" name="lblfechacorrecion_fallosupervision" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask <?php if($FalloSupervision == "SI") {echo '';} else {echo 'disabled';} ?>/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group fallosupervision <?php if ($FalloSupervision == "SI") { echo '';} else {echo 'ocultar';} ?>" style="margin-bottom: 0px;">
                                            <div class="col-sm-2 col-md-2">
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="box-body">
                                                    <div class="row">
                                                        <label for="cboProductoFalloSupervision" class="col-md-2 control-label">DISPOSITVO:</label>
                                                        <div class="col-md-4">
                                                            <select class="form-control input-sm" id="cboProductoFalloSupervision" name="cboProductoFalloSupervision" style="width: 100%">
                                                                <option value="" disabled>--Seleccione--</option>
                                                                <?php


                                                                        $queryCodigo = "SELECT IdItem, CodItem, Item, Precio, CuotaMes
                                                                FROM dbVENTAS.tblitem
                                                                where CategoriaItem = 'attec' and Estado = 'Activo' || IdItem = 115";    
                                                                    	
                                                                    	try{       
                                                                            $stmt = $con->prepare($queryCodigo);
                                                                            //$stmt->bind_param('i', $IdConsultaScoringRP);
                                                                            $stmt->execute();
                                                                            $stmt->store_result();
                                                                            $stmt->bind_result(
                                                                                $IdItem,
                                                                                $CodItem,
                                                                                $Item,
                                                                                $Precio,
                                                                                $CuotaMes
                                                                               );
                                                                            $stmt->fetch();
                                                                                while ($stmt->fetch()){
                                                                                    echo $IdItem;
                                                                                     ?>
                                                                               <option value="<?php echo $IdItem; ?>"><?php echo  $Item; ?></option>          
                                                                        	  <?php } 
                                                                        	    
                                                                            $stmt->close();
                                                                    
                                                                        } catch(PDOException $e) {
                                                                            echo "Error: " . $e->getMessage();
                                                                        }                                                                
                                                                                                                                    
                                                                ?>
                                                            </select>
                                                            <input type="hidden" id="hidProductoFalloSupervision" name="hidProductoFalloSupervision">
                                                        </div>


                                                        <label for="cantidadProductosFalloSupervision" class="col-md-2 control-label">CANTIDAD:</label>
                                                        <div class="col-md-2">
                                                            <input type="number" class="form-control input-sm" id="cantidadProductosFalloSupervision" name="cantidadProductosFalloSupervision">
                                                        </div>
                                                        <div class="col-md-2">
                                                            <button type="button" class="btn btn-danger btn-sm pull-right" id="btnAgregarFalloSupervision" name="btnAgregar"><i class="fa fa-plus"></i>&nbsp AGREGAR </button>
                                                        </div>


                                                    </div>
                                                    <div class="row">
                                                        <div id="listaFalloSupervision" class="col-md-12">

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">MISSING TEST:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="checkbox" name="missingtest" id="missingtest" data-size="small" data-style="ios" <?php if ($MissingTest == "SI") {
                                                                                                                                                    echo 'checked';
                                                                                                                                                } else {
                                                                                                                                                    echo '';
                                                                                                                                                } ?>/>
                                                        <input type="hidden" name="hidden_missingtest" id="hidden_missingtest" value="<?php if ($MissingTest == "SI") {
                                                                                                                                    echo 'SI';
                                                                                                                                } else {
                                                                                                                                    echo 'NO';
                                                                                                                                } ?>">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_datossbn">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_missingtest" value="<?php echo $F_CorreccionMissingTest; ?>" name="lblfechacorrecion_missingtest" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask <?php if($MissingTest == "SI") {echo '';} else {echo 'disabled';} ?>>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">MG01 EN RETARDO:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="checkbox" name="MG_01_retardo" id="MG_01_retardo" data-size="small" data-style="ios" <?php if ($MG_01_retardo == "SI") {
                                                                                                                                                    echo 'checked';
                                                                                                                                                } else {
                                                                                                                                                    echo '';
                                                                                                                                                } ?>/>
                                                        <input type="hidden" name="hidden_MG_01_retardo" id="hidden_MG_01_retardo" value="<?php if ($MG_01_retardo == "SI") {
                                                                                                                                    echo 'SI';
                                                                                                                                } else {
                                                                                                                                    echo 'NO';
                                                                                                                                } ?>">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblfechacorrecion_MG_01_retardo">FECHA CORRECIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechacorrecion_MG_01_retardo" value="<?php echo $F_CorreccionMG_01_retardo; ?>" name="lblfechacorrecion_MG_01_retardo" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask <?php if($MG_01_retardo == "SI") {echo '';} else {echo 'disabled';} ?>/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-8">
                                                <div class="form-group">
                                                    <label class="col-md-3 col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblplantillacomentario"><span style="color:#2c3b41"> <i class="fa fa-fw fa-info"></i>COMENTARIO:</span></label>
                                                    <div class="col-md-9 col-sm-8 col-xs-8">
                                                        <textarea class="form-control input-sm" name="lblplantillacomentario" id="lblplantillacomentario" rows="3" style="resize:none" placeholder="Ingresar..."><?php echo utf8_encode($ComentarioAttec); ?></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-4">
                                                <div class="form-group">
                                                    <label class="col-md-4 col-sm-4 col-xs-4 control-label" style="text-align:left;" for="logcambiosattec">LOG CAMBIOS: <span style="color:red"> * </span></label>
                                                    <div class="col-md-4 col-sm-8 col-xs-8">
                                                        <a class="btn btn-danger btn-sm" href="#" data-toggle="modal" id="logcambiosattec" data-target="#modal-default-logcambiosattec"><i class="fa fa-pencil-square-o"></i> Log Cambios</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.box-body -->
                            </div>
								<div class="box box-custom">
									<div class="box-header with-border" style="background-color:#2c3b41;color:white;">
										<h5>INFORMACION DE CERTIFICACIÓN VENTA</h5>
										<div class="box-tools pull-right">
											<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
											</button>
										</div>
									</div>
									<!-- /.box-header -->
									<div class="box-body">
										<input type="hidden" id="idcertventa" value="<?php if(isset($idcertventa)){echo $idcertventa;}else{}?>">
										<input type="hidden" id="lblpermiso" value="<?php echo $nombacceso;?>">
										<table cellspacing="0" style="width:100%;border-collapse: separate;padding: 20px;">
											<tr>
												<td style="width:15%;font-size: 12px">GESTOR:</td>
												<td style="width:25%">
													<select class="form-control selectgestor input-sm" name="lblasignado" id="lblasignado" style="width: 100%;" disabled="disabled">
													<?php echo $htmlGestor;?>></php>
													</select>
													<input type="hidden" id="hidlblasignadoCert" value="<?php echo $GestorCertVenta;?>">
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">FECHA DE APERTURA:</td>
												<td style="width:2%"></td>
												<td style="width:25%">
													<div class="input-group" id="fi">
														<div class="input-group-addon input-sm">
															<i class="fa fa-calendar"></i>
														</div>
														<input type="text" class="form-control pull-right input-sm" id="lblfechaapertura_cert" value="<?php echo $FechaApertura;?>"  name="lblfechaapertura_cert" disabled="disabled">
													</div>
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">FECHA CIERRE:</td>
												<td style="width:25%">
													<div class="input-group" id="fi">
														<div class="input-group-addon input-sm">
															<i class="fa fa-calendar"></i>
														</div>
														<input type="text" class="form-control pull-right input-sm" id="lblfechacierre_cert" value="<?php echo $FechaCierre;?>"  name="lblfechacierre_cert" disabled="disabled">
													</div>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">TIPO CIERRE:</td>
												<td style="width:2%"></td>
												<td style="width:25%">
												    <input type="text" class="form-control pull-right input-sm" id="lbltipocierre_cert" value="<?php echo $TipoCierre;?>"  name="lbltipocierre_cert" disabled="disabled">
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr class="motivocierretc">
												<td style="width:15%;font-size: 12px">MOTIVO INCIDENCIA:</td>
												<td style="width:25%">
													<input type="text" class="form-control pull-right input-sm" id="lblmotivoincidencia_cert" value="<?php echo $MotivoIncidencia;?>"  name="lblmotivoincidencia_cert" disabled="disabled">
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">SOLUCION INCIDENCIA:</td>
												<td style="width:2%"></td>
												<td style="width:25%">
													<input type="text" class="form-control pull-right input-sm" id="lblsolucionincidencia_cert" value="<?php echo $SolucionIncidencia;?>"  name="lblsolucionincidencia_cert" disabled="disabled">
												</td>
											</tr>
											<tr class="espacio"></tr>
											<tr>
												<td style="width:15%;font-size: 12px">INC. TECNICA:</td>
												<td style="width:25%;">
												    <input type="checkbox" name="inci_tecnica" id="inci_tecnica" <?php if($inci_tecnica=="SI"){echo 'checked';}else{echo '';}?> data-size="small" disabled="disabled"/>
												</td>
												<td style="width:10%"></td>
												<td style="width:15%;font-size: 12px">FORMA PAGO:</td>
												<td style="width:2%"></td>
												<td style="width:25%">
													<input type="text" class="form-control pull-right input-sm" id="lblformapago_cert" value="<?php echo $FormaPagoCert;?>"  name="lblformapago_cert" disabled="disabled">
												</td>
											</tr>
                                                                    <tr class="espacio"></tr>
                                                                     <tr>
                                                                        <td style="width:15%;font-size: 12px">COMENTARIO:</td>

                                                                        <td colspan="3" style="width:77%">
                                                                        <textarea class="form-control input-sm" name="lblcomentario_cert" id="lblcomentario_cert" rows="2" style="resize:none"  placeholder="Ingresar..."><?php echo $ComentarioCert;?></textarea>    
                                                                        </td>

                                                                        <td style="width:2%"></td>
                                                                        <td style="width:25%">
                                                                        </td>
                                                                    </tr>  
										</table>
									</div>
									<!-- /.box-body -->
								</div>                            
                            <!-- INFORMACION DE LA FACTURACION -->
                            <div class="box box-custom">
                                <div class="box-header with-border" style="background-color:#2c3b41;color:white;">
                                    <h5>INFORMACION DE FACTURACIÓN</h5>
                                    <div class="box-tools pull-right">
                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                                        </button>
                                    </div>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                    <div class="form-horizontal">
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-12 col-md-12">
                                                <div class="form-group">
                                                    <label class="col-sm-2 col-xs-4 control-label" style="text-align:left;" for="lblmotivoincidencia">MOTIVO INCIDENCIA: </label>
                                                    <div class="col-sm-10 col-xs-8">
                                                        <textarea class="form-control input-sm" name="lblmotivoincidencia" id="lblmotivoincidencia" rows="1" style="resize:none" placeholder="Ingresar..." disabled="disabled"><?php echo $factmotivoincidencia; ?></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">FECHA RECEPCION DOC.:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfecharecpciondoc" name="lblfecharecpciondoc" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask value="<?php echo $factfecharecepciondoc; ?>" disabled="disabled">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">FECHA DE FACTURACIÓN: <span style="font-size: 12px; color:red ">(*)</span></label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <div class="input-group-addon input-sm">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input type="text" class="form-control pull-right input-sm" id="lblfechafacturacion" name="lblfechafacturacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask value="<?php echo $factfechafacturacion; ?>" disabled="disabled" />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div>
                                            <h5 class="subtitulo" style="font-size: 12px; color:red">MOTIVOS DE INCIDENCIA (*):</h5>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-3 col-md-3">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">DOC. ORIGINAL:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" name="lblfactdocoriginal" id="lblfactdocoriginal" value="<?php echo $factdocoriginal; ?>" disabled="disabled" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-3 col-md-3">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">FALTA DNI:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" name="lblfactdni" id="lblfactdni" value="<?php echo $factdni; ?>" disabled="disabled" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-3 col-md-3">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">REHACER CTO:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" name="lblfactrehacercto" id="lblfactrehacercto" value="<?php echo $factrehacercto; ?>" disabled="disabled" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-3 col-md-3">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">SEGMENTACIÓN:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" name="lblfactsegmentacion" id="lblfactsegmentacion" value="<?php echo $factsegmentacion; ?>" disabled="disabled" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-3 col-md-3">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">ELEMENTOS CTO PS:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" name="lblfactelementosctops" id="lblfactelementosctops" value="<?php echo $factelementosctops; ?>" disabled="disabled" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-3 col-md-3">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">AFILIACION:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" name="lblfactafiliacion" id="lblfactafiliacion" value="<?php echo $factafiliacion; ?>" disabled="disabled" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-3 col-md-3">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">PAGO:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" name="lblfactpago" id="lblfactpago" value="<?php echo $factpago; ?>" disabled="disabled" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-3 col-md-3">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">DOC PAI:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" name="lblfactdocpai" id="lblfactdocpai" value="<?php echo $factdocpai; ?>" disabled="disabled" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group" style="margin-bottom: 0px;">
                                            <div class="col-sm-3 col-md-3">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblinstaladox">PROSPECTO/NRO GUIA:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" name="lblfactprospecto_nroguia" id="lblfactprospecto_nroguia" value="<?php echo $factprospecto_nroguia; ?>" disabled="disabled" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-3 col-md-3">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">AUTORIZA:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" name="lblfactautoriza" id="lblfactautoriza" value="<?php echo $factautoriza; ?>" disabled="disabled" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-3 col-md-3">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">FALTA DOC (P.A./CTO):</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" name="lblfactfaltadoc" id="lblfactfaltadoc" value="<?php echo $factfaltadoc; ?>" disabled="disabled" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-3 col-md-3">
                                                <div class="form-group">
                                                    <label class="col-sm-4 col-xs-4 control-label" style="text-align:left;" for="lblcorreo">FUERA DE HORA:</label>
                                                    <div class="col-sm-8 col-xs-8">
                                                        <input type="text" class="form-control input-sm" name="lblfactfuerahora" id="lblfactfuerahora" value="<?php echo $factfuerahora; ?>" disabled="disabled" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <!-- /.box-body -->
                            </div>
                        </form>   
                    </div>
                    <div class="col-md-2"></div>
                </div>
                    <div class="modal fade" id="modal-default">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h4>GESTIONES DE AGENDAMIENTO</h4>
                                </div>
                                <div class="modal-body" id="vistaboy">

                                    <div id="myGrid" style="height: 100%" class="ag-theme-fresh"></div>
                                    <div id="ningunresultado"></div>

                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>

                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->
                    <div class="modal fade" id="modal-default-logcambiosattec">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header modal-header-danger">
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                    <h4>GESTIONES DE ATTEC</h4>
                                </div>
                                <div class="modal-body" id="vistaboyauditoria">

                                    <div id="myGridauditoria" style="height: 100%" class="ag-theme-fresh"></div>
                                    <div id="ningunresultadoauditoria"></div>

                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>

                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->
                    <?php include 'modalpassword.php'; ?>
            </section>
            <!-- /.content -->        
        </div>
        <!-- /.content-wrapper -->
    </div>
    <!-- ./wrapper -->

        <!-- jQuery v1.11 -->

        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>

        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>
            $.widget.bridge('uibutton', $.ui.button);
        </script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>

        <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>

        <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>

        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>

        <!-- BOOTSTRAP TOOGLE -->
        <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>

        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js" type="text/javascript"></script>

        <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        <!-- SweetAlert -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>

        <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.19.2/moment.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.19.2/locale/es.js"></script>

        <!--GLOBALES -->
        <script>
            //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE REGALOS
            let arregloRegalos = [];
            //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE EXTRAS
            let arregloDatos = [];
            //ARREGLO GENERAL DE KIT, REGALOS Y EXTRAS
            let arregloGeneral = [];

            //ARREGLO DE DATOS QUE CONTIENE LA LISTA DE FALLO DE SUPERVISION
            let arregloDatosFalloSupervision = [];

            const listaExtras = document.querySelector('#listaExtras');
            const listaFalloSupervision = document.querySelector('#listaFalloSupervision');
            const listaRegalos = document.querySelector('#listaRegalos');
        </script>

        <script>
            var columnDefs = [{
                    headerName: 'FechaHoraREG',
                    field: 'FechaHoraREG',
                    width: 140
                },
                {
                    headerName: 'FechaInst',
                    field: 'FechaInst',
                    width: 130,
                    pinned: 'left'
                },
                {
                    headerName: 'HoraInst',
                    field: 'HoraInst',
                    width: 105,
                    pinned: 'left'
                },
                {
                    headerName: 'InstaladoX',
                    field: 'InstaladoX',
                    width: 100
                },
                {
                    headerName: 'MatriculaTec',
                    field: 'MatriculaTec',
                    width: 110
                },
                {
                    headerName: 'Repercusion',
                    field: 'Repercusion',
                    width: 130
                },
                {
                    headerName: 'R.Costo',
                    field: 'RepercusionCosto',
                    width: 90
                },
                {
                    headerName: 'MotivoInviable',
                    field: 'MotivoInviable',
                    width: 150
                },
                {
                    headerName: 'Comentario',
                    field: 'Comentario',
                    width: 200
                },
                {
                    headerName: 'EstadoVenta',
                    field: 'EstadoVenta',
                    width: 120
                },
                {
                    headerName: 'NContrato',
                    field: 'NContrato',
                    width: 120
                },
                {
                    headerName: 'Gestor',
                    field: 'GestorAgenda',
                    width: 120
                }
            ];

            var columnDefsAuditoria = [{
                    headerName: 'FechaHoraREG',
                    field: 'FechaHoraREG',
                    width: 140
                },
                {
                    headerName: 'FechaInst',
                    field: 'FechaInst',
                    width: 130,
                    pinned: 'left'
                },
                {
                    headerName: 'HoraInst',
                    field: 'HoraInst',
                    width: 105,
                    pinned: 'left'
                },
                {
                    headerName: 'Comentario',
                    field: 'ComentarioAttec',
                    width: 200
                },
                {
                    headerName: 'EstadoVenta',
                    field: 'EstadoVenta',
                    width: 120
                },
                {
                    headerName: 'NContrato',
                    field: 'NContrato',
                    width: 120
                },
                {
                    headerName: 'Gestor',
                    field: 'GestorAgenda',
                    width: 120
                },
                {
                    headerName: 'FechaAuditoria',
                    field:  'FechaAuditoria',
                    width: 120
                },
                {
                    headerName: 'DatosSbn',
                    field:  'DatosSbn',
                    width: 120
                },
                {
                    headerName: 'F_CorreccionDatosSbn',
                    field:  'F_CorreccionDatosSbn',
                    width: 120
                },
                {
                    headerName: 'DatosSbn_NoCoincide',
                    field:  'DatosSbn_NoCoincide',
                    width: 120
                },
                {
                    headerName: 'EstadoAttec',
                    field:  'EstadoAttec',
                    width: 120
                },
                {
                    headerName: 'SegIncorrecto',
                    field:  'SegIncorrecto',
                    width: 120
                },
                {
                    headerName: 'F_CorreccionSegIncorrecto',
                    field:  'F_CorreccionSegIncorrecto',
                    width: 120
                },
                {
                    headerName: 'Seg_DebeDecir',
                    field:  'Seg_DebeDecir',
                    width: 120
                },
                {
                    headerName: 'Imagen',
                    field:  'Imagen',
                    width: 120
                },
                {
                    headerName: 'F_Imagen',
                    field:  'F_Imagen',
                    width: 120
                },
                {
                    headerName: 'Imagen_Motivo',
                    field:  'Imagen_Motivo',
                    width: 120
                },
                {
                    headerName: 'IngresoProgramacion',
                    field:  'IngresoProgramacion',
                    width: 120
                },
                {
                    headerName: 'F_CorreccionIngresoProgramacion',
                    field:  'F_CorreccionIngresoProgramacion',
                    width: 120
                },
                {
                    headerName: 'FallosCobertura',
                    field:  'FallosCobertura',
                    width: 120
                },
                {
                    headerName: 'F_CorreccionFallosCobertura',
                    field:  'F_CorreccionFallosCobertura',
                    width: 120
                },
                {
                    headerName: 'MissingTest',
                    field:  'MissingTest',
                    width: 120
                },
                {
                    headerName: 'F_CorreccionMissingTest',
                    field:  'F_CorreccionMissingTest',
                    width: 120
                },
                {
                    headerName: 'ZeroVision',
                    field:  'ZeroVision',
                    width: 120
                },
                {
                    headerName: 'F_CorreccionZeroVision',
                    field:  'F_CorreccionZeroVision',
                    width: 120
                },
                {
                    headerName: 'Zerovision_motivo',
                    field:  'Zerovision_motivo',
                    width: 120
                },
                {
                    headerName: 'FalloSupervision',
                    field:  'FalloSupervision',
                    width: 120
                },
                {
                    headerName: 'F_CorreccionFalloSupervision',
                    field:  'F_CorreccionFalloSupervision',
                    width: 120
                },
                {
                    headerName: 'Tamper',
                    field:  'Tamper',
                    width: 120
                },
                {
                    headerName: 'F_CorreccionTamper',
                    field:  'F_CorreccionTamper',
                    width: 120
                }
                
          
            ];

            var gridOptions = {
                columnDefs: columnDefs,
                rowData: null,
                enableFilter: true,
                enableColResize: true,
                localeText: {
                    // for filter panel
                    page: 'página',
                    more: 'Más',
                    to: 'a',
                    of: 'de',
                    next: 'Siguiente',
                    last: 'Último',
                    first: 'Primero',
                    previous: 'Anterior',
                    loadingOoo: 'Cargando...',
                    // for set filter
                    selectAll: 'Seleccionar todo',
                    searchOoo: 'Buscando...',
                    blanks: 'Espacios en blanco',
                    // for number filter and text filter
                    filterOoo: 'Filtrar...',
                    applyFilter: 'Aplicar Filtro',
                    // for number filter
                    equals: 'Igual',
                    notEqual: 'No es igual',
                    lessThanOrEqual: 'Menor o igual',
                    greaterThanOrEqual: 'Mayor que o igual',
                    inRange: 'En el rango',
                    lessThan: 'Menos que',
                    greaterThan: 'Mas grande que',
                    // for text filter
                    contains: 'Contiene',
                    startsWith: 'Comienza con',
                    endsWith: 'Termina con',
                    notContains: 'No contiene',
                    // the header of the default group column
                    group: 'Grupo',
                    // tool panel
                    columns: 'columnas',
                    rowGroupColumns: 'Grupo columnas',
                    rowGroupColumnsEmptyMessage: 'No hay resultado',
                    valueColumns: 'Columna de valor',
                    pivotMode: 'Modo pivote',
                    groups: 'grupos',
                    values: 'valor',
                    pivots: 'pivote',
                    valueColumnsEmptyMessage: 'No hay resultado',
                    pivotColumnsEmptyMessage: 'No hay resultado',
                    // other
                    noRowsToShow: '<div class="callout callout-danger">\n\
<span class="pull-left">\n\
<img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
</span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
<strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
<p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
<br></div>'


                        ,
                    // enterprise menu
                    pinColumn: 'Aclar columna',
                    valueAggregation: 'Agregar valor',
                    autosizeThiscolumn: 'Auto tamaño esta columna ',
                    autosizeAllColumns: 'Auto tamaño todas columnas',
                    groupBy: 'Agrupar',
                    ungroupBy: 'Agrupar uno',
                    resetColumns: 'Restaurar Columnas',
                    expandAll: 'expandir todo',
                    collapseAll: 'desplegar todo',
                    toolPanel: 'Panel de Heramientas',
                    export: 'Exportar',
                    csvExport: 'Exportar CSV',
                    excelExport: 'Exportar Excel',
                    // enterprise menu pinning
                    pinLeft: 'Anclar a derecha',
                    pinRight: 'Anclar a izquierda',
                    noPin: 'Desanclar',
                    // enterprise menu aggregation and status panel
                    sum: 'Sumar',
                    min: 'Minimo',
                    max: 'Maximo',
                    first: 'Primero',
                    last: 'Ultimo',
                    none: 'Nada',
                    count: 'Contador',
                    average: 'Promedio',
                    // standard menu
                    copy: 'Copiar',
                    copyWithHeaders: 'Copiar Cabecera',
                    ctrlC: 'Ctrl+C',
                    paste: 'Pegar',
                    ctrlV: 'Ctrl+V'
                },
                enableSorting: true
            };

            var gridOptionsAuditoria = {
                columnDefs: columnDefsAuditoria,
                rowData: null,
                enableFilter: true,
                enableColResize: true,
                localeText: {
                    // for filter panel
                    page: 'página',
                    more: 'Más',
                    to: 'a',
                    of: 'de',
                    next: 'Siguiente',
                    last: 'Último',
                    first: 'Primero',
                    previous: 'Anterior',
                    loadingOoo: 'Cargando...',
                    // for set filter
                    selectAll: 'Seleccionar todo',
                    searchOoo: 'Buscando...',
                    blanks: 'Espacios en blanco',
                    // for number filter and text filter
                    filterOoo: 'Filtrar...',
                    applyFilter: 'Aplicar Filtro',
                    // for number filter
                    equals: 'Igual',
                    notEqual: 'No es igual',
                    lessThanOrEqual: 'Menor o igual',
                    greaterThanOrEqual: 'Mayor que o igual',
                    inRange: 'En el rango',
                    lessThan: 'Menos que',
                    greaterThan: 'Mas grande que',
                    // for text filter
                    contains: 'Contiene',
                    startsWith: 'Comienza con',
                    endsWith: 'Termina con',
                    notContains: 'No contiene',
                    // the header of the default group column
                    group: 'Grupo',
                    // tool panel
                    columns: 'columnas',
                    rowGroupColumns: 'Grupo columnas',
                    rowGroupColumnsEmptyMessage: 'No hay resultado',
                    valueColumns: 'Columna de valor',
                    pivotMode: 'Modo pivote',
                    groups: 'grupos',
                    values: 'valor',
                    pivots: 'pivote',
                    valueColumnsEmptyMessage: 'No hay resultado',
                    pivotColumnsEmptyMessage: 'No hay resultado',
                    // other
                    noRowsToShow: '<div class="callout callout-danger">\n\
<span class="pull-left">\n\
<img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
</span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
<strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
<p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
<br></div>'


                        ,
                    // enterprise menu
                    pinColumn: 'Aclar columna',
                    valueAggregation: 'Agregar valor',
                    autosizeThiscolumn: 'Auto tamaño esta columna ',
                    autosizeAllColumns: 'Auto tamaño todas columnas',
                    groupBy: 'Agrupar',
                    ungroupBy: 'Agrupar uno',
                    resetColumns: 'Restaurar Columnas',
                    expandAll: 'expandir todo',
                    collapseAll: 'desplegar todo',
                    toolPanel: 'Panel de Heramientas',
                    export: 'Exportar',
                    csvExport: 'Exportar CSV',
                    excelExport: 'Exportar Excel',
                    // enterprise menu pinning
                    pinLeft: 'Anclar a derecha',
                    pinRight: 'Anclar a izquierda',
                    noPin: 'Desanclar',
                    // enterprise menu aggregation and status panel
                    sum: 'Sumar',
                    min: 'Minimo',
                    max: 'Maximo',
                    first: 'Primero',
                    last: 'Ultimo',
                    none: 'Nada',
                    count: 'Contador',
                    average: 'Promedio',
                    // standard menu
                    copy: 'Copiar',
                    copyWithHeaders: 'Copiar Cabecera',
                    ctrlC: 'Ctrl+C',
                    paste: 'Pegar',
                    ctrlV: 'Ctrl+V'
                },
                enableSorting: true
            };


            function onFilterChanged(value) {
                gridOptions.api.setQuickFilter(value);
            }

            function listar() {
                var idventa = '<?php echo $idventa; ?>'
                $.ajax({
                    url: 'ajax/findDataHisAgenda.php?idventa=' + idventa,
                    success: function(data) {

                        if (data == 1) {
                            var gridDiv = document.querySelector('#myGrid');
                            new agGrid.Grid(gridDiv, gridOptions);

                            agGrid.simpleHttpRequest({
                                url: 'ajax/selectListarHistAgenda.php?idventa=' + idventa
                            }).then(function(data) {

                                gridOptions.api.setRowData(data);
                            });
                            $('#vistaboy').height(function(index, height) {

                                return $(window).height() * 35 / 100;
                            });

                        } else {

                            $("#ningunresultado").html(data);

                            var gridDiv = document.querySelector('#myGrid');
                            new agGrid.Grid(gridDiv, gridOptions);

                            agGrid.simpleHttpRequest({
                                url: 'ajax/selectListarHistAgenda.php?idventa=' + idventa
                            }).then(function(data) {

                                gridOptions.api.setRowData(data);
                            });



                            $('#myGrid').hide("fast");

                        }





                    }
                });
            }
            var refresh = function() {
                var idventa = '<?php echo $idventa; ?>'
                $.ajax({
                    url: 'ajax/findDataHisAgenda.php?idventa=' + idventa,
                    success: function(data) {

                        if (data == 1) {

                            var gridDiv = document.querySelector('#myGrid');
                            agGrid.simpleHttpRequest({
                                url: 'ajax/selectListarHistAgenda.php?idventa=' + idventa
                            }).then(function(data) {
                                gridOptions.api.setRowData(data);
                            });
                            $('#vistaboy').height(function(index, height) {

                                return $(window).height() * 35 / 100;
                            });
                            $("#ningunresultado").hide("fast");
                            $('#myGrid').show(200);
                        } else {

                            $("#ningunresultado").html(data);
                            $('#myGrid').hide("fast");

                        }





                    }
                });

            }

            function listarAuditoria() {
                  var idattec = $('#idattec').val();
                  var gridDiv = document.querySelector('#myGridauditoria');
                  //LIMPIAMOS GRID
                  gridDiv.innerHTML="";
                  //GENERA NUEVO GRID
                  new agGrid.Grid(gridDiv, gridOptionsAuditoria);
                  agGrid.simpleHttpRequest({
                    url:'ajax/selectListarHistAttec.php?idattec='+idattec}).then(function (data) {
                    console.log(data);

                    if (data.respuesta == 'exito'){
                      $('#myGridauditoria').show(200);
                        $("#ningunresultadoauditoria").html('');
                        $("#ningunresultadoauditoria").hide("fast");
                          gridOptionsAuditoria.api.setRowData(data.datos);
                            $('#vistaboyauditoria').height(function(index, height) {
                                return $(window).height() * 35 / 100;
                            });                          
                      
                    } else {
                    $('#myGridauditoria').hide("fast");
                      $("#ningunresultadoauditoria").html(`<div class="callout bg-gray">
                            <h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>
                       <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>
                        <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>
                        <br>
                        </div>`);
                      $("#ningunresultadoauditoria").show();
                    }
                    

                  });
            }

            // setup the grid after the page has finished loading
            document.addEventListener('DOMContentLoaded', function() {

                listar();

            });
        </script>

        <script>
            $(function() {

                $("#lblinstaladox").change(function() {
                    $("#lblinstaladox option:selected").each(function() {
                        var lblinstaladox = $(this).val();
                        $.post("./ajax/selectTecnico.php", {
                            lblinstaladox: lblinstaladox
                        }, function(data) {
                            $("#lbltecnico").html(data);
                        });
                    });

                });

                $("#lblestadoventa").change(function() {
                    var condiciones = $("#lblestadoventa").val();
                    bloquear(condiciones);
                    console.log(condiciones);
                    if (condiciones == 'IncidenciaAuditoria') {
                        $("#lblestadoattec").val('Observada');
                        console.log('Observada');
                    } else {
                        $("#lblestadoattec").val('');
                    }

                });

                $("#lblestadoattec").change(function() {
                    var lblestadoventa = $("#hidestadoventa").val();
                    var lblestadoattec = $(this).val();
                    console.log(lblestadoattec);
                    if (lblestadoattec == 'Observada') {
                        $("#lblestadoventa").val('IncidenciaAuditoria');
                    } else if (lblestadoattec == 'AuditadaOK' || lblestadoattec == 'AuditadaResuelta' || lblestadoattec == 'InstaladaSinAuditar' || lblestadoattec == 'ObservadaInstalada') {
                        $("#lblestadoventa").val('Instalada');
                    } else if (lblestadoattec == 'NoInstalada') {
                        $("#lblestadoventa").val('NoInstalada');
                    } else if (lblestadoattec == 'Desmontaje') {
                        $("#lblestadoventa").val('Desmontada');
                    } else {
                        $("#lblestadoventa").val(lblestadoventa);
                    }

                });

            });
        </script>

        <script>
            $(document).ready(function() {


                bloquear('<?php echo $estadoventa; ?>');

                var alterClass = function() {
                    var ww = document.body.clientWidth;
                    if (ww < 767) {
                        $('body').removeClass('sidebar-collapse');
                    } else if (ww >= 768) {
                        $('body').addClass('sidebar-collapse');
                    };
                };

                $(window).resize(function() {
                    alterClass();
                });
                //Fire it when the page first loads:
                alterClass();
                //plantillacomentario();


                $('#btnGuardarEditarVenta').click(function() {
                    var gestor = '<?php echo $matriculausuario; ?>';
                    var catgventa = $('#lblcategoria').val();
                    var ediventa = '<?php echo $idventa; ?>';
                    var matriculacomercial = '<?php echo $matricula; ?>';
                    var cccomercial = '<?php echo $dc; ?>';
                    var matriculajefe = '<?php echo $matjefe; ?>';
                    var tcgestor = '<?php echo $TCGestor; ?>';

                    var lblestadoventa = $('#lblestadoventa').val();
                    var lblncontrato = $('#lblncontrato').val();
                    var lblcomentarioagenda = $('#lblcomentarioagenda').val();
                    var lblidagenda = $('#lblidagenda').val();
                    var lblidcliente = $('#lblidcliente').val();

                    var FechaGestion = $('#FechaGestion').val();
                    var FechaAgendamiento = $('#FechaAgendamiento').val();
                    var FechaInstalacion = $('#FechaInstalacion').val();
                    var lblIdAgenRepor = $('#lblIdAgenRepor').val();
                    var FechaCancelada = $('#FechaCancelada').val();
                    var FechaInviable = $('#FechaInviable').val();
                    var FechaIlocalizable = $('#FechaIlocalizable').val();
                    
                    var lblfinstalacion = $('#fechainst').val();
                    var lblhinstalacion = $('#horainst').val();
                    
                    //AUDITORIA
                    var lblfechaautidoria = $('#lblfechaautidoria').val();
                    var lblestadoattec = $('#lblestadoattec').val();
                    var hidden_datossbn = $('#hidden_datossbn').val();
                    var lbldatossbncorreccion = $('#lbldatossbncorreccion').val();
                    var lblfechacorrecion_datossbn = $('#lblfechacorrecion_datossbn').val();
                    var hidden_segincorrecto = $('#hidden_segincorrecto').val();
                    var lblsegmentocorreccion = $('#lblsegmentocorreccion').val();
                    var lblfechacorrecion_segincorrecto = $('#lblfechacorrecion_segincorrecto').val();
                    var hidden_imagen = $('#hidden_imagen').val();
                    var lblimagen_motivo = $('#lblimagen_motivo').val();
                    var lblfechacorrecion_imagen = $('#lblfechacorrecion_imagen').val();
                    var hidden_ingresoprogramacion = $('#hidden_ingresoprogramacion').val();
                    var lblfechacorrecion_ingresoprogramacion = $('#lblfechacorrecion_ingresoprogramacion').val();
                    var hidden_falloscomunicacion = $('#hidden_falloscomunicacion').val();
                    var lblfechacorrecion_falloscomunicacion = $('#lblfechacorrecion_falloscomunicacion').val();
                    var hidden_missingtest = $('#hidden_missingtest').val();
                    var lblfechacorrecion_missingtest = $('#lblfechacorrecion_missingtest').val();
                    var hidden_zerovision = $('#hidden_zerovision').val();
                    var lblfechacorrecion_zerovision = $('#lblfechacorrecion_zerovision').val();
                    var hidden_fallosupervision = $('#hidden_fallosupervision').val();
                    var lblfechacorrecion_fallosupervision = $('#lblfechacorrecion_fallosupervision').val();
                    const detalleFallosSupervision = JSON.stringify(arregloDatosFalloSupervision);
                    var hidden_tamper = $('#hidden_tamper').val();
                    var lblfechacorrecion_tamper = $('#lblfechacorrecion_tamper').val();
                    const detalleExtras = JSON.stringify(arregloDatos);
                    var idattec = $('#idattec').val();
                    var lblcomentarioattec=$('#lblplantillacomentario').val();
                    var lblzerovisioncorreccion=$('#lblzerovisioncorreccion').val();
                    
                    
                    var lblIdAttecRepor = $('#lblIdAttecRepor').val();
                    var FechaGestionAttec = $('#FechaGestionAttec').val();
                    var FechaAuditadaOK = $('#FechaAuditadaOK').val();
                    var FechaObservada = $('#FechaObservada').val();
                    var FechaAuditadaResuelta = $('#FechaAuditadaResuelta').val();
                    var FechaInstaladaSinAuditar = $('#FechaInstaladaSinAuditar').val();
                    var FechaNoInstalada = $('#FechaNoInstalada').val();
                    var FechaObservadaInstalada = $('#FechaObservadaInstalada').val();
                    var FechaDesmontada = $('#FechaDesmontada').val();
                    
                    var hidden_MG_01_retardo = $('#hidden_MG_01_retardo').val();
                    var lblfechacorrecion_MG_01_retardo = $('#lblfechacorrecion_MG_01_retardo').val();                    
                
                    
                    var datos = {
                        gestor: gestor,
                        lblestadoventa: lblestadoventa,
                        lblncontrato: lblncontrato,
                        lblcomentarioagenda: lblcomentarioagenda,
                        matriculacomercial: matriculacomercial,
                        cccomercial: cccomercial,
                        matriculajefe: matriculajefe,
                        tcgestor: tcgestor,
                        lblidventa: ediventa,
                        lblidagenda: lblidagenda,
                        lblidcliente: lblidcliente,
                        FechaGestion: FechaGestion,
                        FechaAgendamiento: FechaAgendamiento,
                        FechaInstalacion: FechaInstalacion,
                        lblIdAgenRepor: lblIdAgenRepor,
                        FechaCancelada: FechaCancelada,
                        FechaInviable: FechaInviable,
                        FechaIlocalizable: FechaIlocalizable,
                        lblfechaautidoria: lblfechaautidoria,
                        lblestadoattec: lblestadoattec,
                        hidden_datossbn: hidden_datossbn,
                        lbldatossbncorreccion:lbldatossbncorreccion,
                        lblfechacorrecion_datossbn: lblfechacorrecion_datossbn,
                        hidden_segincorrecto: hidden_segincorrecto,
                        lblsegmentocorreccion: lblsegmentocorreccion,
                        lblfechacorrecion_segincorrecto: lblfechacorrecion_segincorrecto,
                        hidden_imagen: hidden_imagen,
                        lblimagen_motivo: lblimagen_motivo,
                        lblfechacorrecion_imagen: lblfechacorrecion_imagen,
                        hidden_ingresoprogramacion: hidden_ingresoprogramacion,
                        lblfechacorrecion_ingresoprogramacion: lblfechacorrecion_ingresoprogramacion,
                        hidden_falloscomunicacion: hidden_falloscomunicacion,
                        lblfechacorrecion_falloscomunicacion: lblfechacorrecion_falloscomunicacion,
                        hidden_missingtest: hidden_missingtest,
                        lblfechacorrecion_missingtest: lblfechacorrecion_missingtest,
                        hidden_zerovision: hidden_zerovision,
                        lblfechacorrecion_zerovision: lblfechacorrecion_zerovision,
                        hidden_fallosupervision: hidden_fallosupervision,
                        lblfechacorrecion_fallosupervision: lblfechacorrecion_fallosupervision,
                        detalleFallosSupervision: detalleFallosSupervision,
                        hidden_tamper: hidden_tamper,
                        lblfechacorrecion_tamper: lblfechacorrecion_tamper,
                        detalleExtras: detalleExtras,
                        idattec: idattec,
                        lblcomentarioattec:lblcomentarioattec,
                        lblzerovisioncorreccion:lblzerovisioncorreccion,
                        lblfinstalacion:lblfinstalacion,
                        lblhinstalacion:lblhinstalacion,
                        lblIdAttecRepor:lblIdAttecRepor,
                        FechaGestionAttec:FechaGestionAttec,
                        FechaAuditadaOK:FechaAuditadaOK,
                        FechaObservada:FechaObservada,
                        FechaAuditadaResuelta:FechaAuditadaResuelta,
                        FechaInstaladaSinAuditar:FechaInstaladaSinAuditar,
                        FechaNoInstalada:FechaNoInstalada,
                        FechaObservadaInstalada:FechaObservadaInstalada,
                        FechaDesmontada:FechaDesmontada,
                        hidden_MG_01_retardo:hidden_MG_01_retardo,
                        lblfechacorrecion_MG_01_retardo:lblfechacorrecion_MG_01_retardo                    
                    }

                    //Algunas variables por default de alertify
                    alertify.defaults.theme.ok = "btn btn-nuevo";
                    alertify.defaults.theme.cancel = "btn btn-danger";

                    var lastX, lastY;
                    alertify.confirm(
                        '<span style="color:red"><i class="fa fa-warning"></i></span><strong> ADVERTENCIA</strong>',
                        '¿Desea guardar los cambios que ha realizado?',
                        function() {
                            if (validaForm()) {
                                // Primero validará el formulario.
                                console.log(datos);
                                $.ajax({
                                    type: 'POST',
                                    url: 'ajax/updateAttec_pre.php',
                                    data: datos,
                                    success: function(r) {
                                        if (r == 1) {
                                            alertify.success("Modificado con exito");
                                            //enviarEncuesta();
                                            Swal.fire({
                                                title: 'Modificado con exito',
                                                icon: 'success',
                                                showCancelButton: false,
                                                allowOutsideClick: false,
                                                allowEscapeKey: false,
                                                confirmButtonColor: '#3085d6',
                                                confirmButtonText: 'OK'
                                            }).then((result) => {
                                                if (result.isConfirmed) {
                                                    location.reload();
                                                }
                                            });
                                        } else if (r == 2) {
                                            alertify.warning("Contrato Duplicado");
                                        } else if (r == 0) {
                                            alertify.warning("No se realizaron modificaciones");
                                        } else {
                                            alertify.error("Fallo el server");
                                        }
                                    }
                                });
                            }
                        },
                        function() {
                            alertify.error('No se han guardado los cambios')
                        }).set({
                        transition: 'zoom',
                        'labels': {
                            ok: '<i class="fa fa-check"></i> Aceptar',
                            cancel: '<i class="fa fa-remove"></i> Cancelar'
                        },
                        'onshow': function() {

                            lastX = window.scrollX;
                            lastY = window.scrollY;
                        },
                        'onfocus': function() {
                            window.scrollTo(lastX, lastY);
                        }
                    }).show();



                });

                $('.selectdistrito').select2({
                    placeholder: 'Seleccione Distrito - Provincia',
                    allowClear: true,
                    language: {
                        errorLoading: function() {
                            return "La carga falló";
                        },
                        noResults: function() {
                            return "No hay resultado";
                        },
                        searching: function() {

                            return "Buscando..";
                        }
                    },
                    ajax: {
                        url: 'ajax/selectDistrito.php',
                        dataType: 'json',
                        delay: 250,
                        processResults: function(data) {
                            return {
                                results: data
                            };
                        },
                        cache: true
                    }
                });


                $('.cbxtecnico').select2({
                    placeholder: 'Seleccione',
                    allowClear: true,
                    language: {
                        errorLoading: function() {
                            return "La carga falló";
                        },
                        noResults: function() {
                            return "No hay resultado";
                        },
                        searching: function() {

                            return "Buscando..";
                        }
                    }
                });


                $('#datemask').inputmask('dd/mm/yyyy', {
                    'placeholder': 'dd/mm/yyyy'
                });

                $('#lblfechaautidoria').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                $('#lblfechacorrecion_datossbn').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                $('#lblfechacorrecion_segincorrecto').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                $('#lblfechacorrecion_imagen').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                $('#lblfechacorrecion_ingresoprogramacion').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                $('#lblfechacorrecion_falloscomunicacion').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                $('#lblfechacorrecion_missingtest').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                $('#lblfechacorrecion_zerovision').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                $('#lblfechacorrecion_fallosupervision').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                $('#lblfechacorrecion_MG_01_retardo').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });                
                $('#lblfechacorrecion_tamper').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                //Money Euro
                $('[data-mask]').inputmask();
                //Date picker
                $('#fechainst').datepicker({
                    autoclose: true,
                    language: 'es',
                    firstDay: 1
                });
                //Date picker
                $('#horainst').timepicker({
                    defaultTime: false,
                    showInputs: true,
                    minuteStep: 1

                });

                $('#mesano').datepicker({
                    autoclose: true,
                    language: 'en',
                    firstDay: 1,
                    format: 'M-yyyy',
                    viewMode: "years",
                    minViewMode: "months"

                });

                $('#logcambios').click(function() {
                    refresh();
                });

                $('#logcambiosattec').click(function() {
                    listarAuditoria();
                });

                <?php include 'jspassword.php'; ?>

                $('#datossbn').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#datossbn').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_datossbn').val('SI');
                        $('#lblfechacorrecion_datossbn').prop("disabled", false);
                        $('.datossbn').removeClass('ocultar');
                        
                    } else {
                        $('#hidden_datossbn').val('NO');
                        $('#lblfechacorrecion_datossbn').prop("disabled", true);
                        $('.datossbn').addClass('ocultar');
                        
                    }
                        plantillacomentario();
                });


                $('#segincorrecto').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_segincorrecto').val('SI');
                        $('.segcorrecion').removeClass('ocultar');
                        $('#lblfechacorrecion_segincorrecto').prop("disabled", false);
                    } else {
                        $('#hidden_segincorrecto').val('NO');
                        $('.segcorrecion').addClass('ocultar');
                        $('#lblfechacorrecion_segincorrecto').prop("disabled", true);
                    }
                    plantillacomentario();
                });

                $('#segincorrecto').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#imagen').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_imagen').val('SI');
                        $('.imagen').removeClass('ocultar');
                        $('#lblfechacorrecion_imagen').prop("disabled", false);
                    } else {
                        $('#hidden_imagen').val('NO');
                        $('.imagen').addClass('ocultar');
                        $('#lblfechacorrecion_imagen').prop("disabled", true);
                    }
                    plantillacomentario();
                });

                $('#imagen').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#ingresoprogramacion').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_ingresoprogramacion').val('SI');
                        $('#lblfechacorrecion_ingresoprogramacion').prop("disabled", false);
                    } else {
                        $('#hidden_ingresoprogramacion').val('NO');
                        $('#lblfechacorrecion_ingresoprogramacion').prop("disabled", true);
                    }
                    plantillacomentario();
                });

                $('#ingresoprogramacion').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#falloscomunicacion').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_falloscomunicacion').val('SI');
                        $('#lblfechacorrecion_falloscomunicacion').prop("disabled", false);
                    } else {
                        $('#hidden_falloscomunicacion').val('NO');
                        $('#lblfechacorrecion_falloscomunicacion').prop("disabled", true);
                    }
                    plantillacomentario();
                });

                $('#falloscomunicacion').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#missingtest').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_missingtest').val('SI');
                        $('#lblfechacorrecion_missingtest').prop("disabled", false);
                    } else {
                        $('#hidden_missingtest').val('NO');
                        $('#lblfechacorrecion_missingtest').prop("disabled", true);
                    }
                    plantillacomentario();
                });

                $('#missingtest').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#zerovision').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_zerovision').val('SI');
                        $('#lblfechacorrecion_zerovision').prop("disabled", false);
                        $('.zerovisioncorrecion').removeClass('ocultar');
                    } else {
                        $('#hidden_zerovision').val('NO');
                        $('#lblfechacorrecion_zerovision').prop("disabled", true);
                        $('.zerovisioncorrecion').addClass('ocultar');
                    }
                    plantillacomentario();
                });

                $('#zerovision').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

                $('#fallosupervision').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_fallosupervision').val('SI');
                        $('.fallosupervision').removeClass('ocultar');
                        $('#lblfechacorrecion_fallosupervision').prop("disabled", false);
                    } else {
                        $('#hidden_fallosupervision').val('NO');
                        $('.fallosupervision').addClass('ocultar');
                        $('#lblfechacorrecion_fallosupervision').prop("disabled", true);
                    }
                    plantillacomentario();
                });

                $('#fallosupervision').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });
                

                $('#MG_01_retardo').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_MG_01_retardo').val('SI');
                        $('.MG_01_retardo').removeClass('ocultar');
                        $('#lblfechacorrecion_MG_01_retardo').prop("disabled", false);
                    } else {
                        $('#hidden_MG_01_retardo').val('NO');
                        $('.MG_01_retardo').addClass('ocultar');
                        $('#lblfechacorrecion_MG_01_retardo').prop("disabled", true);
                    }
                    plantillacomentario();
                });

                $('#MG_01_retardo').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });
                

                $('#tamper').change(function() {
                    if ($(this).prop('checked')) {
                        $('#hidden_tamper').val('SI');
                        $('.tamper').removeClass('ocultar');
                        $('#lblfechacorrecion_tamper').prop("disabled", false);
                    } else {
                        $('#hidden_tamper').val('NO');
                        $('.tamper').addClass('ocultar');
                         $('#lblfechacorrecion_tamper').prop("disabled", true);
                    }
                    plantillacomentario();
                });

                $('#tamper').bootstrapToggle({
                    on: 'SI',
                    off: 'NO',
                    onstyle: 'danger',
                    offstyle: 'success'
                });

            //ARREGLO GENERAL
                if($('#datosFalloSupervision').val() != ''){
                    arregloDatosFalloSupervision = JSON.parse($('#datosFalloSupervision').val());
                    generarHtmlFalloSupervision();
                }
                if($('#datosExtras').val() != ''){
                    arregloDatos = JSON.parse($('#datosExtras').val());
                    generarHtml();
                }
            });


            <?php include 'jsfuncionpassword.php'; ?>
            var bloquear = function(condiciones) {

                $('#tinviable').hide();
                $('#lblinviable').hide();
                $('#lblinviable').disabled = true;
                $('#tinviableespacio').hide();

                $('#tcancelado').hide();
                $('#lblcancelado').hide();
                $('#lblcancelado').disabled = true;
                $('#tcanceladoespacio').hide();

                $('#lblncontrato').attr("readonly", "readonly");


                if (condiciones == "Inviable") {
                    $('#tinviable').show();
                    $('#lblinviable').show();
                    $('#lblinviable').show();
                    $('#lblinviable').disabled = false;
                    $('#tinviableespacio').show();
                    $('#lblncontrato').removeAttr("readonly");

                } else if (condiciones == "Cancelado") {
                    $('#tcancelado').show();
                    $('#lblcancelado').show();
                    $('#lblcancelado').disabled = false;
                    $('#tcanceladoespacio').show();

                } else if (condiciones == "Instalada" || condiciones == "InstaladaDEL" || condiciones == "InstaladaTEC" || condiciones == "IncidenciaAuditoria") {

                    $('#lblncontrato').removeAttr("readonly");

                } else {
                    $('#tinviable').hide();
                    $('#lblinviable').hide();
                    $('#lblinviable').disabled = true;
                    $('#tinviableespacio').hide();

                    $('#tcancelado').hide();
                    $('#lblcancelado').hide();
                    $('#lblcancelado').disabled = true;
                    $('#tcanceladoespacio').hide();

                    $('#lblncontrato').attr("readonly", "readonly");

                }

            }


            function validaForm() {


                // Campos de texto
                if ($("#frmEditarVenta #lblmatricula").val() == "") {
                    alertify.warning("Por favor ingresar la Matricula correspondiente");
                    $("#frmEditarVenta #lblmatricula")
                        .focus(); // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmEditarVenta #lblnombcomercial").val() == "") {
                    alertify.warning("Por favor ingresar la Matricula valida");
                    $("#frmEditarVenta #lblmatricula")
                        .focus(); // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }
                if ($("#frmEditarVenta #lbldc").val() == "" || $("#frmEditarVenta #lbldc").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar CC correcto");
                    $("#frmEditarVenta #lbldc")
                        .focus(); // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }

                if ($("#frmEditarVenta #lbljefeventa").val() == "" || $("#frmEditarVenta #lbljefeventa").val() ==
                    "No se encontraron resultado") {
                    alertify.warning("Por favor revisar Jefe de Estructura Comercial");
                    $("#frmEditarVenta #lbljefeventa")
                        .focus(); // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                    return false;
                }


                if ($("#frmEditarVenta #lblestadoventa").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Estado de Venta correcto");
                    $("#frmEditarVenta #lblestadoventa").focus();
                    return false;
                }


                if ($("#frmEditarVenta #lblestadoventa").val() == "Cancelada") {
                    if ($("#frmEditarVenta #lblcomentarioagenda").val() == "") {
                        alertify.warning("Por favor ingresar comentario");
                        $("#frmEditarVenta #lblcomentarioagenda").focus();
                        return false;
                    }

                    if ($("#frmEditarVenta #lblrepercucion").val() == "" || $("#frmEditarVenta #lblrepercucion").val() ==
                        "Seleccione") {
                        alertify.warning("Por favor ingresar Repercucion correspondiente");
                        $("#frmEditarVenta #lblrepercucion").focus();
                        return false;
                    }


                    if ($("#frmEditarVenta #lblcosto").val() == "" || $("#frmEditarVenta #lblcosto").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar Costo Repercucion (SI/NO) ");
                        $("#frmEditarVenta #lblcosto").focus();
                        return false;
                    }

                }

                if ($('#frmEditarVenta #lblestadoventa').val() == 'Instalada' || $('#frmEditarVenta #lblestadoventa').val() =='InstaladaDEL' || $('#frmEditarVenta #lblestadoventa').val() =='InstaladaTEC' || $('#frmEditarVenta #lblestadoventa').val()=='IncidenciaAuditoria') {
                    if ($('#frmEditarVenta #lblncontrato').val() == '') {
                        alertify.warning("Por favor ingresar NContrato");
                        $('#frmEditarVenta #lblncontrato').focus();
                        return false;
                    }
                }

                if ($("#frmEditarVenta #lblestadoventa").val() == "Inviable") {
                    if ($("#frmEditarVenta #lblcomentarioagenda").val() == "") {
                        alertify.warning("Por favor ingresar comentario");
                        $("#frmEditarVenta #lblcomentarioagenda").focus();
                        return false;
                    }

                    if ($("#frmEditarVenta #lblrepercucion").val() == "" || $("#frmEditarVenta #lblrepercucion").val() =="Seleccione") {
                        alertify.warning("Por favor ingresar Repercucion correspondiente");
                        $("#frmEditarVenta #lblrepercucion").focus();
                        return false;
                    }


                    if ($("#frmEditarVenta #lblcosto").val() == "" || $("#frmEditarVenta #lblcosto").val() == "Seleccione") {
                        alertify.warning("Por favor ingresar Costo Repercucion (SI/NO) ");
                        $("#frmEditarVenta #lblcosto").focus();
                        return false;
                    }

                    if ($("#frmEditarVenta #lblinviable").val() == "" || $("#frmEditarVenta #lblinviable").val() ==
                        "Seleccione") {
                        alertify.warning("Por favor ingresar Inviable correspondiente");
                        $("#frmEditarVenta #lblinviable").focus();
                        return false;
                    }

                }



                if ($("#frmEditarVenta #lbltipoventa").val() == "") {
                    alertify.warning("Por favor ingresar Recurso correcto");
                    $("#frmEditarVenta #lbltipoventa").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblsegmento").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Segmento correcto");
                    $("#frmEditarVenta #lblsegmento").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblmesesautorizados").val() == "") {
                    alertify.warning("Por favor ingresar MesAutorizado.Si no tuviese coloque: 0");
                    $("#frmEditarVenta #lblmesesautorizados").focus();
                    return false;
                }

                if ($("#frmEditarVenta #lblnombcliente").val() == "") {
                    alertify.warning("Por favor ingresar Nombre del Cliente");
                    $("#frmEditarVenta #lblnombcliente").focus();
                    return false;
                }
                /*
                        if ($("#frmEditarVenta #lblcorreo").val() == "" || !/^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i.test($("#frmEditarVenta #lblcorreo").val())) {
                            alertify.warning("Por favor ingresar correo válido");
                            $("#frmEditarVenta #lblcorreo").focus();
                            return false;
                        }
                    */
                if ($("#frmEditarVenta #lbldireccion").val() == "") {
                    alertify.warning("Por favor ingresar la Direccion del Cliente");
                    $("#frmEditarVenta #lbldireccion").focus();
                    return false;
                }

                if ($("#frmEditarVenta #lbldistrito").val() == "") {
                    alertify.warning("Por favor ingresar Distrito correcto");
                    $("#frmEditarVenta #lbldistrito").select2('open');
                    return false;
                }


                if ($("#frmEditarVenta #lblmovil").val() == "") {
                    alertify.warning("Por favor ingresar Telefono, de caso contrario digite: 0");
                    $("#frmEditarVenta #lblmovil").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblpreciokit").val() == "") {
                    alertify.warning("Por favor ingresar Precio del KIT");
                    $("#frmEditarVenta #lblpreciokit").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lbltotalextra").val() == "") {
                    alertify.warning("Por favor ingresar Total de Extra, de caso contrario digite: 0");
                    $("#frmEditarVenta #lbltotalextra").focus();
                    return false;
                }

                if ($("#frmEditarVenta #lblresumenventa").val() == "") {
                    alertify.warning("Por favor ingresar Resumen de Venta");
                    $("#frmEditarVenta #lblresumenventa").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblformadepago").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar Forma de Pago");
                    $("#frmEditarVenta #lblformadepago").focus();
                    return false;
                }
                if ($("#frmEditarVenta #mesano").val() == "") {
                    alertify.warning("Por favor ingresar 590");
                    $("#frmEditarVenta #mesano").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblPAI").val() == "Seleccione") {
                    alertify.warning("Por favor ingresar PAI");
                    $("#frmEditarVenta #lblPAI").focus();
                    return false;
                }
                if ($("#frmEditarVenta #lblestadoattec").val() == "") {
                    Swal.fire(
                            'Alerta!',
                            'Por favor ingresar EstadoATTEC',
                            'warning'
                                );                    
                    $("#frmEditarVenta #lblestadoattec").focus();
                    return false;
                }

                if ($("#frmEditarVenta #hidden_datossbn").val() == "SI"){
                        if ($("#frmEditarVenta #lbldatossbncorreccion").val() == "" || $("#frmEditarVenta #lbldatossbncorreccion").val() == null){
                                console.log("Entro en fuera e observada");
                                Swal.fire(
                                'Alerta!',
                                'Por favor seleccionar que datos SBN Y Verismart no coincide',
                                'warning'
                                );
                                return false;                            
                            }
                }
                if ($("#frmEditarVenta #hidden_imagen").val() == "SI"){
                            if ($("#frmEditarVenta #lblimagen_motivo").val() == "" || $("#frmEditarVenta #lblimagen_motivo").val() == null || $("#frmEditarVenta #lblimagen_motivo").val() == "MOTIVO"){
                                Swal.fire(
                                'Alerta!',
                                'Por favor seleccionar MOTIVO DE IMAGEN',
                                'warning'
                                );
                                return false;                            
                            }
                }
                if ($("#frmEditarVenta #hidden_segincorrecto").val() == "SI"){
                            if ($("#frmEditarVenta #lblsegmentocorreccion").val() == "" || $("#frmEditarVenta #lblsegmentocorreccion").val() == null){
                                Swal.fire(
                                'Alerta!',
                                'Por favor seleccionar el SEGMENTO que debe decir',
                                'warning'
                                );
                                return false;                            
                            }
                        }
                if ($("#frmEditarVenta #hidden_tamper").val() == "SI"){
                            
                            if (arregloDatos.length===0){
                                Swal.fire(
                                'Alerta!',
                                'Por favor ingresar los dispositivos de TAMPER',
                                'warning'
                                );
                                return false;                            
                            }
                            
                        }                     
                if ($("#frmEditarVenta #hidden_zerovision").val() == "SI"){
                            if ($("#frmEditarVenta #lblzerovisioncorreccion").val() == "" || $("#frmEditarVenta #lblzerovisioncorreccion").val() == null){
                                Swal.fire(
                                'Alerta!',
                                'Por favor seleccionar motivo de ZEROVISION',
                                'warning'
                                );
                                return false;                            
                            }
                        }
                if ($("#frmEditarVenta #hidden_fallosupervision").val() == "SI"){
                            
                            if (arregloDatosFalloSupervision.length===0){
                                Swal.fire(
                                'Alerta!',
                                'Por favor ingresar los dispositivos de FALLO SUPERVISION',
                                'warning'
                                );
                                return false;                            
                            }
                        }
                
                //VALIDACION DE AUDITORIA
                if ($("#frmEditarVenta #lblestadoattec").val() == "AuditadaOK") {
                    if ($("#frmEditarVenta #lblfechaautidoria").val() == ""){
                            Swal.fire(
                            'Alerta!',
                            'Por favor ingresar Fecha Auditoria',
                            'warning'
                            );
                            return false;
                    }
                }

                if ($("#frmEditarVenta #lblestadoattec").val() == "Observada") {
                    console.log("DatosSBN:"+$("#frmEditarVenta #hidden_datossbn").val());
                    console.log("lbldatossbncorreccion:"+$("#frmEditarVenta #lbldatossbncorreccion").val());
                    if ($("#frmEditarVenta #lblfechaautidoria").val() == ""){
                            Swal.fire(
                            'Alerta!',
                            'Por favor ingresar Fecha Auditoria',
                            'warning'
                            );
                            return false;
                    }
                    
                    
                    if ($("#frmEditarVenta #hidden_datossbn").val() == "SI" || 
                        $("#frmEditarVenta #hidden_segincorrecto").val() == "SI" || 
                        $("#frmEditarVenta #hidden_imagen").val() == "SI" || 
                        $("#frmEditarVenta #hidden_ingresoprogramacion").val() == "SI" ||
                        $("#frmEditarVenta #hidden_falloscomunicacion").val() == "SI" ||
                        $("#frmEditarVenta #hidden_missingtest").val() == "SI" ||
                        $("#frmEditarVenta #hidden_zerovision").val() == "SI" ||
                        $("#frmEditarVenta #hidden_fallosupervision").val() == "SI" ||
                        $("#frmEditarVenta #hidden_tamper").val() == "SI") {


                        if ($("#frmEditarVenta #hidden_datossbn").val() == "SI"){
                            if ($("#frmEditarVenta #lbldatossbncorreccion").val() == "" || $("#frmEditarVenta #lbldatossbncorreccion").val() == null){
                                console.log("Entro en observada");
                                Swal.fire(
                                'Alerta!',
                                'Por favor seleccionar que datos SBN Y Verismart no coincide',
                                'warning'
                                );
                                return false;                            
                            }
                        }
                        if ($("#frmEditarVenta #hidden_imagen").val() == "SI"){
                            if ($("#frmEditarVenta #lblimagen_motivo").val() == "" || $("#frmEditarVenta #lblimagen_motivo").val() == null || $("#frmEditarVenta #lblimagen_motivo").val() == "MOTIVO"){
                                Swal.fire(
                                'Alerta!',
                                'Por favor seleccionar MOTIVO DE IMAGEN',
                                'warning'
                                );
                                return false;                            
                            }
                        }
                        if ($("#frmEditarVenta #hidden_segincorrecto").val() == "SI"){
                            if ($("#frmEditarVenta #lblsegmentocorreccion").val() == "" || $("#frmEditarVenta #lblsegmentocorreccion").val() == null){
                                Swal.fire(
                                'Alerta!',
                                'Por favor seleccionar el SEGMENTO que debe decir',
                                'warning'
                                );
                                return false;                            
                            }
                        }
                        if ($("#frmEditarVenta #hidden_tamper").val() == "SI"){
                            
                            if (arregloDatos.length===0){
                                Swal.fire(
                                'Alerta!',
                                'Por favor ingresar los dispositivos de TAMPER',
                                'warning'
                                );
                                return false;                            
                            }
                            
                        }                     
                        if ($("#frmEditarVenta #hidden_zerovision").val() == "SI"){
                            if ($("#frmEditarVenta #lblzerovisioncorreccion").val() == "" || $("#frmEditarVenta #lblzerovisioncorreccion").val() == null){
                                Swal.fire(
                                'Alerta!',
                                'Por favor seleccionar motivo de ZEROVISION',
                                'warning'
                                );
                                return false;                            
                            }
                        }
                        if ($("#frmEditarVenta #hidden_fallosupervision").val() == "SI"){
                            
                            if (arregloDatosFalloSupervision.length===0){
                                Swal.fire(
                                'Alerta!',
                                'Por favor ingresar los dispositivos de FALLO SUPERVISION',
                                'warning'
                                );
                                return false;                            
                            }
                        }
                            
                    }else{
                    Swal.fire(
                            'Alerta!',
                            'Por favor ingresar las incidencias de AUDITORIA',
                            'warning'
                                );                    
                        $("#frmEditarVenta #lblestadoattec").focus();
                        return false;
                    }

                    
                }
                
                if ($("#frmEditarVenta #lblestadoattec").val() == "AuditadaResuelta") {
                    if ($("#frmEditarVenta #lblfechaautidoria").val() == ""){
                            Swal.fire(
                            'Alerta!',
                            'Por favor ingresar Fecha Auditoria',
                            'warning'
                            );
                            return false;
                    }
                    
                    if ($("#frmEditarVenta #hidden_datossbn").val() == "SI") {
                        if ($("#frmEditarVenta #lblfechacorrecion_datossbn").val() == "") {
                            Swal.fire(
                            'Alerta!',
                            'Por favor ingresar Fecha Correcion Datos SBN',
                            'warning'
                            );
                            return false;
                        }
                    }
                    if ($("#frmEditarVenta #hidden_segincorrecto").val() == "SI") {
                        if ($("#frmEditarVenta #lblfechacorrecion_segincorrecto").val() == "") {
                            Swal.fire(
                            'Alerta!',
                            'Por favor ingresar Fecha Correcion Segmento',
                            'warning'
                            );
                            return false;
                        }
                    }

                    if ($("#frmEditarVenta #hidden_imagen").val() == "SI") {
                       
                        if ($("#frmEditarVenta #lblfechacorrecion_imagen").val() == "") {
                            Swal.fire(
                            'Alerta!',
                            'Por favor ingresar Fecha Correcion Imagen',
                            'warning'
                            );
                            return false;
                        }
                        
                    } 
                    if ($("#frmEditarVenta #hidden_ingresoprogramacion").val() == "SI") {
                        if ($("#frmEditarVenta #lblfechacorrecion_ingresoprogramacion").val() == "") {
                            Swal.fire(
                            'Alerta!',
                            'Por favor ingresar Fecha Correcion Ingreso Programacion',
                            'warning'
                            );
                            return false;
                        }
                    } 
                    if ($("#frmEditarVenta #hidden_falloscomunicacion").val() == "SI") {
                        if ($("#frmEditarVenta #lblfechacorrecion_falloscomunicacion").val() == "") {
                            Swal.fire(
                            'Alerta!',
                            'Por favor ingresar Fecha Correcion Fallos Comunicacion',
                            'warning'
                            );
                            return false;
                        }
                    } 
                    if ($("#frmEditarVenta #hidden_missingtest").val() == "SI") {
                        if ($("#frmEditarVenta #lblfechacorrecion_missingtest").val() == "") {
                            Swal.fire(
                            'Alerta!',
                            'Por favor ingresar Fecha Correcion Missing TEST',
                            'warning'
                            );
                            return false;
                        }
                    } 
                    if ($("#frmEditarVenta #hidden_zerovision").val() == "SI") {
                        if ($("#frmEditarVenta #lblfechacorrecion_zerovision").val() == "") {
                            Swal.fire(
                            'Alerta!',
                            'Por favor ingresar Fecha Correcion Zero Vision',
                            'warning'
                            );
                            return false;
                        }
                    }
                    if ($("#frmEditarVenta #hidden_fallosupervision").val() == "SI") {
                        if ($("#frmEditarVenta #lblfechacorrecion_fallosupervision").val() == "") {
                            Swal.fire(
                            'Alerta!',
                            'Por favor ingresar Fecha Correcion Fallo de Supervision',
                            'warning'
                            );
                            return false;
                        }
                    }
                    if ($("#frmEditarVenta #hidden_tamper").val() == "SI") {
                        if ($("#frmEditarVenta #lblfechacorrecion_tamper").val() == "") {
                            Swal.fire(
                            'Alerta!',
                            'Por favor ingresar Fecha Correcion Tamper',
                            'warning'
                            );
                            return false;
                        }
                    }                    
                    
                    
                }                

                return true;
            }


            var calcDataTableHeight = function() {
                return $(window).height() * 65 / 100;
            };


            function filterFloat(evt, input) {
                // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
                var key = window.Event ? evt.which : evt.keyCode;
                var chark = String.fromCharCode(key);
                var tempValue = input.value + chark;
                if (key >= 48 && key <= 57) {
                    if (filter(tempValue) === false) {
                        return false;
                    } else {
                        return true;
                    }
                } else {
                    if (key == 8 || key == 13 || key == 0) {
                        return true;
                    } else if (key == 46) {
                        if (filter(tempValue) === false) {
                            return false;
                        } else {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
            }

            function filter(__val__) {
                var preg = /^([0-9]+\.?[0-9]{0,2})$/;
                if (preg.test(__val__) === true) {
                    return true;
                } else {
                    return false;
                }

            }
        </script>

        <script>
            function enviarEncuesta() {
                const lblestadoventa = $('#lblestadoventa').val();

                if (lblestadoventa === 'Instalada') {

                    let lblcorreo = $('#lblcorreo').val();
                    let lblnombcliente = $('#lblnombcliente').val();
                    let lblmovil = $('#lblmovil').val();
                    let lblncontrato = $('#lblncontrato').val();
                    let fechainst = moment($('#fechainst').val(), 'DD/MM/YYYY').format('DD-MM-YYYY');
                    let lblmatricula = $('#lblmatricula').val();
                    let lbldc = `PE${$('#lbldc').val()}`;

                    let lbldistrito = $('#lbldistrito option:selected').text();
                    let arraylbldistrito = lbldistrito.split(" - ");
                    let distrito = arraylbldistrito[0];
                    let provincia = arraylbldistrito[1];

                    let lblsegmento = $('#lblsegmento').val();
                    let lbltipoventa = $('#lbltipoventa').val();

                    moment.locale('es');
                    let mesinst = moment($('#fechainst').val(), 'DD/MM/YYYY').format('MMMM');

                    data = {
                        "campaign_id": 309162,
                        "survey_id": 335464,
                        "respondent_email": lblcorreo,
                        "respondent_name": lblnombcliente,
                        "respondent_phone": lblmovil,
                        "respondent_expiration_days": 10,
                        "numero_de_instalacion": lblncontrato,
                        "fecha_instalacion": fechainst,
                        "matricula_vendedor": lblmatricula,
                        "delegacion": lbldc,
                        "city": distrito,
                        "state_description": provincia,
                        "segmento": lblsegmento,
                        "recurso": lbltipoventa,
                        "mes_de_instalacion": mesinst,
                        "apellido": " "
                    }

                    fetch('https://qservus.redcalidad.com/api/addrespondent/', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'Authorization': 'Token 69091bedd687e3b2da71f0d804df3853242a493c'
                            },
                            body: JSON.stringify(data),
                        })
                        .then(response => response.json())
                        .then(data => {
                            console.log('Success:', data);
                        })
                        .catch((error) => {
                            console.error('Error:', error);
                        });

                }
            }
        </script>
        <!-- CARRITO DE COMPRAS -->
        <script>
            //Evento que identifica cuando un extra es modificado
            $('#cboProducto').on('change', function() {
                const Producto = $('#cboProducto option:selected').val();
                const tipokit = $('#lbltipokit').val();
                //CODIGO USADO PARA REMOVER EL PRECIO DE REFERENCIA ENTRE PARENTESIS PARA OBTENER EL NOMBRE DEL PRODUCTO
                const txtProducto = $('#cboProducto option:selected').text().split(' (', 1)[0];
                $('#hidProducto').val(txtProducto);

                $('#cboTipoPrecio').val('').trigger('change');

                $("#cboTipoPrecio option[value='PrimeraUnidad']").remove();
                $("#cboTipoPrecio option[value='SegundaUnidadKitZV']").remove();

                if (Producto == 70) {
                    $('#cboTipoPrecio').append($("<option>", {
                        value: 'PrimeraUnidad',
                        text: 'PRIMERA UNIDAD'
                    }));
                }

                if (tipokit == 'ZeroVision') {
                    if (Producto == 84) {
                        $('#cboTipoPrecio').append($("<option>", {
                            value: 'SegundaUnidadKitZV',
                            text: 'SEGUNDA UNIDAD KIT ZEROVISION'
                        }));
                    }
                }
            })

            $('#cboTipoPrecio').on('change', function() {
                //RESETEAR VARIABLES DE CANTIDAD
                $('#cantidadProductos').val('');
                $('#cantidadProductos').prop('disabled', false);
                //RESETEAR VARIABLES DE PRECIO
                $('#precioUnitario').val('');
                $('#precioUnitario').prop('disabled', false);

                const Producto = $('#cboProducto option:selected').val();
                const TipoPrecio = $('#cboTipoPrecio option:selected').val();

                var data = {
                    Producto: Producto
                };

                fetch('ajax/selectListarExtrasField.php', {
                        method: 'POST',
                        body: JSON.stringify(data)
                    })
                    .then(function(res) {
                        return res.json();
                    })
                    .then(function(datos) {

                        const {
                            IdItem,
                            Item,
                            Precio,
                            CuotaMes
                        } = datos;

                        let precioTotal, descuento, precioMax;

                        //SI EL PRODUCTO ES UN MANDO
                        if (Producto == '70') {
                            if (TipoPrecio == 'catalogo') {
                                descuento = 1.00;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'medio') {
                                Swal.fire(
                                    'Alerta!',
                                    'Precio no autorizado',
                                    'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.75;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'autorizado') {
                                Swal.fire(
                                    'Alerta!',
                                    'Precio no autorizado',
                                    'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.50;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 0.75;
                            } else if (TipoPrecio == 'PrimeraUnidad') {
                                precioTotal = 49;

                                $('#cantidadProductos').val(1);
                                $('#precioUnitario').prop('disabled', true);
                                $('#cantidadProductos').prop('disabled', true);
                            }
                        } else if (Producto == '75') {
                            if (TipoPrecio == 'catalogo') {
                                descuento = 1.00;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'medio') {
                                Swal.fire(
                                    'Alerta!',
                                    'Precio no autorizado',
                                    'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.75;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'autorizado') {
                                Swal.fire(
                                    'Alerta!',
                                    'Precio no autorizado',
                                    'warning'
                                );
                                $('#cboTipoPrecio').val('');
                                return;
                                descuento = 0.50;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 0.75;
                            }
                        } else if (Producto == '84') {
                            if (TipoPrecio == 'catalogo') {
                                descuento = 1.00;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'medio') {
                                descuento = 0.75;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 0.75;
                            } else if (TipoPrecio == 'SegundaUnidadKitZV') {
                                precioTotal = 400;
                                $('#cantidadProductos').val(1);
                                $('#precioUnitario').prop('disabled', true);
                                $('#cantidadProductos').prop('disabled', true);
                            }
                        } // si el producto es llave
                        else if (Producto == '68') {
                            if (TipoPrecio == 'catalogo') {
                                descuento = 1.00;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'medio') {
                                descuento = 0.75;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'autorizado') {
                                precioTotal = 15.50;
                                precioMax = Precio * 0.75;
                            }
                        } else if (Producto == '85') {
                            if (TipoPrecio == 'catalogo') { //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal = 299;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 0.75;
                            }
                        } else if (Producto == '86') {
                            if (TipoPrecio == 'catalogo') { //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal = 449;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 0.75;
                            }
                        } else if (Producto == '87') {
                            if (TipoPrecio == 'catalogo') { //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal = 799;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 0.75;
                            }
                        } else if (Producto == '88') {
                            if (TipoPrecio == 'catalogo') { //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal = 549;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 0.75;
                            }
                        } else if (Producto == '89') {
                            if (TipoPrecio == 'catalogo') { //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal = 1399;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 0.75;
                            }
                        } else if (Producto == '90') {
                            if (TipoPrecio == 'catalogo') { //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal = 1399;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 0.75;
                            }
                        } else if (Producto == '91') {
                            if (TipoPrecio == 'catalogo') { //PACK DOBLE PROTECCION
                                descuento = 1.00;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'medio') {
                                //descuento = 0.75;
                                precioTotal = 1499;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 0.75;
                            }
                        } else {
                            if (TipoPrecio == 'catalogo') {
                                descuento = 1.00;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'medio') {
                                descuento = 0.75;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 1
                            } else if (TipoPrecio == 'autorizado') {
                                descuento = 0.50;
                                precioTotal = Precio * descuento;
                                precioMax = Precio * 0.75;
                            }
                        }


                        $('#precioUnitario').val(precioTotal)
                        $('#cuotaMes').val(CuotaMes);

                        $('#precioMin').val(precioTotal);
                        $('#precioMax').val(precioMax);


                    })

            })

            $('#precioUnitario').on('blur', function() {
                //alert($('#precioUnitario').val());

                const precio = parseFloat($(this).val());
                const TipoPrecio = $('#cboTipoPrecio').val();

                let max, min;

                if (TipoPrecio == 'catalogo') {

                    min = parseFloat($('#precioMin').val());
                    max = parseFloat($('#precioMax').val());

                    if (precio < min || precio > max) {
                        Swal.fire('Alerta!', `El precio no puede ser menor a ${min} o mayor a ${max}.`, 'warning');
                        $(this).val('');
                    }

                } else if (TipoPrecio == 'medio') {
                    min = parseFloat($('#precioMin').val());
                    max = parseFloat($('#precioMax').val());

                    if (precio < min || precio >= max) {
                        Swal.fire('Alerta!', `El precio no puede ser menor a ${min} o mayor igual a ${max}.`, 'warning');
                        $(this).val('');
                    }

                } else if (TipoPrecio == 'autorizado') {
                    min = parseFloat($('#precioMin').val());
                    max = parseFloat($('#precioMax').val());

                    if (precio < min || precio >= max) {
                        Swal.fire('Alerta!', `El precio no puede ser menor a ${min} o mayor igual a ${max}.`, 'warning');
                        $(this).val('');
                    }

                }


            })

            function getRandomInt(min, max) {
                return Math.floor(Math.random() * (max - min)) + min;
            }

            $('#btnAgregar').on('click', function(e) {
                const IdItem = $('#cboProducto').val();
                const Producto = $('#cboProducto option:selected').val();
                const Item = $('#hidProducto').val();

                const cantidadProductos = $('#cantidadProductos').val();
                const precioUnitario = $('#precioUnitario').val();
                const cuotaMes = $('#cuotaMes').val();

                const datos = {
                    Producto,
                    cantidadProductos
                };

                let numAleatorio = getRandomInt(10000, 99999);
                const dataID = `${Item}-${numAleatorio}`;

                if (validarProductoUnico(datos)) {

                    if (!validarProducto(datos)) {
                        Swal.fire(
                            '¡Formulario incompleto!',
                            'Por favor, completar todos los datos',
                            'warning'
                        );
                        return;
                    }

                    var data = {
                        CodItem: IdItem,
                        Item: Item,
                        cantidadProductos: cantidadProductos,
                        dataID: dataID
                    };

                    arregloDatos = [...arregloDatos, data];

                    const datosExtra = {
                        tipo: 'extra',
                        descripcion: Item,
                        dataID: dataID
                    }

                    arregloGeneral = [...arregloGeneral, datosExtra];

                    generarHtml();

                    $('#cboProducto').val('');
                    $('#cboTipoPrecio').val('');
                    $('#cantidadProductos').val('');
                    $('#precioUnitario').val('');
                } else {
                    Swal.fire(
                        '¡Extra repetido!',
                        'Imposible vender dos extras',
                        'warning'
                    );
                }

            })

            function validarProductoUnico(datos) {
                const {
                    Producto
                } = datos;

                if (arregloDatos.length > 0) {
                    const resultado = arregloDatos.find(elemento => elemento.CodItem === Producto);

                    if (resultado == undefined) {
                        return true;
                    } else {
                        return false;
                    }

                } else {

                    return true;
                }
            }

            function validarProducto(datos) {

                const {
                    Producto,
                    cantidadProductos
                } = datos;

                if (Producto == '' || Producto == null) {
                    return false;
                }

                if (cantidadProductos == '' || cantidadProductos == 0) {
                    return false;
                }

                return true;
            }

            function generarHtml() {

                limpiarHTML(listaExtras);

                let cantidadExtras = 0;
                let resumen = '';
                let subtotal = 0;
                let subtotalCuota = 0;


                if (arregloDatos.length > 0) {
                    arregloDatos.forEach(datos => {
                        console.log(datos);

                        const {
                            CodItem,
                            CuotaMes,
                            Item,
                            Precio,
                            TipoPrecio,
                            cantidadProductos,
                            totalProductos,
                            totalCuota,
                            dataID
                        } = datos;

                        let CuotaMes_Round = parseFloat(CuotaMes);
                        let Precio_Round = parseFloat(Precio);

                        listaExtras.innerHTML += `
                                <div class="row" style="margin-top: 5px;">
                                    <div class="col-md-12">
                                        <div class="info-box bg-gray" style="min-height: 0px;margin-bottom:0px">
                                            <p class="info-box-icon" style="width: 50%; font-size: 15px; height: auto; line-height: 0px; font-weight: bold;">${Item} <button class="btn borrar-extra" data-id="${dataID}" style="color: red; background-color: transparent;">X</button> </p>
                                            <div class="info-box-content" style="text-align: right;">
                                                <span class="info-box-number">Cantidad: ${cantidadProductos}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            `;

                        let cantidad;

                        cantidad = parseInt(cantidadProductos);
                        cantidadExtras += cantidad;

                        subtotal += totalProductos;
                        subtotalCuota += totalCuota;



                    })
                }

                //ALGORITMO PARA GENERAR EL RESUMEN DE INSTALACION PARA EXTRAS
                arregloGeneral.forEach((elemento, index) => {
                    //Si existe más de un elemento en el arreglo
                    if (arregloGeneral.length > 1) {
                        if ((arregloGeneral.length - 1) == index) {
                            resumen += `${elemento.descripcion} (${elemento.tipo})`;
                        } else {
                            resumen += `${elemento.descripcion} (${elemento.tipo}) + `;
                        }
                    } else {
                        resumen += `${elemento.descripcion}`;
                    }

                })

                $('#txtResumen').val(resumen);

                $('#txtCantidadExtra').val(cantidadExtras);

                $('#txtTotal').val(subtotal);
                $('#txtTotalCuota').val(subtotalCuota);

            }

            function generarHtmlRegalos() {

                limpiarHTML(listaRegalos);

                //const resumenventa = $('#lblresumenventa').val();

                let resumen = '';

                let cantidadRegalos = 0;

                let subtotal = 0;
                let subtotalCuota = 0;

                if (arregloRegalos.length > 0) {
                    arregloRegalos.forEach(datos => {

                        const {
                            CodItem,
                            CuotaMes,
                            Item,
                            Precio,
                            cantidad,
                            totalProductos,
                            totalCuota,
                            dataID
                        } = datos;

                        listaRegalos.innerHTML += `
                                                <div class="row" style="margin-top: 20px;">
                                                    <div class="col-md-12">
                                                        <div class="info-box bg-gray">
                                                            <p class="info-box-icon" style="width: 50%; font-size: 15px; height: 100px; line-height: 100px; font-weight: bold;">${Item} <button class="btn borrar-regalo" data-id="${dataID}" style="color: red; background-color: transparent;">X</button> </p>
                                                            <div class="info-box-content" style="text-align: right;">
                                                                <span class="info-box-text"> Cuota - S/. ${CuotaMes}</span>
                                                                <span class="info-box-text">${cantidad}</span>
                                                                <span class="info-box-number">Total cuota: ${totalCuota}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>`;



                        let auxCantProductos = parseInt(cantidad)

                        cantidadRegalos += auxCantProductos;
                        subtotalCuota += totalCuota;

                    })
                }

                console.log(arregloGeneral);
                //ALGORITMO PARA GENERAR EL RESUMEN DE INSTALACION PARA EXTRAS
                arregloGeneral.forEach((elemento, index) => {
                    //Si existe más de un elemento en el arreglo, por defecto el index 0 siempre es el KIT
                    if (arregloGeneral.length > 1) {
                        if ((arregloGeneral.length - 1) == index) {
                            resumen += `${elemento.descripcion} (${elemento.tipo})`;
                        } else {
                            resumen += `${elemento.descripcion} (${elemento.tipo}) + `;
                        }
                    } else {
                        //SE AGREGA EL TIPO DE KIT
                        resumen += `${elemento.descripcion}`;
                    }

                })

                $('#txtResumen__Regalo').val(resumen);
                $('#txtCantidadRegalo').val(cantidadRegalos);
                $('#txtTotalCuota__Regalo').val(subtotalCuota);

            }

            function limpiarHTML(cont) {
                //forma recomendada
                while (cont.firstChild) {
                    cont.removeChild(cont.firstChild);
                }

            }

            function validarProductoARLO(datos) {
                var valArloI = 0;
                var valArloE = 0;
                const {
                    Producto
                } = datos;
                if (Producto == "113") {
                    if (arregloDatos.length > 0) {
                        const resultadoCamaraInternaArlo = arregloDatos.find(elemento => elemento.CodItem == 110);
                        const resultadoCamaraExternaArlo = arregloDatos.find(elemento => elemento.CodItem == 111);
                        console.log(resultadoCamaraInternaArlo);
                        if (resultadoCamaraInternaArlo == undefined) {
                            valArloI = 0;
                        } else {
                            console.log(resultadoCamaraInternaArlo.TipoPrecio);
                            if (resultadoCamaraInternaArlo.TipoPrecio == 'catalogo') {
                                valArloI = 1;
                            } else {
                                valArloI = 0;
                            }

                        }
                        if (resultadoCamaraExternaArlo == undefined) {
                            valArloE = 0;
                        } else {
                            if (resultadoCamaraExternaArlo.TipoPrecio == 'catalogo') {
                                valArloE = 1;
                            } else {
                                valArloE = 0;
                            }

                        }
                        var sumaAR = (valArloI + valArloE);
                        console.log(sumaAR);
                        if (sumaAR == 0) {
                            return true;
                        } else {
                            return false;
                        }

                    } else {
                        return true;
                    }

                } else {
                    return false;
                }
            }
            //EXTRAS
            $('#generarOferta').on('click', function(e) {

                const txtResumen = $('#txtResumen').val();
                const txtCantidadExtra = $('#txtCantidadExtra').val();
                const txtTotal = $('#txtTotal').val();
                const txtTotalCuota = $('#txtTotalCuota').val();

                const datos = {
                    arregloDatos,
                    txtResumen,
                    txtCantidadRegalo,
                    txtTotal,
                    txtTotalCuota
                }

                //SET DATOS EN EL FORMULARIO
                $('#lbltotalextra').val(txtTotal);
                $('#lbltotalcuota').val(txtTotalCuota);
                $('#lblCantExtras').val(txtCantidadExtra);
                $('#lblresumenventa').val(txtResumen);

                Swal.fire({
                    icon: 'success',
                    text: 'Datos generados correctamente',
                    confirmButtonColor: '#e4002b'
                }).then((result) => {
                    $('#modal__carritocompras').modal('hide');
                })

            })

            $('#generarOferta__Regalo').on('click', function(e) {

                const txtResumen__Regalo = $('#txtResumen__Regalo').val();
                const txtCantidadRegalo = $('#txtCantidadRegalo').val();
                const txtTotalCuota__Regalo = parseFloat($('#txtTotalCuota__Regalo').val());
                let lbltotalcuota = parseFloat($('#lbltotalcuota').val());

                lbltotalcuota += txtTotalCuota__Regalo;

                $('#lblresumenventa').val(txtResumen__Regalo);
                $('#lblCantRegalos').val(txtCantidadRegalo);
                $('#lbltotalcuota').val(lbltotalcuota);

                Swal.fire({
                    icon: 'success',
                    text: 'Datos generados correctamente',
                    confirmButtonColor: '#e4002b'
                }).then((result) => {
                    $('#modal__regalos').modal('hide');
                })
            })

            $('#listaExtras').click(function(e) {
                if (e.target.classList.contains('borrar-extra')) {
                    const dataID = e.target.getAttribute('data-id');

                    //Elimina del arreglo de articulosCarrito por el data-id
                    arregloDatos = arregloDatos.filter(datos => datos.dataID != dataID);
                    arregloGeneral = arregloGeneral.filter(datos => datos.dataID != dataID);

                    generarHtml();


                    swal.fire('Extra eliminado', 'Se elimino el extra correctamente', 'success');
                }
            })
            //FALLO DE SUPERVISION
            $('#listaFalloSupervision').click(function(e) {
                if (e.target.classList.contains('borrar-extra')) {
                    const dataID = e.target.getAttribute('data-id');

                    //Elimina del arreglo de articulosCarrito por el data-id
                    arregloDatosFalloSupervision = arregloDatosFalloSupervision.filter(datos => datos.dataID != dataID);
                    //arregloGeneral = arregloGeneral.filter(datos => datos.dataID != dataID);

                    generarHtmlFalloSupervision();


                    swal.fire('Extra eliminado', 'Se elimino el extra correctamente', 'success');
                }
            })
            //Evento que identifica cuando un extra es modificado
            $('#cboProductoFalloSupervision').on('change', function() {
                const Producto = $('#cboProductoFalloSupervision option:selected').val();
                //CODIGO USADO PARA REMOVER EL PRECIO DE REFERENCIA ENTRE PARENTESIS PARA OBTENER EL NOMBRE DEL PRODUCTO
                const txtProducto = $('#cboProductoFalloSupervision option:selected').text().split(' (', 1)[0];
                $('#hidProductoFalloSupervision').val(txtProducto);

            })

            function generarHtmlFalloSupervision() {

                limpiarHTML(listaFalloSupervision);

                let cantidadExtras = 0;
                let resumen = '';
                let subtotal = 0;
                let subtotalCuota = 0;


                if (arregloDatosFalloSupervision.length > 0) {
                    arregloDatosFalloSupervision.forEach(datos => {
                        console.log(datos);

                        const {
                            CodItem,
                            Item,
                            cantidadProductos,
                            dataID
                        } = datos;

                        listaFalloSupervision.innerHTML += `
                                <div class="row" style="margin-top: 5px;">
                                    <div class="col-md-12">
                                        <div class="info-box bg-gray" style="min-height: 0px;margin-bottom:0px">
                                            <p class="info-box-icon" style="width: 50%; font-size: 15px; height: auto; line-height: 0px; font-weight: bold;">${Item} <button class="btn borrar-extra" data-id="${dataID}" style="color: red; background-color: transparent;">X</button> </p>
                                            <div class="info-box-content" style="text-align: right;">
                                                <span class="info-box-number">Cantidad: ${cantidadProductos}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            `;

                        let cantidad;

                        cantidad = parseInt(cantidadProductos);

                    })
                }

            }

            function validarProductoUnicoFalloSupervision(datos) {
                const {
                    Producto
                } = datos;

                if (arregloDatosFalloSupervision.length > 0) {
                    const resultado = arregloDatosFalloSupervision.find(elemento => elemento.CodItem === Producto);

                    if (resultado == undefined) {
                        return true;
                    } else {
                        return false;
                    }

                } else {

                    return true;
                }
            }

            function validarProductoFalloSupervision(datos) {

                const {
                    Producto,
                    cantidadProductos
                } = datos;

                if (Producto == '' || Producto == null) {
                    return false;
                }

                if (cantidadProductos == '' || cantidadProductos == 0) {
                    return false;
                }

                return true;
            }
            $('#btnAgregarFalloSupervision').on('click', function(e) {
                const IdItem = $('#cboProductoFalloSupervision').val();
                const Producto = $('#cboProductoFalloSupervision option:selected').val();
                const Item = $('#hidProductoFalloSupervision').val();

                const cantidadProductos = $('#cantidadProductosFalloSupervision').val();
                const datos = {
                    Producto,
                    cantidadProductos
                };

                let numAleatorio = getRandomInt(10000, 99999);
                const dataID = `${Item}-${numAleatorio}`;

                if (validarProductoUnicoFalloSupervision(datos)) {

                    if (!validarProductoFalloSupervision(datos)) {
                        Swal.fire(
                            '¡Formulario incompleto!',
                            'Por favor, completar todos los datos',
                            'warning'
                        );
                        return;
                    }

                    var data = {
                        CodItem: IdItem,
                        Item: Item,
                        cantidadProductos: cantidadProductos,
                        dataID: dataID
                    };

                    arregloDatosFalloSupervision = [...arregloDatosFalloSupervision, data];

                    const datosExtra = {
                        tipo: 'extra',
                        descripcion: Item,
                        dataID: dataID
                    }

                    arregloGeneral = [...arregloGeneral, datosExtra];

                    generarHtmlFalloSupervision();

                    $('#cboProductoFalloSupervision').val('');
                    $('#cantidadProductosFalloSupervision').val('');
                } else {
                    Swal.fire(
                        '¡Extra repetido!',
                        'Imposible agregar el mismo dispositivo',
                        'warning'
                    );
                }

            })
            
            function plantillacomentario(){
            const plantillacomentario=$('#lblplantillacomentario');
            
            const hidden_datossbn = $('#hidden_datossbn').val();
            const hidden_segincorrecto = $('#hidden_segincorrecto').val();
            const hidden_imagen = $('#hidden_imagen').val();
            const hidden_ingresoprogramacion = $('#hidden_ingresoprogramacion').val();
            const hidden_falloscomunicacion = $('#hidden_falloscomunicacion').val();
            const hidden_missingtest = $('#hidden_missingtest').val();
            const hidden_zerovision = $('#hidden_zerovision').val();
            const hidden_fallosupervision = $('#hidden_fallosupervision').val();
            const hidden_tamper = $('#hidden_tamper').val();
            let resumen="";
            let solucion="";
            
                if(hidden_datossbn=="SI" || hidden_segincorrecto=="SI" || hidden_zerovision=="SI" ||
                    hidden_falloscomunicacion=="SI" || hidden_fallosupervision=="SI" || hidden_missingtest=="SI" ||
                    hidden_imagen=="SI" || hidden_tamper=="SI" || hidden_ingresoprogramacion=="SI"){
                    resumen+="--Validacion paralizada por instalacion Inviable --Incidencia TEC.:";
                    solucion+="Solucion:";

                    if(hidden_datossbn=="SI"){
                        resumen+=" Diferencia entre datos de IBS y Verismart,";
                    }
                    if(hidden_segincorrecto=="SI"){
                        resumen+=" Error en Segmento,";
                    }
                    if(hidden_imagen=="SI"){
                        resumen+=" Error en Imagen,";
                    }
                    if(hidden_ingresoprogramacion=="SI"){
                        resumen+=" Ingreso en programacion despues de validar,";
                    }
                    if(hidden_falloscomunicacion=="SI"){
                        resumen+=" Fallos de comunicacion (COBERTURA),";
                    }
                    if(hidden_missingtest=="SI"){
                        resumen+=" Missing TEST,";
                    }
                    if(hidden_zerovision=="SI"){
                        resumen+=" Error testeo Zero Vision,";
                    }
                    if(hidden_fallosupervision=="SI"){
                        resumen+=" Fallo de supervision,";
                    } 
                    if(hidden_tamper=="SI"){
                        resumen+=" Manipulacion dispositivos posterior a la validacion,";
                    }
                    
                    //SOLUCION
                    if(hidden_datossbn=="SI" || hidden_segincorrecto=="SI"){
                        solucion+="Corregir datos en ficha de Verismart o IBS con ATTEC";
                    }
                    
                    if(hidden_datossbn=="SI" || hidden_segincorrecto=="SI"){
                        //SOLUCION
                        if(hidden_falloscomunicacion=="SI" || hidden_fallosupervision=="SI" || hidden_missingtest=="SI" || hidden_imagen=="SI" || hidden_tamper=="SI" || hidden_ingresoprogramacion=="SI" || hidden_zerovision=="SI"){
                            solucion+=",";
                        }else{
                            solucion+="";
                        }
                    }

                    //SOLUCION
                    if(hidden_falloscomunicacion=="SI" || hidden_fallosupervision=="SI" || hidden_missingtest=="SI" || hidden_zerovision=="SI"){
                        solucion+=" Ir a la instalacion y llamar a ATTEC para abrir MTO, revisar las observaciones y volver a pasar el validador. Antes de salir de la instalacion verificar con ATTEC para confirmar la solucion de incidencia y cambio de estado de la venta en Verismart";
                    }else if(hidden_imagen=="SI" || hidden_tamper=="SI" || hidden_ingresoprogramacion=="SI"){
                        solucion+=" Ir a la instalacion y llamar a ATTEC para abrir MTO, revisar las observaciones y volver a pasar el validador. Antes de salir de la instalacion verificar con ATTEC para confirmar la solucion de incidencia y cambio de estado de la venta en Verismart";
                    }else{
                        solucion+="";
                    } 
                    
                }
                
                plantillacomentario.val(solucion);
            }
        </script>

        <script>
            $('#inci_tecnica').bootstrapToggle({
			on:'SI',
			off:'NO',
			onstyle:'success',
			offstyle:'danger'
			});
        </script>

</body>

</html>