<?php
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
    }

    date_default_timezone_set('America/Lima');
    
    include 'config/db.php';
    include 'config/conexion.php';

    $fechadiahoy=date("d/m/Y");
    $fechconvercion=date('Y-m-d', strtotime($fechadiahoy));

    $dias=date("d");
    $mes=date("m");
    $ano=date("Y");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verisure | VeriSmart</title>
    
    <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" />
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
            folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
    <!-- daterange picker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-daterangepicker/daterangepicker.css">
    <!-- Date Picker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
    <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
    <!-- Alertifyjs -->
    <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <!--Hoja de estilos de la pagina dashboard visita *No usuar stilos en la misma pagina-->
    <link rel="stylesheet" href="css/dashboardvisita.css">
    
    <link rel="stylesheet" href="admin/bower_components/datatables.net-bs/css/dataTables.bootstrap.min.css">
    
    <!-- Schedule -->
    <link rel="stylesheet" href="admin/bower_components/jquery-schedule/style.min.css">
    
    <style>

        table tbody tr th{
            text-align: center;
        }
        .tblSubHeader, .Row__titulo{
            text-transform: uppercase;
        }
        
        .block{
            display: block!important;
        }
        
        .ocultar{
            display: none;
        }
        
        .bajo{
            background-color: #e4002b;
            color: white;
        }
        
        .medio{
            background-color: orange;
            color: white;
        }
        
        .alto{
            background-color: green;
            color: white;
        }
        
        .tblfooter{
            background-color: gray;
            color: white;
        }
        
        .big{
            width: 20%;
        }
        
        .mid{
            width: 15%;
        }
        
        .small{
            width: 8%;
        }
        
        .tblheadValue{
            background-color: gray;
            text-align: center;
            color: white;
        }
    </style>
    
    <style>
        .table-sortable th {
          cursor: pointer;
        }
        
        .table-sortable .th-sort-asc::after {
          content: "\25b4";
        }
        
        .table-sortable .th-sort-desc::after {
          content: "\25be";
        }
        
        .table-sortable .th-sort-asc::after,
        .table-sortable .th-sort-desc::after {
          margin-left: 5px;
        }
        
        .table-sortable .th-sort-asc,
        .table-sortable .th-sort-desc {
          background: #A62828;
        }
        
        .sizetr{
            height:3vw!important;
        }

    </style>
    <style>
        body {
            padding-top: 60px; /* 60px to make the container go all the way to the bottom of the topbar */
        }
        #logs{
            border: solid 1px #bbb;
            padding: 16px;
            background: #eee;
        }
        #logs .table{
            margin-bottom: 0;
        }
        #logs .table td,
        #logs .table th{
            border: none;
        }
        #schedule .sc_bar_insert{
            background-color: #ff678a;
        }
        #schedule .example2{
            background-color: #3eb698;
        }
        #schedule .example3{
            color: #2c0000;
            font-weight: bold;
            background-color: #c7ae50;
        }
        #schedule .sc_bar.sc_bar_photo .head,
        #schedule .sc_bar.sc_bar_photo .text{
            padding-left: 60px;
        }
        #schedule .sc_bar.sc_bar_photo .photo{
            position: absolute;
            left: 10px;
            top: 10px;
            width: 38px;
        }
        #schedule .sc_bar.sc_bar_photo .photo img{
            max-width: 100%;
        }
        .timeline {
            /* position: relative; */
            margin: 0;
            /* padding: 0; */
            /* list-style: none; */
        }
        .timeline:before {
        content: '';
        /* position: absolute; */
        /* top: 0; */
        /* bottom: 0; */
        /* width: 4px; */
        background: none;
        /* left: 31px; */
        /* margin: 0; */
        /* border-radius: 2px;*/        
        }
        .jq-schedule .sc_menu .sc_header .sc_time {
            background: #e4002b;
        }
        .content-wrapper, .right-side {
            padding-top: 0px;
        }        
    </style>    
</head>
<body class="skin-red sidebar-mini sidebar-collapse">
    <div id="divLoading" class="ocultar">
        <div class="spinner">
            <div class="bounce1"></div>
            <div class="bounce2"></div>
            <div class="bounce3"></div>
        </div>
    </div>
    <div class="wrapper">
        <!-- Header -->
        <?php include 'admin/header.php'; ?>
        <!-- Left side column. contains the logo and sidebar -->
        <?php
            $inicio = "active";
            $dashboardagendadia= "active";
            include 'admin/main-sidebar.php';
        ?>
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <div style="font-size:180%;"> DASHBOARD&nbsp <span style="font-size:80%;color:#DAD8D4"> | &nbsp <span style="font-size:80%;color:#8D8A80">AGENDA DIA</span></span> </div>              
                <ol class="breadcrumb">
                    <li><a class="text-left"><font color="red">DIA: <?php echo $dias."/".$mes."/".$ano;?></font></a></li>
                </ol>
            </section>
            <!-- Main content -->
            <section class="content">
                <div class="box box-danger" >
                    <div class="box-header"> 
                        <i class="fa fa-bar-chart-o"></i> 
                        <h3 class="box-title">Fecha Programacion -  | 
                            <input type="text" style="font-size:100%;color:#444; background-color: #fff;border: 0; font-weight: bold;" id="fechaCotizacion" name="fechaCotizacion" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask="" value="<?php echo $fechadiahoy; ?>">
                        </h3>
                        
                    </div>
                    
                    <div class="box-body">
                            <div id="schedule"></div>
                                      
                    </div>
                    
                </div>
                
            </section>
            <?php include 'modalpassword.php';?>
            
        </div>
    </div>
    <!-- jQuery 3 -->
    <script src="admin/bower_components/jquery/dist/jquery.min.js"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <!-- Bootstrap 3.3.7 -->
    <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
    <!-- SELECT 2 -->
    <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
    <!-- date-range-picker -->
    <script src="admin/bower_components/moment/min/moment.min.js"></script>
    <script src="admin/bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
    <!-- datepicker -->
    <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
    <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>

    <!-- Bootstrap WYSIHTML5 -->
    <script src="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
    <!-- Slimscroll -->
    <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <!-- FastClick -->
    <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
    <!-- AdminLTE App -->
    <script src="admin/dist/js/adminlte.min.js"></script>
    <!-- SWEET ALERT -->
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- CHARTS -->
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    
    <script src="admin/bower_components/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="admin/bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
    <!-- Schedule -->
    <script src="admin/bower_components/jquery-schedule/jq.schedule.min.js"></script>

    <!-- INICIALIZADORES -->
    <script>
        $('#fechaCotizacion').datepicker({
            autoclose: true,
            language: 'es',
            firstDay: 1
        })
        
    </script>
    <!-- document ready -->
    <script>
        $(document).ready(() => {
            //$('#divLoading').removeClass('ocultar');
            //$('#divLoading').addClass('block');
            //GENERAR TABLA DEL DIA

            /*
            setTimeout(function(){
                $('#divLoading').addClass('ocultar');
                $('#divLoading').removeClass('block');
                
                $('#divTable').removeClass('ocultar');
            }, 4200);
            */

        })
    </script>


  
<script type="text/javascript">
    function addLog(type, message){
        var $log = $('<tr />');
        $log.append($('<th />').text(type));
        $log.append($('<td />').text(message ? JSON.stringify(message) : ''));
        $("#logs table").prepend($log);
    }
    
    function cargardatos($sc){
        const fechaCotizacion = moment($('#fechaCotizacion').val(), "DD/MM/YYYY").format("YYYY-MM-DD");
            $.ajax({
                type: 'Post',
                url: 'ajax/dataDashboardAgendaDia.php',
                data: {fechaCotizacion: fechaCotizacion},
                dataType: 'json',
                success: function(data){
                    console.log(data)
                    console.log (data.data);
                    //console.log(String.value(data.data));
                     $sc.timeSchedule('setRows', data.data);
                        //return data
                }
            });
           
    }

    $(function(){
        var isDraggable = true;
        var isResizable = true;
        var $sc = $("#schedule").timeSchedule({
            startTime: "08:00", // schedule start time(HH:ii)
            endTime: "22:00",   // schedule end time(HH:ii)
            widthTime: 60 * 10,  // cell timestamp example 10 minutes
            timeLineY: 70,       // height(px)
            verticalScrollbar: 20,   // scrollbar (px)
            timeLineBorder: 2,   // border(top and bottom)
            bundleMoveWidth: 6,  // width to move all schedules to the right of the clicked time line cell
            draggable: isDraggable,
            dataWidth: 300,
            resizable: isResizable,
            resizableLeft: true,
            rows : {
                '0' : {
                    title : 'Title Area1',
                    schedule:[
                        {
                            
                            end: '12:00:00',
                            start: '09:00:00',
                            text: 'Text Area',
                            data: {
                            }
                        },
                        {
                            start: '12:15',
                            end: '14:00',
                            text: 'Text Area',
                            data: {
                            }
                        }
                    ]
                },
                '1' : {
                    title : 'Title Area2',
                    schedule:[
                        {
                            start: '16:00',
                            end: '17:00',
                            text: 'Text Area',
                            data: {
                            }
                        }
                    ]
                }
            },
            onChange: function(node, data){
                addLog('onChange', data);
            },
            onInitRow: function(node, data){
                addLog('onInitRow', data);
            },
            onClick: function(node, data){
                 window.location.href = 'editaragenda_pre.php?idventa='+data.data.IdVenta+'&rc=agcontroldiario';
                //console.log(node)
                //console.log(data)
                //console.log(data.data.IdVenta)
            },
            onAppendRow: function(node, data){
               
            },
            onAppendSchedule: function(node, data){
                addLog('onAppendSchedule', data);
                if(data.data.class){
                    node.addClass(data.data.class);
                }
                if(data.data.image){
                    var $img = $('<div class="photo"><img></div>');
                    $img.find('img').attr('src', data.data.image);
                    node.prepend($img);
                    node.addClass('sc_bar_photo');
                }
            },
            onScheduleClick: function(node, time, timeline){
                /*
                var start = time;
                var end = $(this).timeSchedule('formatTime', $(this).timeSchedule('calcStringTime', time) + 3600);
                $(this).timeSchedule('addSchedule', timeline, {
                    start: start,
                    end: end,
                    text:'Insert Schedule',
                    data:{
                        class: 'sc_bar_insert'
                    }
                });
                addLog('onScheduleClick', time + ' ' + timeline);
                */
            },
        });
        cargardatos($sc);
     
        $('#event_timelineData').on('click', function(){
            addLog('timelineData', $sc.timeSchedule('timelineData'));
        });
        $('#event_scheduleData').on('click', function(){
            addLog('scheduleData', $sc.timeSchedule('scheduleData'));
        });
        $('#event_resetData').on('click', function(){
            $sc.timeSchedule('resetData');
            addLog('resetData');
        });
        $('#event_resetRowData').on('click', function(){
            $sc.timeSchedule('resetRowData');
            addLog('resetRowData');
        });
        $('#event_setDraggable').on('click', function(){
            isDraggable = !isDraggable;
            $sc.timeSchedule('setDraggable', isDraggable);
            addLog('setDraggable', isDraggable ? 'enable' : 'disable');
        });
        $('#event_setResizable').on('click', function(){
            isResizable = !isResizable;
            $sc.timeSchedule('setResizable', isResizable);
            addLog('setResizable', isResizable ? 'enable' : 'disable');
        });
        $('.ajax-data').on('click', function(){
            $.ajax({url: './data/'+$(this).attr('data-target')})
                .done( (data) => {
                    addLog('Ajax GetData', data);
                    $sc.timeSchedule('setRows', data);
                });
        });
        $('#clear-logs').on('click', function(){
            $('#logs .table').empty();
        });
        $('#fechaCotizacion').on('change', function(){
            //var $sc = $("#schedule").timeSchedule();
            cargardatos($sc);
        })        
    });
</script>

    
</body>
</html>