<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}

$ingresokit=0;
$ingresoextras=0;
$ingresototal=0;

$affectedrowAgenda = 0;

require '../config/db.php';
require '../config/conexion.php';
//FUNCIONES LOG
include 'log/insertLog.php'; //LOG TRANSAC
include 'log/insertLogCliente.php'; //LOG CLIENTE
include 'log/insertLogVenta.php'; //LOG VENTA
include 'log/insertLogAgenda.php'; //LOG AGENDA

//FUNCIONES DE VENTA
include 'funciones/Venta.php';

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';

$gestor=$_POST['gestor'];
$estvisita=$_POST['lblestvisita'];
$estadoventa=$_POST['lblestventa'];
$tipoventa=$_POST['lbltiventa'];
$categoria=$_POST['lblcategoria'];
$validarfechainst="";
$fechmod=date("Y-m-d H:i:s");
$idagenda=$_POST['lblidagenda'];
$idventa=$_POST['lblidventa'];
$comentarioco=$_POST['lblcomentarioco'];
$hidden_contactadoco=$_POST['hidden_contact'];
$hidden_ventaconfirmadaco=$_POST['hidden_ventaconfirmadaco'];
$hidGGCC=$_POST['hidGGCC'];

$fecharegistroventa = date("Y-m-d H:i:s");

//VARIABLES NUEVAS DE LLENADA
$lbltipokit=$_POST['lbltipokit'];
$lblCantExtras=$_POST['lblCantExtras'];
$lblclosingpack=$_POST['lblclosingpack'];
$lblresultadoScoring=$_POST['lblresultadoScoring'];



if(isset($_POST['contratoenviado'])){
    $contratoenviado=$_POST['contratoenviado'];
}else{
    $contratoenviado=NULL;
}
if(isset($_POST['contratocorrecto'])){
    $contratocorrecto=$_POST['contratocorrecto'];
}else{
    $contratocorrecto=NULL;
}

if(isset($_POST['lblprecioespecial'])){
    $lblprecioespecial=$_POST['lblprecioespecial'];
}else{
    $lblprecioespecial=NULL;
}
$hidden_HCertificacion=$_POST['hidden_HCertificacion'];
$IdDocRP=$_POST['IdDocRP'];

//AUTORIZACION DE CARRITO DE COMPRA
if(isset($_POST['hidregalosAutorizados']) && $_POST['hidregalosAutorizados']!=""){
    $hidregalosAutorizados=$_POST['hidregalosAutorizados']; 
}else{
    $hidregalosAutorizados=NULL;
}

if(isset($_POST['hidcategoriaKitAutorizados']) && $_POST['hidcategoriaKitAutorizados']!=""){
    $hidcategoriaKitAutorizados=$_POST['hidcategoriaKitAutorizados']; 
}else{
    $hidcategoriaKitAutorizados=NULL;
}

if(isset($_POST['hidclosingpackAutorizados']) && $_POST['hidclosingpackAutorizados']!=""){
    $hidclosingpackAutorizados=$_POST['hidclosingpackAutorizados']; 
}else{
    $hidclosingpackAutorizados=NULL;
}

if(isset($_POST['hiddescuetocuotaAutorizados']) && $_POST['hiddescuetocuotaAutorizados']!=""){
    $hiddescuetocuotaAutorizados=$_POST['hiddescuetocuotaAutorizados']; 
}else{
    $hiddescuetocuotaAutorizados=NULL;
}

if(isset($_POST['FechaContratoEnviado']) && $_POST['FechaContratoEnviado']!=""){
    $FechaContratoEnviado=$_POST['FechaContratoEnviado']; 
    $FechaContratoEnviado=myUrlEncode($FechaContratoEnviado);
    $FechaContratoEnviado=format_date_Y_mm_dd(str_replace('/', '-', $FechaContratoEnviado));    
}else{
    $FechaContratoEnviado=NULL;
}

if(isset($_POST['pagoenviadoCO']) && $_POST['pagoenviadoCO']!=""){
    $pagoenviadoCO=$_POST['pagoenviadoCO']; 
}else{
    $pagoenviadoCO=NULL;
}
if(isset($_POST['montoCO']) && $_POST['montoCO']!=""){
    $montoCO=$_POST['montoCO']; 
}else{
    $montoCO=NULL;
}
if(isset($_POST['motivoincidenciaCO']) && $_POST['motivoincidenciaCO']!=""){
    $motivoincidenciaCO=$_POST['motivoincidenciaCO']; 
}else{
    $motivoincidenciaCO=NULL;
}
if(isset($_POST['contratocorregidoenviadoCO']) && $_POST['contratocorregidoenviadoCO']!=""){
    $contratocorregidoenviadoCO=$_POST['contratocorregidoenviadoCO']; 
}else{
    $contratocorregidoenviadoCO=NULL;
}
if(isset($_POST['fechadiferenciaCO']) && $_POST['fechadiferenciaCO']!=""){
    $fechadiferenciaCO=$_POST['fechadiferenciaCO']; 
    $fechadiferenciaCO=myUrlEncode($fechadiferenciaCO);
    $fechadiferenciaCO=format_date_Y_mm_dd(str_replace('/', '-', $fechadiferenciaCO));       
    
}else{
    $fechadiferenciaCO=NULL;
}
if(isset($_POST['fechaenviocontratocorregidofinalCO']) && $_POST['fechaenviocontratocorregidofinalCO']!=""){
    
    $fechaenviocontratocorregidofinalCO=$_POST['fechaenviocontratocorregidofinalCO']; 
    $fechaenviocontratocorregidofinalCO=myUrlEncode($fechaenviocontratocorregidofinalCO);
    $fechaenviocontratocorregidofinalCO=format_date_Y_mm_dd(str_replace('/', '-', $fechaenviocontratocorregidofinalCO));        
    
}else{
    $fechaenviocontratocorregidofinalCO=NULL;
}
if(isset($_POST['diferenciamontoCO']) && $_POST['diferenciamontoCO']!=""){
    $diferenciamontoCO=$_POST['diferenciamontoCO']; 
}else{
    $diferenciamontoCO=NULL;
}
if(isset($_POST['comentarior2CO']) && $_POST['comentarior2CO']!=""){
    $comentarior2CO=$_POST['comentarior2CO']; 
}else{
    $comentarior2CO=NULL;
}

if(isset($_POST['fechagestiondocCO']) && $_POST['fechagestiondocCO']!=""){
    
    $fechagestiondocCO=$_POST['fechagestiondocCO']; 
    $fechagestiondocCO=myUrlEncode($fechagestiondocCO);
    $fechagestiondocCO=format_date_Y_mm_dd(str_replace('/', '-', $fechagestiondocCO));        
    
}else{
    $fechagestiondocCO=NULL;
}
if(isset($_POST['fechagestiondocr2CO']) && $_POST['fechagestiondocr2CO']!=""){
    
    $fechagestiondocr2CO=$_POST['fechagestiondocr2CO']; 
    $fechagestiondocr2CO=myUrlEncode($fechagestiondocr2CO);
    $fechagestiondocr2CO=format_date_Y_mm_dd(str_replace('/', '-', $fechagestiondocr2CO));        
    
}else{
    $fechagestiondocr2CO=NULL;
}

    //NUEVAS DATOS PARA LA INFORMACION DE LA VENTA PILOTO NUEVO CARRITO DE COMPRA KIT, EXTRA Y REGALO (26.10.2021)

    if(isset($_POST['lblcategoriaprecio'])){
        $lblcategoriaprecio = $_POST['lblcategoriaprecio'];
    } else {
        $lblcategoriaprecio = null;
    }
     //NUEVOS DATOS PARA EL DETALLE EXTRAS Y REGALOS
     if(isset($_POST['lblCantRegalos'])){
        $lblCantRegalos = $_POST['lblCantRegalos'];
     } else {
         $lblCantRegalos = null;
     }
     
     if(isset($_POST['lbltotalcuota'])){
        $lbltotalcuota = $_POST['lbltotalcuota'];
     }else {
         $lbltotalcuota = null;
     }
     if(isset($_POST['lblDescuentoCuota'])){
        $lblDescuentoCuota = $_POST['lblDescuentoCuota'];
     } else {
         $lblDescuentoCuota = null;
     }
     if(isset($_POST['lbltipocamarakit'])){
        $lbltipocamarakit = $_POST['lbltipocamarakit'];
     }else {
         $lbltipocamarakit = NULL;
     }
     if(isset($_POST['lblsegundaalarma'])){
        $lblsegundaalarma = $_POST['lblsegundaalarma'];
     }else {
         $lblsegundaalarma = NULL;
     }


    if(isset($_POST['valcodigoOperacionScoring'])){
        if($_POST['valcodigoOperacionScoring']=='' || empty($_POST['valcodigoOperacionScoring'])){
            $valcodigoOperacionScoring=NULL;  
            $IdConsultaScoring=NULL;
            $PerfilScoring=NULL;
            $Accion=NULL;
        } else {
            $valcodigoOperacionScoring=$_POST['valcodigoOperacionScoring'];

        
            try{
                $stmtScoring = $con->prepare( "SELECT t.IdConsultaScoring,t.PerfilScoring,t.Accion,t.TipoDocumento,t.NumeroDocumento FROM dbVENTAS.tbltmpscoring t WHERE t.NumeroOperacion= ?");
                $stmtScoring->bind_param('s', $valcodigoOperacionScoring);
                $stmtScoring->execute();
                $stmtScoring->store_result();
                $stmtScoring->bind_result($IdConsultaScoring,$PerfilScoring,$Accion,$TipoDocumento,$NumeroDocumento);
                $stmtScoring->fetch();        
                $stmtScoring->close();
        
            } catch(PDOException $e) {
                $error='error';
            }

                //DOCUMENTO
                if ($IdDocRP == NULL){
                     $resultadoDocumento = insertarDocumento($TipoDocumento,$NumeroDocumento,$fecharegistroventa);
                     if ($resultadoDocumento > 0){
                     $IdDocRP=$resultadoDocumento;

                     }else{
                     $IdDocRP=NULL;  
                     }
                     
                }else{
                    $resultadoDocumento = actualizarDocumento($TipoDocumento,$NumeroDocumento,$IdDocRP);
                    if ($resultadoDocumento > 0){
                    }else{
                    }
                }

            
            }
    } else {
            $valcodigoOperacionScoring=NULL;   
            $IdConsultaScoring=NULL;
            $PerfilScoring=NULL;
            $Accion=NULL;            
    }

    //PROCECSAR LA INFORMACION DEL DETALLE EXTRA Y REGALOS

    $detalleExtras = $_POST['detalleExtras'];
    $detalleRegalos = $_POST['detalleRegalos'];
    $detalleGeneral = $_POST['detalleGeneral'];
    
    $resultadoRegistroRegalos = registrarExtrasRegalos($detalleExtras, $detalleRegalos, $detalleGeneral);

   
//DECLARACION DE VARIABLES RE

if($tipoventa=="RE"){
    //VARIABLES POST 
    $mesesautorizados=$_POST['lblmesesautorizados'];
    $preciokit=$_POST['lblpreciokit'];
    $totalextra=$_POST['lbltotalextra'];
    $extraautorizado=$_POST['lblextraautorizado'];
    $formadepago=$_POST['lblformadepago'];
    $n590=$_POST['lbl590'];
    $PAI=$_POST['lblPAI'];
    $resumenventa=$_POST['lblresumenventa'];
    $idcliente=$_POST['lblidcliente'];
    if($categoria=="Delegacion"){
    
        //Agenda
        $finstalacion=$_POST['lblfinstalacion'];
        $hinstalacion=$_POST['lblhinstalacion'];
        
        if ($finstalacion == '' || empty($finstalacion)){
            $fechagrabar = NULL;
        } else {
            $fechaconvert=  myUrlEncode($finstalacion);
            $fechagrabar=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvert));
        }
        
        if ($hinstalacion == '' || empty($hinstalacion)){
            $horagrabarcomparar = NULL;
        } else {
            $horaconvert=  myUrlEncode($hinstalacion);
            $horagrabar=  date("H:i", strtotime(str_replace("+"," ",$horaconvert)));
            $horagrabarcomparar=  date("H:i:s", strtotime(str_replace("+"," ",$horaconvert)));
        }

        $instaladox=$_POST['lblinstaladox'];
        $tecnico=$_POST['lbltecnico'];
        $comentarioagenda=$_POST['lblcomentarioagenda'];
        $fecharegistroagenda = date("Y-m-d H:i:s");
        $fecharegistrofacturacion = date("Y-m-d H:i:s");
        $inviable=utf8_decode($_POST['lblinviable']);

 
    }
}
else{
    if($categoria=="Delegacion"){
        //Agenda
        $finstalacion=$_POST['lblfinstalacion'];
        $hinstalacion=$_POST['lblhinstalacion'];
        
        if ($finstalacion == '' || empty($finstalacion)){
            $fechagrabar = NULL;
        } else {
            $fechaconvert=  myUrlEncode($finstalacion);
            $fechagrabar=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvert));
        }
        
        if ($hinstalacion == '' || empty($hinstalacion)){
            $horagrabarcomparar = NULL;
        } else {
            $horaconvert=  myUrlEncode($hinstalacion);
            $horagrabar=  date("H:i", strtotime(str_replace("+"," ",$horaconvert)));
            $horagrabarcomparar=  date("H:i:s", strtotime(str_replace("+"," ",$horaconvert)));
        }
        
        $matricula=$_POST['lblmatricula'];
        $nombcomercial=$_POST['lblnombcomercial'];
        $dc=$_POST['lbldc'];
        $jefeventa=$_POST['lbljefeventa'];
        
        $segmento=$_POST['lblsegmento'];
        
        $direccion=$_POST['lbldireccion'];
        $distrito=$_POST['lbldistrito'];
        $nprospecto=$_POST['lblnprospecto'];
        $nprospectohidden=$_POST['lblnprospectohidden'];
        $mesesautorizados=$_POST['lblmesesautorizados'];
        $preciokit=$_POST['lblpreciokit'];
        $totalextra=$_POST['lbltotalextra'];
        $extraautorizado=$_POST['lblextraautorizado'];
        $formadepago=$_POST['lblformadepago'];
        $n590=$_POST['lbl590'];
        $PAI=$_POST['lblPAI'];
        
        $instaladox=$_POST['lblinstaladox'];
        $tecnico=$_POST['lbltecnico'];
        $comentarioagenda=$_POST['lblcomentarioagenda'];
        $fecharegistroagenda = date("Y-m-d H:i:s");
        $fecharegistrofacturacion = date("Y-m-d H:i:s");
        $fecharegistroventa = date("Y-m-d H:i:s");
        
        $nombcliente=$_POST['lblnombcliente'];
        $telefonouno=$_POST['lblmovil'];
        $telefonodos=$_POST['lblfijo'];
        $correo=$_POST['lblcorreo'];
        $idusuario=$_POST['lblidusuario'];
        $resumenventa=$_POST['lblresumenventa'];
        
        $idcliente=$_POST['lblidcliente'];
        $inviable=utf8_decode($_POST['lblinviable']);
    }
    else{
        $matricula=$_POST['lblmatricula'];
        $nombcomercial=$_POST['lblnombcomercial'];
        $dc=$_POST['lbldc'];
        $jefeventa=$_POST['lbljefeventa'];
        
        $segmento=$_POST['lblsegmento'];
        
        $direccion=$_POST['lbldireccion'];
        $distrito=$_POST['lbldistrito'];
        $nprospecto=$_POST['lblnprospecto'];
        $nprospectohidden=$_POST['lblnprospectohidden'];
        $mesesautorizados=$_POST['lblmesesautorizados'];
        $preciokit=$_POST['lblpreciokit'];
        $totalextra=$_POST['lbltotalextra'];
        $extraautorizado=$_POST['lblextraautorizado'];
        $formadepago=$_POST['lblformadepago'];
        $n590=$_POST['lbl590'];
        $PAI=$_POST['lblPAI'];
        
        $fecharegistroagenda = date("Y-m-d H:i:s");
        $fecharegistrofacturacion = date("Y-m-d H:i:s");
        $fecharegistroventa = date("Y-m-d H:i:s");
        
        $nombcliente=$_POST['lblnombcliente'];
        $telefonouno=$_POST['lblmovil'];
        $telefonodos=$_POST['lblfijo'];
        $correo=$_POST['lblcorreo'];
        $idusuario=$_POST['lblidusuario'];
        $resumenventa=$_POST['lblresumenventa'];
                             
        $idcliente=$_POST['lblidcliente'];
    }
}

//DECLARACION DE VARIABLES CON PAI Y SIN PAI
    if($PAI=="PAI 30x36"){
    
    $ingresokit=round((($preciokit+(1080*0.729))/1.18),2);
    $ingresoextras=round(($totalextra/1.18),2);
    $ingresototal=($ingresokit+$ingresoextras);
    
    }
    else if($PAI=="PAI 30x48"){
    $ingresokit=round((($preciokit+(1440*0.663))/1.18),2);
    $ingresoextras=round(($totalextra/1.18),2);
    $ingresototal=($ingresokit+$ingresoextras);
    
    }    
    else{
    
    $ingresokit=round((($preciokit)/1.18),2);
    $ingresoextras=round(($totalextra/1.18),2);
    $ingresototal=($ingresokit+$ingresoextras);
    }

//PROCESAMIENTO DE LA INFORMACION CASO RE Y RP
if($tipoventa=="RE"){
    if($categoria=="Delegacion"){
        $arrayVenta = consultaVenta_General($idventa);
        $arrayAgenda = consultaAgenda($idventa);
        //Documento RP
        $resultadoCliente=actualizarClienteDoc($idcliente);
        
        //ACTUALIZA DATOS DE LA TABLA VENTA SIN SEGMENTO Y NPROSPECTO
        $resultadoventa = actualizarVenta($idventa);
        
        //ACTUALIZA DATOS DE LA TABLA AGENDA
        $resultadoagenda = actualizarAgenda($idventa);
       
        try {
    
          $stmtAgenhist = $con->prepare("INSERT INTO dbVENTAS.tblagendahist(IdAgenda, IdVenta, FechaInst, HoraInst, InstaladoX, MatriculaTec, Comentario, FechaHoraREG,GestorAgenda,EstadoVenta) VALUES(?,?,?,?,?,?,?,?,?,?)");
          $stmtAgenhist->bind_param('iissssssss', $idagenda,$idventa,$fechagrabar,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistroagenda,$gestor,$estadoventa);
          $stmtAgenhist->execute();
          $stmtAgenhist->close();
        } catch (\Exception $e) {
            $error = array(
                'respuesta' => 'error'
            );
        }


    }
    else {
        $arrayVenta = consultaVenta_General($idventa);
        $arrayAgenda = consultaAgenda($idventa);
        //Documento RP
        $resultadoCliente=actualizarClienteDoc($idcliente);
        //ACTUALIZA DATOS DE LA TABLA VENTA SIN SEGMENTO Y NPROSPECTO
        $resultadoventa = actualizarVenta($idventa);
        $resultadoagenda = 0; 
        
        
        if($estadoventa=='PendienteData' || $estadoventa=='PendienteAgenda'){
            $resultadoagenda = actualizarAgenda($idventa);
            $comentarioventaagenda="Ingresa a Agenda";
           
            try {
        
              $stmtAgenhist = $con->prepare("INSERT INTO dbVENTAS.tblagendahist(IdAgenda, IdVenta,Comentario, FechaHoraREG,GestorAgenda,EstadoVenta) VALUES(?,?,?,?,?,?)");
              $stmtAgenhist->bind_param('iissss', $idagenda,$idventa,$comentarioventaagenda,$fechmod,$gestor,$estadoventa);
              $stmtAgenhist->execute();
              $stmtAgenhist->close();
            } catch (\Exception $e) {
                $error = array(
                    'respuesta' => 'error'
                );
            }
            
        }
        
    }
    
    if ($resultadoventa > 0 || $resultadoagenda > 0){

            $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
            $usuariosesion=htmlspecialchars($_SESSION['usuariosesion']);
            $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa);
            $Acceso='Modificar';
            $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
            
            try {
                    
              $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
              $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fechmod, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
              $stmt->execute();
              $idLogSeg = $con->insert_id;
              $stmt->close();
              
            } catch (\Exception $e) {
              echo $e->getMessage();
            }        
    
        if ($resultadoventa > 0){
            insertLogVenta_General($idLogSeg, $arrayVenta);
        }
        if ($resultadoagenda > 0){
            insertLogAgenda($idLogSeg, $arrayAgenda);
        }
        
        echo 1;
    }
    else if ($resultadoventa == 0 || $resultadoagenda == 0) {
        echo 0; //NINGUN CAMBIO FUE REALIZADO
    }
    else {
        echo -1; //ERROR
    }
}
else {
    
    if(editar_buscarProspecto($nprospecto,$nprospectohidden)==false){
        echo 2;
    }else{
    
    
        if($categoria=="Delegacion"){
        
            $arrayVenta = consultaVenta($idventa);
            $arrayAgenda = consultaAgenda($idventa);
            $arrayCliente = consultaCliente($idcliente);
            
            //ACTUALIZA DATOS DEL CLIENTE
            $resultadoCliente = actualizarCliente($idcliente);
            
            //ACTUALIZA DATOS DE LA VENTA
            $resultadoventa = actualizarVenta_Cliente($idventa);
            
            //ACTUALIZA DATOS DE LA TABLA AGENDA
            $resultadoagenda = actualizarAgenda($idventa);

            try {
        
              $stmtAgenhist = $con->prepare("INSERT INTO dbVENTAS.tblagendahist(IdAgenda, IdVenta, FechaInst, HoraInst, InstaladoX, MatriculaTec, Comentario, FechaHoraREG,GestorAgenda,EstadoVenta) VALUES(?,?,?,?,?,?,?,?,?,?)");
              $stmtAgenhist->bind_param('iissssssss', $idagenda,$idventa,$fechagrabar,$horagrabar,$instaladox,$tecnico,$comentarioagenda,$fecharegistroagenda,$gestor,$estadoventa);
              $stmtAgenhist->execute();
              $stmtAgenhist->close();
            } catch (\Exception $e) {
                $error = array(
                    'respuesta' => 'error'
                );
            }           
            
    
        }
        else {
            $arrayVenta = consultaVenta($idventa);
            $arrayAgenda = consultaAgenda($idventa);
            $arrayCliente = consultaCliente($idcliente);
            
            //ACTUALIZA DATOS DEL CLIENTE
            $resultadoCliente = actualizarCliente($idcliente);
            
            //ACTUALIZA DATOS DE LA VENTA
            $resultadoventa = actualizarVenta_Cliente($idventa);
            
            $resultadoagenda = 0;
            
            if($estadoventa=='PendienteData' || $estadoventa=='PendienteAgenda'){
                
                $resultadoagenda = actualizarAgenda($idventa);

                $comentarioventaagenda="Ingresa a Agenda";
               
                try {
            
                  $stmtAgenhist = $con->prepare("INSERT INTO dbVENTAS.tblagendahist(IdAgenda, IdVenta,Comentario, FechaHoraREG,GestorAgenda,EstadoVenta) VALUES(?,?,?,?,?,?)");
                  $stmtAgenhist->bind_param('iissss', $idagenda,$idventa,$comentarioventaagenda,$fechmod,$gestor,$estadoventa);
                  $stmtAgenhist->execute();
                  $stmtAgenhist->close();
                } catch (\Exception $e) {
                    $error = array(
                        'respuesta' => 'error'
                    );
                }
                

            
            }
        }
    
        if ($resultadoCliente > 0 || $resultadoventa > 0 || $resultadoagenda > 0){
                $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
                $usuariosesion=htmlspecialchars($_SESSION['usuariosesion']);
                $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa);
                $Acceso='Modificar';
                $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
                
                try {
                        
                  $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
                  $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fechmod, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
                  $stmt->execute();
                  $idLogSeg = $con->insert_id;
                  $stmt->close();
                  
                } catch (\Exception $e) {
                  echo $e->getMessage();
                } 
            
            if ($resultadoventa > 0){
                insertLogVenta($idLogSeg, $arrayVenta);
            }
            if ($resultadoCliente > 0){
                insertarLog($idLogSeg, $arrayCliente);
            }
            if ($resultadoagenda > 0){
                insertLogAgenda($idLogSeg, $arrayAgenda);
            }
            
            echo 1;
        }
        else if ($resultadoCliente == 0 || $resultadoventa == 0 || $resultadoagenda == 0) {
            echo 0; //NINGUN CAMBIO FUE REALIZADO
        }
        else {
            echo -1; //ERROR
        }

    }
}


function actualizarVenta($idventa){
    
    global $con;
    
    global $categoria;
    global $tipoventa;
    global $preciokit;
    global $totalextra;
    global $ingresototal;
    global $ingresokit;
    global $ingresoextras;
    global $estadoventa;
    global $extraautorizado;
    global $mesesautorizados;
    global $n590;
    global $formadepago;
    global $PAI;
    global $resumenventa;
    global $estvisita;
    global $hidden_contactadoco;
    global $hidden_ventaconfirmadaco;
    global $hidGGCC;
    global $comentarioco;
    //NUEVOS CAMPOS
    global $lbltipokit;
    global $lblCantExtras;
    global $lblclosingpack;
    global $lblresultadoScoring;
    global $lblprecioespecial;
    global $hidden_HCertificacion;
    global $IdConsultaScoring;
    global $hidregalosAutorizados;
    global $hidcategoriaKitAutorizados;
    global $hidclosingpackAutorizados;
    global $hiddescuetocuotaAutorizados;
     //NUEVOS CAMPOS PARA CARRITO
    global $lblCantRegalos;
    global $lbltotalcuota;
    global $lblcategoriaprecio;
    global $lblDescuentoCuota;
    global $lbltipocamarakit;
    global $lblsegundaalarma;
    global $contratoenviado;
    global $contratocorrecto;
    global $FechaContratoEnviado;
    global $pagoenviadoCO;
    global $montoCO;
    global $motivoincidenciaCO;
    global $contratocorregidoenviadoCO;
    global $fechadiferenciaCO;
    global $fechaenviocontratocorregidofinalCO;
    global $diferenciamontoCO;
    
    global $comentarior2CO;
    global $fechagestiondocCO;
    global $fechagestiondocr2CO;


    try{
        $stmt = $con->prepare("UPDATE dbVENTAS.tblventa SET CategoriaVenta=?, TipoVenta=?, PrecioKit=?, TotalExtra=?, IngresoKIT=?, IngresoTotal=?, EstadoVenta=?, ExtraAutorizado=?, MesesAutorizado=?, N590=?, FormaPago=?, PAI=?, ResumenVenta=?, EstadoVisita=?, PrecioKITOriginal=?, TotalExtraOriginal=?, ExtraAutorizadoOriginal=?, MesesAutorizadoOriginal=?, FormaPagoOriginal=?, PAIOriginal=?, ResumenVentaOriginal=?, ContactadoCO=?, VTAConfirmadaCO=?, ComentarioCO=?, TipoKIT=?, CantidadExtras=?, ClosingPack=?, ScoringRP=?, PrecioEspecial=?,HojaCertificacion=?,IdConsultaScoringRP=?,GGCC=?,RegalosAutorizados=?,ClosingpackAutorizados=?,CategoriaKitAutorizados=?,DescuentoCuotaAutorizados=?,CantidadRegalo=?,CantidadRegaloOriginal=?,TotalCuotaMonitoreo=?,CategoriaPrecio=?,dsctCuota=?,TipoCamaraKit=?,SegundaAlarma=?,ContratoEnviado=?,ContratoCorrecto=?,FechaContratoEnviado=?,pagoenviadoCO=?,montoCO=?,motivoincidenciaCO=?,contratocorregidoenviadoCO=?,fechadiferenciaCO=?,fechaenviocontratocorregidofinalCO=?,diferenciamontoCO=?,comentarior2CO=?,fechagestiondocCO=?,fechagestiondocr2CO=?  WHERE IdVenta=?");
        $stmt->bind_param('ssddddssssssssddsssssssssissssisssssiidssssssssdssssdsssi', $categoria, $tipoventa, $preciokit, $totalextra, $ingresokit, $ingresototal, $estadoventa, $extraautorizado, $mesesautorizados, $n590, $formadepago, $PAI, $resumenventa, $estvisita, $preciokit, $totalextra, $extraautorizado, $mesesautorizados, $formadepago, $PAI, $resumenventa, $hidden_contactadoco, $hidden_ventaconfirmadaco, $comentarioco, $lbltipokit, $lblCantExtras, $lblclosingpack, $lblresultadoScoring, $lblprecioespecial, $hidden_HCertificacion,$IdConsultaScoring,$hidGGCC,$hidregalosAutorizados,$hidclosingpackAutorizados,$hidcategoriaKitAutorizados,$hiddescuetocuotaAutorizados,$lblCantRegalos, $lblCantRegalos, $lbltotalcuota, $lblcategoriaprecio, $lblDescuentoCuota,$lbltipocamarakit,$lblsegundaalarma,$contratoenviado,$contratocorrecto,$FechaContratoEnviado,$pagoenviadoCO,$montoCO,$motivoincidenciaCO,$contratocorregidoenviadoCO,$fechadiferenciaCO,$fechaenviocontratocorregidofinalCO,$diferenciamontoCO,$comentarior2CO,$fechagestiondocCO,$fechagestiondocr2CO,$idventa);
        $stmt->execute();
    
        $respuesta = $stmt->affected_rows;
            
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
}

function actualizarVenta_Cliente($idventa){
    
    global $con;
    
    global $idusuario;
    global $idcliente;
    global $matricula;
    global $nombcomercial;
    global $dc;
    global $jefeventa;
    
    global $segmento;
    global $nprospecto;
    
    global $categoria;
    global $tipoventa;
    global $preciokit;
    global $totalextra;
    global $ingresototal;
    global $ingresokit;
    global $ingresoextras;
    global $estadoventa;
    global $extraautorizado;
    global $mesesautorizados;
    global $n590;
    global $formadepago;
    global $PAI;
    global $resumenventa;
    global $estvisita;
    global $hidden_contactadoco;
    global $hidden_ventaconfirmadaco;
    global $comentarioco;
    
    //NUEVOS CAMPOS
    global $lbltipokit;
    global $lblCantExtras;
    global $lblclosingpack;
    global $lblresultadoScoring;
    global $lblprecioespecial;
    global $hidden_HCertificacion;
    global $IdConsultaScoring;
    global $PerfilScoring;
    global $Accion;
    global $hidGGCC;
    global $hidregalosAutorizados;
    global $hidcategoriaKitAutorizados;
    global $hidclosingpackAutorizados;
    global $hiddescuetocuotaAutorizados;
    
         //NUEVOS CAMPOS PARA CARRITO
    global $lblCantRegalos;
    global $lbltotalcuota;
    global $lblcategoriaprecio;
    global $lblDescuentoCuota;
    global $lbltipocamarakit;
    global $lblsegundaalarma;
    global $contratoenviado,$contratocorrecto,$FechaContratoEnviado;
    
    global $pagoenviadoCO;
    global $montoCO;
    global $motivoincidenciaCO;
    global $contratocorregidoenviadoCO;
    global $fechadiferenciaCO;
    global $fechaenviocontratocorregidofinalCO;
    global $diferenciamontoCO;
    global $comentarior2CO;
    
    
    try{
        $stmt = $con->prepare("UPDATE dbVENTAS.tblventa SET IdUsuario=?, IdCliente=?, Matricula=?, Comercial=?, CC=?, JefeVenta=?, CategoriaVenta=?, TipoVenta=?, Segmento=?, NProspecto=?, PrecioKit=?, TotalExtra=?, IngresoKIT=?, IngresoTotal=?, EstadoVenta=?, ExtraAutorizado=?, MesesAutorizado=?, N590=?, FormaPago=?, PAI=?, ResumenVenta=?, EstadoVisita=?, PrecioKITOriginal=?, TotalExtraOriginal=?, ExtraAutorizadoOriginal=?, MesesAutorizadoOriginal=?, FormaPagoOriginal=?, PAIOriginal=?, ResumenVentaOriginal=?, ContactadoCO=?, VTAConfirmadaCO=?, ComentarioCO=?, TipoKIT=?, CantidadExtras=?, ClosingPack=?, ScoringRP=?, PrecioEspecial=?,HojaCertificacion=?,IdConsultaScoringRP=?,PerfilScoring=?,Accion=?,GGCC=?,RegalosAutorizados=?,ClosingpackAutorizados=?,CategoriaKitAutorizados=?,DescuentoCuotaAutorizados=?,CantidadRegalo=?,CantidadRegaloOriginal=?,TotalCuotaMonitoreo=?,CategoriaPrecio=?,dsctCuota=?,TipoCamaraKit=?,SegundaAlarma=?,ContratoEnviado=?,ContratoCorrecto=?,FechaContratoEnviado=?,pagoenviadoCO=?,montoCO=?,motivoincidenciaCO=?,contratocorregidoenviadoCO=?,fechadiferenciaCO=?,fechaenviocontratocorregidofinalCO=?,diferenciamontoCO=?,comentarior2CO=?  WHERE IdVenta=?");
        $stmt->bind_param('iissssssssddddssssssssddsssssssssissssisssssssiidssssssssdssssdsi', $idusuario, $idcliente, $matricula, $nombcomercial, $dc, $jefeventa, $categoria, $tipoventa, $segmento, $nprospecto, $preciokit, $totalextra, $ingresokit, $ingresototal, $estadoventa, $extraautorizado, $mesesautorizados, $n590, $formadepago, $PAI, $resumenventa, $estvisita, $preciokit, $totalextra, $extraautorizado, $mesesautorizados, $formadepago, $PAI, $resumenventa, $hidden_contactadoco, $hidden_ventaconfirmadaco, $comentarioco, $lbltipokit, $lblCantExtras, $lblclosingpack, $lblresultadoScoring, $lblprecioespecial,$hidden_HCertificacion,$IdConsultaScoring,$PerfilScoring,$Accion,$hidGGCC,$hidregalosAutorizados,$hidclosingpackAutorizados,$hidcategoriaKitAutorizados,$hiddescuetocuotaAutorizados,$lblCantRegalos, $lblCantRegalos, $lbltotalcuota, $lblcategoriaprecio, $lblDescuentoCuota,$lbltipocamarakit,$lblsegundaalarma,$contratoenviado,$contratocorrecto,$FechaContratoEnviado,$pagoenviadoCO,$montoCO,$motivoincidenciaCO,$contratocorregidoenviadoCO,$fechadiferenciaCO,$fechaenviocontratocorregidofinalCO,$diferenciamontoCO,$comentarior2CO,$idventa);
        $stmt->execute();
    
        $respuesta = $stmt->affected_rows;
            
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function actualizarAgenda($idventa){
    
    global $con;
    
    global $fechagrabar;
    global $horagrabar;
    global $instaladox;
    global $tecnico;
    global $comentarioagenda;
    global $fecharegistroagenda;
    global $inviable;
    global $cancelado;
    global $repercucion;
    global $costo;
    
    global $gestor;
    global $estadoventa;
    
    $fechagrabar = stringtonull($fechagrabar);
    $horagrabar = stringtonull($horagrabar);
    $instaladox = stringtonull($instaladox);
    $tecnico = stringtonull($tecnico);
    $comentarioagenda = stringtonull($comentarioagenda);
    $inviable = stringtonull($inviable);
    $cancelado = stringtonull($cancelado);
    $repercucion = stringtonull($repercucion);
    $costo = stringtonull($costo);

    try{
        
        $stmt = $con->prepare("UPDATE dbVENTAS.tblagenda SET FechaInst=?, HoraInst=?, InstaladoX=?, MatriculaTec=?, Comentario=?, MotivoInviable=?, MotivoCancelada=?, Repercusion=?, RepercusionCosto=?, GestorAgenda=?, EstadoVenta=? WHERE IdVenta=?");
        $stmt->bind_param('sssssssssssi', $fechagrabar, $horagrabar, $instaladox, $tecnico, $comentarioagenda, $inviable, $cancelado, $repercucion, $costo, $gestor, $estadoventa, $idventa);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function actualizarCliente($idcliente){
    
    global $con;
    
    global $distrito;
    global $nombcliente;
    global $telefonouno;
    global $telefonodos;
    global $correo;
    global $direccion;
    global $IdDocRP;
    
    $telefonodos = stringtonull($telefonodos);
    
    try{
        $stmt = $con->prepare("UPDATE dbVENTAS.tblcliente SET IdGeografico= ?, NombApellido= ?, Telefonouno= ?, Telefonodos= ?, Correo= ?, Direccion= ?,IdDocRP=? WHERE IdCliente = ?");
        $stmt->bind_param("isssssii", $distrito, $nombcliente, $telefonouno, $telefonodos, $correo, $direccion, $IdDocRP,$idcliente);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function stringtonull($val){
    
    if ($val == '' || empty($val) || !isset($val)){
        $resultado = NULL;
    }
    else {
        $resultado = $val;
    }
    
    return $resultado;
}

function insertarDocumento($tipodoc,$documento,$fecharegistro){
    global $con;
    $tipodocnuevo="";
    if($tipodoc==1){
        $tipodocnuevo="DNI";
    }else if($tipodoc==6){
       $tipodocnuevo="RUC"; 
    }else{
       $tipodocnuevo="CE"; 
    }
        try {
    
          $stmt = $con->prepare("INSERT INTO dbVENTAS.tbldocumento(TipoDocumento, Documento, FechaHoraREG) VALUES(?, ?, ?)");
          $stmt->bind_param('sss', $tipodocnuevo,$documento,$fecharegistro);
            $stmt->execute();
            $respuesta = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
    
        return $respuesta;
    

}

function actualizarDocumento($tipodoc,$documento,$IdDocRP){
    global $con;
    $tipodocnuevo="";
    if($tipodoc==1){
        $tipodocnuevo="DNI";
    }else if($tipodoc==6){
       $tipodocnuevo="RUC"; 
    }else{
       $tipodocnuevo="CE"; 
    }
    
    try{
        $stmt = $con->prepare("UPDATE tbldocumento SET TipoDocumento=?, Documento=? WHERE IdDoc = ?");
        $stmt->bind_param('ssi', $tipodocnuevo,$documento, $IdDocRP);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();  
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
        return $respuesta;    
}

//Funcion nueva Cliente
function actualizarClienteDoc($idcliente){
    global $con;

    global $IdDocRP;

    try{
        $stmt = $con->prepare("UPDATE dbVENTAS.tblcliente SET IdDocRP=? WHERE IdCliente = ?");
        $stmt->bind_param("ii", $IdDocRP, $idcliente);
        $stmt->execute();

        $respuesta = $stmt->affected_rows;
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }

    return $respuesta;
}

function registrarExtrasRegalos($detalleExtras, $detalleRegalos, $detalleGeneral){
    global $con;
    global $idventa;
    $fecharegistro = date("Y-m-d H:i:s");
    
    if(($detalleExtras==''||$detalleExtras==null)&&($detalleExtras==''||$detalleExtras==null)&&($detalleExtras==''||$detalleExtras==null)){
        return 'error';
    }
    
    $sql = "SELECT DetalleExtras, DetalleRegalos FROM tblventacotizacion WHERE IdVenta =".$idventa;
    $resultado = $con->query($sql);
    
    $row_cnt = $resultado->num_rows;
    /*
    while($data = $resultado->fetch_assoc()){
        $DetalleExtras__BD = $data['DetalleExtras'];
        $DetalleRegalos__BD = $data['DetalleRegalos'];
    }
    */
    if($row_cnt > 0){

        try{
            $stmt = $con->prepare("UPDATE tblventacotizacion SET DetalleExtras=?, DetalleRegalos=?, DetalleGeneral=? WHERE IdVenta = ?");
            $stmt->bind_param("sssi", $detalleExtras, $detalleRegalos, $detalleGeneral, $idventa);
            $stmt->execute();
            $respuesta = $stmt->affected_rows;
            $stmt->close();
            
        }catch (\Exception $e) {
            $respuesta = 'error';
        }
        
    } else {
    
        try{
            $stmt = $con->prepare("INSERT INTO tblventacotizacion (IdVenta, FechaHoraREG, DetalleExtras, DetalleRegalos, DetalleGeneral) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("issss", $idventa, $fecharegistro, $detalleExtras, $detalleRegalos, $detalleGeneral);
            $stmt->execute();

            $respuesta = $con->insert_id;
            
            $stmt->close();
            
        }catch (\Exception $e) {
            $respuesta = 'error';
        }
    }
    
    return $respuesta;
}


