<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}


require '../config/db.php';
require '../config/conexion.php';
//FUNCIONES LOG
//include 'log/insertLog.php'; //LOG TRANSAC
//include 'log/insertLogCliente.php'; //LOG CLIENTE
//include 'log/insertLogVenta.php'; //LOG VENTA
//include 'log/insertLogAgenda.php'; //LOG AGENDA

//FUNCIONES DE VENTA
//include 'funciones/Venta.php';

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';


$IdVenta = htmlspecialchars($_POST['IdVenta']);
$EstadoVenta = htmlspecialchars($_POST['EstadoVenta']);
$IdCliente = htmlspecialchars($_POST['IdCliente']);
$NContrato = htmlspecialchars($_POST['NContrato']);
$NContratoActual = htmlspecialchars($_POST['NContratoActual']);
$estadoVentaActual = htmlspecialchars($_POST['estadoVenta']);
$idVentaActual = htmlspecialchars($_POST['idVentaActual']);
$IdClienteActual = htmlspecialchars($_POST['IdClienteActual']);
$estadoUpdate = 'InstaladaDEL';
$estadoCancelada = 'Cancelada';


$respuesta = ['respuesta' => 'error'];

$fechaActual = date("Y-m-d H:i:s");

$idUsuario = $_SESSION['id_usuario'];

$usuarioSession = $_SESSION['usuariosesion'];

$dataUrl = $_SERVER['REQUEST_URI'];

$nombreCampoVenta = 'IdVenta';

$tablaVenta = 'tblventa';

$tablaCliente = 'tblCliente';

function enviarMensaje($NContrato,$NContratoActual,$usuarioSession,$estadoVentaActual){
            $mensajeCorreo = '
				<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
				<html xmlns="http://www.w3.org/1999/xhtml">
					<head>
						<meta http-equiv="Content-Type" content="text/html charset=utf-8"/>
						<meta name="viewport" content="width=480, user-scalable=1" />
						<title>Verisure Perú</title>
						<link href="https://fonts.googleapis.com/css?family=Fira+Sans:400,700" rel="stylesheet">
					</head>
					<body style="margin-left: 0px; margin-top: 0px; margin-right: 0px; margin-bottom: 0px; background-color:#f4f4f4">
						<table width="600" align="center" border="0" cellspacing="0" cellpadding="0" bgcolor="#f4f4f4">
						<tr>
							<td align="center">
								<!-- CREATIVIDAD -->
								<table width="600" height="0" bgcolor="#ffffff" border="0" cellspacing="0" cellpadding="0">
									<tr>
										
									</tr>
								</table>
								<table width="600" height="0" bgcolor="#ffffff" border="0" cellspacing="0" cellpadding="0">
									<tr>
										
									</tr>
								</table>
								<table style="background-color: #ffffff;" width="550" cellspacing="0" cellpadding="0" border="0">
									<tbody>
										<tr>
											<td width="500">
												<p style="text-align: center;font-size: 24px;font-family:  Fira Sans, Arial;color: #ff0033; font-weight: bold;margin-top: 0px; ">Estimados compañeros</p>
												<p style="text-align: justify;font-size: 18px;font-family:  Fira Sans, Arial;color: #757575;margin-bottom: 25px; padding:0px 25px;">Se les notifica que se realizó la modificación del contrato '.$NContratoActual.' por el nuevo '.$NContrato.' por el usuario '.$usuarioSession.'. Favor de tomarlo en consideración.</p>
											</td>
										</tr>
									</tbody>
								</table>
								<table width="600" height="0" bgcolor="#ffffff" border="0" cellspacing="0" cellpadding="0">
									<tr>
										
									</tr>
								</table>
								<table width="600" height="0" bgcolor="#ffffff" border="0" cellspacing="0" cellpadding="0">
									<tr>
										
									</tr>
								</table>
								<br>
								<table width="550" height="0"  border="0" cellspacing="0" cellpadding="0">
									<tr>
										
										<td style="padding: 0 8px; font-size: 14px; line-height: 50px; font-family: Lucida Grande, Lucida Sans Unicode, Lucida Sans, DejaVu Sans, Verdana, sans-serif; color: #333333; text-align: center;" align="-">
											
										</td>
										<td align="right" style="font-size: 14px; line-height: 1px; font-family: Fira Sans, sans-serif; color: #747474; text-align: right;">
											
										</td>
									</tr>
								</table>
								<table width="550" height="0"  border="0" cellspacing="0" cellpadding="0">
									<tr>
										<td style="padding-left: 5px; padding-right: 5px; padding-top: 16px; font-size: 13px; line-height: 15px; font-family: Fira Sans, Arial, sans-serif; color: #737373; text-align: center;" width="33.333%" align="center">
										
										</td>
										<td style="padding-left: 5px; padding-right: 5px; padding-top: 16px; font-size: 13px; line-height: 15px; font-family: Fira Sans, Arial, sans-serif; color: #737373; text-align: center;" width="33.333%" align="center">
										
										</td>
										<td style="padding-left: 5px; padding-right: 5px; padding-top: 16px; font-size: 13px; line-height: 15px; font-family: Fira Sans, Arial, sans-serif; color: #737373; text-align: center;" width="33.333%" align="center">
											
									</tr>
									<tr>
										<td style="padding-left: 5px; padding-right: 5px; font-size: 14px; line-height: 42px; font-family: Arial, sans-serif; color: #333333; text-align: center; border-right: 0px solid #979797" width="33.333%" align="center">
											
										<td style="padding-left: 5px; padding-right: 5px; font-size: 14px; line-height: 42px; font-family: Arial, sans-serif; color: #333333; text-align: center;border-left: solid 1px;border-right: solid 1px;" >
											
										<td style="padding-left: 5px; padding-right: 5px; font-size: 14px; line-height: 42px; font-family: Arial, sans-serif; color: #333333; text-align: center;" width="33.333%" align="center">
										
										</td>
									</tr>
									<tr>
										<td style="padding-left: 5px; padding-right: 5px; padding-top: 16px; font-size: 13px; line-height: 15px; font-family: Arial, sans-serif; color: #737373; text-align: center;" width="33.333%" align="center">
										
										</td>
										<td style="padding-left: 5px; padding-right: 5px; padding-top: 16px; font-size: 13px; line-height: 15px; font-family: Arial, sans-serif; color: #737373; text-align: center;" width="33.333%" align="center">
											
										</td>
										<td style="padding-left: 5px; padding-right: 5px; padding-top: 16px; font-size: 13px; line-height: 15px; font-family: Arial, sans-serif; color: #737373; text-align: center;" width="33.333%" align="center">
										
									</tr>
								</table>
								<br><br>
								<table style="border-radius: 0px 0px 45px 45px;" width="550" cellspacing="0" cellpadding="0" border="0" bgcolor="#ffffff" align="center">
									<tbody>
										<tr>
											<td width="600">
												
											</td>
										</tr>
										<tr>
											<td width="600">
												
											</td>
										</tr>
									</tbody>
								</table>
								<table width="600" align="center" border="0" cellspacing="0" cellpadding="0" bgcolor="#f4f4f4">
									<tbody>
										<tr>
											<td width="550">
												<p style="color: #c1c1c1;text-align: center;font-size: 10px;font-family:  Fira Sans, Arial;padding-bottom: 10px; padding-top: 15px;"> Copyright © 2022 Verisure Peru, All rights reserved. Nuestra dirección es: Av. Primavera 1050 Oficina 501 – Santiago de Surco.
											</td>
										</tr>
									</tbody>
								</table>
							</td>
						</tr>
					</table>
				</html>				
				';
 		//echo($mensajeCorreo); exit;
		
    // 	$correoElectronicoCliente = 'incidenciasfact@verisure.pe';

        $correoElectronicoCliente = 'incidenciasfact@verisure.pe';
        $correoBackoffice = 'backoffice@verisure.pe';
        
        if ($estadoVentaActual === 'Instalada' || $estadoVentaActual === 'NoInstalada') {
            // Agrega el correo de backoffice a la lista de destinatarios
            $to = array(
                'Email' => array(
                    0 => $correoElectronicoCliente,
                    1 => $correoBackoffice,
                )
            );
        } else {
            // Usa la lista original de destinatarios
            $to = array(
                'Email' => array(
                    0 => $correoElectronicoCliente,
                )
            );
        }
		
		$from = 'desarrollo@verisure.pe';
		
		$fromName = 'Desarrollo';
		
		$asunto = 'MODIFICACIÓN DE NÚMERO DE CONTRATO';
		
		$opts = array(
            'http'=>array(
            'method'=>"GET",
            'header'=>"User-Agent: api script\r\n"
            )
        );
        
        $context = stream_context_create($opts);
        
        $curl = curl_init();
        
        $dataSC= array (
          'GeneralData' => 
          array (
            'FromName' => $fromName,
            'From' => $from,
            'To' => $to,
            'Cc' => 
            array (
              'Email' => 
              array (
                0 => "",
              )
            ),
            'Bcc' => 
            array (
              'Email' => 
              array (
                0 => "pcurilopez@gmail.com",
              )
            ),
            'Message' => 
            array (
              'Subject' => $asunto,
              'Classification' => 'C',
              'Body' => 
              array (
                'Format' => 'html',
                "Value"=> $mensajeCorreo
              )
            ),
            'Options' => 
            array (
              'OpenTracking' => 'true',
              'ClickTracking' => 'true',
              'TextHtmlTracking' => 'true',
              'AutoTextBody' => 'false',
            )
          )
        );

        $dataSC_string = json_encode($dataSC);
        
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://api2023.masterbase.com/UniqueMail/v3/verisuremktpe",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 60,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => $dataSC_string,
          CURLOPT_HTTPHEADER => array(
            "authorization: Basic U2VjdXJpdHlfY2hlY2s6Njc1NC1TQDlxYTAjZDZVN2MzdzU=",
            "cache-control: no-cache",
            "content-type: application/json"
          ),
        ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
			$message = sprintf($this->mensajeError->msg6,"");
			echo $this->alertas->alertaError($message);
			echo $this->alertas->refrescar(1);
        }
}


// Función para actualizar tblventa
function actualizarTblVenta($con, $estado, $nContrato, $idVenta) {
    $updateVenta = $con->prepare("UPDATE dbVENTAS.tblventa t SET t.EstadoVenta=?, t.NContrato=? WHERE t.IdVenta=?");
    $updateVenta->bind_param('sii', $estado, $nContrato, $idVenta);
    $updateVenta->execute();
    return $updateVenta->affected_rows > 0;
}

// Función para actualizar tblcliente
function actualizarTblCliente($con, $nCliente, $idCliente) {
    $updateCliente = $con->prepare("UPDATE dbVENTAS.tblcliente SET NCliente=? WHERE IdCliente=?");
    $updateCliente->bind_param('si', $nCliente, $idCliente);
    $updateCliente->execute();
    return $updateCliente->affected_rows > 0;
}

// Función para insertar un registro en tbllog
function insertarLogSeguridad($con, $accion, $fecha, $id, $nombreId) {
    $url = $_SERVER['REQUEST_URI'] . '=>' . $nombreId . '=' . $id;
    $usuario = $_SESSION['usuariosesion'];
    $navegador = $_SERVER['HTTP_USER_AGENT'];
    $ip = $_SERVER['REMOTE_ADDR'];
    
    $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip, usuario, fechahorareg, url, accion, navegador) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param('ssssss', $ip, $usuario, $fecha, $url, $accion, $navegador);
    $stmt->execute();

    return $stmt->insert_id;
}

// Función para insertar un registro en tbllog_transac
function insertarLogTransac($con, $IdUsuario, $usuario, $IdLogSeg, $Url, $Identificador, $accion, $Tabla, $RegActual, $RegNuevo, $FechaHoraReg) {
    $Url = $_SERVER['REQUEST_URI'] . '=>' . $nombreCampoVenta . '=' . $idVentaActual;
    
    $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog_transac(Id_Usuario, usuario, IdLogSeg, URL, Identificador, accion, Tabla, RegActual, RegNuevo, FechaHoraReg) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param('isisisssss', $IdUsuario, $usuario, $IdLogSeg, $Url, $Identificador, $accion, $Tabla, $RegActual, $RegNuevo, $FechaHoraReg);
    $stmt->execute();
}

// Función para insertar un registro en tbllog_transac específico para tblcliente
function insertarLogCliente($con, $IdUsuario, $usuario, $IdLogSeg, $Url, $Identificador, $accion, $Tabla, $RegActual, $RegNuevo, $FechaHoraReg) {
    // Aquí podrías personalizar la lógica para tblcliente si es necesario
    // Puedes adaptar esta función según los campos específicos de tblcliente
    insertarLogTransac($con, $IdUsuario, $usuario, $IdLogSeg, $Url, $Identificador, $accion, $Tabla, $RegActual, $RegNuevo, $FechaHoraReg);
}



if ($IdVenta == '') {
    // Actualizar tblventa y tblcliente del registro actual
    $ventaActualizada = actualizarTblVenta($con, $estadoUpdate, $NContrato, $idVentaActual);
    $clienteActualizado = actualizarTblCliente($con, $NContrato, $IdClienteActual);

    if ($ventaActualizada && $clienteActualizado) {
        
        $dataJsonActual = array();
        
        $dataJsonVenta = array(
                'NContrato' => $NContrato
            );
        
        $jsonNumeroVenta = json_encode($dataJsonVenta);
        
        $dataJsonCliente = array(
                'NCliente' => $NContrato
            );
        
        $jsonNumeroCliente = json_encode($dataJsonCliente);
        
        $evento = 'Modificar';
        
        // Insertar registro de cambio en tbllog
        $idLogSeguridad = insertarLogSeguridad($con, $evento, $fechaActual, $idVentaActual, $nombreCampoVenta);

        // Insertar registro de cambio en tbllog_transac para tblventa
        insertarLogTransac($con, $idUsuario, $usuarioSession, $idLogSeguridad, $dataUrl, $idVentaActual, $evento, $tablaVenta, $dataJsonActual, $jsonNumeroVenta, $fechaActual);

        // Insertar registro de cambio en tbllog_transac para tblcliente
        insertarLogCliente($con, $idUsuario, $usuarioSession, $idLogSeguridad, $dataUrl, $IdClienteActual, $evento, $tablaCliente, $dataJsonActual, $jsonNumeroCliente, $fechaActual);

        $respuesta = ['respuesta' => 'exito'];
    }
} elseif ($IdVenta <> '' && $estadoVentaActual <> 'PorFacturar' && $estadoVentaActual <> 'Facturada' && $EstadoVenta <> 'PorFacturar' && $EstadoVenta <> 'Facturada') {
    // Actualizar tblventa y tblcliente del registro que contiene al NContrato (Cancelada)
    
    $ventaCancelada = actualizarTblVenta($con, $estadoCancelada, null, $IdVenta);
    $clienteCancelado = actualizarTblCliente($con, null, $IdCliente);

    if ($ventaCancelada && $clienteCancelado) {
        
        $evento = 'Modificar';
        
        $jsonEstadoCancelado = json_encode(['EstadoVenta' => $estadoCancelada]);
        
        $jsonClienteNull = json_encode(['NCliente' => null]);
        
        // Insertar registro de cambio en tbllog
        $idLogSeguridadCancelada = insertarLogSeguridad($con, $evento, $fechaActual, $IdVenta, $nombreCampoVenta);

        // Insertar registro de cambio en tbllog_transac para tblventa (Cancelada)
        insertarLogTransac($con, $idUsuario, $usuarioSession, $idLogSeguridadCancelada, $dataUrl, $IdVenta, $evento, $tablaVenta, '', $jsonEstadoCancelado, $fechaActual);

        // Insertar registro de cambio en tbllog_transac para tblcliente (Cancelada)
        insertarLogCliente($con, $idUsuario, $usuarioSession, $idLogSeguridadCancelada, $dataUrl, $IdCliente, $evento, $tablaCliente, '', $jsonClienteNull, $fechaActual);

        // Actualizar tblventa y tblcliente del registro actual
        $ventaActualizada = actualizarTblVenta($con, $estadoUpdate, $NContrato, $idVentaActual);
        $clienteActualizado = actualizarTblCliente($con, $NContrato, $IdClienteActual);

        if ($ventaActualizada && $clienteActualizado) {
            
            $evento = 'Modificar';
            
            $jsonNumeroVenta = json_encode(['NContrato' => $NContrato]);
        
            $jsonNumeroCliente = json_encode(['NCliente' => $NContrato]);
            
            // Insertar registro de cambio en tbllog
            $idLogSeguridad = insertarLogSeguridad($con, $evento, $fechaActual, $idVentaActual, $nombreCampoVenta);

            // Insertar registro de cambio en tbllog_transac para tblventa
            insertarLogTransac($con, $idUsuario, $usuarioSession, $idLogSeguridad, $dataUrl, $idVentaActual, $evento, $tablaVenta, '', $jsonNumeroVenta, $fechaActual);

            // Insertar registro de cambio en tbllog_transac para tblcliente
            insertarLogCliente($con, $idUsuario, $usuarioSession, $idLogSeguridad, $dataUrl, $IdClienteActual, $evento, $tablaCliente, '', $jsonNumeroCliente, $fechaActual);

            $respuesta = ['respuesta' => 'exito'];
        }
    }
}

if($respuesta['respuesta']=='exito'){
    enviarMensaje($NContrato,$NContratoActual,$usuarioSession,$estadoVentaActual);
}
die(json_encode($respuesta));
?>

