<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include dirname(__DIR__).'/helper/helper_validacion.php';

$q=NULL;

if (isset($_GET['q'])) {
    $q=sanitizaCampo($_GET['q'],'sanitizestring|scapestring|htmlspecialchars',$con);
}


    try{
        $q = "%{$q}%";
        $stmt = $con->prepare( "SELECT d.CodUbigeoReniec,d.Distrito,p.Provincia FROM dbVENTAS.tbldistrital d INNER JOIN dbVENTAS.tblprovincial p on d.IdProvincial=p.IdProvincial WHERE d.Distrito LIKE ? limit 25");
        $stmt->bind_param('s', $q);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($CodUbigeoReniec,$Distrito,$Provincia);
        $json = [];        
        while ($stmt->fetch()){
        $json[] = array_map("utf8_encode",['id'=>$CodUbigeoReniec, 'text'=>$Distrito." - ".$Provincia]);            
	    }
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
echo json_encode($json); 