<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include dirname(__DIR__).'/helper/helper_validacion.php';

$q=NULL;

if (isset($_GET['q'])) {
    $q=sanitizaCampo($_GET['q'],'sanitizestring|scapestring|htmlspecialchars',$con);
}

    try{
        $q = "%{$q}%";
        $stmt = $con->prepare( "SELECT u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Gestor FROM dbUSUARIO.tblusuario u  INNER JOIN dbUSUARIO.tblarea a on a.IdArea=u.IdArea
		WHERE (u.Matricula LIKE ? or u.Nombres LIKE ?) AND a.NombreArea LIKE  '%Marketing%' and u.Estado='Activo'");
        $stmt->bind_param('ss', $q,$q);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($Matricula,$Gestor);
        $json = [];        
        while ($stmt->fetch()){
        $json[] = array_map("utf8_encode",['id'=>$Matricula, 'text'=>$Matricula." - ".$Gestor]);            
	    }
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    
echo json_encode($json);    
