<?php

    require_once '../config/db.php';
    require_once '../config/conexion.php';
    //INCLUR FUNCIONES DE ENVIO DE CORREO
    include 'Correo/correoUsuario.php';
    
    date_default_timezone_set('America/Lima');
    
    $fileContent = $_FILES['inputPlantilla'];
    $fileContent = file_get_contents($fileContent['tmp_name']);
    
    $fileContent = explode("\n", $fileContent);
    $fileContent = array_filter($fileContent);
    
    foreach ($fileContent as $fila){
        $usuarioList[] = explode(",", $fila);
    }
    
    if(sizeof($usuarioList) > 1){
        $i =0;
        foreach ($usuarioList as $usuarioData){
            if($i > 0){
                //validarDatos($usuarioData)
                if(true){
                    $respuesta = insertDatos($usuarioData);
                    
                    $resultadoFinal[] = $respuesta;

                } else {
                    $respuesta = array(
                        'respuesta' => 'error',
                    );
                    
                    die($respuesta);
                }
            }
            $i++; 
        }       
    } else {
        $respuesta = array(
            respuesta => 'Sindatos'
        );
        
        die($respuesta);
    }
    
    echo json_encode($resultadoFinal, JSON_UNESCAPED_UNICODE);
    
    
    function validarDatos($usuarioData){
        //Usuario
        if($usuarioData[0] == ''){
            return false;
        }
        //Matricula
        if($usuarioData[1] == ''){
            return false;
        }
        //Nombre
        if($usuarioData[2] == ''){
            return false;
        }
        //Apellido
        if($usuarioData[3] == ''){
            return false;
        }
        //Tipo Documento
        if($usuarioData[4] == ''){
            return false;
        }
        //Documento
        if($usuarioData[5] == ''){
            return false;
        }
        //Area
        if($usuarioData[6] == ''){
            return false;
        }
        //Perfil
        if($usuarioData[7] == ''){
            return false;
        }
        //Tipo
        if($usuarioData[10] == ''){
            return false;
        }
        //Manager
        if($usuarioData[11] == ''){
            return false;
        }
        //Correo
        if($usuarioData[12] == ''){
            return false;
        }
        //Fecha Ingreso
        if($usuarioData[13] == ''){
            return false;
        }
        
        return true;
    }
    
    function insertDatos($usuarioData){
        
        global $con;
        
        //SEPARAR DATOS POR FILA DEL ARRAY
        $usuario = $usuarioData[0];
        $matricula = $usuarioData[1];
        $nombres = $usuarioData[2];
        $apellidos = $usuarioData[3];
        $tipoDocumento = $usuarioData[4];
        $documento = $usuarioData[5];
        $telefono = $usuarioData[8];
        $demo = $usuarioData[9];
        $categoria = $usuarioData[10];
        $manager = $usuarioData[11];
        $correo = $usuarioData[12];
        $fechaIngreso = format_date_Y_mm_dd(str_replace('/', '-', myUrlEncode($usuarioData[13])));
        $fte = $usuarioData[14];
        
        $cargo = obtenerCargo($categoria);
        
        //AREA Y PERFIL
        $area = $usuarioData[6]; //OBLIGATORIO
        $perfil= $usuarioData[7]; //OBLIGATORIO
        $IdArea = obtenerArea($area);
        
        $IdPerfil = obtenerPerfil($perfil);
        
        if($IdPerfil == 'error'){
            $respuesta = array(
                'respuesta' => 'error',
            );
            
            return $respuesta;
        } 
        
        $cc = obtenerCC($area);
        $ln = obtenerLN($area);
        
        $estado = 'Activo';
        
        $passwordxdni="Verisure".substr($documento,-4);
        $user_password_hash=password_hash($passwordxdni,PASSWORD_DEFAULT);
        
        
        try{
            $stmt = $con->prepare("INSERT INTO dbUSUARIO.tblusuario(IdArea, IdPerfil, Matricula, Nombres, Apellidos, TipoDocumento, NumeroDoc, Usuario, Telefono, Demo, Categoria, Manager, Correo, FTE, FechaIngreso, CC, 	LN, Estado, Password, Cargo) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param('iisssssssssssssiisss', $IdArea, $IdPerfil, $matricula, $nombres, $apellidos, $tipoDocumento, $documento, $usuario, $telefono, $demo, $categoria, $manager, $correo, $fte, $fechaIngreso, $cc, $ln, $estado, $user_password_hash, $cargo);
            $stmt->execute();
            
            $id = $con->insert_id;
            if($id > 0){
                $respuesta = array(
                        'respuesta' => 'exito',
                        'id' => $id,
                        'usuario' => $usuario,
                        'data' => $usuarioData
                    );
                    
                $id = '';
                    
                enviarCorreoAltaUsuarioMasivo($usuarioData);
            } else {
                $respuesta = array(
                    'respuesta' => 'error',
                    'usuario' => $usuario,
                    'error' => $con->error,
                    'data' => $usuarioData
                    
                );
            }
            $stmt->close();
            
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error',
                'mensaje' => $e,
                'data' => $usuarioData
            );
        }
        
        return $respuesta;
        /*
        
        try{
            $stmt = $con->prepare("INSERT INTO dbUSUARIO.tblusuario(IdArea, IdPerfil, Matricula, Nombres, Apellidos, TipoDocumento, NumeroDoc, Telefono, Demo, Categoria, Manager, CC, LN, Correo, Usuario, FechaIngreso, FTE, Estado) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param('iisssssssssiisssss', $area, $perfil, $matricula, $nombres, $apellidos, $tipoDocumento, $documento, $telefono, $demo, $categoria, $manager, $cc, $ln, $correo, $usuario, $fechaIngreso, $fte, 'Activo');
            $stmt->execute();
            $respuesta = $con->insert_id;
            $stmt->close();
        }   catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
        
        */
    };
    
    
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
        
    }
    
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }
    
    function obtenerArea($area){
        global $con;
        
        $sql = "SELECT * 
                FROM dbUSUARIO.tblarea a
                WHERE a.IdDpto IN ( 6, 7, 8, 9, 10, 11, 12, 13, 14,15,17,18,21,22,23, 24) 
                AND a.NombreArea = '".$area."'"; 
        $resultado = $con->query($sql);
        
        while($data = $resultado->fetch_assoc()){
            $idArea = $data['IdArea'];
        }
        
        return $idArea;
    }
    
    function obtenerLN($area){
        global $con;
        
        $sql = "SELECT * 
                FROM dbUSUARIO.tblarea a
                WHERE a.IdDpto IN ( 6, 7, 8, 9, 10, 11, 12, 13, 14,15,17,18,21,22,23, 24) 
                AND a.NombreArea = '".$area."'"; 
        $resultado = $con->query($sql);
        
        while($data = $resultado->fetch_assoc()){
            $ln = $data['LN'];
        }
        
        return $ln;
    }
    
    function obtenerCC($area){
        global $con;
        
        $sql = "SELECT d.CC
                FROM dbUSUARIO.tblarea a
                INNER JOIN dbUSUARIO.tbldepartamento d ON a.IdDpto = d.IdDpto
                WHERE a.IdDpto IN (6, 7, 8, 9, 10, 11, 12, 13, 14,15,17,18,21,22,23, 24) 
                AND a.NombreArea LIKE '".$area."'"; 
        $resultado = $con->query($sql);
        
        while($data = $resultado->fetch_assoc()){
            $CC = $data['CC'];
        }
        
        return $CC;
    }
    
    function obtenerPerfil($perfil){
        global $con;
        
        $sql = "SELECT * 
                FROM dbUSUARIO.tblperfil p 
                WHERE p.IdPerfil in (17,3,4,5,6,7,8,9,14,49) 
                AND p.NombrePerfil LIKE '%".$perfil."%'";
                
        $resultado = $con->query($sql);
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $IdPerfil = $data['IdPerfil'];
            }
        } else {
            return 'error';
        }
        
        
        
        return $IdPerfil;        
    }
    
    function obtenerCargo($categoria){
        switch ($categoria) {
            case 'MST':
                $cargo = 'Especialista Máster';
                break;
            case 'DEL':
                $cargo = 'Delegado Comercial';
                break;
            case 'COORDINADORA':
                $cargo = 'COORDINADORA';
                break;
            case 'JE':
                $cargo = 'Jefe Venta';
                break;
            case 'VET':
                $cargo = 'Veterano Comercial';
                break;
            case 'COACH':
                $cargo = 'COACH';
                break;
            case 'N3':
                $cargo = 'Especialista de Venta';
                break;
            case 'N2':
                $cargo = 'Especialista de Venta';
                break;
            case 'N1':
                $cargo = 'Especialista de Venta';
                break;
            case 'ELI/MST':
                $cargo = 'ELI/MST';
                break;
            case 'GERENTE TERRITORIAL':
                $cargo = 'GERENTE TERRITORIAL';
                break;
            case 'JE/DEL':
                $cargo = 'JE/DEL';
                break;
        }
        
        return $cargo;
    }

?>