<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
//LOG
require_once 'log/insertLog.php';
//LIBRERIA DE EXPORTACION
require_once 'libreria/Spout/Autoloader/autoload.php';

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

$fileName = 'Ventas3U.csv';

$writer = WriterEntityFactory::createCSVWriter();

$writer->openToBrowser($fileName);

$head = array('IdVenta','IdUsuario',
'IdCliente',
'Matricula',
'Comercial',
'CC',
'JefeVenta',
'CategoriaVenta',
'TipoVenta',
'Segmento',
'NProspecto',
'NContrato',
'PrecioKit',
'TotalExtra',
'IngresoKIT',
'IngresoExtras',
'IngresoTotal',
'EstadoVenta',
'ExtraAutorizado',
'MesesAutorizado',
'N590',
'FormaPago',
'PAI',
'ResumenVenta',
'FechaHoraREG',
'EstadoVisita',
'FechaVisita',
'HoraVisita',
'FVencimientoVisita',
'GestorMKT',
'OrigenVisita',
'ComentarioVisita',
'GestorOrigen',
'IdGeografico',
'NombApellido',
'Telefonouno',
'Telefonodos',
'Correo',
'Direccion',
'Distrito',
'Provincia',
'CCOriginal',
'IMP',
'ContactadoCO',
'MesVisita',
'VTAConfirmadaCO',
'FechaInst',
'HoraInst',
'InstaladoX',
'MatriculaTec',
'IdProspectoRP',
'FechaFacturacion',
'TipoKIT',
'CantidadExtras',
'ClosingPack',
'PrecioEspecial',
'ScoringFIELD',
'GestorCertVenta',
'FechaApertura',
'FechaCierre',
'Renove',
'RCompetencia',
'RVencimiento'
);
$rowFromValues = WriterEntityFactory::createRowFromArray($head);
$writer->addRow($rowFromValues);

date_default_timezone_set('America/Lima');

$fecharegistro=date("Y-m-d H:i:s");

$result_exec = StmtInsertarLogSeguridad_General('Exportar', $fecharegistro, '', '');


$query="SELECT 
v.IdVenta,
v.IdUsuario,
v.IdCliente,
v.Matricula,
v.Comercial,
v.CC,
v.JefeVenta,
v.CategoriaVenta,
v.TipoVenta,
v.Segmento,
v.NProspecto,
v.NContrato,
v.PrecioKit,
v.TotalExtra,
v.IngresoKIT,
v.IngresoExtras,
v.IngresoTotal,
v.EstadoVenta,
v.ExtraAutorizado,
v.MesesAutorizado,
v.N590,
v.FormaPago,
v.PAI,
v.ResumenVenta,
v.FechaHoraREG,
v.EstadoVisita,
v.FechaVisita,
v.HoraVisita,
v.FVencimientoVisita,
v.GestorMKT,
v.OrigenVisita,
v.ComentarioVisita,
v.GestorOrigen,
c.IdGeografico,
c.NombApellido,
c.Telefonouno,
c.Telefonodos,
c.Correo,
c.Direccion,
g.Distrito,
g.Provincia,
v.CCOriginal,
v.IMP,
v.ContactadoCO,
v.MesVisita,
v.VTAConfirmadaCO,
a.FechaInst,
a.HoraInst,
a.InstaladoX,
a.MatriculaTec,
v.IdProspectoRP,
f.FechaFacturacion,
v.TipoKIT,
v.CantidadExtras,
v.ClosingPack,
v.PrecioEspecial,
v.ScoringRP as ScoringFIELD,
v.GestorCertVenta,
v.FechaApertura,
cer.FechaCierre,
v.Renove,
v.RCompetencia,
v.RVencimiento
FROM dbVENTAS.tblventa v INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
INNER JOIN dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
INNER JOIN dbVENTAS.tblagenda a on a.IdVenta=v.IdVenta
INNER JOIN dbVENTAS.tblfacturacion f on f.IdVenta=v.IdVenta
LEFT JOIN dbVENTAS.tblcertificacionventa cer on cer.IdCertVenta=v.IdCertVenta
WHERE STR_TO_DATE(v.N590,'%b-%Y')>=DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 3 MONTH),'%Y-%m-00')";
/*3 Ultimos N590*/

$result = $con->query($query);



while ($Venta = $result->fetch_assoc()){
  $rowData = WriterEntityFactory::createRowFromArray($Venta);
  $writer->addRow($rowData);
}



$result->close();

$writer->close();

$con->close();

?>
