<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';

date_default_timezone_set('America/Lima');

//LOG
$fecharegistro=date("Y-m-d H:i:s");

        $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
        $usuariosesion=htmlspecialchars($_SESSION['usuariosesion']);
        $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI']);
        $Acceso='Exportar';
        $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
        
        try {
                
          $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
          $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
          $stmt->execute();
          $stmt->close();
          
        } catch (\Exception $e) {
          echo $e->getMessage();
        } 


//LIBRERIA DE EXPORTACION
require_once 'libreria/Spout/Autoloader/autoload.php';

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

$fileName = 'GestionReferidos.csv';

$writer = WriterEntityFactory::createCSVWriter();

$writer->openToBrowser($fileName);

$head = array(
    'IdReferido',
    'Telefono',
    'Gestor',
    'NombresGestor',
    'ApellidosGestor',
    'TipoContacto',
    'EstadoReferido',
    'FechaHoraREG',
    'NVuelta',
    'FechaHoraRellamada'
);
$rowFromValues = WriterEntityFactory::createRowFromArray($head);
$writer->addRow($rowFromValues);


$query = "SELECT g.IdReferido, r.Telefono, g.GestorRP as Gestor, u.Nombres as NombresGestor, u.Apellidos as ApellidosGestor, g.TipoContacto, g.EstadoReferido, g.FechaHoraREG, g.NVuelta,g.FechaHoraRellamada
FROM dbVENTAS.tblGestionReferido g
INNER JOIN dbREFERIDO.tblreferido_detalle r ON g.IdReferido = r.Id
INNER JOIN dbUSUARIO.tblusuario u ON u.Matricula = g.GestorRP";
            
$result = $con->query($query);
//CONTADOR i para las filas de la consulta

while ($datos = $result->fetch_assoc()){
    $arreglo[] = $datos;

}

for($i=0; $i<count($arreglo); $i++){
    $rowData = WriterEntityFactory::createRowFromArray($arreglo[$i]);
    $writer->addRow($rowData);
}

$result->close();

$writer->close();

$con->close();

?>