<?php

function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}
function format_date_Y_mm_dd_H_i_s($date)
{
    return date('Y-m-d H:i:s', strtotime($date));
}

require_once '../config/db.php';
require_once '../config/conexion.php';

$json = file_get_contents('php://input');
$data = json_decode($json);



if(isset($data->lblFechaRegistro)){
    $lblFechaRegistro = $data->lblFechaRegistro;
    $lblFechaRegistro = date('Y-m-d', strtotime(str_replace('/', '-',$lblFechaRegistro)));
} else {
    $lblFechaRegistro = format_date_Y_mm_dd_H_i_s("2020-10-19 07:37:44");
}

if(isset($data->lblMesVisita)){
    $lblMesVisita = $data->lblMesVisita;
    
    $nmes = date('n', strtotime($lblMesVisita));
} else {
    $lblMesVisita= 'Dec-2020';
    
    $nmes = '12';
}

$deleaciones = array(
    array('Id' => 150, 'Titulo'=>'SURCO', 'Delegado'=>'B. MURGA'), 
    array('Id' =>151, 'Titulo'=>'SURCO2', 'Delegado'=>'H. VIGO'), 
    array('Id' =>152, 'Titulo'=>'LA MOLINA', 'Delegado'=>'C. CUNEO'), 
    array('Id' =>153, 'Titulo'=>'LINCE', 'Delegado'=>'C. ALMEIDA'), 
    array('Id' =>154, 'Titulo'=>'MIRAFLORES', 'Delegado'=>'D. ADELL / L. ZAVALA'), 
    array('Id' =>155, 'Titulo'=>'MAGDALENA', 'Delegado'=>'F. VERA / M. CASTILLO'), 
    array('Id' =>156, 'Titulo'=>'SAN ISIDRO', 'Delegado'=>'J. TORREGROSA'), 
    array('Id' =>120, 'Titulo'=>'TRUJILLO', 'Delegado'=>'A. VIOLERO'), 
    array('Id' =>200, 'Titulo'=>'PIURA', 'Delegado'=>'A. VIOLERO'), 
    array('Id' =>41, 'Titulo'=>'AREQUIPA', 'Delegado'=>'C. MOSCOSO / V. ORTIZ'), 
);

$totalVisitas = 0;

$arregloVisitasTotales = consultaVisitas();
$arregloGeofinder = consultaGeofinderCC();
$arregloGeofinderDistrito = consultaGeofinderDistrito();
$arregloVisitasDia = consultaVisitasDia();

$Distritos = consultaDistritosVisitas();

for($i=0; $i<count($deleaciones); $i++){
    $delegacion = $deleaciones[$i]['Id'];
    
    $cantidadVisitas = cantidadVisitas($delegacion, $arregloVisitasTotales);
    $cantidadVisitasEncontradas = cantidadVisitasEncontradas($delegacion, $arregloGeofinder);
    $cantidadVisitasNoEncontradas = cantidadVisitasNoEncontradas($delegacion, $arregloGeofinder);
    
    $porcentajeEncontradas = porcentaje($cantidadVisitasEncontradas, $cantidadVisitas);
    $porcentajeNoEncontradas = porcentaje($cantidadVisitasNoEncontradas, $cantidadVisitas);
    
    $totalVisitas += $cantidadVisitas;
    $totalVisitasEncontradas += $cantidadVisitasEncontradas;
    $totalVisitasNoEncontradas += $cantidadVisitasNoEncontradas;
    
    $porcentajeTotalEncontradas = porcentaje($totalVisitasEncontradas, $totalVisitas);
    $porcentajeTotalNoEncontradas = porcentaje($totalVisitasNoEncontradas, $totalVisitas);
    
    $arregloDatos[$i] = array(
                            'Delegacion' => $deleaciones[$i],
                            'Visitas' => $cantidadVisitas,
                            'Encontradas' => $cantidadVisitasEncontradas,
                            'NoEncontradas' => $cantidadVisitasNoEncontradas,
                            'PorcEncontradas' => $porcentajeEncontradas,
                            'PorcNoEncontradas' => $porcentajeNoEncontradas,
                            'FechaRegistro' => $lblFechaRegistro
                        );
}

foreach ($Distritos as $clave => $valor) {
    
    $cantidadVisitiasEncontradasDistritos = cantidadVisitasDistritoEncontradas($valor['Distrito'], $arregloGeofinderDistrito);
    $cantidadVisitasDistritoNoEncontradas = cantidadVisitasDistritoNoEncontradas($valor['Distrito'], $arregloGeofinderDistrito);
    
    $Distritos[$clave]['VisitasEncontradas'] = $cantidadVisitiasEncontradasDistritos;
    $Distritos[$clave]['VisitasNoEncontradas'] = $cantidadVisitasDistritoNoEncontradas;
    
    $porcentajeEncontradas = porcentaje($cantidadVisitiasEncontradasDistritos, $valor['TotalVisitas']);
    $porcentajeNoEncontradas = porcentaje($cantidadVisitasDistritoNoEncontradas, $valor['TotalVisitas']);
    
    $Distritos[$clave]['PorcVisitasEncontradas'] = $porcentajeEncontradas;
    $Distritos[$clave]['PorcVisitasNoEncontradas'] = $porcentajeNoEncontradas;
        
}

$arregloDatos['Distritos'] = $Distritos;

$arregloDatos['VisitasDiario'] = $arregloVisitasDia;



$arregloDatos['Totales'] = array(
    'TotalVisitas' => $totalVisitas,
    'totalVisitasEncontradas' => $totalVisitasEncontradas,
    'totalVisitasNoEncontradas' => $totalVisitasNoEncontradas,
    'porcentajeTotalEncontradas' => $porcentajeTotalEncontradas,
    'porcentajeTotalNoEncontradas' => $porcentajeTotalNoEncontradas
);

echo json_encode($arregloDatos);

function consultaVisitas(){
    global $con;
    global $lblFechaRegistro;
    
    $sql = "SELECT CCOriginal CC, count(v.IdVenta) visitas 
    FROM dbVENTAS.tblventa v 
    WHERE v.FechaHoraREG >= '".$lblFechaRegistro."' AND v.TipoVenta='RE' AND CCOriginal NOT IN (512, 511)
    GROUP BY CCOriginal";
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    if ($row_cnt > 0){
        while($visita = $resultado->fetch_assoc()){
            $data[] = $visita;
        }
    }

    return $data;
}

function consultaGeofinderCC(){
    global $con;
    global $lblFechaRegistro;
    
    $sql = "SELECT CCOriginal, CASE WHEN c.objGeofinder IS NULL THEN FALSE WHEN c.objGeofinder = '' THEN FALSE ELSE TRUE END AS DIRBUSQUEDA,  COUNT(*) CANTIDAD
            FROM dbVENTAS.tblventa v
            INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
            WHERE v.FechaHoraREG >= '".$lblFechaRegistro."' AND v.TipoVenta='RE' AND CCOriginal NOT IN (512, 511)
            GROUP BY CCOriginal, DIRBUSQUEDA";
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    if ($row_cnt > 0){
        while($visita = $resultado->fetch_assoc()){
            $data[] = $visita;
        }
    }
    
    return $data;
          
}
function consultaGeofinderDistrito(){
    global $con;
    global $lblFechaRegistro;
    
    $sql = "SELECT g.Distrito, CASE c.objGeofinder WHEN '' THEN FALSE ELSE TRUE END AS DIRBUSQUEDA,  COUNT(*) CANTIDAD
            FROM dbVENTAS.tblventa v
            INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
            INNER JOIN tblgeografico g ON c.IdGeografico = g.IdGeografico
            WHERE v.FechaHoraREG >= '".$lblFechaRegistro."' AND v.TipoVenta='RE' AND CCOriginal NOT IN (512, 511)
            GROUP BY g.Distrito, DIRBUSQUEDA";
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    if ($row_cnt > 0){
        while($visita = $resultado->fetch_assoc()){
            $data[] = $visita;
        }
    }
    
    return $data;
          
}

function cantidadVisitas($delegacion, $arregloVisitasTotales){
    $cantVisitas = 0;
    for($i=0; $i<count($arregloVisitasTotales); $i++){
        if ($delegacion == $arregloVisitasTotales[$i]['CC']){
            //echo $arregloVisitasTotales[$i]['visitas'];
            $cantVisitas =  $arregloVisitasTotales[$i]['visitas'];
            break;
        } 
    }
    return $cantVisitas;
}

function cantidadVisitasEncontradas($delegacion, $arreglo){
    $cantVisitas = 0;
    
    for($i=0; $i<count($arreglo); $i++){
        if ($delegacion == $arreglo[$i]['CCOriginal'] && $arreglo[$i]['DIRBUSQUEDA'] == "1"){
            $cantVisitas = $arreglo[$i]['CANTIDAD'];
        } 
    }

    return $cantVisitas;
}

function cantidadVisitasDistritoEncontradas($distrito, $arreglo){
    $cantVisitas = 0;
    
    for($i=0; $i<count($arreglo); $i++){
        if ($distrito == $arreglo[$i]['Distrito'] && $arreglo[$i]['DIRBUSQUEDA'] == "1"){
            $cantVisitas = $arreglo[$i]['CANTIDAD'];
        } 
    }

    return $cantVisitas;
}

function cantidadVisitasDistritoNoEncontradas($distrito, $arreglo){
    $cantVisitas = 0;
    
    for($i=0; $i<count($arreglo); $i++){
        if ($distrito == $arreglo[$i]['Distrito'] && $arreglo[$i]['DIRBUSQUEDA'] == "0"){
            $cantVisitas = $arreglo[$i]['CANTIDAD'];
        } 
    }

    return $cantVisitas;
}

function cantidadVisitasNoEncontradas($delegacion, $arreglo){
    $cantVisitas = 0;
    
    for($i=0; $i<count($arreglo); $i++){
        if ($delegacion == $arreglo[$i]['CCOriginal'] && $arreglo[$i]['DIRBUSQUEDA'] == "0"){
            $cantVisitas = $arreglo[$i]['CANTIDAD'];
        } 
    }

    return $cantVisitas;
}

function consultaDistritosVisitas(){
    
    global $con;
    global $lblFechaRegistro;
    
    $sql = "SELECT g.Distrito, CONCAT(g.Provincia, ' - ', g.Distrito) DistritoProvincia, count(*) 'TotalVisitas'
    FROM tblventa v
    INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
    INNER JOIN tblgeografico g ON c.IdGeografico = g.IdGeografico
    WHERE v.FechaHoraREG >= '".$lblFechaRegistro."' AND v.TipoVenta='RE' AND CCOriginal NOT IN (512, 511)
    GROUP BY g.Distrito
    ORDER BY g.Provincia, g.Distrito ASC";
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    
    if ($row_cnt > 0){
        while($visita = $resultado->fetch_assoc()){
            $data[] = $visita;
        }
    } else {
        $data = array();
    }
    
    return $data;
    
}

function consultaVisitasDia(){
    global $con;
    global $lblMesVisita;
    global $nmes;
    
    
    $sql = "SELECT DAY(v.FechaHoraREG) Dia
            FROM tblventa v
            INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
            WHERE MONTH(v.FechaHoraREG)=".$nmes." and v.MesVisita = '".$lblMesVisita."' AND v.TipoVenta='RE' AND v.CCOriginal NOT IN (512, 511)
            GROUP BY DAY(v.FechaHoraREG)";
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    
    if ($row_cnt > 0){
        while($datos = $resultado->fetch_assoc()){
            $dia = $datos['Dia'];
            
            $sql2 = "SELECT CASE c.objGeofinder WHEN '' THEN FALSE ELSE TRUE END AS DIRBUSQUEDA, count(*) Total
                    FROM tblventa v INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
                    WHERE MONTH(v.FechaHoraREG)=".$nmes." AND DAY(v.FechaHoraREG)='".$dia."' and v.MesVisita = '".$lblMesVisita."' AND v.TipoVenta='RE' AND v.CCOriginal NOT IN (512, 511)
                    GROUP BY DIRBUSQUEDA";
            $resultado2 = $con->query($sql2);
            $row_cnt2 = $resultado2->num_rows;
            if ($row_cnt2 > 0){
                while($visitas = $resultado2->fetch_assoc()){
                    if ($visitas['DIRBUSQUEDA'] == 0){
                        $totalNoEncontradas = $visitas['Total'];
                    } else {
                        $totalEncontradas = $visitas['Total'];
                    }
                    
                    $data[$dia] = array(
                            'TotalEncontradas' => $totalEncontradas,
                            'TotalNoEncontradas' => $totalNoEncontradas
                        );
                }
            }
            
        }
    } else {
        $data = array();
    }
    
    return $data;
        
}

function porcentaje($parte, $total){
    if($total > 0){
        return number_format(round(($parte/$total)*100, 2), 2);
    } else {
        return 0;
    }
    
}





?>