<?php

    require_once '../config/db.php';
    require_once '../config/conexion.php';
    
    date_default_timezone_set('America/Lima');
    
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date)
    {
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date)
    {
        return date('Y-m-d', strtotime($date));
    }
    
    
    if(isset($_POST['MesComercial'])){
        $mes = $_POST['MesComercial'];
    } else {
        $mes = 'jul-2021';
    }

    $arrayDatosGestores = consultarGestores($mes);
    
    $diasLaborables = $arrayDatosGestores['DiasLaborables'];
    $gestores = $arrayDatosGestores['Base'];
    $diasLaborados = (float)diasLaborados();
    
    if(!empty($gestores)){
    
        $gestores = json_decode($gestores, true);
        //ARRAY CON LOS DATOS DEL UPFRONT DE LA CONSULTA
        $actualGestores = consultaTotalVendidoActual($mes);
        //ARRAY CON LOS DATOS DEL TOTAL DE GESTIONES
        $actualGestiones = consultaTotalGestiones($mes);
        //ARRAY CON LOS DATOS DE AGENDANDOS
        $actualAgendados = consultaAgendados($mes);
        //ARRAY CON LOS DATOS DE INSTALADOS
        $actualInstalados = consultaInstalados($mes);
        //ARRAY CON LOS DATOS DE FACTURADOS
        $actualFacturados = consultaFacturados($mes);
        //ARRAY CON LOS DATOS DE NELEMENTOS INSTALADOS
        $actualNElementos = consultarNElementos($mes);
        //ARRAY CON LOS DATOS DE UPFRONT POR CANALES DE CADA GESTOR
        $actualTotalXcanal = consultaTotalVendidoActualCanales($mes);
        //ARRAY CON LOS DATOS DE GESTION DEL GESTOR POR CANAL
        $actutalGestionesXcanal = consultaTotalGestionesCanales($mes);
        //ARRAY CON LOS DATOS DE AGENDADOS DEL GESTOR POR CANAL
        $actualAgendadosXcanal = consultaAgendadosCanales($mes);
        //ARRAY CON LOS DATOS DE INSTALADOS DEL GESTOR POR CANAL
        $actualInstaladosXcanal = consultaInstaladosCanales($mes);
        //ARRAY CON LOS DATOS DE FACTURADOS DEL GESTOR POR CANAL
        $actualFacturadosXcanal = array();
        //ARRAY CON LOS DATOS DE ELEMENTOS DEL GESTO POR CANAL
        $actualNElementosXcanal = consultarNElementosCanales($mes);
        
        //AÑADIR DATOS DE LOS RESULTADOS DE LOS ARREGLOS AL ARRAY GESTORES
        agregarDatos($actualGestores, 'upfront');
        agregarDatos($actualGestiones, 'gestiones');
        agregarDatos($actualAgendados, 'agendados');
        agregarDatos($actualInstalados, 'instalados');
        agregarDatos($actualFacturados, 'facturados');
        agregarDatos($actualNElementos, 'nelementos');
        
        agregarDatos($actualTotalXcanal, 'canal');
        agregarDatos($actutalGestionesXcanal, 'canalGestiones');
        agregarDatos($actualAgendadosXcanal, 'canalAgendados');
        agregarDatos($actualInstaladosXcanal, 'canalInstalados');
        agregarDatos($actualFacturadosXcanal, 'canalFacturados');
        agregarDatos($actualNElementosXcanal, 'canalNElementos');
        
        $arrayDatos = array(
            'Resultado' => 'exito',
            'Datos' => $gestores,
            'diasLaborables' => $diasLaborables,
            'diasLaborados' => $diasLaborados,
            'DatosCanales' => $actualNElementosXcanal
        );
    } else {
        $arrayDatos = array(
            'Resultado' => 'sinDatos',
        );
    }
    
    echo json_encode($arrayDatos);
    
    function consultarGestores($mes){
        global $con;
        
        $sql = "SELECT Base, DiasLaborables
                FROM tblDashboardUpselling
                WHERE N590 ='".$mes."'";
        $resultado = $con->query($sql);
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta = [
                    'DiasLaborables' => $data['DiasLaborables'],
                    'Base' => $data['Base']
                ];
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;
    }
    
    function consultaTotalVendidoActual($mes){

        global $con;
        global $gestores;
        
        $strGestores = gestoresString($gestores);

        $sql = "SELECT Amp.GestorUpselling, SUM(Cot.TotalPrecio) Total
                FROM tblampliacion Amp
                INNER JOIN tblcotizacion Cot ON Amp.IdCotizacion = Cot.IdCotizacion
                WHERE MesAmp = '".$mes."'
                AND EstadoAmp IN ('Instalada')
                AND GestorUpselling IN ".$strGestores."
                GROUP BY Amp.GestorUpselling";
        $resultado = $con->query($sql);
        
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;
        
        
    }
    
    function consultaTotalGestiones($mes){
        global $con;
        global $gestores;
        
        $strGestores = gestoresString($gestores);
        
        $sql ="SELECT Amp.GestorUpselling, count(*) Total
                FROM tblampliacion Amp
                INNER JOIN tblcotizacion Cot ON Amp.IdCotizacion = Cot.IdCotizacion
                WHERE Amp.MesAmp = '".$mes."'
                AND Amp.GestorUpselling IN ".$strGestores."
                GROUP BY GestorUpselling";
                
        $resultado = $con->query($sql);
        
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;         
        
    }
    
    function consultaAgendados($mes){
        
        global $con;
        global $gestores;
        
        $strGestores = gestoresString($gestores);
        
        $sql ="SELECT Amp.GestorUpselling, count(*) Total
                FROM tblampliacion Amp
                INNER JOIN tblcotizacion Cot ON Amp.IdCotizacion = Cot.IdCotizacion
                WHERE Amp.MesAmp = '".$mes."'
                AND Amp.GestorUpselling IN ".$strGestores."
                AND Amp.EstadoAmp IN ('AgendadaTEC', 'Instalada')
                GROUP BY GestorUpselling";
                
        $resultado = $con->query($sql);
        
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;        
    }
    
    function consultaInstalados($mes){
        
        global $con;
        global $gestores;
        
        $strGestores = gestoresString($gestores);
        
        $sql ="SELECT Amp.GestorUpselling, count(*) Total
                FROM tblampliacion Amp
                INNER JOIN tblcotizacion Cot ON Amp.IdCotizacion = Cot.IdCotizacion
                WHERE Amp.MesAmp = '".$mes."'
                AND Amp.GestorUpselling IN ".$strGestores."
                AND Amp.EstadoAmp IN ('Instalada')
                GROUP BY GestorUpselling";
                
        $resultado = $con->query($sql);
        
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;        
    }
    
    function consultaFacturados($mes){
        
        global $con;
        global $gestores;
        
        $strGestores = gestoresString($gestores);
        
        $sql ="SELECT Amp.GestorUpselling, count(*) Total
                FROM tblampliacion Amp
                INNER JOIN tblcotizacion Cot ON Amp.IdCotizacion = Cot.IdCotizacion
                WHERE Amp.MesAmp = '".$mes."'
                AND Amp.GestorUpselling IN ".$strGestores."
                AND Amp.EstadoAmp IN ('Facturada')
                GROUP BY GestorUpselling";
                
        $resultado = $con->query($sql);
        
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;        
    }
    
    function consultarNElementos($mes){
        
        global $con;
        global $gestores;
        
        $strGestores = gestoresString($gestores);
        
        $sql = "SELECT amp.GestorUpselling, sum(cot.TotalUnidad) Total
                FROM tblampliacion amp
                INNER JOIN tblcotizacion cot ON amp.IdCotizacion = cot.IdCotizacion
                WHERE amp.MesAmp = '".$mes."'
                AND amp.EstadoAmp IN ('Instalada')
                AND amp.GestorUpselling IN ".$strGestores."
                group by amp.GestorUpselling";
                
        $resultado = $con->query($sql);
        
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta; 
    }
    
    function consultaTotalVendidoActualCanales($mes){
        global $con;
        global $gestores;
        
        $strGestores = gestoresString($gestores);

        $sql = "SELECT Amp.GestorUpselling, Amp.TipoCanal, SUM(Cot.TotalPrecio) Total
                FROM tblampliacion Amp
                INNER JOIN tblcotizacion Cot ON Amp.IdCotizacion = Cot.IdCotizacion
                WHERE MesAmp = '".$mes."'
                AND EstadoAmp IN ('Instalada')
                AND GestorUpselling IN ".$strGestores."
                GROUP BY Amp.GestorUpselling, Amp.TipoCanal";
        $resultado = $con->query($sql);
        
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;
    }
    
    function consultaTotalGestionesCanales($mes){
        global $con;
        global $gestores;
        
        $strGestores = gestoresString($gestores);
        
        $sql ="SELECT Amp.GestorUpselling, Amp.TipoCanal, count(*) Total
                FROM tblampliacion Amp
                INNER JOIN tblcotizacion Cot ON Amp.IdCotizacion = Cot.IdCotizacion
                WHERE Amp.MesAmp = '".$mes."'
                AND Amp.GestorUpselling IN ".$strGestores."
                GROUP BY GestorUpselling, Amp.TipoCanal";
                
        $resultado = $con->query($sql);
        
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;         
        
    }
    
    function consultaAgendadosCanales($mes){
        
        global $con;
        global $gestores;
        
        $strGestores = gestoresString($gestores);
        
        $sql ="SELECT Amp.GestorUpselling, Amp.TipoCanal, count(*) Total
                FROM tblampliacion Amp
                INNER JOIN tblcotizacion Cot ON Amp.IdCotizacion = Cot.IdCotizacion
                WHERE Amp.MesAmp = '".$mes."'
                AND Amp.GestorUpselling IN ".$strGestores."
                AND Amp.EstadoAmp IN ('AgendadaTEC', 'Instalada')
                GROUP BY GestorUpselling, Amp.TipoCanal";
                
        $resultado = $con->query($sql);
        
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;        
    }
    
    function consultaInstaladosCanales($mes){
        
        global $con;
        global $gestores;
        
        $strGestores = gestoresString($gestores);
        
        $sql ="SELECT Amp.GestorUpselling, Amp.TipoCanal, count(*) Total
                FROM tblampliacion Amp
                INNER JOIN tblcotizacion Cot ON Amp.IdCotizacion = Cot.IdCotizacion
                WHERE Amp.MesAmp = '".$mes."'
                AND Amp.GestorUpselling IN ".$strGestores."
                AND Amp.EstadoAmp IN ('Instalada')
                GROUP BY GestorUpselling, Amp.TipoCanal";
                
        $resultado = $con->query($sql);
        
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta;        
    }
    
    function consultarNElementosCanales($mes){
        
        global $con;
        global $gestores;
        
        $strGestores = gestoresString($gestores);
        
        $sql = "SELECT Amp.GestorUpselling, Amp.TipoCanal, sum(cot.TotalUnidad) Total
                FROM tblampliacion Amp
                INNER JOIN tblcotizacion cot ON Amp.IdCotizacion = cot.IdCotizacion
                WHERE Amp.MesAmp = '".$mes."'
                AND Amp.EstadoAmp IN ('Instalada')
                AND Amp.GestorUpselling IN ".$strGestores."
                group by Amp.GestorUpselling, Amp.TipoCanal";
                
        $resultado = $con->query($sql);
        
        
        $row_cnt = $resultado->num_rows;
        
        if($row_cnt > 0){
            while($data = $resultado->fetch_assoc()){
                $respuesta[] = $data;
            }    
        } else {
            $respuesta = [];
        }
        
        return $respuesta; 
    }
    
    function agregarDatos($datos, $tipo){
        
        global $gestores;
        global $diasLaborables;
        
        //RECORRE EL ARREGLO DE GESTORES
        foreach($gestores as $clave => $valor){
            $matricula = $valor['matricula'];
            $objetivo = (float)$valor['objetivo'];
            
            //AGREGA VALORES 0.00 A LOS GESTORES QUE NO TIENEN UPFRONT
            if($tipo == 'upfront'){
                $gestores[$clave]['upfront'] = "0.00";
                $gestores[$clave]['avance'] = "0.00";
                $gestores[$clave]['proy'] = "0.00";
                $gestores[$clave]['upfrontFLOAT'] = 0.00;
            }
            
            if($tipo == 'gestiones'){
                $gestores[$clave]['gestiones'] = 0;
            }
            
            if($tipo == 'agendados'){
                $gestores[$clave]['agendados'] = 0;
            }
            
            if($tipo == 'instalados'){
                $gestores[$clave]['instalados'] = 0;
            }
            
            if($tipo == 'facturados'){
                $gestores[$clave]['facturados'] = 0;
            }
            
            if($tipo == 'nelementos'){
                $gestores[$clave]['nelementos'] = 0;
            }
            
            if($tipo == 'canal'){
                $gestores[$clave]['canales'] = ['Inbound' => ['canal' => 'Inbound', 'upfrontCanal' => '0,00', 'upfrontFLOATCanal' => 0.00], 
                                                'Outbound' => ['canal' => 'Outbound', 'upfrontCanal' => '0,00', 'upfrontFLOATCanal' => 0.00], 
                                                'PostMantos' => ['canal' => 'PostMantos', 'upfrontCanal' => '0,00', 'upfrontFLOATCanal' => 0.00]];
            }
            
            if($tipo == 'canalGestiones'){
                $gestores[$clave]['canales']['Inbound']['GestionesCanal'] = 0;
                $gestores[$clave]['canales']['Outbound']['GestionesCanal'] = 0;
                $gestores[$clave]['canales']['PostMantos']['GestionesCanal'] = 0;
            }
            
            if($tipo == 'canalAgendados'){
                $gestores[$clave]['canales']['Inbound']['AgendadosCanal'] = 0;
                $gestores[$clave]['canales']['Outbound']['AgendadosCanal'] = 0;
                $gestores[$clave]['canales']['PostMantos']['AgendadosCanal'] = 0;
            }
            
            if($tipo == 'canalInstalados'){
                $gestores[$clave]['canales']['Inbound']['InstaladosCanal'] = 0;
                $gestores[$clave]['canales']['Outbound']['InstaladosCanal'] = 0;
                $gestores[$clave]['canales']['PostMantos']['InstaladosCanal'] = 0;
            }

            if($tipo == 'canalFacturados'){
                $gestores[$clave]['canales']['Inbound']['FacturadosCanal'] = 0;
                $gestores[$clave]['canales']['Outbound']['FacturadosCanal'] = 0;
                $gestores[$clave]['canales']['PostMantos']['FacturadosCanal'] = 0;
            }
            if($tipo == 'canalNElementos'){
                $gestores[$clave]['canales']['Inbound']['NElementosCanal'] = 0;
                $gestores[$clave]['canales']['Outbound']['NElementosCanal'] = 0;
                $gestores[$clave]['canales']['PostMantos']['NElementosCanal'] = 0;
            }
            
            foreach($datos as $claveGestor => $valorGestor){
                $GestorUpselling = $valorGestor['GestorUpselling'];
                
                if($matricula === $GestorUpselling){
                    
                    if($tipo == 'upfront'){
                        
                        $total = (float)$valorGestor['Total'];
                        //CALCULA EL PORCENTAJE DE AVANCE
                        $avance = porcentaje($total, $objetivo);
                        //DIAS LABORADOS DEL MES
                        $diasLaborados = (float)diasLaborados();
                        
                        $proy = ((($total/$diasLaborados)*$diasLaborables)/$objetivo)*100;
                        
                        //Añadir total como numero
                        $gestores[$clave]['upfrontFLOAT'] = $total;
                        //Usar funcion number format para volver a string con separacion de miles y punto para los decimales
                        $total = number_format($total,2,'.',',');
                        $avance = number_format($avance,2,'.',',');
                        $proy = number_format($proy, 2,'.',',');
                        //Agregar al arreglo Gestores
                        $gestores[$clave]['upfront'] = $total;
                        $gestores[$clave]['avance'] = $avance;
                        $gestores[$clave]['proy'] = $proy;
                    }
                    
                    if($tipo == 'gestiones'){
                        $gestiones = (int)$valorGestor['Total'];
                        $gestores[$clave]['gestiones'] = $gestiones;
                    }
                    
                    if($tipo == 'agendados'){
                        $agendados = (int)$valorGestor['Total'];
                        $gestores[$clave]['agendados'] = $agendados;
                    }
                    
                    if($tipo == 'instalados'){
                        $instalados = (int)$valorGestor['Total'];
                        $gestores[$clave]['instalados'] = $instalados;
                    }
                    
                    if($tipo == 'facturados'){
                        $facturados = (int)$valorGestor['Total'];
                        $gestores[$clave]['facturados'] = $facturados;
                    }
                    
                    if($tipo == 'nelementos'){
                        $nelementos = (int)$valorGestor['Total'];
                        $gestores[$clave]['nelementos'] = $nelementos;
                    }
                    
                    if($tipo == 'canal'){
                        $TipoCanal = $valorGestor['TipoCanal'];
                        $UpfrontGestorCanal = (float)$valorGestor['Total'];
                        $gestores[$clave]['canales'][$TipoCanal]['upfrontFLOATCanal'] = $UpfrontGestorCanal;
                        
                        $UpfrontGestorCanal = number_format($UpfrontGestorCanal, 2,'.',',');
                        $gestores[$clave]['canales'][$TipoCanal]['upfrontCanal'] = $UpfrontGestorCanal;
                        
                    }
                    
                    if($tipo == 'canalGestiones'){
                        $TipoCanal = $valorGestor['TipoCanal'];
                        $GestionesGestorCanal = (float)$valorGestor['Total'];
                        
                        $gestores[$clave]['canales'][$TipoCanal]['GestionesCanal'] = $GestionesGestorCanal;
                    }
                    
                    if($tipo == 'canalAgendados'){
                        $TipoCanal = $valorGestor['TipoCanal'];
                        $AgendadosGestorCanal = (int)$valorGestor['Total'];
                        
                        $gestores[$clave]['canales'][$TipoCanal]['AgendadosCanal'] = $AgendadosGestorCanal;
                    }
                    
                    if($tipo == 'canalInstalados'){
                        $TipoCanal = $valorGestor['TipoCanal'];
                        $InstaladosGestorCanal = (int)$valorGestor['Total'];
                        
                        $gestores[$clave]['canales'][$TipoCanal]['InstaladosCanal'] = $InstaladosGestorCanal;
                    }
                    
                    if($tipo == 'canalNElementos'){
                        $TipoCanal = $valorGestor['TipoCanal'];
                        $ElementosGestorCanal = (int)$valorGestor['Total'];
                        
                        $gestores[$clave]['canales'][$TipoCanal]['NElementosCanal'] = $ElementosGestorCanal;

                    }
                }
            }
            
        }
        
    }
    
    function porcentaje($parte, $total){
        if($total > 0 && $parte >= 0){
            return number_format(round(($parte/$total)*100, 2), 2);
        } else {
            return 0;
        }
    }
    
    function diasLaborados(){
        $feriados = 
                    [   '1' => [],
                        '2' => [],
                        '3' => [],
                        '4' => [],
                        '5' => [],
                        '6' => [],
                        '7' => [28, 29],
                        '8' => [30],
                        '9' => [],
                        '10' => [8],
                        '11' => [1],
                        '12' => [8, 25]
                    ];
        
        //MES COMERCIAL DATO
        global $mes;
        
        $mesGestion =  date("n", strtotime($mes)); //Representacion número del mes enviado
        $mesActual = date("n", time()); //Representación numérica de un mes, sin ceros iniciales
        
        $año = date("Y", strtotime($mes)); //Una representación numérica completa de un año, 4 dígitos
        
        if($mesGestion == $mesActual){
            $mes_format = date("m", time()); //Representación numérica de un mes, con ceros iniciales
            $diaActual = date("j", time()); //Día del mes sin ceros iniciales
        } else {
            $mes_format = date("m", strtotime($mes)); //Representación numérica de un mes, con ceros iniciales
            $diasTotalesMes = date("t", strtotime($mes)); //Número de días del mes dado
            $diaActual = $diasTotalesMes;
        }
        
        $contador = 0;
        
        $feriadosMesActual = $feriados[$mesGestion];
        
        for($i=1; $i<=$diaActual; $i++){
            
            //Añadir 0 al recorrido del mes
            //Genera la fecha con formato año-mes-dia de cada día del mes
            if($i<10){
                $dia = "0".$i;
                $fecha = $año."-".$mes_format."-".$dia;
            } else {
                $fecha = $año."-".$mes_format."-".$i;
            }
            //Convertimos el string a una variable tipo time
            $fecha=strtotime($fecha);
            
            //Obtenemos la representacion numérica de la iso-8601 del día de la semana
            $diaFecha = date("N", $fecha); //Representación numérica ISO-8601 del día de la semana (añadido en PHP 5.1.0) 1 (para lunes) hasta 7 (para domingo)
            //Busca en el arreglo de FeriadosMesActual desde el primer día del mes
            if (in_array($i, $feriadosMesActual)) {
                if($diaFecha>= 1 && $diaFecha <= 5){
                    $contador--;
                }else if ($diaFecha == 6){
                    $contador -= 0.5;
                }
            }
            //Si el día es de lunes a viernes aumentamos el contador con un valor igual a 1, si es sabado 0.5
            if($diaFecha >= 1 && $diaFecha <= 5){
                $contador++;
            } else if ($diaFecha == 6){
                $contador += 0.5;
            }
        }
        
        return $contador;
    }
    
    function gestoresString($gestores){
        $strGestores = "(";
        
        foreach ($gestores as $clave => $valor){
            $matricula = $valor['matricula'];
            
            if (next($gestores)==true){
                $strGestores .= "'".$matricula."', ";
            } else {
                $strGestores .= "'".$matricula."'";
            }
        }
        
        $strGestores .= ")";
        
        return $strGestores;
    }
    
    
    